theory VDMpc = Lemmas:

consts all_classes :: "cname set"

axioms finclasses: "\<forall> (C::cname). C \<in> all_classes
\<and> finite all_classes"

(*derivation system for VDM*)

section {* Basic types *}

types
  "vdmassn" = "[env,  heap,  heap,  val,  rescomp]
\<Rightarrow> bool"

types
   vdmtuple = " expr \<times> vdmassn"

(* change to lists*)
types
   vdmcontext = " vdmtuple list"

consts vdm_proof :: "( vdmcontext \<times>  vdmtuple) set"

syntax
  vdm_deriv :: " vdmcontext \<Rightarrow>  expr \<Rightarrow> vdmassn \<Rightarrow> bool"
		  ("_ \<rhd>  _ : _ " [900,100,100] 50)

translations
 "G \<rhd> e : P" == "(G,e,P) \<in> vdm_proof"

syntax
  vdm_emptyctx :: " expr \<Rightarrow> vdmassn \<Rightarrow>
bool" ("\<rhd> _ : _ " 40)
translations
  "\<rhd> e : P " == "[] \<rhd> e : P"

(* ---------------------------------------------------------------------------
*)
(* ToDo: move this into a separate file and sort out dependencies *)

section {* Aux functions and lemmas for context adaptation *}

subsection {* Well-structured heaps etc *}



constdefs classOf :: "env \<Rightarrow> heap \<Rightarrow>
rname \<Rightarrow> cname \<Rightarrow> bool"
 "classOf E h x C == (\<exists> a . E\<lfloor>x\<rfloor>
= Ref a \<and> h @@ a = Some C)"




inductive vdm_proof intros


vdm_null: "G \<rhd> NULL : (\<lambda>  E h  hh  v  p . hh = h \<and> v = RVal Nullref \<and> p = tickRo)"


vdm_int: "G \<rhd> expr.Int i : (\<lambda>  E h hh v p . hh = h
\<and> v = IVal i \<and> p = tickRo)"

vdm_ivar: "G \<rhd> IVar x : (\<lambda> E h hh v p . hh = h
\<and> v = IVal (E<x>) \<and> p = tickRo)"

vdm_rvar: "G \<rhd> RVar x : (\<lambda> E h hh v p . hh = h
\<and> v = RVal (E\<lfloor>x\<rfloor>) \<and> p =
tickRo)"

vdm_prim: "G \<rhd> Primop f x y : (\<lambda> E h hh v p  . hh
= h \<and> v = IVal (f (E<x>) (E<y>)) \<and> p =
\<langle>3 0 0 0\<rangle>)"

vdm_rprim: "G \<rhd> RPrimop f x y : (\<lambda> E h hh v p  .
hh = h \<and> v = IVal (f (E\<lfloor>x\<rfloor>)
(E\<lfloor>y\<rfloor>)) \<and> p = \<langle>3 0 0
0\<rangle>)"

vdm_getfi: "G \<rhd> GetFi x f : (\<lambda> E h hh v p  .
\<exists> a . E\<lfloor>x\<rfloor> = Ref a \<and> hh = h
\<and>  
                                                   v = IVal ((heap.iheap hh) f
a) \<and> 
                                                   p = \<langle>2 0 0
0\<rangle> )"
vdm_getfr: "G \<rhd> GetFr x f : (\<lambda> E h hh v p  .
\<exists> a . E\<lfloor>x\<rfloor> = Ref a \<and> hh = h
\<and> 
                                                   v = RVal ((heap.rheap hh) f
a) \<and> 
                                                   p = \<langle>2 0 0
0\<rangle>)"

vdm_putfi: "G \<rhd> PutFi x f y : 
            (\<lambda> E h hh v p  . \<exists> a .
E\<lfloor>x\<rfloor>  = Ref a \<and> hh =
h<a\<bullet>f:=E<y>> \<and>
                                  v = arbitrary \<and>  p =
\<langle>3 0 0 0\<rangle>)"

vdm_putfr: "G \<rhd> PutFr x f y : 
            (\<lambda> E h hh v p  . \<exists> a .
E\<lfloor>x\<rfloor>  = Ref a \<and> hh =
h\<lfloor>a\<diamondsuit>f:=E\<lfloor>y\<rfloor>\<rfloor>
\<and>
                                  v = arbitrary \<and> p =
\<langle>3 0 0 0\<rangle>)"

vdm_new: "G \<rhd> New c ifldvals rfldvals :
              (\<lambda> E h hh v p  . \<exists> l . l = freshloc
(fmap_dom (heap.oheap h)) \<and> 
                                    hh = newObj h l E c ifldvals rfldvals
\<and>
                                    v = RVal (Ref l) \<and>
                                    p = tickRo)"

vdm_if: "\<lbrakk>G \<rhd> e1 : P1; G \<rhd> e2 :
P2\<rbrakk> \<Longrightarrow> 
         G \<rhd> (IF x THEN e1 ELSE e2) :
          (\<lambda> E h hh v p . \<exists> pp. p = tkn 2 pp
\<and> 
                               (E<x> = grailbool True
\<longrightarrow> (P1  E h hh v pp  )) \<and> 
                               (E<x> = grailbool False
\<longrightarrow> (P2  E h hh v pp  )) \<and>
                               (E<x> = grailbool True \<or>
E<x> = grailbool False))"

vdm_leti: "\<lbrakk>G \<rhd> e1 : P1; G \<rhd> e2 :
P2\<rbrakk> \<Longrightarrow>
           G \<rhd> (Leti x e1 e2) :
                (\<lambda> E h hh v p  . \<exists> p1 p2 h1 i . (P1 
E h h1 (IVal i) p1) \<and>
                                               (P2 (E<x:=i>) h1 hh v p2)
\<and>
                                               p = tk (p1 \<smile>
p2))"

vdm_letr: "\<lbrakk>G \<rhd> e1 : P1; G \<rhd> e2 :
P2\<rbrakk> \<Longrightarrow>
           G \<rhd> (Letr x e1 e2) :
                (\<lambda> E h hh v p  . \<exists> p1 p2 h1 r . (P1 
E h h1 (RVal r) p1) \<and>
                                               (P2
(E\<lfloor>x:=r\<rfloor>) h1 hh v p2) \<and>
                                               p = tk (p1 \<smile>
p2))"

vdm_letv: "\<lbrakk>G \<rhd> e1 : P1; G \<rhd> e2 :
P2\<rbrakk> \<Longrightarrow>
           G \<rhd> (Letv e1 e2) :
                (\<lambda> E h hh v p  . \<exists> p1 p2 h1 w . (P1 
E h h1 w p1) \<and>
                                               (P2  E h1 hh v p2) \<and>
                                               p = (p1 \<smile>
p2))"

vdm_call: "\<lbrakk> ((Call f, P) # G) \<rhd> (funtable f) : (\<lambda> E h hh v p  . (P  E h hh v (tkcall p)))\<rbrakk> \<Longrightarrow>  G \<rhd> (Call f) : P"
(*
vdm_mhinvokestatic:
  "\<lbrakk> (G \<union> {(MH_InvokeStatic C mn,P)})
\<rhd> 
    (methtable C mn) :  
    (\<lambda> E h hh v p  . (P  E h hh v (\<langle>2 0 1
1\<rangle> \<oplus> p))) \<rbrakk> \<Longrightarrow>
   G \<rhd> (MH_InvokeStatic C mn) : P"


vdm_mhinvoke:
  "\<lbrakk> \<forall> C. 
      (G \<union> {(MH_Invoke x mn,P)}) \<rhd> 
      (methtable C mn) :  
      (\<lambda> E' h hh v p  . \<forall> E  . classOf E h  x C
\<and> E' = E\<lfloor>self :=
E\<lfloor>x\<rfloor>\<rfloor> \<longrightarrow> (P  E h
hh v (\<langle>4 0 1 1\<rangle> \<oplus> p) )) \<rbrakk>
\<Longrightarrow>
   G \<rhd> (MH_Invoke x mn) : P"

*)

vdm_invokestatic:
  "\<lbrakk> ((InvokeStatic C mn y,P) # G) \<rhd> 
    (methtable C mn) :  
    (\<lambda> E h hh v p  . \<forall> E'. E = newframe_env Nullref (E'\<lfloor>y\<rfloor>)  \<longrightarrow> (P E' h hh v (\<langle>3 0 1 1\<rangle> \<oplus> p) )) \<rbrakk> \<Longrightarrow>
   G \<rhd> (InvokeStatic C mn y) : P"

vdm_invoke:
  "\<lbrakk> \<forall> C. 
     ((Invoke x mn y,P) # G) \<rhd> 
     (methtable C mn) :  
    (\<lambda> E h hh v p  . \<forall> E' . classOf E' h  x C \<and> E = newframe_env (E'\<lfloor>x\<rfloor>) (E'\<lfloor>y\<rfloor>) \<longrightarrow> 
          (P E' h hh v (\<langle>5 0 1 1\<rangle> \<oplus> p) )) \<rbrakk> \<Longrightarrow>
   G \<rhd> (Invoke x mn y) : P"

vdm_ax: "\<lbrakk> (e,P) mem G \<rbrakk>
\<Longrightarrow> G \<rhd> e : P"

vdm_conseq: "\<lbrakk>G \<rhd> e : P; (\<forall> E h hh v p . (P  E h hh v p ) \<longrightarrow> (Q  E h hh v p ))\<rbrakk>
\<Longrightarrow> G \<rhd> e : Q"

subsection {*Semantic validity*}

end
