theory VDMderivedComb = Lemmas + VDMcomb: 

text {*
 In this section we define several useful rules, that are derived from the core 
 program logic. 
*}

subsection {* Weakening lemmas for contexts *}

lemma CtxtWeak: "G \<rhd> e :: P \<Longrightarrow> (G \<union> D) \<rhd> e :: P"
apply (erule vdmcomb_proof.induct)
apply (blast intro!: vdmcomb_proof.intros)+
apply (rule vdm_if, simp, simp)
apply (rule vdm_leti, simp, simp)
apply (rule vdm_letr, simp, simp)
apply (rule vdm_letv, simp, simp)
apply (rule vdm_call, simp)
apply (rule vdm_ax, simp)
apply (rule vdm_conseq, fast, simp)
apply (rule vdm_new)
done

lemma CtxtWeakSingleton: "G \<rhd> e :: P \<Longrightarrow> (insert (ee, Q) G) \<rhd> e :: P"
by (insert CtxtWeak [of G e P "{(ee,Q)}"], simp)

subsection {* Cut rules *}

lemma CutAux: 
"(DD \<rhd> e :: Q \<Longrightarrow>
(\<forall> G ee P D . (DD = (insert (ee, P) D) \<longrightarrow> (G \<rhd> ee ::P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> D \<rhd> e::Q)))"
apply (erule vdmcomb_proof.induct)
apply clarify
apply (fast intro: vdm_null)
apply (fast intro: vdm_int)
apply (fast intro: vdm_ivar)
apply (fast intro: vdm_rvar)
apply (fast intro: vdm_prim)
apply (fast intro: vdm_rprim)
apply (fast intro: vdm_getfi)
apply (fast intro: vdm_getfr)
apply (fast intro: vdm_putfi)
apply (fast intro: vdm_putfr)
(*apply (fast intro: vdm_new)*)
(*case vdm_if*)
apply clarsimp
apply (erule_tac x=Ga in allE, erule_tac x=Ga in allE)
apply (erule_tac x=ee in allE, erule_tac x=ee in allE)
apply (erule_tac x=P in allE, erule_tac x=P in allE)
apply (erule_tac x=D in allE, erule_tac x=D in allE)
apply (insert vdm_if, simp)
(*case vdm_leti*)
apply clarsimp apply (rotate_tac 4) apply(erule thin_rl)
apply (erule_tac x=Ga in allE, erule_tac x=Ga in allE)
apply (erule_tac x=ee in allE, erule_tac x=ee in allE)
apply (erule_tac x=P in allE, erule_tac x=P in allE)
apply (erule_tac x=D in allE, erule_tac x=D in allE)
apply (insert vdm_leti, simp)
(*case vdm_letr*)
apply clarsimp apply (rotate_tac 4) apply(erule thin_rl, erule thin_rl)
apply (erule_tac x=Ga in allE, erule_tac x=Ga in allE)
apply (erule_tac x=ee in allE, erule_tac x=ee in allE)
apply (erule_tac x=P in allE, erule_tac x=P in allE)
apply (erule_tac x=D in allE, erule_tac x=D in allE)
apply (insert vdm_letr, simp)
(*case vdm_letv*)
apply clarsimp apply (rotate_tac 4) apply(erule thin_rl, erule thin_rl, erule thin_rl)
apply (erule_tac x=Ga in allE, erule_tac x=Ga in allE)
apply (erule_tac x=ee in allE, erule_tac x=ee in allE)
apply (erule_tac x=P in allE, erule_tac x=P in allE)
apply (erule_tac x=D in allE, erule_tac x=D in allE)
apply (insert vdm_letv, simp)
(*case vdm_call*)
apply clarsimp apply (rotate_tac 2) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rule vdm_call)
apply (erule_tac x = Ga in allE, erule_tac x = ee in allE, erule_tac x = Pa in allE,
       erule_tac x="(insert (CALL f, P) D)" in allE, fastsimp) 
(*Case vdm_ax*)
apply clarsimp apply (rotate_tac 1) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (erule disjE)
apply clarsimp
apply (subgoal_tac "(Ga \<union> D) \<rhd>  ee :: Pa")
apply (subgoal_tac "D = (Ga \<union> D)", simp, fast)
apply (simp add: CtxtWeak)
apply (rule vdm_ax, simp)
apply (rotate_tac 3) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (safe, erule_tac x=Ga in allE, erule_tac x=ee in allE,
             erule_tac x=Pa in allE, erule_tac x=D in allE, simp)
apply (erule vdm_conseq, assumption)
(*case vdm_new*)
apply (rule vdm_new)
done

lemma CCutAux: 
"(DD \<rhd> e :: Q \<Longrightarrow>
(\<forall> G f P D . (DD = (insert (Call f, P) D) \<longrightarrow> (G \<rhd> Call f ::P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> D \<rhd> e::Q)))"
by (drule CutAux , simp)

lemma mhInvStat_CutAux: 
"(DD \<rhd> e :: Q) \<Longrightarrow>
 (\<forall> G C mn P D . ((DD = (insert (C\<bullet>\<bullet>mn, P) D)) \<longrightarrow> (G \<rhd> (C\<bullet>\<bullet>mn) :: P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> (D \<rhd> e :: Q)))"
by (drule CutAux, simp)

lemma mhInv_CutAux: 
"(DD \<rhd> e :: Q) \<Longrightarrow> 
(\<forall> G x mn P D . ((DD = (insert (x\<diamondsuit>\<diamondsuit>mn, P) D)) \<longrightarrow> (G \<rhd> (x\<diamondsuit>\<diamondsuit>mn) :: P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> (D \<rhd> e :: Q)))"
by (drule CutAux , simp)


lemma InvStat_CutAux: 
"(DD \<rhd> e :: Q) \<Longrightarrow>
(\<forall> G C mn y P D . ((DD = (insert (C\<bullet>mn(y), P) D)) \<longrightarrow> (G \<rhd> (C\<bullet>mn(y)) :: P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> (D \<rhd> e :: Q)))"
by (drule CutAux , simp)

lemma Inv_CutAux: 
"(DD \<rhd> e :: Q) \<Longrightarrow>
(\<forall> G C mn P D . ((DD = (insert (x\<diamondsuit>mn(y), P) D)) \<longrightarrow> (G \<rhd> (x\<diamondsuit>mn(y)) :: P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> (D \<rhd> e :: Q)))"
by (drule CutAux , simp)

lemma CCut:"\<lbrakk> (insert (ee, P) D) \<rhd> e:: Q; G \<rhd> ee :: P; G \<subseteq> D\<rbrakk> \<Longrightarrow> D \<rhd> e::Q"
by (drule CutAux , simp)

lemma cut:"\<lbrakk> G \<rhd> ee :: P ; (insert (ee, P) G) \<rhd> e :: Q \<rbrakk> \<Longrightarrow> G \<rhd> e :: Q"
by (drule CutAux , simp)

(*callInvokeContext G == true if G contains only entried for Calls or xxx_invokes*)
constdefs callInvokeContext::"vdmcontext \<Rightarrow> bool"
"callInvokeContext G == 
(\<forall> e Q . (e,Q) : G \<longrightarrow> (\<exists> f . e = Call f))"

(*contextProvable G D == true if all calls and invokes in G are provable from D*)
constdefs contextProvable::" vdmcontext \<Rightarrow>  vdmcontext \<Rightarrow> bool"
"contextProvable G D == (\<forall> e Q . (e, Q) : G \<longrightarrow> D \<rhd> e :: Q)"

lemma cut2Aux:
"\<forall> G D . (finite G \<longrightarrow> D \<subseteq> G \<longrightarrow> card (G - D) = n \<longrightarrow> 
          (\<forall> e P. (G \<rhd> e :: P \<longrightarrow> (callInvokeContext G) \<longrightarrow> (contextProvable G D) \<longrightarrow> D \<rhd> e :: P)))"
apply (induct n)
apply clarsimp
apply (subgoal_tac "G = D", simp)
defer 1
apply clarsimp
apply (erule_tac x=G in allE)
apply (erule impE, assumption)
apply (subgoal_tac "\<exists> ee P DDD . G - D = {(ee,P)} \<union> DDD \<and> (ee,P) \<notin> DDD \<and> card DDD = n")
apply (erule exE)+
apply (erule conjE)+
apply (erule_tac x="D \<union> {(ee,Pa)}" in allE)
apply (erule impE)
apply rule
apply (subgoal_tac "x:D \<or> x : {(ee,Pa)}")
apply (erule disjE, fast)
apply simp
apply (subgoal_tac "(ee, Pa) \<in> G - D", fast)
apply (subgoal_tac "(ee, Pa) \<in> insert (ee, Pa) DDD", simp)
apply fast
apply fast
apply (erule impE)
defer 1
apply (erule_tac x=e in allE, erule_tac x=P in allE)
apply (erule impE, assumption)
apply (erule impE, assumption)
apply (erule impE)
apply (simp add: contextProvable_def)
apply (insert CtxtWeak)
apply (rule, clarsimp)
apply (erule_tac x=ea in allE, erule_tac x=Q in allE)
apply (erule impE, assumption)
apply (subgoal_tac "(D \<union> {(ee,Pa)}) \<rhd>  ea :: Q ")
apply (subgoal_tac "D \<union> {(ee,Pa)} = insert (ee, Pa) D", simp)
apply simp
apply (erule_tac thin_rl, erule_tac thin_rl, erule_tac thin_rl, erule_tac thin_rl, erule_tac thin_rl, erule_tac thin_rl)
apply (rotate_tac 2)
apply fast
(* end of the proof of contextprovable G - \<dots>*)
apply (rotate_tac -1, erule thin_rl)
apply (rule CCut)
apply (subgoal_tac "insert (ee, Pa) D \<rhd>  e :: P", assumption)
apply (subgoal_tac "D \<union> {(ee,Pa)} = insert (ee, Pa) D", simp)
apply simp
apply (subgoal_tac "D \<rhd>  ee :: Pa", assumption)
apply (subgoal_tac "(ee,Pa) \<in> G", simp add: callInvokeContext_def)
apply (erule_tac x=ee in allE)
apply (erule impE)
apply (rule_tac x=Pa in exI, assumption)
apply (clarsimp, simp add: contextProvable_def)
apply (subgoal_tac "(ee, Pa) \<in> G - D", fast)
apply (subgoal_tac "(ee, Pa) \<in> {(ee, Pa)} \<union> DDD", simp)
apply fast
apply simp
apply (rotate_tac 3, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
defer 1
apply fast
apply (rotate_tac 3, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rotate_tac 3, erule thin_rl)
apply (subgoal_tac "G - (D \<union> {(ee, Pa)}) = DDD", simp)
apply rule
apply rule
apply fast
apply rule
apply (case_tac "x:G")
apply (case_tac "x :D")
apply fast
apply fast
apply fast
apply (subgoal_tac "finite (G - D)")
prefer 2 apply simp
apply (case_tac "G - D = {}")
apply simp
apply (subgoal_tac "\<exists> x. x: (G - D)")
prefer 2 apply fast
apply (erule exE)
apply (rule_tac x="fst x" in exI)
apply (rule_tac x="snd x" in exI)
apply (rule_tac x="(G - D) - {x}" in exI)
apply rule
apply fastsimp
apply rule
apply fastsimp
apply (simp add: card_Diff_singleton)
done

lemma cut2:"\<lbrakk>finite G; G \<rhd> e :: P; D \<subseteq> G; callInvokeContext G; contextProvable G D\<rbrakk> \<Longrightarrow> D \<rhd> e :: P"
apply (insert cut2Aux [of "card (G - D)"])
by (erule_tac x=G in allE, erule_tac x=D in allE, fastsimp)

subsection {* Mutual recursion *}

declare callInvokeContext_def[simp]

text {*
 For working with sets of mutually recursive functions/methodsm, we require that their
 specifications are collected in the following table.
*}

consts
  spectable  :: "funame \<Rightarrow> vdmassn"          -- {* specifications of functions *}
  Mspectable :: "cname \<Rightarrow> mname \<Rightarrow> vdmassn"  -- {* specifications of methods *}

text {* 
 We define what it means for a context to be consistent with the above tables.
*}

constdefs consistent::" vdmcontext \<Rightarrow> bool"
"consistent G == 
(\<forall> f P. (Call f, P) : G \<longrightarrow> (P = spectable f \<and> G \<rhd> funtable f:: (\<lambda> E h hh v p . P  E h hh v (tkcall p))))"

lemma consistent_preserved: "\<lbrakk>consistent G; callInvokeContext G; (e,Q):G\<rbrakk> \<Longrightarrow> consistent (G - {(e,Q)})"
apply (simp add: consistent_def, clarsimp)
apply (subgoal_tac "(G - {(e,Q)}) \<rhd> e::Q")(*now use the subgoal (G - {(e,Q)}) \<rhd> e::Q to prove the goal*)
apply (subgoal_tac "G = insert (e, Q) (G - {(e, Q)})") prefer 2 apply fast
(*case call*)
apply (erule_tac x=f in allE, erule_tac x=P in allE, clarsimp)
apply (rule cut, assumption, simp)
(* now prove the subgoal (G - {(e, Q)}) \<rhd>  e :: Q *)
  apply (erule_tac x=e in allE)
  apply (subgoal_tac "(\<exists>f. e = CALL f)")
  apply (rotate_tac -2, erule thin_rl)
  prefer 2 apply clarsimp
  (*case call*)
  apply clarsimp
(*  apply (rotate_tac 1, erule thin_rl)*)
(*  apply (erule_tac x=fa in allE, erule_tac x=Q in allE, clarsimp)*)
  apply (rule vdm_call)
  apply (subgoal_tac "G = insert (CALL fa, Q) (G - {(CALL fa, Q)})")
  apply clarsimp 
  apply (erule_tac x=fa in allE, erule_tac x=Q in allE, clarsimp)
  apply (subgoal_tac "(\<lambda>E h hh v p.
                          spectable fa E h hh v
                           (mkRescomp (1 + clock p) (1 + callc p) (invkc p)
                             (invkdpth p))) = tkCallAssn (spectable fa)", clarsimp)
  apply (rule, rule, rule, rule, rule, simp add: tkCallAssn_def)
  apply fastsimp
done

subsection {* Rule for mutual recursion *}

lemma MUTREClemma: 
"\<forall> G . ((finite G \<and> card G = n \<and> callInvokeContext G \<and> consistent G \<and> (e,P) : G) \<longrightarrow> \<rhd> e::P)"
apply (induct n)
(*case n=0*)
apply clarsimp
(*Case n>0*)
apply clarsimp
apply (case_tac "G = {(e,P)}")
apply clarsimp
apply (erule_tac x="{(e,P)}" in allE)
apply (clarsimp, simp add:consistent_def)
apply (rule vdm_call, clarsimp)
apply (subgoal_tac "(\<lambda>E h hh v p.
                            spectable f E h hh v
                             (mkRescomp (1 + clock p) (1 + callc p)
                               (invkc p) (invkdpth p))) = tkCallAssn (spectable f)", clarsimp)
apply (rule, rule, rule, rule, rule, simp add: tkCallAssn_def)
(*Case G has more entries than (e,P)*) 
apply (subgoal_tac "\<exists> ee Q . (ee,Q) \<noteq> (e,P) \<and> (ee,Q) : G")
prefer 2
apply (rotate_tac 2)
apply (erule thin_rl, erule thin_rl)
apply (rotate_tac 1)
apply (erule thin_rl)
apply fastsimp
(* use the fact that there is another pair (ee,Q)::G*)
apply clarsimp
apply (subgoal_tac "(G - {(ee,Q)}) \<rhd> ee:: Q")
apply (erule_tac x="G - {(ee, Q)}" in allE)
apply (subgoal_tac "consistent (G - {(ee, Q)})", simp)
prefer 2 apply (simp add: consistent_preserved)
apply (subgoal_tac "card (G - {(ee, Q)}) = n", simp)
prefer 2 apply (simp add: card_Diff_singleton) 
apply clarsimp
apply (case_tac "e = ee", clarsimp)
apply (case_tac "P = Q", clarsimp, clarsimp)
apply (case_tac "ea = e", clarsimp)
apply (erule_tac x=e in allE, simp)
apply clarsimp
apply (erule_tac x=ea in allE, simp)
apply clarsimp
apply (case_tac "ea = ee", clarsimp)
apply (erule_tac x=ee in allE, simp)
apply clarsimp
apply (erule_tac x=ea in allE, simp)
(*the proof for (G - {(ee, Q)}) \<rhd>  ee :: Q *)
  apply (erule_tac x=ee in allE)
  apply (subgoal_tac "(\<exists>f. ee = CALL f)", clarsimp)
  prefer 2 apply(subgoal_tac "(\<exists>Q. (ee, Q) \<in> G)", simp) apply(rule_tac x=Q in exI, simp)
  (*case call*)
    apply (rule vdm_call)
    apply (subgoal_tac "G - {(CALL f, Q)} \<union> {(CALL f, Q)} = G")
    prefer 2 apply fast
    apply clarsimp
    apply (rotate_tac 4) apply (erule thin_rl)
    (*before unfolding consistent, we first bring the other 4 cases to the same state as this goal*)
  (* back to case call*)
  apply (unfold consistent_def)
  apply (erule_tac x=f in allE, erule_tac x="Q" in allE, clarsimp)
  apply (subgoal_tac "(\<lambda>E h hh v p.
                         spectable f E h hh v
                          (mkRescomp (1 + clock p) (1 + callc p) (invkc p)
                            (invkdpth p))) = tkCallAssn (spectable f)", clarsimp)
  apply (rule, rule, rule, rule, rule, simp add: tkCallAssn_def)
done


text {*
 This is the rule we use for proving properties over mutually recursive functions/methods.
*}

theorem MUTREC:
"\<lbrakk> finite G; card G = n; callInvokeContext G; consistent G; (e,P) : G \<rbrakk> \<Longrightarrow> \<rhd> e::P"
by (insert MUTREClemma [of n e P], fast)

end
