(*  Examples from List.cmlt -> Grail*)

theory RevComb =  ListClassComb:
(* List reversal:
Camelot:
let rev' l acc = 
  match l with Nil@d => acc 
             | Cons (h, t)@d => rev' t (Cons (h, acc)@d )

Grail:   
class ListRevInPlace {
   method public static ListRevInPlace$dia_0 rev' (ListRevInPlace$dia_0 l,
ListRevInPlace$dia_0 acc) =
   let

      fun f:rev'(ListRevInPlace$dia_0 l, ListRevInPlace$dia_0 d,
ListRevInPlace$dia_0 ?t0, ListRevInPlace$dia_0 d#0, int h, ListRevInPlace$dia_0
t, ListRevInPlace$dia_0 acc, ListRevInPlace$dia_0 l) =
      let
         val tag = getfield l <int ListRevInPlace$dia_0.$>
      in
         if tag = 0
         then f:0(l, d, ?t0, d#0, h, t, acc, l)
         else f:1(l, d, ?t0, d#0, h, t, acc, l)
      end

      fun f:1(ListRevInPlace$dia_0 l, ListRevInPlace$dia_0 d,
ListRevInPlace$dia_0 ?t0, ListRevInPlace$dia_0 d#0, int h, ListRevInPlace$dia_0
t, ListRevInPlace$dia_0 acc, ListRevInPlace$dia_0 l) =
      let
         val h = getfield l <int ListRevInPlace$dia_0.f0>
         val t = getfield l <ListRevInPlace$dia_0
ListRevInPlace$dia_0.f1>
         val d#0 = l
         val ?t0 = invokestatic <ListRevInPlace$dia_0
ListRevInPlace$dia_0.fill (ListRevInPlace$dia_0, int, int,
ListRevInPlace$dia_0)> (d#0, 1, h, acc)
      in
         invokestatic <ListRevInPlace$dia_0 ListRevInPlace.rev'
(ListRevInPlace$dia_0, ListRevInPlace$dia_0)> (t, ?t0)
      end

      fun f:0(ListRevInPlace$dia_0 l, ListRevInPlace$dia_0 d,
ListRevInPlace$dia_0 ?t0, ListRevInPlace$dia_0 d#0, int h, ListRevInPlace$dia_0
t, ListRevInPlace$dia_0 acc, ListRevInPlace$dia_0 l) =
      let
         val d = l
      in
         acc
      end
   in
      f:rev'(l, d, ?t0, d#0, h, t, acc, l)
   end
}

ToyGrail:
class ListRevInPlace {
   method public static List rev' (List l, List acc) =
   let fun f(List l, List acc) =
        let  tag = getfield l TAG
        in if tag = 0
           then acc
           else let  h = getfield l HD
                     t = getfield l TL
                     one = 1
                     () = putfield l TAG one
                     () = putfield l HD h
                     () = putfield l TL acc
                     acc = l
                     l = t
                in f(l,acc)
                end
   in
      f(l, acc)
   end
}
*)


declare rescomp_plus_def [simp del]
declare rescomp_cup_def [simp del]

lemma SetAux[simp]: "\<lbrakk>X \<inter> Y = {}; x:X\<rbrakk> \<Longrightarrow> \<not> x:Y"
by fast

lemma clockRC: "clock (mkRescomp a b c d) = a"
by simp

lemma callcRC: "callc (mkRescomp a b c d) = b"
by simp

lemma invkcRC: "invkc (mkRescomp a b c d) = c"
by simp

lemma invkdpthRC: "invkdpth (mkRescomp a b c d) = d"
by simp

(*
constdefs split::"heap \<Rightarrow> heap \<Rightarrow> heap \<Rightarrow> bool"
"split h h1 h2 == (\<forall> r iF v. ((((h1<r\<bullet>iF> = v) \<or> (h2<r\<bullet>iF> = v)) \<longrightarrow> h<r\<bullet>iF> = v) \<and> 
                               (h<r\<bullet>iF> = v \<longrightarrow> ((h1<r\<bullet>iF> = v) \<or> (h2<r\<bullet>iF> = v)))"
*)

constdefs Dom :: "heap \<Rightarrow> locn set"
"Dom h == fmap_dom (oheap h)"

constdefs heapsum::"heap \<Rightarrow> heap \<Rightarrow> heap"
"heapsum h1 h2 == \<lparr>oheap = Abs_Finmap((Rep_Finmap (objhp h1)) ++ (Rep_Finmap (objhp h2))),
                   iheap = \<lambda> ifld l . if l: Dom h1 then h1<l\<bullet>ifld> else h2<l\<bullet>ifld>,
                   rheap = \<lambda> rfld l . if l: Dom h1 then h1\<lfloor>l\<diamondsuit>rfld\<rfloor> else h2\<lfloor>l\<diamondsuit>rfld\<rfloor>\<rparr>"
constdefs LL::"nat \<Rightarrow> rname \<Rightarrow> vdmassn"
"LL L l E h hh v p == (\<exists> X r. E\<lfloor>l\<rfloor> = Ref r \<and> (L,r,X,h) \<in> LocLength)"

lemma LookupDom:"fmap_lookup (oheap h) l = Some c \<Longrightarrow> l : Dom h"
by (simp add: Dom_def fmap_dom_def themap_def fmap_lookup_def, auto)

constdefs star::"vdmassn \<Rightarrow> vdmassn \<Rightarrow> vdmassn"
"star he1 he2 E h hh v p == (\<exists> h1 h2. he1 E h1 hh v p \<and> he2 E h2 hh v p \<and> Dom h1 \<inter> Dom h2 = {} \<and> h = heapsum h1 h2)"

constdefs LLX::"locn set \<Rightarrow> nat \<Rightarrow> rname \<Rightarrow> vdmassn"
"LLX X L l E h hh v p == (\<exists> r. E\<lfloor>l\<rfloor> = Ref r \<and> (L,r,X,h) \<in> LocLength)"

constdefs starLists::"nat \<Rightarrow> rname \<Rightarrow> nat \<Rightarrow> rname \<Rightarrow> vdmassn"
"starLists L l A a E h hh v p == (\<exists> X Y . (LLX X L l && LLX Y A a) E h hh v p \<and> X \<inter> Y = {})"


lemma "IMPLIES (HeapIs Same) (allocates (constVE (IVal 0)))"
by (simp add: IMPLIES_def HeapIs_def Same_def allocates_def constVE_def)

lemma ANDelim1Ass: "IMPLIES (A && B) A"
by (simp add: IMPLIES_def AND_def)

lemma ANDelim2Ass: "IMPLIES (A && B) B"
by (simp add: IMPLIES_def AND_def)

lemma ANDelim: "\<lbrakk>(A && B) E h hh v p; \<lbrakk>A E h hh v p; B E h hh v p\<rbrakk> \<Longrightarrow> R \<rbrakk> \<Longrightarrow> R"
by (simp add: AND_def)

lemma ANDintro: "\<lbrakk> A E h hh v p; B E h hh v p\<rbrakk> \<Longrightarrow> (A && B) E h hh v p"
by (simp add: AND_def)

lemma HeapsumIfld1: "\<lbrakk>h = heapsum h1 h2; r : Dom h1\<rbrakk> \<Longrightarrow> h<r\<bullet>F> = h1<r\<bullet>F>"
by (simp add: heapsum_def Dom_def)
lemma HeapsumIfld2: "\<lbrakk>h = heapsum h1 h2; r : Dom h2; r \<notin> Dom h1\<rbrakk> \<Longrightarrow>  h2<r\<bullet>F> = h<r\<bullet>F>"
by (simp add: heapsum_def Dom_def)
lemma HeapsumRfld1: "\<lbrakk>h = heapsum h1 h2; r : Dom h1\<rbrakk> \<Longrightarrow> h\<lfloor>r\<diamondsuit>F\<rfloor> = h1\<lfloor>r\<diamondsuit>F\<rfloor>"
by (simp add: heapsum_def Dom_def)
lemma HeapsumRfld2: "\<lbrakk>h = heapsum h1 h2; r : Dom h2; r \<notin> Dom h1\<rbrakk> \<Longrightarrow>  h2\<lfloor>r\<diamondsuit>F\<rfloor> = h\<lfloor>r\<diamondsuit>F\<rfloor>"
by (simp add: heapsum_def Dom_def)


lemma HeapsumTAG1: "\<lbrakk>(heapsum h1 h2)<r\<bullet>TAG> < 1; r : Dom h1\<rbrakk> \<Longrightarrow> h1<r\<bullet>TAG> < 1"
by (simp add: HeapsumIfld1)

lemma ResultFieldAccess:"\<lbrakk>ResultIs (idotVE (rvarVE l) F) E h h1 (IVal i) p; renv E l = Ref r\<rbrakk> \<Longrightarrow> h<r\<bullet>F> = i"
by (simp add: ResultIs_def valExpr_predicates)

lemma ResultIop1: "ResultIs (iopVE (ivarVE v) (\<lambda>x y. if x < 1 then 1 else 0) (ivarVE v)) E<v:=i> h h1 (IVal 1) p \<Longrightarrow> i < 1"
by (simp add: ResultIs_def valExpr_predicates)

lemma ResultIop2: "ResultIs (iopVE (ivarVE v) (\<lambda>x y. if x < 1 then 1 else 0) (ivarVE v)) E<v:=i> h h1 (IVal 0) p \<Longrightarrow> \<not> i < 1"
by (simp add: ResultIs_def valExpr_predicates)

lemma LocLengthDom1:"(L, r, X, h) \<in> LocLength \<Longrightarrow> r:Dom h"
by (simp add: Dom_def, erule LocLengthElim3)

lemma LocLengthDom2:"(L, r, X, h) \<in> LocLength \<Longrightarrow> X \<subseteq> (Dom h)"
by (simp add: Dom_def, erule LocLengthElim4)

lemma TicksConst: "ticks (constVE (IVal i)) E h h1 v p \<Longrightarrow> clock p = i"
by (simp add: ticks_def constVE_def)

lemma ConstArith1: "\<lbrakk>constVE (IVal (a * c + b)) E1 h1 (IVal i); a + b = d \<rbrakk> \<Longrightarrow> 
                    constVE (IVal (d + a * c)) E h (IVal (a + i))"
by (simp add: constVE_def)

lemma Iupd: "\<lbrakk>x \<noteq> y\<rbrakk> \<Longrightarrow> ienv E<x:=v> y = E<y>"
by (insert ivarupdate_def, fastsimp)

lemma Rupd: "\<lbrakk>x \<noteq> y\<rbrakk> \<Longrightarrow> renv E\<lfloor>x:=v\<rfloor> y = E\<lfloor>y\<rfloor>"
by (insert rvarupdate_def, fastsimp)

lemma IRupd: "renv E<x:=v> y = E\<lfloor>y\<rfloor>"
by (insert ivarupdate_def, fastsimp)

lemma RIupd: "ienv E\<lfloor>x:=v\<rfloor> y = E<y>"
by (insert rvarupdate_def, fastsimp)

locale RevInplaceClock = 
  fixes    tag     :: iname    and	   h       :: iname    and	   b       ::iname   and one :: iname
    and    l       :: rname    and         acc     :: rname    and         t      :: rname  
    and	   f       :: funame   and callcA :: int and callcB :: int and clockA ::int and clockB :: int and invkcA :: int 
    and invkcB :: int and invkdpthA :: nat and invkdpthB :: nat and sf::vdmassn
 assumes  funtf:
          "funtable f == (LET tag = GetFi l TAG;
                                b = Primop (% x y. if x < 1 then 1 else 0) tag tag
                          IN IF b THEN RVar acc 
                             ELSE LET  h   = GetFi l HD;
                                    rf t   = GetFr l TL;
                                       one = expr.Int 1;
                                         _ = PutFi l TAG one; 
                                         _ = PutFi l HD h;
                                         _ = PutFr l TL acc;
                                    rf acc = RVar l;
                                    rf l   = RVar t 
                                 IN CALL f END
                         END)"
      and  vardistinct:     "tag \<noteq> h \<and> tag \<noteq> b \<and> tag \<noteq> one \<and> h \<noteq> b \<and> h \<noteq> one \<and> b \<noteq> one \<and> 
                             l \<noteq> acc \<and> l \<noteq> t \<and> acc \<noteq> t \<and> 
                             HD \<noteq> TAG"
      and resdefs: "(callcA = 1) \<and> (callcB = 1) \<and> (clockA = 31) \<and> (clockB = 11) \<and> (invkcA = 0)
                    \<and> (invkcB = 0) \<and> (invkdpthA = 0) \<and> (invkdpthB = 0)"
     defines spectf: "sf E hp hh v p == 
                  (\<forall> L AC . impliesAssn (starLists L l AC acc)
                                        (ticks (constVE (IVal(clockA * (int L) + clockB)))) E hp hh v p)"

lemma Same_same: "HeapIs Same E h hh v p \<Longrightarrow> same X h hh"
by (simp add: HeapIs_def Same_def same_def)

lemma iUpd_same: "\<lbrakk>HeapIs (iUpd Same (rvarVE x) FLD (ivarVE y)) E h hh v p; E\<lfloor>x\<rfloor> = Ref l; l \<notin> X\<rbrakk> \<Longrightarrow>
       same X h hh"
by (simp add: predicates same_def)

lemma rUpd_same: "\<lbrakk>HeapIs (rUpd Same (rvarVE x) FLD (rvarVE y)) E h hh v p; E\<lfloor>x\<rfloor> = Ref l; l \<notin> X\<rbrakk> \<Longrightarrow>
       same X h hh"
by (simp add: predicates same_def)

lemma same_trans: "\<lbrakk>same X h h1; same X h1 h2\<rbrakk> \<Longrightarrow> same X h h2"
by (simp add: same_def)

lemma same_id:"same X h h"
by (simp add: same_def)

lemma Same_NoClassChange: "\<lbrakk>HeapIs Same E h h1 v p; h@@la = Some LST\<rbrakk> \<Longrightarrow> h1@@la = Some LST"
by (simp add:HeapIs_def Same_def)

lemma iUpd_NoClassChange: "\<lbrakk>HeapIs (iUpd Same (rvarVE x) FLD (ivarVE y)) E h h1 v p; h@@la = Some LST\<rbrakk> 
     \<Longrightarrow> h1@@la = Some LST"
by (simp add:HeapIs_def iUpd_def Same_def, auto)

lemma rUpd_NoClassChange: "\<lbrakk>HeapIs (rUpd Same (rvarVE x) FLD (rvarVE y)) E h h1 v p; h@@la = Some LST\<rbrakk> 
     \<Longrightarrow> h1@@la = Some LST"
by (simp add:HeapIs_def rUpd_def Same_def, auto)


lemma Same_getFI: "\<lbrakk>HeapIs Same E h hh v p; h<l\<bullet>F> = i\<rbrakk> \<Longrightarrow> hh<l\<bullet>F> = i"
by (simp add: HeapIs_def Same_def)

lemma rUpd_getFI: "\<lbrakk>HeapIs (rUpd Same obj FF w) E h hh v p; h<l\<bullet>F> = i\<rbrakk> \<Longrightarrow> hh<l\<bullet>F> = i"
by (simp add: HeapIs_def Same_def rUpd_def, auto)

lemma iUpd_getFI1: "\<lbrakk>HeapIs (iUpd Same obj FF w) E h hh v p; FF \<noteq> F; h<l\<bullet>F> = i\<rbrakk> \<Longrightarrow> hh<l\<bullet>F> = i"
by (simp add: HeapIs_def Same_def iUpd_def, auto)

lemma iUpd_getFI2: "\<lbrakk>HeapIs (iUpd Same ve F w) E h hh v p; 
                     \<not> ve E h (RVal (Ref l)); h<l\<bullet>F> = i\<rbrakk> \<Longrightarrow> hh<l\<bullet>F> = i"
by (simp add: HeapIs_def Same_def iUpd_def, auto)

lemma iUpd_getFI3: "\<lbrakk>HeapIs (iUpd Same (rvarVE x) F (constVE (IVal i))) E h hh v p;
                     E\<lfloor>x\<rfloor> = Ref l\<rbrakk> \<Longrightarrow> hh<l\<bullet>F> = i"  
by (simp add: HeapIs_def Same_def iUpd_def constVE_def rvarVE_def)

lemma iUpd_getFI4: "\<lbrakk>HeapIs (iUpd Same (rvarVE x) F (ivarVE y)) E h hh v p;
                     E\<lfloor>x\<rfloor> = Ref l; E<y> = i\<rbrakk> \<Longrightarrow> hh<l\<bullet>F> = i"  
by (simp add: HeapIs_def Same_def iUpd_def ivarVE_def rvarVE_def)

lemma Same_getFR: "\<lbrakk>HeapIs Same E h hh v p; h\<lfloor>l\<diamondsuit>F\<rfloor> = r\<rbrakk> \<Longrightarrow> hh\<lfloor>l\<diamondsuit>F\<rfloor> = r"
by (simp add: HeapIs_def Same_def)

lemma iUpd_getFR: "\<lbrakk>HeapIs (iUpd Same obj FF w) E h hh v p; h\<lfloor>l\<diamondsuit>F\<rfloor> = r\<rbrakk> \<Longrightarrow> hh\<lfloor>l\<diamondsuit>F\<rfloor> = r"
by (simp add: HeapIs_def Same_def iUpd_def, auto)

lemma rUpd_getFR1: "\<lbrakk>HeapIs (rUpd Same obj FF w) E h hh v p; FF \<noteq> F; h\<lfloor>l\<diamondsuit>F\<rfloor> = r\<rbrakk> \<Longrightarrow> hh\<lfloor>l\<diamondsuit>F\<rfloor> = r"
by (simp add: HeapIs_def Same_def rUpd_def, auto)

lemma rUpd_getFR2: "\<lbrakk>HeapIs (rUpd Same ve F w) E h hh v p; 
                     \<not> ve E h (RVal (Ref l)); h\<lfloor>l\<diamondsuit>F\<rfloor> = r\<rbrakk> \<Longrightarrow> hh\<lfloor>l\<diamondsuit>F\<rfloor> = r"
by (simp add: HeapIs_def Same_def rUpd_def, auto)

lemma rUpd_getFR3: "\<lbrakk>HeapIs (rUpd Same (rvarVE x) F (constVE (RVal r))) E h hh v p;
                     E\<lfloor>x\<rfloor> = Ref l\<rbrakk> \<Longrightarrow> hh\<lfloor>l\<diamondsuit>F\<rfloor> = r"  
by (simp add: HeapIs_def Same_def rUpd_def constVE_def rvarVE_def)

lemma rUpd_getFR4: "\<lbrakk>HeapIs (rUpd Same (rvarVE x) F (rvarVE y)) E h hh v p;
                     E\<lfloor>x\<rfloor> = Ref l; E\<lfloor>y\<rfloor> = r\<rbrakk> \<Longrightarrow> hh\<lfloor>l\<diamondsuit>F\<rfloor> = r"  
by (simp add: HeapIs_def Same_def rUpd_def ivarVE_def rvarVE_def)

lemma ResultIConst: "ResultIs (constVE (IVal i)) E h h1 (IVal j) p \<Longrightarrow> j=i"
by (simp add: ResultIs_def constVE_def)

lemma ResultRConst: "ResultIs (constVE (RVal r)) E h h1 (RVal s) p \<Longrightarrow> s=r"
by (simp add: ResultIs_def constVE_def)

lemma ResultIVar: "ResultIs (ivarVE x) E h h1 (IVal i) p \<Longrightarrow> E<x>=i"
by (simp add: ResultIs_def ivarVE_def)

lemma ResultRVar: "ResultIs (rvarVE x) E h h1 (RVal r) p \<Longrightarrow> E\<lfloor>x\<rfloor>=r"
by (simp add: ResultIs_def rvarVE_def)

lemma tickClock:"tickCosts i E h h1 v p \<Longrightarrow> clock p = i"
by (simp add: tickCosts_def costs_def AND_def ticks_def constVE_def)

lemma ResultRDot: "\<lbrakk>ResultIs (rdotVE (rvarVE x) F) E h h1 (RVal r) p; E\<lfloor>x\<rfloor> = Ref l\<rbrakk> \<Longrightarrow> h\<lfloor>l\<diamondsuit>F\<rfloor> = r"
by (simp add: ResultIs_def rdotVE_def rvarVE_def constVE_def)

lemma (in RevInplaceClock) "\<rhd> (Call f) :: sf"
apply (rule vdm_call)
apply (rule vdm_conseq)
apply (simp only:funtf)
apply(rule vdm_basics)+
apply (rule vdm_ax, simp)
apply (simp add: IMPLIES_def)
apply (simp add: tkCallAssn_def spectf)
apply (simp only: impliesAssn_def, safe)
apply (simp add: letiComb_def)
apply (simp only: condComb_def)
apply safe
apply (case_tac "ia = 1")
(*Case 1*)
apply clarsimp
apply (erule ANDelim)+
apply (simp add: starLists_def AND_def LLX_def, safe)
apply (subgoal_tac "L=0")
apply (simp add: tickClock ticks_def rescomp_cup_def constVE_def resdefs)
apply (rule LocLengthElim1, assumption)
apply (simp only: ResultFieldAccess)
apply (erule ResultIop1)
(*case 2*)
apply clarsimp
apply (simp add: letiComb_def letrComb_def letvComb_def)
apply (simp add: spectf impliesAssn_def)
apply (erule ANDelim)+
apply (simp only: starLists_def AND_def LLX_def, safe)
apply (subgoal_tac "\<exists> LL. L = Suc LL", safe)
prefer 2
  apply (subgoal_tac "ha<r\<bullet>TAG> = i")
  apply (subgoal_tac "\<not> i < 1")
  apply (erule LocLengthDom3, simp)
  apply (erule ResultIop2)
  apply (erule ResultFieldAccess, assumption)
apply (erule LocLength.elims, simp_all, safe)
apply (erule_tac x=id in allE)
apply (erule impE)
prefer 2 (*apply (erule ANDelim)+
ticks
apply (rule ANDintro)*)
apply (simp add: tickClock ticks_def constVE_def rescomp_cup_def resdefs)
(*last goal*)
apply (rule_tac x="Suc AC" in exI, rule_tac x="Xa-{la}" in exI,safe)
apply (rule_tac x=tt in exI, safe)
  (*an easier proof of this subgoal is
    apply (simp add: ResultIs_def constVE_def rvarVE_def rdotVE_def rvarVE_def HeapIs_def Same_def Iupd Rupd vardistinct)
   , but we aim at deriving lemmas\<dots>*)
  apply (subgoal_tac "rd = rb", safe)
  apply (subgoal_tac "h1b\<lfloor>la\<diamondsuit>TL\<rfloor> = rb")
  apply (simp add: Same_getFR)
  apply (erule ResultRDot, simp add: vardistinct)
  apply (simp add: ResultIs_def rvarVE_def vardistinct Iupd Rupd)
apply (erule LocLengthSame)
  apply (rule same_trans, erule Same_same)+
  apply (rule same_trans,
         ((erule iUpd_same)+),
         simp add: vardistinct,
         fast)+
  apply (rule same_trans,
         ((erule rUpd_same)+),
         simp add: vardistinct,
         fast)+
  apply (rule same_trans, erule Same_same)+
  apply (rule same_id)
apply (rule_tac x="Y \<union> {la}" in exI, rule, rule_tac x="la" in exI )
apply rule
apply (subgoal_tac "E<tag:=i><b:=0><h:=ib>\<lfloor>t:=rb\<rfloor><one:=ic>\<lfloor>l\<rfloor>=  rc")
apply (simp add: vardistinct Rupd)
apply (erule ResultRVar)

apply (rule CONS_LocL, simp_all)

apply (erule Same_NoClassChange)+
apply (erule rUpd_NoClassChange)+
apply (erule iUpd_NoClassChange)+
apply (erule Same_NoClassChange)+
apply (assumption)

apply (erule Same_getFI)+
apply (erule rUpd_getFI)
apply (erule iUpd_getFI1, simp add: vardistinct)
apply (erule iUpd_getFI4, simp add: vardistinct)
apply simp 
apply (erule ResultIConst)

apply (erule Same_getFR)+
apply (erule rUpd_getFR4, (simp add: vardistinct)+)

apply (erule LocLengthDom)

apply (erule LocLengthSame)
apply (rule same_trans, erule Same_same)+
apply (rule same_trans, ((erule iUpd_same)+), simp add: vardistinct, fast)+
apply (rule same_trans, ((erule rUpd_same)+), simp add: vardistinct, fast)+
apply (rule same_trans, erule Same_same)+
apply (rule same_id)

apply fast
done

lemma tickCalls:"tickCosts i E h h1 v p \<Longrightarrow> callc p = 0"
by (simp add: tickCosts_def costs_def AND_def calls_def constVE_def)

lemma tickInvks:"tickCosts i E h h1 v p \<Longrightarrow> invkc p = 0"
by (simp add: tickCosts_def costs_def AND_def invokes_def constVE_def)

lemma tickDepth:"tickCosts i E h h1 v p \<Longrightarrow> invkdpth p = 0"
by (simp add: tickCosts_def costs_def AND_def depth_def constVE_def)

lemma tickAlloc:"tickCosts i E h h1 v p \<Longrightarrow> allocates (constVE (IVal 0)) EE h h1 w q"
by (simp add: tickCosts_def costs_def AND_def allocates_def constVE_def)

lemma ClockTrans:
      "\<lbrakk>tickCosts j E h1 h2 w q; tickCosts i E h h1 v p;  k = i + j\<rbrakk> \<Longrightarrow> ticks (constVE (IVal k)) EEE h h2 u (p \<smile> q)"
by (simp add: ticks_def constVE_def rescomp_cup_def tickClock)

lemma AllocTrans:
     "\<lbrakk>allocates (constVE (IVal i)) E h h1 v p; allocates (constVE (IVal j)) E h1 h2 v p; k = i + j\<rbrakk> \<Longrightarrow>
      allocates (constVE (IVal k)) E h h2 v p"
by (simp add: allocates_def constVE_def)

lemma AllocId:"allocates (constVE (IVal 0)) E h h v p"
by (simp add: allocates_def constVE_def)

lemma AllocConst: "allocates (constVE (IVal i)) E h hh v p \<Longrightarrow> allocates (constVE(IVal i)) EE h hh w q"
by (simp add: allocates_def constVE_def)

locale RevInplace = 
  fixes    tag     :: iname    and	   h       :: iname    and	   b       ::iname   and one :: iname
    and    l       :: rname    and         acc     :: rname    and         t      :: rname  
    and	   f       :: funame   and callcA :: int and callcB :: int and clockA ::int and clockB :: int and invkcA :: int 
    and invkcB :: int and invkdpthA :: nat and invkdpthB :: nat and sf::vdmassn
 assumes  funtf:
          "funtable f == (LET tag = GetFi l TAG;
                                b = Primop (% x y. if x < 1 then 1 else 0) tag tag
                          IN IF b THEN RVar acc 
                             ELSE LET  h   = GetFi l HD;
                                    rf t   = GetFr l TL;
                                       one = expr.Int 1;
                                         _ = PutFi l TAG one; 
                                         _ = PutFi l HD h;
                                         _ = PutFr l TL acc;
                                    rf acc = RVar l;
                                    rf l   = RVar t 
                                 IN CALL f END
                         END)"
      and  vardistinct:     "tag \<noteq> h \<and> tag \<noteq> b \<and> tag \<noteq> one \<and> h \<noteq> b \<and> h \<noteq> one \<and> b \<noteq> one \<and> 
                             l \<noteq> acc \<and> l \<noteq> t \<and> acc \<noteq> t \<and> 
                             HD \<noteq> TAG"
      and resdefs: "(callcA = 1) \<and> (callcB = 1) \<and> (clockA = 31) \<and> (clockB = 11) \<and> (invkcA = 0)
                    \<and> (invkcB = 0) \<and> (invkdpthA = 0) \<and> (invkdpthB = 0)"
     defines spectf: "sf E hp hh v p ==
                  (\<forall> L AC . impliesAssn (starLists L l AC acc)
                                        (ticks (constVE (IVal(clockA * (int L) + clockB)))
                                         && calls (constVE (IVal(callcA * (int L) + callcB)))
                                         && invokes (constVE (IVal(invkcA * (int L) + invkcB)))
                                         && depth (constVE (IVal(int (invkdpthA * L + invkdpthB))))
                                         && allocates (constVE (IVal 0))) E hp hh v p)"

lemma (in RevInplace) "\<rhd> (Call f) :: sf"
apply (rule vdm_call)
apply (rule vdm_conseq)
apply (simp only:funtf)
apply(rule vdm_basics)+(*, my_clarify1, my_simp2)+*)
apply (rule vdm_ax, simp)
apply (simp add: IMPLIES_def)
apply (simp add: tkCallAssn_def spectf)
apply (simp only: impliesAssn_def, safe)
apply (simp add: letiComb_def)
apply (simp only: condComb_def)
apply safe
apply (case_tac "ia = 1")
(*Case 1*)
apply clarsimp
apply (erule ANDelim)+
apply (simp add: starLists_def AND_def LLX_def)
apply (subgoal_tac "L=0", safe)
apply (simp add: tickClock ticks_def rescomp_cup_def constVE_def resdefs)
apply (simp add: tickCalls calls_def rescomp_cup_def constVE_def resdefs)
apply (simp add: tickInvks invokes_def rescomp_cup_def constVE_def resdefs)
apply (simp add: tickDepth depth_def rescomp_cup_def constVE_def resdefs)
apply (rule AllocTrans, erule tickAlloc)+
apply (rule AllocId, simp+)
apply (rule LocLengthElim1, assumption)
apply (simp only: ResultFieldAccess)
apply (erule ResultIop1)
(*case 2*)
apply clarsimp
apply (simp add: letiComb_def letrComb_def letvComb_def, safe)
apply (simp add: spectf impliesAssn_def)
(*apply (erule ANDelim)+*)
apply (simp only: starLists_def AND_def LLX_def, clarsimp)
apply (subgoal_tac "\<exists> LL. L = Suc LL", clarsimp)
prefer 2
  apply (subgoal_tac "ha<rc\<bullet>TAG> = i")
  apply (subgoal_tac "\<not> i < 1")
  apply (erule LocLengthDom3, simp)
  apply (erule ResultIop2)
  apply (erule ResultFieldAccess, assumption)
apply (erule LocLength.elims, simp_all, clarsimp)
apply (erule_tac x=ia in allE)
apply (erule impE, safe)
defer 1
(*ticks*)
(*apply (rule ClockTrans)+
apply (simp only: tickCosts_def costs_def)
apply (rule tickClock)*)
apply (simp add: tickClock ticks_def constVE_def rescomp_cup_def resdefs)
(*calls*)
apply (simp add: tickCalls calls_def constVE_def rescomp_cup_def resdefs)
(*invokes*)
apply (simp add: tickInvks invokes_def constVE_def rescomp_cup_def resdefs)
(*depth*)
apply (simp add: tickDepth depth_def constVE_def rescomp_cup_def resdefs)
(*allocates*)
apply (rule AllocTrans, erule tickAlloc)+
apply (erule AllocConst, fast+, arith)
(*last goal*)
apply (rule_tac x="Suc AC" in exI, rule_tac x="Xa-{la}" in exI,safe)
apply (rule_tac x=tt in exI, safe)
  (*an easier proof of this subgoal is
    apply (simp add: ResultIs_def constVE_def rvarVE_def rdotVE_def rvarVE_def HeapIs_def Same_def Iupd Rupd vardistinct)
   , but we aim at deriving lemmas\<dots>*)
  apply (subgoal_tac "r = rb", safe)
  apply (subgoal_tac "h1b\<lfloor>la\<diamondsuit>TL\<rfloor> = rb")
  apply (simp add: Same_getFR)
  apply (erule ResultRDot, simp add: vardistinct)
  apply (simp add: ResultIs_def rvarVE_def vardistinct Iupd Rupd)
apply (erule LocLengthSame)
  apply (rule same_trans, erule Same_same)+
  apply (rule same_trans,
         ((erule iUpd_same)+),
         simp add: vardistinct,
         fast)+
  apply (rule same_trans,
         ((erule rUpd_same)+),
         simp add: vardistinct,
         fast)+
  apply (rule same_trans, erule Same_same)+
  apply (rule same_id)
apply (rule_tac x="Y \<union> {la}" in exI, rule, rule_tac x="la" in exI )
apply rule
apply (subgoal_tac "E<tag:=i><b:=0><h:=ib>\<lfloor>t:=r\<rfloor><one:=ic>\<lfloor>l\<rfloor>=  ra")
apply (simp add: vardistinct Rupd)
apply (erule ResultRVar)

apply (rule CONS_LocL, simp_all)

apply (erule Same_NoClassChange)+
apply (erule rUpd_NoClassChange)+
apply (erule iUpd_NoClassChange)+
apply (erule Same_NoClassChange)+
apply (assumption)

apply (erule Same_getFI)+
apply (erule rUpd_getFI)
apply (erule iUpd_getFI1, simp add: vardistinct)
apply (erule iUpd_getFI4, simp add: vardistinct)
apply simp 
apply (erule ResultIConst)

apply (erule Same_getFR)+
apply (erule rUpd_getFR4, (simp add: vardistinct)+)

apply (erule LocLengthDom)

apply (erule LocLengthSame)
apply (rule same_trans, erule Same_same)+
apply (rule same_trans, ((erule iUpd_same)+), simp add: vardistinct, fast)+
apply (rule same_trans, ((erule rUpd_same)+), simp add: vardistinct, fast)+
apply (rule same_trans, erule Same_same)+
apply (rule same_id)

apply fast
done

lemma (in RevInplace) "\<rhd> (Call f) :: sf"
apply (rule vdm_call)
apply (rule vdm_conseq)
apply (simp only:funtf)
apply(rule vdm_basics)+(*, my_clarify1, my_simp2)+*)
apply (rule vdm_ax, simp)
apply (simp add: IMPLIES_def)
apply (simp add: tkCallAssn_def spectf)
apply (simp only: impliesAssn_def, safe)
apply (simp add: letiComb_def)
apply (simp only: condComb_def)
apply safe
apply (case_tac "ia = 1")
(*Case 1*)
apply clarsimp
apply (erule ANDelim)+
apply (simp add: starLists_def AND_def LLX_def)
apply (subgoal_tac "L=0", safe)
apply (simp add: tickClock ticks_def rescomp_cup_def constVE_def resdefs)
apply (simp add: tickCalls calls_def rescomp_cup_def constVE_def resdefs)
apply (simp add: tickInvks invokes_def rescomp_cup_def constVE_def resdefs)
apply (simp add: tickDepth depth_def rescomp_cup_def constVE_def resdefs)
apply (rule AllocTrans, erule tickAlloc)+
apply (rule AllocId, simp+)
apply (rule LocLengthElim1, assumption)
apply (simp only: ResultFieldAccess)
apply (erule ResultIop1)
(*case 2*)
apply clarsimp
oops

lemma "\<lbrakk>letiComb x (HeapIs Same && ResultIs (constVE (IVal i))) (letiComb y (HeapIs Same) R) E h hh v p\<rbrakk> 
      \<Longrightarrow> letiComb y (HeapIs Same) R (E<x:=i>) h hh v (tickRo  \<smile> p)"
apply (simp add: letiComb_def AND_def ResultIs_def constVE_def HeapIs_def Same_def, clarsimp)
apply (rule_tac x="tickRo \<smile> p1 \<smile> tickRo \<smile> p1a" in exI)
apply (rule_tac x="p2a" in exI)
apply rule
apply (rule_tac x="ia" in exI, simp)
apply (simp add: rescomp_cup_def)
apply arith
done

lemma "\<lbrakk>letiComb x P (letiComb y (HeapIs Same) R) E h hh v p; IMPLIES P (HeapIs Same && ResultIs (constVE (IVal i)))\<rbrakk> 
      \<Longrightarrow> letiComb y (HeapIs Same) R (E<x:=i>) h hh v (tickRo  \<smile> p)"
apply (simp add: IMPLIES_def letiComb_def AND_def ResultIs_def constVE_def HeapIs_def Same_def)
apply (erule exE)+
apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h1 in allE, erule_tac x="IVal ia" in allE)
apply (erule impE, clarify)
apply (rule, assumption)
apply clarify
apply (rule_tac x="tickRo \<smile> p1 \<smile> tickRo \<smile> p1a" in exI)
apply (rule_tac x="p2a" in exI)
apply rule
apply (rule_tac x="iaa" in exI, simp)
apply (simp add: rescomp_cup_def)
apply arith
done

lemma "\<lbrakk>letiComb x P (letiComb y Q R) E h hh v p; IMPLIES P (HeapIs Same && ResultIs (constVE (IVal i))); IMPLIES Q (HeapIs Same)\<rbrakk> 
      \<Longrightarrow> letiComb y (HeapIs Same) R (E<x:=i>) h hh v (tickRo  \<smile> p)"
apply (simp add: letiComb_def AND_def ResultIs_def constVE_def HeapIs_def Same_def)
apply (erule exE)+
apply clarify
apply (subgoal_tac "i=ia", clarify)
prefer 2 apply (simp add: IMPLIES_def)
         apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h1 in allE, 
                erule_tac x="IVal ia" in allE, erule_tac x="p1" in allE)
         apply (simp add: AND_def ResultIs_def constVE_def HeapIs_def Same_def)
apply (subgoal_tac "h=h1a", clarify)
prefer 2 apply (simp add: IMPLIES_def)
         apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h1 in allE, 
                erule_tac x="IVal i" in allE, erule_tac x="p1" in allE, simp)
         apply (erule_tac x="E<x:=i>" in allE, erule_tac x=h1 in allE, erule_tac x=h1a in allE, 
                erule_tac x="IVal ia" in allE, erule_tac x="p1a" in allE, simp)
         apply (simp add: AND_def ResultIs_def constVE_def HeapIs_def Same_def)
apply (rule_tac x="tickRo \<smile> p1 \<smile> tickRo \<smile> p1a" in exI)
apply (rule_tac x="p2a" in exI)
apply rule
apply (rule_tac x="iaa" in exI, simp)
apply (simp add: rescomp_cup_def)
apply arith
done

theorem LetiLetiHeapIs:
     "\<lbrakk>letiComb x P (letiComb y Q R) E h hh v p; IMPLIES P (HeapIs Same && ResultIs (constVE (IVal i))); IMPLIES Q (HeapIs he)\<rbrakk> 
      \<Longrightarrow> letiComb y (HeapIs he) R (E<x:=i>) h hh v (tickRo  \<smile> p)"
apply (simp add: letiComb_def AND_def ResultIs_def constVE_def HeapIs_def Same_def)
apply (erule exE)+
apply clarify
apply (subgoal_tac "i=ia", clarify)
prefer 2 apply (simp add: IMPLIES_def)
         apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h1 in allE, 
                erule_tac x="IVal ia" in allE, erule_tac x="p1" in allE)
         apply (simp add: AND_def ResultIs_def constVE_def HeapIs_def Same_def)
apply (subgoal_tac "h=h1", clarify)
prefer 2 apply (simp add: IMPLIES_def)
         apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h1 in allE, 
                erule_tac x="IVal i" in allE, erule_tac x="p1" in allE, simp)
         apply (simp add: AND_def ResultIs_def constVE_def HeapIs_def Same_def)
apply (rule_tac x="tickRo \<smile> p1 \<smile> tickRo \<smile> p1a" in exI,
       rule_tac x="p2a" in exI, 
       rule_tac x="h1a" in exI)
apply rule 
apply (simp add: IMPLIES_def,
       erule_tac x="E<x:=i>" in allE, erule_tac x=h in allE, erule_tac x=h1a in allE, 
                erule_tac x="IVal ia" in allE, erule_tac x="p1a" in allE, simp, simp add: HeapIs_def)
apply rule
apply (rule_tac x="iaa" in exI, simp)
apply (simp add: rescomp_cup_def, arith)
done

theorem LetiLetrHeapIs:
     "\<lbrakk>letiComb x P (letrComb y Q R) E h hh v p; IMPLIES P (HeapIs Same && ResultIs (constVE (IVal i))); IMPLIES Q (HeapIs he)\<rbrakk> 
      \<Longrightarrow> letrComb y (HeapIs he) R (E<x:=i>) h hh v (tickRo  \<smile> p)"
apply (simp add: letiComb_def letrComb_def AND_def ResultIs_def constVE_def HeapIs_def Same_def)
apply (erule exE)+
apply clarify
apply (subgoal_tac "i=ia", clarify)
prefer 2 apply (simp add: IMPLIES_def)
         apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h1 in allE, 
                erule_tac x="IVal ia" in allE, erule_tac x="p1" in allE)
         apply (simp add: AND_def ResultIs_def constVE_def HeapIs_def Same_def)
apply (subgoal_tac "h=h1", clarify)
prefer 2 apply (simp add: IMPLIES_def)
         apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h1 in allE, 
                erule_tac x="IVal i" in allE, erule_tac x="p1" in allE, simp)
         apply (simp add: AND_def ResultIs_def constVE_def HeapIs_def Same_def)
apply (rule_tac x="tickRo \<smile> p1 \<smile> tickRo \<smile> p1a" in exI,
       rule_tac x="p2a" in exI, 
       rule_tac x="h1a" in exI)
apply rule 
apply (simp add: IMPLIES_def,
       erule_tac x="E<x:=i>" in allE, erule_tac x=h in allE, erule_tac x=h1a in allE, 
                erule_tac x="RVal r" in allE, erule_tac x="p1a" in allE, simp, simp add: HeapIs_def)
apply rule
apply (rule_tac x="r" in exI, simp)
apply (simp add: rescomp_cup_def, arith)
done

theorem LetiLetvHeapIs:
     "\<lbrakk>letiComb x P (letvComb Q R) E h hh v p; IMPLIES P (HeapIs Same && ResultIs (constVE (IVal i))); IMPLIES Q (HeapIs he)\<rbrakk> 
      \<Longrightarrow> letvComb (HeapIs he) R (E<x:=i>) h hh v (tickRo \<smile> p)"
apply (simp add: letiComb_def letvComb_def AND_def ResultIs_def constVE_def HeapIs_def Same_def)
apply (erule exE)+
apply clarify
apply (subgoal_tac "i=ia", clarify)
prefer 2 apply (simp add: IMPLIES_def)
         apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h1 in allE, 
                erule_tac x="IVal ia" in allE, erule_tac x="p1" in allE)
         apply (simp add: AND_def ResultIs_def constVE_def HeapIs_def Same_def)
apply (subgoal_tac "h=h1", clarify)
prefer 2 apply (simp add: IMPLIES_def)
         apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h1 in allE, 
                erule_tac x="IVal i" in allE, erule_tac x="p1" in allE, simp)
         apply (simp add: AND_def ResultIs_def constVE_def HeapIs_def Same_def)
apply (rule_tac x="tickRo \<smile> p1 \<smile> tickRo \<smile> p1a" in exI,
       rule_tac x="p2a" in exI, 
       rule_tac x="h1a" in exI)
apply rule 
apply (simp add: IMPLIES_def,
       erule_tac x="E<x:=i>" in allE, erule_tac x=h in allE, erule_tac x=h1a in allE, 
                erule_tac x="w" in allE, erule_tac x="p1a" in allE, simp, simp add: HeapIs_def)
apply simp
apply (simp add: rescomp_cup_def, arith)
done

theorem LetrLetiHeapIs:
     "\<lbrakk>letrComb x P (letiComb y Q R) E h hh v p; IMPLIES P (HeapIs Same && ResultIs (constVE (RVal r))); IMPLIES Q (HeapIs he)\<rbrakk> 
      \<Longrightarrow> letiComb y (HeapIs he) R (E\<lfloor>x:=r\<rfloor>) h hh v (tickRo  \<smile> p)"
apply (simp add: letrComb_def letiComb_def AND_def ResultIs_def constVE_def HeapIs_def Same_def)
apply (erule exE)+
apply clarify
apply (subgoal_tac "r=ra", clarify)
prefer 2 apply (simp add: IMPLIES_def)
         apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h1 in allE, 
                erule_tac x="RVal ra" in allE, erule_tac x="p1" in allE)
         apply (simp add: AND_def ResultIs_def constVE_def HeapIs_def Same_def)
apply (subgoal_tac "h=h1", clarify)
prefer 2 apply (simp add: IMPLIES_def)
         apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h1 in allE, 
                erule_tac x="RVal r" in allE, erule_tac x="p1" in allE, simp)
         apply (simp add: AND_def ResultIs_def constVE_def HeapIs_def Same_def)
apply (rule_tac x="tickRo \<smile> p1 \<smile> tickRo \<smile> p1a" in exI,
       rule_tac x="p2a" in exI, 
       rule_tac x="h1a" in exI)
apply rule 
apply (simp add: IMPLIES_def)
          apply (erule thin_rl)
          apply(erule_tac x="E\<lfloor>x:=r\<rfloor>" in allE, erule_tac x=h in allE, erule_tac x=h1a in allE, 
                erule_tac x="IVal i" in allE, erule_tac x="p1a" in allE)
apply( simp, simp add: HeapIs_def)
apply rule
apply (rule_tac x="i" in exI, simp)
apply (simp add: rescomp_cup_def, arith)
done

theorem LetrLetrHeapIs:
     "\<lbrakk>letrComb x P (letrComb y Q R) E h hh v p; IMPLIES P (HeapIs Same && ResultIs (constVE (RVal r))); IMPLIES Q (HeapIs he)\<rbrakk> 
      \<Longrightarrow> letrComb y (HeapIs he) R (E\<lfloor>x:=r\<rfloor>) h hh v (tickRo  \<smile> p)"
apply (simp add: letrComb_def AND_def ResultIs_def constVE_def HeapIs_def Same_def)
apply (erule exE)+
apply clarify
apply (subgoal_tac "r=ra", clarify)
prefer 2 apply (simp add: IMPLIES_def)
         apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h1 in allE, 
                erule_tac x="RVal ra" in allE, erule_tac x="p1" in allE)
         apply (simp add: AND_def ResultIs_def constVE_def HeapIs_def Same_def)
apply (subgoal_tac "h=h1", clarify)
prefer 2 apply (simp add: IMPLIES_def)
         apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h1 in allE, 
                erule_tac x="RVal r" in allE, erule_tac x="p1" in allE, simp)
         apply (simp add: AND_def ResultIs_def constVE_def HeapIs_def Same_def)
apply (rule_tac x="tickRo \<smile> p1 \<smile> tickRo \<smile> p1a" in exI,
       rule_tac x="p2a" in exI, 
       rule_tac x="h1a" in exI)
apply rule 
apply (simp add: IMPLIES_def, erule thin_rl)
       apply( erule_tac x="E\<lfloor>x:=r\<rfloor>" in allE, erule_tac x=h in allE, erule_tac x=h1a in allE, 
                erule_tac x="RVal ra" in allE, erule_tac x="p1a" in allE, simp, simp add: HeapIs_def)
apply rule
apply (rule_tac x="raa" in exI, simp)
apply (simp add: rescomp_cup_def, arith)
done

theorem LetrLetvHeapIs:
     "\<lbrakk>letrComb x P (letvComb Q R) E h hh v p; IMPLIES P (HeapIs Same && ResultIs (constVE (RVal r))); IMPLIES Q (HeapIs he)\<rbrakk> 
      \<Longrightarrow> letvComb (HeapIs he) R (E\<lfloor>x:=r\<rfloor>) h hh v (tickRo \<smile> p)"
apply (simp add: letrComb_def letvComb_def AND_def ResultIs_def constVE_def HeapIs_def Same_def)
apply (erule exE)+
apply clarify
apply (subgoal_tac "r=ra", clarify)
prefer 2 apply (simp add: IMPLIES_def)
         apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h1 in allE, 
                erule_tac x="RVal ra" in allE, erule_tac x="p1" in allE)
         apply (simp add: AND_def ResultIs_def constVE_def HeapIs_def Same_def)
apply (subgoal_tac "h=h1", clarify)
prefer 2 apply (simp add: IMPLIES_def)
         apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h1 in allE, 
                erule_tac x="RVal r" in allE, erule_tac x="p1" in allE, simp)
         apply (simp add: AND_def ResultIs_def constVE_def HeapIs_def Same_def)
apply (rule_tac x="tickRo \<smile> p1 \<smile> tickRo \<smile> p1a" in exI,
       rule_tac x="p2a" in exI, 
       rule_tac x="h1a" in exI)
apply rule 
apply (simp add: IMPLIES_def, erule thin_rl,
       erule_tac x="E\<lfloor>x:=r\<rfloor>" in allE, erule_tac x=h in allE, erule_tac x=h1a in allE, 
                erule_tac x="w" in allE, erule_tac x="p1a" in allE, simp, simp add: HeapIs_def)
apply simp
apply (simp add: rescomp_cup_def, arith)
done

constdefs HEcomp::"heapExpr \<Rightarrow> heapExpr \<Rightarrow> heapExpr"
"HEcomp he1 he2 E h hh == (\<exists> h1 . he1 E h h1 \<and> he2 E h1 hh)"

lemma "HEcomp Same he = he"
by (rule, rule, rule, simp add: HEcomp_def Same_def)

lemma "HEcomp he Same = he"
by (rule, rule, rule, simp add: HEcomp_def Same_def)

theorem LetvLetvHeapIsComp:
     "\<lbrakk>letvComb P (letvComb Q R) E h hh v p; IMPLIES P (HeapIs he1); IMPLIES Q (HeapIs he2)\<rbrakk> 
      \<Longrightarrow> letvComb (HeapIs (HEcomp he1 he2)) R E h hh v p"
apply (simp add: letvComb_def, clarify)
apply (subgoal_tac "he1 E h h1")
apply (subgoal_tac "he2 E h1 h1a")
apply (rule_tac x="p1 \<smile> p1a" in exI, rule, rule, rule, rule)
prefer 2
apply (rule, assumption)
apply (simp add: rescomp_cup_def max_def)
apply (simp add: HeapIs_def HEcomp_def, fast)
apply (simp add: IMPLIES_def HeapIs_def, fast)+
done

theorem LetvLetiHeapIsComp:
     "\<lbrakk>letvComb P (letiComb x Q R) E h hh v p; IMPLIES P (HeapIs he1); IMPLIES Q (HeapIs he2)\<rbrakk> 
      \<Longrightarrow> letiComb x (HeapIs (HEcomp he1 he2)) R E h hh v p"
apply (simp add: letvComb_def letiComb_def, clarify)
apply (subgoal_tac "he1 E h h1")
apply (subgoal_tac "he2 E h1 h1a")
apply (rule_tac x="p1 \<smile> p1a" in exI, rule, rule, rule, rule)
prefer 2
apply (rule, assumption)
apply (simp add: rescomp_cup_def max_def)
apply (simp add: HeapIs_def HEcomp_def, fast)
apply (simp add: IMPLIES_def HeapIs_def, fast)+
done

theorem LetvLetrHeapIsComp:
     "\<lbrakk>letvComb P (letrComb x Q R) E h hh v p; IMPLIES P (HeapIs he1); IMPLIES Q (HeapIs he2)\<rbrakk> 
      \<Longrightarrow> letrComb x (HeapIs (HEcomp he1 he2)) R E h hh v p"
apply (simp add: letvComb_def letrComb_def, clarify)
apply (subgoal_tac "he1 E h h1")
apply (subgoal_tac "he2 E h1 h1a")
apply (rule_tac x="p1 \<smile> p1a" in exI, rule, rule, rule, rule)
prefer 2
apply (rule, assumption)
apply (simp add: rescomp_cup_def max_def)
apply (simp add: HeapIs_def HEcomp_def, fast)
apply (simp add: IMPLIES_def HeapIs_def, fast)+
done

theorem LetiLetvHeapIsComp:
     "\<lbrakk>letiComb x P (letvComb Q R) E h hh v p; IMPLIES P (HeapIs he1 && ResultIs (constVE (IVal i))); IMPLIES Q (HeapIs he2)\<rbrakk> 
      \<Longrightarrow> letvComb (HeapIs (HEcomp he1 he2)) R (E<x:=i>) h hh v (tickRo \<smile> p)"
(*does not hold!! becuase update to E is not carried out*)
oops

lemma triv:"\<lbrakk>v= renv E x ; w=renv E x\<rbrakk> \<Longrightarrow> v=w" by simp

lemma letiElimIDOT:
      "\<lbrakk>letiComb x P Q E h hh v p;
        IMPLIES P (HeapIs Same && ResultIs (idotVE (rvarVE y) F ) && costs 0 (clock p1) (callc p1) (invkc p1) (invkdpth p1)); 
        idotVE (rvarVE y) F E h (IVal i);
        \<forall> p2. Q (E<x:=i>) h hh v p2 \<longrightarrow> (tickRo \<smile> p1 \<smile> p2) = p \<longrightarrow> R\<rbrakk> \<Longrightarrow> R"
apply (simp add: letiComb_def, clarsimp)
apply (subgoal_tac "h=h1 \<and> i = ia \<and> p1=p1a", clarsimp)
apply (simp add: predicates, clarsimp)
apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h1 in allE,
         erule_tac x="IVal i" in allE)
apply (rotate_tac 1, erule_tac x=p1a in allE, simp)
apply auto
apply (subgoal_tac "Ref l = Ref la", clarify)
apply (erule triv, simp)
done

lemma GetFiElim:
      "\<lbrakk>letiComb x (HeapIs Same && ResultIs (idotVE (rvarVE y) F ) && tickCosts n) Q E h hh v p;
        (rvarVE y) E h (RVal (Ref l));
        \<forall> p2. Q (E<x:=(iheap h) F l>) h hh v p2 \<longrightarrow> (tkn (n + 1) p2) = p \<longrightarrow> R\<rbrakk> \<Longrightarrow> R"
apply (simp add: predicates, clarsimp)
apply (subgoal_tac "Ref l = Ref la", clarify)
apply (erule_tac x=p2 in allE, simp add: rescomp_cup_def)
apply (erule triv, simp)
done

lemma GetFiElim1:
      "\<lbrakk>letiComb x (HeapIs Same && ResultIs (idotVE (rvarVE y) F ) && tickCosts n) Q E h hh v p;
        idotVE (rvarVE y) F E h (IVal i);
        \<forall> p2. Q (E<x:=i>) h hh v p2 \<longrightarrow> (tkn (n + 1) p2) = p \<longrightarrow> R\<rbrakk> \<Longrightarrow> R"
apply (simp add: predicates, clarsimp)
apply (subgoal_tac "Ref l = Ref la", clarify)
apply (erule_tac x=p2 in allE, simp add: rescomp_cup_def)
apply (erule triv, simp)
done
lemma GetFiElim2:
      "\<lbrakk>letiComb x (HeapIs Same && ResultIs (idotVE (rvarVE y) F ) && tickCosts n) Q E h hh v p;
        idotVE (rvarVE y) F E h (IVal i);
        \<forall> p2. Q (E<x:=i>) h hh v p2  \<longrightarrow> R (tkn (n + 1) p2)\<rbrakk> \<Longrightarrow> R p"
apply (simp add: predicates, clarify)
apply (subgoal_tac "Ref l = Ref la", clarify)
apply (erule_tac x=p2 in allE, clarsimp, simp add: rescomp_cup_def, auto)
apply (subgoal_tac "(clock p1 + 1 + clock p2) = (1 + (clock p1 + clock p2))", auto)
done

(*
lemma letiElimIDOT3:
      "\<lbrakk>letiComb x (HeapIs Same && ResultIs (idotVE (rvarVE y) F ) && tickCosts n) Q E h hh v p;
        idotVE (rvarVE y) F E h (IVal i);
        Q (E<x:=i>) h hh v (tkn n p) \<Longrightarrow> R p\<rbrakk> \<Longrightarrow> R p"
apply (simp add: letiComb_def predicates, clarsimp)
apply (subgoal_tac "Ref l = Ref la", clarify, simp_all add: rescomp_cup_def)
apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h1 in allE,
         erule_tac x="IVal i" in allE)
apply (rotate_tac 1,erule_tac x=p1 in allE, simp, clarsimp)
apply (subgoal_tac "(\<forall> p. tkn (n+1) p = (tickRo \<smile> p1 \<smile> p))")
apply (erule_tac x=p2 in allE)
apply (subgoal_tac "Ref l = Ref la", clarify, simp_all add: rescomp_cup_def)
sorry
*)

lemma IopElim:
      "\<lbrakk>letiComb z (HeapIs Same && ResultIs (iopVE (ivarVE x) f (ivarVE y)) && tickCosts n) Q E h hh v p;
        (ivarVE x) E h (IVal i);
        (ivarVE y) E h (IVal j);
        \<forall> p2. Q (E<z:=f i j>) h hh v p2 \<longrightarrow> (tkn (n + 1) p2) = p \<longrightarrow> R\<rbrakk> \<Longrightarrow> R"
apply (simp add: predicates, clarsimp)
apply( erule_tac x=p2 in allE, simp add:rescomp_cup_def)
done

lemma letiElimCONST:
      "\<lbrakk>letiComb x P Q E h hh v p;
        IMPLIES P (HeapIs Same && ResultIs (constVE (IVal i)) && costs 0 (clock p1) (callc p1) (invkc p1) (invkdpth p1)); 
        \<forall> p2.  Q (E<x:=i>) h hh v p2 \<longrightarrow> (tickRo \<smile> p1 \<smile> p2) = p \<longrightarrow> R\<rbrakk> \<Longrightarrow> R"
apply (simp add: letiComb_def, clarsimp)
apply (subgoal_tac "h=h1 \<and> i = ia \<and> p1 = p1a", clarsimp)
apply (simp add: IMPLIES_def ResultIs_def constVE_def)
apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h1 in allE,
         erule_tac x="IVal ia" in allE, erule_tac x=p1a in allE, simp)
apply (simp add: predicates)
done

lemma IconstElim2:
      "\<lbrakk>letiComb x (HeapIs Same && ResultIs (constVE (IVal i)) && tickCosts n) Q E h hh v p;
        \<forall> p2.  Q (E<x:=i>) h hh v p2 \<longrightarrow> (tkn (n+1) p2) = p \<longrightarrow> R\<rbrakk> \<Longrightarrow> R"
by (simp add: predicates, clarsimp)

lemma IconstElim1:
      "\<lbrakk>letiComb x (HeapIs Same && ResultIs (constVE (IVal i)) && tickCosts n) Q E h hh v pp;
        !! p. Q (E<x:=i>) h hh v p \<Longrightarrow> pp = (tkn (n+1) p) \<Longrightarrow> R\<rbrakk> 
      \<Longrightarrow> R"
by (simp add: predicates, clarsimp)

lemma IconstElim3:
      "\<lbrakk>letiComb x (HeapIs Same && ResultIs (constVE (IVal i)) && tickCosts n) Q E h hh v pp;
        !! p . \<lbrakk>Q (E<x:=i>) h hh v p; pp = (tkn (n+1) p)\<rbrakk> \<Longrightarrow> R\<rbrakk> 
      \<Longrightarrow> R"
by (simp add: predicates, clarsimp)

lemma IconstElim:
      "\<lbrakk>letiComb x (HeapIs Same && ResultIs (constVE (IVal i)) && tickCosts n) Q E h hh v p;
        \<forall> p2.  Q (E<x:=i>) h hh v p2 \<longrightarrow> (tkn (n+1) p2) = p \<longrightarrow> R\<rbrakk> \<Longrightarrow> R"
apply (simp add: predicates, clarsimp)
apply( erule_tac x=p2 in allE, simp add:rescomp_cup_def)
done

lemma letrElim:
      "\<lbrakk>letrComb x P Q E h hh v p;
        IMPLIES P (HeapIs Same && ResultIs (rdotVE (rvarVE y) F ) && costs 0 (clock p1) (callc p1) (invkc p1) (invkdpth p1)); 
        rdotVE (rvarVE y) F E h (RVal r);
        \<forall> p2. Q (E\<lfloor>x:=r\<rfloor>) h hh v p2 \<longrightarrow> (tickRo \<smile> p1 \<smile> p2) = p \<longrightarrow> R\<rbrakk> \<Longrightarrow> R"
apply (simp add: letrComb_def, clarsimp)
apply (subgoal_tac "h=h1 \<and> r = ra \<and> p1=p1a", clarsimp)
apply (simp add: IMPLIES_def ResultIs_def rdotVE_def rvarVE_def, clarsimp)
apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h1 in allE,
         erule_tac x="RVal ra" in allE, erule_tac x=p1a in allE, simp)
apply (simp add: predicates)
apply auto
apply (subgoal_tac "Ref l = Ref la", clarify)
apply (erule triv, simp)
done

lemma GetFrElim:
      "\<lbrakk>letrComb x (HeapIs Same && ResultIs (rdotVE (rvarVE y) F ) && tickCosts n) Q E h hh v p;
        rdotVE (rvarVE y) F E h (RVal r);
        \<forall> p2. Q (E\<lfloor>x:=r\<rfloor>) h hh v p2 \<longrightarrow> (tkn (n + 1) p2) = p \<longrightarrow> R\<rbrakk> \<Longrightarrow> R"
apply (simp add: predicates, clarsimp)
apply (subgoal_tac "Ref l = Ref la", clarify)
apply (erule_tac x=p2 in allE, simp add: rescomp_cup_def)
apply (erule triv, simp)
done

lemma letrElimRVar:
      "\<lbrakk>letrComb x P Q E h hh v p;
        IMPLIES P (HeapIs Same && ResultIs (rvarVE y) && costs 0 (clock p1) (callc p1) (invkc p1) (invkdpth p1)); 
        (rvarVE y) E h (RVal r);
        \<forall> p2. Q (E\<lfloor>x:=r\<rfloor>) h hh v p2 \<longrightarrow> (tickRo \<smile> p1 \<smile> p2) = p \<longrightarrow> R\<rbrakk> \<Longrightarrow> R"
apply (simp add: letrComb_def, clarsimp)
apply (subgoal_tac "h=h1 \<and> r = ra \<and> p1=p1a", clarsimp)
apply (simp add: IMPLIES_def ResultIs_def rvarVE_def, clarsimp)
apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h1 in allE,
         erule_tac x="RVal r" in allE, erule_tac x=p1a in allE, simp)
apply (simp add: predicates)
done

lemma RVarElim:
      "\<lbrakk>letrComb x (HeapIs Same && ResultIs (rvarVE y) && tickCosts n) Q E h hh v p;
        (rvarVE y) E h (RVal r);
        \<forall> p2. Q (E\<lfloor>x:=r\<rfloor>) h hh v p2 \<longrightarrow> (tkn (n+1) p2) = p \<longrightarrow> R\<rbrakk> \<Longrightarrow> R"
apply (simp add: predicates, clarsimp)
apply (erule_tac x=p2 in allE, simp add:rescomp_cup_def)
done

lemma letvElimRupd:
      "\<lbrakk>letvComb P Q E h hh v p;
        IMPLIES P (HeapIs (rUpd Same (rvarVE x) F (rvarVE y)) && costs 0 (clock p1) (callc p1) (invkc p1) (invkdpth p1)); 
        (rvarVE x) E h (RVal (Ref a));
        \<forall> p2. Q E (h\<lfloor>a\<diamondsuit>F:=E\<lfloor>y\<rfloor>\<rfloor>) hh v p2 \<longrightarrow> (p1 \<smile> p2) = p \<longrightarrow> R\<rbrakk> \<Longrightarrow> R"
apply (simp add: letvComb_def, clarsimp)
apply (subgoal_tac "h1=h\<lfloor>a\<diamondsuit>F:=E\<lfloor>y\<rfloor>\<rfloor> \<and> p1=p1a", clarsimp)
apply (simp add: IMPLIES_def)
apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h1 in allE,
         erule_tac x=w in allE, erule_tac x=p1a in allE, simp)
apply (simp add: predicates)
apply auto
apply (subgoal_tac "Ref l = Ref a", clarify)
apply (erule triv, simp)
done

lemma PutFrElim:
      "\<lbrakk>letvComb (HeapIs (rUpd Same (rvarVE x) F (rvarVE y)) && ResultIs (constVE arbitrary) && tickCosts n) Q E h hh v p;
        E\<lfloor>x\<rfloor> = Ref a;
        \<forall> p2. Q E (h\<lfloor>a\<diamondsuit>F:=E\<lfloor>y\<rfloor>\<rfloor>) hh v p2 \<longrightarrow> (tkn n p2) = p \<longrightarrow> R\<rbrakk> \<Longrightarrow> R"
apply (simp add: predicates, clarsimp)
apply (erule_tac x=p2 in allE, simp add: rescomp_cup_def)
done

lemma letvElimIupd:
      "\<lbrakk>letvComb P Q E h hh v p;
        IMPLIES P (HeapIs (iUpd Same (rvarVE x) F (ivarVE y)) && costs 0 (clock p1) (callc p1) (invkc p1) (invkdpth p1)); 
        (rvarVE x) E h (RVal (Ref a));
        \<forall> p2. Q E (h<a\<bullet>F:=E<y>>) hh v p2 \<longrightarrow> (p1 \<smile> p2) = p \<longrightarrow> R\<rbrakk> \<Longrightarrow> R"
apply (simp add: letvComb_def, clarsimp)
apply (subgoal_tac "h1=h<a\<bullet>F:=E<y>> \<and> p1=p1a", clarsimp)
apply (simp add: IMPLIES_def)
apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h1 in allE,
         erule_tac x=w in allE, erule_tac x=p1a in allE, simp)
apply (simp add: predicates)
apply auto
apply (subgoal_tac "Ref l = Ref a", clarify)
apply (erule triv, simp)
done

lemma PutFiElim:
      "\<lbrakk>letvComb (HeapIs (iUpd Same (rvarVE x) F (ivarVE y)) && ResultIs (constVE arbitrary) && tickCosts n) Q E h hh v p;
        E\<lfloor>x\<rfloor> = Ref a;
        \<forall> p2. Q E (h<a\<bullet>F:=E<y>>) hh v p2 \<longrightarrow> (tkn n p2) = p \<longrightarrow> R\<rbrakk> \<Longrightarrow> R"
apply (simp add: predicates, clarsimp)
apply (erule_tac x=p2 in allE, simp add: rescomp_cup_def)
done

lemma IMPLIES_triv:"IMPLIES A A" by (simp add: IMPLIES_def AND_def)

lemma IMPLIES_Middle:"IMPLIES (A && B && C) (A && C)" by (simp add: IMPLIES_def AND_def)

lemma (in RevInplaceClock) "\<rhd> (Call f) :: sf"
apply (rule vdm_call)
apply (rule vdm_conseq)
apply (simp only:funtf)
apply(rule vdm_basics)+
apply (rule vdm_ax, simp)
apply (simp add: IMPLIES_def tkCallAssn_def spectf)
apply (simp only: impliesAssn_def, safe)
apply (case_tac "L=0", clarsimp)
(*case 1*)
apply (erule GetFiElim2,safe)
(*apply (erule GetFiElim1, safe) *)
  apply (simp add: starLists_def AND_def LLX_def, simp add: predicates, clarsimp)
  apply (erule LocLength.elims, simp_all)
apply (erule IopElim,safe) apply (simp add: predicates) apply (simp add: predicates)
apply (simp only: condComb_def, clarsimp)
apply (simp add: AND_def predicates resdefs rescomp_cup_def)
(*case 2*)
apply (erule GetFiElim1, safe) 
  apply (simp add: starLists_def AND_def LLX_def, simp add: predicates, clarsimp)
  apply (erule LocLength.elims, simp_all)
apply (erule IopElim, safe) apply (simp add: predicates) apply (simp add: predicates)
apply (simp only: condComb_def, clarsimp)
(* FIRST show that l.HD=i holds for some i!*)
  apply (simp add: starLists_def AND_def LLX_def, safe)
  apply (erule LocLength.elims, simp)
(*NOW apply the elim rule*)
apply (erule GetFiElim) apply (simp add:predicates)
apply safe
apply (erule GetFrElim, safe) apply (simp add:predicates)
apply (erule IconstElim, safe)
apply (erule PutFiElim, safe) apply (simp add: vardistinct Iupd Rupd)
apply (erule PutFiElim, safe) apply (simp add: vardistinct Iupd Rupd)
apply (erule PutFrElim, safe) apply (simp add: vardistinct Iupd Rupd)
apply (erule RVarElim, safe) apply (simp add: rvarVE_def vardistinct Iupd Rupd)
apply (erule RVarElim, safe) apply (simp add: rvarVE_def vardistinct Iupd Rupd) 
(*end of extended VCG*)
apply (simp add: spectf impliesAssn_def)
apply (erule_tac x=i in allE, erule impE)
prefer 2
  apply (simp add: tickClock ticks_def constVE_def rescomp_cup_def resdefs)
(*last goal*)
apply (rule_tac x="Suc AC" in exI, simp add: starLists_def AND_def LLX_def vardistinct)
apply (rule_tac x="Xa-{la}" in exI,safe)
apply (erule LocLengthSame)
apply (simp add: same_def)
apply (rule_tac x="Y \<union> {la}" in exI, rule, rule_tac x="la" in exI )
apply (simp add: vardistinct Rupd)
apply (rule CONS_LocL, simp_all)
apply (insert vardistinct, clarsimp)
apply (erule LocLengthDom)
apply (erule LocLengthSame, simp add: same_def)
apply fast
done

lemma StarRef: "starLists L l AC acc E h hh v p \<Longrightarrow> \<exists> r . E\<lfloor>l\<rfloor> = Ref r"
by (simp add: starLists_def AND_def LLX_def, clarsimp)

lemma CondElim:
      "\<lbrakk>condComb b P Q E h hh v p; 
        E<b>=grailbool True \<longrightarrow> (\<forall> p2. P E h hh v p2 \<longrightarrow> (tkn 2 p2) = p \<longrightarrow> R); 
        E<b>=grailbool False \<longrightarrow> (\<forall> p2. Q E h hh v p2 \<longrightarrow> (tkn 2 p2) = p \<longrightarrow> R)\<rbrakk> \<Longrightarrow> R"
by (simp add: predicates, auto)

lemma (in RevInplaceClock) "\<rhd> (Call f) :: sf"
apply (rule vdm_call, rule vdm_conseq)
apply (simp only:funtf)
apply(rule vdm_basics)+
apply (rule vdm_ax, simp)
apply (simp add: IMPLIES_def tkCallAssn_def spectf impliesAssn_def, safe)
apply (subgoal_tac "\<exists> r. E\<lfloor>l\<rfloor> = Ref r", clarsimp)
apply (erule GetFiElim, simp add: predicates, safe)
apply (erule IopElim, simp add: predicates, simp add: predicates, safe)
apply (erule CondElim)
apply clarsimp
apply (simp add: predicates resdefs rescomp_cup_def starLists_def LLX_def, safe)
apply (erule LocLengthElim1, assumption)
apply clarsimp
apply (erule GetFiElim, simp add: predicates, safe)
apply (erule GetFrElim, simp add:predicates, safe)
apply (erule IconstElim, safe)
apply (erule PutFiElim, simp add: vardistinct Iupd Rupd, safe)
apply (erule PutFiElim, simp add: vardistinct Iupd Rupd, safe)
apply (erule PutFrElim, simp add: vardistinct Iupd Rupd, safe)
apply (erule RVarElim, simp add: rvarVE_def vardistinct Iupd Rupd, safe)
apply (erule RVarElim, simp add: rvarVE_def vardistinct Iupd Rupd, safe) 
(*end of extended VCG*)
apply (simp add: spectf impliesAssn_def starLists_def AND_def LLX_def, safe)
apply (erule LocLength.elims, ((simp add: vardistinct)+))
apply (erule_tac x=i in allE, erule impE)
apply (rule_tac x="Suc AC" in exI, rule_tac x="Xa-{la}" in exI,safe)
apply (erule LocLengthSame)
apply (simp add: same_def)
apply (rule_tac x="Y \<union> {la}" in exI, rule, rule_tac x="la" in exI )
apply (simp add: vardistinct Rupd)
apply (rule CONS_LocL, simp_all)
apply (fastsimp intro: vardistinct)
apply (erule LocLengthDom)
apply (erule LocLengthSame, simp add: same_def)
apply fast
apply (simp add: predicates rescomp_cup_def resdefs)
apply (erule StarRef)
done

lemma (in RevInplace) "\<rhd> (Call f) :: sf"
apply (rule vdm_call, rule vdm_conseq)
apply (simp only:funtf)
apply(rule vdm_basics)+
apply (rule vdm_ax, simp)
apply (simp add: IMPLIES_def tkCallAssn_def spectf impliesAssn_def, safe)
apply (subgoal_tac "\<exists> r. E\<lfloor>l\<rfloor> = Ref r", clarsimp)
apply (erule GetFiElim, simp add: predicates, safe)
apply (erule IopElim, simp add: predicates, simp add: predicates, safe)
apply (erule CondElim)
apply clarsimp
apply (simp add: predicates resdefs rescomp_cup_def starLists_def LLX_def, safe)
apply (erule LocLengthElim1, assumption)
apply clarsimp
apply (erule GetFiElim, simp add: predicates, safe)
apply (erule GetFrElim, simp add:predicates, safe)
apply (erule IconstElim, safe)
apply (erule PutFiElim, simp add: vardistinct Iupd Rupd, safe)
apply (erule PutFiElim, simp add: vardistinct Iupd Rupd, safe)
apply (erule PutFrElim, simp add: vardistinct Iupd Rupd, safe)
apply (erule RVarElim, simp add: rvarVE_def vardistinct Iupd Rupd, safe)
apply (erule RVarElim, simp add: rvarVE_def vardistinct Iupd Rupd, safe) 
(*end of extended VCG*)
apply (simp add: spectf impliesAssn_def starLists_def AND_def LLX_def, clarsimp)
apply (erule LocLength.elims, ((simp add: vardistinct)+))
apply (erule_tac x=i in allE, erule impE)
apply (rule_tac x="Suc AC" in exI, rule_tac x="Xa-{la}" in exI,safe)
apply (erule LocLengthSame)
apply (simp add: same_def)
apply (rule_tac x="Y \<union> {la}" in exI, rule, rule_tac x="la" in exI )
apply (simp add: vardistinct Rupd)
apply (rule CONS_LocL, simp_all)
apply (fastsimp intro: vardistinct)
apply (erule LocLengthDom)
apply (erule LocLengthSame, simp add: same_def)
apply fast
apply (simp add: predicates rescomp_cup_def resdefs)+
apply (erule StarRef)
done
done
(*old version*)

locale RevInplace = 
  fixes    tag     :: iname    and	   h       :: iname    and	   b       ::iname   and one :: iname
    and    l       :: rname    and         acc     :: rname    and         t      :: rname  
    and	   f       :: funame   and callcA :: int and callcB :: int and clockA ::int and clockB :: int and invkcA :: int 
    and invkcB :: int and invkdpthA :: nat and invkdpthB :: nat and sf::vdmassn
 assumes  funtf:
          "funtable f == (LET tag = GetFi l TAG;
                                b = Primop (% x y. if x < 1 then 1 else 0) tag tag
                          IN IF b THEN RVar acc 
                             ELSE LET  h   = GetFi l HD;
                                    rf t   = GetFr l TL;
                                       one = expr.Int 1;
                                         _ = PutFi l TAG one; 
                                         _ = PutFi l HD h;
                                         _ = PutFr l TL acc;
                                    rf acc = RVar l;
                                    rf l   = RVar t 
                                 IN CALL f END
                         END)"
      and  vardistinct:     "tag \<noteq> h \<and> tag \<noteq> b \<and> tag \<noteq> one \<and> h \<noteq> b \<and> h \<noteq> one \<and> b \<noteq> one \<and> 
                             l \<noteq> acc \<and> l \<noteq> t \<and> acc \<noteq> t \<and> 
                             HD \<noteq> TAG"
      and resdefs: "(callcA = 1) \<and> (callcB = 1) \<and> (clockA = 31) \<and> (clockB = 11) \<and> (invkcA = 0)
                    \<and> (invkcB = 0) \<and> (invkdpthA = 0) \<and> (invkdpthB = 0)"
     defines spectf: "sf E hp hh v p == 
                  (\<forall> L AC . impliesAssn (star (LL L l) (LL AC acc))
                                        (ticks (constVE (IVal(clockA * (int L) + clockB)))
                                         && calls (constVE (IVal(callcA * (int L) + callcB)))
                                         && invokes (constVE (IVal(invkcA * (int L) + invkcB)))
                                         && depth (constVE (IVal(int (invkdpthA * L + invkdpthB))))
                                         && allocates (constVE (IVal 0))) E hp hh v p)"


method_setup my_simp1 =
  {* Method.no_args (Method.METHOD (fn facts => (asm_simp_tac  HOL_ss 1))) *}
  "package simp_tac into an Isar method."

method_setup my_simp2 =
  {* Method.no_args (Method.METHOD (fn facts => (asm_full_simp_tac  HOL_ss 1))) *}
  "package simp_tac into an Isar method."

method_setup my_clarify1 =
  {* Method.no_args (Method.METHOD (fn facts => (clarify_tac  HOL_cs 1))) *}
  "package simp_tac into an Isar method."

constdefs HeapMinus :: "heap \<Rightarrow> locn \<Rightarrow> heap"
"HeapMinus h l == h\<lparr>oheap := Abs_Finmap(\<lambda> ll. if ll = l then None else h@@ll)\<rparr>"

lemma HeapMinusDom:"Dom (HeapMinus h l) = (Dom h) - {l}"
sorry

constdefs HeapPlus:: "heap \<Rightarrow> locn \<Rightarrow> heap \<Rightarrow> heap"
"HeapPlus h l hh == \<lparr>oheap = Abs_Finmap(\<lambda> ll. if ll = l then hh@@ll else h@@ll),
                     iheap = \<lambda> F ll. if ll = l then hh<ll\<bullet>F> else h<ll\<bullet>F>,
                     rheap = \<lambda> F ll. if ll = l then hh\<lfloor>ll\<diamondsuit>F\<rfloor> else h\<lfloor>ll\<diamondsuit>F\<rfloor>\<rparr>"
lemma HeapPlusDom1:"\<lbrakk>l: Dom hh\<rbrakk> \<Longrightarrow> Dom (HeapPlus h l hh) = (Dom h) \<union> {l}"
apply (simp add: Dom_def fmap_dom_def HeapPlus_def dom_def, auto)
sorry
lemma HeapPlusDom2:"Dom (HeapPlus h l hh) \<subseteq> (Dom h) \<union> {l}"
apply (simp add: Dom_def fmap_dom_def HeapPlus_def dom_def, auto)
sorry

lemma MinusSame: "\<lbrakk>X \<subseteq> (Dom h) - {l}\<rbrakk>\<Longrightarrow> same X h (HeapMinus h l)"
apply (simp add: same_def themap_def HeapMinus_def fmap_lookup_def fmap_dom_def, clarsimp)
sorry
(*
lemma LookupDom: "fmap_lookup f l = Some C \<Longrightarrow> l : fmap_dom f"
by (simp add: fmap_dom_def dom_def fmap_lookup_def)
*)

lemma HeapSameNoEnv: "HeapIs Same E h hh v p \<Longrightarrow> h = hh"
by (simp add: HeapIs_def Same_def)

lemma SameMinus:"\<lbrakk>X \<subseteq> Dom h\<rbrakk> \<Longrightarrow> same (X - {l}) h (HeapMinus h l)"
apply (simp add: HeapMinus_def fmap_lookup_def themap_def same_def, auto)
sorry

lemma SumMinusPlus:"\<lbrakk>l : Dom h\<rbrakk> \<Longrightarrow> heapsum h hh = heapsum (HeapMinus h l) (HeapPlus hh l h)"
apply rule
prefer 2
apply (simp add: HeapMinus_def HeapPlus_def heapsum_def)
apply rule
apply rule
apply clarsimp
apply auto
apply (simp add: Dom_def fmap_dom_def)
sorry

lemma SumIHeap1:"xa : Dom hp \<Longrightarrow> (heapsum hp (h2 \<lparr>iheap := IH1, iheap := IH2, rheap := RH\<rparr>))<xa\<bullet>x> = hp<xa\<bullet>x>"
by (simp add: heapsum_def)

lemma SumIHeap2:"(heapsum hp h2 \<lparr>iheap := IH1, iheap := IH2, rheap := RH\<rparr>)<xa\<bullet>x> = IH2 x xa"
by (simp add: heapsum_def)

lemma CallsConst: "calls (constVE (IVal i)) E h h1 v p \<Longrightarrow> callc p = i"
by (simp add: calls_def constVE_def)

lemma InvokesConst: "invokes (constVE (IVal i)) E h h1 v p \<Longrightarrow> invkc p = i"
by (simp add: invokes_def constVE_def)

lemma DepthConst: "\<lbrakk>i = int n\<rbrakk> \<Longrightarrow> depth (constVE (IVal i)) E h h1 v p \<Longrightarrow> invkdpth p = n"
by (simp add: depth_def constVE_def)

lemma AllocatesConst: "allocates (constVE (IVal i)) E h h1 v p \<Longrightarrow> 
                       int (card (fmap_dom (oheap h1))) - int (card (fmap_dom (oheap h))) = i"
by (simp add: allocates_def constVE_def)

lemma AllocatesZeroConst: "allocates (constVE (IVal 0)) E h h1 v p \<Longrightarrow> 
                       card (fmap_dom (oheap h1)) = (card (fmap_dom (oheap h)))"
by (simp add: allocates_def constVE_def)

lemma ConstTicks: "clock p = i \<Longrightarrow> ticks (constVE (IVal i)) E h h1 v p"
by (simp add: ticks_def constVE_def)

lemma ConstArith2: "\<lbrakk>constVE (IVal (c + b)) E1 h1 (IVal i); a + b = d\<rbrakk> \<Longrightarrow> 
                    constVE (IVal (d + c)) E h (IVal (a + i))"
by (simp add: constVE_def)

lemma ConstArith3: "\<lbrakk>constVE (IVal a) E1 h1 (IVal i)\<rbrakk> \<Longrightarrow>
                    constVE (IVal a) E h (IVal i)"
by (simp add: constVE_def)

lemma ConstArith4: "constVE (IVal a) E1 h1 (IVal i) \<Longrightarrow> constVE (IVal a) E h (IVal i)"
by (simp add: constVE_def)

lemma rUpdlemma: "\<lbrakk> HeapIs (rUpd Same (rvarVE x) F (rvarVE y)) E h h1 w p; E\<lfloor>x\<rfloor> = Ref l; E\<lfloor>y\<rfloor>=v\<rbrakk> \<Longrightarrow> h1\<lfloor>l\<diamondsuit>F\<rfloor> = v"
by (simp add: HeapIs_def Same_def rvarVE_def rUpd_def)

lemma SameNotinDomain: "\<lbrakk>l \<notin> X\<rbrakk> \<Longrightarrow> same X h (HeapPlus h l h1)"
apply (simp add:same_def HeapPlus_def)
sorry

lemma SetUnionEmptyMono:"\<lbrakk>C \<inter> B = {}; A \<subseteq> C\<rbrakk> \<Longrightarrow> A \<inter> B = {}"
by fast

lemma (in RevInplace) "\<rhd> (Call f) :: sf"
apply (rule vdm_call)
apply (rule vdm_conseq)
apply (simp only:funtf)
apply(rule vdm_basics)+(*, my_clarify1, my_simp2)+*)
apply (rule vdm_ax, simp)
apply (simp add: IMPLIES_def)
apply (simp add: letiComb_def)
apply (simp only: condComb_def)
apply clarsimp
apply (case_tac "ia = 1")
(*Case 1*)
apply clarsimp
apply (simp add: tkCallAssn_def spectf)
apply (simp only: impliesAssn_def, clarsimp)
apply (erule ANDelim)+
apply (simp add: star_def LL_def, clarsimp)
apply (subgoal_tac "L=0")
apply (simp add: ResultIs_def idotVE_def rvarVE_def iopVE_def ivarVE_def constVE_def
                 cost_predicates tickCosts_def costs_def AND_def rescomp_cup_def , clarsimp)
apply (simp add: resdefs)
apply (rule LocLengthElim1, assumption)
apply (rule HeapsumTAG1)
apply (subgoal_tac "(heapsum h1b h2)<r\<bullet>TAG> = i")
apply (subgoal_tac "i < 1", fast)
apply (erule ResultIop1)
apply (erule ResultFieldAccess, assumption)
apply (erule LocLengthDom1)
(*case 2*)
apply clarsimp
apply (simp add: letiComb_def letrComb_def letvComb_def, safe)
apply (simp add: tkCallAssn_def spectf)
apply (simp only: impliesAssn_def, clarsimp)
apply (erule ANDelim)+
apply (simp add: star_def LL_def, clarsimp)
apply (subgoal_tac "\<exists> LL. L = Suc LL", clarsimp)
prefer 2
  apply (subgoal_tac "(heapsum h1j h2)<rc\<bullet>TAG> = i")
  apply (subgoal_tac "\<not> i < 1")
  apply (erule LocLength.elims, simp_all) apply (simp add: HeapsumIfld1 LookupDom)
  apply (erule ResultIop2)
  apply (erule ResultFieldAccess, assumption)
apply (erule LocLength.elims, simp_all)
apply (erule_tac x=ic in allE)
apply (erule impE)
prefer 2 apply (erule ANDelim)+
(*ticks*)
apply (rule ANDintro)
apply (simp add: cost_predicates, (erule ANDelim)+)
apply (simp add: TicksConst resdefs rescomp_cup_def) 
apply (erule ConstArith1, arith)
(*calls*)
apply (rule ANDintro)
apply (simp add: cost_predicates, (erule ANDelim)+)
apply (simp add: CallsConst resdefs rescomp_cup_def) 
apply (erule ConstArith2, arith)
(*invokes*)
apply (rule ANDintro)
apply (simp add: cost_predicates, (erule ANDelim)+)
apply (simp add: InvokesConst resdefs rescomp_cup_def) 
apply (erule ConstArith3)
(*depth*)
apply (rule ANDintro)
apply (simp add: cost_predicates, (erule ANDelim)+)
apply (subgoal_tac "0 = int 0") prefer 2 apply arith
apply (subgoal_tac "invkdpth p1 = 0 \<and> invkdpth p1a = 0 \<and> 
                    invkdpth p1b = 0 \<and> invkdpth p1c = 0 \<and> 
                    invkdpth p1d = 0 \<and> invkdpth p1e = 0 \<and> 
                    invkdpth p1f = 0 \<and> invkdpth p1g = 0 \<and> 
                    invkdpth p1h = 0 \<and> invkdpth p1i = 0 ") 
prefer 2 apply (simp add: DepthConst)
apply (simp add:resdefs rescomp_cup_def) 
apply (erule ConstArith4)
(*allocates*)
apply (simp add: cost_predicates, (erule ANDelim)+)
apply (simp add: AllocatesZeroConst resdefs rescomp_cup_def) 
apply (simp add: constVE_def) (*should be done by some lemmas*)
(*last goal*)
apply clarsimp
apply (subgoal_tac "Xb - {la} \<subseteq> Dom hp \<and> la : Dom hp", clarsimp)
prefer 2
  apply (simp add: LookupDom)
  apply (simp add: Dom_def, erule LocLengthElim4)
apply (subgoal_tac "Xa \<subseteq> Dom h2 \<and> Xb \<subseteq> Dom hp", clarsimp)
prefer 2
  apply (rule,simp add: Dom_def, erule LocLengthElim4, fast)
apply (subgoal_tac "Xa \<inter> Xb = {}")
prefer 2
  apply (fast)
apply (rule_tac x="Suc AC" in exI, rule_tac x="HeapMinus hp la" in exI, safe)
apply (rule_tac x="Xb - {la}" in exI, rule_tac x=tt in exI, safe)
apply (simp add: vardistinct ResultIs_def rvarVE_def Rupd Iupd)
defer 1
apply (rule LocLengthSame, assumption)
apply (erule SameMinus) 
apply (rule_tac x="HeapPlus h2 la h1g" in exI)
apply rule
apply (rule_tac x="Xa \<union> {la}" in exI)
apply (subgoal_tac "ra = Ref la", clarsimp)
prefer 2 apply (simp add: ResultIs_def vardistinct rvarVE_def) (*lemma*)
apply (rule_tac x="la" in exI, simp add: vardistinct Rupd)
apply (rule CONS_LocL)
defer 1 (*lemma*)
apply (simp add: HeapPlus_def)
apply (subgoal_tac "ib = 1") prefer 2 apply (simp add: ResultIs_def constVE_def vardistinct)
apply (simp add: HeapIs_def Same_def rUpd_def ivarVE_def rvarVE_def iUpd_def vardistinct, clarsimp)
apply (insert vardistinct, clarsimp)
apply (simp add: HeapPlus_def)
apply (simp add: HeapPlus_def)
apply (subgoal_tac "h1g\<lfloor>la\<diamondsuit>TL\<rfloor> = Ref rd", assumption)
apply (erule rUpdlemma, simp , simp)
apply fast
apply (subgoal_tac "rd: Xa", fast)
apply (erule LocLengthDom)
apply (subgoal_tac "insert la Xa - {la} = Xa", clarsimp) prefer 2 defer 1
apply (erule LocLengthSame)
apply (rule SameNotinDomain)
apply fast
apply (simp add: HeapMinusDom)
apply (subgoal_tac "la: Dom h1g", rule)
apply (simp add: HeapPlusDom1)
apply (erule SetUnionEmptyMono)
apply fast

prefer 3 apply clarsimp
continue here
apply (subgoal_tac "Dom hp - {la} \<subseteq> Dom hp", fast)
apply (simp add: HeapIs_def Same_def rUpd_def vardistinct, clarsimp)
apply (rule_tac x="HeapPlus h2 la (heapsum hp h2
                   (| iheap := (iheap (heapsum hp h2))(TAG := (iheap (heapsum hp h2) TAG)(laa := id)),
                      iheap := (iheap (heapsum hp h2))
                        (TAG := (iheap (heapsum hp h2) TAG)(laa := id), HD := (iheap (heapsum hp h2) HD)(lb := ie)),
                      rheap := (rheap (heapsum hp h2))(TL := (rheap (heapsum hp h2) TL)(lc := rc)) |))" in exI, safe)
prefer 2
  apply (simp add:HeapMinusDom)
  apply (subgoal_tac "x : Dom h2 \<union> {la}", fast)
  apply (subgoal_tac "Dom (HeapPlus h2 la
                    (h2\<lparr>iheap := (iheap (heapsum hp h2))(TAG := (iheap (heapsum hp h2) TAG)(la := 1)),
                          iheap := (iheap (heapsum hp h2))
                            (TAG := (iheap (heapsum hp h2) TAG)(la := 1), HD := iheap (heapsum hp h2) HD),
                          rheap := (rheap (heapsum hp h2))(TL := (rheap (heapsum hp h2) TL)(la := Ref rd))\<rparr>)) \<subseteq> Dom h2 \<union> {la}", fast)
  apply (rule HeapPlusDom2) 
prefer 2
  apply rule
  prefer 2 apply (rule, rule)
           apply (case_tac "xa : Dom hp")
           apply (simp add: SumIHeap1, safe)
           apply clarsimp
           apply (simp add:heapsum_def HeapMinus_def HeapPlus_def)
           apply (simp add:heapsum_def HeapMinus_def HeapPlus_def)
           apply (simp add:heapsum_def HeapMinus_def HeapPlus_def)
           apply (simp add:heapsum_def HeapMinus_def HeapPlus_def)
           apply (simp add:heapsum_def HeapMinus_def HeapPlus_def)
           apply (simp add: Dom_def fmap_dom_def)
done
heapsum h hh\<lparr>\<rparr> =
heapsum (HeapMinus h l)
           (HeapPlus hh l
             (hh\<lparr>\<rparr>))
apply (case_tac "x = la", clarsimp)
  apply (simp add: fmap_dom_def HeapMinus_def)
apply (rule_tac x=Xb in exI)
apply (rule  CONS_LocL)
defer 1
apply (simp add: HeapPlus_def, clarsimp)
apply (simp add: HeapPlus_def)
apply (simp add: HeapPlus_def)
apply simp



apply (subgoal_tac "Xa \<inter> Xb = {} \<and> Xa \<subseteq> fmap_dom (objhp h2) \<and> Xb \<subseteq> fmap_dom (objhp hp) ", clarsimp)
prefer 2
  apply (subgoal_tac "Xa \<subseteq> fmap_dom (objhp h2) \<and> Xb \<subseteq> fmap_dom (objhp hp) ", clarsimp, fast)
  apply (simp add: LocLengthElim4)
  apply (subgoal_tac "Xb - {la} \<subseteq> fmap_dom (objhp hp) ")
  apply (subgoal_tac "la : fmap_dom (objhp hp)", fast)
  apply (erule LookupDom)
  apply (simp add: LocLengthElim4)
(*apply (simp add: HeapsumIfld2 ResultIs_def idotVE_def rdotVE_def constVE_def rvarVE_def iopVE_def ivarVE_def constVE_def iUpd_def Same_def
                 cost_predicates tickCosts_def costs_def AND_def rescomp_cup_def , clarsimp)*)
apply (erule_tac x=ic in allE)
apply (erule impE)
(*prefer 2 apply clarsimp*)
apply (rule_tac x="Suc AC" in exI)
apply (rule_tac x="HeapMinus hp la" in exI, rule) 
apply (rule, rule, rule) prefer 2 
apply (rule LocLengthSame, assumption)
apply (simp add: same_def, clarsimp)
apply (simp add: HeapMinus_def fmap_lookup_def themap_def)
defer 1
apply (simp add: HeapsumIfld2 ResultIs_def idotVE_def rdotVE_def constVE_def rvarVE_def iopVE_def ivarVE_def constVE_def iUpd_def Same_def
                 cost_predicates tickCosts_def costs_def AND_def rescomp_cup_def , clarsimp)
apply (insert vardistinct, clarsimp)
apply (simp add: Rupd heapsum_def)
apply (subgoal_tac "la \<in> fmap_dom (oheap hp)", clarsimp,erule LookupDom)
apply (simp add: HeapsumIfld2 ResultIs_def idotVE_def rdotVE_def constVE_def rvarVE_def iopVE_def ivarVE_def constVE_def iUpd_def Same_def
                 cost_predicates tickCosts_def costs_def AND_def rescomp_cup_def , clarsimp)
apply (rule_tac x="HeapPlus (h2
             \<lparr>iheap := (iheap (heapsum hp h2))(TAG := (iheap (heapsum hp h2) TAG)(la := 1)),
                iheap := (iheap (heapsum hp h2))(TAG := (iheap (heapsum hp h2) TAG)(la := 1), HD := iheap (heapsum hp h2) HD),
                rheap := (rheap (heapsum hp h2))(TL := (rheap (heapsum hp h2) TL)(la := Ref rd))\<rparr>)
           la (heapsum hp h2
             \<lparr>iheap := (iheap (heapsum hp h2))(TAG := (iheap (heapsum hp h2) TAG)(la := 1)),
                iheap := (iheap (heapsum hp h2))(TAG := (iheap (heapsum hp h2) TAG)(la := 1), HD := iheap (heapsum hp h2) HD),
                rheap := (rheap (heapsum hp h2))(TL := (rheap (heapsum hp h2) TL)(la := Ref rd))\<rparr>)" in exI)
apply rule
apply (rule_tac x="Xa \<union> {la}" in exI, rule_tac x=la in exI, clarsimp)
apply (simp add: Rupd rUpd_def Same_def rvarVE_def)
apply (rule  CONS_LocL, simp_all)
apply (simp add: fmap_lookup_def)
defer 1
apply (simp add: HeapPlus_def, clarsimp)
apply (simp add: HeapPlus_def, clarsimp)
apply (subgoal_tac "rd : Xa", simp, fast)
apply (erule LocLengthDom)
apply (rule LocLengthSame)
apply (subgoal_tac "Xa - {la} = Xa", clarify, assumption)
apply fast
apply (simp add: same_def, clarsimp)
apply (rule)
apply (simp add: HeapPlus_def fmap_lookup_def) defer 1
apply safe
apply (simp add: HeapPlus_def, safe)
apply (rule HeapsumIfld2, simp)
apply fast
apply simp
apply (rule HeapsumIfld2, simp)
apply fast
apply fast
apply (rule HeapsumIfld2, simp)
apply fast
apply fast
apply (rule HeapsumIfld2, simp)
apply fast
apply fast
apply (simp add: HeapPlus_def, safe)
apply (rule HeapsumRfld2, simp)
apply fast
apply fast
apply (rule HeapsumRfld2, simp)
apply fast
apply fast
apply (simp add: HeapMinus_def HeapPlus_def fmap_dom_def fmap_lookup_def dom_def themap_def, clarsimp)
defer 1
apply rule
prefer 2 
apply (simp add: heapsum_def HeapMinus_def HeapPlus_def, rule, rule)
apply (erule LocLengthDom)
apply (rule Conc
apply (rule LocLengthSame, fast)
apply (rule MinusSame)
apply (subgoal_tac "Xb - {la} \<subseteq> fmap_dom (oheap hp)", fast)
apply (erule LocLengthElim4)
apply (rule_tac x="HeapPlus h2 la hp" in exI, rule)
apply (rule_tac x="Xa \<union> {la}" in exI, rule_tac x="la" in exI, simp add: Rupd)
apply (rule  CONS_LocL, simp_all)
defer 1 (*lemma: "fmap_lookup (oheap hp) la = Some LST \<Longrightarrow> fmap_lookup (oheap (HeapPlus h2 la hp)) la = Some LST"*)
apply (simp add: HeapPlus_def)
apply (simp only: HeapPlus_def)
prefer 3
apply (subgoal_tac "Xa - {la} = Xa") 
apply clarsimp
apply (erule LocLengthSame)
defer 1
defer 1
apply (simp add: iUpd_def Same_def rvarVE_def ivarVE_def heapsum_def Rupd Iupd)
apply(rule_tac x="_/'(_/\<mapsto>\<^sub>f/_')" in exI)
apply (rule HeapsumTAG1, assumption)
apply (erule LocLengthElim3)
defer 1
apply (simp add:constVE_def ticks_def resdefs rescomp_cup_def tickCosts_def costs_def)
apply (simp add: impliesAssn_def AND_def) (*should be some assnpredicates*)
apply clarsimp
apply (subgoal_tac "L=0")
apply (simp add: cost_predicates constVE_def tickCosts_def costs_def AND_def rescomp_cup_def resdefs)
apply (simp add: valExpr_predicates iopVE_def, clarsimp) (*iopVE_def should be in valExpr_predicates*)
apply (simp add: star_def LL_def, clarsimp)
apply (erule LocLengthElim1)
defer 1 (*property of star. use (erule LocLengthSame) etc*) 
(*Case 2*)
apply clarsimp
apply (simp add: Same_def, clarsimp)
apply (simp add: spectf)
apply clarsimp
apply (simp add: impliesAssn_def AND_def) (*should be some assnpredicates*)
apply clarsimp
apply (subgoal_tac "\<exists> LL . L = Suc LL", clarsimp)
apply (erule_tac x=LLa in allE, erule impE)
apply (rule_tac x="Suc AC" in exI) 
apply (simp add: star_def, clarsimp) defer 1 (*property of star, needs heap instantiation*)
apply (simp add: cost_predicates constVE_def tickCosts_def costs_def AND_def rescomp_cup_def resdefs)
(*apply (simp add: valExpr_predicates iopVE_def, clarsimp) *) (*iopVE_def should be in valExpr_predicates*)
apply (simp add: star_def LL_def, clarsimp)
apply (subgoal_tac "(L, rc, X, h1d) \<in> LocLength")
apply (rotate_tac -1)
apply (erule LocLength.elims)
apply (simp add: valExpr_predicates iopVE_def)
apply fast
(*property of split*)
(*some of the goals will need insert vardistinct*)
oops
end
