(*  Examples from List.cmlt -> Grail*)

theory ExampleListReverseInplace =  ListClassAM:
(* List reversal:
Camelot:
let rev' l acc = 
  match l with Nil@d => acc 
             | Cons (h, t)@d => rev' t (Cons (h, acc)@d )

Grail:   
class ListRevInPlace {
   method public static ListRevInPlace$dia_0 rev' (ListRevInPlace$dia_0 l,
ListRevInPlace$dia_0 acc) =
   let

      fun f:rev'(ListRevInPlace$dia_0 l, ListRevInPlace$dia_0 d,
ListRevInPlace$dia_0 ?t0, ListRevInPlace$dia_0 d#0, int h, ListRevInPlace$dia_0
t, ListRevInPlace$dia_0 acc, ListRevInPlace$dia_0 l) =
      let
         val tag = getfield l <int ListRevInPlace$dia_0.$>
      in
         if tag = 0
         then f:0(l, d, ?t0, d#0, h, t, acc, l)
         else f:1(l, d, ?t0, d#0, h, t, acc, l)
      end

      fun f:1(ListRevInPlace$dia_0 l, ListRevInPlace$dia_0 d,
ListRevInPlace$dia_0 ?t0, ListRevInPlace$dia_0 d#0, int h, ListRevInPlace$dia_0
t, ListRevInPlace$dia_0 acc, ListRevInPlace$dia_0 l) =
      let
         val h = getfield l <int ListRevInPlace$dia_0.f0>
         val t = getfield l <ListRevInPlace$dia_0
ListRevInPlace$dia_0.f1>
         val d#0 = l
         val ?t0 = invokestatic <ListRevInPlace$dia_0
ListRevInPlace$dia_0.fill (ListRevInPlace$dia_0, int, int,
ListRevInPlace$dia_0)> (d#0, 1, h, acc)
      in
         invokestatic <ListRevInPlace$dia_0 ListRevInPlace.rev'
(ListRevInPlace$dia_0, ListRevInPlace$dia_0)> (t, ?t0)
      end

      fun f:0(ListRevInPlace$dia_0 l, ListRevInPlace$dia_0 d,
ListRevInPlace$dia_0 ?t0, ListRevInPlace$dia_0 d#0, int h, ListRevInPlace$dia_0
t, ListRevInPlace$dia_0 acc, ListRevInPlace$dia_0 l) =
      let
         val d = l
      in
         acc
      end
   in
      f:rev'(l, d, ?t0, d#0, h, t, acc, l)
   end
}

ToyGrail:
class ListRevInPlace {
   method public static List rev' (List l, List acc) =
   let fun f(List l, List acc) =
        let  tag = getfield l TAG
        in if tag = 0
           then acc
           else let  h = getfield l HD
                     t = getfield l TL
                     one = 1
                     () = putfield l TAG one
                     () = putfield l HD h
                     () = putfield l TL acc
                     acc = l
                     l = t
                in f(l,acc)
                end
   in
      f(l, acc)
   end
}
*)


declare rescomp_plus_def [simp del]
declare rescomp_cup_def [simp del]

lemma SetAux[simp]: "\<lbrakk>X \<inter> Y = {}; x:X\<rbrakk> \<Longrightarrow> \<not> x:Y"
by fast

lemma clockRC: "clock (mkRescomp a b c d) = a"
by simp

lemma callcRC: "callc (mkRescomp a b c d) = b"
by simp

lemma invkcRC: "invkc (mkRescomp a b c d) = c"
by simp

lemma invkdpthRC: "invkdpth (mkRescomp a b c d) = d"
by simp

locale RevInplace = 
  fixes    tag     :: iname    and	   h       :: iname    and	   b       ::
iname   and one :: iname
    and    l       :: rname    and         acc     :: rname    and         t    
  :: rname  
    and	   f       :: funame   and callcA :: int and callcB :: int and clockA ::
int and clockB :: int and invkcA :: int 
    and invkcB :: int and invkdpthA :: nat and invkdpthB :: nat and sf::
vdmassn
 assumes  funtf:
          "funtable f == (LET tag = GetFi l TAG;
                                b = Primop (% x y. if x < 1 then 1 else 0)
tag tag
                          IN IF b THEN RVar acc 
                             ELSE LET  h   = GetFi l HD;
                                    rf t   = GetFr l TL;
                                       one = expr.Int 1;
                                         _ = PutFi l TAG one; 
                                         _ = PutFi l HD h;
                                         _ = PutFr l TL acc;
                                    rf acc = RVar l;
                                    rf l   = RVar t 
                                 IN CALL f END
                         END)"
      and  vardistinct:     "tag \<noteq> h \<and> tag \<noteq> b \<and> tag \<noteq> one \<and> h \<noteq> b \<and> h \<noteq> one \<and> b \<noteq> one \<and> 
                             l \<noteq> acc \<and> l \<noteq> t \<and> acc \<noteq> t \<and> 
                             HD \<noteq> TAG"
      and  vardistinct1:     "distinct [tag,h,b,one] \<and> 
                             distinct[l,acc,t] \<and> 
                             distinct[HD,TAG]"
      and resdefs: "(callcA = 1) \<and> (callcB = 1) \<and> (clockA = 31) \<and> (clockB = 11) \<and> (invkcA = 0)
                    \<and> (invkcB = 0) \<and> (invkdpthA = 0) \<and> (invkdpthB = 0)"
     defines spectf: "sf == (% E h hh v p . 
           (\<forall> L X rl AC Y racc. ((E\<lfloor>l\<rfloor>
= Ref rl \<and> (L,rl,X,h) \<in> LocLength \<and>
                                  E\<lfloor>acc\<rfloor> = Ref racc
\<and> (AC,racc,Y,h) \<in> LocLength \<and> X \<inter> Y
= {}) \<longrightarrow> 
                                 (HSize h = HSize hh \<and> 
                                  p = \<langle> (clockA * (int L) +
clockB) (callcA * (int L) + callcB) (invkcA * (int L) + invkcB) (invkdpthA * L +
invkdpthB)\<rangle>))))"

lemmas vdm_basics = vdm_null vdm_int vdm_ivar vdm_rvar vdm_prim vdm_rprim
vdm_getfi vdm_getfr vdm_putfi vdm_putfr vdm_new vdm_if vdm_leti vdm_letr
vdm_letv 
lemmas vdm_calls = vdm_call vdm_mhinvokestatic vdm_mhinvoke
 
method_setup my_simp1 =
  {* Method.no_args (Method.METHOD (fn facts => (asm_simp_tac  HOL_ss 1))) *}
  "package simp_tac into an Isar method."

method_setup my_simp2 =
  {* Method.no_args (Method.METHOD (fn facts => (asm_full_simp_tac  HOL_ss 1))) *}
  "package simp_tac into an Isar method."

method_setup my_clarify1 =
  {* Method.no_args (Method.METHOD (fn facts => (clarify_tac  HOL_cs 1))) *}
  "package simp_tac into an Isar method."

lemma Iupd: "\<lbrakk>x \<noteq> y\<rbrakk> \<Longrightarrow> ienv E<x:=v> y = E<y>"
by (insert ivarupdate_def, fastsimp)

lemma Rupd: "\<lbrakk>x \<noteq> y\<rbrakk> \<Longrightarrow> renv E\<lfloor>x:=v\<rfloor> y = E\<lfloor>y\<rfloor>"
by (insert rvarupdate_def, fastsimp)

lemma IRupd: "renv E<x:=v> y = E\<lfloor>y\<rfloor>"
by (insert ivarupdate_def, fastsimp)

lemma RIupd: "ienv E\<lfloor>x:=v\<rfloor> y = E<y>"
by (insert rvarupdate_def, fastsimp)

lemma (in RevInplace) "\<rhd> (Call f) : sf"

apply (rule vdm_call)
apply (rule vdm_conseq)
apply (simp only:funtf)
apply(rule vdm_basics, my_clarify1, my_simp2)+
apply (rule vdm_ax, simp)
apply clarify
apply (simp (no_asm_use))
apply (case_tac "ha<a\<bullet>TAG> < 1") 
(*Case 1*)
apply(drule mp, assumption)
apply my_clarify1
apply (my_simp2)
apply (simp only:spectf resdefs clockRC callcRC invkcRC invkdpthRC rescomp_plus_def rescomp_cup_def)
apply (fastsimp dest:LocLengthElim1)
(*Case 2*)
apply (rotate_tac 1)
apply (erule thin_rl)
apply (drule mp, assumption)
apply ((erule exE)+, (erule conjE)+)+
apply my_clarify1
apply (insert vardistinct)
apply my_simp1
apply (simp only:spectf resdefs clockRC callcRC invkcRC invkdpthRC rescomp_plus_def rescomp_cup_def)
apply clarify
apply (simp only: ivarupdate_def rvarupdate_def)
apply clarify
apply (simp (no_asm) add: max_def)
apply clarify
apply (simp only: ifldupdate_def)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply my_clarify1

apply my_simp1
apply (erule ssubst, simp only: mkRescomp_def)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (erule ssubst)
apply (simp (no_asm_use))

  apply clarsimp
  apply (erule LocLength.elims, simp_all, clarsimp)
  apply (erule_tac x="i" in allE)
  apply (erule impE)
  apply (rule exI)
  apply rule
  apply (erule LocLengthSame)
  apply (simp add: same_def)
  apply (rule_tac x="Suc AC" in exI, rule_tac x="Y \<union>
{la}" in exI, rule)
  apply (erule LocLengthSuc, fastsimp+)

apply (insert vardistinct)

done
end
