(*  Examples from List.cmlt -> Grail*)

theory RRev = ListClass:
(* List reversal:
Camelot:
let rev' l acc = 
  match l with Nil@d => acc 
             | Cons (h, t)@d => rev' t (Cons (h, acc)@d )

Grail:   
class ListRevInPlace {
   method public static ListRevInPlace$dia_0 rev' (ListRevInPlace$dia_0 l, ListRevInPlace$dia_0 acc) =
   let

      fun f:rev'(ListRevInPlace$dia_0 l, ListRevInPlace$dia_0 d, ListRevInPlace$dia_0 ?t0, ListRevInPlace$dia_0 d#0, int h, ListRevInPlace$dia_0 t, ListRevInPlace$dia_0 acc, ListRevInPlace$dia_0 l) =
      let
         val tag = getfield l <int ListRevInPlace$dia_0.$>
      in
         if tag = 0
         then f:0(l, d, ?t0, d#0, h, t, acc, l)
         else f:1(l, d, ?t0, d#0, h, t, acc, l)
      end

      fun f:1(ListRevInPlace$dia_0 l, ListRevInPlace$dia_0 d, ListRevInPlace$dia_0 ?t0, ListRevInPlace$dia_0 d#0, int h, ListRevInPlace$dia_0 t, ListRevInPlace$dia_0 acc, ListRevInPlace$dia_0 l) =
      let
         val h = getfield l <int ListRevInPlace$dia_0.f0>
         val t = getfield l <ListRevInPlace$dia_0 ListRevInPlace$dia_0.f1>
         val d#0 = l
         val ?t0 = invokestatic <ListRevInPlace$dia_0 ListRevInPlace$dia_0.fill (ListRevInPlace$dia_0, int, int, ListRevInPlace$dia_0)> (d#0, 1, h, acc)
      in
         invokestatic <ListRevInPlace$dia_0 ListRevInPlace.rev' (ListRevInPlace$dia_0, ListRevInPlace$dia_0)> (t, ?t0)
      end

      fun f:0(ListRevInPlace$dia_0 l, ListRevInPlace$dia_0 d, ListRevInPlace$dia_0 ?t0, ListRevInPlace$dia_0 d#0, int h, ListRevInPlace$dia_0 t, ListRevInPlace$dia_0 acc, ListRevInPlace$dia_0 l) =
      let
         val d = l
      in
         acc
      end
   in
      f:rev'(l, d, ?t0, d#0, h, t, acc, l)
   end
}

ToyGrail:
class ListRevInPlace {
   method public static List rev' (List l, List acc) =
   let fun f(List l, List acc) =
        let  tag = getfield l TAG
        in if tag = 0
           then acc
           else let  h = getfield l HD
                     t = getfield l TL
                     one = 1
                     () = putfield l TAG one
                     () = putfield l HD h
                     () = putfield l TL acc
                     acc = l
                     l = t
                in f(l,acc)
                end
   in
      f(l, acc)
   end
}
*)


declare update_lemmas[simp]

locale RevInplace = 
  fixes    tag     :: iname    and	   h       :: iname    and	   b       :: iname   and one :: iname
    and    l       :: rname    and         acc     :: rname    and         t       :: rname  
    and	   f       :: funame   and callcA :: nat and callcB :: nat and clockA :: nat and clockB :: nat and invkcA :: nat 
    and invkcB :: nat and invkdpthA :: nat and invkdpthB :: nat and specf :: vdmassn
 assumes  funtf[simp]:
          "funtable f == LET tag = GetFi l TAG;
                               b = Primop (% x y. if x < 1 then 1 else 0) tag tag
                          IN IF b THEN RVar acc 
                             ELSE LET  h   = GetFi l HD;
                                    rf t   = GetFr l TL;
                                       one = expr.Int 1;
                                         _ = PutFi l TAG one; 
                                         _ = PutFi l HD h;
                                         _ = PutFr l TL acc;
                                    rf acc = RVar l;
                                    rf l   = RVar t 
                                 IN CALL f END
                         END"
     and sf[simp]: "specf = {(E,h,hh,v,p) . 
           (\<forall> L X rl AC Y racc. ((E\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> LocLength \<and>
                                  E\<lfloor>acc\<rfloor> = Ref racc \<and> (AC,racc,Y,h) \<in> LocLength \<and> X \<inter> Y = {}) \<longrightarrow> 
                                 (HSize h = HSize hh \<and> 
                                  p = \<langle> (int (clockA * L + clockB)) (int (callcA * L + callcB))
                                        (int (invkcA * L + invkcB)) (invkdpthA * L + invkdpthB)\<rangle>)))}"
      and  vardistinct:     "distinct [tag,h,b,one] \<and> distinct [one,b,h,tag] \<and> 
                             distinct[l,acc,t] \<and> distinct [t,acc,l] \<and>
                             distinct[HD,TAG] \<and> distinct [TAG,HD]"
      and resdefs[simp]: "(callcA = 1) \<and> (callcB = 1) \<and> (clockA = 31) \<and> (clockB = 11) \<and> (invkcA = 0) \<and> (invkcB = 0) \<and> (invkdpthA = 0) \<and> (invkdpthB = 0)"

lemma (in RevInplace) "\<rhd> (Call f) : specf"
apply (rule vdm_call)
apply (insert vardistinct)
apply (rule vdm_conseq) 
apply (simp only:funtf)
apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2 
apply (rule vdm_leti, rule vdm_prim) prefer 2 apply clarsimp prefer 2 
apply (rule vdm_if, rule vdm_rvar) prefer 2 apply clarsimp 
apply (case_tac "aa<ad\<bullet>TAG> < 1", clarsimp) defer 1
apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2 
apply (rule vdm_letr, rule vdm_getfr) prefer 2 apply clarsimp prefer 2 
apply (rule vdm_leti, rule vdm_int) prefer 2 apply clarsimp prefer 2 
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2 
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2 
apply (rule vdm_letv, rule vdm_putfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2 
apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply (rule vdm_ax, simp)
apply clarsimp
defer 1
(*Case 1*)
apply (erule LocLengthElim1, simp)
(*Case 2*)
apply (erule LocLength.elims, clarsimp, clarsimp)
apply (erule_tac x=i in allE, erule impE)
apply (rule_tac x="Xa - {la}" in exI)
apply (rule conjI)
apply (erule LocLengthSame)
  apply (simp add: same_def)
  apply (rule_tac x="Suc AC" in exI, rule_tac x="Y \<union> {la}" in exI, rule)
  apply (erule LocLengthSuc, fastsimp, fastsimp, fastsimp, fastsimp, fastsimp)
done

(*
lemma (in RevInplace) "\<rhd> (Call f) : specf"
apply (insert vardistinct)
apply (rule vdm_call)
apply (clarsimp)
apply (rule vdm_conseq) prefer 2 apply clarify prefer 2
apply(rule vdm_leti, rule vdm_getfi) prefer 2 apply clarify prefer 2
apply(rule vdm_leti, rule vdm_prim)  prefer 2 apply clarify prefer 2
apply(rule vdm_if) prefer 3 apply clarsimp
   apply (case_tac "aa<rl\<bullet>TAG> < 1")
   (-first case-)
     apply clarsimp prefer 3
     apply(rule vdm_rvar) apply clarsimp
     defer 1
   (-second case-)
     apply clarsimp prefer 2
     apply(rule vdm_leti, rule vdm_getfi) prefer 2 apply clarify prefer 2
     apply(rule vdm_letr, rule vdm_getfr) prefer 2 apply clarify prefer 2
     apply(rule vdm_leti, rule vdm_int) prefer 2 apply clarify prefer 2
     apply(rule vdm_letv, rule vdm_putfi) prefer 2 apply clarify prefer 2
     apply(rule vdm_letv, rule vdm_putfi)  prefer 2 apply clarify prefer 2
     apply(rule vdm_letv, rule vdm_putfr) prefer 2 apply clarify prefer 2
     apply(rule vdm_letr, rule vdm_rvar) prefer 2 apply clarify prefer 2
     apply(rule vdm_letr, rule vdm_rvar) prefer 2 apply clarify prefer 2
     apply (rule vdm_ax, simp)
     apply clarsimp
     defer 1
(-Case 1-)
  apply (erule LocLengthElim1, simp)
(-Case 2-)
  apply (erule LocLength.elims, simp_all)
  apply (erule allE)
  apply (erule impE)
  apply (rule exI)
  apply rule
  apply (erule LocLengthSame)
  apply (simp add: same_def)
  apply (rule_tac x="Suc AC" in exI, rule_tac x="Y \<union> {la}" in exI, rule)
  apply (erule LocLengthSuc, fastsimp+)
done
*)
end
