theory Node = VDMcomb:

consts NODE     :: cname      -- {* class name of the data type *}
       NodeID   :: ifldname   -- {* ID of the edge (should be string)*}
       NodeDIST     :: ifldname   -- {* current distance from source *} 

consts ID::iname
       DIST :: iname
       this :: rname

(*fun NodeInit (this, ID, DIST) = \<dots>*)
constdefs NodeInit :: expr
"NodeInit == LET _ = PutFi this NodeID ID IN PutFi this NodeDIST DIST END"

consts node :: "(locn \<times> int \<times> int \<times> heap) set"
inductive node intros
nodeConstr:"\<lbrakk>h@@l = Some NODE; h<l\<bullet>NodeID> = i; h<l\<bullet>NodeDIST> = d\<rbrakk> \<Longrightarrow> (l,i,d,h) : node"

constdefs NodeInitSPEC :: vdmassn
"NodeInitSPEC E h hh v p == \<forall> l . (E\<lfloor>this\<rfloor>=Ref l \<and> h@@l = Some NODE \<longrightarrow> (l,E<ID>,E<DIST>,hh):node)"

locale NodeInitCorrect =
  fixes nodeinit :: funame
  assumes funtNodeinit: "funtable nodeinit = NodeInit"
      and vardistinct:  "NodeID \<noteq> NodeDIST \<and> ID \<noteq> DIST"

lemma (in NodeInitCorrect) "\<rhd> (Call nodeinit) :: NodeInitSPEC"
apply (rule vdm_call, rule vdm_conseq)
apply (simp add: funtNodeinit NodeInit_def)
apply (rule vdm_basics)+
apply (simp add: IMPLIES_def NodeInitSPEC_def tkCallAssn_def, safe)
apply (erule PutFiElim, assumption)
apply (rule nodeConstr, (simp add: vardistinct predicates)+)
done 

end
