(* used as example in Appendix of deliverable; minor changes in text bits 
   most proofs are hidden; definitions of models relations still in place *)

header {* Representation of Lists on the heap *}

theory ListClass = VDM:

subsection {* Basic definitions *}

text {*
 Function computing heap consumption.
*}

constdefs HSize ::"heap \<Rightarrow> int"
"HSize h == int (card (fmap_dom (heap.oheap h)))"
declare HSize_def [simp]

lemma SizeInsert[simp]: "int (card (insert (freshloc (fmap_dom H)) (fmap_dom H))) = int (card (fmap_dom H)) + 1"
apply (subgoal_tac "card (insert (freshloc (fmap_dom H)) (fmap_dom H)) = Suc (card (fmap_dom H))")
apply simp
apply (rule card_insert_disjoint)
apply fastsimp
apply (rule freshloc, fastsimp)
done

constdefs same::"locn set \<Rightarrow> heap \<Rightarrow> heap \<Rightarrow> bool"
"same X h hh == \<forall> l. (l \<in> X \<longrightarrow> (fmap_lookup (heap.oheap h) l = fmap_lookup (heap.oheap hh) l \<and> 
                                  (\<forall> ifield . (heap.iheap h) ifield l = (heap.iheap hh) ifield l)) \<and>
                                  (\<forall> rfield . (heap.rheap h) rfield l = (heap.rheap hh) rfield l))"

consts LST     :: cname      -- {* class name of the data type *}
       TAG     :: ifldname   -- {* tag distinguishing between nil and cons cells *}
       HD      :: ifldname   -- {* list head, containing data *} 
       TL      :: rfldname   -- {* list tail, containing pointer *}

subsection {* Main models relation *}

text {*
 The models relation encodes how a Grail data type is represented on the heap.
 It's the main definition needed to formalise a datatype in Grail.

 The List data type is encoded by objects with 3 components: $\mbox{TAG}$, 
 $\mbox{HD}$ and $\mbox{TL}$. $\mbox{TAG}$ indicates whether it is a $\mbox{NIL}$
 cell ($0$) or a $\mbox{CONS}$ cell ($1$). 
*}

consts LocLength::"(nat \<times> locn \<times> (locn set) \<times> heap) set"
inductive LocLength intros

  NIL_LocL:  "\<lbrakk>fmap_lookup(oheap hp) l = Some LST; 
	       (heap.iheap hp) TAG l = 0;
               X \<subseteq> fmap_dom (oheap hp);
               l \<in> X\<rbrakk> 
             \<Longrightarrow> (0,l, X, hp) \<in> LocLength"

  CONS_LocL: "\<lbrakk>fmap_lookup(heap.oheap hp) l = Some LST;
	       (heap.iheap hp) TAG l = 1;
	       (heap.iheap hp) HD l = h; 
	       (heap.rheap hp) TL l = Ref tt; 
               l \<in> X;
               tt \<in> X - {l};  (i,tt, X - {l} , hp) \<in> LocLength\<rbrakk>
             \<Longrightarrow> ( Suc i , l, X, hp) \<in> LocLength"

subsection {*Predicate Same*}

(*identify over heaps which are identical on the domain of the predicate*)
lemma LocLengthSameAux:
"\<forall> l X h hh . (((n,l,X,h) \<in> LocLength \<and> same X h hh) \<longrightarrow> (n,l,X,hh) \<in> LocLength)"
apply (induct n)
apply clarsimp
apply (erule LocLength.elims, simp_all, clarsimp)
apply (rule NIL_LocL)
apply (simp_all add: same_def)
apply clarsimp
apply (subgoal_tac "x \<in> fmap_dom (oheap hp)")
prefer 2 apply fast
apply (simp add: fmap_dom_def dom_def, clarsimp)
apply (rule_tac x=y in exI,simp add: fmap_lookup_def)
apply clarsimp
apply (erule LocLength.elims, simp)
apply (erule_tac x=tt in allE)
apply (erule_tac x="Xa - {la}" in allE)
apply (erule_tac x=hp in allE)
apply (erule_tac x=hh in allE)
apply (rule CONS_LocL, simp_all)
done

lemma LocLengthSame:
"\<lbrakk>(n,l,X,h) \<in> LocLength; same X h hh\<rbrakk> \<Longrightarrow> (n,l,X,hh) \<in> LocLength"
by (insert LocLengthSameAux, fast)

subsection{*Properties of LocLength*}

lemma LocLengthDom[simp]: "(i,l,X,h) : LocLength \<Longrightarrow> l : X"
by (erule LocLength.elims, simp_all)

lemma LocLengthElim1:
  "\<lbrakk>(L, ad, X, aa) \<in> LocLength; aa<ad\<bullet>TAG> < 1\<rbrakk> \<Longrightarrow> L = 0"
by (erule LocLength.elims, simp_all)

lemma LocLengthElim2:
  "\<lbrakk>(L, ad, X, aa) \<in> LocLength; aa<ad\<bullet>TAG> = 0 \<rbrakk> \<Longrightarrow> L = 0"
by (erule LocLength.elims, simp_all)

lemma LocLengthDom2:
  "\<lbrakk>(L, ad, X, aa) \<in> LocLength;  \<not> aa<ad\<bullet>TAG> < 1\<rbrakk> \<Longrightarrow> \<exists> l. aa\<lfloor>ad\<diamondsuit>TL\<rfloor> = Ref l"
by (erule LocLength.elims, simp_all)

lemma LocLengthSuc:
  "\<lbrakk>(AC, racc, Y, hp) \<in> LocLength; TAG \<noteq> HD; fmap_lookup (oheap hp) la = Some LST; la \<notin> Y\<rbrakk> 
       \<Longrightarrow> (Suc AC, la, Y \<union> {la}, hp
           \<lparr>iheap := (iheap hp)(TAG := (iheap hp TAG)(la := 1)), iheap := (iheap hp)(TAG := (iheap hp TAG)(la := 1), HD := iheap hp HD),
              rheap := (rheap hp)(TL := (rheap hp TL)(la := Ref racc))\<rparr>)
          \<in> LocLength"
apply (rule CONS_LocL)
apply simp_all
apply (erule LocLengthDom)
apply (erule LocLengthSame)
apply (simp add: same_def)
done

lemma "\<lbrakk>(n,l,D,h): LocLength; \<not> h<l\<bullet>TAG> < 1\<rbrakk> \<Longrightarrow> fmap_lookup(oheap h) l = Some LST"
by (erule LocLength.elims, simp_all)

lemma "\<lbrakk>(n,l,D,h): LocLength; \<not> h<l\<bullet>TAG> < 1\<rbrakk> \<Longrightarrow> (iheap h) TAG l = 1"
by (erule LocLength.elims, simp_all)

lemma "\<lbrakk>(n,l,D,h): LocLength; \<not> h<l\<bullet>TAG> < 1\<rbrakk> \<Longrightarrow> (iheap h) HD l = ?hd"
by (erule LocLength.elims, simp_all, fast)

lemma "\<lbrakk>(n,l,D,h): LocLength; \<not> h<l\<bullet>TAG> < 1\<rbrakk> \<Longrightarrow> l:D"
by (erule LocLength.elims, simp_all)

end
