(*  
   File:	Finmap.thy
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: Finmap.thy,v 1.1 2003/11/20 14:34:15 a1hloidl Exp $
   
    A type definition for finite maps

  Olha's comment: guys, see also "A theory of finite maps" 
                  by Graham Collins and Donald Syme,
                  www.collins-peak.net/academic/fmap.ps
*)

theory Finmap = Map:

typedef (Finmap)
  ('a,'b) finmap = "{F::'a \<leadsto> 'b| F. finite (dom F)}" 
proof
  show "empty : ?Finmap"
  by simp
qed

syntax 
 "finmap"  :: "[type,type] => type"  (infixr "~=>f" 0)

syntax (xsymbols)
  "finmap"     :: "[type, type] => type"      (infixr "\<leadsto>\<^sub>f" 0)

constdefs
  fimap :: "('a \<leadsto> 'b) \<Rightarrow> ('a \<leadsto>\<^sub>f 'b)"
  "fimap S \<equiv> Abs_Finmap(S)"

  themap :: "('a \<leadsto>\<^sub>f 'b) \<Rightarrow> ('a \<leadsto> 'b)" 
  "themap F \<equiv> Rep_Finmap(F)"

lemma finmap [simp]: "finite (dom F) \<Longrightarrow> themap(fimap F) = F"
  by (simp add: fimap_def themap_def Finmap_def Abs_Finmap_inverse)

lemma finmap2 [simp]: "fimap(themap F) = F"
 by (simp add: fimap_def themap_def Finmap_def Rep_Finmap_inverse)

lemma finmap_cases [case_names finmap, cases type: finmap]: 
  "(!!M. \<lbrakk> F = fimap M; finite (dom M) \<rbrakk> \<Longrightarrow> R) \<Longrightarrow> R"
proof -
  assume r: "!!M. \<lbrakk> F = fimap M; finite (dom M) \<rbrakk> \<Longrightarrow> R"
  obtain M where "F = fimap M" and "finite (dom M)"
  by (cases F) (auto simp add: fimap_def Finmap_def)
  thus R by (rule r)
qed

lemma finmap_induct [case_names finmap, induct type: finmap]:
    "(!!M. finite (dom M) ==> P (fimap M)) ==> P f"
by (cases f, simp)

constdefs
 fmap_upd	:: "('a ~=>f 'b) => 'a => 'b => ('a ~=>f 'b)"
					         ("_/'(_/|->f_')"   [900,0,0]900)
 "fmap_upd f a b == fimap(themap(f)(a\<mapsto>b))"

syntax
  fmap_upd   :: "('a \<leadsto>\<^sub>f 'b) => 'a      => 'b      => ('a \<leadsto>\<^sub>f 'b)"
					  ("_/'(_/\<mapsto>\<^sub>f/_')"  [900,0,0]900)

constdefs
 fmap_lookup	:: "('a ~=>f 'b) => 'a => 'b option"
 "fmap_lookup f a == themap(f) a"

constdefs
 emptyfinmap :: "'a \<leadsto>\<^sub>f 'b"
 "emptyfinmap == fimap(empty)"

lemma lookupEmptyfinmap[simp]: "fmap_lookup emptyfinmap k  = None"
by (simp add: emptyfinmap_def fmap_lookup_def)

lemma lookupUpdatefinmap[simp]: "fmap_lookup (f(a \<mapsto>\<^sub>f b)) a= Some b"
apply (induct f)
apply (simp add: fmap_upd_def fmap_lookup_def)
done

subsection {* Domain of a finite map *}

constdefs
 fmap_dom  :: "('a ~=>f 'b) => 'a set"
 "fmap_dom f == dom(themap f)"

lemma finite_dom_fmap [intro]:  "finite (fmap_dom f)"
apply (induct f)
apply (simp add: fmap_dom_def)
done

lemma fmap_dom_emptymap [simp]: "fmap_dom emptyfinmap = {}"
apply (simp add: emptyfinmap_def fmap_dom_def)
done

lemma fmap_dom_update [simp]: "fmap_dom (f(a\<mapsto>\<^sub>fb)) = (fmap_dom f) \<union> {a}"
apply (induct f)
apply (simp add: fmap_dom_def fmap_upd_def)
done

(*some temporary lemmas by Lenb*)
lemma FMAPlookup1:"(\<not> c = a) \<Longrightarrow> ((fmap_lookup (f(a \<mapsto>\<^sub>f b)) c) = (fmap_lookup f c))"
apply (induct f)
apply (simp add: fmap_dom_def fmap_upd_def fmap_lookup_def)
done

lemma FMAPlookup2: "(((\<not> c = a) \<and> (fmap_lookup f c = d)) \<longrightarrow> (fmap_lookup (f(a \<mapsto>\<^sub>f b)) c = d))"
apply (induct f)
apply (simp add: fmap_dom_def fmap_upd_def fmap_lookup_def)
done

lemma FMAPlookup3:"\<And>   a b c d f . (((\<not> c = a) \<and> (fmap_lookup f c = d)) \<longrightarrow> (fmap_lookup (f(a \<mapsto>\<^sub>f b)) c = d))"
apply(simp add:FMAPlookup1)
done


(* Missing: 
   empty_upd_none
   sum_case_empty_empty, etc,etc. *)
end


