theory Edge = Node:

consts EDGE     :: cname      -- {* class name of the data type *}
       EdgeID       :: ifldname   -- {* ID of the edge (should be string)*}
       EdgeCOST     :: ifldname   -- {* weight *} 
       EdgeSOURCE   :: rfldname   -- {* source *}
       EdgeTARGET   :: rfldname   -- {* target *}

consts SOURCE :: rname
       TARGET :: rname
       COST :: iname

(*fun EdgeInit (this, ID, SOURCE, TARGET, COST) = \<dots>*)
constdefs EdgeInit :: expr
"EdgeInit == LET _ = PutFi this EdgeID ID;
                 _ = PutFr this EdgeSOURCE SOURCE;
                 _ = PutFr this EdgeTARGET TARGET
             IN PutFi this EdgeCOST COST END"

consts edge :: "(locn \<times> int \<times> ref \<times> ref \<times> int \<times> heap) set"
inductive edge intros
edgeConstr:"\<lbrakk>h@@l = Some EDGE; h<l\<bullet>EdgeID> = i; h\<lfloor>l\<diamondsuit>EdgeSOURCE\<rfloor> = s; 
             h\<lfloor>l\<diamondsuit>EdgeTARGET\<rfloor> = t; h<l\<bullet>EdgeCOST> = c\<rbrakk>
            \<Longrightarrow> (l,i,s,t,c,h) : edge"

constdefs EdgeInitSPEC :: vdmassn
"EdgeInitSPEC E h hh v p == 
  \<forall> l . (E\<lfloor>this\<rfloor>=Ref l \<and> h@@l = Some EDGE \<longrightarrow> (l,E<ID>,E\<lfloor>SOURCE\<rfloor>,E\<lfloor>TARGET\<rfloor>,E<COST>,hh):edge)"

locale EdgeInitCorrect =
  fixes nodeinit :: funame
  assumes funtEdgeinit: "funtable edgeinit = EdgeInit"
      and vardistinct:  "EdgeID \<noteq> EdgeCOST \<and> ID \<noteq> COST \<and> 
                         EdgeSOURCE \<noteq> EdgeTARGET \<and> SOURCE \<noteq> TARGET"

lemma (in EdgeInitCorrect) "\<rhd> (Call edgeinit) :: EdgeInitSPEC"
apply (rule vdm_call, rule vdm_conseq)
apply (simp add: funtEdgeinit EdgeInit_def)
apply (rule vdm_basics)+
apply (simp add: IMPLIES_def EdgeInitSPEC_def tkCallAssn_def, safe)
apply (erule PutFiElim, assumption)
apply (erule PutFrElim, assumption)
apply (erule PutFrElim, assumption)
apply (rule edgeConstr)
apply (simp add: vardistinct predicates)+
done 

end
