theory DoubleInv = VDMderived + ListClass:
(*Cmaelot:

let double l = match l with Nil@d => Nil@d
                          | Cons(h,t)@d => Cons(h,Cons(h,double t)@d)


COmpiler Output:
  class Double {
   method public static Double$dia_0 double (Double$dia_0 l) =
   let

      fun f:double(Double$dia_0 l) =
      let
         val v4 = getfield l <int Double$dia_0.$>
      in
         if v4 = 0
         then f:0(l)
         else f:1(l)
      end

      fun f:1(Double$dia_0 l) =
      let
         val v4 = getfield l <int Double$dia_0.f0>
         val v3 = getfield l <Double$dia_0 Double$dia_0.f1>
         val v2 = l
         val v1 = invokestatic <Double$dia_0 Double.double (Double$dia_0)> (v3)
         val l = invokestatic <Double$dia_0 Double$dia_0.fill (Double$dia_0, int, int, Double$dia_0)> (v2, 1, v4, v1)
      in
         invokestatic <Double$dia_0 Double$dia_0.make (int, int, Double$dia_0)> (1, v4, l)
      end

      
      fun f:0(Double$dia_0 l) =
         invokestatic <Double$dia_0 Double$dia_0.fill (Double$dia_0, int)> (l, 0)
   in
      f:double(l)
   end
}

Pretty-printed with invokestatic:
class Double {
   method public static List double (List l) =
   let
      fun f(l) =
      let val v4 = getfield l TAG
      in
         if v4 = 0
         then putfield l TAG 0
         else f1(l)
      end

      fun f1(List l) =
      let
         val v4 = getfield l HD
         val v3 = getfield l TL
         val v2 = l
         val v1 = invokestatic <List.double (v3)

         val () = putfield v2 TAG 1
         val () = putfield v2 HD v4
         val () = putfield v2 TL v1
         val l = v2
      in new List(TAG:=1, HD:=v4, TL:= l)
      end

   in
      f(l)
   end
}
*)

constdefs clockA::nat "clockA == 37"
          clockB::nat "clockB == 17"
          callcA::nat "callcA == 0"
          callcB::nat "callcB == 0"
          invkcA::nat "invkcA == 1"
          invkcB::nat "invkcB == 0"
          invkdpthA::nat "invkdpthA == 1"
          invkdpthB::nat "invkdpthB == 0"
          
locale Double = 
  fixes    v4     :: iname   and    one     :: iname and    zero     :: iname and b       :: iname
    and    l       :: rname  and v3 :: rname and v2 :: rname and    v1       :: rname
    and	   double   :: mname  and specm :: vdmassn

 assumes methtm[simp]:
         "methtable LST double ==
                     (LET rf l = RVar param;
                            v4 = GetFi l TAG;
                            b  = Primop (% x y. if x = 0 then 1 else 0) v4 v4
                        IN IF b 
                           THEN LET zero = expr.Int 0;
                                       _ = PutFi l TAG zero 
                                IN RVar l END
                           ELSE LET v4 = GetFi l HD;
                                 rf v3 = GetFr l TL;
                                 rf v2 = RVar l;
                                 rf v1 = LST\<bullet>double(v3);
                                   one = expr.Int 1;
                                    _  = PutFi v2 TAG one;
                                    _  = PutFi v2 HD v4;
                                    _  = PutFr v2 TL v1;
                                  rf l = RVar v2
                               IN NEW <LST> ([(TAG,one), (HD,v4)],[(TL,l)]) 
                               END
                       END)"

     and mf: "Mspectable LST double
            == {(E,h,hh,v,p) . 
                    \<forall> L . ((\<exists> rl X. E\<lfloor>v3\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> LocLength) \<longrightarrow>
                            HSize hh = HSize h + (int L) \<and> 
                            p = \<langle> (int(37 * L + 20)) 0 (int(L + 1)) (L + 1)\<rangle>)}"
(*     and mf: "Mspectable LST double
            == {(E,h,hh,v,p) . 
                    \<forall> L . ((\<exists> rl X. E\<lfloor>v3\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> LocLength) \<longrightarrow>
                            HSize hh = HSize h + (int L) \<and> 
                            p = \<langle> (int(37 * L + 17 + 3)) (int(0 * L + 0))
                                  (int(1 * L + 0 + 1)) (1 * L + 0 + 1)\<rangle>)}"*)
(*     and mf: "Mspectable LST double
            == {(E,h,hh,v,p) . 
                    \<forall> L . ((\<exists> rl X. E\<lfloor>v3\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> LocLength) \<longrightarrow>
                            HSize hh = HSize h + (int L) \<and> 
                            p = \<langle> (int(clockA * L + clockB + 3)) (int(callcA * L + callcB))
                                  (int(invkcA * L + invkcB + 1)) (invkdpthA * L + invkdpthB + 1)\<rangle>)}"
*)     and vardistinct: "distinct [v4,one,zero,b] \<and> distinct [b,zero,one,v4] \<and>
                         distinct [l,v1,v2,v3,param,self] \<and> distinct [self,param,v3,v2,v1,l] \<and>
                         distinct [TAG,HD] \<and> distinct [HD,TAG]"

lemma (in Double) "\<rhd> (LST\<bullet>double(v3)): (Mspectable LST double)"
apply (rule vdm_invokestatic, simp)
apply (rule vdm_conseq)
apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_prim) prefer 2 apply clarsimp prefer 2
apply (rule vdm_if)
apply (rule vdm_leti, rule vdm_int) prefer 3 apply clarsimp
apply (case_tac "aa<a\<bullet>TAG> \<noteq> 0", clarsimp) defer 1 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi, rule vdm_rvar) apply clarsimp defer 1
apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_getfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_ax, simp) prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_int) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply (rule vdm_new) apply clarsimp 
apply (insert vardistinct)
apply (simp_all add: newObj_def newframe_env_def mf)
apply clarsimp
apply (erule LocLength.elims, simp_all, clarsimp)
apply (erule_tac x=i in allE)
apply (erule impE)
apply fast
apply simp
(*defer 1*)
apply clarsimp
apply (erule LocLength.elims, simp_all)
(*apply (simp_all add: clockA_def clockB_def callcA_def callcB_def invkcA_def invkcB_def invkdpthA_def invkdpthB_def)*)
done
end
