(*  Examples from List.cmlt -> Grail*)

(*Camelot:
let double_rev l acc = match l with Nil => acc
                                  | Cons(h,t) => double_rev t (Cons(h, Cons(h,acc)))

let double_rev2 l acc = match l with Nil => acc
                                   | Cons(h,t)@d => double_rev2 t (Cons(h,Cons(h,acc)@d))

Compiled Grail:   
method public static List$dia_0 double_rev2 (List$dia_0 l, List$dia_0 acc) =
   let fun f:double_rev2(List$dia_0 l, List$dia_0 ?t2, List$dia_0 ?t3, 
                         List$dia_0 d, int h, List$dia_0 t, List$dia_0 acc, List$dia_0 l) =
       let val tag = getfield l <int List$dia_0.$>
       in if tag = 0
          then f:0(l, ?t2, ?t3, d, h, t, acc, l)
          else f:1(l, ?t2, ?t3, d, h, t, acc, l)
       end
       fun f:1(List$dia_0 l, List$dia_0 ?t2, List$dia_0 ?t3, List$dia_0 d, 
               int h, List$dia_0 t, List$dia_0 acc, List$dia_0 l) =
       let val h = getfield l <int List$dia_0.f1>
           val t = getfield l <List$dia_0 List$dia_0.f0>
           val d = l
           val ?t3 = invokestatic <List$dia_0 List$dia_0.fill (List$dia_0, int, int, List$dia_0)> (d, 1, h, acc)
           val ?t2 = invokestatic <List$dia_0 List$dia_0.make (int, int, List$dia_0)> (1, h, ?t3)
       in invokestatic <List$dia_0 List.double_rev2 (List$dia_0, List$dia_0)> (t, ?t2)
       end
       fun f:0(List$dia_0 l, List$dia_0 ?t2, List$dia_0 ?t3, List$dia_0 d, 
               int h, List$dia_0 t, List$dia_0 acc, List$dia_0 l) = acc
   in f:double_rev2(l, ?t2, ?t3, d, h, t, acc, l)
   end 

   method public static List$dia_0 double_rev (List$dia_0 l, List$dia_0 acc) =
   let fun f:double_rev(List$dia_0 l, List$dia_0 ?t0, List$dia_0 ?t1, 
                        int h, List$dia_0 t, List$dia_0 acc, List$dia_0 l) =
       let val tag = getfield l <int List$dia_0.$>
       in if tag = 0
          then f:0(l, ?t0, ?t1, h, t, acc, l)
          else f:1(l, ?t0, ?t1, h, t, acc, l)
       end
       fun f:1(List$dia_0 l, List$dia_0 ?t0, List$dia_0 ?t1, int h, List$dia_0 t, List$dia_0 acc, List$dia_0 l) =
       let val h = getfield l <int List$dia_0.f1>
           val t = getfield l <List$dia_0 List$dia_0.f0>
           val ?t1 = invokestatic <List$dia_0 List$dia_0.make (int, int, List$dia_0)> (1, h, acc)
           val ?t0 = invokestatic <List$dia_0 List$dia_0.make (int, int, List$dia_0)> (1, h, ?t1)
       in invokestatic <List$dia_0 List.double_rev (List$dia_0, List$dia_0)> (t, ?t0)
       end
       fun f:0(List$dia_0 l, List$dia_0 ?t0, List$dia_0 ?t1, int h, List$dia_0 t, 
               List$dia_0 acc, List$dia_0 l) = acc
    in f:double_rev(l, ?t0, ?t1, h, t, acc, l)
    end

ToyGrail:
method public static List double_rev2 (List l, List acc) =
   let fun f(List l, List acc) =
       let val tag = getfield l <int List.$>
       in if tag = 0
          then f0(acc)
          else f1(l, acc)
       end
       fun f1(List l, List acc) =
       let val h = getfield l <int List.f1>
           val t = getfield l <List List.f0>
           val d = l
           val one = 1
           val () = putfield d TAG one
           val () = putfield d HD h
           val () = putfield d TL acc
           val ?t3 = d
           val ?t2 = invokestatic <List.alloc ()> ()
           val () = putfield ?t2 TAG one
           val () = putfield ?t2 HD h
           val () = putfield ?t2 TL ?t3
           val l = t
           val acc = ?t2
       in f(l,acc)
       end
       fun f0(List acc) = acc
   in f(l, acc)
   end 

   method public static List double_rev (List l, List acc) =
   let fun f(List l, List acc) =
       let val tag = getfield l <int List.$>
       in if tag = 0
          then f:0(acc)
          else f:1(l, acc)
       end
       fun f1(List l, List acc) =
       let val h = getfield l <int List.f1>
           val t = getfield l <List List.f0>
           val one = 1

           val ?t1 = invokestatic <List.alloc ()> ()
           val () = putfield ?t1 TAG one
           val () = putfield ?t1 HD h
           val () = putfield ?t1 TL acc

           val ?t0 = invokestatic <List List.alloc ()> ()
           val () = putfield ?t0 TAG one
           val () = putfield ?t0 HD h
           val () = putfield ?t0 TL ?t1
           val l = t
           val acc = ?t0
       in f(l,acc)
       end
       fun f0(List acc) = acc
    in f(l, acc)
    end
*)
 
theory Double = VDMderived + ListClass:

constdefs clockA::nat "clockA == 37"
          clockB::nat "clockB == 11"
          callcA::nat "callcA == 1"
          callcB::nat "callcB == 1"
          invkcA::nat "invkcA == 0"
          invkcB::nat "invkcB == 0"
          invkdpthA::nat "invkdpthA == 0"
          invkdpthB::nat "invkdpthB == 0"
          
locale Double = 
  fixes    tag     :: iname  and    h       :: iname  and    one     :: iname and	   b       :: iname
    and    l       :: rname  and    acc     :: rname  and    t       :: rname and    d       :: rname
    and    t2      :: rname  and    t3      :: rname
    and	   f       :: funame  and specf :: vdmassn
 assumes funtf[simp]:
         "funtable f == LET tag = GetFi l TAG;
                                b = Primop (% x y. if x = 0 then 1 else 0) tag tag
                          IN IF b (*8 ticks till here*)
                          THEN RVar acc
                          ELSE LET h    = GetFi l HD;
                                 rf t   = GetFr l TL;
                                 rf d   = RVar l;
                                    one = expr.Int 1;
                                    _   = PutFi d TAG one;
                                    _   = PutFi d HD h;
                                    _   = PutFr d TL acc;
                                 rf t3  = RVar d;
                                 rf t2  = NEW <LST> ([(TAG,one),(HD,h)],[(TL,t3)]);
                                 rf l   = RVar t;
                                 rf acc = RVar t2
                               IN CALL f END
                          END"
      and sf: "specf == {(E,h,hh,v,p) . 
                    \<forall> L X. ((\<exists> rl . E\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> LocLength) \<longrightarrow>
                            HSize hh = HSize h + (int L) \<and> 
                            p = \<langle> (int(37 * L + 11)) (int(L + 1)) 0 0\<rangle>)}"
(*       and sf: "specf == {(E,h,hh,v,p) . 
                    \<forall> L X. ((\<exists> rl . E\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> LocLength) \<longrightarrow>
                            HSize hh = HSize h + (int L) \<and> 
                            p = \<langle> (int(clockA * L + clockB)) (int(callcA * L + callcB))
                                  (int(invkcA * L + invkcB)) (invkdpthA * L + invkdpthB)\<rangle>)}"*)
      and vardistinct: "distinct [tag,h,one,b] \<and> distinct [b,one,h,tag] \<and>
                         distinct [l,acc,t,d,t2,t3] \<and> distinct [t3,t2,d,t,acc,l] \<and>
                         distinct [f,f0,f1] \<and> distinct [f1,f0,f] \<and>
                         distinct [TAG,HD] \<and> distinct [HD,TAG]"

lemma (in Double) "\<rhd> (CALL f): specf"
apply (rule vdm_call)
apply (insert vardistinct)
apply (rule vdm_conseq)
apply (simp only: funtf)
apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_prim) prefer 2 apply clarsimp prefer 2
apply (rule vdm_if) 
apply (rule vdm_rvar) prefer 2 apply clarsimp 
apply (case_tac "aa<ad\<bullet>TAG> = 0", clarsimp) defer 1
apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_getfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_int) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_new) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply (rule vdm_ax, simp) 
(*end of vcg*)
apply (simp_all add: sf)
defer 1
(* Case 1*)
  apply clarsimp
  apply (subgoal_tac "L=0", simp)(* add:clockA_def clockB_def callcA_def callcB_def invkcA_def invkcB_def invkdpthA_def invkdpthB_def)*)
  apply (erule LocLengthElim2, assumption)
(* Case 2*)
  apply clarsimp
  apply (erule LocLength.elims,  simp_all, clarsimp)
  apply (erule_tac x=i in allE)
  apply (erule impE)
  apply (rule_tac x="Xa - {la}" in exI)
  apply (rule LocLengthSame, assumption)
  apply (simp add: same_def newObj_def)
  apply (fastsimp intro: freshloc)
  apply (simp add: newObj_def)(* clockA_def clockB_def callcA_def callcB_def invkcA_def invkcB_def invkdpthA_def invkdpthB_def)*)
done
end
