theory combEx1 = ListClassComb:

constdefs LLX::"locn set \<Rightarrow> nat \<Rightarrow> rname \<Rightarrow> vdmassn"
"LLX X L l E h hh v p == (\<exists> r. E\<lfloor>l\<rfloor> = Ref r \<and> (L,r,X,h) \<in> LocLength)"

constdefs starLists::"nat \<Rightarrow> rname \<Rightarrow> nat \<Rightarrow> rname \<Rightarrow> vdmassn"
"starLists L l A a == \<lambda> E h hh v p . (\<exists> X Y . (LLX X L l && LLX Y A a) E h hh v p \<and> X \<inter> Y = {})"

lemma StarRef: "starLists L l AC acc E h hh v p \<Longrightarrow> \<exists> r . E\<lfloor>l\<rfloor> = Ref r"
by (simp add: starLists_def AND_def LLX_def, clarsimp)

lemma "IMPLIES P Q = (\<forall> E h hh v p. (impliesAssn P Q E h hh v p))"
by (simp add: IMPLIES_def impliesAssn_def)

locale RevInplace = 
  fixes    tag     :: iname    and	   h       :: iname    and	   b       ::iname   and one :: iname
    and    l       :: rname    and         acc     :: rname    and         t      :: rname  
    and	   f       :: funame   and callcA :: int and callcB :: int and clockA ::int and clockB :: int and invkcA :: int 
    and invkcB :: int and invkdpthA :: nat and invkdpthB :: nat and sf::vdmassn and sf2::vdmassn
 assumes  funtf:
          "funtable f == (LET tag = GetFi l TAG;
                                b = Primop (% x y. if x < 1 then 1 else 0) tag tag
                          IN IF b THEN RVar acc 
                             ELSE LET  h   = GetFi l HD;
                                    rf t   = GetFr l TL;
                                       one = expr.Int 1;
                                         _ = PutFi l TAG one; 
                                         _ = PutFi l HD h;
                                         _ = PutFr l TL acc;
                                    rf acc = RVar l;
                                    rf l   = RVar t 
                                 IN CALL f END
                         END)"
      and  vardistinct:     "tag \<noteq> h \<and> tag \<noteq> b \<and> tag \<noteq> one \<and> h \<noteq> b \<and> h \<noteq> one \<and> b \<noteq> one \<and> 
                             l \<noteq> acc \<and> l \<noteq> t \<and> acc \<noteq> t \<and> 
                             HD \<noteq> TAG"
      and resdefs: "(callcA = 1) \<and> (callcB = 1) \<and> (clockA = 31) \<and> (clockB = 11) \<and> (invkcA = 0)
                    \<and> (invkcB = 0) \<and> (invkdpthA = 0) \<and> (invkdpthB = 0)"
     defines spectf: "sf E hp hh v p ==
                  (\<forall> L AC . impliesAssn (starLists L l AC acc)
                                        (ticks (constVE (IVal(clockA * (int L) + clockB)))
                                         && calls (constVE (IVal(callcA * (int L) + callcB)))
                                         && invokes (constVE (IVal(invkcA * (int L) + invkcB)))
                                         && depth (constVE (IVal(int (invkdpthA * L + invkdpthB))))
                                         && allocates (constVE (IVal 0))) E hp hh v p)"
         and spectf2: "sf2 == (ALLnat (\<lambda> L . ALLnat (\<lambda> A . (impliesAssn (starLists L l A acc) 
                                                                   (ticks (constVE (IVal(clockA * (int L) + clockB)))
                                                                    && calls (constVE (IVal(callcA * (int L) + callcB)))
                                                                    && invokes (constVE (IVal(invkcA * (int L) + invkcB)))
                                                                    && depth (constVE (IVal(int (invkdpthA * L + invkdpthB))))
                                                                    && allocates (constVE (IVal 0)))))))"

lemma (in RevInplace) "sf = sf2"
by (rule, rule, rule, rule, rule, simp add: spectf spectf2 predicates ALLnat_def impliesAssn_def)

declare rescomp_plus_def [simp del]
declare rescomp_cup_def [simp del]

lemma SetAux[simp]: "\<lbrakk>X \<inter> Y = {}; x:X\<rbrakk> \<Longrightarrow> \<not> x:Y"
by fast

lemma TknAdd[simp]: "tkn i (tkn j p) = tkn (i+j) p"
by (simp add: rescomp_cup_def)

(*proof takes 17secs*)
lemma (in RevInplace) "\<rhd> (Call f) :: sf"
apply (rule vdm_call, rule vdm_conseq)
apply (simp only:funtf)
apply(rule vdm_basics)+
apply (rule vdm_ax, simp)
apply (simp add: IMPLIES_def tkCallAssn_def spectf impliesAssn_def, safe)
apply (subgoal_tac "\<exists> r. E\<lfloor>l\<rfloor> = Ref r", clarsimp)
apply (erule GetFiElim, simp add: predicates, simp)
apply (erule IopElim, simp add: predicates, simp add: predicates, simp)
apply (erule CondElim)
apply clarsimp
apply (simp add: predicates resdefs rescomp_cup_def starLists_def LLX_def, safe)
apply (erule LocLengthElim1, assumption)
apply clarsimp
apply (erule GetFiElim, simp add: predicates, simp)
apply (erule GetFrElim, simp add:predicates, simp)
apply (erule IconstElim, simp)
apply (erule PutFiElim, simp add: vardistinct, simp)
apply (erule PutFiElim, simp add: vardistinct, simp)
apply (erule PutFrElim, simp add: vardistinct, simp)
apply (erule RVarElim, simp add: rvarVE_def vardistinct, simp)
apply (erule RVarElim, simp add: rvarVE_def vardistinct, simp) 
(*end of extended VCG*)
apply (simp add: spectf impliesAssn_def starLists_def AND_def LLX_def, clarsimp)
apply (erule LocLength.elims, ((simp add: vardistinct)+))
apply (erule_tac x=i in allE, erule impE, clarify)
apply (rule_tac x="Suc AC" in exI, rule_tac x="Xa-{la}" in exI, safe)
apply (erule LocLengthSame)
apply (simp add: same_def)
apply (rule_tac x="Y \<union> {la}" in exI, rule)
apply (rule CONS_LocL, simp_all)
apply (fastsimp intro: vardistinct)
apply (erule LocLengthDom)
apply (erule LocLengthSame, simp add: same_def)
apply fast
apply (simp add: predicates rescomp_cup_def resdefs)+
apply (erule StarRef)
done

locale RevInplace1 = 
  fixes    tag     :: iname    and	   h       :: iname    and	   b       ::iname   and one :: iname
    and    l       :: rname    and         acc     :: rname    and         t      :: rname  
    and	   f       :: funame   and callcA :: int and callcB :: int and clockA ::int and clockB :: int and invkcA :: int 
    and invkcB :: int and invkdpthA :: nat and invkdpthB :: nat and sf::vdmassn
 assumes  funtf:
          "funtable f == (LET tag = GetFi l TAG;
                                b = Primop (% x y. if x < 1 then 1 else 0) tag tag
                          IN IF b THEN RVar acc 
                             ELSE LET  h   = GetFi l HD;
                                    rf t   = GetFr l TL;
                                       one = expr.Int 1;
                                         _ = PutFi l TAG one; 
                                         _ = PutFi l HD h;
                                         _ = PutFr l TL acc;
                                    rf acc = RVar l;
                                    rf l   = RVar t 
                                 IN CALL f END
                         END)"
      and  vardistinct:     "tag \<noteq> h \<and> tag \<noteq> b \<and> tag \<noteq> one \<and> h \<noteq> b \<and> h \<noteq> one \<and> b \<noteq> one \<and> 
                             l \<noteq> acc \<and> l \<noteq> t \<and> acc \<noteq> t \<and> 
                             HD \<noteq> TAG"
      and resdefs[simp]: "(callcA = 1) \<and> (callcB = 1) \<and> (clockA = 31) \<and> (clockB = 11) \<and> (invkcA = 0)
                          \<and> (invkcB = 0) \<and> (invkdpthA = 0) \<and> (invkdpthB = 0)"
     defines spectf: "sf E hp hh v p ==
                  (\<forall> L AC . (\<exists> X Y r1 r2. E\<lfloor>l\<rfloor> = Ref r1 \<and> (L,r1,X,hp) : LocLength \<and>
                                           E\<lfloor>acc\<rfloor> = Ref r2 \<and> (AC,r2,Y,hp) : LocLength \<and>
                                           X \<inter> Y = {})
                             \<longrightarrow> ((ticks (constVE (IVal(clockA * (int L) + clockB)))
                                  && calls (constVE (IVal(callcA * (int L) + callcB)))
                                         && invokes (constVE (IVal(invkcA * (int L) + invkcB)))
                                         && depth (constVE (IVal(int (invkdpthA * L + invkdpthB))))
                                         && allocates (constVE (IVal 0))) E hp hh v p))"

(*proof takes 10 secs*)
lemma (in RevInplace1) "\<rhd> (Call f) :: sf"
apply (rule vdm_call, rule vdm_conseq)
apply (simp only:funtf)
apply(rule vdm_basics)+
apply (rule vdm_ax, simp)
apply (simp add: IMPLIES_def tkCallAssn_def spectf, safe)
apply (erule GetFiElim, simp add: predicates, simp)
apply (erule IopElim, simp add: predicates, simp add: predicates, simp)
apply (erule CondElim)
apply clarsimp
apply (simp add: predicates rescomp_cup_def, safe)
apply (erule LocLengthElim1, assumption)
apply clarsimp
apply (erule GetFiElim, simp add: predicates, simp)
apply (erule GetFrElim, simp add:predicates, simp)
apply (erule IconstElim, simp)
apply (erule PutFiElim, simp add: vardistinct, simp)
apply (erule PutFiElim, simp add: vardistinct, simp)
apply (erule PutFrElim, simp add: vardistinct, simp)
apply (erule RVarElim, simp add: rvarVE_def vardistinct, simp)
apply (erule RVarElim, simp add: rvarVE_def vardistinct, simp) 
(*end of extended VCG*)
apply (simp add: spectf)
apply (erule LocLength.elims, ((simp add: vardistinct)+))
apply (erule_tac x=i in allE, erule impE, clarify)
apply (rule_tac x="Suc AC" in exI, rule_tac x="Xa-{la}" in exI, safe)
apply (erule LocLengthSame, simp add: same_def)
apply (rule_tac x="Y \<union> {la}" in exI, rule)
apply (rule CONS_LocL, simp_all)
apply (fastsimp intro: vardistinct)
apply (erule LocLengthDom)
apply (erule LocLengthSame, simp add: same_def)
apply fast
apply (simp add: predicates rescomp_cup_def)+
done

(* does not yet work

lemma (in RevInplace) "\<rhd> (Call f) :: sf2"
apply (rule vdm_call, rule vdm_conseq)
apply (simp only:funtf)
apply(rule vdm_basics)+
apply (rule vdm_ax, simp)
apply (rule IMPLIES_Intro)
apply (simp add: tkCallAssn_def spectf2)
apply (rule AllnatIntro)
apply (rule AllnatIntro)
apply (rule impliesAssnIntro)

apply (erule GetFiElim, insert StarRef) apply (simp add: predicates) apply fast etc does not work! so do subgoal_tac!

apply (subgoal_tac "\<exists> r. E\<lfloor>l\<rfloor> = Ref r", clarsimp)
apply (erule GetFiElim, simp add: predicates, simp)
apply (erule IopElim, simp add: predicates, simp add: predicates, simp)
apply (erule CondElim)
apply clarsimp
apply (simp add: predicates resdefs rescomp_cup_def starLists_def LLX_def, safe)
apply (erule LocLengthElim1, assumption)
apply clarsimp
apply (erule GetFiElim, simp add: predicates, simp)
apply (erule GetFrElim, simp add:predicates, simp)
apply (erule IconstElim, simp)
apply (erule PutFiElim, simp add: vardistinct, simp)
apply (erule PutFiElim, simp add: vardistinct, simp)
apply (erule PutFrElim, simp add: vardistinct, simp)
apply (erule RVarElim, simp add: rvarVE_def vardistinct, simp)
apply (erule RVarElim, simp add: rvarVE_def vardistinct, simp) 

end of extended VCG

apply (simp add: spectf impliesAssn_def starLists_def AND_def LLX_def, clarsimp)
apply (erule LocLength.elims, ((simp add: vardistinct)+))
apply (erule_tac x=i in allE, erule impE, clarify)
apply (rule_tac x="Suc AC" in exI, rule_tac x="Xa-{la}" in exI, safe)
apply (erule LocLengthSame)
apply (simp add: same_def)
apply (rule_tac x="Y \<union> {la}" in exI, rule)
apply (rule CONS_LocL, simp_all)
apply (fastsimp intro: vardistinct)
apply (erule LocLengthDom)
apply (erule LocLengthSame, simp add: same_def)
apply fast
apply (simp add: predicates rescomp_cup_def resdefs)+
apply (erule StarRef)
done
*)
end
