(*  
   File:	$RCSfile: VDMderivedLIST.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: VDMderivedLIST.thy,v 1.1 2003/11/19 18:08:35 lenb Exp $

   
*)

header {* Derived rules of the program logic *}

theory VDMderived = Lemmas + VDMpc: 

text {*
 In this section we define several useful rules, that are derived from the core 
 program logic. 
*}

subsection {* Weakening lemmas for contexts *}

(*be seq.induct 1;
by(strip_tac 1);
by(ALLGOALS(fast_tac(HOL_cs addEs [Suc_lessE] addIs seq.intrs)));
*)

lemma CtxtWeak: "G \<rhd> e : P \<Longrightarrow> (\<forall> D . (\<forall> p . p mem G \<longrightarrow> p mem D) \<longrightarrow> D \<rhd> e : P)"
apply (erule vdm_proof.induct)
apply (blast intro!: vdm_proof.intros)
apply (blast intro!: vdm_proof.intros)
apply (blast intro!: vdm_proof.intros)
apply (blast intro!: vdm_proof.intros)
apply (blast intro!: vdm_proof.intros)
apply (blast intro!: vdm_proof.intros)
apply (blast intro!: vdm_proof.intros)
apply (blast intro!: vdm_proof.intros)
apply (blast intro!: vdm_proof.intros)
apply (blast intro!: vdm_proof.intros)
apply (blast intro!: vdm_proof.intros)
apply safe
apply (rule vdm_if)
apply blast
apply blast
apply (rule vdm_leti, blast, blast)
apply (rule vdm_letr, blast, blast)
apply (rule vdm_letv, blast, blast)
apply (rule vdm_call, clarsimp)
(*apply (rule vdm_mhinvokestatic)
apply (rule vdm_mhinvoke, simp)*)
apply (rule vdm_invokestatic, clarsimp)
apply (rule vdm_invoke, clarsimp)
apply (rule vdm_ax, clarsimp)
apply (rule vdm_conseq)
apply (erule_tac x=D in allE)
apply fast
apply simp
done
lemma CtxtWeak1 [rule_format]: "G \<rhd> e : P \<Longrightarrow> (\<forall> D . (\<forall> p . p mem G \<longrightarrow> p mem D) \<longrightarrow> D \<rhd> e : P)"
by (rule  CtxtWeak)

lemma CtxtWeakSingleton: "G \<rhd> e : P \<Longrightarrow> ((ee, Q) # G) \<rhd> e : P"
by (rule CtxtWeak1, simp+)

subsection {* Cut rules *}
(*Delta |- B ::: i ==>   !A j Gamma . set Delta =  set (A # Gamma)  -->  \
            \ (Gamma |- ( < A >) ::: j -->  Gamma |- B ::: i + j)"*)
lemma CutAux: 
"(D \<rhd> e : Q \<Longrightarrow>
(\<forall> ee P . (set D = set ((ee, P) # G) \<longrightarrow> (G \<rhd> ee :P) \<longrightarrow> G \<rhd> e:Q)))"
apply (erule vdm_proof.induct)
apply safe
apply (fast intro: vdm_null)
apply (fast intro: vdm_int)
apply (fast intro: vdm_ivar)
apply (fast intro: vdm_rvar)
apply (fast intro: vdm_prim)
apply (fast intro: vdm_rprim)
apply (fast intro: vdm_getfi)
apply (fast intro: vdm_getfr)
apply (fast intro: vdm_putfi)
apply (fast intro: vdm_putfr)
apply (fast intro: vdm_new)
(*case vdm_if*)
apply clarsimp
(*apply (erule_tac x=Ga in allE, erule_tac x=Ga in allE)
apply (erule_tac x=ee in allE, erule_tac x=ee in allE)
apply (erule_tac x=P in allE, erule_tac x=P in allE)
apply (erule_tac x=D in allE, erule_tac x=D in allE)*)
apply (insert vdm_if, simp)
(*case vdm_leti*)
apply clarsimp apply (rotate_tac 6) apply(erule thin_rl)
(*apply (erule_tac x=Ga in allE, erule_tac x=Ga in allE)
apply (erule_tac x=ee in allE, erule_tac x=ee in allE)
apply (erule_tac x=P in allE, erule_tac x=P in allE)
apply (erule_tac x=D in allE, erule_tac x=D in allE)*)
apply (insert vdm_leti, simp)
(*case vdm_letr*)
apply clarsimp apply (rotate_tac 6) apply(erule thin_rl, erule thin_rl)
(*apply (erule_tac x=Ga in allE, erule_tac x=Ga in allE)
apply (erule_tac x=ee in allE, erule_tac x=ee in allE)
apply (erule_tac x=P in allE, erule_tac x=P in allE)
apply (erule_tac x=D in allE, erule_tac x=D in allE)*)
apply (insert vdm_letr, simp)
(*case vdm_letv*)
apply clarsimp apply (rotate_tac 6) apply(erule thin_rl, erule thin_rl, erule thin_rl)
(*apply (erule_tac x=Ga in allE, erule_tac x=Ga in allE)
apply (erule_tac x=ee in allE, erule_tac x=ee in allE)
apply (erule_tac x=P in allE, erule_tac x=P in allE)
apply (erule_tac x=D in allE, erule_tac x=D in allE)*)
apply (insert vdm_letv, simp)
(*case vdm_call*)
apply clarsimp apply (rotate_tac 4) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rule vdm_call, simp)
apply (erule_tac x = ee in allE, erule_tac x = Pa in allE, clarsimp)
apply (subgoal_tac "set ((CALL f, P) # Ga) = set ((CALL f, P) # G)")
apply clarsimp
apply (
apply (rule CtxtWeak1)
apply (drule mp)
apply(
       erule_tac x="(insert (CALL f, P) D)" in allE, fastsimp) 
(* case vdm_mh_invokestatic*)
apply clarsimp apply (rotate_tac 2) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rule vdm_mhinvokestatic)
apply (erule_tac x = Ga in allE, erule_tac x = ee in allE, erule_tac x = Pa in allE,
       erule_tac x="(insert (C\<bullet>\<bullet>mn, P) D)" in allE, fastsimp) 
(* case vdm_mh_invoke *)
apply clarsimp apply (rotate_tac 1) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rule vdm_mhinvoke)
apply clarsimp
(* no more quantification over E h l
apply (erule_tac x = "E'" in allE, erule_tac x = "h'" in allE,
       erule_tac x = "a" in allE, erule_tac x = "C" in allE, clarsimp) *)
apply (erule_tac x = "C" in allE, clarsimp)
apply (erule_tac x = Ga in allE, erule_tac x = ee in allE, erule_tac x = Pa in allE,
       erule_tac x="(insert (x\<diamondsuit>\<diamondsuit>mn, P) D)" in allE, fastsimp) 
(* case vdm_invokestatic*)
apply clarsimp apply (rotate_tac 2) apply(erule thin_rl, erule thin_rl, erule thin_rl)
apply (rule vdm_invokestatic)
apply clarsimp (*new vdminvokestatic rule*) (* even newer rule *)
(* apply (erule_tac x="E'" in allE, clarsimp) *)
apply (erule_tac x = Ga in allE, erule_tac x = ee in allE, erule_tac x = Pa in allE,
       erule_tac x="(insert (C\<bullet>mn(y), P) D)" in allE, fastsimp) 
(* case vdm_invoke *)
apply clarsimp apply (rotate_tac 1) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rule vdm_invoke)
apply clarsimp
(*  nuke allqs
apply (erule_tac x = "E'" in allE, erule_tac x = "h'" in allE,
       erule_tac x = "a" in allE, erule_tac x = "C" in allE, clarsimp)
*)
apply (erule_tac x = "C" in allE, clarsimp)
apply (erule_tac x = Ga in allE, erule_tac x = ee in allE, erule_tac x = Pa in allE,
       erule_tac x="(insert (x\<diamondsuit>mn(y), P) D)" in allE, fastsimp) 
(*Case vdm_ax*)
apply clarsimp apply (rotate_tac 1) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (erule disjE)
apply clarsimp
apply (subgoal_tac "(Ga \<union> D) \<rhd>  ee : Pa")
apply (subgoal_tac "D = (Ga \<union> D)", simp, fast)
apply (simp add: CtxtWeak)
apply (rule vdm_ax, simp)
apply (rotate_tac 3) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (fastsimp intro: vdm_conseq)
done

lemma CCutAux: 
"(DD \<rhd> e : Q \<Longrightarrow>
(\<forall> G f P D . (DD = (insert (Call f, P) D) \<longrightarrow> (G \<rhd> Call f :P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> D \<rhd> e:Q)))"
by (drule CutAux , simp)

lemma mhInvStat_CutAux: 
"(DD \<rhd> e : Q) \<Longrightarrow>
 (\<forall> G C mn P D . ((DD = (insert (C\<bullet>\<bullet>mn, P) D)) \<longrightarrow> (G \<rhd> (C\<bullet>\<bullet>mn) : P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> (D \<rhd> e : Q)))"
by (drule CutAux, simp)

lemma mhInv_CutAux: 
"(DD \<rhd> e : Q) \<Longrightarrow> 
(\<forall> G x mn P D . ((DD = (insert (x\<diamondsuit>\<diamondsuit>mn, P) D)) \<longrightarrow> (G \<rhd> (x\<diamondsuit>\<diamondsuit>mn) : P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> (D \<rhd> e : Q)))"
by (drule CutAux , simp)


lemma InvStat_CutAux: 
"(DD \<rhd> e : Q) \<Longrightarrow>
(\<forall> G C mn y P D . ((DD = (insert (C\<bullet>mn(y), P) D)) \<longrightarrow> (G \<rhd> (C\<bullet>mn(y)) : P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> (D \<rhd> e : Q)))"
by (drule CutAux , simp)

lemma Inv_CutAux: 
"(DD \<rhd> e : Q) \<Longrightarrow>
(\<forall> G C mn P D . ((DD = (insert (x\<diamondsuit>mn(y), P) D)) \<longrightarrow> (G \<rhd> (x\<diamondsuit>mn(y)) : P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> (D \<rhd> e : Q)))"
by (drule CutAux , simp)

lemma CCut:"\<lbrakk> (insert (ee, P) D) \<rhd> e: Q; G \<rhd> ee : P; G \<subseteq> D\<rbrakk> \<Longrightarrow> D \<rhd> e:Q"
by (drule CutAux , simp)

lemma cut:"\<lbrakk> G \<rhd> ee : P ; (insert (ee, P) G) \<rhd> e : Q \<rbrakk> \<Longrightarrow> G \<rhd> e : Q"
by (drule CutAux , simp)

(*callInvokeContext G == true if G contains only entried for Calls or xxx_invokes*)
constdefs callInvokeContext::"vdmcontext \<Rightarrow> bool"
"callInvokeContext G == 
  (\<forall> e Q . (e,Q) : G \<longrightarrow> ((\<exists> f . e = Call f) \<or> 
                          (\<exists> x mn . e = x\<diamondsuit>\<diamondsuit>mn) \<or> (\<exists> C mn . e = C\<bullet>\<bullet>mn) \<or> 
                          (\<exists> x mn y . e = x\<diamondsuit>mn(y)) \<or> (\<exists> C mn y. e = C\<bullet>mn(y))))"


(*contextProvable G D == true if all entriesin G are provable from D*)
constdefs contextProvable::" vdmcontext \<Rightarrow>  vdmcontext \<Rightarrow> bool"
"contextProvable G D == (\<forall> e Q . (e, Q) : G \<longrightarrow> D \<rhd> e : Q)"

lemma cut2Aux:
"\<forall> G D . (finite G \<longrightarrow> D \<subseteq> G \<longrightarrow> card (G - D) = n \<longrightarrow> 
          (\<forall> e P. (G \<rhd> e : P \<longrightarrow> (contextProvable G D) \<longrightarrow> D \<rhd> e : P)))"
apply (induct n)
apply clarsimp
apply (subgoal_tac "G = D", simp)
defer 1
apply clarsimp
apply (erule_tac x=G in allE)
apply (erule impE, assumption)
apply (subgoal_tac "\<exists> ee P DDD . G - D = {(ee,P)} \<union> DDD \<and> (ee,P) \<notin> DDD \<and> card DDD = n")
apply (erule exE)+
apply (erule conjE)+
apply (erule_tac x="D \<union> {(ee,Pa)}" in allE)
apply (erule impE)
apply rule
apply (subgoal_tac "x:D \<or> x : {(ee,Pa)}")
apply (erule disjE, fast)
apply simp
apply (subgoal_tac "(ee, Pa) \<in> G - D", fast)
apply (subgoal_tac "(ee, Pa) \<in> insert (ee, Pa) DDD", simp)
apply fast
apply fast
apply (erule impE)
defer 1
apply (erule_tac x=e in allE, erule_tac x=P in allE)
apply clarify
apply (erule impE)
apply (simp add: contextProvable_def)
apply (insert CtxtWeak)
apply (rule, clarsimp)
apply (erule_tac x=ea in allE, erule_tac x=Q in allE)
apply (erule impE, assumption)
apply (subgoal_tac "(D \<union> {(ee,Pa)}) \<rhd>  ea : Q ")
apply (subgoal_tac "D \<union> {(ee,Pa)} = insert (ee, Pa) D", simp)
apply simp
apply (erule_tac thin_rl, erule_tac thin_rl, erule_tac thin_rl, erule_tac thin_rl, erule_tac thin_rl, erule_tac thin_rl)
apply (rotate_tac 2)
apply fast
(* end of the proof of contextprovable G - \<dots>*)
apply (rotate_tac -1, erule thin_rl)
apply (rule CCut)
apply (subgoal_tac "insert (ee, Pa) D \<rhd>  e : P", assumption)
apply (subgoal_tac "D \<union> {(ee,Pa)} = insert (ee, Pa) D", simp)
apply simp
apply (subgoal_tac "D \<rhd>  ee : Pa", assumption)
apply (subgoal_tac "(ee,Pa) \<in> G")
apply (simp add: contextProvable_def)
apply (subgoal_tac "(ee, Pa) \<in> G - D", fast)
apply (subgoal_tac "(ee, Pa) \<in> {(ee, Pa)} \<union> DDD", simp)
apply fast
apply simp
apply (rotate_tac 3, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
defer 1
apply fast
(*apply (rotate_tac 3, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rotate_tac 3, erule thin_rl)*)
apply (subgoal_tac "G - (D \<union> {(ee, Pa)}) = DDD", simp)
apply rule
apply rule
apply blast
apply rule
apply blast
apply (subgoal_tac "finite (G - D)")
(*prefer 2 apply *)
apply (case_tac "G - D = {}")
apply simp
apply (subgoal_tac "\<exists> x. x: (G - D)")
prefer 2 apply fast
apply (erule exE)
apply (rule_tac x="fst x" in exI)
apply (rule_tac x="snd x" in exI)
apply (rule_tac x="(G - D) - {x}" in exI)
apply rule
apply fastsimp
apply rule
apply fastsimp
apply (simp add: card_Diff_singleton)
apply (rule cardR_imp_finite)
apply (subgoal_tac "(G - D, Suc n) \<in> cardR", auto)
apply (simp add: card_def)
sorry(*trivial fact about cardR*)

lemma cut2:"\<lbrakk>finite G; G \<rhd> e : P; D \<subseteq> G; contextProvable G D\<rbrakk> \<Longrightarrow> D \<rhd> e : P"
apply (insert cut2Aux [of "card (G - D)"])
by (erule_tac x=G in allE, erule_tac x=D in allE, fastsimp)

subsection {* Mutual recursion *}

declare callInvokeContext_def[simp]

text {*
 For working with sets of mutually recursive functions/methodsm, we require that their
 specifications are collected in the following table.
*}

consts
  spectable  :: "funame \<Rightarrow> vdmassn"          -- {* specifications of functions *}
  Mspectable :: "cname \<Rightarrow> mname \<Rightarrow> vdmassn"  -- {* specifications of methods *}

text {* 
 We define what it means for a context to be consistent with the above tables.
*}

constdefs consistent::" vdmcontext \<Rightarrow> bool"
"consistent G == 
((\<forall> f P. (Call f, P) : G \<longrightarrow> (P = spectable f \<and> G \<rhd> funtable f: {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> P})) \<and> 
 (\<forall> C mn P. (C\<bullet>\<bullet>mn, P) : G \<longrightarrow> (P = Mspectable C mn \<and> G \<rhd> methtable C mn: {(E,h,hh,v,p) . (E,h,hh,v,\<langle>2 0 1 1\<rangle> \<oplus> p) \<in> P})) \<and> 
 (\<forall> mn x P. (x\<diamondsuit>\<diamondsuit>mn, P) : G \<longrightarrow> ((\<exists> C . P = Mspectable C mn) \<and> 
                                 (\<forall> C . G \<rhd> methtable C mn: 
                                           {(E',h,hh,v,p) . \<forall> E . classOf E h x C \<and> E' = E\<lfloor>self := E\<lfloor>x\<rfloor>\<rfloor> \<longrightarrow>
                                                                  (E,h,hh,v,\<langle>4 0 1 1\<rangle> \<oplus> p) \<in> P}))) \<and> 
 (\<forall> C mn y P. (C\<bullet>mn(y), P) : G \<longrightarrow> (P = Mspectable C mn \<and> 
                                     G \<rhd> methtable C mn: 
                                         {(E,h,hh,v,p) . \<forall> E'. E = newframe_env Nullref (E'\<lfloor>y\<rfloor>)  \<longrightarrow> 
                                                        (E',h,hh,v,\<langle>3 0 1 1\<rangle> \<oplus> p) \<in> P})) \<and>
 (\<forall> x mn y P. (x\<diamondsuit>mn(y), P) : G \<longrightarrow> ((\<exists> C . P = Mspectable C mn) \<and> 
                                     (\<forall> C . G \<rhd> methtable C mn: 
                                              {(E,h,hh,v,p) . \<forall> E'. classOf E' h x C \<and> E = newframe_env (E'\<lfloor>x\<rfloor>) (E'\<lfloor>y\<rfloor>) \<longrightarrow>
                                                             (E',h,hh,v,\<langle>5 0 1 1\<rangle> \<oplus> p) \<in> P}))))"

lemma consistent_preserved: "\<lbrakk>consistent G; callInvokeContext G; (e,Q):G\<rbrakk> \<Longrightarrow> consistent (G - {(e,Q)})"
apply (simp add: consistent_def, clarsimp)
apply (subgoal_tac "(G - {(e,Q)}) \<rhd> e:Q")(*now use the subgoal (G - {(e,Q)}) \<rhd> e:Q to prove the goal*)
apply (subgoal_tac "G = insert (e, Q) (G - {(e, Q)})") prefer 2 apply fast
apply (rule, clarify)
(*case call*)
apply (erule_tac x=f in allE, erule_tac x=P in allE, clarsimp)
apply (rule cut, assumption, simp)
apply (rule, clarify)
(*case mhinvokestatic*)
apply (erule_tac x=C in allE, erule_tac x=mn in allE, erule_tac x=P in allE, clarsimp)
apply (rule cut, assumption, simp)
apply (rule, clarify)
(*case mhinvoke*)
apply (rotate_tac 2)
apply (erule thin_rl, erule thin_rl)
apply (erule_tac x=mn in allE, erule_tac x=x in allE, erule_tac x=P in allE, clarsimp)
apply (rule cut, assumption, simp)
apply (rule, clarify)
(*case invokestatic*)
apply (rotate_tac 1) apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule_tac x=C in allE, erule_tac x=mn in allE, erule_tac x=y in allE, erule_tac x=P in allE, clarsimp)
apply (rule cut, assumption, simp)
apply clarsimp
(*case invoke*)
apply (rotate_tac 2)
apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (erule_tac x=x in allE, erule_tac x=mn in allE, erule_tac x=y in allE, erule_tac x=P in allE, clarsimp)
apply (erule_tac x=C in allE)
apply (rule cut, assumption, simp)
(* now prove the subgoal (G - {(e, Q)}) \<rhd>  e : Q *)
  apply (erule_tac x=e in allE)
  apply (subgoal_tac "(\<exists>f. e = CALL f) \<or> (\<exists>x mn. e = x\<diamondsuit>\<diamondsuit>mn) \<or> (\<exists>C mn. e = C\<bullet>\<bullet>mn) \<or> 
                      (\<exists>x mn y. e = x\<diamondsuit>mn(y)) \<or> (\<exists>C mn y. e = C\<bullet>mn(y))") 
  apply (rotate_tac -2, erule thin_rl)
  prefer 2 apply(subgoal_tac "(\<exists>Q. (e, Q) \<in> G)", clarsimp) apply (rule_tac x=Q in exI, simp)
  apply (erule disjE, clarify)
  (*case call*)
  apply (rotate_tac 2, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
  apply (rule vdm_call)
  apply (subgoal_tac "G = insert (CALL f, Q) (G - {(CALL f, Q)})")
  apply clarsimp
  apply fastsimp
  apply (erule disjE, clarify)
  (* case mhinvoke *)
  apply (rotate_tac 1, erule thin_rl, erule thin_rl)
  apply (rotate_tac 1, erule thin_rl, erule thin_rl)
  apply (rule vdm_mhinvoke)
  apply clarsimp
  apply (subgoal_tac "G = insert (x\<diamondsuit>\<diamondsuit>mn,Q) (G - {(x\<diamondsuit>\<diamondsuit>mn, Q)})")
  apply clarsimp
  apply fastsimp
  apply (erule disjE, clarify)
  (*case mhinvokestatic*)
  apply (rotate_tac 1, erule thin_rl)
  apply (rotate_tac 1, erule thin_rl, erule thin_rl, erule thin_rl)
  apply (rule vdm_mhinvokestatic)
  apply (subgoal_tac "G = insert (C\<bullet>\<bullet>mn, Q) (G - {(C\<bullet>\<bullet>mn, Q)})")
  apply clarsimp
  apply fastsimp
  apply (erule disjE, clarify)
  (* case invoke *)
  apply (rotate_tac 1, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
  apply (rule vdm_invoke)
  apply clarsimp
  apply (subgoal_tac "G = insert (x\<diamondsuit>mn(y), Q) (G - {(x\<diamondsuit>mn(y), Q)})")
  apply clarsimp
  apply fastsimp
  (* case invokestatic *)
  apply (rotate_tac 1, erule thin_rl, erule thin_rl, erule thin_rl)
  apply (rotate_tac 1, erule thin_rl) 
  apply clarsimp
  apply (rule vdm_invokestatic) 
  apply (subgoal_tac "G = insert (C\<bullet>mn(y), Q) (G - {(C\<bullet>mn(y), Q)})")
  apply clarsimp 
  apply fastsimp  
done

subsection {* Rule for mutual recursion *}

lemma MUTREClemma: 
"\<forall> G . ((finite G \<and> card G = n \<and> callInvokeContext G \<and> consistent G \<and> (e,P) : G) \<longrightarrow> \<rhd> e:P)"
apply (induct n)
(*case n=0*)
apply clarsimp
(*Case n>0*)
apply clarsimp
apply (case_tac "G = {(e,P)}")
apply clarsimp
apply (erule_tac x="{(e,P)}" in allE)
apply (erule disjE, clarsimp, simp add:consistent_def)
apply (rule vdm_call, clarsimp)
apply (erule disjE, clarsimp, simp add:consistent_def)
apply (rule vdm_mhinvoke, clarsimp)
apply (erule disjE, clarsimp, simp add:consistent_def)
apply (rule vdm_mhinvokestatic, clarsimp)
apply (erule disjE, clarsimp, simp add:consistent_def)
apply (rule vdm_invoke, clarsimp)
apply (clarsimp, simp add:consistent_def) 
apply (rule vdm_invokestatic, clarsimp)
(*Case G has more entries than (e,P)*) 
apply (subgoal_tac "\<exists> ee Q . (ee,Q) \<noteq> (e,P) \<and> (ee,Q) : G")
prefer 2
apply (rotate_tac 2)
apply (erule thin_rl, erule thin_rl)
apply (rotate_tac 1)
apply (erule thin_rl)
apply fastsimp
(* use the fact that there is another pair (ee,Q):G*)
apply clarsimp
apply (subgoal_tac "(G - {(ee,Q)}) \<rhd> ee: Q")
apply (erule_tac x="G - {(ee, Q)}" in allE)
apply (subgoal_tac "consistent (G - {(ee, Q)})", simp)
prefer 2 apply (simp add: consistent_preserved)
apply (subgoal_tac "card (G - {(ee, Q)}) = n", simp)
prefer 2 apply (simp add: card_Diff_singleton) 
apply clarsimp
apply (case_tac "e = ee", clarsimp)
apply (case_tac "P = Q", clarsimp, clarsimp)
apply (case_tac "ea = e", clarsimp)
apply (erule_tac x=e in allE, simp)
apply clarsimp
apply (erule_tac x=ea in allE, simp)
apply clarsimp
apply (case_tac "ea = ee", clarsimp)
apply (erule_tac x=ee in allE, simp)
apply clarsimp
apply (erule_tac x=ea in allE, simp)
(*the proof for (G - {(ee, Q)}) \<rhd>  ee : Q *)
  apply (erule_tac x=ee in allE)
  apply (subgoal_tac "(\<exists>f. ee = CALL f) \<or> (\<exists>x mn. ee = x\<diamondsuit>\<diamondsuit>mn) \<or> (\<exists>C mn. ee = C\<bullet>\<bullet>mn) \<or> 
                      (\<exists>x mn y. ee = x\<diamondsuit>mn(y)) \<or> (\<exists>C mn y. ee = C\<bullet>mn(y))", clarsimp)
  prefer 2 apply(subgoal_tac "(\<exists>Q. (ee, Q) \<in> G)", simp) apply(rule_tac x=Q in exI, simp)
  apply (erule disjE, clarsimp)
  (*case call*)
    apply (rule vdm_call)
    apply (subgoal_tac "G - {(CALL f, Q)} \<union> {(CALL f, Q)} = G")
    prefer 2 apply fast
    apply clarsimp
    apply (rotate_tac 4) apply (erule thin_rl)
    (*before unfolding consistent, we first bring the other 4 cases to the same state as this goal*)
  defer 1
  apply (erule disjE, clarsimp)
  (*case mhinvoke*)
    apply (rule vdm_mhinvoke, clarsimp)
    apply (subgoal_tac "insert (x\<diamondsuit>\<diamondsuit>mn, Q) (G - {(x\<diamondsuit>\<diamondsuit>mn, Q)}) = G")
    prefer 2 apply fast
    apply clarsimp
    apply (rotate_tac 4) apply (erule thin_rl)
  defer 1
  apply (erule disjE, clarsimp)
  (*case mhinvokestatic*)
    apply (rule vdm_mhinvokestatic)
    apply (subgoal_tac "G - {(C\<bullet>\<bullet>mn, Q)} \<union> {(C\<bullet>\<bullet>mn, Q)} = G")
    prefer 2 apply fast
    apply clarsimp
    apply (rotate_tac 4) apply (erule thin_rl)
  defer 1    
  apply (erule disjE, clarsimp)
  (*case invoke*)
    apply (rule vdm_invoke, clarsimp)
    apply (subgoal_tac "insert (x\<diamondsuit>mn(y), Q) (G - {(x\<diamondsuit>mn(y), Q)}) = G")
    prefer 2 apply fast
    apply clarsimp
    apply (rotate_tac 4) apply (erule thin_rl)
  defer 1
  (*case invokestatic*)
    apply clarsimp
    apply (rule vdm_invokestatic)
    apply (subgoal_tac "G - {(C\<bullet>mn(y), Q)} \<union> {(C\<bullet>mn(y), Q)} = G")
    prefer 2 apply fast
    apply clarsimp
    apply (rotate_tac 4) apply (erule thin_rl)
  defer 1
  (* back to case call*)
  apply (unfold consistent_def)
  apply (erule conjE)
  apply (erule_tac x=f in allE, erule_tac x="Q" in allE, clarsimp)
  (*case mhinvoke*)
  apply (erule conjE)
  apply (rotate_tac 7, erule thin_rl) (* dont need the assumtion for calls *)
  apply (erule conjE)
  apply (rotate_tac 7, erule thin_rl) (* dont need the assumtion for mhinvokestatic *)
  apply (erule conjE)
  apply (erule_tac x=mn in allE, erule_tac x=x in allE, erule_tac x="Q" in allE, simp)
  (* case mhinvokestatic*)
  apply (erule conjE)
  apply (rotate_tac 7, erule thin_rl) (*dont need the assumtion for calls*)
  apply (erule conjE)
  apply (erule_tac x=C in allE, erule_tac x=mn in allE, erule_tac x="Q" in allE, clarsimp)
  (* case invoke*)
  apply (erule conjE)
  apply (rotate_tac 7, erule thin_rl) (* dont need the assumtion for calls *)
  apply (erule conjE)
  apply (rotate_tac 7, erule thin_rl) (* dont need the assumtion for mhinvokestatic *)
  apply (erule conjE)
  apply (rotate_tac 7, erule thin_rl) (* dont need the assumtion for mhinvoke *)
  apply (erule conjE)
  apply (rotate_tac 7, erule thin_rl) (* dont need the assumtion for invokestatic *)
  apply (erule_tac x=x in allE, erule_tac x=mn in allE, erule_tac x=y in allE, erule_tac x="Q" in allE, simp)
  (* case invokestatic*)
  apply (erule conjE)
  apply (rotate_tac 7, erule thin_rl) (*dont need the assumtion for calls*)
  apply (erule conjE)
  apply (rotate_tac 7, erule thin_rl) (*dont need the assumtion for mhinvokestatic*)
  apply (erule conjE)
  apply (rotate_tac 7, erule thin_rl) (* dont need the assumtion for mhinvoke*)
  apply (erule conjE)
  apply (erule_tac x=C in allE, erule_tac x=mn in allE, 
         erule_tac x=y in allE, erule_tac x="Q" in allE, clarsimp)
done


text {*
 This is the rule we use for proving properties over mutually recursive functions/methods.
*}

theorem MUTREC:
"\<lbrakk> finite G; card G = n; callInvokeContext G; consistent G; (e,P) : G \<rbrakk> \<Longrightarrow> \<rhd> e:P"
by (insert MUTREClemma [of n e P], fast)

end
