theory VDMcomb = Lemmas:

consts all_classes :: "cname set"

(*axioms finclasses: "\<forall> (C::cname). C \<in> all_classes \<and> finite all_classes"*)

(*derivation system for VDM*)

section {* Basic types *}
types
  "valExpr" = "[env, heap, val] \<Rightarrow> bool"
types
  "heapExpr" = "[env, heap, heap] \<Rightarrow> bool"

types 
  "costExpr" = "[env, heap, rescomp] \<Rightarrow> bool"

types
  "vdmassn" = "[env,  heap,  heap,  val,  rescomp] \<Rightarrow> bool"

types
   vdmtuple = " expr \<times> vdmassn"

types
   vdmcontext = " vdmtuple set"

constdefs HSize ::"heap \<Rightarrow> int"
"HSize h == int (card (fmap_dom (heap.oheap h)))"
declare HSize_def [simp]

lemma SizeInsert[simp]: "int (card (insert (freshloc (fmap_dom H))
(fmap_dom H))) = int (card (fmap_dom H)) + 1"
apply (subgoal_tac "card (insert (freshloc (fmap_dom H)) (fmap_dom H)) =
Suc (card (fmap_dom H))")
apply simp
apply (rule card_insert_disjoint)
apply fastsimp
apply (rule freshloc, fastsimp)
done

constdefs constVE:: "val \<Rightarrow> valExpr" 
"constVE w E h v == (w = v) "
constdefs ivarVE:: "iname \<Rightarrow> valExpr"
"ivarVE x E h v == (\<exists> i. E<x> = i \<and> v = IVal i)"
constdefs rvarVE:: "rname \<Rightarrow> valExpr"
"rvarVE x E h v == (\<exists> r. E\<lfloor>x\<rfloor> = r \<and> v = RVal r)"
constdefs idotVE::"valExpr \<Rightarrow> ifldname \<Rightarrow> valExpr"
"idotVE ve f E h v == (\<exists> l. ve E h (RVal (Ref l)) \<and> constVE (IVal(h<l\<bullet>f>)) E h v)"
constdefs rdotVE::"valExpr \<Rightarrow> rfldname \<Rightarrow> valExpr"
"rdotVE ve f E h v == (\<exists> l. ve E h (RVal (Ref l)) \<and> constVE (RVal(h\<lfloor>l\<diamondsuit>f\<rfloor>)) E h v)"
constdefs iopVE::"valExpr \<Rightarrow> (int \<Rightarrow> int \<Rightarrow> int) \<Rightarrow> valExpr \<Rightarrow> valExpr"
"iopVE ve1 f ve2 E h v == (\<exists> i1 i2. ve1 E h (IVal i1) \<and> ve2 E h (IVal i2) \<and> v = IVal (f i1 i2))"
constdefs ropVE::"valExpr \<Rightarrow> (ref \<Rightarrow> ref \<Rightarrow> int) \<Rightarrow> valExpr \<Rightarrow> valExpr"
"ropVE ve1 f ve2 E h v == (\<exists> r1 r2. ve1 E h (RVal r1) \<and> ve2 E h (RVal r2) \<and> v = IVal (f r1 r2))"

constdefs Same::heapExpr
"Same E h hh == (h = hh)"
constdefs iUpd::"heapExpr \<Rightarrow> valExpr \<Rightarrow> ifldname \<Rightarrow> valExpr \<Rightarrow> heapExpr"
"iUpd he ve1 f ve2 E h hh == (\<exists> h' . he E h h' \<and> (\<exists> l i. hh = h'\<lparr>iheap := (iheap h')(f := (iheap h' f)(l:=i))\<rparr> \<and> 
                                                         ve1 E h' (RVal (Ref l)) \<and> 
                                                         ve2 E h' (IVal i)))"
constdefs rUpd::"heapExpr \<Rightarrow> valExpr \<Rightarrow> rfldname \<Rightarrow> valExpr \<Rightarrow> heapExpr"
"rUpd he ve1 f ve2 E h hh == (\<exists> h' . he E h h' \<and> (\<exists> l r. hh = h'\<lparr>rheap := (rheap h')(f := (rheap h' f)(l:=r))\<rparr> \<and> 
                                                         ve1 E h' (RVal (Ref l)) \<and> 
                                                         ve2 E h' (RVal r)))"
constdefs extendHE::"heapExpr \<Rightarrow> cname \<Rightarrow> locn \<Rightarrow> (ifldname \<times> iname) list \<Rightarrow> (rfldname \<times> rname) list \<Rightarrow> heapExpr"
"extendHE he c l iflds rflds E h hh == (\<exists> h' . he E h h' \<and> (l = freshloc (fmap_dom (heap.oheap h'))) \<and> (hh = newObj h' l E c iflds rflds))"

constdefs ResultIs::"valExpr \<Rightarrow> vdmassn"
"ResultIs ve E h hh v p == ve E h v"
constdefs HeapIs::"heapExpr \<Rightarrow> vdmassn"
"HeapIs he E h hh v p == he E h hh"

constdefs ticks::"valExpr \<Rightarrow> vdmassn"
"ticks ve E h hh v p == (\<exists> i. ve E h (IVal i) \<and> clock p = i)"
constdefs calls::"valExpr \<Rightarrow> vdmassn"
"calls ve E h hh v p == (\<exists> i. ve E h (IVal i) \<and> callc p = i)"
constdefs invokes::"valExpr \<Rightarrow> vdmassn"
"invokes ve E h hh v p == (\<exists> i. ve E h (IVal i) \<and> invkc p = i)"
constdefs depth::"valExpr \<Rightarrow> vdmassn"
"depth ve E h hh v p == (\<exists> i. ve E h (IVal i) \<and> (int (invkdpth p)) = i)"
constdefs allocates::"valExpr \<Rightarrow> vdmassn"
"allocates ve E h hh v p == ve E h (IVal ((HSize hh) - (HSize h)))"

constdefs AND:: "[vdmassn, vdmassn] \<Rightarrow> vdmassn" (infixr "&&" 0)
"AND ve1 ve2 E h hh v p == (ve1 E h hh v p \<and> ve2 E h hh v p)"

constdefs costs::"[int, int, int, int, nat] \<Rightarrow> vdmassn "
"costs a t c i d == (allocates (constVE (IVal a)) && ticks (constVE (IVal t)) &&
                     calls (constVE (IVal c)) && invokes (constVE (IVal i)) &&
                     depth (constVE (IVal (int d))))"

constdefs tickCosts::"int \<Rightarrow> vdmassn"
"tickCosts t == costs 0 t 0 0 0"

consts vdmcomb_proof :: "( vdmcontext \<times>  vdmtuple) set"

syntax
  vdmcomb_deriv :: " vdmcontext \<Rightarrow>  expr \<Rightarrow> vdmassn \<Rightarrow> bool"
		  ("_ \<rhd>  _ :: _ " [900,100,100] 50)

translations
 "G \<rhd> e :: P" == "(G,e,P) \<in> vdmcomb_proof"

syntax
  vdm_emptyctx_comb :: " expr \<Rightarrow> vdmassn \<Rightarrow> bool" ("\<rhd> _ :: _ " 40)
translations
  "\<rhd> e :: P " == "{} \<rhd> e :: P"

(* ---------------------------------------------------------------------------
*)
(* ToDo: move this into a separate file and sort out dependencies *)

section {* Aux functions and lemmas for context adaptation *}

subsection {* Well-structured heaps etc *}

constdefs classOf :: "env \<Rightarrow> heap \<Rightarrow> rname \<Rightarrow> cname \<Rightarrow> bool"
 "classOf E h x C == (\<exists> a . E\<lfloor>x\<rfloor> = Ref a \<and> h @@ a = Some C)"

constdefs condComb:: "iname \<Rightarrow> vdmassn \<Rightarrow> vdmassn \<Rightarrow> vdmassn"
"condComb x P1 P2 E h hh v p == (\<exists> pp . p = tkn 2 pp \<and> (E<x> = grailbool True \<or> E<x> = grailbool False) \<and>
                                 (if E<x> = grailbool True then (P1  E h hh v pp) else (P2 E h hh v pp)))"

constdefs letiComb:: "iname \<Rightarrow> vdmassn \<Rightarrow> vdmassn \<Rightarrow> vdmassn"
"letiComb x P1 P2 E h hh v p == (\<exists> p1 p2 h1 i . (P1 E h h1 (IVal i) p1) \<and>
                                               (P2 (E<x:=i>) h1 hh v p2) \<and>
                                               p = tk (p1 \<smile> p2))"

constdefs letrComb:: "rname \<Rightarrow> vdmassn \<Rightarrow> vdmassn \<Rightarrow> vdmassn"
"letrComb x P1 P2 E h hh v p == (\<exists> p1 p2 h1 r . (P1 E h h1 (RVal r) p1) \<and>
                                               (P2 (E\<lfloor>x:=r\<rfloor>) h1 hh v p2) \<and>
                                               p = tk (p1 \<smile> p2))"
constdefs letvComb:: "vdmassn \<Rightarrow> vdmassn \<Rightarrow> vdmassn"
"letvComb P1 P2 E h hh v p == (\<exists> p1 p2 h1 w . (P1 E h h1 w p1) \<and> (P2  E h1 hh v p2) \<and> p = (p1 \<smile> p2))"

constdefs tkCallAssn::"vdmassn \<Rightarrow> vdmassn"
"tkCallAssn P E h hh v p == P E h hh v (tkcall p)"

constdefs impliesAssn::"vdmassn \<Rightarrow> vdmassn \<Rightarrow> vdmassn"
"impliesAssn P Q E h hh v p == (P E h hh v p \<longrightarrow> Q E h hh v p)"

constdefs IMPLIES::"vdmassn \<Rightarrow> vdmassn \<Rightarrow> bool"
"IMPLIES P Q == (\<forall> E h hh v p . (P  E h hh v p ) \<longrightarrow> (Q  E h hh v p))"

constdefs EXloc::"(locn \<Rightarrow> vdmassn) \<Rightarrow> vdmassn"
"EXloc P E h hh v p== (\<exists> l . P l E h hh v p)"

constdefs ALLnat::"(nat \<Rightarrow> vdmassn) \<Rightarrow> vdmassn"
"ALLnat P E h hh v p == (\<forall> n . P n E h hh v p)"

inductive vdmcomb_proof intros

vdm_null: "G \<rhd> NULL :: ((HeapIs Same) && (ResultIs (constVE (RVal Nullref)))
                                       && (tickCosts 1))"

vdm_int: "G \<rhd> expr.Int i :: ((HeapIs Same) && (ResultIs (constVE (IVal i))) && (tickCosts 1))"

vdm_ivar: "G \<rhd> IVar x :: ((HeapIs Same) && (ResultIs (ivarVE x)) && (tickCosts 1))"

vdm_rvar: "G \<rhd> RVar x :: ((HeapIs Same) && (ResultIs (rvarVE x)) && (tickCosts 1))"

vdm_prim: "G \<rhd> Primop f x y :: ((HeapIs Same) && (ResultIs (iopVE (ivarVE x) f (ivarVE y))) && (tickCosts 3))"

vdm_rprim: "G \<rhd> RPrimop f x y :: ((HeapIs Same) && (ResultIs (ropVE (rvarVE x) f (rvarVE y))) && (tickCosts 3))"

vdm_getfi: "G \<rhd> GetFi x f :: ((HeapIs Same) && (ResultIs (idotVE (rvarVE x) f)) && (tickCosts 2))"

vdm_getfr: "G \<rhd> GetFr x f :: ((HeapIs Same) && (ResultIs (rdotVE (rvarVE x) f)) && (tickCosts 2))"

vdm_putfi: "G \<rhd> PutFi x f y :: ((HeapIs (iUpd Same (rvarVE x) f (ivarVE y))) &&
                                 (ResultIs (constVE arbitrary)) && (tickCosts 3))"

vdm_putfr: "G \<rhd> PutFr x f y :: ((HeapIs (rUpd Same (rvarVE x) f (rvarVE y))) &&
                                 (ResultIs (constVE arbitrary)) && (tickCosts 3))"
vdm_if: "\<lbrakk>G \<rhd> e1 :: P1; G \<rhd> e2 :: P2\<rbrakk> \<Longrightarrow> G \<rhd> (IF x THEN e1 ELSE e2) :: (condComb x P1 P2)"

vdm_leti: "\<lbrakk>G \<rhd> e1 :: P1; G \<rhd> e2 :: P2\<rbrakk> \<Longrightarrow> G \<rhd> (Leti x e1 e2) :: letiComb x P1 P2"

vdm_letr: "\<lbrakk>G \<rhd> e1 :: P1; G \<rhd> e2 :: P2\<rbrakk> \<Longrightarrow> G \<rhd> (Letr x e1 e2) :: letrComb x P1 P2"

vdm_letv: "\<lbrakk>G \<rhd> e1 :: P1; G \<rhd> e2 :: P2\<rbrakk> \<Longrightarrow> G \<rhd> (Letv e1 e2) :: letvComb P1 P2"

vdm_call: "\<lbrakk>(G \<union> {(Call f, P)}) \<rhd> (funtable f) :: tkCallAssn P\<rbrakk> \<Longrightarrow>  G \<rhd> (Call f) :: P"

vdm_ax: "\<lbrakk> (e,P) \<in> G \<rbrakk> \<Longrightarrow> G \<rhd> e :: P"

vdm_conseq: "\<lbrakk>G \<rhd> e :: P; IMPLIES P Q\<rbrakk> \<Longrightarrow> G \<rhd> e :: Q"

vdm_new: "G \<rhd> New c iflds rflds :: 
          EXloc (\<lambda> l . (HeapIs (extendHE Same c l iflds rflds) &&
                        ResultIs (constVE (RVal (Ref l))) &&
                        costs 1 1 0 0 0))"
(*
vdm_iff: "\<lbrakk> G \<rhd> e1 :: (HeapIs he1 && ResultIs ve1);  G \<rhd> e2 :: (HeapIs he2 && ResultIs ve2)\<rbrakk> \<Longrightarrow>
          G \<rhd> (IF x THEN e1 ELSE e2) :: (HeapIs (condHeap x he1 he2) && ResultIs (condRes x ve1 ve2) && costs\<dots>)"

constdefs condHeap :: "iname \<Rightarrow> heapExpr \<Rightarrow> heapExpr \<Rightarrow> heapExpr"
"condHeap x he1 he2 E h hh == ((E<x> = grailbool True) \<longrightarrow> he1 E h hh \<and>
                               (E<x> = grailbool False) \<longrightarrow> he2 E h hh)"
condRes :: "iname \<Rightarrow> valExpr \<Rightarrow> valExpr \<Rightarrow> valExpr"
"condRes x ve1 ve2 E h v == ((E<x> = grailbool True) \<longrightarrow> ve1 E h v \<and>
                               (E<x> = grailbool False) \<longrightarrow> ve2 E h v)"
*)
lemmas valExpr_predicates = constVE_def ivarVE_def rvarVE_def idotVE_def rdotVE_def 
                            iopVE_def ropVE_def
lemmas cost_predicates = tickCosts_def costs_def allocates_def ticks_def calls_def invokes_def depth_def
lemmas heap_predicates = iUpd_def rUpd_def Same_def extendHE_def
lemmas logic_predicates = AND_def IMPLIES_def EXloc_def
lemmas assn_predicates = HeapIs_def ResultIs_def condComb_def letiComb_def letrComb_def 
                         letvComb_def tkCallAssn_def
lemmas predicates = assn_predicates valExpr_predicates heap_predicates cost_predicates
                    logic_predicates

lemma IFcomb:
  "(condComb x P1 P2) = 
   (\<lambda> E h hh v p . \<exists> pp. p = tkn 2 pp \<and> 
                               (E<x> = grailbool True \<longrightarrow> (P1  E h hh v pp  )) \<and> 
                               (E<x> = grailbool False \<longrightarrow> (P2  E h hh v pp  )) \<and>
                               (E<x> = grailbool True \<or> E<x> = grailbool False))"
apply rule
apply rule
apply rule
apply rule
apply rule
apply rule
apply (simp_all add:predicates)
apply auto
done

lemma LETIcomb:
  "letiComb x P1 P2 =
   (\<lambda> E h hh v p  . \<exists> p1 p2 h1 i . (P1 E h h1 (IVal i) p1) \<and> (P2 (E<x:=i>) h1 hh v p2) \<and> p = tk (p1 \<smile> p2))"
apply rule
apply rule
apply rule
apply rule
apply rule
apply rule
apply (simp_all add:predicates)
done

lemma LETRcomb:
  "letrComb x P1 P2 =
   (\<lambda> E h hh v p  . \<exists> p1 p2 h1 r . (P1 E h h1 (RVal r) p1) \<and> (P2 (E\<lfloor>x:=r\<rfloor>) h1 hh v p2) \<and> p = tk (p1 \<smile> p2))"
apply rule
apply rule
apply rule
apply rule
apply rule
apply rule
apply (simp_all add:predicates)
done

lemma LETVcomb:
  "letvComb P1 P2 =
   (\<lambda> E h hh v p  . \<exists> p1 p2 h1 w . (P1 E h h1 w p1) \<and> (P2  E h1 hh v p2) \<and> p = (p1 \<smile> p2))"
apply rule
apply rule
apply rule
apply rule
apply rule
apply rule
apply (simp_all add:predicates)
done

lemma NEWcomb:
  "EXloc (\<lambda> l . (HeapIs (extendHE Same c l iflds rflds) &&
                        ResultIs (constVE (RVal (Ref l))) &&
                        costs 1 1 0 0 0))=
   (\<lambda> E h hh v p  . \<exists> l . l = freshloc (fmap_dom (heap.oheap h)) \<and> 
                                    hh = newObj h l E c iflds rflds \<and>
                                    v = RVal (Ref l) \<and>
                                    p = tickRo)" 
apply rule
apply rule
apply rule
apply rule
apply rule
apply rule
apply (simp only: EXloc_def)
apply (simp_all add:predicates newObj_def)
done

lemma NULLcomb:
      "((HeapIs Same) && (ResultIs (constVE (RVal Nullref))) && (tickCosts 1)) =
       (\<lambda>  E h  hh  v  p . hh = h \<and> v = RVal Nullref \<and> p = tickRo)"
by (rule+, (simp add: predicates)+)
lemma INTcomb:
      "((HeapIs Same) && (ResultIs (constVE (IVal i))) && (tickCosts 1)) = 
       (\<lambda>  E h hh v p . hh = h \<and> v = IVal i \<and> p = tickRo)"
by (rule+, (simp add: predicates)+)
lemma IVARcomb:
      "((HeapIs Same) && (ResultIs (ivarVE x)) && (tickCosts 1)) = 
       (\<lambda> E h hh v p . hh = h \<and> v = IVal (E<x>) \<and> p = tickRo)"
by (rule+, (simp add: predicates)+)
lemma RVARcomb:
      "((HeapIs Same) && (ResultIs (rvarVE x)) && (tickCosts 1)) = 
       (\<lambda> E h hh v p . hh = h \<and> v = RVal (E\<lfloor>x\<rfloor>) \<and> p = tickRo)"
by (rule+, (simp add: predicates)+)
lemma PRIMcomb:
      "((HeapIs Same) && (ResultIs (iopVE (ivarVE x) f (ivarVE y))) && (tickCosts 3)) =
       (\<lambda> E h hh v p  . hh = h \<and> v = IVal (f (E<x>) (E<y>)) \<and> p = \<langle>3 0 0 0\<rangle>)"
by (rule+, (simp add: predicates)+)
lemma RPRIMcomb:
      "((HeapIs Same) && (ResultIs (ropVE (rvarVE x) f (rvarVE y))) && (tickCosts 3)) =
       (\<lambda> E h hh v p  . hh = h \<and> v = IVal (f (E\<lfloor>x\<rfloor>) (E\<lfloor>y\<rfloor>)) \<and> p = \<langle>3 0 0 0\<rangle>)"
by (rule+, (simp add: predicates)+)
lemma GETFIcomb:
      "\<forall> x f .
       ((HeapIs Same) && (ResultIs (idotVE (rvarVE x) f)) && (tickCosts 2)) =
       (\<lambda> E h hh v p  . \<exists> a . E\<lfloor>x\<rfloor> = Ref a \<and> hh = h \<and> v = IVal ((heap.iheap hh) f a) \<and> p = \<langle>2 0 0 0\<rangle> )"
apply rule
apply rule
apply rule
apply rule
apply rule
apply rule
apply rule
apply rule
apply (simp_all add: predicates)
apply clarsimp
apply (rule_tac x=l in exI, simp)
apply clarsimp
done
lemma GETFRcomb:
  "((HeapIs Same) && (ResultIs (rdotVE (rvarVE x) f)) && (tickCosts 2)) =
   (\<lambda> E h hh v p  . \<exists> a . E\<lfloor>x\<rfloor> = Ref a \<and> hh = h \<and> v = RVal ((heap.rheap hh) f a) \<and> p = \<langle>2 0 0 0\<rangle>)"
apply rule
apply rule
apply rule
apply rule
apply rule
apply rule
apply (simp_all add: predicates)
apply clarsimp
apply (rule_tac x=l in exI, simp)
apply clarsimp
done
lemma PUTFIcomb: 
  "((HeapIs (iUpd Same (rvarVE x) f (ivarVE y))) && (ResultIs (constVE arbitrary)) && (tickCosts 3)) = 
   (\<lambda> E h hh v p  . \<exists> a . E\<lfloor>x\<rfloor>  = Ref a \<and> hh = h<a\<bullet>f:=E<y>> \<and> v = arbitrary \<and>  p = \<langle>3 0 0 0\<rangle>)"
apply rule
apply rule
apply rule
apply rule
apply rule
apply rule
apply (simp_all add: predicates)
apply clarsimp
apply (rule_tac x=l in exI, simp)
apply auto
done
lemma PUTFRcomb: 
  "((HeapIs (rUpd Same (rvarVE x) f (rvarVE y))) && (ResultIs (constVE arbitrary)) && (tickCosts 3)) =
   (\<lambda> E h hh v p  . \<exists> a . E\<lfloor>x\<rfloor>  = Ref a \<and> hh = h\<lfloor>a\<diamondsuit>f:=E\<lfloor>y\<rfloor>\<rfloor> \<and> v = arbitrary \<and> p = \<langle>3 0 0 0\<rangle>)"
apply rule
apply rule
apply rule
apply rule
apply rule
apply rule
apply (simp_all add: predicates)
apply clarsimp
apply (rule_tac x=l in exI, simp)
apply auto
done

lemmas vdm_basics = vdm_null vdm_int vdm_ivar vdm_rvar vdm_prim vdm_rprim
vdm_getfi vdm_getfr vdm_putfi vdm_putfr vdm_if vdm_leti vdm_letr
vdm_letv  vdm_new 
(*vdmbasics :lemmas vdm_calls = vdm_call vdm_mhinvokestatic vdm_mhinvoke*)

(*Elimination rules*) 
lemma IconstElim:
      "\<lbrakk>letiComb x (HeapIs Same && ResultIs (constVE (IVal i)) && tickCosts n) Q E h hh v p;
        \<lbrakk>Q (E<x:=i>) h hh v (tkn (- n - 1) p)\<rbrakk> \<Longrightarrow> R
       \<rbrakk>  \<Longrightarrow> R"
by (simp add: predicates, clarsimp,
    subgoal_tac "p2 = (mkRescomp (clock p2) (callc p2) (invkc p2) (invkdpth p2))", auto)

lemma RConstElim:
      "\<lbrakk>letrComb x (HeapIs Same && ResultIs (constVE (RVal r)) && tickCosts n) Q E h hh v p;
        \<lbrakk>Q (E\<lfloor>x:=r\<rfloor>) h hh v (tkn (- n - 1) p)\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates, clarsimp,
    subgoal_tac "p2 = (mkRescomp (clock p2) (callc p2) (invkc p2) (invkdpth p2))", auto)

lemma IVarElim:
      "\<lbrakk>letiComb x (HeapIs Same && ResultIs (ivarVE y) && tickCosts n) Q E h hh v p;
        (ivarVE y) E h (IVal i);
        \<lbrakk>Q (E<x:=i>) h hh v (tkn (- n - 1) p)\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates, clarsimp,
    subgoal_tac "p2 = (mkRescomp (clock p2) (callc p2) (invkc p2) (invkdpth p2))", auto)

lemma RVarElim:
      "\<lbrakk>letrComb x (HeapIs Same && ResultIs (rvarVE y) && tickCosts n) Q E h hh v p;
        (rvarVE y) E h (RVal r);
        \<lbrakk>Q (E\<lfloor>x:=r\<rfloor>) h hh v (tkn (-n - 1) p)\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates, clarsimp,
    subgoal_tac "p2 = (mkRescomp (clock p2) (callc p2) (invkc p2) (invkdpth p2))", auto)

lemma IopElim:
      "\<lbrakk>letiComb z (HeapIs Same && ResultIs (iopVE (ivarVE x) f (ivarVE y)) && tickCosts n) Q E h hh v p;
        (ivarVE x) E h (IVal i);
        (ivarVE y) E h (IVal j);
        \<lbrakk>Q (E<z:=f i j>) h hh v (tkn (-n - 1) p)\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates, clarsimp,
    subgoal_tac "p2 = (mkRescomp (clock p2) (callc p2) (invkc p2) (invkdpth p2))", auto)

lemma RopElim:
      "\<lbrakk>letiComb z (HeapIs Same && ResultIs (ropVE (rvarVE x) f (rvarVE y)) && tickCosts n) Q E h hh v p;
        (rvarVE x) E h (RVal i);
        (rvarVE y) E h (RVal j);
        \<lbrakk>Q (E<z:=f i j>) h hh v (tkn (-n - 1) p)\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates, clarsimp,
    subgoal_tac "p2 = (mkRescomp (clock p2) (callc p2) (invkc p2) (invkdpth p2))", auto)

lemma GetFiElim:
      "\<lbrakk>letiComb x (HeapIs Same && ResultIs (idotVE (rvarVE y) F ) && tickCosts n) Q E h hh v p;
        (rvarVE y) E h (RVal (Ref l));
        \<lbrakk>Q (E<x:=(iheap h) F l>) h hh v (tkn (- n - 1) p)\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates, clarsimp,
    subgoal_tac "Ref l = Ref la", clarify,
    subgoal_tac "p2 = (mkRescomp (clock p2) (callc p2) (invkc p2) (invkdpth p2))", auto)

lemma GetFrElim:
      "\<lbrakk>letrComb x (HeapIs Same && ResultIs (rdotVE (rvarVE y) F ) && tickCosts n) Q E h hh v p;
        rdotVE (rvarVE y) F E h (RVal r);
        \<lbrakk>Q (E\<lfloor>x:=r\<rfloor>) h hh v (tkn (- n - 1) p)\<rbrakk> \<Longrightarrow>R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates, clarsimp,
    subgoal_tac "Ref l = Ref la", clarify,
    subgoal_tac "p2 = (mkRescomp (clock p2) (callc p2) (invkc p2) (invkdpth p2))", auto)

lemma PutFiElim:
      "\<lbrakk>letvComb (HeapIs (iUpd Same (rvarVE x) F (ivarVE y)) && 
                  ResultIs (constVE arbitrary) && tickCosts n) Q E h hh v p;
        E\<lfloor>x\<rfloor> = Ref a;
        \<lbrakk>Q E (h<a\<bullet>F:=E<y>>) hh v (tkn (- n) p)\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates, clarsimp,
    subgoal_tac "p2 = (mkRescomp (clock p2) (callc p2) (invkc p2) (invkdpth p2))", auto)

lemma PutFrElim:
      "\<lbrakk>letvComb (HeapIs (rUpd Same (rvarVE x) F (rvarVE y)) && ResultIs (constVE arbitrary) && tickCosts n) Q E h hh v p;
        E\<lfloor>x\<rfloor> = Ref a;
        \<lbrakk>Q E (h\<lfloor>a\<diamondsuit>F:=E\<lfloor>y\<rfloor>\<rfloor>) hh v (tkn ( - n) p)\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates, clarsimp,
    subgoal_tac "p2 = (mkRescomp (clock p2) (callc p2) (invkc p2) (invkdpth p2))", auto)

lemma NewElim:
      "\<lbrakk>letrComb x (EXloc (\<lambda> l . (HeapIs (extendHE Same c l iflds rflds) &&
                        ResultIs (constVE (RVal (Ref l))) &&
                        costs 1 1 0 0 0))) Q E h hh v p;
         l = (freshloc (fmap_dom (oheap h)));
        \<lbrakk>Q (E\<lfloor>x:=Ref l\<rfloor>) (newObj h l E c iflds rflds) hh v (tkn (-2) p)\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates newObj_def, clarsimp,
    subgoal_tac "p2 = (mkRescomp (clock p2) (callc p2) (invkc p2) (invkdpth p2))", auto)

lemma CondElim:
      "\<lbrakk>condComb b P Q E h hh v p; 
        \<lbrakk>E<b>=grailbool True; P E h hh v (tkn (- 2) p)\<rbrakk> \<Longrightarrow> R; 
        \<lbrakk>E<b>=grailbool False; Q E h hh v (tkn (- 2) p)\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates,
    (subgoal_tac "pp = (mkRescomp (clock pp) (callc pp) (invkc pp) (invkdpth pp))", auto)+)

lemma AllnatElim:
      "\<lbrakk>ALLnat P E h hh v p; !!n . P n E h hh v p \<Longrightarrow> R\<rbrakk> \<Longrightarrow> R"
by (simp add: ALLnat_def)

lemma ExlocElim: "\<lbrakk>EXloc P E h hh v p; EX n . P n E h hh v p \<Longrightarrow> R\<rbrakk> \<Longrightarrow> R"
by (simp add: EXloc_def)

lemma impliesAssnElim:
      "\<lbrakk>impliesAssn P Q E h hh v p; P E h hh v p;  Q E h hh v p \<Longrightarrow> R\<rbrakk> \<Longrightarrow> R"
by (simp only: impliesAssn_def)

lemma IMPLIES_Intro:
      "\<lbrakk>!! E h hh v p . P E h hh v p \<Longrightarrow> Q  E h hh v p\<rbrakk> \<Longrightarrow> IMPLIES P Q"
by (simp add: IMPLIES_def)

lemma AllnatIntro:
       "\<lbrakk>!!n. P n E h hh v p\<rbrakk> \<Longrightarrow> ALLnat P E h hh v p"
by (simp add: ALLnat_def)

lemma impliesAssnIntro:
      "\<lbrakk>P E h hh v p \<Longrightarrow> Q E h hh v p\<rbrakk> \<Longrightarrow> impliesAssn P Q E h hh v p"
by (simp add: impliesAssn_def)
end
