theory Separation = ListClassComb:

types LocSpec = "locn set \<Rightarrow> vdmassn"

constdefs LIST::"nat \<Rightarrow> rname \<Rightarrow> LocSpec"
"LIST N l == \<lambda> X E h hh v p . (\<exists> r. E\<lfloor>l\<rfloor> = Ref r \<and> (N,r,X,h) \<in> LocLength)"

constdefs DisjLists::"nat \<Rightarrow> rname \<Rightarrow> nat \<Rightarrow> rname \<Rightarrow> vdmassn"
"DisjLists N l M a == \<lambda> E h hh v p . (\<exists> X Y . (LIST N l X && LIST M a Y) E h hh v p \<and> X \<inter> Y = {})"

constdefs star ::"LocSpec \<Rightarrow> LocSpec \<Rightarrow> LocSpec"   (infixr "\<star>" 100)
"star P Q == \<lambda> Z E h hh v p . (\<exists> X Y .  (P X && Q Y) E h hh v p \<and> X \<union> Y \<subseteq> Z \<and> X \<inter> Y = {})"

lemma starCommutative: "P \<star> Q = Q \<star> P"
by (simp add: star_def predicates, rule, rule, rule, rule, rule, rule, fast)

lemma starAssociative: "P \<star> (Q \<star> R) = (P \<star> Q) \<star> R"
apply (rule, simp add: star_def predicates, rule, rule, rule, rule, rule, rule)
apply clarsimp apply (rule, rule, rule, rule, assumption) apply (rule, rule, assumption) prefer 2
               apply (rule, rule, assumption)  apply rule 
               apply (subgoal_tac "((X \<union> Y) - Ya) \<union> Ya \<subseteq> x", assumption) apply fast apply fast apply fast 
apply clarsimp apply (rule, rule, assumption) apply (rule, rule, rule, rule, assumption) apply (rule, rule, assumption) prefer 2
               apply rule apply (subgoal_tac "Xa \<union> ((X \<union> Y) - Xa) \<subseteq> x", assumption) apply fast apply fast apply fast 
done

constdefs STAR ::"LocSpec \<Rightarrow> LocSpec \<Rightarrow> LocSpec"   (infixr "\<currency>" 100)
"STAR P Q == \<lambda> Z E h hh v p . (\<exists> X Y .  (P X && Q Y) E h hh v p \<and> X \<union> Y = Z \<and> X \<inter> Y = {})"

lemma STARcommutative: "P \<currency> Q = Q \<currency> P"
by (simp add: STAR_def predicates, rule, rule, rule, rule, rule, rule, fast)

lemma STARassociative: "P \<currency> (Q \<currency> R) = (P \<currency> Q) \<currency> R"
apply (rule, simp add: STAR_def predicates, rule, rule, rule, rule, rule, rule)
apply clarsimp apply (rule, rule, rule, rule, assumption) apply (rule, rule, assumption) prefer 2
               apply (rule, rule, assumption)  apply rule 
               apply (subgoal_tac "(X \<union> Xa) \<union> Ya = X \<union> (Xa \<union> Ya)", assumption) apply fast apply fast apply fast 
apply clarsimp apply (rule, rule, assumption) apply (rule, rule, rule, rule, assumption) apply (rule, rule, assumption) prefer 2
               apply rule apply (subgoal_tac "Xa \<union> (Ya \<union> Y) = Xa \<union> Ya \<union> Y", assumption) apply fast apply fast apply fast 
done

constdefs Pre::"LocSpec \<Rightarrow> vdmassn"  ("\<flat>")
"Pre P == \<lambda> E h hh v p . P (fmap_dom (oheap h)) E h hh v p"

constdefs Post::"LocSpec \<Rightarrow> vdmassn"  ("\<sharp>")
"Post P == \<lambda> E h hh v p . P (fmap_dom (oheap hh)) E h hh v p"

lemma LocLengthDom: "\<forall> X r h . ((N,r,X,h) : LocLength \<longrightarrow> X \<subseteq> fmap_dom (oheap h))"
apply clarsimp
apply (induct N)
apply (erule LocLength.elims, simp_all, fast)
apply (erule LocLength.elims, simp_all, auto) apply (case_tac "x \<in> Xa - {l}") apply fast
apply (subgoal_tac "x=l") prefer 2 apply fast apply auto apply (simp add: fmap_dom_def fmap_lookup_def dom_def)
done

theorem "\<flat> ((LIST N l) \<star> (LIST M a)) = DisjLists N l M a"
apply (simp add: Pre_def star_def DisjLists_def LIST_def)
apply (rule, rule, rule, rule, rule, rule)
(*1*) apply(fast) 
(*2*) apply clarsimp apply(rule, rule, rule) apply fast 
  apply (simp add:AND_def, clarsimp) apply (erule disjE) apply (insert LocLengthDom, fast) apply fast
done

locale RevEquivalence =
 fixes deliverableSpec::vdmassn  and sepSpec :: vdmassn and l :: rname and acc :: rname and
       callcA :: nat and callcB :: nat and clockA :: nat and clockB :: nat and 
       invkcA :: nat and invkcB :: nat and invkdpthA :: nat and invkdpthB :: nat
  assumes dSpec[simp]:"deliverableSpec == \<lambda> E h hh v p . 
           (\<forall> L X rl AC Y racc. ((E\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> LocLength \<and>
                                  E\<lfloor>acc\<rfloor> = Ref racc \<and> (AC,racc,Y,h) \<in> LocLength \<and> X \<inter> Y = {}) \<longrightarrow> 
                                 (HSize h = HSize hh \<and> 
                                  p = \<langle> (int(clockA * L + clockB)) (int (callcA * L + callcB) )
                                        (int(invkcA * L + invkcB)) (invkdpthA * L + invkdpthB)\<rangle>)))"
      and  vardistinct:  "distinct [acc,l]"
      and resdefs[simp]: "(callcA = 1) \<and> (callcB = 1) \<and> (clockA = 31) \<and> (clockB = 11) \<and> 
                          (invkcA = 0) \<and> (invkcB = 0) \<and> (invkdpthA = 0) \<and> (invkdpthB = 0)"
      and sSpec[simp]: "sepSpec == (ALLnat (\<lambda> L . ALLnat (\<lambda> A . impliesAssn (\<flat> ((LIST L l) \<star> (LIST A acc))) 
                                                             (ticks (constVE (IVal(int (clockA * L + clockB))))
                                                               && calls (constVE (IVal(int (callcA * L + callcB))))
                                                               && invokes (constVE (IVal(int(invkcA * L + invkcB))))
                                                               && depth (constVE (IVal(int (invkdpthA * L + invkdpthB))))
                                                               && allocates (constVE (IVal 0))))))"

lemma (in RevEquivalence)
"deliverableSpec = sepSpec"
apply (rule, rule, rule, rule, rule, rule)
apply (simp_all add: ALLnat_def impliesAssn_def Pre_def star_def LIST_def predicates)
apply clarsimp apply (erule_tac x=n in allE) apply (erule impE, clarsimp, fast, simp)
apply clarsimp apply (erule_tac x=L in allE) apply (erule impE) apply (rule, rule, rule, assumption)
               apply (rule, rule, assumption) apply (insert LocLengthDom, fast)
      apply(rule,arith, simp)
done
end
