(*Version of Rev.thy with invoke*)

theory ExampleListReverseInplace = ListClass + VDMderived:

(*With invokes:*)
(*class ListRevInPlace {
   method public static REV (l, acc) =
   let fun f(l, t0, h, t, acc) =
         let val tag = getfield l TAG
         in if tag = 0
            then f0(l, t0, h, t, acc)
            else f1(l, t0, h, t, acc)
         end

       fun f1(l, t0, h, t, acc) =
         let val h = getfield l HD
             val t = getfield l TL
             val one = 1
             val _ = putfield l TAG one
             val _ = putfield l HD h
             val _ = putfield l TL acc
             val t0 = l
         in invokestatic REV (t, t0)
         end

      fun f0(l, d, t0, h, t, acc) = acc
   in f(l, t0, h, t, acc)
   end
}
*)

constdefs IcallcA :: nat "IcallcA == 1"
constdefs IcallcB :: nat "IcallcB == 1"
constdefs IclockA :: nat "IclockA == 31"
constdefs IclockB :: nat "IclockB == 11"
constdefs IinvkcA :: nat "IinvkcA == 0"
constdefs IinvkcB :: nat "IinvkcB == 0"
constdefs IinvkdpthA :: nat "IinvkdpthA == 0"
constdefs IinvkdpthB :: nat "IinvkdpthB == 0"

constdefs IIcallcA :: nat "IIcallcA == 1"
constdefs IIcallcB :: nat "IIcallcB == 1"
constdefs IIclockA :: nat "IIclockA == 31"
constdefs IIclockB :: nat "IIclockB == 20"
constdefs IIinvkcA :: nat "IIinvkcA == 0"
constdefs IIinvkcB :: nat "IIinvkcB == 0"
constdefs IIinvkdpthA :: nat "IIinvkdpthA == 0"
constdefs IIinvkdpthB :: nat "IIinvkdpthB == 0"

locale RevInplaceInvoke = 
  fixes    tag     :: iname    and	   h       :: iname    and	   b       :: iname   and one :: iname
    and    l       :: rname    and         acc     :: rname    and         t       :: rname   and t0 :: rname
    and	   f       :: funame   and REV :: mname and mspectRev1:: vdmassn and mspectRev2 :: vdmassn
(*    and IcallcA :: nat and IcallcB :: nat and IclockA :: nat and IclockB :: nat 
    and IinvkcA :: nat and IinvkcB :: nat and IinvkdpthA :: nat and IinvkdpthB :: nat 

    and IIcallcA :: nat and IIcallcB :: nat and IIclockA :: nat and IIclockB :: nat 
    and IIinvkcA :: nat and IIinvkcB :: nat and IIinvkdpthA :: nat and IIinvkdpthB :: nat *)
 assumes  funtf[simp]:
          "funtable f == (LET tag = GetFi l TAG;
                                b = Primop (% x y. if x < 1 then 1 else 0) tag tag
                          IN IF b
                             THEN RVar acc 
                             ELSE LET  h   = GetFi l HD;
                                    rf t   = GetFr l TL;
                                       one = expr.Int 1;
                                         _ = PutFi l TAG one; 
                                         _ = PutFi l HD h;
                                         _ = PutFr l TL acc;
                                     rf t0 = RVar l
                                  IN t\<diamondsuit>REV(t0) END 
                          END)::'a expr"
     and meth[simp]:
         "methtable LST REV == (LET rf l = RVar self;
                                rf acc = RVar param
                              IN CALL f END)::'a expr"
     and spectf:
         "spectable f == {(E,h,hh,v,p) . 
           (\<forall> L X rl AC Y racc. ((E\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> LocLength \<and>
                                  E\<lfloor>acc\<rfloor> = Ref racc \<and> (AC,racc,Y,h) \<in> LocLength \<and> X \<inter> Y = {}) \<longrightarrow> 
                                 (HSize h = HSize hh \<and> 
                                  p = \<langle> (IclockA * L + IclockB) (IcallcA * L + IcallcB) (IinvkcA * L + IinvkcB) (IinvkdpthA * L + IinvkdpthB)\<rangle>)))}"
      and  vardistinct:     "distinct [tag,h,b,one] \<and> distinct [one,b,h,tag] \<and> 
                             distinct[l,acc,t,t0,self,param] \<and> distinct [param,self,t0,t,acc,l] \<and>
                             distinct[HD,TAG] \<and> distinct [TAG,HD]"
(*      and resdefs: "(IcallcA = 1) \<and> (IcallcB = 1) \<and> (IclockA = 31) \<and> (IclockB = 11) \<and> (IinvkcA = 0) \<and> (IinvkcB = 0) \<and> (IinvkdpthA = 0) \<and> (IinvkdpthB = 0) \<and> (IIcallcA = 1) \<and> (IIcallcB = 1) \<and> (IIclockA = 31) \<and> (IIclockB = 13) \<and> (IIinvkcA = 0) \<and> (IIinvkcB = 0) \<and> (IIinvkdpthA = 0) \<and> (IIinvkdpthB = 0)"
*)
    defines "mspectRev1 == {(E,h,hh,v,p) . (\<forall> L X rl AC Y racc. 
                                (fmap_lookup (oheap h) rl = Some LST \<and> 
                                 fmap_lookup (oheap h) racc = Some LST \<and>
                                 (E\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> LocLength \<and>
                                  E\<lfloor>acc\<rfloor> = Ref racc \<and> (AC,racc,Y,h) \<in> LocLength \<and> X \<inter> Y = {}) \<longrightarrow> 
                                 (HSize h = HSize hh \<and> 
                                  p = \<langle> (IIclockA * L + IIclockB) (IIcallcA * L + IIcallcB) (IIinvkcA * L + IIinvkcB) (IIinvkdpthA * L + IIinvkdpthB)\<rangle>)))}"
        and "mspectRev2 == {(E,h,hh,v,p) . (\<forall> L X rl AC Y racc. 
                                (fmap_lookup (oheap h) rl = Some LST \<and> 
                                 fmap_lookup (oheap h) racc = Some LST \<and>
                                 (E\<lfloor>t\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> LocLength \<and>
                                  E\<lfloor>t0\<rfloor> = Ref racc \<and> (AC,racc,Y,h) \<in> LocLength \<and> X \<inter> Y = {}) \<longrightarrow> 
                                 (HSize h = HSize hh \<and> 
                                  p = \<langle> (IIclockA * L + IIclockB) (IIcallcA * L + IIcallcB) (IIinvkcA * L + IIinvkcB) (IIinvkdpthA * L + IIinvkdpthB)\<rangle>)))}"

lemma (in RevInplaceInvoke) "\<rhd> ((l\<diamondsuit>REV(acc))::'a expr) : {(E,h,hh,v,p) . 
           (\<forall> L X rl AC Y racc. ((fmap_lookup (oheap h) rl = Some LST \<and> 
                                 fmap_lookup (oheap h) racc = Some LST \<and> E\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> LocLength \<and>
                                  E\<lfloor>acc\<rfloor> = Ref racc \<and> (AC,racc,Y,h) \<in> LocLength \<and> X \<inter> Y = {}) \<and> AC = 0 \<longrightarrow> 
                                 (HSize h = HSize hh \<and> 
                                  p = \<langle> (IIclockA * L + IIclockB) (IIcallcA * L + IIcallcB) (IIinvkcA * L + IIinvkcB) (IIinvkdpthA * L + IIinvkdpthB)\<rangle>)))}"
apply (insert vardistinct)
apply (subgoal_tac "\<forall> E h loc CC . (qach_QaQ E h loc l CC \<longrightarrow> CC = LST) \<and> (qach_QaQ E h loc t CC \<longrightarrow> CC = LST) ")
apply (rule vdm_conseq)
apply (subgoal_tac "\<rhd> l\<diamondsuit>REV(acc) : mspectRev1", assumption)
prefer 2 apply (simp add: mspectRev1_def, clarsimp) apply (erule_tac x=L in allE) apply (erule impE) apply fast apply simp
apply (rule MUTREC)
apply (subgoal_tac "finite {(l\<diamondsuit>REV(acc),mspectRev1), (t\<diamondsuit>REV(t0),mspectRev2), (CALL f, spectable f)}")
apply assumption
apply simp
apply simp
apply clarsimp
prefer 2 apply (simp)
apply (simp add: consistent_def)
apply (rule)
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_getfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_prim)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_if)
apply (rule vdm_rvar)
apply (rule vdm_leti, rule vdm_getfi)
prefer 2 apply clarsimp prefer 2 
apply (rule vdm_letr, rule vdm_getfr)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_int)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfr)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_ax, simp)
apply (case_tac "aa<ad\<bullet>TAG> < 1", clarsimp) apply(simp add: spectf, clarsimp)
(*Case <*)
apply (erule LocLength.elims, simp_all)
apply (simp add: IclockB_def IcallcB_def IinvkcB_def IinvkdpthB_def)
(* >= *)
apply (erule exE, erule conjE, simp)+
apply (simp add: mspectRev2_def spectf, clarsimp)
  apply (erule LocLength.elims, simp_all, clarsimp)
  apply (erule_tac x="i" in allE)
  apply (erule impE)
  apply rule apply (rotate_tac -3) apply (erule LocLength.elims, simp_all)
  apply (rule exI, rule conjI)
  apply (erule LocLengthSame)
  apply (simp add: same_def)
  apply (rule_tac x="Suc AC" in exI, rule_tac x="Y \<union> {la}" in exI, rule)
  apply (erule LocLengthSuc, fastsimp, fastsimp, fastsimp, fastsimp)
  apply rule
apply (simp add: IclockB_def IcallcB_def IinvkcB_def IinvkdpthB_def)
apply (simp add: IclockA_def IIclockA_def)
defer 1 (* IIclockB = 13*)
apply (simp add: IclockB_def IcallcB_def IinvkcB_def IinvkdpthB_def)
apply (simp add: IclockA_def IIclockA_def)
apply (simp add: IcallcA_def IIcallcA_def IinvkcA_def IIinvkcA_def IinvkdpthA_def IIinvkdpthA_def)
defer 1 (*IIcallcB = Suc 0 \<and> IIinvkcB = 0 \<and> IIinvkdpthB = 0*)
apply clarsimp
apply rule 
apply clarsimp
apply (simp add: mspectRev1_def)
apply rule
defer 1
apply clarsimp
(* continue here deferred goal is incomaptible with the similar one from the next subgoal, and THIS subgoal does not hold\<dots>*)
apply (erule_tac x=E' in allE, erule_tac x=h' in allE, erule_tac x=a in allE, erule_tac x=C in allE, clarify)
apply (simp only: meth)
apply (rule vdm_conseq)
apply(rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply(rule vdm_ax, simp)
prefer 3 
apply clarsimp
apply rule prefer 2
apply clarsimp
apply (erule_tac x=E' in allE, erule_tac x=h' in allE, erule_tac x=a in allE, erule_tac x=C in allE, clarify)
apply (simp only: meth)
apply (rule vdm_conseq)
apply(rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply(rule vdm_ax, simp)
(* end of vcg*)
apply (simp add: spectf mspectRev2_def, clarsimp)
apply (erule_tac x=L in allE)
apply (erule impE)
apply (rule_tac x=X in exI, simp)
apply (rule_tac x=AC in exI, rule_tac x=Y in exI, simp)
apply clarsimp
apply (simp add: IIclockA_def IclockA_def IIclockB_def IclockB_def
                    IIcallcA_def IcallcA_def IIcallcB_def IcallcB_def
                    IIinvkcA_def IinvkcA_def IIinvkcB_def IinvkcB_def
                    IIinvkdpthA_def IinvkdpthA_def IIinvkdpthB_def IinvkdpthB_def)
defer 1
apply (simp add: spectf mspectRev1_def, clarsimp)
apply (erule_tac x=L in allE)
apply (erule impE)
apply (rule_tac x=X in exI, simp)
apply (rule_tac x=AC in exI, rule_tac x=Y in exI, simp)
apply clarsimp
apply (simp add: IIclockA_def IclockA_def IIclockB_def IclockB_def
                    IIcallcA_def IcallcA_def IIcallcB_def IcallcB_def
                    IIinvkcA_def IinvkcA_def IIinvkcB_def IinvkcB_def
                    IIinvkdpthA_def IinvkdpthA_def IIinvkdpthB_def IinvkdpthB_def)
defer 1
apply (simp add: spectf mspectRev2_def, clarsimp)
apply (erule LocLength.elims, simp_all, clarsimp)
apply (erule_tac x=i in allE)
apply (erule impE, clarsimp)
apply rule apply (rotate_tac -3, erule LocLength.elims, simp_all)
apply (rule_tac x="Xa - {la}" in exI, rule)
apply (subgoal_tac "same (Xa - {la}) hp (hp\<lparr>iheap := (iheap hp)(TAG := (iheap hp TAG)(la := 1)), iheap := (iheap hp)(TAG := (iheap hp TAG)(la := 1), HD := iheap hp HD),
              rheap := (rheap hp)(TL := (rheap hp TL)(la := Ref racc))\<rparr>)")
apply (erule LocLengthSame, simp) 
apply (simp add: same_def)
apply (rule_tac x="Suc AC" in exI, rule_tac x="insert la Y" in exI, clarsimp, rule)
apply (rule CONS_LocL, simp_all)
apply (subgoal_tac "racc \<in> Y")
apply fast
apply (erule LocLength.elims, simp_all)
apply (subgoal_tac "Y = Y - {la}", clarsimp)
apply (subgoal_tac "same Y hp (hp\<lparr>iheap := (iheap hp)(TAG := (iheap hp TAG)(la := 1)), iheap := (iheap hp)(TAG := (iheap hp TAG)(la := 1), HD := iheap hp HD),
              rheap := (rheap hp)(TL := (rheap hp TL)(la := Ref racc))\<rparr>)")
apply (erule LocLengthSame, simp) 
apply (simp add: same_def)
apply fast
apply fast
apply fast
defer 1
apply (simp add: spectf, clarsimp)
apply (erule LocLength.elims, simp_all, clarsimp) 
apply (simp add: IIclockA_def IclockA_def IIclockB_def IclockB_def
                    IIcallcA_def IcallcA_def IIcallcB_def IcallcB_def
                    IIinvkcA_def IinvkcA_def IIinvkcB_def IinvkcB_def
                    IIinvkdpthA_def IinvkdpthA_def IIinvkdpthB_def IinvkdpthB_def)
prefer 2
apply (rule_tac x="\<lparr>ienv = \<lambda> x . 1, renv = \<lambda> x . Ref 1\<rparr>" in exI)
apply (rule_tac x="\<lparr>oheap = fmap_upd emptyfinmap 1 LST, iheap = \<lambda> f loc. 1, rheap = \<lambda> f loc . Nullref\<rparr>" in exI)
apply (rule_tac x="1" in exI)
apply (rule_tac x="LST" in exI, simp add: qach_QaQ_def mspectRev2_def)
apply clarsimp
apply rule
prefer 2
apply rule 
apply (simp add: IIclockA_def IclockA_def IIclockB_def IclockB_def
                    IIcallcA_def IcallcA_def IIcallcB_def IcallcB_def
                    IIinvkcA_def IinvkcA_def IIinvkcB_def IinvkcB_def
                    IIinvkdpthA_def IinvkdpthA_def IIinvkdpthB_def IinvkdpthB_def)
apply rule
prefer 2
apply (simp add: IIclockA_def IclockA_def IIclockB_def IclockB_def
                    IIcallcA_def IcallcA_def IIcallcB_def IcallcB_def
                    IIinvkcA_def IinvkcA_def IIinvkcB_def IinvkcB_def
                    IIinvkdpthA_def IinvkdpthA_def IIinvkdpthB_def IinvkdpthB_def)
prefer 4
apply (subgoal_tac "IIclockA = IclockA \<and> IIclockB = IclockB + 9 \<and> 
                    IIcallcA = IcallcA \<and> IIcallcB = IcallcB \<and>
                    IIinvkcA = IinvkcA \<and> IIinvkcB = IinvkcB + 1 \<and>
                    IIinvkdpthA = IinvkdpthA \<and> IIinvkdpthB = IinvkdpthB + 1", clarsimp)
apply (subgoal_tac "29 + IIclockB = IclockA + IclockB \<and> Suc 0 = IcallcA \<and> IIinvkcB = IinvkcA + IinvkcB \<and> IIinvkdpthB 
apply (simp add: spectf, clarsimp)
apply (erule LocLength.elims, simp_all, clarsimp) 
defer 1
here
apply(simp_all add: clockB_def callcB_def invkcB_def invkdpthB_def)
prefer 2
apply(rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letr, rule vdm_getfr) prefer 2 apply clarsimp prefer 2
apply(rule vdm_leti, rule vdm_int) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letv, rule vdm_putfr) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply (rule vdm_ax, simp)
apply (insert vardistinct)
apply clarsimp
apply (erule LocLength.elims, simp_all, clarsimp)
apply (erule_tac x=i in allE)
apply (erule impE)
apply (rule_tac x="Xa - {la}" in exI, rule)
apply (subgoal_tac "same (Xa - {la}) hp (hp \<lparr>iheap := (iheap hp)(TAG := (iheap hp TAG)(la := 1)),
              iheap := (iheap hp)(TAG := (iheap hp TAG)(la := 1), HD := iheap hp HD),
              rheap := (rheap hp)(TL := (rheap hp TL)(la := Ref racc))\<rparr>)")
defer 1
apply (simp add: same_def) 
apply (rule_tac x="Suc AC" in exI, rule_tac x="Y \<union> {la}" in exI, rule)
apply (rule CONS_LocL, simp_all)
apply (subgoal_tac "racc \<in> Y")
apply fast
apply (erule LocLength.elims, simp_all)
apply (subgoal_tac "Y = Y - {la}", clarsimp)
apply (subgoal_tac "same Y hp \<lparr>oheap = oheap hp, iheap = (iheap hp)(TAG := (iheap hp TAG)(la := 1), HD := iheap hp HD),
              rheap = (rheap hp)(TL := (rheap hp TL)(la := Ref racc))\<rparr>")
defer 1
apply (simp add: same_def, fast)
apply fast
apply fast
apply (simp_all add: clockA_def callcA_def invkcA_def invkdpthA_def)
apply (erule LocLengthSame) apply fast
apply (erule LocLengthSame) 
apply (simp add: same_def)
done
