theory LIST = Edge + VDMderivedComb:

consts LST     :: cname      -- {* class name of the data type *}
       ListHD   :: rfldname   -- {* head *}
       ListTL   :: rfldname   -- {* tail *}

consts HEAD :: rname
       t    :: rname

(*fun ListInit (this, ID, HEAD) = \<dots>*)
constdefs ListInit :: expr
"ListInit == LET _ = PutFr this ListHD HEAD;
              rf t = Null
             IN PutFr this ListTL t END"

consts list :: "(locn \<times> ref \<times> ref \<times> heap) set"
inductive list intros
listConstr:"\<lbrakk>h@@l = Some LST; h\<lfloor>l\<diamondsuit>ListHD\<rfloor> = H; h\<lfloor>l\<diamondsuit>ListTL\<rfloor> = T\<rbrakk>
            \<Longrightarrow> (l,H,T,h) : list"

constdefs ListInitSPEC :: vdmassn
"ListInitSPEC E h hh v p == 
  \<forall> l . (E\<lfloor>this\<rfloor>=Ref l \<and> h@@l = Some LST \<longrightarrow> (l,E\<lfloor>HEAD\<rfloor>,Nullref,hh):list)"

locale ListInitCorrect =
  fixes nodeinit :: funame
  assumes funtListinit: "funtable listinit = ListInit"
      and vardistinct:  "ListHD \<noteq> ListTL \<and> t \<noteq> this \<and> HEAD \<noteq> this"

lemma (in ListInitCorrect) "\<rhd> (Call listinit) :: ListInitSPEC"
apply (rule vdm_call, rule vdm_conseq)
apply (simp add: funtListinit ListInit_def)
apply (rule vdm_basics)+
apply (simp add: IMPLIES_def ListInitSPEC_def tkCallAssn_def, safe)
apply (erule PutFrElim, assumption)
apply (erule RConstElim)
apply (rule listConstr)
apply (simp add: vardistinct predicates)+
done 

constdefs CALLS::"iname \<Rightarrow> int \<Rightarrow> valExpr"
"CALLS x i == (iopVE (ivarVE x) (\<lambda> x y . x + y) (constVE (IVal i)))"

locale MkList =
fixes LST     :: cname
  and ListHD   :: rfldname
  and ListTL   :: rfldname
  and this :: rname
  and L :: rname
  and M :: rname
  and entry :: rname
  and n :: iname
  and b :: iname
  and mkList :: funame
  and mkListf :: funame
  and mkList_body:: expr
  and mkListf_body:: expr

  and mkListSPEC :: vdmassn
  and mkListf_SPEC :: vdmassn

defines "mkList_body == LET rf L = Null IN Call mkListf END"

    and "mkListf_body == LET b = Primop (\<lambda> x y. if x <= 0 then grailbool True else grailbool False) n n
                  IN IF b THEN RVar L 
                     ELSE LET rf M = RVar L;
                              rf L = NEW <LST> ([], [(ListHD,entry), (ListTL,M)]);
                                 n = Primop (\<lambda> x y . x - 1) n n
                          IN (Call mkListf) END
                  END"

    and "mkListSPEC == (impliesAssn (\<lambda> E h hh v p. 0 <= E<n>) (allocates (ivarVE n) && invokes (constVE (IVal 0)) && 
                                                               depth (constVE (IVal 0)) && calls (CALLS n 2)))"

    and "mkListf_SPEC == (impliesAssn (\<lambda> E h hh v p. 0 <= E<n>) (allocates (ivarVE n) && invokes (constVE (IVal 0)) && 
                                                                 depth (constVE (IVal 0)) && calls (CALLS n 1)))"


  assumes funtmkList: "funtable mkList = mkList_body"
      and funtmkListf: "funtable mkListf = mkListf_body"
      and specmkList: "spectable mkList = mkListSPEC"
      and specmkListf: "spectable mkListf = mkListf_SPEC"
      and vardistinct:  "distinct[ListHD,ListTL] \<and> distinct[M,L,this,entry] \<and> 
                         distinct[n,b] \<and> distinct[mkList, mkListf]"

lemma (in MkList) "\<rhd> (Call mkListf) :: mkListf_SPEC"
apply (rule vdm_call)
apply (simp add: funtmkListf mkListf_body_def)
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply (rule vdm_ax, simp)
apply (simp add: IMPLIES_def, safe)
apply (erule IopElim, simp add:predicates, simp add:predicates)
apply (erule CondElim, clarsimp)
  apply (simp add: CALLS_def mkListSPEC_def mkListf_SPEC_def predicates impliesAssn_def)
apply clarsimp
apply (erule RVarElim, simp add: predicates)
apply (erule NewElim, simp)
apply (erule IopElim, simp add:predicates, simp add:predicates)
apply (simp add: CALLS_def mkListSPEC_def mkListf_SPEC_def predicates impliesAssn_def)
apply (erule impE, insert vardistinct, clarsimp)apply (simp add: newObj_def)
done
  
lemma (in MkList) "\<rhd> (Call mkList) :: mkListSPEC"
apply (rule MUTREC)
apply (subgoal_tac "finite {(Call mkList, mkListSPEC), (Call mkListf, mkListf_SPEC)}")
apply (assumption, simp_all)
apply (simp add: consistent_def,safe)
apply (simp_all add: specmkList specmkListf)
apply (simp add: funtmkList mkList_body_def)
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply (rule vdm_ax, simp)
apply (rule disjI2, simp)
apply (simp add: IMPLIES_def, safe)
apply (erule RConstElim, simp)
defer 1
apply (simp add: funtmkListf mkListf_body_def)
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply (rule vdm_ax, simp)
apply (rule disjI2, simp)
apply (simp add: IMPLIES_def, safe)
apply (erule IopElim, simp add:predicates, simp add:predicates)
apply (erule CondElim, clarsimp)
defer 1
apply clarsimp
apply (erule RVarElim, simp add: predicates)
apply (erule NewElim, simp)
apply (erule IopElim, simp add:predicates, simp add:predicates)
apply (simp_all add: CALLS_def mkListSPEC_def mkListf_SPEC_def predicates impliesAssn_def)
apply (erule impE, insert vardistinct, clarsimp, simp add: newObj_def)
done

locale ConsLocale =
fixes cons:: funame 
  and cons_body :: expr
  and head :: rname
  and tail :: rname
  and consSPEC :: vdmassn
defines "cons_body == NEW <LST> ([],[(ListHD,head), (ListTL,tail)])"

    and "consSPEC == (allocates (constVE (IVal 1)) && invokes (constVE (IVal 0)) && 
                      depth (constVE (IVal 0)) && calls (constVE (IVal 1)))"

  assumes funt_cons: "funtable cons = cons_body"
      and vardistinct:  "distinct[ListHD,ListTL] \<and> distinct[head,tail]"

lemma (in ConsLocale) "\<rhd> (Call cons) :: consSPEC"
apply (rule vdm_call)
apply (simp add: funt_cons cons_body_def)
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply (simp add: consSPEC_def predicates newObj_def)
done

consts modelsList :: "(ref \<times> (locn set) \<times> nat \<times> heap) set"
inductive modelsList intros
modelsListNIL : "(Nullref,{},0,h) : modelsList"
modelsListCONS: "\<lbrakk>h@@l = Some LST; h\<lfloor>l\<diamondsuit>ListHD\<rfloor> = Ref head; 
                  h\<lfloor>l\<diamondsuit>ListTL\<rfloor> = tail; l \<notin> X; (tail,X,i,h):modelsList\<rbrakk> 
                \<Longrightarrow> (Ref l, X \<union> {l}, Suc i,h) : modelsList"


constdefs same::"locn set \<Rightarrow> heap \<Rightarrow> heap \<Rightarrow> bool"
"same X h hh == \<forall> l ifld rfld. (l \<in> X \<longrightarrow> (h@@l = hh@@l \<and>  h<l\<bullet>ifld> = hh<l\<bullet>ifld> \<and> h\<lfloor>l\<diamondsuit>rfld\<rfloor> = hh\<lfloor>l\<diamondsuit>rfld\<rfloor>))"

lemma modelsListSameAux:
"\<forall> r X h hh . (((r,X,L,h) \<in> modelsList \<and> same X h hh) \<longrightarrow> (r,X,L,hh) \<in> modelsList)"
apply (induct L)
apply clarsimp
apply (erule modelsList.elims, simp_all, clarsimp)
apply (rule modelsListNIL)
apply clarsimp
apply (erule modelsList.elims, simp,safe)
apply (erule_tac x="ha\<lfloor>l\<diamondsuit>ListTL\<rfloor>" in allE)
apply (erule_tac x="Xa" in allE)
apply (erule_tac x=ha in allE)
apply (erule_tac x=hh in allE)
apply (rule modelsListCONS, simp_all add: same_def)
done

lemma modelsListSame:
"\<lbrakk>(r,X,L,h) \<in> modelsList; same X h hh\<rbrakk> \<Longrightarrow> (r,X,L,hh) \<in> modelsList"
by (insert modelsListSameAux, fast)

locale Reverse =
fixes reverse  :: funame  and reverseloop :: funame
  and reverse_body :: expr  and reverseloop_body :: expr
  and iTail :: rname and i :: rname and j :: rname 
  and b :: iname
  and reverseSPEC :: vdmassn and reverseloopSPEC :: vdmassn
defines "reverse_body == LET rf j = Null;
                                b = RPrimop (\<lambda> r rr. if r = Nullref 
                                                     then grailbool True 
                                                     else grailbool False) i i
                          IN IF b THEN RVar j ELSE CALL reverseloop END"

    and "reverseloop_body == LET rf iTail = GetFr i ListTL;
                                        _ = PutFr i ListTL j;
                                     rf j = RVar i;
                                     rf i = RVar iTail;
                                        b = RPrimop (\<lambda> r rr. if r = Nullref 
                                                             then grailbool True 
                                                             else grailbool False) i i
                             IN IF b THEN RVar j ELSE CALL reverseloop END"

    defines reverseSPEC:
        "reverseSPEC E h hh v p == (\<forall> L X. impliesAssn (\<lambda> E1 h1 hh1 v1 p1 . (E1\<lfloor>i\<rfloor>,X,L,h1):modelsList)
                                                   (allocates (constVE (IVal 0)) && invokes (constVE (IVal 0)) && 
                                                     depth (constVE (IVal 0)) && calls (constVE (IVal (int L + 1)))) E h hh v p)"
        and loopSPEC:
        "reverseloopSPEC E h hh v p == (\<forall> L X. impliesAssn (\<lambda> E1 h1 hh1 v1 p1 . \<exists> r. E1\<lfloor>i\<rfloor> = Ref r \<and>(Ref r,X,L,h1):modelsList)
                                                   (allocates (constVE (IVal 0)) && invokes (constVE (IVal 0)) && 
                                                     depth (constVE (IVal 0)) && calls (constVE (IVal (int L)))) E h hh v p)"

  assumes funt_reverse: "funtable reverse = reverse_body"
      and funt_reverseloop: "funtable reverseloop = reverseloop_body"
      and spec_reverse: "spectable reverse = reverseSPEC"
      and spec_loop: "spectable reverseloop = reverseloopSPEC"
      and vardistinct:  "distinct[ListHD,ListTL] \<and> distinct[i,j,iTail] \<and> distinct[reverse, reverseloop]"

lemma (in Reverse) "\<rhd> (Call reverseloop) :: reverseloopSPEC"
apply (rule vdm_call)
apply (simp add: funt_reverseloop reverseloop_body_def)
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply (rule vdm_ax, simp)
apply (simp add: IMPLIES_def tkCallAssn_def loopSPEC impliesAssn_def, safe)
apply (erule GetFrElim, simp add: predicates)
apply (erule PutFrElim, insert vardistinct, auto)
apply (erule RVarElim, simp add: predicates)
apply (erule RVarElim, simp add: predicates)
apply (erule RopElim, simp add: predicates, simp add: predicates)
apply (erule CondElim, clarsimp)
defer 1
apply clarsimp
(*end of VCG*)
apply (simp add: loopSPEC predicates) apply (erule modelsList.elims, simp_all, clarsimp) apply (erule_tac x=ia in allE)
apply (simp add: predicates impliesAssn_def) apply (erule impE, clarsimp)
apply (subgoal_tac "\<exists> r. ha\<lfloor>l\<diamondsuit>ListTL\<rfloor> = Ref r", clarsimp) apply (rule_tac x=Xa in exI)
apply (erule modelsListSame) apply (simp add: same_def)
apply (case_tac "ha\<lfloor>l\<diamondsuit>ListTL\<rfloor>", auto)
apply (simp add: predicates, safe) apply(erule modelsList.elims, simp_all, safe) apply(erule modelsList.elims, simp_all)
done

lemma (in Reverse) "\<rhd> (Call reverse) :: reverseSPEC"
apply (rule MUTREC)
apply (subgoal_tac "finite {(Call reverse, reverseSPEC), (Call reverseloop, reverseloopSPEC)}")
apply (assumption, simp_all)
apply (simp add: consistent_def,safe)
apply (simp_all add: spec_reverse spec_loop)
apply (simp add: funt_reverse reverse_body_def)
apply (rule vdm_conseq) 
apply (rule vdm_basics)+
apply (rule vdm_ax, simp) 
apply (rule disjI2, simp) 
apply (simp add: IMPLIES_def, safe)
apply (erule RConstElim, simp)
apply (erule RopElim, simp add: predicates, simp add: predicates)
apply (erule CondElim,clarsimp)
prefer 3
apply (simp add: funt_reverseloop reverseloop_body_def)
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply (rule vdm_ax, simp)
apply (rule disjI2, simp) 
apply (simp add: IMPLIES_def loopSPEC impliesAssn_def, safe)
apply (erule GetFrElim, simp add: predicates)
apply (erule PutFrElim, insert vardistinct, auto)
apply (erule RVarElim, simp add: predicates)
apply (erule RVarElim, simp add: predicates)
apply (erule RopElim, simp add: predicates, simp add: predicates)
apply (erule CondElim, clarsimp)
defer 1
apply clarsimp
(*end of VCG*)
apply (simp_all add: reverseSPEC loopSPEC predicates) apply (erule modelsList.elims, simp_all, clarsimp) apply (erule_tac x=ia in allE)
apply (simp add: predicates impliesAssn_def) apply (erule impE, clarsimp)
apply (subgoal_tac "\<exists> r. ha\<lfloor>l\<diamondsuit>ListTL\<rfloor> = Ref r", clarsimp) apply (rule_tac x=Xa in exI)
apply (erule modelsListSame) apply (simp add: same_def)
apply (case_tac "ha\<lfloor>l\<diamondsuit>ListTL\<rfloor>", auto)
apply (simp_all add: predicates impliesAssn_def, rule)apply(erule modelsList.elims, simp_all)
apply (rule, erule_tac x=L in allE, erule impE, clarsimp)
apply (case_tac "E\<lfloor>i\<rfloor> ", auto)
apply(erule modelsList.elims, simp_all, safe) apply(erule modelsList.elims, simp_all)
done

consts occurs::"(ref \<times> ref \<times> nat \<times> heap) set"
(* (r1,r,n,h) :occurs if r1 occurs at position n in the list starting in r*)
inductive occurs intros
occursZero:"\<lbrakk>h@@l = Some LST; h\<lfloor>l\<diamondsuit>ListHD\<rfloor> = r1\<rbrakk> \<Longrightarrow> (r1,Ref l,0,h) : occurs"
occursSucc:"\<lbrakk>h@@l = Some LST; h\<lfloor>l\<diamondsuit>ListHD\<rfloor> = r2; r2 \<noteq> r1;
                  h\<lfloor>l\<diamondsuit>ListTL\<rfloor> = tail; (r1,tail,n,h):occurs
            \<rbrakk> \<Longrightarrow> (r1,Ref l,Suc n,h) : occurs"

locale Member =
fixes member  :: funame  and memberf :: funame  and memberg :: funame
  and member_body :: expr  and memberf_body :: expr  and memberg_body :: expr
  and memberSPEC :: vdmassn and memberfSPEC :: vdmassn and membergSPEC :: vdmassn
  and L :: rname and this :: rname and A :: rname
  and b :: iname
defines "member_body == LET rf L = RVar this IN CALL memberf END"
    and "memberf_body == LET b = RPrimop (\<lambda> r rr. if r = Nullref 
                                                  then grailbool True 
                                                  else grailbool False) L L
                         IN IF b THEN Expr.Int 0 ELSE CALL memberg END"
    and "memberg_body == LET rf HEAD = GetFr L ListHD;
                             rf L = GetFr L ListTL;
                                b = RPrimop (\<lambda> r rr. if r = rr then grailbool True else grailbool False) HEAD A
                         IN IF b THEN Expr.Int 1 ELSE CALL memberf END"

    defines member_SPEC:
        "memberSPEC E h hh v p == (\<forall> n X k. impliesAssn (\<lambda> E1 h1 hh1 v1 p1 . \<exists> r. E1\<lfloor>this\<rfloor> = Ref r \<and> (E1\<lfloor>this\<rfloor>,X,n,h1):modelsList \<and> 
                                                                               (E1\<lfloor>A\<rfloor>,Ref r,k,h) : occurs)
                                                       (allocates (constVE (IVal 0)) && invokes (constVE (IVal 0)) && 
                                                        depth (constVE (IVal 0)) && 
                                                        calls (constVE (IVal (2 * (int k) + 3)))) E h hh v p) \<and>
                                   (\<forall> n X . impliesAssn (\<lambda> E1 h1 hh1 v1 p1 . \<exists> r. E1\<lfloor>this\<rfloor> = Ref r \<and> (E1\<lfloor>this\<rfloor>,X,n,h1):modelsList \<and> 
                                                                              (\<forall> k . (E1\<lfloor>A\<rfloor>,Ref r,k,h) \<notin> occurs))
                                                        (allocates (constVE (IVal 0)) && invokes (constVE (IVal 0)) && 
                                                         depth (constVE (IVal 0)) && 
                                                         calls (constVE (IVal (2 * (int n) + 2)))) E h hh v p) \<and>
                                   (\<forall> n X . impliesAssn (\<lambda> E1 h1 hh1 v1 p1 . E1\<lfloor>this\<rfloor> = Nullref \<and> (E1\<lfloor>this\<rfloor>,X,n,h1):modelsList)
                                                        (allocates (constVE (IVal 0)) && invokes (constVE (IVal 0)) && 
                                                         depth (constVE (IVal 0)) && 
                                                         calls (constVE (IVal 2))) E h hh v p)"
        and memberf_SPEC:
        "memberfSPEC E h hh v p == (\<forall> n X k. impliesAssn (\<lambda> E1 h1 hh1 v1 p1 . \<exists> r. E1\<lfloor>L\<rfloor> = Ref r \<and> (E1\<lfloor>L\<rfloor>,X,n,h1):modelsList \<and> 
                                                                               (E1\<lfloor>A\<rfloor>,Ref r,k,h) : occurs)
                                                       (allocates (constVE (IVal 0)) && invokes (constVE (IVal 0)) && 
                                                        depth (constVE (IVal 0)) && 
                                                        calls (constVE (IVal (2 * (int k) + 2)))) E h hh v p) \<and>
                                   (\<forall> n X . impliesAssn (\<lambda> E1 h1 hh1 v1 p1 . \<exists> r. E1\<lfloor>L\<rfloor> = Ref r \<and> (E1\<lfloor>L\<rfloor>,X,n,h1):modelsList \<and> 
                                                                              (\<forall> k . (E1\<lfloor>A\<rfloor>,Ref r,k,h) \<notin> occurs))
                                                        (allocates (constVE (IVal 0)) && invokes (constVE (IVal 0)) && 
                                                         depth (constVE (IVal 0)) && 
                                                         calls (constVE (IVal (2 * (int n) + 1)))) E h hh v p) \<and>
                                   (\<forall> n X . impliesAssn (\<lambda> E1 h1 hh1 v1 p1 . E1\<lfloor>L\<rfloor> = Nullref \<and> (E1\<lfloor>L\<rfloor>,X,n,h1):modelsList)
                                                        (allocates (constVE (IVal 0)) && invokes (constVE (IVal 0)) && 
                                                         depth (constVE (IVal 0)) && 
                                                         calls (constVE (IVal 1))) E h hh v p)"
        and memberg_SPEC:
        "membergSPEC E h hh v p == (\<forall> n X k. impliesAssn (\<lambda> E1 h1 hh1 v1 p1 . \<exists> r. E1\<lfloor>L\<rfloor> = Ref r \<and> (E1\<lfloor>L\<rfloor>,X,n,h1):modelsList \<and> 
                                                                                    (E1\<lfloor>A\<rfloor>,Ref r,k,h) : occurs)
                                                       (allocates (constVE (IVal 0)) && invokes (constVE (IVal 0)) && 
                                                        depth (constVE (IVal 0)) && 
                                                        calls (constVE (IVal (2 * (int k) + 1)))) E h hh v p) \<and>
                                   (\<forall> n X . impliesAssn (\<lambda> E1 h1 hh1 v1 p1 . \<exists> r. E1\<lfloor>L\<rfloor> = Ref r \<and> (E1\<lfloor>L\<rfloor>,X,n,h1):modelsList \<and> 
                                                                                   (\<forall> k . (E1\<lfloor>A\<rfloor>,Ref r,k,h) \<notin> occurs))
                                                        (allocates (constVE (IVal 0)) && invokes (constVE (IVal 0)) && 
                                                         depth (constVE (IVal 0)) && 
                                                         calls (constVE (IVal (2 * (int n))))) E h hh v p)"

  assumes funt_member: "funtable member = member_body"
      and funt_memberf: "funtable memberf = memberf_body"
      and funt_memberg: "funtable memberg = memberg_body"
      and spec_member: "spectable member = memberSPEC"
      and spec_memberf: "spectable memberf = memberfSPEC"
      and spec_memberg: "spectable memberg = membergSPEC"
      and vardistinct:  "distinct[ListHD,ListTL] \<and> distinct[L,A,this,HEAD] \<and> distinct[member, memberf, memberg]"

lemma (in Member) "\<rhd> (Call memberf) :: memberfSPEC"
apply (rule MUTREC)
apply (subgoal_tac "finite {(Call memberf, memberfSPEC), (Call memberg, membergSPEC)}")
apply (assumption, simp_all)
apply (simp add: consistent_def,safe)
apply (simp_all add: spec_memberf spec_memberg)
apply (simp add: funt_memberf memberf_body_def)
apply (rule vdm_conseq) 
apply (rule vdm_basics)+
apply (rule vdm_ax, simp) 
apply (rule disjI2, simp) 
apply (simp add: IMPLIES_def, safe)
apply (erule RopElim, simp add: predicates, simp add: predicates)
apply (erule CondElim,clarsimp)
defer 1
defer 1
apply (simp add: funt_memberg memberg_body_def)
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply (subgoal_tac "(CALL memberf, memberfSPEC) \<in> {(CALL memberf, memberfSPEC), (CALL memberg, membergSPEC)}")
apply (rule vdm_ax, assumption, simp)
apply (simp add: IMPLIES_def memberg_SPEC impliesAssn_def, safe)
apply (erule GetFrElim, simp add: predicates)
apply (erule GetFrElim, simp add: predicates)
apply (insert vardistinct, auto)
apply (erule RopElim, simp add: predicates, simp add: predicates)
apply (erule CondElim, clarsimp)
defer 1
defer 1
apply (erule GetFrElim, simp add: predicates)
apply (erule GetFrElim, simp add: predicates)
apply (insert vardistinct, auto)
apply (erule RopElim, simp add: predicates, simp add: predicates)
apply (erule CondElim, clarsimp)
defer 1
defer 1
(*end of vcg*)
(* 6 side conditions left*)
apply (simp_all add: predicates memberf_SPEC memberg_SPEC impliesAssn_def)
(* 4 *)
apply clarsimp
apply (erule occurs.elims, simp+)
(*3*)
apply clarsimp
apply (rotate_tac -2, erule thin_rl, erule thin_rl)
apply (erule modelsList.elims, simp_all, clarsimp)
apply (erule occurs.elims, simp_all, clarsimp)
apply (erule_tac x=i in allE, erule_tac x=Xa in allE, erule_tac x=n in allE)
apply (erule impE, clarsimp)
apply (subgoal_tac "\<exists> r . h\<lfloor>la\<diamondsuit>ListTL\<rfloor> = Ref r", clarsimp)
  apply (erule occurs.elims, clarsimp, clarsimp)
apply simp
(*2*)
apply (clarsimp, subgoal_tac "(renv E A, Ref r, 0, hh) : occurs", clarsimp)
  apply (rule occursZero)
  apply (erule modelsList.elims, simp+)
(*1*)
apply clarsimp
apply (case_tac "h\<lfloor>r\<diamondsuit>ListTL\<rfloor> = Nullref")
apply (rotate_tac -2)
apply (erule impE, clarsimp)
apply (erule modelsList.elims, simp_all,clarsimp) apply fast
apply (erule modelsList.elims, simp_all, clarsimp) 
apply (erule modelsList.elims, simp_all)
(* case Ref *)
apply (erule modelsList.elims, simp_all, clarsimp)
apply (rotate_tac -6)
apply (erule_tac x=i in allE)
apply (erule impE) prefer 2 apply simp
apply (erule modelsList.elims, simp_all, clarsimp)
apply (rule, rule)
apply (rule modelsListCONS, simp+)
apply clarsimp
apply (subgoal_tac "(renv E A, Ref l, Suc k, h) \<in> occurs", simp)
apply (rule occursSucc, simp+)
done


lemma (in Member) "\<rhd> (Call member) :: memberSPEC"
apply (rule MUTREC)
apply (subgoal_tac "finite {(Call member, memberSPEC), (Call memberf, memberfSPEC), (Call memberg, membergSPEC)}")
apply (assumption, simp_all)
apply (simp add: consistent_def,safe)
apply (simp_all add: spec_member spec_member)
apply (simp add: funt_member member_body_def)
apply (rule vdm_conseq) 
apply (rule vdm_basics)+
apply (rule vdm_ax)
apply (subgoal_tac "(CALL memberf, memberfSPEC) \<in> {(CALL member, memberSPEC), (CALL memberf, memberfSPEC), (CALL memberg, membergSPEC)}", assumption, simp) 
apply (simp add: IMPLIES_def, safe)
apply (erule RVarElim, simp add: predicates, simp)
defer 1
apply (simp_all add: spec_memberf spec_memberg)
apply (simp add: funt_memberf memberf_body_def)
apply (rule vdm_conseq) 
apply (rule vdm_basics)+
apply (rule vdm_ax) 
apply (subgoal_tac "(CALL memberg, membergSPEC) \<in> {(CALL member, memberSPEC), (CALL memberf, memberfSPEC), (CALL memberg, membergSPEC)}", assumption, simp) 
apply (simp add: IMPLIES_def, safe)
apply (erule RopElim, simp add: predicates, simp add: predicates)
apply (erule CondElim,clarsimp)
defer 1
apply clarsimp
defer 1
apply (simp add: funt_memberg memberg_body_def)
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply (rule vdm_ax) 
apply (subgoal_tac "(CALL memberf, memberfSPEC) \<in> {(CALL member, memberSPEC), (CALL memberf, memberfSPEC), (CALL memberg, membergSPEC)}", assumption, simp)
apply (simp add: IMPLIES_def memberg_SPEC impliesAssn_def, safe)
apply (erule GetFrElim, simp add: predicates)
apply (erule GetFrElim, simp add: predicates)
apply (insert vardistinct, auto)
apply (erule RopElim, simp add: predicates, simp add: predicates)
apply (erule CondElim, clarsimp)
defer 1
apply clarsimp
defer 1
apply (erule GetFrElim, simp add: predicates)
apply (erule GetFrElim, simp add: predicates)
apply (insert vardistinct, auto)
apply (erule RopElim, simp add: predicates, simp add: predicates)
apply (erule CondElim, clarsimp)
defer 1
apply clarsimp
defer 1
(*end of vcg*)
(* 7 side conditions left*)
apply (simp_all add: predicates memberf_SPEC memberg_SPEC member_SPEC impliesAssn_def)
(* 5 *)
apply clarsimp
(* 4 *)
apply clarsimp
apply (erule occurs.elims, simp+)
(*3*)
apply clarsimp
apply (rotate_tac -2, erule thin_rl, erule thin_rl)
apply (erule modelsList.elims, simp_all, clarsimp)
apply (erule occurs.elims, simp_all, clarsimp)
apply (erule_tac x=i in allE, erule_tac x=Xa in allE, erule_tac x=n in allE)
apply (erule impE, clarsimp)
apply (subgoal_tac "\<exists> r . h\<lfloor>la\<diamondsuit>ListTL\<rfloor> = Ref r", clarsimp)
  apply (erule occurs.elims, clarsimp, clarsimp)
apply simp
(*2*)
apply (clarsimp, subgoal_tac "(renv E A, Ref r, 0, hh) : occurs", clarsimp)
  apply (rule occursZero)
  apply (erule modelsList.elims, simp+)
(*1*)
apply clarsimp
apply (case_tac "h\<lfloor>r\<diamondsuit>ListTL\<rfloor> = Nullref")
apply (rotate_tac -2)
apply (erule impE, clarsimp)
apply (erule modelsList.elims, simp_all,clarsimp) apply fast
apply (erule modelsList.elims, simp_all, clarsimp) 
apply (erule modelsList.elims, simp_all)
(* case Ref *)
apply (erule modelsList.elims, simp_all, clarsimp)
apply (rotate_tac -6)
apply (erule_tac x=i in allE)
apply (erule impE) prefer 2 apply simp
apply (erule modelsList.elims, simp_all, clarsimp)
apply (rule, rule)
apply (rule modelsListCONS, simp+)
apply clarsimp
apply (subgoal_tac "(renv E A, Ref l, Suc k, h) \<in> occurs", simp)
apply (rule occursSucc, simp+)
done
end
