val before_set2pred_simp_tac =
  (simp_tac (HOL_basic_ss addsimps [Collect_conj_eq RS sym,thm "Compl_Collect"]));

val split_simp_tac = (simp_tac (HOL_basic_ss addsimps [split_conv]));

(*****************************************************************************)
(** set2pred transforms sets inclusion into predicates implication,         **)
(** maintaining the original variable names.                                **)
(** Ex. "{x. x=0} <= {x. x <= 1}" -set2pred-> "x=0 --> x <= 1"              **)
(** Subgoals containing intersections (A Int B) or complement sets (-A)     **)
(** are first simplified by "before_set2pred_simp_tac", that returns only   **)
(** subgoals of the form "{x. P x} <= {x. Q x}", which are easily           **)
(** transformed.                                                            **)
(** This transformation may solve very easy subgoals due to a ligth         **)
(** simplification done by (split_all_tac)                                  **)
(*****************************************************************************)

fun set2pred i thm = let fun mk_string [] = ""
                           | mk_string (x::xs) = x^" "^mk_string xs;
                       (*  
                         val vars=get_vars(thm);
                         val var_string = mk_string (map (fst o dest_Free) vars);
                        *)
      in ((before_set2pred_simp_tac i) THEN_MAYBE
          (EVERY [rtac subsetI i, 
                  (* do we really need Collect[ID] since we work with sets, not
                     functions as assertions anyway -- HWL
                  rtac CollectI i,
                  dtac CollectD i, *)
                  (TRY(split_all_tac i)) THEN_MAYBE
                  ((* (rename_tac var_string i) THEN *)
                   (full_simp_tac (HOL_basic_ss addsimps [split_conv]) i)) ])) thm
      end;

(*****************************************************************************)
(** BasicSimpTac is called to simplify all verification conditions. It does **)
(** a light simplification by applying "mem_Collect_eq", then it calls      **)
(** MaxSimpTac, which solves subgoals of the form "A <= A",                 **)
(** and transforms any other into predicates, applying then                 **)
(** the tactic chosen by the user, which may solve the subgoal completely.  **)
(*****************************************************************************)

val simpletac =   
  clarsimp_tac 
    (HOL_cs ,
    (HOL_basic_ss addsimps [mem_Collect_eq,split_conv] addsimprocs [record_simproc]));

fun MaxSimpTac tac = FIRST'[rtac subset_refl, 
			    set2pred THEN_MAYBE' (simpletac THEN_MAYBE' tac),
                            K all_tac]


fun BasicSimpTac tac = simpletac THEN_MAYBE' MaxSimpTac tac;

val VDM_leaf_rules = map thm ["vdm_null", "vdm_int", "vdm_ivar", "vdm_rvar", "vdm_prim", "vdm_rprim", "vdm_getfi", "vdm_getfr", "vdm_putfi", "vdm_putfr", "vdm_new", "vdm_if"];

val VDM_let_rules = map thm ["vdm_leti", "vdm_letr", "vdm_letv"];


(* precond: if a pre-condition is to be solved; 
   rep:     if tactic should loop and fail if not solved 
		(otherwise will execute a single step, and always return a result)
 *)

 fun tacif flag tac = if flag then tac else all_tac

 (* --------------------------------------------------------------------------- *)
 (* std *)
(*
 fun HoareMaybeApplyIndHypThenAgainMaybeNot i = 
   SUBGOAL (fn (prop,_) =>
      let val concl = Logic.strip_assums_concl prop in
          case concl (* fixme: dest *) of 
	  (Const ("Trueprop", _) $
	   (Const ("ToyHLbasic.hoare_valid",_) $ P $ expr $ Q)) =>
	      (case expr of 
		Const("ToyGrailDef.expr.Call",_) $ Free(fnname,_) =>
		   (tracing ("__ Using HRecWF for function " ^ fnname);
  	           EVERY [rtac (thm "HWC") i, assumption i])
              | Const("ToyGrailDef.expr.Call",_) $ Const(fnname,_) =>
		(tracing ("__ Using HRecWF for function " ^ fnname);
  	         EVERY [rtac (thm "HWC") i, assumption i])
	     | _ => no_tac)
         | _ => no_tac
      end) i
*)
(*
 (* Apply HRecWF' to a "CALL foo" instance *)
 fun HoareRecWFCall i =
   SUBGOAL (fn (prop,_) =>
      let val concl = Logic.strip_assums_concl prop in
          case concl (* fixme: dest *) of 
	  (Const ("Trueprop", _) $
	   (Const ("ToyHLbasic.hoare_valid",_) $ P $ expr $ Q)) =>
	      (case expr of 
		Const("ToyGrailDef.expr.Call",_) $ Free(fnname,_) =>
		   (tracing ("__ Using HRecWF for function " ^ fnname);
  	           res_inst_tac [("r","fun_wfmeasure_table " ^ fnname)] (thm "HRecWF'") i)
              | Const("ToyGrailDef.expr.Call",_) $ Const(fnname,_) =>
		(tracing ("__ Using HRecWF for function " ^ fnname);
		 res_inst_tac [("r","fun_wfmeasure_table " ^ fnname)] (thm "HRecWF'") i)
	     | _ => no_tac)
         | _ => no_tac
      end) i

 fun HoareRecWFInvoke i =
   SUBGOAL (fn (prop,_) =>
      let val concl = Logic.strip_assums_concl prop in
          case concl (* fixme: dest *) of 
	  (Const ("Trueprop", _) $
	   (Const ("ToyHLbasic.hoare_valid",_) $ P $ expr $ Q)) =>
	      (case expr of 
		Const("ToyGrailDef.expr.Invoke",_) $ Free(rn,_) $ Free(mn,_)  $ pn =>
		   (tracing ("__ HoareRecWFInvoke for obj " ^ rn ^ " and method " ^ mn);
  	           res_inst_tac [("r","meth_wfmeasure_table " ^ mn)] (thm "HRecWF'") i)
              | Const("ToyGrailDef.expr.Invoke",_) $ Free(rn,_) $ Const(mn,_)  $ pn =>
		   (tracing ("__ HoareRecWFInvoke for obj " ^ rn ^ " and method " ^ mn);
  	           res_inst_tac [("r","meth_wfmeasure_table " ^ mn)] (thm "HRecWF'") i)
              | Const("ToyGrailDef.expr.Invoke",_) $ Const(rn,_) $ Free(mn,_)  $ pn =>
		   (tracing ("__ HoareRecWFInvoke for obj " ^ rn ^ " and method " ^ mn);
  	           res_inst_tac [("r","meth_wfmeasure_table " ^ mn)] (thm "HRecWF'") i)
              | Const("ToyGrailDef.expr.Invoke",_) $ Const(rn,_) $ Const(mn,_)  $ pn =>
		   (tracing ("__ HoareRecWFInvoke for obj " ^ rn ^ " and method " ^ mn);
  	           res_inst_tac [("r","meth_wfmeasure_table " ^ mn)] (thm "HRecWF'") i)
	     | _ => no_tac)
         | _ => no_tac
      end) i

 fun HoareRecWFInvokestatic i =
   SUBGOAL (fn (prop,_) =>
      let val concl = Logic.strip_assums_concl prop in
          case concl (* fixme: dest *) of 
	  (Const ("Trueprop", _) $
	   (Const ("ToyHLbasic.hoare_valid",_) $ P $ expr $ Q)) =>
	      (case expr of 
		Const("ToyGrailDef.expr.InvokeStatic",_) $ Free(cn,_) $ Free(mn,_)  $ pn =>
		   (tracing ("__ HoareRecWFInvokeStatic for class " ^ cn ^ " and method " ^ mn);
  	           res_inst_tac [("r","meth_wfmeasure_table " ^ mn)] (thm "HRecWF'") i)
              | Const("ToyGrailDef.expr.InvokeStatic",_) $ Free(cn,_) $ Const(mn,_)  $ pn =>
		   (tracing ("__ HoareRecWFInvokeStatic for class " ^ cn ^ " and method " ^ mn);
  	           res_inst_tac [("r","meth_wfmeasure_table " ^ mn)] (thm "HRecWF'") i)
              | Const("ToyGrailDef.expr.InvokeStatic",_) $ Const(cn,_) $ Free(mn,_)  $ pn =>
		   (tracing ("__ HoareRecWFInvokeStatic for class " ^ cn ^ " and method " ^ mn);
  	           res_inst_tac [("r","meth_wfmeasure_table " ^ mn)] (thm "HRecWF'") i)
              | Const("ToyGrailDef.expr.InvokeStatic",_) $ Const(cn,_) $ Const(mn,_)  $ pn =>
		   (tracing ("__ HoareRecWFInvokeStatic for class " ^ cn ^ " and method " ^ mn);
  	           res_inst_tac [("r","meth_wfmeasure_table " ^ mn)] (thm "HRecWF'") i)
	     | _ => no_tac)
         | _ => no_tac
      end) i
*)
 fun CheckInvoke tac i st = st |>
   SUBGOAL (fn (prop,_) =>
      let val concl = Logic.strip_assums_concl prop in
          case concl (* fixme: dest *) of 
	  (Const ("Trueprop", _) $
	   (Const ("vdm_valid",_) $ P $ expr $ Q)) =>
	      (case expr of 
		Const("Invoke",_) $  Free(rn,_) $ Free(mn,_) $ pn =>
		   (tracing ("__ Invoke for class " ^ rn ^ " and method " ^ mn);
  	            all_tac)
              | Const("Invoke",_) $ Free(rn,_) $ Const(mn,_) $ pn =>
		   (tracing ("__ Invoke for class " ^ rn ^ " and method " ^ mn);
  	            all_tac)
              | Const("Invoke",_) $ Const(rn,_) $ Free(mn,_) $ pn =>
		   (tracing ("__ Invoke for class " ^ rn ^ " and method " ^ mn);
  	            all_tac)
              | Const("Invoke",_) $ Const(rn,_) $ Const(mn,_) $ pn =>
		   (tracing ("__ Invoke for class " ^ rn ^ " and method " ^ mn);
  	            all_tac)
	     | _ => no_tac)
         | _ => no_tac
      end) i

 (* --------------------------------------------------------------------------- *)
 (* WAS hoare1: using merged Adaptation and CALL; adaptation is Nipkow-style *)

 (* Apply HRecWF' to a "CALL foo" instance 
 fun HoareRecWFCall1 i =
   SUBGOAL (fn (prop,_) =>
      let val concl = Logic.strip_assums_concl prop in
          case concl (* fixme: dest *) of 
	  (Const ("Trueprop", _) $
	   (Const ("ToyHLbasic.hoare_valid",_) $ P $ expr $ Q)) =>
	      (case expr of 
		Const("ToyGrailDef.expr.Call",_) $ Free(fnname,_) =>
		   (tracing (".. Using HRecWF for function " ^ fnname);
  	           res_inst_tac [("r","fun_wfmeasure_table " ^ fnname)] (thm "HRecWF'") i)
              | Const("ToyGrailDef.expr.Call",_) $ Const(fnname,_) =>
		(tracing (".. Using HRecWF for function " ^ fnname);
		 res_inst_tac [("r","fun_wfmeasure_table " ^ fnname)] (thm "HRecWF'") i)
	     | _ => no_tac)
         | _ => no_tac
      end) i
 *)
 fun LetRule1Tac tac precond rep i = 
     (tracing "-- Trying Let" ; 
      EVERY[resolve_tac VDM_let_rules i,
            fn x => (tracing ".. Got lucky with a Let"; all_tac x),
            tacif rep (Rule1Tac tac true(*!!was:false!!*) rep (i+1))]  (* let body *)
     )
 and Rule1Tac tac precond rep i st = st |>  
    (  (LetRule1Tac tac precond rep i  THEN 
         tacif rep (Rule1Tac tac precond rep i))            (* let header *)
       ORELSE
     ( 
     (tracing ".. Once more unto the breach" ; 
      FIRST[trace_goalno_tac (resolve_tac VDM_leaf_rules) i,
	    (tracing ".. No leaf, Trying If" ; 
	     EVERY[trace_goalno_tac (rtac (thm "vdm_if'")) i,
                   tacif rep (Rule1Tac tac true(*!!was:false!!*) rep (i+2)), (* else branch *)
                   tacif rep (Rule1Tac tac true(*!!was:false!!*) rep (i+1))]), (* then branch *)
	    (tracing ".. No If, Trying Call" ; 
             (assume_tac i)      (* CALL: induction hyp by assumption *)
				  (* FIXME: would be nice to thin remaining goals here *)
              ORELSE		  (* or, try unravelling body. *)
	      (EVERY[(tracing ".. Trying RecWFCall" ; vdm_call i),  (* HoareRecWFCall i),*)
		     rtac allI i,
		     rtac impI i,
                     trace_goalno_tac (rtac (thm "HCallAdapt00")) i, (* or HCall0 *)
		     (* rtac allI i, *)
		     tac i,	  (* unfolding of fntable should be done by tac! *)
                     tacif rep (Rule1Tac tac true rep i)])),    
				(* FIXME: why extra subgoal here? *)
	    (tracing ".. No Call, Trying Invoke" ; 
             (assume_tac i)    (* CALL: induction hyp by assumption *)
				(* FIXME: would be nice to thin remaining goals here *)
              ORELSE		(* or, try unravelling body. *)
	      (EVERY[vdm_call i,    (* HoareRecWFCall i,  *)
		     rtac allI i,
		     rtac impI i,
                     trace_goalno_tac (rtac (thm "vdm_invoke")) i,
		     rtac allI i,  
		     tac i,
                     tacif rep (Rule1Tac tac false rep i)])),       (* method body *)

	    (tracing ".. Nothing at all, let's sulk in a corner" ; 
             if rep then (K all_tac i) else no_tac )    (* if stepping, must succeed on some rule. *)
             ]
       THEN 
             (if precond 
               then (if rep then (fn x=>x) else TRY) (tracing ".. BasicSimpTac" ; trace_goalno_tac (BasicSimpTac tac) i)
               else (if rep then (fn x=>x) else TRY) (tracing ".. subset_refl" ; (trace_goalno_tac (rtac (thm "subset_refl")) i))
            )
         )) )

fun vcg_tac tac i thm = SUBGOAL (fn _ =>
   (Rule1Tac tac true true i)) i thm

fun vcg_step_tac tac i thm = SUBGOAL (fn _ =>
   (Rule1Tac tac true false i)) i thm

 (* --------------------------------------------------------------------------- *)
 (* WAS hoare3: using merged Adaptation and CALL; adaptation is Kleyman-style *)

 (* Apply HRecWF' to a "CALL foo" instance *)
 fun HoareRecWFCall3 i =
   SUBGOAL (fn (prop,_) =>
      let val concl = Logic.strip_assums_concl prop in
          case concl (* fixme: dest *) of 
	  (Const ("Trueprop", _) $
	   (Const ("vdm_valid",_) $ P $ expr $ Q)) =>
	      (case expr of 
		Const("Call",_) $ Free(fnname,_) =>
		   (tracing ("__ Using HRecWF for function " ^ fnname);
                    res_inst_tac [("r","fun_wfmeasure_table " ^ fnname)] (thm "HRecWF'") i)
              | Const("Call",_) $ Const(fnname,_) =>
		  (tracing ("__ Using HRecWF for function " ^ fnname);
		   res_inst_tac [("r","fun_wfmeasure_table " ^ fnname)] (thm "HRecWF'") i)
	     | _ => no_tac)
         | _ => no_tac
      end) i

 fun LetRuleTac tac precond rep i = 
     (tracing "-- Trying Let" ; 
      EVERY[resolve_tac VDM_let_rules i,
            fn x => (tracing ".. Got lucky with a Let"; all_tac x),
            tacif rep (RuleTac tac true(*!!was:false!!*) rep (i+1))]  (* let body *)
     )
 and RuleTac tac precond rep i st = st |>  
    (  (LetRuleTac tac precond rep i  THEN 
         tacif rep (RuleTac tac precond rep i))            (* let header *)
       ORELSE
     ( 
     (tracing "__ Once more unto the breach" ; 
      FIRST[trace_goalno_tac (resolve_tac VDM_leaf_rules) i,
	    (tracing "__ No leaf, Trying If" ; 
	     EVERY[trace_goalno_tac (rtac (thm "vdm_if'")) i,
                   tacif rep (RuleTac tac true(*!!was:false!!*) rep (i+2)),   (* else branch *)
                   tacif rep (RuleTac tac true(*!!was:false!!*) rep (i+1))]), (* then branch *)
	    (tracing "__ No If, Trying Call" ; 
             (HoareMaybeApplyIndHypThenAgainMaybeNot i)       (* apply ind hyp if possb *)
				  (* FIXME: would be nice to thin remaining goals here *)
              ORELSE		  (* or, try unravelling body. *)
	      (EVERY[(tracing "__ Trying RecWFCall" ; HoareRecWFCall3 i),
		     rtac allI i,
		     rtac impI i,
                     rtac (thm "HSP") i,
                     trace_goalno_tac (rtac (thm "HKleymanAdapt00")) i, (* or ((thm "HCallAdapt00") i),*)  (* or HCall0 *)
		     (* rtac allI i, *)
		     tac i,	  (* unfolding of fntable should be done by tac! *)
                     tacif rep (RuleTac tac true rep i)])),    
				(* FIXME: why extra subgoal here? *)
	    (tracing "__ No Call, Trying Invoke" ; 
             (assumption i)       (* apply ind hyp if possb *)
				(* FIXME: would be nice to thin remaining goals here *)
              ORELSE		(* or, try unravelling body. *)
	      (EVERY[HoareRecWFCall3 i,   (* to be tested *)
		     rtac allI i,
		     rtac impI i,
                     trace_goalno_tac (rtac (thm "HInvoke")) i,
		     rtac allI i,  
		     tac i,
                     tacif rep (RuleTac tac false rep i)])),       (* method body *)

	    (tracing "__ No Invoke, trying InvokeStatic" ; 
             (assumption i)       (* apply ind hyp if possb *)
				(* FIXME: would be nice to thin remaining goals here *)
              ORELSE		(* or, try unravelling body. *)
	      (EVERY[HoareRecWFInvokestatic i,   (* to be tested *)
		     rtac allI i,
		     rtac impI i,
                     trace_goalno_tac (rtac (thm "HInvokeStatic")) i,
		     rtac allI i,  
		     tac i,
                     tacif rep (RuleTac tac false rep i)])),       (* method body *)

	    (tracing "__ Nothing at all, let's sulk in a corner" ; 
             if rep then (K all_tac i) else no_tac )    (* if stepping, must succeed on some rule. *)
             ]
       THEN 
             (if precond 
               then (if rep then (fn x=>x) else TRY) (tracing "__ BasicSimpTac" ; trace_goalno_tac (BasicSimpTac tac) i)
               else (if rep then (fn x=>x) else TRY) (tracing "__ subset_refl" ; (trace_goalno_tac (rtac (thm "subset_refl")) i))
            )
         )) )

fun vcg1_tac tac i thm = SUBGOAL (fn _ =>
   (RuleTac tac true true i)) i thm

fun vcg1_step_tac tac i thm = SUBGOAL (fn _ =>
   (RuleTac tac true false i)) i thm

(* --------------------------------------------------------------------------- *)
(* rec: using invariants in function calls *)

 (* Similar to HoareRecWFCall, but inserting pre- and post-conditions here *)

 fun HoareInst thmname p tab i =
   SUBGOAL (fn (prop,_) =>
      let val concl = Logic.strip_assums_concl prop in
          case concl (* fixme: dest *) of 
	  (Const ("Trueprop", _) $
	   (Const ("ToyHLbasic.hoare_valid",_) $ P $ expr $ Q)) =>
	      (case expr of 
		Const("ToyGrailDef.expr.Call",_) $ Free(fnname,_) =>
		   (tracing ("__ HoareInst for function " ^ fnname);
		 res_inst_tac [(p,tab ^ " " ^ fnname)] (thm thmname) i)
              | Const("ToyGrailDef.expr.Call",_) $ Const(fnname,_) =>
		(tracing ("__ HoareInst for function " ^ fnname);
		 res_inst_tac [(p,tab ^ " " ^ fnname)] (thm thmname) i)
	     | _ => no_tac)
         | _ => no_tac
      end) i

 fun HoareLetRuleTacRec tac precond rep i = 
     (tracing "-- Trying Let" ; 
      EVERY[resolve_tac VDM_let_rules i,
            fn x => (tracing ".. Got lucky with a Let"; all_tac x),
            tacif rep (RuleTacRec tac true(*!!was:false!!*) rep (i+1))]  (* let body *)
     )
 and RuleTacRec tac precond rep i st = st |>  
    (  (HoareLetRuleTacRec tac precond rep i  THEN 
        tacif rep (RuleTacRec tac precond rep i))            (* let header *)
       ORELSE
     ( 
     (tracing "Trying Leaf" ; 
      FIRST[resolve_tac VDM_leaf_rules i,
	    (tracing "Trying If" ; 
	     EVERY[rtac (thm "HIf'") i,
                   tacif rep (RuleTacRec tac true(*!!was:false!!*) rep (i+2)),     (* else branch *)
                   tacif rep (RuleTacRec tac true(*!!was:false!!*) rep (i+1))]),	(* then branch *)
             ((EVERY[HoareInst "HCallAux0" "Q'" "fun_postassn_table" i,
                     (* or use some form of adaptation rule with hard-wired table lookup
                     rtac (thm "HWC") i,
                     rtac (thm "HCallAdapt3") i,
		     *)
		     tac (i+1),
                     HoareInst "HSP" "P'" "fun_preassn_table" i,
                     tac i])),
             ((EVERY[rtac (thm "HSP") i,
                     rtac (thm "HInvoke") i,
		     rtac allI i,  
		     tac i,
                     tacif rep (RuleTacRec tac false rep i)])),    (* method body *)

             if rep then (K all_tac i) else no_tac  (* if stepping, must succeed on some rule. *)
             ]
       THEN (tracing "Done" ; 
             (if precond 
               then (if rep then (fn x=>x) else TRY) (BasicSimpTac tac i)
               else (if rep then (fn x=>x) else TRY) (rtac (thm "subset_refl") i))
            )
         )) )

 (* --------------------------------------------------------------------------- *)
 (* check whether top level thing in conclusion is a hoare_valid of an expr *)

 fun CheckExpr tac i  st = st |>  
   SUBGOAL (fn (prop,_) =>
      let val concl = Logic.strip_assums_concl prop in
          case concl of 
	  (Const ("Trueprop", _) $
	   (Const ("vdm_valid",_) $ P $ expr $ Q)) =>
	      (case expr of 
		  Const("Call",_) $ Free(fnname,_) =>
		   (tracing ("^^ it is a CALL " ^ fnname); all_tac)
		| Const("Invoke",_) $ rname1 $ mname $ rname2 =>
		   (tracing "^^ it is a Invoke "; all_tac)
		| Const("Null",_) =>
		   (tracing "^^ it is a Null "; all_tac)
		| Const("Int",_) $ i =>
		   (tracing "^^ it is a Int "; all_tac)
		| Const("IVar",_) $ iname  =>
		   (tracing "^^ it is a IVar "; all_tac)
		| Const("RVar",_) $ rname  =>
		   (tracing "^^ it is a RVar "; all_tac)
		| Const("Primop",_) $ f $ iname1 $ iname2  =>
		   (tracing "^^ it is a Primop "; all_tac)
		| Const("RPrimop",_) $ f $ rname1 $ rname2  =>
		   (tracing "^^ it is a RPrimop "; all_tac)
		| Const("New",_) $ cname  =>
		   (tracing "^^ it is a New "; all_tac)
		| Const("If_",_) $ iname $ expr1 $ expr2 =>
		   (tracing "^^ it is a If "; all_tac)
		| Const("Leti",_) $ iname $ expr1 $ expr2 =>
		   (tracing "^^ it is a Leti "; all_tac)
		| Const("Letr",_) $ rname $ expr1 $ expr2 =>
		   (tracing "^^ it is a Letr "; all_tac)
		| Const("GetFi",_) $ ifldname $ iname2 =>
		   (tracing "^^ it is a GetFi "; all_tac)
		| Const("GetFr",_) $ ifldname $ iname =>
		   (tracing "^^ it is a GetFr "; all_tac)
		| Const("PutFi",_) $ iname1 $ ifldname $ iname2 =>
		   (tracing "^^ it is a PutFi "; all_tac)
		| Const("PutFr",_) $ rname $ ifldname $ iname =>
		   (tracing "^^ it is a PutFr "; all_tac)
	        | _ => (tracing "^^ no match in inner case over expr" ; all_tac))
         | _ => (tracing "^^ HoareInst: no match in outer case over concl" ; no_tac)
      end) i

 (* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ *)

fun vcg_check_expr_tac tac i thm = SUBGOAL (fn _ =>
   (CheckExpr tac i)) i thm

fun vcg_check_invoke_tac tac i thm = SUBGOAL (fn _ =>
   (CheckInvoke tac i)) i thm

(*
fun vcg_rec_tac tac i thm = SUBGOAL (fn _ =>
   (RuleTacRec tac true true i)) i thm

fun vcg_rec_step_tac tac i thm = SUBGOAL (fn _ =>
   (RuleTacRec tac true false i)) i thm

*)