(* $Id: ProofConsumerArith.thy,v 1.1 2003/11/19 14:40:43 a1hloidl Exp $

   The proof consumer in this case uses a trivial formula and a proof term
   as printed by the consumer and replays the proof to check it.
*)

theory ProofConsumerArith = Main:

(* version from: ProofSyntax.print_proof_of false (thm "bonzo_1701") *)
ML {*
val my_prf = ProofSyntax.read_proof Main.thy false
"allI \<cdot> _ \<bullet>
 (\<Lambda>m. ccontr \<cdot> _ \<bullet>
       (\<Lambda>H: _.
         equal_elim \<cdot> _ \<cdot> _ \<bullet>
          (combination \<cdot> Trueprop \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
            (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
              (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                (combination \<cdot> op \<le> \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
                  (combination \<cdot> op + m \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
                    One_nat_def)) \<bullet>
                (reflexive \<cdot> _)) \<bullet>
              (equal_elim \<cdot> _ \<cdot> _ \<bullet>
                (eq_cong2 \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                  (equal_elim \<cdot> _ \<cdot> _ \<bullet>
                    (symmetric \<cdot> _ \<cdot> _ \<bullet>
                      (combination \<cdot> Trueprop \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
                        (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                          (combination \<cdot> op = \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
                            (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                              (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                  (combination \<cdot> op \<le> \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
                                    (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                      (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                        (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                          (combination \<cdot> op + \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
 (reflexive \<cdot> _) \<bullet>
 (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
   (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
     (combination \<cdot> op * \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
       (eq_reflection \<cdot> _ \<cdot> _ \<bullet> numeral_0_eq_0)) \<bullet>
     (reflexive \<cdot> _)) \<bullet>
   (eq_reflection \<cdot> _ \<cdot> _ \<bullet> (mult_0 \<cdot> _)))) \<bullet>
                                          (reflexive \<cdot> _)) \<bullet>
                                        (eq_reflection \<cdot> _ \<cdot> _ \<bullet>
                                          (add_Suc_right \<cdot> _ \<cdot> _))) \<bullet>
                                      (combination \<cdot> Suc \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                        (reflexive \<cdot> _) \<bullet>
                                        (eq_reflection \<cdot> _ \<cdot> _ \<bullet>
                                          (add_0_right \<cdot> _))))) \<bullet>
                                  (eq_reflection \<cdot> _ \<cdot> _ \<bullet> numeral_0_eq_0)) \<bullet>
                                (eq_reflection \<cdot> _ \<cdot> _ \<bullet> (le_0_eq \<cdot> _))) \<bullet>
                              (Eq_FalseI \<cdot> _ \<bullet> (Suc_not_Zero \<cdot> _)))) \<bullet>
                          (reflexive \<cdot> _)))) \<bullet>
                    (HOL.refl \<cdot> _))) \<bullet>
                (eq_reflection \<cdot> _ \<cdot> _ \<bullet>
                  (HOL.trans \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                    (equal_elim \<cdot> _ \<cdot> _ \<bullet>
                      (symmetric \<cdot> _ \<cdot> _ \<bullet>
                        (combination \<cdot> Trueprop \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
                          (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                            (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                              (combination \<cdot> op = \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
                                (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                  (combination \<cdot> op \<le> \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
                                    (combination \<cdot> op + m \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                      (reflexive \<cdot> _) \<bullet>
                                      (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                        (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                          (combination \<cdot> Suc \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
 (reflexive \<cdot> _) \<bullet>
 (eq_reflection \<cdot> _ \<cdot> _ \<bullet> (HOL.sym \<cdot> _ \<cdot> _ \<bullet> numeral_0_eq_0))) \<bullet>
                                          (eq_reflection \<cdot> _ \<cdot> _ \<bullet>
 (Suc_eq_add_numeral_1 \<cdot> _))) \<bullet>
                                        (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                          (combination \<cdot> op + Numeral0 \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
 (reflexive \<cdot> _) \<bullet>
 (eq_reflection \<cdot> _ \<cdot> _ \<bullet> (HOL.sym \<cdot> _ \<cdot> _ \<bullet> numeral_1_eq_1))) \<bullet>
                                          (eq_reflection \<cdot> _ \<cdot> _ \<bullet>
 (equal_elim \<cdot> _ \<cdot> _ \<bullet>
   (combination \<cdot> Trueprop \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
     (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
       (combination \<cdot> op = \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
         (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
           (combination \<cdot> op + \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
             (eq_reflection \<cdot> _ \<cdot> _ \<bullet> (HOL.sym \<cdot> _ \<cdot> _ \<bullet> numeral_0_eq_0))) \<bullet>
           (reflexive \<cdot> _))) \<bullet>
       (reflexive \<cdot> _))) \<bullet>
   (add_0 \<cdot> _))))))) \<bullet>
                                  (reflexive \<cdot> _))) \<bullet>
                              (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                (combination \<cdot> op \<le> \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
                                  (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                    (combination \<cdot> op + \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                      (reflexive \<cdot> _) \<bullet>
                                      (eq_reflection \<cdot> _ \<cdot> _ \<bullet>
                                        (equal_elim \<cdot> _ \<cdot> _ \<bullet>
                                          (combination \<cdot> Trueprop \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
 (reflexive \<cdot> _) \<bullet>
 (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
   (combination \<cdot> op = \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
     (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
       (combination \<cdot> op * \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
         (eq_reflection \<cdot> _ \<cdot> _ \<bullet> (HOL.sym \<cdot> _ \<cdot> _ \<bullet> numeral_1_eq_1))) \<bullet>
       (reflexive \<cdot> _))) \<bullet>
   (reflexive \<cdot> _))) \<bullet>
                                          (mult_1 \<cdot> _)))) \<bullet>
                                    (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                      (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                        (combination \<cdot> Suc \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                          (reflexive \<cdot> _) \<bullet>
                                          (eq_reflection \<cdot> _ \<cdot> _ \<bullet>
 (HOL.sym \<cdot> _ \<cdot> _ \<bullet> numeral_0_eq_0))) \<bullet>
                                        (eq_reflection \<cdot> _ \<cdot> _ \<bullet>
                                          (Suc_eq_add_numeral_1 \<cdot> _))) \<bullet>
                                      (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                        (combination \<cdot> op + Numeral0 \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                          (reflexive \<cdot> _) \<bullet>
                                          (eq_reflection \<cdot> _ \<cdot> _ \<bullet>
 (HOL.sym \<cdot> _ \<cdot> _ \<bullet> numeral_1_eq_1))) \<bullet>
                                        (eq_reflection \<cdot> _ \<cdot> _ \<bullet>
                                          (equal_elim \<cdot> _ \<cdot> _ \<bullet>
 (combination \<cdot> Trueprop \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
   (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
     (combination \<cdot> op = \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
       (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
         (combination \<cdot> op + \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
           (eq_reflection \<cdot> _ \<cdot> _ \<bullet> (HOL.sym \<cdot> _ \<cdot> _ \<bullet> numeral_0_eq_0))) \<bullet>
         (reflexive \<cdot> _))) \<bullet>
     (reflexive \<cdot> _))) \<bullet>
 (add_0 \<cdot> _))))))) \<bullet>
                                (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                  (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                    (combination \<cdot> op + \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                      (reflexive \<cdot> _) \<bullet>
                                      (eq_reflection \<cdot> _ \<cdot> _ \<bullet>
                                        (equal_elim \<cdot> _ \<cdot> _ \<bullet>
                                          (combination \<cdot> Trueprop \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
 (reflexive \<cdot> _) \<bullet>
 (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
   (combination \<cdot> op = \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
     (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
       (combination \<cdot> op * \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
         (eq_reflection \<cdot> _ \<cdot> _ \<bullet> (HOL.sym \<cdot> _ \<cdot> _ \<bullet> numeral_1_eq_1))) \<bullet>
       (reflexive \<cdot> _))) \<bullet>
   (reflexive \<cdot> _))) \<bullet>
                                          (mult_1 \<cdot> _)))) \<bullet>
                                    (reflexive \<cdot> _)) \<bullet>
                                  (eq_reflection \<cdot> _ \<cdot> _ \<bullet>
                                    (equal_elim \<cdot> _ \<cdot> _ \<bullet>
                                      (combination \<cdot> Trueprop \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                        (reflexive \<cdot> _) \<bullet>
                                        (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                          (combination \<cdot> op = \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
 (reflexive \<cdot> _) \<bullet>
 (combination \<cdot> op + m \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
   (eq_reflection \<cdot> _ \<cdot> _ \<bullet> (HOL.sym \<cdot> _ \<cdot> _ \<bullet> numeral_0_eq_0)))) \<bullet>
                                          (reflexive \<cdot> _))) \<bullet>
                                      (add_0_right \<cdot> _)))))) \<bullet>
                            (eq_reflection \<cdot> _ \<cdot> _ \<bullet> (simp_thms_6 \<cdot> _))))) \<bullet>
                      TrueI) \<bullet>
                    (HOL.trans \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                      (nat_le_add_iff1 \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                        (equal_elim \<cdot> _ \<cdot> _ \<bullet>
                          (symmetric \<cdot> _ \<cdot> _ \<bullet>
                            (combination \<cdot> Trueprop \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
                              (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                (eq_reflection \<cdot> _ \<cdot> _ \<bullet>
                                  (le_nat_number_of_eq_not_less \<cdot> _ \<cdot> _)) \<bullet>
                                (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                  (combination \<cdot> Not \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
                                    (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                      (eq_reflection \<cdot> _ \<cdot> _ \<bullet>
                                        (less_nat_number_of \<cdot> _ \<cdot> _)) \<bullet>
                                      (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                        (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                          (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
 (combination \<cdot> If \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
   (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (eq_reflection \<cdot> _ \<cdot> _ \<bullet> (bin_rel_simps_12 \<cdot> _ \<cdot> _)) \<bullet>
     (Eq_FalseI \<cdot> _ \<bullet> bin_rel_simps_7))) \<bullet>
 (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
   (combination \<cdot> neg \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
     (combination \<cdot> number_of \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
       (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (eq_reflection \<cdot> _ \<cdot> _ \<bullet> (bin_arith_simps_19 \<cdot> _)) \<bullet>
         (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
           (combination \<cdot> bin_pred \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
             (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
               (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                 (combination \<cdot> NCons \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
                   (eq_reflection \<cdot> _ \<cdot> _ \<bullet> bin_arith_simps_7)) \<bullet>
                 (reflexive \<cdot> _)) \<bullet>
               (eq_reflection \<cdot> _ \<cdot> _ \<bullet> bin_arith_simps_32))) \<bullet>
           (eq_reflection \<cdot> _ \<cdot> _ \<bullet> bin_arith_simps_1))))) \<bullet>
   (Eq_TrueI \<cdot> _ \<bullet> bin_rel_simps_11))) \<bullet>
                                          (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
 (combination \<cdot> neg \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
   (combination \<cdot> number_of \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
     (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
       (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
         (combination \<cdot> bin_add (bin.Pls BIT True) \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
           (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
             (eq_reflection \<cdot> _ \<cdot> _ \<bullet> (bin_arith_simps_19 \<cdot> _)) \<bullet>
             (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
               (combination \<cdot> bin_pred \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
                 (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                   (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                     (combination \<cdot> NCons \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
                       (eq_reflection \<cdot> _ \<cdot> _ \<bullet> bin_arith_simps_7)) \<bullet>
                     (reflexive \<cdot> _)) \<bullet>
                   (eq_reflection \<cdot> _ \<cdot> _ \<bullet> bin_arith_simps_32))) \<bullet>
               (eq_reflection \<cdot> _ \<cdot> _ \<bullet> bin_arith_simps_1)))) \<bullet>
         (eq_reflection \<cdot> _ \<cdot> _ \<bullet> (bin_arith_simps_22 \<cdot> _))) \<bullet>
       (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (eq_reflection \<cdot> _ \<cdot> _ \<bullet> (bin_arith_simps_17 \<cdot> _)) \<bullet>
         (eq_reflection \<cdot> _ \<cdot> _ \<bullet> bin_arith_simps_32))))) \<bullet>
 (Eq_FalseI \<cdot> _ \<bullet> bin_rel_simps_7))) \<bullet>
                                        (eq_reflection \<cdot> _ \<cdot> _ \<bullet>
                                          (if_False \<cdot> _ \<cdot> _))))) \<bullet>
                                  (eq_reflection \<cdot> _ \<cdot> _ \<bullet> simp_thms_8))))) \<bullet>
                          TrueI)) \<bullet>
                      (equal_elim \<cdot> _ \<cdot> _ \<bullet>
                        (symmetric \<cdot> _ \<cdot> _ \<bullet>
                          (combination \<cdot> Trueprop \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
                            (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                              (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                (combination \<cdot> op = \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
                                  (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                    (combination \<cdot> op \<le> \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                      (reflexive \<cdot> _) \<bullet>
                                      (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                        (combination \<cdot> op + \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                          (reflexive \<cdot> _) \<bullet>
                                          (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
 (combination \<cdot> op * \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
   (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (eq_reflection \<cdot> _ \<cdot> _ \<bullet> (diff_nat_number_of \<cdot> _ \<cdot> _)) \<bullet>
     (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
       (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
         (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
           (combination \<cdot> If \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
             (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
               (eq_reflection \<cdot> _ \<cdot> _ \<bullet> (bin_rel_simps_12 \<cdot> _ \<cdot> _)) \<bullet>
               (Eq_FalseI \<cdot> _ \<bullet> bin_rel_simps_7))) \<bullet>
           (reflexive \<cdot> _)) \<bullet>
         (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
           (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
             (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
               (combination \<cdot> Let \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
                 (combination \<cdot> number_of \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
                   (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                     (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                       (combination \<cdot> bin_add (bin.Pls BIT True) \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                         (reflexive \<cdot> _) \<bullet>
                         (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                           (eq_reflection \<cdot> _ \<cdot> _ \<bullet> (bin_arith_simps_19 \<cdot> _)) \<bullet>
                           (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                             (combination \<cdot> bin_pred \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
                               (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                 (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                   (combination \<cdot> NCons \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                     (reflexive \<cdot> _) \<bullet>
                                     (eq_reflection \<cdot> _ \<cdot> _ \<bullet> bin_arith_simps_7)) \<bullet>
                                   (reflexive \<cdot> _)) \<bullet>
                                 (eq_reflection \<cdot> _ \<cdot> _ \<bullet> bin_arith_simps_32))) \<bullet>
                             (eq_reflection \<cdot> _ \<cdot> _ \<bullet> bin_arith_simps_1)))) \<bullet>
                       (eq_reflection \<cdot> _ \<cdot> _ \<bullet> (bin_arith_simps_22 \<cdot> _))) \<bullet>
                     (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                       (eq_reflection \<cdot> _ \<cdot> _ \<bullet> (bin_arith_simps_17 \<cdot> _)) \<bullet>
                       (eq_reflection \<cdot> _ \<cdot> _ \<bullet> bin_arith_simps_32))))) \<bullet>
               (abstract_rule \<cdot> _ \<cdot> _ \<bullet>
                 (\<Lambda>d. combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                       (combination \<cdot> If (neg d) \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
                         (eq_reflection \<cdot> _ \<cdot> _ \<bullet>
                           (HOL.sym \<cdot> _ \<cdot> _ \<bullet> numeral_0_eq_0))) \<bullet>
                       (reflexive \<cdot> _)))) \<bullet>
             (Let_number_of \<cdot> _ \<cdot> (\<lambda>d. if neg d then Numeral0 else nat d))) \<bullet>
           (transitive \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
             (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
               (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                 (combination \<cdot> If \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
                   (Eq_FalseI \<cdot> _ \<bullet> bin_rel_simps_7)) \<bullet>
                 (reflexive \<cdot> _)) \<bullet>
               (eq_reflection \<cdot> _ \<cdot> _ \<bullet> (nat_number_of \<cdot> _))) \<bullet>
             (eq_reflection \<cdot> _ \<cdot> _ \<bullet> (if_cancel \<cdot> _ \<cdot> _))))) \<bullet>
       (eq_reflection \<cdot> _ \<cdot> _ \<bullet> (if_False \<cdot> _ \<cdot> _))))) \<bullet>
 (reflexive \<cdot> _))) \<bullet>
                                        (combination \<cdot> Suc \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                          (reflexive \<cdot> _) \<bullet>
                                          (eq_reflection \<cdot> _ \<cdot> _ \<bullet>
 (HOL.sym \<cdot> _ \<cdot> _ \<bullet> numeral_0_eq_0))))) \<bullet>
                                    (reflexive \<cdot> _))) \<bullet>
                                (combination \<cdot> _ \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                  (combination \<cdot> op \<le> \<cdot> _ \<cdot> _ \<cdot> _ \<bullet> (reflexive \<cdot> _) \<bullet>
                                    (combination \<cdot> op + (Numeral0 * m) \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                      (reflexive \<cdot> _) \<bullet>
                                      (combination \<cdot> Suc \<cdot> _ \<cdot> _ \<cdot> _ \<bullet>
                                        (reflexive \<cdot> _) \<bullet>
                                        (eq_reflection \<cdot> _ \<cdot> _ \<bullet>
                                          (HOL.sym \<cdot> _ \<cdot> _ \<bullet> numeral_0_eq_0))))) \<bullet>
                                  (reflexive \<cdot> _))) \<bullet>
                              (eq_reflection \<cdot> _ \<cdot> _ \<bullet> (simp_thms_6 \<cdot> _))))) \<bullet>
                        TrueI))))))) \<bullet>
          (iffD1 \<cdot> _ \<cdot> _ \<bullet> (linorder_not_less \<cdot> _ \<cdot> _) \<bullet> H)))"
*}

ML {*
val trm = ProofSyntax.term_of_proof my_prf
*}

ML {* 
val trm = term_of
 (read_cterm (sign_of Main.thy) ("\<forall> (m::nat) . m < m+1", propT))
*}

ML {*
val my_prf' = Reconstruct.reconstruct_proof (sign_of Main.thy) trm my_prf;
*}

ML {* 
val my_thm = ProofChecker.thm_of_proof Main.thy my_prf';
*}

end
