(* $Id: ProofConsumer1.thy,v 1.1 2003/11/19 14:40:43 a1hloidl Exp $

   The proof consumer in this case uses a trivial formula and a proof term
   as printed by the consumer and replays the proof to check it.
*)

theory ProofConsumer1 = ProofBase1:

(* version from: ProofSyntax.print_proof_of false (thm "bonzo_1701") *)
ML {*
val my_prf = ProofSyntax.read_proof Main.thy false
"allI % _ %%
 (Lam A.
   allI % _ %%
    (Lam B.
      impI % _ % _ %%
       (Lam H: _.
         conjI % _ % _ %% (conjE % _ % _ % _ %% H %% (Lam (H: _) H: _. H)) %%
          (conjE % _ % _ % _ %% H %% (Lam (H: _) Ha: _. H)))))"
*}

(* version from: ProofSyntax.print_proof_of false (thm "bonzo_1701") 
   using a proof via fastsmp *)

(*
ML {*
val trm = ProofSyntax.term_of_proof my_prf
*}
*)

ML {* 
val trm = term_of
 (read_cterm (sign_of Main.thy) ("\<forall> A B. (A & B --> B & A)", propT))
*}

(*
ML {*
val prf' = Reconstruct.reconstruct_proof (sign_of Main.thy) trm magic_prf;
*}

ML {* 
val thm = ProofChecker.thm_of_proof Main.thy prf';
*}
*)

(* reconstruct the full proof out of the proof term *)
ML {*
val my_prf' = Reconstruct.reconstruct_proof (sign_of Main.thy) trm my_prf;
*}

(* replay the proof *)
ML {* 
val my_thm = ProofChecker.thm_of_proof Main.thy my_prf';
*}

end
