theory ProofBase2 = Main:

(* full detail on proof terms that are generated *)
ML {*
proofs := 2;
*}

typedecl varname 

datatype expr = VAR varname | KONST bool | AND expr expr | OR expr expr

types env = "varname => bool"

(*
syntax
 lookup_ :: "[env, varname] => bool"
translations
 "lookup_ E n" == "E n"
*)

consts
 semn  :: "(env \<times> expr \<times> bool) set" -- {* operational semantics *}

syntax
 semn_  :: "[env, expr, bool] \<Rightarrow> bool" ("_ \<turnstile> _ \<Down> _")

translations
 "E \<turnstile> e \<Down> v" == "(E,e,v) : semn"

inductive semn intros
 semVar:    "(E, (VAR n),  E n) : semn"
 semKonst:  "(E, (KONST b),  b) : semn"
 semAnd:    "[| (E, e1, b1) : semn ; (E, e2, b2) : semn |] ==> 
             (E,  (AND e1 e2), (b1 & b2)) : semn"
 semOr: "[| (E,  e1, b1) : semn ; (E, e2, b2) : semn |] ==> 
            (E, (OR e1 e2), (b1 | b2)) : semn"



(*
lemma "A & B --> B & A"
by clarsimp
*)

(* 
lemma "kool (expr.Konst True)"
sorry
*)
(*
constdefs 
 kool :: "expr => bool"
 "kool e == \<exists> v. \<forall> E . (E,e,v) : semn"

syntax
 tautt :: "[expr] \<Rightarrow> bool"               ("\<box> _" )
translations
 "tautt" => "\<lambda> e . (\<forall> E . (E, e, True) : semn)"
*)
(*"\<forall> E . E \<turnstile> e \<Down> True"*)


end

