(*  
   File:	$RCSfile: ProducerGr7.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ProducerGr7.thy,v 1.1 2003/12/05 15:30:42 a1hloidl Exp $

   Example: List append 

   Doesn't use locales for now but should. Need to figure out how the ML-fcts for
   locales work.

   The imported theories represent the shared knowledge of producer and consumer.
*)

theory ProducerGr7 = VDM5 + Prelude + Lemmas + ProofTermSize + BaseGr7 :

(* full detail on proof terms that are generated *)
ML {*
proofs := 2;
*}

lemma bonzo_1704: "\<rhd> (Call f) : spectable f"
apply (rule vdm_call, simp)
apply (insert vardistinct, clarsimp)
apply (rule vdm_conseq)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti) apply (rule vdm_getfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti) apply (rule vdm_prim)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_if)
prefer 3 apply clarsimp 
apply (case_tac "aa<rl\<bullet>TAG> = 0")
apply clarsimp defer 1 apply clarsimp prefer 3
apply (rule vdm_leti) apply (rule vdm_getfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_getfr)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti) apply (rule vdm_int)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfr)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_ax) apply simp
apply clarsimp defer 1
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2 
apply (rule vdm_leti) apply (rule vdm_getfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti) apply (rule vdm_prim)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_if) 
prefer 3 apply clarsimp apply (case_tac "aa<rlrev\<bullet>TAG> = 0") apply clarsimp
defer 1 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 5 apply clarsimp prefer 2 apply (rule vdm_rvar)
apply clarsimp prefer 3
apply (rule vdm_leti) apply (rule vdm_getfi)
prefer 3 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_getfr)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti) apply (rule vdm_int)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti) apply (rule vdm_int)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfr)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_ax) apply simp
apply clarsimp
(*end of VCG*)
prefer 2
apply (erule LocLength.elims, simp_all, clarsimp)
apply (erule LocLength.elims, simp_all, clarsimp)
apply (simp add: C_def F_def)
apply (erule LocLength.elims, simp_all, clarsimp)
apply (erule LocLength.elims, simp_all, clarsimp)
apply (erule_tac x=0 in allE)
apply (erule_tac x=i in allE)
apply (erule impE)
apply (rule_tac x="{la}" in exI, rule)
apply (rule NIL_LocL, simp_all)
apply fast
apply fast
apply (rule_tac x="X - {laa}" in exI, clarsimp, rule)
apply (rule LocLengthSame, assumption) 
apply (simp add: same_def)
apply fast
apply (simp add: A_def D_def) 
(*last side condition*)
apply (erule LocLength.elims, simp_all, clarsimp)
apply (erule_tac x=i in allE)
apply (erule_tac x="Suc LREV" in allE)
apply (erule impE)
apply (rule_tac x="Xa - {la}" in exI, clarsimp, rule)
apply (rule LocLengthSame, assumption) 
apply (simp add: same_def)
apply (rule_tac x="Z \<union> {la}" in exI, rule)
apply (rule CONS_LocL, simp_all)
apply (subgoal_tac "rlrev \<in> Z", fast)
apply (erule LocLength.elims, simp_all)
apply (subgoal_tac "Z - {la} = Z", clarsimp)
prefer 2 apply fast
apply (rule LocLengthSame, assumption)
apply (simp add: same_def)
apply (rule, fast)
apply fast
apply (simp add: A_def B_def D_def EE_def)
ML {* nprf_size() *}
done

ML {*
ProofSyntax.print_proof_of false (thm "bonzo_1704");
*}

(* this printed proof is what shall be shipped as certificate;
   for now just cut and paste into BonzoConsumer.thy *)

end

