(*  
   File:	$RCSfile: ProducerGr6.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ProducerGr6.thy,v 1.1 2003/12/05 15:30:42 a1hloidl Exp $

   Example: konstant (the minimal example)

   Doesn't use locales for now but should. Need to figure out how the ML-fcts for
   locales work.

   The imported theories represent the shared knowledge of producer and consumer.
*)

theory ProducerGr6 = VDM5 + Prelude + Lemmas + ProofTermSize + BaseGr6 :

(* full detail on proof terms that are generated *)
ML {*
proofs := 2;
*}

lemma bonzo_1704: "\<rhd> ((Call f)::'a expr) : spectable f"
apply (rule vdm_call)
apply (simp)
apply (rule vdm_conseq)
apply(rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply(rule vdm_leti, rule vdm_prim) prefer 2 apply clarsimp prefer 2
apply(rule vdm_if)
apply(rule vdm_rvar) prefer 2 apply clarsimp
apply (case_tac "aa<ad\<bullet>TAG> < 1")
apply clarsimp apply (erule LocLength.elims, clarsimp) 
apply(simp_all add: clockB_def callcB_def invkcB_def invkdpthB_def)
prefer 2
apply(rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letr, rule vdm_getfr) prefer 2 apply clarsimp prefer 2
apply(rule vdm_leti, rule vdm_int) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letv, rule vdm_putfr) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply (rule vdm_ax, simp)
apply (insert vardistinct)
apply clarsimp
apply (erule LocLength.elims, simp_all, clarsimp)
apply (erule_tac x=i in allE)
apply (erule impE)
apply (rule_tac x="Xa - {la}" in exI, rule)
apply (rule LocLengthSame, assumption)
apply (simp add: same_def) 
apply (rule_tac x="Suc AC" in exI, rule_tac x="Y \<union> {la}" in exI, rule)
apply (rule CONS_LocL, simp_all)
apply (subgoal_tac "racc \<in> Y")
apply fast
apply (erule LocLength.elims, simp_all)
apply (subgoal_tac "Y = Y - {la}", clarsimp)
apply (rule LocLengthSame, assumption)
apply (simp add: same_def)
apply fast
apply fast
apply fast
apply (simp_all add: clockA_def callcA_def invkcA_def invkdpthA_def)
ML {* nprf_size() *}
done

ML {*
ProofSyntax.print_proof_of false (thm "bonzo_1704");
*}

(* this printed proof is what shall be shipped as certificate;
   for now just cut and paste into BonzoConsumer.thy *)

end

