(*  
   File:	$RCSfile: ProducerGr2.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ProducerGr2.thy,v 1.2 2003/12/01 22:15:48 a1hloidl Exp $

   Example: swap from ExampleSwap.thy

   Doesn't use locales for now but should. Need to figure out how the ML-fcts for
   locales work.

   The imported theories represent the shared knowledge of producer and consumer.
*)

theory ProducerGr2 = VDM5 + Prelude + Lemmas + ProofTermSize: (*  + BaseGr2 : *)

(* full detail on proof terms that are generated *)
ML {*
proofs := 2;
*}

ML {*
val bonzo_1702_term = "\<rhd> CALL swap :
      {(E,h,hh,v,p). (E<y> < E<x> \<longrightarrow> v = IVal (E<y>) \<and> h = hh \<and> p = \<langle> 14 1 0 0 \<rangle>) \<and> 
                     ((E<x> <= E<y>) \<longrightarrow> v = IVal (E<x>) \<and> h = hh \<and> p =  \<langle> 8 1 0 0 \<rangle>)}"
*}

(* locale swap_example = *)

consts     tmp :: iname
consts	   x :: iname
consts	   y :: iname
consts	   q :: iname
consts	   swap      :: funame

axioms swapfun[simp]:
"funtable swap =  
 LET q  = x :> y
 IN IF q 
    THEN LET
      tmp = IVar x;
      x = IVar y;
      y = IVar tmp
     IN IVar x END
    ELSE IVar x
 END"

axioms  vardistinct: "distinct [tmp,x,y,q] \<and> distinct [q,y,x,tmp]"

(* so let's prove it for 14 and 8*)
lemma bonzo_1702:
   "\<rhd> CALL swap :
      {(E,h,hh,v,p). (E<y> < E<x> \<longrightarrow> v = IVal (E<y>) \<and> h = hh \<and> p = \<langle> 14 1 0 0 \<rangle>) \<and> 
                     ((E<x> <= E<y>) \<longrightarrow> v = IVal (E<x>) \<and> h = hh \<and> p =  \<langle> 8 1 0 0 \<rangle>)}"
apply (rule vdm_call, simp)
apply (rule vdm_conseq)
apply (rule vdm_leti)
apply (rule vdm_prim)
apply (rule vdm_if)
apply (rule vdm_leti)
apply (rule vdm_ivar)
apply (rule vdm_leti)
apply (rule vdm_ivar)
apply (rule vdm_leti)
apply (rule vdm_ivar)
apply (rule vdm_ivar)
apply (rule vdm_ivar)
apply (insert vardistinct)
apply clarsimp
ML {* nprf_size() *}
done

ML {*
ProofSyntax.print_proof_of false (thm "bonzo_1702");
*}


(* this printed proof is what shall be shipped as certificate;
   for now just cut and paste into BonzoConsumer.thy *)

end


