(*  
   File:	$RCSfile: ProducerGr1.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ProducerGr1.thy,v 1.2 2003/12/01 22:15:48 a1hloidl Exp $

   Example: count-down w/ parameterless static invoke
   This file shows how to generate a proof term, that can be saved to a file
   (for now only printed) and then sent to another machine.

   Doesn't use locales for now but should. Need to figure out how the ML-fcts for
   locales work.

   The imported theories represent the shared knowledge of producer and consumer.
*)

theory ProducerGr1 = VDM5 + Prelude + Lemmas + BaseGr1 :

(* full detail on proof terms that are generated *)
ML {*
proofs := 2;
*}

ML {*
val bonzo_1701_term = "\<rhd> ((MH_InvokeStatic KountClass kount) :: 'a expr) :
    {(E,h,hh,v,(p::Semantics.renv)). 0 < h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> \<longrightarrow> v = IVal 0 \<and> hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0}"
*}

(* Resource property: *)
lemma bonzo_1701: 
   "\<rhd> ((MH_InvokeStatic KountClass kount) :: 'a expr) :
    {(E,h,hh,v,(p::Semantics.renv)). 0 < h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> \<longrightarrow> v = IVal 0 \<and> hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0}"
apply (rule vdm_mhinvokestatic, simp)
apply (rule vdm_conseq)
apply (rule vdm_leti)
apply (rule vdm_int)
apply (rule vdm_leti)
apply (rule vdm_getfi)
apply (rule vdm_leti)
apply (rule vdm_prim)
apply (rule vdm_letv)
apply (rule vdm_putfi)
apply (rule vdm_leti)
apply (rule vdm_prim)
apply (rule vdm_if)
apply (rule vdm_int)
apply (rule vdm_ax, simp)
apply (insert vardistinct)
apply clarsimp
ML {* nprf_size() *}
done

(* test only *)
(*
ML {*
val bonzo_1701_prf = #2 (#der (rep_thm (thm "bonzo_1701")));
*}
*)
(*
(* test only *)
ML {* 
val t = term_of
 (read_cterm (sign_of Main.thy) ("A & B --> B & A", propT));
*}
*)

ML {*
ProofSyntax.print_proof_of false (thm "bonzo_1701");
*}

(* this printed proof is what shall be shipped as certificate;
   for now just cut and paste into BonzoConsumer.thy *)

end


