(*  
   File:	$RCSfile: ConsumerGr5.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ConsumerGr5.thy,v 1.1 2003/11/20 14:26:09 a1hloidl Exp $

   Example: konstant (the minimal example)
   Proof term generated in BonzoMicroProducer.thy is pasted in here.

*)

theory ConsumerGr5 = VDM5 + Prelude + Lemmas :

section {* Count-down w/ MH_InvokeStatic *}

(* version with fast *)
(*
"vdm_conseq % _ % _ % _ % _ %% (vdm_int % _ % _) %%
 (subsetI % _ % _ %% (Lam x H: _. H))"
*)

(* +++++++++++++++++++++++++++++
   The following command generates this error message:

*** Type unification failed: Clash of types "fun" and "proof".
*** Type error in application: Operator not of function type.
*** 
*** Operator:  thm.HOL.refl :: proof
*** Operand:   UNIV :: ??'a set
*** 
*** Exception- ERROR raised
*** At command "ML".
   ++++++++++++++++++++++++++++++ *)

(* version with clarsimp *)
ML {*
val my_prf = ProofSyntax.read_proof (theory "VDM5") false
"vdm_conseq % _ % _ % _ % _ %% (vdm_int % _ % _) %%
 (equal_elim % _ % _ %%
   (symmetric % _ % _ %%
     (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
       (transitive % _ % _ % _ %%
         (combination % _ % _ % _ % _ %%
           (combination % op <= % _ % _ % _ %% (reflexive % _) %%
             (combination % Collect % _ % _ % _ %% (reflexive % _) %%
               (combination % split % _ % _ % _ %% (reflexive % _) %%
                 (abstract_rule % _ % _ %%
                   (Lam E.
                     combination % split % _ % _ % _ %% (reflexive % _) %%
                      (abstract_rule % _ % _ %%
                        (Lam h.
                          combination % split % _ % _ % _ %% (reflexive % _) %%
                           (abstract_rule % _ % _ %%
                             (Lam hh.
                               eq_reflection % _ % _ %%
                                (split_part % _ % _)))))))))) %%
           (combination % Collect % _ % _ % _ %% (reflexive % _) %%
             (combination % split % _ % _ % _ %% (reflexive % _) %%
               (abstract_rule % _ % _ %%
                 (Lam E.
                   combination % split % _ % _ % _ %% (reflexive % _) %%
                    (abstract_rule % _ % _ %%
                      (Lam h.
                        combination % split % _ % _ % _ %% (reflexive % _) %%
                         (abstract_rule % _ % _ %%
                           (Lam hh.
                             eq_reflection % _ % _ %% (split_part % _ % _)))))))))) %%
         (Eq_TrueI % _ %% (axioms_1 % _))))) %%
   TrueI)"
*}

ML {* 
val trm = term_of
 (read_cterm (sign_of (theory "VDM5")) ("\<rhd> ((expr.Int 1) :: nat expr) : {(E,h,hh,v,p) . hh = h  \<and> v = IVal 1 \<and> p = \<langle>Suc 0 0 0 0\<rangle>}", propT))
*}

(* reconstruct the full proof out of the proof term *)
ML {*
val my_prf' = Reconstruct.reconstruct_proof (sign_of (theory "VDM5")) trm my_prf;
*}

(* replay the proof *)
ML {* 
val my_thm = ProofChecker.thm_of_proof (theory "VDM5") my_prf';
*}

end
