(*  
   File:	$RCSfile: ConsumerGr1.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ConsumerGr1.thy,v 1.1 2003/11/19 14:40:37 a1hloidl Exp $

   Example: count-down w/ parameterless static invoke
   This file shows how to read program source (from file ExBonzo.thy) and use
   the proof term hard coded as constant input_prf in this file to
   prove a given resource property.
*)

theory ConsumerGr1 = VDM5 + Prelude + Lemmas + BaseGr1 :

section {* Count-down w/ MH_InvokeStatic *}

ML {*
val trm = term_of
 (read_cterm (sign_of (theory "VDM5")) ("\<rhd> ((MH_InvokeStatic KountClass kount) :: 'a expr) :
    {(E,h,hh,v,(p::Semantics.renv)). 0 < h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> \<longrightarrow> v = IVal 0 \<and> hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0}", propT));
*}

ML {*
val prf = ProofSyntax.read_proof (theory "VDM5") false
"vdm_mhinvokestatic % _ % _ % _ % _ %%
 (equal_elim % _ % _ %%
   (symmetric % _ % _ %%
     (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
       (combination % _ % _ % _ % _ %%
         (combination % op : % _ % _ % _ %% (reflexive % _) %%
           (combination % _ % _ % _ % _ %%
             (combination % Pair % _ % _ % _ %% (reflexive % _) %%
               (transitive % _ % _ % _ %%
                 (eq_reflection % _ % _ %% (Un_insert_right % _ % _ % _)) %%
                 (combination %
                   insert
                    (KountClass\<bullet>\<bullet>kount,
                     {(E, h, hh, v, p).
                      0 < h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
                      v = IVal 0 &
                      hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0}) %
                   _ %
                   _ %
                   _ %%
                   (reflexive % _) %%
                   (eq_reflection % _ % _ %% (Un_absorb % _))))) %%
             (combination % _ % _ % _ % _ %%
               (combination % Pair % _ % _ % _ %% (reflexive % _) %%
                 (transitive % _ % _ % _ %% (eq_reflection % _ % _ %% kountbdy) %%
                   (combination % Leti one (Int 1) % _ % _ % _ %% (reflexive % _) %%
                     (combination % Leti n (self\<bullet>count) % _ % _ % _ %%
                       (reflexive % _) %%
                       (combination % _ % _ % _ % _ %%
                         (combination % Leti n % _ % _ % _ %% (reflexive % _) %%
                           (combination % _ % _ % _ % _ %%
                             (combination % _ % _ % _ % _ %%
                               (combination % Primop % _ % _ % _ %% (reflexive % _) %%
                                 PrimopDefs_12) %%
                               (reflexive % _)) %%
                             (reflexive % _))) %%
                         (combination % Letv (self\<bullet>count := n) % _ % _ % _ %%
                           (reflexive % _) %%
                           (combination % _ % _ % _ % _ %%
                             (combination % Leti b % _ % _ % _ %% (reflexive % _) %%
                               (combination % _ % _ % _ % _ %%
                                 (combination % _ % _ % _ % _ %%
                                   (combination % Primop % _ % _ % _ %%
                                     (reflexive % _) %%
                                     PrimopDefs_6) %%
                                   (reflexive % _)) %%
                                 (reflexive % _))) %%
                             (reflexive % _)))))))) %%
               (combination % Collect % _ % _ % _ %% (reflexive % _) %%
                 (combination % split % _ % _ % _ %% (reflexive % _) %%
                   (abstract_rule % _ % _ %%
                     (Lam E.
                       combination % split % _ % _ % _ %% (reflexive % _) %%
                        (abstract_rule % _ % _ %%
                          (Lam h.
                            combination % split % _ % _ % _ %% (reflexive % _) %%
                             (abstract_rule % _ % _ %%
                               (Lam hh.
                                 combination % split % _ % _ % _ %% (reflexive % _) %%
                                  (abstract_rule % _ % _ %%
                                    (Lam v.
                                      abstract_rule % _ % _ %%
                                       (Lam p.
                                         transitive % _ % _ % _ %%
                                          (transitive % _ % _ % _ %%
 (combination % _ % _ % _ % _ %%
   (combination % op : % _ % _ % _ %% (reflexive % _) %%
     (combination % Pair E % _ % _ % _ %% (reflexive % _) %%
       (combination % Pair h % _ % _ % _ %% (reflexive % _) %%
         (combination % Pair hh % _ % _ % _ %% (reflexive % _) %%
           (combination % Pair v % _ % _ % _ %% (reflexive % _) %%
             (transitive % _ % _ % _ %%
               (transitive % _ % _ % _ %%
                 (combination % _ % _ % _ % _ %%
                   (combination % op \<oplus> % _ % _ % _ %% (reflexive % _) %%
                     (combination % renv.clock_field 2 % _ % _ % _ %%
                       (reflexive % _) %%
                       (combination % callc_field 0 % _ % _ % _ %% (reflexive % _) %%
                         (combination % _ % _ % _ % _ %%
                           (combination % invkc_field % _ % _ % _ %%
                             (reflexive % _) %%
                             axm.Nat.One_nat_def) %%
                           (combination % _ % _ % _ % _ %%
                             (combination % invkdpth_field % _ % _ % _ %%
                               (reflexive % _) %%
                               axm.Nat.One_nat_def) %%
                             (reflexive % _)))))) %%
                   (reflexive % _)) %%
                 (renv_plus_def % _ % _)) %%
               (combination % _ % _ % _ % _ %%
                 (combination % renv.clock_field % _ % _ % _ %% (reflexive % _) %%
                   (transitive % _ % _ % _ %%
                     (combination % _ % _ % _ % _ %%
                       (combination % op + % _ % _ % _ %% (reflexive % _) %%
                         (eq_reflection % _ % _ %%
                           (select_convs_1 % _ % _ % _ % _ % _))) %%
                       (reflexive % _)) %%
                     (eq_reflection % _ % _ %% (add_2_eq_Suc % _)))) %%
                 (combination % _ % _ % _ % _ %%
                   (combination % callc_field % _ % _ % _ %% (reflexive % _) %%
                     (transitive % _ % _ % _ %%
                       (combination % _ % _ % _ % _ %%
                         (combination % op + % _ % _ % _ %% (reflexive % _) %%
                           (eq_reflection % _ % _ %%
                             (select_convs_2 % _ % _ % _ % _ % _))) %%
                         (reflexive % _)) %%
                       (eq_reflection % _ % _ %% (zero % _)))) %%
                   (combination % _ % _ % _ % _ %%
                     (combination % invkc_field % _ % _ % _ %% (reflexive % _) %%
                       (transitive % _ % _ % _ %%
                         (transitive % _ % _ % _ %%
                           (combination % _ % _ % _ % _ %%
                             (combination % op + % _ % _ % _ %% (reflexive % _) %%
                               (eq_reflection % _ % _ %%
                                 (select_convs_3 % _ % _ % _ % _ % _))) %%
                             (reflexive % _)) %%
                           (eq_reflection % _ % _ %% (add_Suc % _ % _))) %%
                         (combination % Suc % _ % _ % _ %% (reflexive % _) %%
                           (eq_reflection % _ % _ %% (zero % _))))) %%
                     (combination % _ % _ % _ % _ %%
                       (combination % invkdpth_field % _ % _ % _ %% (reflexive % _) %%
                         (transitive % _ % _ % _ %%
                           (transitive % _ % _ % _ %%
                             (combination % _ % _ % _ % _ %%
                               (combination % op + % _ % _ % _ %% (reflexive % _) %%
                                 (eq_reflection % _ % _ %%
                                   (select_convs_4 % _ % _ % _ % _ % _))) %%
                               (reflexive % _)) %%
                             (eq_reflection % _ % _ %% (add_Suc % _ % _))) %%
                           (combination % Suc % _ % _ % _ %% (reflexive % _) %%
                             (eq_reflection % _ % _ %% (zero % _))))) %%
                       (reflexive % _))))))))))) %%
   (reflexive % _)) %%
 (eq_reflection % _ % _ %%
   (mem_Collect_eq % _ %
     (%(E, h, hh, v, p).
         0 < h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
         v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)))) %%
                                          (transitive % _ % _ % _ %%
 (eq_reflection % _ % _ %%
   (split_conv %
     (%E (h, hh, v, p).
         0 < h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
         v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0) %
     _ %
     _)) %%
 (transitive % _ % _ % _ %%
   (transitive % _ % _ % _ %%
     (combination %
       (%(h, hh, v, p).
           0 < h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
           v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0) %
       _ %
       _ %
       _ %%
       (reflexive % _) %%
       (reflexive % _)) %%
     (eq_reflection % _ % _ %%
       (split_conv %
         (%h (hh, v, p).
             0 < h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
             v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0) %
         _ %
         _))) %%
   (transitive % _ % _ % _ %%
     (transitive % _ % _ % _ %%
       (combination %
         (%(hh, v, p).
             0 < h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
             v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0) %
         _ %
         _ %
         _ %%
         (reflexive % _) %%
         (reflexive % _)) %%
       (eq_reflection % _ % _ %%
         (split_conv %
           (%hh (v, p).
               0 < h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
               v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0) %
           _ %
           _))) %%
     (transitive % _ % _ % _ %%
       (transitive % _ % _ % _ %%
         (combination %
           (%(v, p).
               0 < h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
               v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0) %
           _ %
           _ %
           _ %%
           (reflexive % _) %%
           (reflexive % _)) %%
         (eq_reflection % _ % _ %%
           (split_conv %
             (%v p. 0 < h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
                    v = IVal 0 &
                    hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0) %
             _ %
             _))) %%
       (combination %
         (%p. 0 < h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
              v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0) %
         _ %
         _ %
         _ %%
         (reflexive % _) %%
         (reflexive % _)))))))))))))))))))) %%
         (reflexive % _)))) %%
   (vdm_conseq % _ % _ % _ % _ %%
     (vdm_leti % _ % _ % _ % _ % _ % _ %% (vdm_int % _ % _) %%
       (vdm_leti % _ % _ % _ % _ % _ % _ %% (vdm_getfi % _ % _ % _) %%
         (vdm_leti % _ % _ % _ % _ % _ % _ %%
           (vdm_prim % _ % (%x y. x - 1) % _ % _) %%
           (vdm_letv % _ % _ % _ % _ % _ %% (vdm_putfi % _ % _ % _ % _) %%
             (vdm_leti % _ % _ % _ % _ % _ % _ %%
               (vdm_prim % _ % (%x y. if x < y then 1 else 0) % _ % _) %%
               (vdm_if % _ % _ % _ % _ % _ % _ %% (vdm_int % _ % _) %%
                 (vdm_ax % _ % _ % _ %%
                   (equal_elim % _ % _ %%
                     (symmetric % _ % _ %%
                       (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                         (transitive % _ % _ % _ %%
                           (eq_reflection % _ % _ %% (insert_iff % _ % _ % _)) %%
                           (transitive % _ % _ % _ %%
                             (combination % _ % _ % _ % _ %%
                               (combination % op | % _ % _ % _ %% (reflexive % _) %%
                                 (transitive % _ % _ % _ %%
                                   (eq_reflection % _ % _ %%
                                     (Pair_eq % _ % _ % _ % _)) %%
                                   (transitive % _ % _ % _ %%
                                     (combination % _ % _ % _ % _ %%
                                       (combination % op & % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (eq_reflection % _ % _ %%
(simp_thms_6 % _))) %%
                                       (reflexive % _)) %%
                                     (eq_reflection % _ % _ %%
                                       (simp_thms_22 % _))))) %%
                               (eq_reflection % _ % _ %% (empty_iff % _))) %%
                             (eq_reflection % _ % _ %% (simp_thms_31 % _)))))) %%
                     (HOL.refl % _))))))))) %%
     (equal_elim % _ % _ %%
       (symmetric % _ % _ %%
         (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
           (combination % _ % _ % _ % _ %%
             (combination % op <= % _ % _ % _ %% (reflexive % _) %%
               (combination % Collect % _ % _ % _ %% (reflexive % _) %%
                 (combination % split % _ % _ % _ %% (reflexive % _) %%
                   (abstract_rule % _ % _ %%
                     (Lam E.
                       combination % split % _ % _ % _ %% (reflexive % _) %%
                        (abstract_rule % _ % _ %%
                          (Lam h.
                            combination % split % _ % _ % _ %% (reflexive % _) %%
                             (abstract_rule % _ % _ %%
                               (Lam hh.
                                 combination % split % _ % _ % _ %% (reflexive % _) %%
                                  (abstract_rule % _ % _ %%
                                    (Lam v.
                                      abstract_rule % _ % _ %%
                                       (Lam p.
                                         transitive % _ % _ % _ %%
                                          (transitive % _ % _ % _ %%
 (combination % Ex % _ % _ % _ %% (reflexive % _) %%
   (abstract_rule % _ % _ %%
     (Lam p1.
       transitive % _ % _ % _ %%
        (transitive % _ % _ % _ %%
          (combination % Ex % _ % _ % _ %% (reflexive % _) %%
            (abstract_rule % _ % _ %%
              (Lam p2.
                transitive % _ % _ % _ %%
                 (combination % Ex % _ % _ % _ %% (reflexive % _) %%
                   (abstract_rule % _ % _ %%
                     (Lam h1.
                       transitive % _ % _ % _ %%
                        (transitive % _ % _ % _ %%
                          (combination % Ex % _ % _ % _ %% (reflexive % _) %%
                            (abstract_rule % _ % _ %%
                              (Lam i.
                                transitive % _ % _ % _ %%
                                 (transitive % _ % _ % _ %%
                                   (combination % _ % _ % _ % _ %%
                                     (combination % op & % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (transitive % _ % _ % _ %%
                                         (transitive % _ % _ % _ %%
(combination % op : (E, h, h1, IVal i, p1) % _ % _ % _ %% (reflexive % _) %%
  (combination % Collect % _ % _ % _ %% (reflexive % _) %%
    (combination % split % _ % _ % _ %% (reflexive % _) %%
      (abstract_rule % _ % _ %%
        (Lam E.
          combination % split % _ % _ % _ %% (reflexive % _) %%
           (abstract_rule % _ % _ %%
             (Lam h.
               combination % split % _ % _ % _ %% (reflexive % _) %%
                (abstract_rule % _ % _ %%
                  (Lam hh. eq_reflection % _ % _ %% (split_part % _ % _)))))))))) %%
(eq_reflection % _ % _ %%
  (mem_Collect_eq % _ %
    (%(E, h, hh, ab).
        hh = h & (%(v, p). v = IVal 1 & p = \<langle>Suc 0 0 0 0\<rangle>) ab)))) %%
                                         (transitive % _ % _ % _ %%
(eq_reflection % _ % _ %%
  (split_conv %
    (%E (h, hh, ab).
        hh = h & (%(v, p). v = IVal 1 & p = \<langle>Suc 0 0 0 0\<rangle>) ab) %
    _ %
    _)) %%
(transitive % _ % _ % _ %%
  (transitive % _ % _ % _ %%
    (combination %
      (%(h, hh, ab).
          hh = h & (%(v, p). v = IVal 1 & p = \<langle>Suc 0 0 0 0\<rangle>) ab) %
      _ %
      _ %
      _ %%
      (reflexive % _) %%
      (reflexive % _)) %%
    (eq_reflection % _ % _ %%
      (split_conv %
        (%h (hh, ab).
            hh = h & (%(v, p). v = IVal 1 & p = \<langle>Suc 0 0 0 0\<rangle>) ab) %
        _ %
        _))) %%
  (transitive % _ % _ % _ %%
    (transitive % _ % _ % _ %%
      (combination %
        (%(hh, ab).
            hh = h & (%(v, p). v = IVal 1 & p = \<langle>Suc 0 0 0 0\<rangle>) ab) %
        _ %
        _ %
        _ %%
        (reflexive % _) %%
        (reflexive % _)) %%
      (eq_reflection % _ % _ %%
        (split_conv %
          (%hh ab.
              hh = h & (%(v, p). v = IVal 1 & p = \<langle>Suc 0 0 0 0\<rangle>) ab) %
          _ %
          _))) %%
    (transitive % _ % _ % _ %%
      (combination %
        (%ab. h1 = h & (%(v, p). v = IVal 1 & p = \<langle>Suc 0 0 0 0\<rangle>) ab) %
        _ %
        _ %
        _ %%
        (reflexive % _) %%
        (reflexive % _)) %%
      (combination % op & (h1 = h) % _ % _ % _ %% (reflexive % _) %%
        (transitive % _ % _ % _ %%
          (eq_reflection % _ % _ %%
            (split_conv % (%v p. v = IVal 1 & p = \<langle>Suc 0 0 0 0\<rangle>) % _ %
              _)) %%
          (combination % (%p. IVal i = IVal 1 & p = \<langle>Suc 0 0 0 0\<rangle>) %
            (%p. i = 1 & p = \<langle>Suc 0 0 0 0\<rangle>) %
            _ %
            _ %%
            (abstract_rule % _ % _ %%
              (Lam p.
                combination % _ % _ % _ % _ %%
                 (combination % op & % _ % _ % _ %% (reflexive % _) %%
                   (eq_reflection % _ % _ %% (inject_1 % _ % _))) %%
                 (reflexive % _))) %%
            (reflexive % _)))))))))) %%
                                     (combination % _ % _ % _ % _ %%
                                       (combination % op & % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (transitive % _ % _ % _ %%
(transitive % _ % _ % _ %%
  (combination % op : (E<one:=i>, h1, hh, v, p2) % _ % _ % _ %% (reflexive % _) %%
    (combination % Collect % _ % _ % _ %% (reflexive % _) %%
      (combination % split % _ % _ % _ %% (reflexive % _) %%
        (abstract_rule % _ % _ %%
          (Lam E.
            combination % split % _ % _ % _ %% (reflexive % _) %%
             (abstract_rule % _ % _ %%
               (Lam h.
                 combination % split % _ % _ % _ %% (reflexive % _) %%
                  (abstract_rule % _ % _ %%
                    (Lam hh.
                      combination % split % _ % _ % _ %% (reflexive % _) %%
                       (abstract_rule % _ % _ %%
                         (Lam v.
                           abstract_rule % _ % _ %%
                            (Lam p.
                              combination % Ex % _ % _ % _ %% (reflexive % _) %%
                               (abstract_rule % _ % _ %%
                                 (Lam p1.
                                   combination % Ex % _ % _ % _ %% (reflexive % _) %%
                                    (abstract_rule % _ % _ %%
                                      (Lam p2.
                                        combination % Ex % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (abstract_rule % _ % _ %%
(Lam h1.
  combination % Ex % _ % _ % _ %% (reflexive % _) %%
   (abstract_rule % _ % _ %%
     (Lam i.
       combination % _ % _ % _ % _ %%
        (combination % op & % _ % _ % _ %% (reflexive % _) %%
          (transitive % _ % _ % _ %%
            (eq_reflection % _ % _ %%
              (mem_Collect_eq % _ %
                (%(E, h, hh, v, p).
                    EX a. E\<lfloor>self\<rfloor> = Ref a &
                          hh = h &
                          v = IVal hh<a\<bullet>count> &
                          p = \<langle>2 0 0 0\<rangle>))) %%
            (transitive % _ % _ % _ %%
              (eq_reflection % _ % _ %%
                (split_conv %
                  (%E (h, hh, v, p).
                      EX a. E\<lfloor>self\<rfloor> = Ref a &
                            hh = h &
                            v = IVal hh<a\<bullet>count> &
                            p = \<langle>2 0 0 0\<rangle>) %
                  _ %
                  _)) %%
              (transitive % _ % _ % _ %%
                (transitive % _ % _ % _ %%
                  (combination %
                    (%(h, hh, v, p).
                        EX a. E\<lfloor>self\<rfloor> = Ref a &
                              hh = h &
                              v = IVal hh<a\<bullet>count> &
                              p = \<langle>2 0 0 0\<rangle>) %
                    _ %
                    _ %
                    _ %%
                    (reflexive % _) %%
                    (reflexive % _)) %%
                  (eq_reflection % _ % _ %%
                    (split_conv %
                      (%h (hh, v, p).
                          EX a. E\<lfloor>self\<rfloor> = Ref a &
                                hh = h &
                                v = IVal hh<a\<bullet>count> &
                                p = \<langle>2 0 0 0\<rangle>) %
                      _ %
                      _))) %%
                (transitive % _ % _ % _ %%
                  (transitive % _ % _ % _ %%
                    (combination %
                      (%(hh, v, p).
                          EX a. E\<lfloor>self\<rfloor> = Ref a &
                                hh = h &
                                v = IVal hh<a\<bullet>count> &
                                p = \<langle>2 0 0 0\<rangle>) %
                      _ %
                      _ %
                      _ %%
                      (reflexive % _) %%
                      (reflexive % _)) %%
                    (eq_reflection % _ % _ %%
                      (split_conv %
                        (%hh (v, p).
                            EX a. E\<lfloor>self\<rfloor> = Ref a &
                                  hh = h &
                                  v = IVal hh<a\<bullet>count> &
                                  p = \<langle>2 0 0 0\<rangle>) %
                        _ %
                        _))) %%
                  (transitive % _ % _ % _ %%
                    (transitive % _ % _ % _ %%
                      (combination %
                        (%(v, p).
                            EX a. E\<lfloor>self\<rfloor> = Ref a &
                                  h1 = h &
                                  v = IVal h1<a\<bullet>count> &
                                  p = \<langle>2 0 0 0\<rangle>) %
                        _ %
                        _ %
                        _ %%
                        (reflexive % _) %%
                        (reflexive % _)) %%
                      (eq_reflection % _ % _ %%
                        (split_conv %
                          (%v p. EX a. E\<lfloor>self\<rfloor> = Ref a &
                                       h1 = h &
                                       v = IVal h1<a\<bullet>count> &
                                       p = \<langle>2 0 0 0\<rangle>) %
                          _ %
                          _))) %%
                    (combination %
                      (%p. EX a. E\<lfloor>self\<rfloor> = Ref a &
                                 h1 = h &
                                 IVal i = IVal h1<a\<bullet>count> &
                                 p = \<langle>2 0 0 0\<rangle>) %
                      (%p. EX a. E\<lfloor>self\<rfloor> = Ref a &
                                 h1 = h &
                                 i = h1<a\<bullet>count> &
                                 p = \<langle>2 0 0 0\<rangle>) %
                      _ %
                      _ %%
                      (abstract_rule % _ % _ %%
                        (Lam p.
                          combination % Ex % _ % _ % _ %% (reflexive % _) %%
                           (abstract_rule % _ % _ %%
                             (Lam a.
                               combination % op & (E\<lfloor>self\<rfloor> = Ref a) %
                                _ %
                                _ %
                                _ %%
                                (reflexive % _) %%
                                (combination % op & (h1 = h) % _ % _ % _ %%
                                  (reflexive % _) %%
                                  (combination % _ % _ % _ % _ %%
                                    (combination % op & % _ % _ % _ %%
                                      (reflexive % _) %%
                                      (eq_reflection % _ % _ %%
                                        (inject_1 % _ % _))) %%
                                    (reflexive % _))))))) %%
                      (reflexive % _)))))))) %%
        (combination % _ % _ % _ % _ %%
          (combination % op & % _ % _ % _ %% (reflexive % _) %%
            (transitive % _ % _ % _ %%
              (transitive % _ % _ % _ %%
                (combination % op : (E<n:=i>, h1, hh, v, p2) % _ % _ % _ %%
                  (reflexive % _) %%
                  (combination % Collect % _ % _ % _ %% (reflexive % _) %%
                    (combination % split % _ % _ % _ %% (reflexive % _) %%
                      (abstract_rule % _ % _ %%
                        (Lam E.
                          combination % split % _ % _ % _ %% (reflexive % _) %%
                           (abstract_rule % _ % _ %%
                             (Lam h.
                               combination % split % _ % _ % _ %% (reflexive % _) %%
                                (abstract_rule % _ % _ %%
                                  (Lam hh.
                                    combination % split % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (abstract_rule % _ % _ %%
                                       (Lam v.
                                         abstract_rule % _ % _ %%
                                          (Lam p.
 transitive % _ % _ % _ %%
  (transitive % _ % _ % _ %%
    (combination % Ex % _ % _ % _ %% (reflexive % _) %%
      (abstract_rule % _ % _ %%
        (Lam p1.
          transitive % _ % _ % _ %%
           (transitive % _ % _ % _ %%
             (combination % Ex % _ % _ % _ %% (reflexive % _) %%
               (abstract_rule % _ % _ %%
                 (Lam p2.
                   transitive % _ % _ % _ %%
                    (combination % Ex % _ % _ % _ %% (reflexive % _) %%
                      (abstract_rule % _ % _ %%
                        (Lam h1.
                          transitive % _ % _ % _ %%
                           (transitive % _ % _ % _ %%
                             (combination % Ex % _ % _ % _ %% (reflexive % _) %%
                               (abstract_rule % _ % _ %%
                                 (Lam i.
                                   transitive % _ % _ % _ %%
                                    (transitive % _ % _ % _ %%
                                      (combination % _ % _ % _ % _ %%
                                        (combination % op & % _ % _ % _ %%
                                          (reflexive % _) %%
                                          (transitive % _ % _ % _ %%
 (transitive % _ % _ % _ %%
   (combination % op : (E, h, h1, IVal i, p1) % _ % _ % _ %% (reflexive % _) %%
     (combination % Collect % _ % _ % _ %% (reflexive % _) %%
       (combination % split % _ % _ % _ %% (reflexive % _) %%
         (abstract_rule % _ % _ %%
           (Lam E.
             combination % split % _ % _ % _ %% (reflexive % _) %%
              (abstract_rule % _ % _ %%
                (Lam h.
                  combination % split % _ % _ % _ %% (reflexive % _) %%
                   (abstract_rule % _ % _ %%
                     (Lam hh.
                       eq_reflection % _ % _ %% (split_part % _ % _)))))))))) %%
   (eq_reflection % _ % _ %%
     (mem_Collect_eq % _ %
       (%(E, h, hh, ab).
           hh = h &
           (%(v, p). v = IVal (E<n> - 1) & p = \<langle>3 0 0 0\<rangle>) ab)))) %%
 (transitive % _ % _ % _ %%
   (eq_reflection % _ % _ %%
     (split_conv %
       (%E (h, hh, ab).
           hh = h &
           (%(v, p). v = IVal (E<n> - 1) & p = \<langle>3 0 0 0\<rangle>) ab) %
       _ %
       _)) %%
   (transitive % _ % _ % _ %%
     (transitive % _ % _ % _ %%
       (combination %
         (%(h, hh, ab).
             hh = h &
             (%(v, p). v = IVal (E<n> - 1) & p = \<langle>3 0 0 0\<rangle>) ab) %
         _ %
         _ %
         _ %%
         (reflexive % _) %%
         (reflexive % _)) %%
       (eq_reflection % _ % _ %%
         (split_conv %
           (%h (hh, ab).
               hh = h &
               (%(v, p). v = IVal (E<n> - 1) & p = \<langle>3 0 0 0\<rangle>) ab) %
           _ %
           _))) %%
     (transitive % _ % _ % _ %%
       (transitive % _ % _ % _ %%
         (combination %
           (%(hh, ab).
               hh = h &
               (%(v, p). v = IVal (E<n> - 1) & p = \<langle>3 0 0 0\<rangle>) ab) %
           _ %
           _ %
           _ %%
           (reflexive % _) %%
           (reflexive % _)) %%
         (eq_reflection % _ % _ %%
           (split_conv %
             (%hh ab.
                 hh = h &
                 (%(v, p). v = IVal (E<n> - 1) & p = \<langle>3 0 0 0\<rangle>) ab) %
             _ %
             _))) %%
       (transitive % _ % _ % _ %%
         (combination %
           (%ab. h1 = h &
                 (%(v, p). v = IVal (E<n> - 1) & p = \<langle>3 0 0 0\<rangle>) ab) %
           _ %
           _ %
           _ %%
           (reflexive % _) %%
           (reflexive % _)) %%
         (combination % op & (h1 = h) % _ % _ % _ %% (reflexive % _) %%
           (transitive % _ % _ % _ %%
             (eq_reflection % _ % _ %%
               (split_conv %
                 (%v p. v = IVal (E<n> - 1) & p = \<langle>3 0 0 0\<rangle>) %
                 _ %
                 _)) %%
             (combination %
               (%p. IVal i = IVal (E<n> - 1) & p = \<langle>3 0 0 0\<rangle>) %
               (%p. i = E<n> - 1 & p = \<langle>3 0 0 0\<rangle>) %
               _ %
               _ %%
               (abstract_rule % _ % _ %%
                 (Lam p.
                   combination % _ % _ % _ % _ %%
                    (combination % op & % _ % _ % _ %% (reflexive % _) %%
                      (eq_reflection % _ % _ %% (inject_1 % _ % _))) %%
                    (reflexive % _))) %%
               (reflexive % _)))))))))) %%
                                        (combination % _ % _ % _ % _ %%
                                          (combination % op & % _ % _ % _ %%
 (reflexive % _) %%
 (transitive % _ % _ % _ %%
   (transitive % _ % _ % _ %%
     (combination % op : (E<n:=i>, h1, hh, v, p2) % _ % _ % _ %% (reflexive % _) %%
       (combination % Collect % _ % _ % _ %% (reflexive % _) %%
         (combination % split % _ % _ % _ %% (reflexive % _) %%
           (abstract_rule % _ % _ %%
             (Lam E.
               combination % split % _ % _ % _ %% (reflexive % _) %%
                (abstract_rule % _ % _ %%
                  (Lam h.
                    combination % split % _ % _ % _ %% (reflexive % _) %%
                     (abstract_rule % _ % _ %%
                       (Lam hh.
                         combination % split % _ % _ % _ %% (reflexive % _) %%
                          (abstract_rule % _ % _ %%
                            (Lam v.
                              abstract_rule % _ % _ %%
                               (Lam p.
                                 combination % Ex % _ % _ % _ %% (reflexive % _) %%
                                  (abstract_rule % _ % _ %%
                                    (Lam p1.
                                      combination % Ex % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (abstract_rule % _ % _ %%
                                         (Lam p2.
combination % Ex % _ % _ % _ %% (reflexive % _) %%
 (abstract_rule % _ % _ %%
   (Lam h1.
     transitive % _ % _ % _ %%
      (transitive % _ % _ % _ %%
        (combination % Ex % _ % _ % _ %% (reflexive % _) %%
          (abstract_rule % _ % _ %%
            (Lam w.
              combination % _ % _ % _ % _ %%
               (combination % op & % _ % _ % _ %% (reflexive % _) %%
                 (transitive % _ % _ % _ %%
                   (eq_reflection % _ % _ %%
                     (mem_Collect_eq % _ %
                       (%(E, h, hh, v, p).
                           EX a. E\<lfloor>self\<rfloor> = Ref a &
                                 hh = h<a\<bullet>count:=E<n>> &
                                 v = arbitrary & p = \<langle>3 0 0 0\<rangle>))) %%
                   (transitive % _ % _ % _ %%
                     (eq_reflection % _ % _ %%
                       (split_conv %
                         (%E (h, hh, v, p).
                             EX a. E\<lfloor>self\<rfloor> = Ref a &
                                   hh = h<a\<bullet>count:=E<n>> &
                                   v = arbitrary & p = \<langle>3 0 0 0\<rangle>) %
                         _ %
                         _)) %%
                     (transitive % _ % _ % _ %%
                       (transitive % _ % _ % _ %%
                         (combination %
                           (%(h, hh, v, p).
                               EX a. E\<lfloor>self\<rfloor> = Ref a &
                                     hh = h<a\<bullet>count:=E<n>> &
                                     v = arbitrary & p = \<langle>3 0 0 0\<rangle>) %
                           _ %
                           _ %
                           _ %%
                           (reflexive % _) %%
                           (reflexive % _)) %%
                         (eq_reflection % _ % _ %%
                           (split_conv %
                             (%h (hh, v, p).
                                 EX a. E\<lfloor>self\<rfloor> = Ref a &
                                       hh = h<a\<bullet>count:=E<n>> &
                                       v = arbitrary &
                                       p = \<langle>3 0 0 0\<rangle>) %
                             _ %
                             _))) %%
                       (transitive % _ % _ % _ %%
                         (transitive % _ % _ % _ %%
                           (combination %
                             (%(hh, v, p).
                                 EX a. E\<lfloor>self\<rfloor> = Ref a &
                                       hh = h<a\<bullet>count:=E<n>> &
                                       v = arbitrary &
                                       p = \<langle>3 0 0 0\<rangle>) %
                             _ %
                             _ %
                             _ %%
                             (reflexive % _) %%
                             (reflexive % _)) %%
                           (eq_reflection % _ % _ %%
                             (split_conv %
                               (%hh (v, p).
                                   EX a. E\<lfloor>self\<rfloor> = Ref a &
                                         hh = h<a\<bullet>count:=E<n>> &
                                         v = arbitrary &
                                         p = \<langle>3 0 0 0\<rangle>) %
                               _ %
                               _))) %%
                         (transitive % _ % _ % _ %%
                           (transitive % _ % _ % _ %%
                             (combination %
                               (%(v, p).
                                   EX a. E\<lfloor>self\<rfloor> = Ref a &
                                         h1 = h<a\<bullet>count:=E<n>> &
                                         v = arbitrary &
                                         p = \<langle>3 0 0 0\<rangle>) %
                               _ %
                               _ %
                               _ %%
                               (reflexive % _) %%
                               (reflexive % _)) %%
                             (eq_reflection % _ % _ %%
                               (split_conv %
                                 (%v p. EX a.
E\<lfloor>self\<rfloor> = Ref a &
h1 = h<a\<bullet>count:=E<n>> & v = arbitrary & p = \<langle>3 0 0 0\<rangle>) %
                                 _ %
                                 _))) %%
                           (combination %
                             (%p. EX a. E\<lfloor>self\<rfloor> = Ref a &
                                        h1 = h<a\<bullet>count:=E<n>> &
                                        w = arbitrary &
                                        p = \<langle>3 0 0 0\<rangle>) %
                             _ %
                             _ %
                             _ %%
                             (reflexive % _) %%
                             (reflexive % _)))))))) %%
               (combination % _ % _ % _ % _ %%
                 (combination % op & % _ % _ % _ %% (reflexive % _) %%
                   (transitive % _ % _ % _ %%
                     (transitive % _ % _ % _ %%
                       (combination % op : (E, h1, hh, v, p2) % _ % _ % _ %%
                         (reflexive % _) %%
                         (combination % Collect % _ % _ % _ %% (reflexive % _) %%
                           (combination % split % _ % _ % _ %% (reflexive % _) %%
                             (abstract_rule % _ % _ %%
                               (Lam E.
                                 combination % split % _ % _ % _ %% (reflexive % _) %%
                                  (abstract_rule % _ % _ %%
                                    (Lam h.
                                      combination % split % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (abstract_rule % _ % _ %%
                                         (Lam hh.
combination % split % _ % _ % _ %% (reflexive % _) %%
 (abstract_rule % _ % _ %%
   (Lam v.
     abstract_rule % _ % _ %%
      (Lam p.
        transitive % _ % _ % _ %%
         (transitive % _ % _ % _ %%
           (combination % Ex % _ % _ % _ %% (reflexive % _) %%
             (abstract_rule % _ % _ %%
               (Lam p1.
                 transitive % _ % _ % _ %%
                  (transitive % _ % _ % _ %%
                    (combination % Ex % _ % _ % _ %% (reflexive % _) %%
                      (abstract_rule % _ % _ %%
                        (Lam p2.
                          transitive % _ % _ % _ %%
                           (combination % Ex % _ % _ % _ %% (reflexive % _) %%
                             (abstract_rule % _ % _ %%
                               (Lam h1.
                                 transitive % _ % _ % _ %%
                                  (transitive % _ % _ % _ %%
                                    (combination % Ex % _ % _ % _ %%
                                      (reflexive % _) %%
                                      (abstract_rule % _ % _ %%
                                        (Lam i.
                                          transitive % _ % _ % _ %%
(transitive % _ % _ % _ %%
  (combination % _ % _ % _ % _ %%
    (combination % op & % _ % _ % _ %% (reflexive % _) %%
      (transitive % _ % _ % _ %%
        (transitive % _ % _ % _ %%
          (combination % op : (E, h, h1, IVal i, p1) % _ % _ % _ %% (reflexive % _) %%
            (combination % Collect % _ % _ % _ %% (reflexive % _) %%
              (combination % split % _ % _ % _ %% (reflexive % _) %%
                (abstract_rule % _ % _ %%
                  (Lam E.
                    combination % split % _ % _ % _ %% (reflexive % _) %%
                     (abstract_rule % _ % _ %%
                       (Lam h.
                         combination % split % _ % _ % _ %% (reflexive % _) %%
                          (abstract_rule % _ % _ %%
                            (Lam hh.
                              eq_reflection % _ % _ %%
                               (split_part % _ % _)))))))))) %%
          (eq_reflection % _ % _ %%
            (mem_Collect_eq % _ %
              (%(E, h, hh, ab).
                  hh = h &
                  (%(v, p).
                      v = IVal (if E<n> < E<one> then 1 else 0) &
                      p = \<langle>3 0 0 0\<rangle>)
                   ab)))) %%
        (transitive % _ % _ % _ %%
          (eq_reflection % _ % _ %%
            (split_conv %
              (%E (h, hh, ab).
                  hh = h &
                  (%(v, p).
                      v = IVal (if E<n> < E<one> then 1 else 0) &
                      p = \<langle>3 0 0 0\<rangle>)
                   ab) %
              _ %
              _)) %%
          (transitive % _ % _ % _ %%
            (transitive % _ % _ % _ %%
              (combination %
                (%(h, hh, ab).
                    hh = h &
                    (%(v, p).
                        v = IVal (if E<n> < E<one> then 1 else 0) &
                        p = \<langle>3 0 0 0\<rangle>)
                     ab) %
                _ %
                _ %
                _ %%
                (reflexive % _) %%
                (reflexive % _)) %%
              (eq_reflection % _ % _ %%
                (split_conv %
                  (%h (hh, ab).
                      hh = h &
                      (%(v, p).
                          v = IVal (if E<n> < E<one> then 1 else 0) &
                          p = \<langle>3 0 0 0\<rangle>)
                       ab) %
                  _ %
                  _))) %%
            (transitive % _ % _ % _ %%
              (transitive % _ % _ % _ %%
                (combination %
                  (%(hh, ab).
                      hh = h &
                      (%(v, p).
                          v = IVal (if E<n> < E<one> then 1 else 0) &
                          p = \<langle>3 0 0 0\<rangle>)
                       ab) %
                  _ %
                  _ %
                  _ %%
                  (reflexive % _) %%
                  (reflexive % _)) %%
                (eq_reflection % _ % _ %%
                  (split_conv %
                    (%hh ab.
                        hh = h &
                        (%(v, p).
                            v = IVal (if E<n> < E<one> then 1 else 0) &
                            p = \<langle>3 0 0 0\<rangle>)
                         ab) %
                    _ %
                    _))) %%
              (transitive % _ % _ % _ %%
                (combination %
                  (%ab. h1 = h &
                        (%(v, p).
                            v = IVal (if E<n> < E<one> then 1 else 0) &
                            p = \<langle>3 0 0 0\<rangle>)
                         ab) %
                  _ %
                  _ %
                  _ %%
                  (reflexive % _) %%
                  (reflexive % _)) %%
                (combination % op & (h1 = h) % _ % _ % _ %% (reflexive % _) %%
                  (transitive % _ % _ % _ %%
                    (eq_reflection % _ % _ %%
                      (split_conv %
                        (%v p. v = IVal (if E<n> < E<one> then 1 else 0) &
                               p = \<langle>3 0 0 0\<rangle>) %
                        _ %
                        _)) %%
                    (combination %
                      (%p. IVal i = IVal (if E<n> < E<one> then 1 else 0) &
                           p = \<langle>3 0 0 0\<rangle>) %
                      (%p. i = (if E<n> < E<one> then 1 else 0) &
                           p = \<langle>3 0 0 0\<rangle>) %
                      _ %
                      _ %%
                      (abstract_rule % _ % _ %%
                        (Lam p.
                          combination % _ % _ % _ % _ %%
                           (combination % op & % _ % _ % _ %% (reflexive % _) %%
                             (eq_reflection % _ % _ %% (inject_1 % _ % _))) %%
                           (reflexive % _))) %%
                      (reflexive % _)))))))))) %%
    (combination % _ % _ % _ % _ %%
      (combination % op & % _ % _ % _ %% (reflexive % _) %%
        (transitive % _ % _ % _ %%
          (transitive % _ % _ % _ %%
            (combination % op : (E<b:=i>, h1, hh, v, p2) % _ % _ % _ %%
              (reflexive % _) %%
              (combination % Collect % _ % _ % _ %% (reflexive % _) %%
                (combination % split % _ % _ % _ %% (reflexive % _) %%
                  (abstract_rule % _ % _ %%
                    (Lam E.
                      combination % split % _ % _ % _ %% (reflexive % _) %%
                       (abstract_rule % _ % _ %%
                         (Lam h.
                           combination % split % _ % _ % _ %% (reflexive % _) %%
                            (abstract_rule % _ % _ %%
                              (Lam hh.
                                combination % split % _ % _ % _ %% (reflexive % _) %%
                                 (abstract_rule % _ % _ %%
                                   (Lam v.
                                     abstract_rule % _ % _ %%
                                      (Lam p.
                                        combination % Ex % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (abstract_rule % _ % _ %%
(Lam pp.
  combination % _ % _ % _ % _ %%
   (combination % op & % _ % _ % _ %% (reflexive % _) %%
     (combination % op = p % _ % _ % _ %% (reflexive % _) %%
       (transitive % _ % _ % _ %% (renv_cup_def % _ % _) %%
         (combination % _ % _ % _ % _ %%
           (combination % renv.clock_field % _ % _ % _ %% (reflexive % _) %%
             (transitive % _ % _ % _ %%
               (combination % _ % _ % _ % _ %%
                 (combination % op + % _ % _ % _ %% (reflexive % _) %%
                   (eq_reflection % _ % _ %% (select_convs_1 % _ % _ % _ % _ % _))) %%
                 (reflexive % _)) %%
               (eq_reflection % _ % _ %% (add_2_eq_Suc % _)))) %%
           (combination % _ % _ % _ % _ %%
             (combination % callc_field % _ % _ % _ %% (reflexive % _) %%
               (transitive % _ % _ % _ %%
                 (combination % _ % _ % _ % _ %%
                   (combination % op + % _ % _ % _ %% (reflexive % _) %%
                     (eq_reflection % _ % _ %%
                       (select_convs_2 % _ % _ % _ % _ % _))) %%
                   (reflexive % _)) %%
                 (eq_reflection % _ % _ %% (zero % _)))) %%
             (combination % _ % _ % _ % _ %%
               (combination % invkc_field % _ % _ % _ %% (reflexive % _) %%
                 (transitive % _ % _ % _ %%
                   (combination % _ % _ % _ % _ %%
                     (combination % op + % _ % _ % _ %% (reflexive % _) %%
                       (eq_reflection % _ % _ %%
                         (select_convs_3 % _ % _ % _ % _ % _))) %%
                     (reflexive % _)) %%
                   (eq_reflection % _ % _ %% (zero % _)))) %%
               (combination % _ % _ % _ % _ %%
                 (combination % invkdpth_field % _ % _ % _ %% (reflexive % _) %%
                   (transitive % _ % _ % _ %%
                     (combination % _ % _ % _ % _ %%
                       (combination % max % _ % _ % _ %% (reflexive % _) %%
                         (eq_reflection % _ % _ %%
                           (select_convs_4 % _ % _ % _ % _ % _))) %%
                       (reflexive % _)) %%
                     (eq_reflection % _ % _ %% (max_0L % _)))) %%
                 (reflexive % _)))))))) %%
   (combination % _ % _ % _ % _ %%
     (combination % op & % _ % _ % _ %% (reflexive % _) %%
       (eq_reflection % _ % _ %%
         (imp_cong % _ % _ % _ % _ %%
           (meta_eq_to_obj_eq % _ % _ %%
             (equal_elim % _ % _ %%
               (symmetric % _ % _ %%
                 (combination % _ % _ % _ % _ %%
                   (combination % op == % _ % _ % _ %% (reflexive % _) %%
                     (combination % op = E<b> % _ % _ % _ %% (reflexive % _) %%
                       (eq_reflection % _ % _ %% (if_True % _ % _)))) %%
                   (reflexive % _))) %%
               (reflexive % _))) %%
           (Lam H: _.
             meta_eq_to_obj_eq % _ % _ %%
              (equal_elim % _ % _ %%
                (symmetric % _ % _ %%
                  (combination % _ % _ % _ % _ %%
                    (combination % op == % _ % _ % _ %% (reflexive % _) %%
                      (transitive % _ % _ % _ %%
                        (transitive % _ % _ % _ %%
                          (combination % op : (E, h, hh, v, pp) % _ % _ % _ %%
                            (reflexive % _) %%
                            (combination % Collect % _ % _ % _ %% (reflexive % _) %%
                              (combination % split % _ % _ % _ %% (reflexive % _) %%
                                (abstract_rule % _ % _ %%
                                  (Lam E.
                                    combination % split % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (abstract_rule % _ % _ %%
                                       (Lam h.
                                         combination % split % _ % _ % _ %%
                                          (reflexive % _) %%
                                          (abstract_rule % _ % _ %%
 (Lam hh. eq_reflection % _ % _ %% (split_part % _ % _)))))))))) %%
                          (eq_reflection % _ % _ %%
                            (mem_Collect_eq % _ %
                              (%(E, h, hh, ab).
                                  hh = h &
                                  (%(v, p).
                                      v = IVal 0 & p = \<langle>Suc 0 0 0 0\<rangle>)
                                   ab)))) %%
                        (transitive % _ % _ % _ %%
                          (eq_reflection % _ % _ %%
                            (split_conv %
                              (%E (h, hh, ab).
                                  hh = h &
                                  (%(v, p).
                                      v = IVal 0 & p = \<langle>Suc 0 0 0 0\<rangle>)
                                   ab) %
                              _ %
                              _)) %%
                          (transitive % _ % _ % _ %%
                            (transitive % _ % _ % _ %%
                              (combination %
                                (%(h, hh, ab).
                                    hh = h &
                                    (%(v, p).
                                        v = IVal 0 &
                                        p = \<langle>Suc 0 0 0 0\<rangle>)
                                     ab) %
                                _ %
                                _ %
                                _ %%
                                (reflexive % _) %%
                                (reflexive % _)) %%
                              (eq_reflection % _ % _ %%
                                (split_conv %
                                  (%h (hh, ab).
                                      hh = h &
                                      (%(v, p).
                                          v = IVal 0 &
                                          p = \<langle>Suc 0 0 0 0\<rangle>)
                                       ab) %
                                  _ %
                                  _))) %%
                            (transitive % _ % _ % _ %%
                              (transitive % _ % _ % _ %%
                                (combination %
                                  (%(hh, ab).
                                      hh = h &
                                      (%(v, p).
                                          v = IVal 0 &
                                          p = \<langle>Suc 0 0 0 0\<rangle>)
                                       ab) %
                                  _ %
                                  _ %
                                  _ %%
                                  (reflexive % _) %%
                                  (reflexive % _)) %%
                                (eq_reflection % _ % _ %%
                                  (split_conv %
                                    (%hh ab.
                                        hh = h &
                                        (%(v, p).
 v = IVal 0 & p = \<langle>Suc 0 0 0 0\<rangle>)
                                         ab) %
                                    _ %
                                    _))) %%
                              (transitive % _ % _ % _ %%
                                (combination %
                                  (%ab. hh = h &
                                        (%(v, p).
 v = IVal 0 & p = \<langle>Suc 0 0 0 0\<rangle>)
                                         ab) %
                                  _ %
                                  _ %
                                  _ %%
                                  (reflexive % _) %%
                                  (reflexive % _)) %%
                                (combination % op & (hh = h) % _ % _ % _ %%
                                  (reflexive % _) %%
                                  (transitive % _ % _ % _ %%
                                    (eq_reflection % _ % _ %%
                                      (split_conv %
                                        (%v p.
 v = IVal 0 & p = \<langle>Suc 0 0 0 0\<rangle>) %
                                        _ %
                                        _)) %%
                                    (combination %
                                      (%p. v = IVal 0 &
p = \<langle>Suc 0 0 0 0\<rangle>) %
                                      _ %
                                      _ %
                                      _ %%
                                      (reflexive % _) %%
                                      (reflexive % _)))))))))) %%
                    (reflexive % _))) %%
                (reflexive % _)))))) %%
     (combination % _ % _ % _ % _ %%
       (combination % op & % _ % _ % _ %% (reflexive % _) %%
         (eq_reflection % _ % _ %%
           (imp_cong % _ % _ % _ % _ %%
             (meta_eq_to_obj_eq % _ % _ %%
               (equal_elim % _ % _ %%
                 (symmetric % _ % _ %%
                   (combination % _ % _ % _ % _ %%
                     (combination % op == % _ % _ % _ %% (reflexive % _) %%
                       (combination % op = E<b> % _ % _ % _ %% (reflexive % _) %%
                         (eq_reflection % _ % _ %% (if_False % _ % _)))) %%
                     (reflexive % _))) %%
                 (reflexive % _))) %%
             (Lam H: _.
               meta_eq_to_obj_eq % _ % _ %%
                (equal_elim % _ % _ %%
                  (symmetric % _ % _ %%
                    (combination % _ % _ % _ % _ %%
                      (combination % op == % _ % _ % _ %% (reflexive % _) %%
                        (transitive % _ % _ % _ %%
                          (eq_reflection % _ % _ %%
                            (mem_Collect_eq % _ %
                              (%(E, h, hh, v, p).
                                  0 < h<(theloc
                                          E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                  v = IVal 0 &
                                  hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> =
                                  0))) %%
                          (transitive % _ % _ % _ %%
                            (eq_reflection % _ % _ %%
                              (split_conv %
                                (%E (h, hh, v, p).
                                    0 < h<(theloc
 E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                    v = IVal 0 &
                                    hh<(theloc
                                         E\<lfloor>self\<rfloor>)\<bullet>count> =
                                    0) %
                                _ %
                                _)) %%
                            (transitive % _ % _ % _ %%
                              (transitive % _ % _ % _ %%
                                (combination %
                                  (%(h, hh, v, p).
                                      0 < h<(theloc
   E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                      v = IVal 0 &
                                      hh<(theloc
E\<lfloor>self\<rfloor>)\<bullet>count> =
                                      0) %
                                  _ %
                                  _ %
                                  _ %%
                                  (reflexive % _) %%
                                  (reflexive % _)) %%
                                (eq_reflection % _ % _ %%
                                  (split_conv %
                                    (%h (hh, v, p).
                                        0 < h<(theloc
     E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                        v = IVal 0 &
                                        hh<(theloc
  E\<lfloor>self\<rfloor>)\<bullet>count> =
                                        0) %
                                    _ %
                                    _))) %%
                              (transitive % _ % _ % _ %%
                                (transitive % _ % _ % _ %%
                                  (combination %
                                    (%(hh, v, p).
                                        0 < h<(theloc
     E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                        v = IVal 0 &
                                        hh<(theloc
  E\<lfloor>self\<rfloor>)\<bullet>count> =
                                        0) %
                                    _ %
                                    _ %
                                    _ %%
                                    (reflexive % _) %%
                                    (reflexive % _)) %%
                                  (eq_reflection % _ % _ %%
                                    (split_conv %
                                      (%hh (v, p).
                                          0 < h<(theloc
       E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                          v = IVal 0 &
                                          hh<(theloc
    E\<lfloor>self\<rfloor>)\<bullet>count> =
                                          0) %
                                      _ %
                                      _))) %%
                                (transitive % _ % _ % _ %%
                                  (transitive % _ % _ % _ %%
                                    (combination %
                                      (%(v, p).
                                          0 < h<(theloc
       E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                          v = IVal 0 &
                                          hh<(theloc
    E\<lfloor>self\<rfloor>)\<bullet>count> =
                                          0) %
                                      _ %
                                      _ %
                                      _ %%
                                      (reflexive % _) %%
                                      (reflexive % _)) %%
                                    (eq_reflection % _ % _ %%
                                      (split_conv %
                                        (%v p.
 0 < h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
 v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0) %
                                        _ %
                                        _))) %%
                                  (combination %
                                    (%p. 0 < h<(theloc
      E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                         v = IVal 0 &
                                         hh<(theloc
   E\<lfloor>self\<rfloor>)\<bullet>count> =
                                         0) %
                                    _ %
                                    _ %
                                    _ %%
                                    (reflexive % _) %%
                                    (reflexive % _)))))))) %%
                      (reflexive % _))) %%
                  (reflexive % _)))))) %%
       (combination % _ % _ % _ % _ %%
         (combination % op | % _ % _ % _ %% (reflexive % _) %%
           (combination % op = E<b> % _ % _ % _ %% (reflexive % _) %%
             (eq_reflection % _ % _ %% (if_True % _ % _)))) %%
         (combination % op = E<b> % _ % _ % _ %% (reflexive % _) %%
           (eq_reflection % _ % _ %% (if_False % _ % _)))))))))))))))))))) %%
            (eq_reflection % _ % _ %%
              (mem_Collect_eq % _ %
                (%(E, h, hh, v, p).
                    EX pp. p = \<langle>Suc (Suc
   (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                           (E<b> = 1 -->
                            hh = h &
                            v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                           (E<b> = 0 -->
                            0 < h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
                            v = IVal 0 &
                            hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0) &
                           (E<b> = 1 | E<b> = 0))))) %%
          (transitive % _ % _ % _ %%
            (eq_reflection % _ % _ %%
              (split_conv %
                (%E (h, hh, v, p).
                    EX pp. p = \<langle>Suc (Suc
   (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                           (E<b> = 1 -->
                            hh = h &
                            v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                           (E<b> = 0 -->
                            0 < h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
                            v = IVal 0 &
                            hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0) &
                           (E<b> = 1 | E<b> = 0)) %
                _ %
                _)) %%
            (transitive % _ % _ % _ %%
              (transitive % _ % _ % _ %%
                (combination % _ % _ % _ % _ %%
                  (combination % split % _ % _ % _ %% (reflexive % _) %%
                    (abstract_rule % _ % _ %%
                      (Lam h.
                        combination % split % _ % _ % _ %% (reflexive % _) %%
                         (abstract_rule % _ % _ %%
                           (Lam hh.
                             combination % split % _ % _ % _ %% (reflexive % _) %%
                              (abstract_rule % _ % _ %%
                                (Lam v.
                                  abstract_rule % _ % _ %%
                                   (Lam p.
                                     combination % Ex % _ % _ % _ %%
                                      (reflexive % _) %%
                                      (abstract_rule % _ % _ %%
                                        (Lam pp.
                                          combination %
op & (p = \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle>) %
_ %
_ %
_ %%
(reflexive % _) %%
(combination % _ % _ % _ % _ %%
  (combination % op & % _ % _ % _ %% (reflexive % _) %%
    (eq_reflection % _ % _ %%
      (imp_cong % _ % _ % _ % _ %%
        (meta_eq_to_obj_eq % _ % _ %%
          (equal_elim % _ % _ %%
            (symmetric % _ % _ %%
              (combination % _ % _ % _ % _ %%
                (combination % op == % _ % _ % _ %% (reflexive % _) %%
                  (combination % _ % _ % _ % _ %%
                    (combination % op = % _ % _ % _ %% (reflexive % _) %%
                      (eq_reflection % _ % _ %% (ivarUpdSame % _ % _ % _))) %%
                    (reflexive % _))) %%
                (reflexive % _))) %%
            (reflexive % _))) %%
        (Lam H: _. meta_eq_to_obj_eq % _ % _ %% (reflexive % _))))) %%
  (combination % _ % _ % _ % _ %%
    (combination % op & % _ % _ % _ %% (reflexive % _) %%
      (eq_reflection % _ % _ %%
        (imp_cong % _ % _ % _ % _ %%
          (meta_eq_to_obj_eq % _ % _ %%
            (equal_elim % _ % _ %%
              (symmetric % _ % _ %%
                (combination % _ % _ % _ % _ %%
                  (combination % op == % _ % _ % _ %% (reflexive % _) %%
                    (combination % _ % _ % _ % _ %%
                      (combination % op = % _ % _ % _ %% (reflexive % _) %%
                        (eq_reflection % _ % _ %% (ivarUpdSame % _ % _ % _))) %%
                      (reflexive % _))) %%
                  (reflexive % _))) %%
              (reflexive % _))) %%
          (Lam H: _.
            meta_eq_to_obj_eq % _ % _ %%
             (equal_elim % _ % _ %%
               (symmetric % _ % _ %%
                 (combination % _ % _ % _ % _ %%
                   (combination % op == % _ % _ % _ %% (reflexive % _) %%
                     (eq_reflection % _ % _ %%
                       (imp_cong % _ % _ % _ % _ %%
                         (meta_eq_to_obj_eq % _ % _ %%
                           (equal_elim % _ % _ %%
                             (symmetric % _ % _ %%
                               (combination % _ % _ % _ % _ %%
                                 (combination % op == % _ % _ % _ %%
                                   (reflexive % _) %%
                                   (combination % op < 0 % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (combination % iheap h count % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (combination % theloc % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (transitive % _ % _ % _ %%
(combination % _ % _ % _ % _ %%
  (combination % renv_fct % _ % _ % _ %% (reflexive % _) %%
    (combination % ivarupdate E b % _ % _ % _ %% (reflexive % _) %%
      (eq_reflection % _ % _ %% H))) %%
  (reflexive % _)) %%
(eq_reflection % _ % _ %% (rvarIupdTriv % _ % _ % _ % _))))))) %%
                                 (reflexive % _))) %%
                             (reflexive % _))) %%
                         (Lam Ha: _.
                           meta_eq_to_obj_eq % _ % _ %%
                            (equal_elim % _ % _ %%
                              (symmetric % _ % _ %%
                                (combination % _ % _ % _ % _ %%
                                  (combination % op == % _ % _ % _ %%
                                    (reflexive % _) %%
                                    (combination % op & (v = IVal 0) % _ % _ % _ %%
                                      (reflexive % _) %%
                                      (combination % _ % _ % _ % _ %%
                                        (combination % op = % _ % _ % _ %%
                                          (reflexive % _) %%
                                          (combination % iheap hh count % _ % _ % _ %%
 (reflexive % _) %%
 (combination % theloc % _ % _ % _ %% (reflexive % _) %%
   (transitive % _ % _ % _ %%
     (combination % _ % _ % _ % _ %%
       (combination % renv_fct % _ % _ % _ %% (reflexive % _) %%
         (combination % ivarupdate E b % _ % _ % _ %% (reflexive % _) %%
           (eq_reflection % _ % _ %% H))) %%
       (reflexive % _)) %%
     (eq_reflection % _ % _ %% (rvarIupdTriv % _ % _ % _ % _)))))) %%
                                        (reflexive % _)))) %%
                                  (reflexive % _))) %%
                              (reflexive % _)))))) %%
                   (reflexive % _))) %%
               (reflexive % _)))))) %%
    (combination % _ % _ % _ % _ %%
      (combination % op | % _ % _ % _ %% (reflexive % _) %%
        (combination % _ % _ % _ % _ %%
          (combination % op = % _ % _ % _ %% (reflexive % _) %%
            (eq_reflection % _ % _ %% (ivarUpdSame % _ % _ % _))) %%
          (reflexive % _))) %%
      (combination % _ % _ % _ % _ %%
        (combination % op = % _ % _ % _ %% (reflexive % _) %%
          (eq_reflection % _ % _ %% (ivarUpdSame % _ % _ % _))) %%
        (reflexive % _))))))))))))))) %%
                  (reflexive % _)) %%
                (eq_reflection % _ % _ %%
                  (split_conv %
                    (%h (hh, v, p).
                        EX pp. p = \<langle>Suc
  (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                               (i = 1 -->
                                hh = h &
                                v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                               (i = 0 -->
                                0 < h<(theloc
                                        E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                v = IVal 0 &
                                hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> =
                                0) &
                               (i = 1 | i = 0)) %
                    _ %
                    _))) %%
              (transitive % _ % _ % _ %%
                (transitive % _ % _ % _ %%
                  (combination %
                    (%(hh, v, p).
                        EX pp. p = \<langle>Suc
  (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                               (i = 1 -->
                                hh = h1 &
                                v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                               (i = 0 -->
                                0 < h1<(theloc
                                         E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                v = IVal 0 &
                                hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> =
                                0) &
                               (i = 1 | i = 0)) %
                    _ %
                    _ %
                    _ %%
                    (reflexive % _) %%
                    (reflexive % _)) %%
                  (eq_reflection % _ % _ %%
                    (split_conv %
                      (%hh (v, p).
                          EX pp. p = \<langle>Suc
    (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                 (i = 1 -->
                                  hh = h1 &
                                  v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                 (i = 0 -->
                                  0 < h1<(theloc
E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                  v = IVal 0 &
                                  hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> =
                                  0) &
                                 (i = 1 | i = 0)) %
                      _ %
                      _))) %%
                (transitive % _ % _ % _ %%
                  (transitive % _ % _ % _ %%
                    (combination %
                      (%(v, p).
                          EX pp. p = \<langle>Suc
    (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                 (i = 1 -->
                                  hh = h1 &
                                  v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                 (i = 0 -->
                                  0 < h1<(theloc
E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                  v = IVal 0 &
                                  hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> =
                                  0) &
                                 (i = 1 | i = 0)) %
                      _ %
                      _ %
                      _ %%
                      (reflexive % _) %%
                      (reflexive % _)) %%
                    (eq_reflection % _ % _ %%
                      (split_conv %
                        (%v p. EX pp. p = \<langle>Suc
         (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                      (i = 1 -->
                                       hh = h1 &
                                       v = IVal 0 &
                                       pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                      (i = 0 -->
                                       0 < h1<(theloc
     E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                       v = IVal 0 &
                                       hh<(theloc
 E\<lfloor>self\<rfloor>)\<bullet>count> =
                                       0) &
                                      (i = 1 | i = 0)) %
                        _ %
                        _))) %%
                  (combination %
                    (%p. EX pp. p = \<langle>Suc
   (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                (i = 1 -->
                                 hh = h1 &
                                 v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                (i = 0 -->
                                 0 < h1<(theloc
                                          E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                 v = IVal 0 &
                                 hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> =
                                 0) &
                                (i = 1 | i = 0)) %
                    _ %
                    _ %
                    _ %%
                    (reflexive % _) %%
                    (reflexive % _)))))))) %%
      (combination % op = p % _ % _ % _ %% (reflexive % _) %%
        (transitive % _ % _ % _ %%
          (transitive % _ % _ % _ %%
            (combination % _ % _ % _ % _ %%
              (combination % op \<smile> % _ % _ % _ %% (reflexive % _) %%
                (combination % _ % _ % _ % _ %%
                  (combination % renv.clock_field % _ % _ % _ %% (reflexive % _) %%
                    axm.Nat.One_nat_def) %%
                  (reflexive % _))) %%
              (renv_cup_def % _ % _)) %%
            (renv_cup_def % _ % _)) %%
          (combination % _ % _ % _ % _ %%
            (combination % renv.clock_field % _ % _ % _ %% (reflexive % _) %%
              (transitive % _ % _ % _ %%
                (transitive % _ % _ % _ %%
                  (combination % _ % _ % _ % _ %%
                    (combination % op + % _ % _ % _ %% (reflexive % _) %%
                      (eq_reflection % _ % _ %%
                        (select_convs_1 % _ % _ % _ % _ % _))) %%
                    (eq_reflection % _ % _ %%
                      (select_convs_1 % _ % _ % _ % _ % _))) %%
                  (eq_reflection % _ % _ %% (add_Suc % _ % _))) %%
                (combination % Suc % _ % _ % _ %% (reflexive % _) %%
                  (eq_reflection % _ % _ %% (zero % _))))) %%
            (combination % _ % _ % _ % _ %%
              (combination % callc_field % _ % _ % _ %% (reflexive % _) %%
                (transitive % _ % _ % _ %%
                  (combination % _ % _ % _ % _ %%
                    (combination % op + % _ % _ % _ %% (reflexive % _) %%
                      (eq_reflection % _ % _ %%
                        (select_convs_2 % _ % _ % _ % _ % _))) %%
                    (eq_reflection % _ % _ %%
                      (select_convs_2 % _ % _ % _ % _ % _))) %%
                  (eq_reflection % _ % _ %% (zero % _)))) %%
              (combination % _ % _ % _ % _ %%
                (combination % invkc_field % _ % _ % _ %% (reflexive % _) %%
                  (transitive % _ % _ % _ %%
                    (combination % _ % _ % _ % _ %%
                      (combination % op + % _ % _ % _ %% (reflexive % _) %%
                        (eq_reflection % _ % _ %%
                          (select_convs_3 % _ % _ % _ % _ % _))) %%
                      (eq_reflection % _ % _ %%
                        (select_convs_3 % _ % _ % _ % _ % _))) %%
                    (eq_reflection % _ % _ %% (zero % _)))) %%
                (combination % _ % _ % _ % _ %%
                  (combination % invkdpth_field % _ % _ % _ %% (reflexive % _) %%
                    (transitive % _ % _ % _ %%
                      (combination % _ % _ % _ % _ %%
                        (combination % max % _ % _ % _ %% (reflexive % _) %%
                          (eq_reflection % _ % _ %%
                            (select_convs_4 % _ % _ % _ % _ % _))) %%
                        (eq_reflection % _ % _ %%
                          (select_convs_4 % _ % _ % _ % _ % _))) %%
                      (eq_reflection % _ % _ %% (max_0L % _)))) %%
                  (reflexive % _))))))))) %%
  (eq_reflection % _ % _ %% (conj_assoc % _ % _ % _))) %%
(combination % op & (h1 = h) % _ % _ % _ %% (reflexive % _) %%
  (eq_reflection % _ % _ %% (conj_assoc % _ % _ % _)))))) %%
                                    (eq_reflection % _ % _ %%
                                      (ex_simps_2 % _ % _))) %%
                                  (combination % op & (h1 = h) % _ % _ % _ %%
                                    (reflexive % _) %%
                                    (transitive % _ % _ % _ %%
                                      (transitive % _ % _ % _ %%
                                        (combination % Ex % _ % _ % _ %%
                                          (reflexive % _) %%
                                          (abstract_rule % _ % _ %%
 (Lam i. reflexive % _))) %%
                                        (eq_reflection % _ % _ %%
                                          (simp_thms_39 % _ %
 (%i. p1 = \<langle>3 0 0 0\<rangle> &
      (EX pp. p2 =
              \<langle>Suc (Suc (renv.clock
                                  pp)) callc pp invkc pp invkdpth pp\<rangle> &
              (i = 1 --> hh = h1 & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
              (i = 0 -->
               0 < h1<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
               v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0) &
              (i = 1 | i = 0)) &
      p = \<langle>Suc (renv.clock p1 +
                        renv.clock
                         p2) callc p1 +
                             callc
                              p2 invkc p1 +
                                 invkc
                                  p2 max (invkdpth p1) (invkdpth p2)\<rangle>)))) %%
                                      (combination %
                                        op & (p1 = \<langle>3 0 0 0\<rangle>) %
                                        _ %
                                        _ %
                                        _ %%
                                        (reflexive % _) %%
                                        (combination % _ % _ % _ % _ %%
                                          (combination % op & % _ % _ % _ %%
 (reflexive % _) %%
 (combination % Ex % _ % _ % _ %% (reflexive % _) %%
   (abstract_rule % _ % _ %%
     (Lam pp.
       combination %
        op & (p2 =
              \<langle>Suc (Suc (renv.clock
                                  pp)) callc pp invkc pp invkdpth pp\<rangle>) %
        _ %
        _ %
        _ %%
        (reflexive % _) %%
        (combination % _ % _ % _ % _ %%
          (combination % op & % _ % _ % _ %% (reflexive % _) %%
            (eq_reflection % _ % _ %%
              (imp_cong % _ % _ % _ % _ %%
                (meta_eq_to_obj_eq % _ % _ %%
                  (equal_elim % _ % _ %%
                    (symmetric % _ % _ %%
                      (combination % _ % _ % _ % _ %%
                        (combination % op == % _ % _ % _ %% (reflexive % _) %%
                          (eq_reflection % _ % _ %% (ifElimT % _))) %%
                        (reflexive % _))) %%
                    (reflexive % _))) %%
                (Lam H: _. meta_eq_to_obj_eq % _ % _ %% (reflexive % _))))) %%
          (transitive % _ % _ % _ %%
            (combination % _ % _ % _ % _ %%
              (combination % op & % _ % _ % _ %% (reflexive % _) %%
                (eq_reflection % _ % _ %%
                  (imp_cong % _ % _ % _ % _ %%
                    (meta_eq_to_obj_eq % _ % _ %%
                      (equal_elim % _ % _ %%
                        (symmetric % _ % _ %%
                          (combination % _ % _ % _ % _ %%
                            (combination % op == % _ % _ % _ %% (reflexive % _) %%
                              (eq_reflection % _ % _ %% (ifElimF % _))) %%
                            (reflexive % _))) %%
                        (reflexive % _))) %%
                    (Lam H: _. meta_eq_to_obj_eq % _ % _ %% (reflexive % _))))) %%
              (transitive % _ % _ % _ %%
                (combination % _ % _ % _ % _ %%
                  (combination % op | % _ % _ % _ %% (reflexive % _) %%
                    (eq_reflection % _ % _ %% (ifElimT % _))) %%
                  (eq_reflection % _ % _ %% (ifElimF % _))) %%
                (eq_reflection % _ % _ %% (simp_thms_3 % _)))) %%
            (eq_reflection % _ % _ %% (simp_thms_21 % _)))))))) %%
                                          (reflexive % _)))))))) %%
                           (eq_reflection % _ % _ %%
                             (simp_thms_39 % _ %
                               (%h1. p1 = \<langle>3 0 0 0\<rangle> &
                                     (EX pp. p2 =
  \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
  (E<n> < E<one> --> hh = h1 & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
  (~ E<n> < E<one> -->
   0 < h1<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
   v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
                                     p = \<langle>Suc
        (renv.clock p1 +
         renv.clock
          p2) callc p1 +
              callc
               p2 invkc p1 +
                  invkc p2 max (invkdpth p1) (invkdpth p2)\<rangle>)))))) %%
                    (eq_reflection % _ % _ %% (ex_simps_2 % _ % _))) %%
                  (combination % op & (p1 = \<langle>3 0 0 0\<rangle>) % _ % _ % _ %%
                    (reflexive % _) %%
                    (combination % Ex % _ % _ % _ %% (reflexive % _) %%
                      (abstract_rule % _ % _ %% (Lam p2. reflexive % _))))))) %%
           (eq_reflection % _ % _ %%
             (simp_thms_39 % _ %
               (%p1. EX p2. (EX pp. p2 =
                                    \<langle>Suc
   (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                    (E<n> < E<one> -->
                                     hh = h &
                                     v = IVal 0 &
                                     pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                    (~ E<n> < E<one> -->
                                     0 < h<(theloc
  E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                     v = IVal 0 &
                                     hh<(theloc
                                          E\<lfloor>self\<rfloor>)\<bullet>count> =
                                     0)) &
                            p = \<langle>Suc (renv.clock p1 +
   renv.clock
    p2) callc p1 +
        callc p2 invkc p1 + invkc p2 max (invkdpth p1) (invkdpth p2)\<rangle>)))) %%
         (combination % Ex % _ % _ % _ %% (reflexive % _) %%
           (abstract_rule % _ % _ %%
             (Lam p2.
               combination %
                op & (EX pp. p2 =
                             \<langle>Suc (Suc
 (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                             (E<n> < E<one> -->
                              hh = h &
                              v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                             (~ E<n> < E<one> -->
                              0 < h<(theloc
                                      E\<lfloor>self\<rfloor>)\<bullet>count> -->
                              v = IVal 0 &
                              hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> =
                              0)) %
                _ %
                _ %
                _ %%
                (reflexive % _) %%
                (combination % op = p % _ % _ % _ %% (reflexive % _) %%
                  (combination % _ % _ % _ % _ %%
                    (combination % renv.clock_field % _ % _ % _ %% (reflexive % _) %%
                      (transitive % _ % _ % _ %%
                        (transitive % _ % _ % _ %%
                          (combination % Suc % _ % _ % _ %% (reflexive % _) %%
                            (combination % _ % _ % _ % _ %%
                              (combination % op + % _ % _ % _ %% (reflexive % _) %%
                                (eq_reflection % _ % _ %%
                                  (select_convs_1 % _ % _ % _ % _ % _))) %%
                              (reflexive % _))) %%
                          (equal_elim % _ % _ %%
                            (eq_cong2 % _ % _ % _ %%
                              (equal_elim % _ % _ %%
                                (symmetric % _ % _ %%
                                  (combination % Trueprop % _ % _ % _ %%
                                    (reflexive % _) %%
                                    (combination % _ % _ % _ % _ %%
                                      (combination % op = % _ % _ % _ %%
                                        (reflexive % _) %%
                                        (combination % _ % _ % _ % _ %%
                                          (combination % op + % _ % _ % _ %%
 (reflexive % _) %%
 (combination % op * 4 % _ % _ % _ %% (reflexive % _) %%
   (eq_reflection % _ % _ %% numeral_1_eq_Suc_0))) %%
                                          (transitive % _ % _ % _ %%
 (combination % op + (renv.clock p2) % _ % _ % _ %% (reflexive % _) %%
   (eq_reflection % _ % _ %% numeral_0_eq_0)) %%
 (eq_reflection % _ % _ %% (add_0_right % _))))) %%
                                      (reflexive % _)))) %%
                                (HOL.refl % _))) %%
                            (eq_reflection % _ % _ %%
                              (HOL.trans % _ % _ % _ %%
                                (equal_elim % _ % _ %%
                                  (symmetric % _ % _ %%
                                    (combination % Trueprop % _ % _ % _ %%
                                      (reflexive % _) %%
                                      (transitive % _ % _ % _ %%
                                        (combination % _ % _ % _ % _ %%
                                          (combination % op = % _ % _ % _ %%
 (reflexive % _) %%
 (transitive % _ % _ % _ %%
   (transitive % _ % _ % _ %%
     (combination % Suc % _ % _ % _ %% (reflexive % _) %%
       (eq_reflection % _ % _ %% (add_ac_2 % _ % _))) %%
     (eq_reflection % _ % _ %% (Suc_eq_add_numeral_1 % _))) %%
   (transitive % _ % _ % _ %%
     (transitive % _ % _ % _ %%
       (combination % op + (renv.clock p2 + 3) % _ % _ % _ %% (reflexive % _) %%
         (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% numeral_1_eq_1))) %%
       (eq_reflection % _ % _ %% (add_ac_2 % _ % _))) %%
     (eq_reflection % _ % _ %% (add_ac_3 % _ % _ % _))))) %%
                                          (transitive % _ % _ % _ %%
 (combination % _ % _ % _ % _ %%
   (combination % op + % _ % _ % _ %% (reflexive % _) %%
     (eq_reflection % _ % _ %%
       (equal_elim % _ % _ %%
         (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
           (combination % _ % _ % _ % _ %%
             (combination % op = % _ % _ % _ %% (reflexive % _) %%
               (combination % op * Numeral1 % _ % _ % _ %% (reflexive % _) %%
                 (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% numeral_1_eq_1)))) %%
             (reflexive % _))) %%
         (mult_1_right % _)))) %%
   (transitive % _ % _ % _ %%
     (combination % _ % _ % _ % _ %%
       (combination % op + % _ % _ % _ %% (reflexive % _) %%
         (eq_reflection % _ % _ %%
           (equal_elim % _ % _ %%
             (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
               (combination % _ % _ % _ % _ %%
                 (combination % op = % _ % _ % _ %% (reflexive % _) %%
                   (combination % op * 3 % _ % _ % _ %% (reflexive % _) %%
                     (eq_reflection % _ % _ %%
                       (HOL.sym % _ % _ %% numeral_1_eq_1)))) %%
                 (reflexive % _))) %%
             (mult_1_right % _)))) %%
       (reflexive % _)) %%
     (eq_reflection % _ % _ %% (add_ac_2 % _ % _)))) %%
 (eq_reflection % _ % _ %% (add_ac_3 % _ % _ % _)))) %%
                                        (eq_reflection % _ % _ %%
                                          (simp_thms_6 % _))))) %%
                                  TrueI) %%
                                (HOL.trans % _ % _ % _ %%
                                  (left_add_mult_distrib % _ % _ % _ % _) %%
                                  (equal_elim % _ % _ %%
                                    (symmetric % _ % _ %%
                                      (combination % Trueprop % _ % _ % _ %%
                                        (reflexive % _) %%
                                        (transitive % _ % _ % _ %%
                                          (combination % _ % _ % _ % _ %%
 (combination % op = % _ % _ % _ %% (reflexive % _) %%
   (combination % _ % _ % _ % _ %%
     (combination % op + % _ % _ % _ %% (reflexive % _) %%
       (transitive % _ % _ % _ %%
         (transitive % _ % _ % _ %%
           (combination % _ % _ % _ % _ %%
             (combination % op * % _ % _ % _ %% (reflexive % _) %%
               (transitive % _ % _ % _ %%
                 (eq_reflection % _ % _ %% (add_nat_number_of % _ % _)) %%
                 (transitive % _ % _ % _ %%
                   (combination % _ % _ % _ % _ %%
                     (combination % _ % _ % _ % _ %%
                       (combination % If % _ % _ % _ %% (reflexive % _) %%
                         (transitive % _ % _ % _ %%
                           (eq_reflection % _ % _ %% (bin_rel_simps_12 % _ % _)) %%
                           (Eq_FalseI % _ %% bin_rel_simps_7))) %%
                       (reflexive % _)) %%
                     (transitive % _ % _ % _ %%
                       (combination % _ % _ % _ % _ %%
                         (combination % _ % _ % _ % _ %%
                           (combination % If % _ % _ % _ %% (reflexive % _) %%
                             (transitive % _ % _ % _ %%
                               (eq_reflection % _ % _ %%
                                 (bin_rel_simps_12 % _ % _)) %%
                               (transitive % _ % _ % _ %%
                                 (eq_reflection % _ % _ %%
                                   (bin_rel_simps_12 % _ % _)) %%
                                 (Eq_FalseI % _ %% bin_rel_simps_7)))) %%
                           (reflexive % _)) %%
                         (combination % number_of % _ % _ % _ %% (reflexive % _) %%
                           (transitive % _ % _ % _ %%
                             (eq_reflection % _ % _ %%
                               (bin_arith_simps_25 % _ % _)) %%
                             (transitive % _ % _ % _ %%
                               (combination % _ % _ % _ % _ %%
                                 (combination % NCons % _ % _ % _ %%
                                   (reflexive % _) %%
                                   (transitive % _ % _ % _ %%
                                     (combination % bin_add bin.Pls % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (transitive % _ % _ % _ %%
                                         (eq_reflection % _ % _ %%
(bin_arith_simps_15 % _)) %%
                                         (combination % _ % _ % _ % _ %%
(combination % op BIT % _ % _ % _ %% (reflexive % _) %%
  (eq_reflection % _ % _ %% bin_arith_simps_3)) %%
(reflexive % _)))) %%
                                     (eq_reflection % _ % _ %%
                                       (bin_arith_simps_5 % _)))) %%
                                 (reflexive % _)) %%
                               (eq_reflection % _ % _ %%
                                 (bin_arith_simps_36 % _ % _ % _)))))) %%
                       (eq_reflection % _ % _ %% (if_False % _ % _)))) %%
                   (eq_reflection % _ % _ %% (if_False % _ % _))))) %%
             (reflexive % _)) %%
           (eq_reflection % _ % _ %% (mult_nat_number_of % _ % _))) %%
         (transitive % _ % _ % _ %%
           (combination % _ % _ % _ % _ %%
             (combination % _ % _ % _ % _ %%
               (combination % If % _ % _ % _ %% (reflexive % _) %%
                 (transitive % _ % _ % _ %%
                   (eq_reflection % _ % _ %% (bin_rel_simps_12 % _ % _)) %%
                   (transitive % _ % _ % _ %%
                     (eq_reflection % _ % _ %% (bin_rel_simps_12 % _ % _)) %%
                     (transitive % _ % _ % _ %%
                       (eq_reflection % _ % _ %% (bin_rel_simps_12 % _ % _)) %%
                       (Eq_FalseI % _ %% bin_rel_simps_7))))) %%
               (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% numeral_0_eq_0))) %%
             (combination % number_of % _ % _ % _ %% (reflexive % _) %%
               (transitive % _ % _ % _ %%
                 (eq_reflection % _ % _ %% (bin_arith_simps_31 % _ % _)) %%
                 (transitive % _ % _ % _ %%
                   (combination % _ % _ % _ % _ %%
                     (combination % NCons % _ % _ % _ %% (reflexive % _) %%
                       (transitive % _ % _ % _ %%
                         (eq_reflection % _ % _ %% (bin_arith_simps_31 % _ % _)) %%
                         (transitive % _ % _ % _ %%
                           (combination % _ % _ % _ % _ %%
                             (combination % NCons % _ % _ % _ %% (reflexive % _) %%
                               (transitive % _ % _ % _ %%
                                 (eq_reflection % _ % _ %%
                                   (bin_arith_simps_30 % _ % _)) %%
                                 (transitive % _ % _ % _ %%
                                   (combination % _ % _ % _ % _ %%
                                     (combination % bin_add % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (transitive % _ % _ % _ %%
                                         (combination % _ % _ % _ % _ %%
(combination % NCons % _ % _ % _ %% (reflexive % _) %%
  (eq_reflection % _ % _ %% (bin_arith_simps_9 % _))) %%
(reflexive % _)) %%
                                         (eq_reflection % _ % _ %%
bin_arith_simps_32))) %%
                                     (reflexive % _)) %%
                                   (eq_reflection % _ % _ %%
                                     (bin_arith_simps_5 % _))))) %%
                             (reflexive % _)) %%
                           (eq_reflection % _ % _ %%
                             (bin_arith_simps_36 % _ % _ % _))))) %%
                     (reflexive % _)) %%
                   (eq_reflection % _ % _ %% (bin_arith_simps_36 % _ % _ % _)))))) %%
           (eq_reflection % _ % _ %% (if_False % _ % _))))) %%
     (reflexive % _))) %%
 (combination % _ % _ % _ % _ %%
   (combination % op + % _ % _ % _ %% (reflexive % _) %%
     (transitive % _ % _ % _ %%
       (eq_reflection % _ % _ %% (mult_nat_number_of % _ % _)) %%
       (transitive % _ % _ % _ %%
         (combination % _ % _ % _ % _ %%
           (combination % _ % _ % _ % _ %%
             (combination % If % _ % _ % _ %% (reflexive % _) %%
               (transitive % _ % _ % _ %%
                 (eq_reflection % _ % _ %% (bin_rel_simps_12 % _ % _)) %%
                 (transitive % _ % _ % _ %%
                   (eq_reflection % _ % _ %% (bin_rel_simps_12 % _ % _)) %%
                   (transitive % _ % _ % _ %%
                     (eq_reflection % _ % _ %% (bin_rel_simps_12 % _ % _)) %%
                     (Eq_FalseI % _ %% bin_rel_simps_7))))) %%
             (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% numeral_0_eq_0))) %%
           (combination % number_of % _ % _ % _ %% (reflexive % _) %%
             (transitive % _ % _ % _ %%
               (eq_reflection % _ % _ %% (bin_arith_simps_31 % _ % _)) %%
               (transitive % _ % _ % _ %%
                 (combination % _ % _ % _ % _ %%
                   (combination % NCons % _ % _ % _ %% (reflexive % _) %%
                     (transitive % _ % _ % _ %%
                       (eq_reflection % _ % _ %% (bin_arith_simps_31 % _ % _)) %%
                       (transitive % _ % _ % _ %%
                         (combination % _ % _ % _ % _ %%
                           (combination % NCons % _ % _ % _ %% (reflexive % _) %%
                             (transitive % _ % _ % _ %%
                               (eq_reflection % _ % _ %%
                                 (bin_arith_simps_30 % _ % _)) %%
                               (transitive % _ % _ % _ %%
                                 (combination % _ % _ % _ % _ %%
                                   (combination % bin_add % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (transitive % _ % _ % _ %%
                                       (combination % _ % _ % _ % _ %%
                                         (combination % NCons % _ % _ % _ %%
(reflexive % _) %%
(eq_reflection % _ % _ %% (bin_arith_simps_9 % _))) %%
                                         (reflexive % _)) %%
                                       (eq_reflection % _ % _ %%
                                         bin_arith_simps_32))) %%
                                   (reflexive % _)) %%
                                 (eq_reflection % _ % _ %%
                                   (bin_arith_simps_5 % _))))) %%
                           (reflexive % _)) %%
                         (eq_reflection % _ % _ %%
                           (bin_arith_simps_36 % _ % _ % _))))) %%
                   (reflexive % _)) %%
                 (eq_reflection % _ % _ %% (bin_arith_simps_36 % _ % _ % _)))))) %%
         (eq_reflection % _ % _ %% (if_False % _ % _))))) %%
   (eq_reflection % _ % _ %%
     (equal_elim % _ % _ %%
       (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
         (combination % _ % _ % _ % _ %%
           (combination % op = % _ % _ % _ %% (reflexive % _) %%
             (combination % op + (renv.clock p2) % _ % _ % _ %% (reflexive % _) %%
               (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% numeral_0_eq_0)))) %%
           (reflexive % _))) %%
       (add_0_right % _))))) %%
                                          (eq_reflection % _ % _ %%
 (simp_thms_6 % _))))) %%
                                    TrueI)))))) %%
                        (combination % _ % _ % _ % _ %%
                          (combination % op + % _ % _ % _ %% (reflexive % _) %%
                            (transitive % _ % _ % _ %%
                              (eq_reflection % _ % _ %% (mult_Suc_right % _ % _)) %%
                              (transitive % _ % _ % _ %%
                                (combination % op + 4 % _ % _ % _ %%
                                  (reflexive % _) %%
                                  (eq_reflection % _ % _ %% (mult_0_right % _))) %%
                                (eq_reflection % _ % _ %%
                                  (plus_ac0_zero_right % _))))) %%
                          (reflexive % _)))) %%
                    (combination % _ % _ % _ % _ %%
                      (combination % callc_field % _ % _ % _ %% (reflexive % _) %%
                        (transitive % _ % _ % _ %%
                          (combination % _ % _ % _ % _ %%
                            (combination % op + % _ % _ % _ %% (reflexive % _) %%
                              (eq_reflection % _ % _ %%
                                (select_convs_2 % _ % _ % _ % _ % _))) %%
                            (reflexive % _)) %%
                          (eq_reflection % _ % _ %% (zero % _)))) %%
                      (combination % _ % _ % _ % _ %%
                        (combination % invkc_field % _ % _ % _ %% (reflexive % _) %%
                          (transitive % _ % _ % _ %%
                            (combination % _ % _ % _ % _ %%
                              (combination % op + % _ % _ % _ %% (reflexive % _) %%
                                (eq_reflection % _ % _ %%
                                  (select_convs_3 % _ % _ % _ % _ % _))) %%
                              (reflexive % _)) %%
                            (eq_reflection % _ % _ %% (zero % _)))) %%
                        (combination % _ % _ % _ % _ %%
                          (combination % invkdpth_field % _ % _ % _ %%
                            (reflexive % _) %%
                            (transitive % _ % _ % _ %%
                              (combination % _ % _ % _ % _ %%
                                (combination % max % _ % _ % _ %% (reflexive % _) %%
                                  (eq_reflection % _ % _ %%
                                    (select_convs_4 % _ % _ % _ % _ % _))) %%
                                (reflexive % _)) %%
                              (eq_reflection % _ % _ %% (max_0L % _)))) %%
                          (reflexive % _))))))))))))))))))))) %%
                       (eq_reflection % _ % _ %%
                         (mem_Collect_eq % _ %
                           (%(E, h, hh, v, p).
                               EX p2. (EX pp. p2 =
   \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
   (E<n> < E<one> --> hh = h & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
   (~ E<n> < E<one> -->
    0 < h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
    v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
                                      p = \<langle>4 +
        renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>)))) %%
                     (transitive % _ % _ % _ %%
                       (eq_reflection % _ % _ %%
                         (split_conv %
                           (%E (h, hh, v, p).
                               EX p2. (EX pp. p2 =
   \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
   (E<n> < E<one> --> hh = h & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
   (~ E<n> < E<one> -->
    0 < h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
    v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
                                      p = \<langle>4 +
        renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) %
                           _ %
                           _)) %%
                       (transitive % _ % _ % _ %%
                         (transitive % _ % _ % _ %%
                           (combination %
                             (%(h, hh, v, p).
                                 EX p2. (EX pp.
 p2 = \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
 (E<n> < E<one> --> hh = h & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
 (~ E<n> < E<one> -->
  0 < h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
  v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
                                        p = \<langle>4 +
          renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) %
                             _ %
                             _ %
                             _ %%
                             (reflexive % _) %%
                             (reflexive % _)) %%
                           (eq_reflection % _ % _ %%
                             (split_conv %
                               (%h (hh, v, p).
                                   EX p2. (EX pp.
   p2 = \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
   (E<n> < E<one> --> hh = h & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
   (~ E<n> < E<one> -->
    0 < h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
    v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
                                          p = \<langle>4 +
            renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) %
                               _ %
                               _))) %%
                         (transitive % _ % _ % _ %%
                           (transitive % _ % _ % _ %%
                             (combination %
                               (%(hh, v, p).
                                   EX p2. (EX pp.
   p2 = \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
   (E<n> < E<one> --> hh = h1 & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
   (~ E<n> < E<one> -->
    0 < h1<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
    v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
                                          p = \<langle>4 +
            renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) %
                               _ %
                               _ %
                               _ %%
                               (reflexive % _) %%
                               (reflexive % _)) %%
                             (eq_reflection % _ % _ %%
                               (split_conv %
                                 (%hh (v, p).
                                     EX p2. (EX pp.
     p2 = \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
     (E<n> < E<one> --> hh = h1 & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
     (~ E<n> < E<one> -->
      0 < h1<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
      v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
 p = \<langle>4 + renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) %
                                 _ %
                                 _))) %%
                           (transitive % _ % _ % _ %%
                             (transitive % _ % _ % _ %%
                               (combination %
                                 (%(v, p).
                                     EX p2. (EX pp.
     p2 = \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
     (E<n> < E<one> --> hh = h1 & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
     (~ E<n> < E<one> -->
      0 < h1<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
      v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
 p = \<langle>4 + renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) %
                                 _ %
                                 _ %
                                 _ %%
                                 (reflexive % _) %%
                                 (reflexive % _)) %%
                               (eq_reflection % _ % _ %%
                                 (split_conv %
                                   (%v p. EX p2.
  (EX pp. p2 =
          \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
          (E<n> < E<one> -->
           hh = h1 & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
          (~ E<n> < E<one> -->
           0 < h1<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
           v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
  p = \<langle>4 + renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) %
                                   _ %
                                   _))) %%
                             (combination %
                               (%p. EX p2. (EX pp.
    p2 = \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
    (E<n> < E<one> --> hh = h1 & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
    (~ E<n> < E<one> -->
     0 < h1<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
     v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
p = \<langle>4 + renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) %
                               _ %
                               _ %
                               _ %%
                               (reflexive % _) %%
                               (reflexive % _)))))))) %%
                 (combination % op = p % _ % _ % _ %% (reflexive % _) %%
                   (renv_cup_def % _ % _)))))) %%
        (eq_reflection % _ % _ %% (ex_simps_1 % _ % _))) %%
      (combination % _ % _ % _ % _ %%
        (combination % op & % _ % _ % _ %% (reflexive % _) %%
          (transitive % _ % _ % _ %%
            (transitive % _ % _ % _ %%
              (combination % Ex % _ % _ % _ %% (reflexive % _) %%
                (abstract_rule % _ % _ %% (Lam w. reflexive % _))) %%
              (eq_reflection % _ % _ %%
                (HOL.trans % _ % _ % _ %% (thm % _) %%
                  (thm % _ % _ %%
                    (allI % _ %%
                      (Lam x.
                        iffI % _ % _ %%
                         (Lam H: _.
                           exE % _ % _ %% H %%
                            (Lam w H: _.
                              conjE % _ % _ % _ %% H %%
                               (Lam (H: _) Ha: _.
                                 conjE % _ % _ % _ %% Ha %%
                                  (Lam (Ha: _) Hb: _.
                                    conjE % _ % _ % _ %% Hb %%
                                     (Lam (Hb: _) Hc: _.
                                       exI %
                                        (%xa.
 xa = arbitrary &
 E\<lfloor>self\<rfloor> = Ref x &
 h1 = h<x\<bullet>count:=E<n>> & p1 = \<langle>3 0 0 0\<rangle>) %
                                        _ %%
                                        (conjI % _ % _ %% Hb %%
                                          (conjI % _ % _ %% H %%
 (conjI % _ % _ %% Ha %% Hc)))))))) %%
                         (Lam H: _.
                           exE % _ % _ %% H %%
                            (Lam w H: _.
                              conjE % _ % _ % _ %% H %%
                               (Lam (H: _) Ha: _.
                                 conjE % _ % _ % _ %% Ha %%
                                  (Lam (Ha: _) Hb: _.
                                    conjE % _ % _ % _ %% Hb %%
                                     (Lam (Hb: _) Hc: _.
                                       exI %
                                        (%xa.
 E\<lfloor>self\<rfloor> = Ref x &
 h1 = h<x\<bullet>count:=E<n>> & xa = arbitrary & p1 = \<langle>3 0 0 0\<rangle>) %
                                        _ %%
                                        (conjI % _ % _ %% Ha %%
                                          (conjI % _ % _ %% Hb %%
 (conjI % _ % _ %% H %% Hc)))))))))))))) %%
            (combination % Ex % _ % _ % _ %% (reflexive % _) %%
              (abstract_rule % _ % _ %%
                (Lam a.
                  transitive % _ % _ % _ %%
                   (eq_reflection % _ % _ %% (ex_simps_1 % _ % _)) %%
                   (transitive % _ % _ % _ %%
                     (combination % _ % _ % _ % _ %%
                       (combination % op & % _ % _ % _ %% (reflexive % _) %%
                         (transitive % _ % _ % _ %%
                           (combination % Ex % _ % _ % _ %% (reflexive % _) %%
                             (abstract_rule % _ % _ %% (Lam w. reflexive % _))) %%
                           (Eq_TrueI % _ %% (simp_thms_37 % _)))) %%
                       (reflexive % _)) %%
                     (eq_reflection % _ % _ %% (simp_thms_22 % _)))))))) %%
        (reflexive % _)))))))))))))))))))) %%
     (eq_reflection % _ % _ %%
       (mem_Collect_eq % _ %
         (%(E, h, hh, v, p).
             EX p1 p2 h1.
                (EX a. E\<lfloor>self\<rfloor> = Ref a &
                       h1 = h<a\<bullet>count:=E<n>> &
                       p1 = \<langle>3 0 0 0\<rangle>) &
                (EX p2a.
                    (EX pp. p2a =
                            \<langle>Suc (Suc
(renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                            (E<n> < E<one> -->
                             hh = h1 &
                             v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                            (~ E<n> < E<one> -->
                             0 < h1<(theloc
                                      E\<lfloor>self\<rfloor>)\<bullet>count> -->
                             v = IVal 0 &
                             hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> =
                             0)) &
                    p2 =
                    \<langle>4 + renv.clock
                                  p2a callc p2a invkc p2a invkdpth p2a\<rangle>) &
                p = \<langle>renv.clock p1 +
                             renv.clock
                              p2 callc p1 +
                                 callc
                                  p2 invkc p1 +
                                     invkc
                                      p2 max (invkdpth p1)
                                          (invkdpth p2)\<rangle>)))) %%
   (transitive % _ % _ % _ %%
     (eq_reflection % _ % _ %%
       (split_conv %
         (%E (h, hh, v, p).
             EX p1 p2 h1.
                (EX a. E\<lfloor>self\<rfloor> = Ref a &
                       h1 = h<a\<bullet>count:=E<n>> &
                       p1 = \<langle>3 0 0 0\<rangle>) &
                (EX p2a.
                    (EX pp. p2a =
                            \<langle>Suc (Suc
(renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                            (E<n> < E<one> -->
                             hh = h1 &
                             v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                            (~ E<n> < E<one> -->
                             0 < h1<(theloc
                                      E\<lfloor>self\<rfloor>)\<bullet>count> -->
                             v = IVal 0 &
                             hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> =
                             0)) &
                    p2 =
                    \<langle>4 + renv.clock
                                  p2a callc p2a invkc p2a invkdpth p2a\<rangle>) &
                p = \<langle>renv.clock p1 +
                             renv.clock
                              p2 callc p1 +
                                 callc
                                  p2 invkc p1 +
                                     invkc
                                      p2 max (invkdpth p1) (invkdpth p2)\<rangle>) %
         _ %
         _)) %%
     (transitive % _ % _ % _ %%
       (transitive % _ % _ % _ %%
         (combination % _ % _ % _ % _ %%
           (combination % split % _ % _ % _ %% (reflexive % _) %%
             (abstract_rule % _ % _ %%
               (Lam h.
                 combination % split % _ % _ % _ %% (reflexive % _) %%
                  (abstract_rule % _ % _ %%
                    (Lam hh.
                      combination % split % _ % _ % _ %% (reflexive % _) %%
                       (abstract_rule % _ % _ %%
                         (Lam v.
                           abstract_rule % _ % _ %%
                            (Lam p.
                              combination % Ex % _ % _ % _ %% (reflexive % _) %%
                               (abstract_rule % _ % _ %%
                                 (Lam p1.
                                   combination % Ex % _ % _ % _ %% (reflexive % _) %%
                                    (abstract_rule % _ % _ %%
                                      (Lam p2.
                                        combination % Ex % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (abstract_rule % _ % _ %%
(Lam h1.
  combination % _ % _ % _ % _ %%
   (combination % op & % _ % _ % _ %% (reflexive % _) %%
     (combination % Ex % _ % _ % _ %% (reflexive % _) %%
       (abstract_rule % _ % _ %%
         (Lam a.
           combination % _ % _ % _ % _ %%
            (combination % op & % _ % _ % _ %% (reflexive % _) %%
              (combination % _ % _ % _ % _ %%
                (combination % op = % _ % _ % _ %% (reflexive % _) %%
                  (eq_reflection % _ % _ %% (rvarIupdTriv % _ % _ % _ % _))) %%
                (reflexive % _))) %%
            (combination % _ % _ % _ % _ %%
              (combination % op & % _ % _ % _ %% (reflexive % _) %%
                (combination % op = h1 % _ % _ % _ %% (reflexive % _) %%
                  (combination % obj_ifieldupdate h a count % _ % _ % _ %%
                    (reflexive % _) %%
                    (eq_reflection % _ % _ %% (ivarUpdSame % _ % _ % _))))) %%
              (reflexive % _)))))) %%
   (combination % _ % _ % _ % _ %%
     (combination % op & % _ % _ % _ %% (reflexive % _) %%
       (combination % Ex % _ % _ % _ %% (reflexive % _) %%
         (abstract_rule % _ % _ %%
           (Lam p2.
             combination % _ % _ % _ % _ %%
              (combination % op & % _ % _ % _ %% (reflexive % _) %%
                (combination % Ex % _ % _ % _ %% (reflexive % _) %%
                  (abstract_rule % _ % _ %%
                    (Lam pp.
                      combination %
                       op & (p2 =
                             \<langle>Suc (Suc
 (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle>) %
                       _ %
                       _ %
                       _ %%
                       (reflexive % _) %%
                       (combination % _ % _ % _ % _ %%
                         (combination % op & % _ % _ % _ %% (reflexive % _) %%
                           (eq_reflection % _ % _ %%
                             (imp_cong % _ % _ % _ % _ %%
                               (meta_eq_to_obj_eq % _ % _ %%
                                 (equal_elim % _ % _ %%
                                   (symmetric % _ % _ %%
                                     (combination % _ % _ % _ % _ %%
                                       (combination % op == % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (combination % _ % _ % _ % _ %%
(combination % op < % _ % _ % _ %% (reflexive % _) %%
  (eq_reflection % _ % _ %% (ivarUpdSame % _ % _ % _))) %%
(eq_reflection % _ % _ %%
  (ivarUpdOther % _ % _ % _ % _ %%
    (equal_elim % _ % _ %%
      (symmetric % _ % _ %%
        (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
          (transitive % _ % _ % _ %%
            (combination % Not % _ % _ % _ %% (reflexive % _) %%
              (Eq_FalseI % _ %%
                (conjunct1 % _ % _ %%
                  (equal_elim % _ % _ %%
                    (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                      (transitive % _ % _ % _ %%
                        (transitive % _ % _ % _ %%
                          (combination % _ % _ % _ % _ %%
                            (combination % op & % _ % _ % _ %% (reflexive % _) %%
                              (transitive % _ % _ % _ %%
                                (eq_reflection % _ % _ %%
                                  (distinct.simps_2 % _ % _)) %%
                                (transitive % _ % _ % _ %%
                                  (combination % _ % _ % _ % _ %%
                                    (combination % op & % _ % _ % _ %%
                                      (reflexive % _) %%
                                      (transitive % _ % _ % _ %%
                                        (combination % Not % _ % _ % _ %%
                                          (reflexive % _) %%
                                          (transitive % _ % _ % _ %%
 (transitive % _ % _ % _ %%
   (combination % op : one % _ % _ % _ %% (reflexive % _) %%
     (transitive % _ % _ % _ %% (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
       (combination % insert n % _ % _ % _ %% (reflexive % _) %%
         (transitive % _ % _ % _ %%
           (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
           (combination % insert b % _ % _ % _ %% (reflexive % _) %%
             (eq_reflection % _ % _ %% set.simps_1)))))) %%
   (eq_reflection % _ % _ %% (insert_iff % _ % _ % _))) %%
 (combination % op | (one = n) % _ % _ % _ %% (reflexive % _) %%
   (transitive % _ % _ % _ %% (eq_reflection % _ % _ %% (insert_iff % _ % _ % _)) %%
     (transitive % _ % _ % _ %%
       (combination % op | (one = b) % _ % _ % _ %% (reflexive % _) %%
         (eq_reflection % _ % _ %% (empty_iff % _))) %%
       (eq_reflection % _ % _ %% (simp_thms_31 % _))))))) %%
                                        (eq_reflection % _ % _ %%
                                          (de_Morgan_disj % _ % _)))) %%
                                    (transitive % _ % _ % _ %%
                                      (eq_reflection % _ % _ %%
                                        (distinct.simps_2 % _ % _)) %%
                                      (transitive % _ % _ % _ %%
                                        (combination % _ % _ % _ % _ %%
                                          (combination % op & % _ % _ % _ %%
 (reflexive % _) %%
 (combination % Not % _ % _ % _ %% (reflexive % _) %%
   (transitive % _ % _ % _ %%
     (transitive % _ % _ % _ %%
       (combination % op : n % _ % _ % _ %% (reflexive % _) %%
         (transitive % _ % _ % _ %%
           (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
           (combination % insert b % _ % _ % _ %% (reflexive % _) %%
             (eq_reflection % _ % _ %% set.simps_1)))) %%
       (eq_reflection % _ % _ %% (insert_iff % _ % _ % _))) %%
     (transitive % _ % _ % _ %%
       (combination % op | (n = b) % _ % _ % _ %% (reflexive % _) %%
         (eq_reflection % _ % _ %% (empty_iff % _))) %%
       (eq_reflection % _ % _ %% (simp_thms_31 % _)))))) %%
                                          (transitive % _ % _ % _ %%
 (eq_reflection % _ % _ %% (distinct.simps_2 % _ % _)) %%
 (transitive % _ % _ % _ %%
   (combination % _ % _ % _ % _ %%
     (combination % op & % _ % _ % _ %% (reflexive % _) %%
       (transitive % _ % _ % _ %%
         (combination % Not % _ % _ % _ %% (reflexive % _) %%
           (transitive % _ % _ % _ %%
             (combination % op : b % _ % _ % _ %% (reflexive % _) %%
               (eq_reflection % _ % _ %% set.simps_1)) %%
             (eq_reflection % _ % _ %% (empty_iff % _)))) %%
         (eq_reflection % _ % _ %% simp_thms_8))) %%
     (eq_reflection % _ % _ %% distinct.simps_1)) %%
   (eq_reflection % _ % _ %% (simp_thms_25 % _))))) %%
                                        (eq_reflection % _ % _ %%
                                          (simp_thms_21 % _))))) %%
                                  (eq_reflection % _ % _ %%
                                    (conj_assoc % _ % _ % _))))) %%
                            (transitive % _ % _ % _ %%
                              (eq_reflection % _ % _ %% (distinct.simps_2 % _ % _)) %%
                              (transitive % _ % _ % _ %%
                                (combination % _ % _ % _ % _ %%
                                  (combination % op & % _ % _ % _ %%
                                    (reflexive % _) %%
                                    (transitive % _ % _ % _ %%
                                      (combination % Not % _ % _ % _ %%
                                        (reflexive % _) %%
                                        (transitive % _ % _ % _ %%
                                          (transitive % _ % _ % _ %%
 (combination % op : b % _ % _ % _ %% (reflexive % _) %%
   (transitive % _ % _ % _ %% (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
     (combination % insert n % _ % _ % _ %% (reflexive % _) %%
       (transitive % _ % _ % _ %% (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
         (combination % insert one % _ % _ % _ %% (reflexive % _) %%
           (eq_reflection % _ % _ %% set.simps_1)))))) %%
 (eq_reflection % _ % _ %% (insert_iff % _ % _ % _))) %%
                                          (combination % op | (b = n) % _ % _ % _ %%
 (reflexive % _) %%
 (transitive % _ % _ % _ %% (eq_reflection % _ % _ %% (insert_iff % _ % _ % _)) %%
   (transitive % _ % _ % _ %%
     (combination % op | (b = one) % _ % _ % _ %% (reflexive % _) %%
       (eq_reflection % _ % _ %% (empty_iff % _))) %%
     (eq_reflection % _ % _ %% (simp_thms_31 % _))))))) %%
                                      (eq_reflection % _ % _ %%
                                        (de_Morgan_disj % _ % _)))) %%
                                  (transitive % _ % _ % _ %%
                                    (eq_reflection % _ % _ %%
                                      (distinct.simps_2 % _ % _)) %%
                                    (transitive % _ % _ % _ %%
                                      (combination % _ % _ % _ % _ %%
                                        (combination % op & % _ % _ % _ %%
                                          (reflexive % _) %%
                                          (combination % Not % _ % _ % _ %%
 (reflexive % _) %%
 (transitive % _ % _ % _ %%
   (transitive % _ % _ % _ %%
     (combination % op : n % _ % _ % _ %% (reflexive % _) %%
       (transitive % _ % _ % _ %% (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
         (combination % insert one % _ % _ % _ %% (reflexive % _) %%
           (eq_reflection % _ % _ %% set.simps_1)))) %%
     (eq_reflection % _ % _ %% (insert_iff % _ % _ % _))) %%
   (transitive % _ % _ % _ %%
     (combination % op | (n = one) % _ % _ % _ %% (reflexive % _) %%
       (eq_reflection % _ % _ %% (empty_iff % _))) %%
     (eq_reflection % _ % _ %% (simp_thms_31 % _)))))) %%
                                        (transitive % _ % _ % _ %%
                                          (eq_reflection % _ % _ %%
 (distinct.simps_2 % _ % _)) %%
                                          (transitive % _ % _ % _ %%
 (combination % _ % _ % _ % _ %%
   (combination % op & % _ % _ % _ %% (reflexive % _) %%
     (transitive % _ % _ % _ %%
       (combination % Not % _ % _ % _ %% (reflexive % _) %%
         (transitive % _ % _ % _ %%
           (combination % op : one % _ % _ % _ %% (reflexive % _) %%
             (eq_reflection % _ % _ %% set.simps_1)) %%
           (eq_reflection % _ % _ %% (empty_iff % _)))) %%
       (eq_reflection % _ % _ %% simp_thms_8))) %%
   (eq_reflection % _ % _ %% distinct.simps_1)) %%
 (eq_reflection % _ % _ %% (simp_thms_25 % _))))) %%
                                      (eq_reflection % _ % _ %%
                                        (simp_thms_21 % _))))) %%
                                (eq_reflection % _ % _ %%
                                  (conj_assoc % _ % _ % _))))) %%
                          (eq_reflection % _ % _ %% (conj_assoc % _ % _ % _))) %%
                        (combination % op & (one ~= n) % _ % _ % _ %%
                          (reflexive % _) %%
                          (eq_reflection % _ % _ %% (conj_assoc % _ % _ % _))))) %%
                    vardistinct)))) %%
            (eq_reflection % _ % _ %% simp_thms_8)))) %%
      TrueI))))) %%
                                       (reflexive % _))) %%
                                   (reflexive % _))) %%
                               (Lam H: _.
                                 meta_eq_to_obj_eq % _ % _ %% (reflexive % _))))) %%
                         (eq_reflection % _ % _ %%
                           (imp_cong % _ % _ % _ % _ %%
                             (meta_eq_to_obj_eq % _ % _ %%
                               (equal_elim % _ % _ %%
                                 (symmetric % _ % _ %%
                                   (combination % _ % _ % _ % _ %%
                                     (combination % op == % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (combination % Not % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (combination % _ % _ % _ % _ %%
(combination % op < % _ % _ % _ %% (reflexive % _) %%
  (eq_reflection % _ % _ %% (ivarUpdSame % _ % _ % _))) %%
(eq_reflection % _ % _ %%
  (ivarUpdOther % _ % _ % _ % _ %%
    (equal_elim % _ % _ %%
      (symmetric % _ % _ %%
        (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
          (transitive % _ % _ % _ %%
            (combination % Not % _ % _ % _ %% (reflexive % _) %%
              (Eq_FalseI % _ %%
                (conjunct1 % _ % _ %%
                  (equal_elim % _ % _ %%
                    (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                      (transitive % _ % _ % _ %%
                        (transitive % _ % _ % _ %%
                          (combination % _ % _ % _ % _ %%
                            (combination % op & % _ % _ % _ %% (reflexive % _) %%
                              (transitive % _ % _ % _ %%
                                (eq_reflection % _ % _ %%
                                  (distinct.simps_2 % _ % _)) %%
                                (transitive % _ % _ % _ %%
                                  (combination % _ % _ % _ % _ %%
                                    (combination % op & % _ % _ % _ %%
                                      (reflexive % _) %%
                                      (transitive % _ % _ % _ %%
                                        (combination % Not % _ % _ % _ %%
                                          (reflexive % _) %%
                                          (transitive % _ % _ % _ %%
 (transitive % _ % _ % _ %%
   (combination % op : one % _ % _ % _ %% (reflexive % _) %%
     (transitive % _ % _ % _ %% (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
       (combination % insert n % _ % _ % _ %% (reflexive % _) %%
         (transitive % _ % _ % _ %%
           (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
           (combination % insert b % _ % _ % _ %% (reflexive % _) %%
             (eq_reflection % _ % _ %% set.simps_1)))))) %%
   (eq_reflection % _ % _ %% (insert_iff % _ % _ % _))) %%
 (combination % op | (one = n) % _ % _ % _ %% (reflexive % _) %%
   (transitive % _ % _ % _ %% (eq_reflection % _ % _ %% (insert_iff % _ % _ % _)) %%
     (transitive % _ % _ % _ %%
       (combination % op | (one = b) % _ % _ % _ %% (reflexive % _) %%
         (eq_reflection % _ % _ %% (empty_iff % _))) %%
       (eq_reflection % _ % _ %% (simp_thms_31 % _))))))) %%
                                        (eq_reflection % _ % _ %%
                                          (de_Morgan_disj % _ % _)))) %%
                                    (transitive % _ % _ % _ %%
                                      (eq_reflection % _ % _ %%
                                        (distinct.simps_2 % _ % _)) %%
                                      (transitive % _ % _ % _ %%
                                        (combination % _ % _ % _ % _ %%
                                          (combination % op & % _ % _ % _ %%
 (reflexive % _) %%
 (combination % Not % _ % _ % _ %% (reflexive % _) %%
   (transitive % _ % _ % _ %%
     (transitive % _ % _ % _ %%
       (combination % op : n % _ % _ % _ %% (reflexive % _) %%
         (transitive % _ % _ % _ %%
           (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
           (combination % insert b % _ % _ % _ %% (reflexive % _) %%
             (eq_reflection % _ % _ %% set.simps_1)))) %%
       (eq_reflection % _ % _ %% (insert_iff % _ % _ % _))) %%
     (transitive % _ % _ % _ %%
       (combination % op | (n = b) % _ % _ % _ %% (reflexive % _) %%
         (eq_reflection % _ % _ %% (empty_iff % _))) %%
       (eq_reflection % _ % _ %% (simp_thms_31 % _)))))) %%
                                          (transitive % _ % _ % _ %%
 (eq_reflection % _ % _ %% (distinct.simps_2 % _ % _)) %%
 (transitive % _ % _ % _ %%
   (combination % _ % _ % _ % _ %%
     (combination % op & % _ % _ % _ %% (reflexive % _) %%
       (transitive % _ % _ % _ %%
         (combination % Not % _ % _ % _ %% (reflexive % _) %%
           (transitive % _ % _ % _ %%
             (combination % op : b % _ % _ % _ %% (reflexive % _) %%
               (eq_reflection % _ % _ %% set.simps_1)) %%
             (eq_reflection % _ % _ %% (empty_iff % _)))) %%
         (eq_reflection % _ % _ %% simp_thms_8))) %%
     (eq_reflection % _ % _ %% distinct.simps_1)) %%
   (eq_reflection % _ % _ %% (simp_thms_25 % _))))) %%
                                        (eq_reflection % _ % _ %%
                                          (simp_thms_21 % _))))) %%
                                  (eq_reflection % _ % _ %%
                                    (conj_assoc % _ % _ % _))))) %%
                            (transitive % _ % _ % _ %%
                              (eq_reflection % _ % _ %% (distinct.simps_2 % _ % _)) %%
                              (transitive % _ % _ % _ %%
                                (combination % _ % _ % _ % _ %%
                                  (combination % op & % _ % _ % _ %%
                                    (reflexive % _) %%
                                    (transitive % _ % _ % _ %%
                                      (combination % Not % _ % _ % _ %%
                                        (reflexive % _) %%
                                        (transitive % _ % _ % _ %%
                                          (transitive % _ % _ % _ %%
 (combination % op : b % _ % _ % _ %% (reflexive % _) %%
   (transitive % _ % _ % _ %% (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
     (combination % insert n % _ % _ % _ %% (reflexive % _) %%
       (transitive % _ % _ % _ %% (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
         (combination % insert one % _ % _ % _ %% (reflexive % _) %%
           (eq_reflection % _ % _ %% set.simps_1)))))) %%
 (eq_reflection % _ % _ %% (insert_iff % _ % _ % _))) %%
                                          (combination % op | (b = n) % _ % _ % _ %%
 (reflexive % _) %%
 (transitive % _ % _ % _ %% (eq_reflection % _ % _ %% (insert_iff % _ % _ % _)) %%
   (transitive % _ % _ % _ %%
     (combination % op | (b = one) % _ % _ % _ %% (reflexive % _) %%
       (eq_reflection % _ % _ %% (empty_iff % _))) %%
     (eq_reflection % _ % _ %% (simp_thms_31 % _))))))) %%
                                      (eq_reflection % _ % _ %%
                                        (de_Morgan_disj % _ % _)))) %%
                                  (transitive % _ % _ % _ %%
                                    (eq_reflection % _ % _ %%
                                      (distinct.simps_2 % _ % _)) %%
                                    (transitive % _ % _ % _ %%
                                      (combination % _ % _ % _ % _ %%
                                        (combination % op & % _ % _ % _ %%
                                          (reflexive % _) %%
                                          (combination % Not % _ % _ % _ %%
 (reflexive % _) %%
 (transitive % _ % _ % _ %%
   (transitive % _ % _ % _ %%
     (combination % op : n % _ % _ % _ %% (reflexive % _) %%
       (transitive % _ % _ % _ %% (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
         (combination % insert one % _ % _ % _ %% (reflexive % _) %%
           (eq_reflection % _ % _ %% set.simps_1)))) %%
     (eq_reflection % _ % _ %% (insert_iff % _ % _ % _))) %%
   (transitive % _ % _ % _ %%
     (combination % op | (n = one) % _ % _ % _ %% (reflexive % _) %%
       (eq_reflection % _ % _ %% (empty_iff % _))) %%
     (eq_reflection % _ % _ %% (simp_thms_31 % _)))))) %%
                                        (transitive % _ % _ % _ %%
                                          (eq_reflection % _ % _ %%
 (distinct.simps_2 % _ % _)) %%
                                          (transitive % _ % _ % _ %%
 (combination % _ % _ % _ % _ %%
   (combination % op & % _ % _ % _ %% (reflexive % _) %%
     (transitive % _ % _ % _ %%
       (combination % Not % _ % _ % _ %% (reflexive % _) %%
         (transitive % _ % _ % _ %%
           (combination % op : one % _ % _ % _ %% (reflexive % _) %%
             (eq_reflection % _ % _ %% set.simps_1)) %%
           (eq_reflection % _ % _ %% (empty_iff % _)))) %%
       (eq_reflection % _ % _ %% simp_thms_8))) %%
   (eq_reflection % _ % _ %% distinct.simps_1)) %%
 (eq_reflection % _ % _ %% (simp_thms_25 % _))))) %%
                                      (eq_reflection % _ % _ %%
                                        (simp_thms_21 % _))))) %%
                                (eq_reflection % _ % _ %%
                                  (conj_assoc % _ % _ % _))))) %%
                          (eq_reflection % _ % _ %% (conj_assoc % _ % _ % _))) %%
                        (combination % op & (one ~= n) % _ % _ % _ %%
                          (reflexive % _) %%
                          (eq_reflection % _ % _ %% (conj_assoc % _ % _ % _))))) %%
                    vardistinct)))) %%
            (eq_reflection % _ % _ %% simp_thms_8)))) %%
      TrueI)))))) %%
                                     (reflexive % _))) %%
                                 (reflexive % _))) %%
                             (Lam H: _.
                               meta_eq_to_obj_eq % _ % _ %%
                                (equal_elim % _ % _ %%
                                  (symmetric % _ % _ %%
                                    (combination % _ % _ % _ % _ %%
                                      (combination % op == % _ % _ % _ %%
                                        (reflexive % _) %%
                                        (eq_reflection % _ % _ %%
                                          (imp_cong % _ % _ % _ % _ %%
 (meta_eq_to_obj_eq % _ % _ %%
   (equal_elim % _ % _ %%
     (symmetric % _ % _ %%
       (combination % _ % _ % _ % _ %%
         (combination % op == % _ % _ % _ %% (reflexive % _) %%
           (combination % op < 0 % _ % _ % _ %% (reflexive % _) %%
             (combination % iheap h1 count % _ % _ % _ %% (reflexive % _) %%
               (combination % theloc % _ % _ % _ %% (reflexive % _) %%
                 (eq_reflection % _ % _ %% (rvarIupdTriv % _ % _ % _ % _)))))) %%
         (reflexive % _))) %%
     (reflexive % _))) %%
 (Lam H: _.
   meta_eq_to_obj_eq % _ % _ %%
    (equal_elim % _ % _ %%
      (symmetric % _ % _ %%
        (combination % _ % _ % _ % _ %%
          (combination % op == % _ % _ % _ %% (reflexive % _) %%
            (combination % op & (v = IVal 0) % _ % _ % _ %% (reflexive % _) %%
              (combination % _ % _ % _ % _ %%
                (combination % op = % _ % _ % _ %% (reflexive % _) %%
                  (combination % iheap hh count % _ % _ % _ %% (reflexive % _) %%
                    (combination % theloc % _ % _ % _ %% (reflexive % _) %%
                      (eq_reflection % _ % _ %% (rvarIupdTriv % _ % _ % _ % _))))) %%
                (reflexive % _)))) %%
          (reflexive % _))) %%
      (reflexive % _)))))) %%
                                      (reflexive % _))) %%
                                  (reflexive % _)))))))))) %%
              (reflexive % _))))) %%
     (reflexive % _)))))))))))))))) %%
           (reflexive % _)) %%
         (eq_reflection % _ % _ %%
           (split_conv %
             (%h (hh, v, p).
                 EX p1 p2 h1.
                    (EX a. E\<lfloor>self\<rfloor> = Ref a &
                           h1 = h<a\<bullet>count:=i> &
                           p1 = \<langle>3 0 0 0\<rangle>) &
                    (EX p2a.
                        (EX pp. p2a =
                                \<langle>Suc (Suc
    (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                (i < E<one> -->
                                 hh = h1 &
                                 v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                (~ i < E<one> -->
                                 0 < h1<(theloc
                                          E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                 v = IVal 0 &
                                 hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> =
                                 0)) &
                        p2 =
                        \<langle>4 + renv.clock
                                      p2a callc p2a invkc p2a invkdpth p2a\<rangle>) &
                    p = \<langle>renv.clock p1 +
                                 renv.clock
                                  p2 callc p1 +
                                     callc
                                      p2 invkc p1 +
                                         invkc
                                          p2 max (invkdpth p1)
   (invkdpth p2)\<rangle>) %
             _ %
             _))) %%
       (transitive % _ % _ % _ %%
         (transitive % _ % _ % _ %%
           (combination %
             (%(hh, v, p).
                 EX p1 p2 h1a.
                    (EX a. E\<lfloor>self\<rfloor> = Ref a &
                           h1a = h1<a\<bullet>count:=i> &
                           p1 = \<langle>3 0 0 0\<rangle>) &
                    (EX p2a.
                        (EX pp. p2a =
                                \<langle>Suc (Suc
    (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                (i < E<one> -->
                                 hh = h1a &
                                 v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                (~ i < E<one> -->
                                 0 < h1a<(theloc
E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                 v = IVal 0 &
                                 hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> =
                                 0)) &
                        p2 =
                        \<langle>4 + renv.clock
                                      p2a callc p2a invkc p2a invkdpth p2a\<rangle>) &
                    p = \<langle>renv.clock p1 +
                                 renv.clock
                                  p2 callc p1 +
                                     callc
                                      p2 invkc p1 +
                                         invkc
                                          p2 max (invkdpth p1)
   (invkdpth p2)\<rangle>) %
             _ %
             _ %
             _ %%
             (reflexive % _) %%
             (reflexive % _)) %%
           (eq_reflection % _ % _ %%
             (split_conv %
               (%hh (v, p).
                   EX p1 p2 h1a.
                      (EX a. E\<lfloor>self\<rfloor> = Ref a &
                             h1a = h1<a\<bullet>count:=i> &
                             p1 = \<langle>3 0 0 0\<rangle>) &
                      (EX p2a.
                          (EX pp. p2a =
                                  \<langle>Suc
 (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                  (i < E<one> -->
                                   hh = h1a &
                                   v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                  (~ i < E<one> -->
                                   0 < h1a<(theloc
  E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                   v = IVal 0 &
                                   hh<(theloc
                                        E\<lfloor>self\<rfloor>)\<bullet>count> =
                                   0)) &
                          p2 =
                          \<langle>4 + renv.clock
                                        p2a callc
  p2a invkc p2a invkdpth p2a\<rangle>) &
                      p = \<langle>renv.clock p1 +
                                   renv.clock
                                    p2 callc p1 +
                                       callc
                                        p2 invkc p1 +
invkc p2 max (invkdpth p1) (invkdpth p2)\<rangle>) %
               _ %
               _))) %%
         (transitive % _ % _ % _ %%
           (transitive % _ % _ % _ %%
             (combination %
               (%(v, p).
                   EX p1 p2 h1a.
                      (EX a. E\<lfloor>self\<rfloor> = Ref a &
                             h1a = h1<a\<bullet>count:=i> &
                             p1 = \<langle>3 0 0 0\<rangle>) &
                      (EX p2a.
                          (EX pp. p2a =
                                  \<langle>Suc
 (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                  (i < E<one> -->
                                   hh = h1a &
                                   v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                  (~ i < E<one> -->
                                   0 < h1a<(theloc
  E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                   v = IVal 0 &
                                   hh<(theloc
                                        E\<lfloor>self\<rfloor>)\<bullet>count> =
                                   0)) &
                          p2 =
                          \<langle>4 + renv.clock
                                        p2a callc
  p2a invkc p2a invkdpth p2a\<rangle>) &
                      p = \<langle>renv.clock p1 +
                                   renv.clock
                                    p2 callc p1 +
                                       callc
                                        p2 invkc p1 +
invkc p2 max (invkdpth p1) (invkdpth p2)\<rangle>) %
               _ %
               _ %
               _ %%
               (reflexive % _) %%
               (reflexive % _)) %%
             (eq_reflection % _ % _ %%
               (split_conv %
                 (%v p. EX p1 p2 h1a.
                           (EX a. E\<lfloor>self\<rfloor> = Ref a &
                                  h1a = h1<a\<bullet>count:=i> &
                                  p1 = \<langle>3 0 0 0\<rangle>) &
                           (EX p2a.
                               (EX pp. p2a =
                                       \<langle>Suc
      (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                       (i < E<one> -->
                                        hh = h1a &
                                        v = IVal 0 &
                                        pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                       (~ i < E<one> -->
                                        0 < h1a<(theloc
       E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                        v = IVal 0 &
                                        hh<(theloc
  E\<lfloor>self\<rfloor>)\<bullet>count> =
                                        0)) &
                               p2 =
                               \<langle>4 + renv.clock
  p2a callc p2a invkc p2a invkdpth p2a\<rangle>) &
                           p = \<langle>renv.clock p1 +
                                        renv.clock
                                         p2 callc p1 +
 callc p2 invkc p1 + invkc p2 max (invkdpth p1) (invkdpth p2)\<rangle>) %
                 _ %
                 _))) %%
           (combination %
             (%p. EX p1 p2 h1a.
                     (EX a. E\<lfloor>self\<rfloor> = Ref a &
                            h1a = h1<a\<bullet>count:=i> &
                            p1 = \<langle>3 0 0 0\<rangle>) &
                     (EX p2a.
                         (EX pp. p2a =
                                 \<langle>Suc
(Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                 (i < E<one> -->
                                  hh = h1a &
                                  v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                 (~ i < E<one> -->
                                  0 < h1a<(theloc
 E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                  v = IVal 0 &
                                  hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> =
                                  0)) &
                         p2 =
                         \<langle>4 + renv.clock
                                       p2a callc
 p2a invkc p2a invkdpth p2a\<rangle>) &
                     p = \<langle>renv.clock p1 +
                                  renv.clock
                                   p2 callc p1 +
                                      callc
                                       p2 invkc p1 +
                                          invkc
p2 max (invkdpth p1) (invkdpth p2)\<rangle>) %
             _ %
             _ %
             _ %%
             (reflexive % _) %%
             (reflexive % _)))))))) %%
                                          (combination % op = p % _ % _ % _ %%
 (reflexive % _) %%
 (transitive % _ % _ % _ %%
   (transitive % _ % _ % _ %%
     (combination % _ % _ % _ % _ %%
       (combination % op \<smile> % _ % _ % _ %% (reflexive % _) %%
         (combination % _ % _ % _ % _ %%
           (combination % renv.clock_field % _ % _ % _ %% (reflexive % _) %%
             axm.Nat.One_nat_def) %%
           (reflexive % _))) %%
       (renv_cup_def % _ % _)) %%
     (renv_cup_def % _ % _)) %%
   (combination % _ % _ % _ % _ %%
     (combination % renv.clock_field % _ % _ % _ %% (reflexive % _) %%
       (transitive % _ % _ % _ %%
         (transitive % _ % _ % _ %%
           (combination % _ % _ % _ % _ %%
             (combination % op + % _ % _ % _ %% (reflexive % _) %%
               (eq_reflection % _ % _ %% (select_convs_1 % _ % _ % _ % _ % _))) %%
             (eq_reflection % _ % _ %% (select_convs_1 % _ % _ % _ % _ % _))) %%
           (eq_reflection % _ % _ %% (add_Suc % _ % _))) %%
         (combination % Suc % _ % _ % _ %% (reflexive % _) %%
           (eq_reflection % _ % _ %% (zero % _))))) %%
     (combination % _ % _ % _ % _ %%
       (combination % callc_field % _ % _ % _ %% (reflexive % _) %%
         (transitive % _ % _ % _ %%
           (combination % _ % _ % _ % _ %%
             (combination % op + % _ % _ % _ %% (reflexive % _) %%
               (eq_reflection % _ % _ %% (select_convs_2 % _ % _ % _ % _ % _))) %%
             (eq_reflection % _ % _ %% (select_convs_2 % _ % _ % _ % _ % _))) %%
           (eq_reflection % _ % _ %% (zero % _)))) %%
       (combination % _ % _ % _ % _ %%
         (combination % invkc_field % _ % _ % _ %% (reflexive % _) %%
           (transitive % _ % _ % _ %%
             (combination % _ % _ % _ % _ %%
               (combination % op + % _ % _ % _ %% (reflexive % _) %%
                 (eq_reflection % _ % _ %% (select_convs_3 % _ % _ % _ % _ % _))) %%
               (eq_reflection % _ % _ %% (select_convs_3 % _ % _ % _ % _ % _))) %%
             (eq_reflection % _ % _ %% (zero % _)))) %%
         (combination % _ % _ % _ % _ %%
           (combination % invkdpth_field % _ % _ % _ %% (reflexive % _) %%
             (transitive % _ % _ % _ %%
               (combination % _ % _ % _ % _ %%
                 (combination % max % _ % _ % _ %% (reflexive % _) %%
                   (eq_reflection % _ % _ %% (select_convs_4 % _ % _ % _ % _ % _))) %%
                 (eq_reflection % _ % _ %% (select_convs_4 % _ % _ % _ % _ % _))) %%
               (eq_reflection % _ % _ %% (max_0L % _)))) %%
           (reflexive % _))))))))) %%
                                      (eq_reflection % _ % _ %%
                                        (conj_assoc % _ % _ % _))) %%
                                    (combination % op & (h1 = h) % _ % _ % _ %%
                                      (reflexive % _) %%
                                      (eq_reflection % _ % _ %%
                                        (conj_assoc % _ % _ % _)))))) %%
                             (eq_reflection % _ % _ %% (ex_simps_2 % _ % _))) %%
                           (combination % op & (h1 = h) % _ % _ % _ %%
                             (reflexive % _) %%
                             (transitive % _ % _ % _ %%
                               (combination % Ex % _ % _ % _ %% (reflexive % _) %%
                                 (abstract_rule % _ % _ %% (Lam i. reflexive % _))) %%
                               (eq_reflection % _ % _ %%
                                 (simp_thms_39 % _ %
                                   (%i. p1 = \<langle>3 0 0 0\<rangle> &
                                        (EX p1 p2a h1a.
 (EX a. E\<lfloor>self\<rfloor> = Ref a &
        h1a = h1<a\<bullet>count:=i> & p1 = \<langle>3 0 0 0\<rangle>) &
 (EX p2. (EX pp. p2 =
                 \<langle>Suc (Suc (renv.clock
                                     pp)) callc pp invkc pp invkdpth pp\<rangle> &
                 (i < E<one> -->
                  hh = h1a & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                 (~ i < E<one> -->
                  0 < h1a<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
                  v = IVal 0 &
                  hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
         p2a = \<langle>4 + renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
 p2 =
 \<langle>renv.clock p1 +
          renv.clock
           p2a callc p1 +
               callc
                p2a invkc p1 + invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                                        p = \<langle>Suc
           (renv.clock p1 +
            renv.clock
             p2) callc p1 +
                 callc
                  p2 invkc p1 +
                     invkc p2 max (invkdpth p1) (invkdpth p2)\<rangle>)))))))) %%
                    (eq_reflection % _ % _ %%
                      (simp_thms_39 % _ %
                        (%h1. p1 = \<langle>3 0 0 0\<rangle> &
                              (EX p1 p2a h1a.
                                  (EX a. E\<lfloor>self\<rfloor> = Ref a &
                                         h1a = h1<a\<bullet>count:=(E<n> - 1)> &
                                         p1 = \<langle>3 0 0 0\<rangle>) &
                                  (EX p2. (EX pp.
   p2 = \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
   (E<n> - 1 < E<one> -->
    hh = h1a & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
   (~ E<n> - 1 < E<one> -->
    0 < h1a<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
    v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
                                          p2a =
                                          \<langle>4 +
        renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                                  p2 =
                                  \<langle>renv.clock p1 +
renv.clock
 p2a callc p1 +
     callc p2a invkc p1 + invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                              p = \<langle>Suc
 (renv.clock p1 +
  renv.clock
   p2) callc p1 +
       callc p2 invkc p1 + invkc p2 max (invkdpth p1) (invkdpth p2)\<rangle>)))))) %%
             (eq_reflection % _ % _ %% (ex_simps_2 % _ % _))) %%
           (combination % op & (p1 = \<langle>3 0 0 0\<rangle>) % _ % _ % _ %%
             (reflexive % _) %%
             (combination % Ex % _ % _ % _ %% (reflexive % _) %%
               (abstract_rule % _ % _ %% (Lam p2. reflexive % _))))))) %%
    (eq_reflection % _ % _ %%
      (simp_thms_39 % _ %
        (%p1. EX p2. (EX p1 p2a h1.
                         (EX a. E\<lfloor>self\<rfloor> = Ref a &
                                h1 = h<a\<bullet>count:=(E<n> - 1)> &
                                p1 = \<langle>3 0 0 0\<rangle>) &
                         (EX p2. (EX pp. p2 =
                                         \<langle>Suc
        (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                         (E<n> - 1 < E<one> -->
                                          hh = h1 &
                                          v = IVal 0 &
                                          pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                         (~ E<n> - 1 < E<one> -->
                                          0 < h1<(theloc
        E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                          v = IVal 0 &
                                          hh<(theloc
    E\<lfloor>self\<rfloor>)\<bullet>count> =
                                          0)) &
                                 p2a =
                                 \<langle>4 + renv.clock
    p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                         p2 =
                         \<langle>renv.clock p1 +
                                  renv.clock
                                   p2a callc p1 +
                                       callc
                                        p2a invkc p1 +
 invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                     p = \<langle>Suc (renv.clock p1 +
                                       renv.clock
                                        p2) callc p1 +
 callc p2 invkc p1 + invkc p2 max (invkdpth p1) (invkdpth p2)\<rangle>)))) %%
  (combination % Ex % _ % _ % _ %% (reflexive % _) %%
    (abstract_rule % _ % _ %%
      (Lam p2.
        combination %
         op & (EX p1 p2a h1.
                  (EX a. E\<lfloor>self\<rfloor> = Ref a &
                         h1 = h<a\<bullet>count:=(E<n> - 1)> &
                         p1 = \<langle>3 0 0 0\<rangle>) &
                  (EX p2. (EX pp. p2 =
                                  \<langle>Suc
 (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                  (E<n> - 1 < E<one> -->
                                   hh = h1 &
                                   v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                  (~ E<n> - 1 < E<one> -->
                                   0 < h1<(theloc
 E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                   v = IVal 0 &
                                   hh<(theloc
                                        E\<lfloor>self\<rfloor>)\<bullet>count> =
                                   0)) &
                          p2a =
                          \<langle>4 + renv.clock
                                        p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                  p2 =
                  \<langle>renv.clock p1 +
                           renv.clock
                            p2a callc p1 +
                                callc
                                 p2a invkc p1 +
                                     invkc
                                      p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) %
         _ %
         _ %
         _ %%
         (reflexive % _) %%
         (combination % op = p % _ % _ % _ %% (reflexive % _) %%
           (combination % _ % _ % _ % _ %%
             (combination % renv.clock_field % _ % _ % _ %% (reflexive % _) %%
               (transitive % _ % _ % _ %%
                 (transitive % _ % _ % _ %%
                   (combination % Suc % _ % _ % _ %% (reflexive % _) %%
                     (combination % _ % _ % _ % _ %%
                       (combination % op + % _ % _ % _ %% (reflexive % _) %%
                         (eq_reflection % _ % _ %%
                           (select_convs_1 % _ % _ % _ % _ % _))) %%
                       (reflexive % _))) %%
                   (equal_elim % _ % _ %%
                     (eq_cong2 % _ % _ % _ %%
                       (equal_elim % _ % _ %%
                         (symmetric % _ % _ %%
                           (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                             (combination % _ % _ % _ % _ %%
                               (combination % op = % _ % _ % _ %% (reflexive % _) %%
                                 (combination % _ % _ % _ % _ %%
                                   (combination % op + % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (combination % op * 4 % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (eq_reflection % _ % _ %%
                                         numeral_1_eq_Suc_0))) %%
                                   (transitive % _ % _ % _ %%
                                     (combination % op + (renv.clock p2) % _ % _ %
                                       _ %%
                                       (reflexive % _) %%
                                       (eq_reflection % _ % _ %% numeral_0_eq_0)) %%
                                     (eq_reflection % _ % _ %%
                                       (add_0_right % _))))) %%
                               (reflexive % _)))) %%
                         (HOL.refl % _))) %%
                     (eq_reflection % _ % _ %%
                       (HOL.trans % _ % _ % _ %%
                         (equal_elim % _ % _ %%
                           (symmetric % _ % _ %%
                             (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                               (transitive % _ % _ % _ %%
                                 (combination % _ % _ % _ % _ %%
                                   (combination % op = % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (transitive % _ % _ % _ %%
                                       (transitive % _ % _ % _ %%
                                         (combination % Suc % _ % _ % _ %%
(reflexive % _) %%
(eq_reflection % _ % _ %% (add_ac_2 % _ % _))) %%
                                         (eq_reflection % _ % _ %%
(Suc_eq_add_numeral_1 % _))) %%
                                       (transitive % _ % _ % _ %%
                                         (transitive % _ % _ % _ %%
(combination % op + (renv.clock p2 + 3) % _ % _ % _ %% (reflexive % _) %%
  (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% numeral_1_eq_1))) %%
(eq_reflection % _ % _ %% (add_ac_2 % _ % _))) %%
                                         (eq_reflection % _ % _ %%
(add_ac_3 % _ % _ % _))))) %%
                                   (transitive % _ % _ % _ %%
                                     (combination % _ % _ % _ % _ %%
                                       (combination % op + % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (eq_reflection % _ % _ %%
(equal_elim % _ % _ %%
  (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
    (combination % _ % _ % _ % _ %%
      (combination % op = % _ % _ % _ %% (reflexive % _) %%
        (combination % op * Numeral1 % _ % _ % _ %% (reflexive % _) %%
          (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% numeral_1_eq_1)))) %%
      (reflexive % _))) %%
  (mult_1_right % _)))) %%
                                       (transitive % _ % _ % _ %%
                                         (combination % _ % _ % _ % _ %%
(combination % op + % _ % _ % _ %% (reflexive % _) %%
  (eq_reflection % _ % _ %%
    (equal_elim % _ % _ %%
      (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
        (combination % _ % _ % _ % _ %%
          (combination % op = % _ % _ % _ %% (reflexive % _) %%
            (combination % op * 3 % _ % _ % _ %% (reflexive % _) %%
              (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% numeral_1_eq_1)))) %%
          (reflexive % _))) %%
      (mult_1_right % _)))) %%
(reflexive % _)) %%
                                         (eq_reflection % _ % _ %%
(add_ac_2 % _ % _)))) %%
                                     (eq_reflection % _ % _ %%
                                       (add_ac_3 % _ % _ % _)))) %%
                                 (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
                           TrueI) %%
                         (HOL.trans % _ % _ % _ %%
                           (left_add_mult_distrib % _ % _ % _ % _) %%
                           (equal_elim % _ % _ %%
                             (symmetric % _ % _ %%
                               (combination % Trueprop % _ % _ % _ %%
                                 (reflexive % _) %%
                                 (transitive % _ % _ % _ %%
                                   (combination % _ % _ % _ % _ %%
                                     (combination % op = % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (combination % _ % _ % _ % _ %%
                                         (combination % op + % _ % _ % _ %%
(reflexive % _) %%
(transitive % _ % _ % _ %%
  (transitive % _ % _ % _ %%
    (combination % _ % _ % _ % _ %%
      (combination % op * % _ % _ % _ %% (reflexive % _) %%
        (transitive % _ % _ % _ %%
          (eq_reflection % _ % _ %% (add_nat_number_of % _ % _)) %%
          (transitive % _ % _ % _ %%
            (combination % _ % _ % _ % _ %%
              (combination % _ % _ % _ % _ %%
                (combination % If % _ % _ % _ %% (reflexive % _) %%
                  (transitive % _ % _ % _ %%
                    (eq_reflection % _ % _ %% (bin_rel_simps_12 % _ % _)) %%
                    (Eq_FalseI % _ %% bin_rel_simps_7))) %%
                (reflexive % _)) %%
              (transitive % _ % _ % _ %%
                (combination % _ % _ % _ % _ %%
                  (combination % _ % _ % _ % _ %%
                    (combination % If % _ % _ % _ %% (reflexive % _) %%
                      (transitive % _ % _ % _ %%
                        (eq_reflection % _ % _ %% (bin_rel_simps_12 % _ % _)) %%
                        (transitive % _ % _ % _ %%
                          (eq_reflection % _ % _ %% (bin_rel_simps_12 % _ % _)) %%
                          (Eq_FalseI % _ %% bin_rel_simps_7)))) %%
                    (reflexive % _)) %%
                  (combination % number_of % _ % _ % _ %% (reflexive % _) %%
                    (transitive % _ % _ % _ %%
                      (eq_reflection % _ % _ %% (bin_arith_simps_25 % _ % _)) %%
                      (transitive % _ % _ % _ %%
                        (combination % _ % _ % _ % _ %%
                          (combination % NCons % _ % _ % _ %% (reflexive % _) %%
                            (transitive % _ % _ % _ %%
                              (combination % bin_add bin.Pls % _ % _ % _ %%
                                (reflexive % _) %%
                                (transitive % _ % _ % _ %%
                                  (eq_reflection % _ % _ %%
                                    (bin_arith_simps_15 % _)) %%
                                  (combination % _ % _ % _ % _ %%
                                    (combination % op BIT % _ % _ % _ %%
                                      (reflexive % _) %%
                                      (eq_reflection % _ % _ %% bin_arith_simps_3)) %%
                                    (reflexive % _)))) %%
                              (eq_reflection % _ % _ %% (bin_arith_simps_5 % _)))) %%
                          (reflexive % _)) %%
                        (eq_reflection % _ % _ %%
                          (bin_arith_simps_36 % _ % _ % _)))))) %%
                (eq_reflection % _ % _ %% (if_False % _ % _)))) %%
            (eq_reflection % _ % _ %% (if_False % _ % _))))) %%
      (reflexive % _)) %%
    (eq_reflection % _ % _ %% (mult_nat_number_of % _ % _))) %%
  (transitive % _ % _ % _ %%
    (combination % _ % _ % _ % _ %%
      (combination % _ % _ % _ % _ %%
        (combination % If % _ % _ % _ %% (reflexive % _) %%
          (transitive % _ % _ % _ %%
            (eq_reflection % _ % _ %% (bin_rel_simps_12 % _ % _)) %%
            (transitive % _ % _ % _ %%
              (eq_reflection % _ % _ %% (bin_rel_simps_12 % _ % _)) %%
              (transitive % _ % _ % _ %%
                (eq_reflection % _ % _ %% (bin_rel_simps_12 % _ % _)) %%
                (Eq_FalseI % _ %% bin_rel_simps_7))))) %%
        (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% numeral_0_eq_0))) %%
      (combination % number_of % _ % _ % _ %% (reflexive % _) %%
        (transitive % _ % _ % _ %%
          (eq_reflection % _ % _ %% (bin_arith_simps_31 % _ % _)) %%
          (transitive % _ % _ % _ %%
            (combination % _ % _ % _ % _ %%
              (combination % NCons % _ % _ % _ %% (reflexive % _) %%
                (transitive % _ % _ % _ %%
                  (eq_reflection % _ % _ %% (bin_arith_simps_31 % _ % _)) %%
                  (transitive % _ % _ % _ %%
                    (combination % _ % _ % _ % _ %%
                      (combination % NCons % _ % _ % _ %% (reflexive % _) %%
                        (transitive % _ % _ % _ %%
                          (eq_reflection % _ % _ %% (bin_arith_simps_30 % _ % _)) %%
                          (transitive % _ % _ % _ %%
                            (combination % _ % _ % _ % _ %%
                              (combination % bin_add % _ % _ % _ %% (reflexive % _) %%
                                (transitive % _ % _ % _ %%
                                  (combination % _ % _ % _ % _ %%
                                    (combination % NCons % _ % _ % _ %%
                                      (reflexive % _) %%
                                      (eq_reflection % _ % _ %%
                                        (bin_arith_simps_9 % _))) %%
                                    (reflexive % _)) %%
                                  (eq_reflection % _ % _ %% bin_arith_simps_32))) %%
                              (reflexive % _)) %%
                            (eq_reflection % _ % _ %% (bin_arith_simps_5 % _))))) %%
                      (reflexive % _)) %%
                    (eq_reflection % _ % _ %% (bin_arith_simps_36 % _ % _ % _))))) %%
              (reflexive % _)) %%
            (eq_reflection % _ % _ %% (bin_arith_simps_36 % _ % _ % _)))))) %%
    (eq_reflection % _ % _ %% (if_False % _ % _))))) %%
                                         (reflexive % _))) %%
                                     (combination % _ % _ % _ % _ %%
                                       (combination % op + % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (transitive % _ % _ % _ %%
(eq_reflection % _ % _ %% (mult_nat_number_of % _ % _)) %%
(transitive % _ % _ % _ %%
  (combination % _ % _ % _ % _ %%
    (combination % _ % _ % _ % _ %%
      (combination % If % _ % _ % _ %% (reflexive % _) %%
        (transitive % _ % _ % _ %%
          (eq_reflection % _ % _ %% (bin_rel_simps_12 % _ % _)) %%
          (transitive % _ % _ % _ %%
            (eq_reflection % _ % _ %% (bin_rel_simps_12 % _ % _)) %%
            (transitive % _ % _ % _ %%
              (eq_reflection % _ % _ %% (bin_rel_simps_12 % _ % _)) %%
              (Eq_FalseI % _ %% bin_rel_simps_7))))) %%
      (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% numeral_0_eq_0))) %%
    (combination % number_of % _ % _ % _ %% (reflexive % _) %%
      (transitive % _ % _ % _ %%
        (eq_reflection % _ % _ %% (bin_arith_simps_31 % _ % _)) %%
        (transitive % _ % _ % _ %%
          (combination % _ % _ % _ % _ %%
            (combination % NCons % _ % _ % _ %% (reflexive % _) %%
              (transitive % _ % _ % _ %%
                (eq_reflection % _ % _ %% (bin_arith_simps_31 % _ % _)) %%
                (transitive % _ % _ % _ %%
                  (combination % _ % _ % _ % _ %%
                    (combination % NCons % _ % _ % _ %% (reflexive % _) %%
                      (transitive % _ % _ % _ %%
                        (eq_reflection % _ % _ %% (bin_arith_simps_30 % _ % _)) %%
                        (transitive % _ % _ % _ %%
                          (combination % _ % _ % _ % _ %%
                            (combination % bin_add % _ % _ % _ %% (reflexive % _) %%
                              (transitive % _ % _ % _ %%
                                (combination % _ % _ % _ % _ %%
                                  (combination % NCons % _ % _ % _ %%
                                    (reflexive % _) %%
                                    (eq_reflection % _ % _ %%
                                      (bin_arith_simps_9 % _))) %%
                                  (reflexive % _)) %%
                                (eq_reflection % _ % _ %% bin_arith_simps_32))) %%
                            (reflexive % _)) %%
                          (eq_reflection % _ % _ %% (bin_arith_simps_5 % _))))) %%
                    (reflexive % _)) %%
                  (eq_reflection % _ % _ %% (bin_arith_simps_36 % _ % _ % _))))) %%
            (reflexive % _)) %%
          (eq_reflection % _ % _ %% (bin_arith_simps_36 % _ % _ % _)))))) %%
  (eq_reflection % _ % _ %% (if_False % _ % _))))) %%
                                       (eq_reflection % _ % _ %%
                                         (equal_elim % _ % _ %%
(combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
  (combination % _ % _ % _ % _ %%
    (combination % op = % _ % _ % _ %% (reflexive % _) %%
      (combination % op + (renv.clock p2) % _ % _ % _ %% (reflexive % _) %%
        (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% numeral_0_eq_0)))) %%
    (reflexive % _))) %%
(add_0_right % _))))) %%
                                   (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
                             TrueI)))))) %%
                 (combination % _ % _ % _ % _ %%
                   (combination % op + % _ % _ % _ %% (reflexive % _) %%
                     (transitive % _ % _ % _ %%
                       (eq_reflection % _ % _ %% (mult_Suc_right % _ % _)) %%
                       (transitive % _ % _ % _ %%
                         (combination % op + 4 % _ % _ % _ %% (reflexive % _) %%
                           (eq_reflection % _ % _ %% (mult_0_right % _))) %%
                         (eq_reflection % _ % _ %% (plus_ac0_zero_right % _))))) %%
                   (reflexive % _)))) %%
             (combination % _ % _ % _ % _ %%
               (combination % callc_field % _ % _ % _ %% (reflexive % _) %%
                 (transitive % _ % _ % _ %%
                   (combination % _ % _ % _ % _ %%
                     (combination % op + % _ % _ % _ %% (reflexive % _) %%
                       (eq_reflection % _ % _ %%
                         (select_convs_2 % _ % _ % _ % _ % _))) %%
                     (reflexive % _)) %%
                   (eq_reflection % _ % _ %% (zero % _)))) %%
               (combination % _ % _ % _ % _ %%
                 (combination % invkc_field % _ % _ % _ %% (reflexive % _) %%
                   (transitive % _ % _ % _ %%
                     (combination % _ % _ % _ % _ %%
                       (combination % op + % _ % _ % _ %% (reflexive % _) %%
                         (eq_reflection % _ % _ %%
                           (select_convs_3 % _ % _ % _ % _ % _))) %%
                       (reflexive % _)) %%
                     (eq_reflection % _ % _ %% (zero % _)))) %%
                 (combination % _ % _ % _ % _ %%
                   (combination % invkdpth_field % _ % _ % _ %% (reflexive % _) %%
                     (transitive % _ % _ % _ %%
                       (combination % _ % _ % _ % _ %%
                         (combination % max % _ % _ % _ %% (reflexive % _) %%
                           (eq_reflection % _ % _ %%
                             (select_convs_4 % _ % _ % _ % _ % _))) %%
                         (reflexive % _)) %%
                       (eq_reflection % _ % _ %% (max_0L % _)))) %%
                   (reflexive % _))))))))))))))))))))) %%
                (eq_reflection % _ % _ %%
                  (mem_Collect_eq % _ %
                    (%(E, h, hh, v, p).
                        EX p2. (EX p1 p2a h1.
                                   (EX a. E\<lfloor>self\<rfloor> = Ref a &
                                          h1 = h<a\<bullet>count:=(E<n> - 1)> &
                                          p1 = \<langle>3 0 0 0\<rangle>) &
                                   (EX p2. (EX pp.
    p2 = \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
    (E<n> - 1 < E<one> -->
     hh = h1 & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
    (~ E<n> - 1 < E<one> -->
     0 < h1<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
     v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
p2a = \<langle>4 + renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                                   p2 =
                                   \<langle>renv.clock p1 +
 renv.clock
  p2a callc p1 +
      callc p2a invkc p1 + invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                               p = \<langle>4 +
 renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>)))) %%
              (transitive % _ % _ % _ %%
                (eq_reflection % _ % _ %%
                  (split_conv %
                    (%E (h, hh, v, p).
                        EX p2. (EX p1 p2a h1.
                                   (EX a. E\<lfloor>self\<rfloor> = Ref a &
                                          h1 = h<a\<bullet>count:=(E<n> - 1)> &
                                          p1 = \<langle>3 0 0 0\<rangle>) &
                                   (EX p2. (EX pp.
    p2 = \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
    (E<n> - 1 < E<one> -->
     hh = h1 & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
    (~ E<n> - 1 < E<one> -->
     0 < h1<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
     v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
p2a = \<langle>4 + renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                                   p2 =
                                   \<langle>renv.clock p1 +
 renv.clock
  p2a callc p1 +
      callc p2a invkc p1 + invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                               p = \<langle>4 +
 renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) %
                    _ %
                    _)) %%
                (transitive % _ % _ % _ %%
                  (transitive % _ % _ % _ %%
                    (combination % _ % _ % _ % _ %%
                      (combination % split % _ % _ % _ %% (reflexive % _) %%
                        (abstract_rule % _ % _ %%
                          (Lam h.
                            combination % split % _ % _ % _ %% (reflexive % _) %%
                             (abstract_rule % _ % _ %%
                               (Lam hh.
                                 combination % split % _ % _ % _ %% (reflexive % _) %%
                                  (abstract_rule % _ % _ %%
                                    (Lam v.
                                      abstract_rule % _ % _ %%
                                       (Lam p.
                                         combination % Ex % _ % _ % _ %%
                                          (reflexive % _) %%
                                          (abstract_rule % _ % _ %%
 (Lam p2.
   combination % _ % _ % _ % _ %%
    (combination % op & % _ % _ % _ %% (reflexive % _) %%
      (combination % Ex % _ % _ % _ %% (reflexive % _) %%
        (abstract_rule % _ % _ %%
          (Lam p1.
            combination % Ex % _ % _ % _ %% (reflexive % _) %%
             (abstract_rule % _ % _ %%
               (Lam p2.
                 combination % Ex % _ % _ % _ %% (reflexive % _) %%
                  (abstract_rule % _ % _ %%
                    (Lam h1.
                      combination % _ % _ % _ % _ %%
                       (combination % op & % _ % _ % _ %% (reflexive % _) %%
                         (combination % Ex % _ % _ % _ %% (reflexive % _) %%
                           (abstract_rule % _ % _ %%
                             (Lam a.
                               combination % _ % _ % _ % _ %%
                                (combination % op & % _ % _ % _ %% (reflexive % _) %%
                                  (combination % _ % _ % _ % _ %%
                                    (combination % op = % _ % _ % _ %%
                                      (reflexive % _) %%
                                      (eq_reflection % _ % _ %%
                                        (rvarIupdTriv % _ % _ % _ % _))) %%
                                    (reflexive % _))) %%
                                (combination % _ % _ % _ % _ %%
                                  (combination % op & % _ % _ % _ %%
                                    (reflexive % _) %%
                                    (combination % op = h1 % _ % _ % _ %%
                                      (reflexive % _) %%
                                      (combination % obj_ifieldupdate h a count % _ %
                                        _ %
                                        _ %%
                                        (reflexive % _) %%
                                        (combination % _ % _ % _ % _ %%
                                          (combination % op - % _ % _ % _ %%
 (reflexive % _) %%
 (eq_reflection % _ % _ %% (ivarUpdSame % _ % _ % _))) %%
                                          (reflexive % _))))) %%
                                  (reflexive % _)))))) %%
                       (combination % _ % _ % _ % _ %%
                         (combination % op & % _ % _ % _ %% (reflexive % _) %%
                           (combination % Ex % _ % _ % _ %% (reflexive % _) %%
                             (abstract_rule % _ % _ %%
                               (Lam p2.
                                 combination % _ % _ % _ % _ %%
                                  (combination % op & % _ % _ % _ %%
                                    (reflexive % _) %%
                                    (combination % Ex % _ % _ % _ %%
                                      (reflexive % _) %%
                                      (abstract_rule % _ % _ %%
                                        (Lam pp.
                                          combination %
op & (p2 =
      \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle>) %
_ %
_ %
_ %%
(reflexive % _) %%
(combination % _ % _ % _ % _ %%
  (combination % op & % _ % _ % _ %% (reflexive % _) %%
    (eq_reflection % _ % _ %%
      (imp_cong % _ % _ % _ % _ %%
        (meta_eq_to_obj_eq % _ % _ %%
          (equal_elim % _ % _ %%
            (symmetric % _ % _ %%
              (combination % _ % _ % _ % _ %%
                (combination % op == % _ % _ % _ %% (reflexive % _) %%
                  (combination % _ % _ % _ % _ %%
                    (combination % op < % _ % _ % _ %% (reflexive % _) %%
                      (combination % _ % _ % _ % _ %%
                        (combination % op - % _ % _ % _ %% (reflexive % _) %%
                          (eq_reflection % _ % _ %% (ivarUpdSame % _ % _ % _))) %%
                        (reflexive % _))) %%
                    (eq_reflection % _ % _ %%
                      (ivarUpdOther % _ % _ % _ % _ %%
                        (equal_elim % _ % _ %%
                          (symmetric % _ % _ %%
                            (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                              (transitive % _ % _ % _ %%
                                (combination % Not % _ % _ % _ %% (reflexive % _) %%
                                  (Eq_FalseI % _ %%
                                    (conjunct1 % _ % _ %%
                                      (equal_elim % _ % _ %%
                                        (combination % Trueprop % _ % _ % _ %%
                                          (reflexive % _) %%
                                          (transitive % _ % _ % _ %%
 (transitive % _ % _ % _ %%
   (combination % _ % _ % _ % _ %%
     (combination % op & % _ % _ % _ %% (reflexive % _) %%
       (transitive % _ % _ % _ %%
         (eq_reflection % _ % _ %% (distinct.simps_2 % _ % _)) %%
         (transitive % _ % _ % _ %%
           (combination % _ % _ % _ % _ %%
             (combination % op & % _ % _ % _ %% (reflexive % _) %%
               (transitive % _ % _ % _ %%
                 (combination % Not % _ % _ % _ %% (reflexive % _) %%
                   (transitive % _ % _ % _ %%
                     (transitive % _ % _ % _ %%
                       (combination % op : one % _ % _ % _ %% (reflexive % _) %%
                         (transitive % _ % _ % _ %%
                           (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
                           (combination % insert n % _ % _ % _ %% (reflexive % _) %%
                             (transitive % _ % _ % _ %%
                               (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
                               (combination % insert b % _ % _ % _ %%
                                 (reflexive % _) %%
                                 (eq_reflection % _ % _ %% set.simps_1)))))) %%
                       (eq_reflection % _ % _ %% (insert_iff % _ % _ % _))) %%
                     (combination % op | (one = n) % _ % _ % _ %% (reflexive % _) %%
                       (transitive % _ % _ % _ %%
                         (eq_reflection % _ % _ %% (insert_iff % _ % _ % _)) %%
                         (transitive % _ % _ % _ %%
                           (combination % op | (one = b) % _ % _ % _ %%
                             (reflexive % _) %%
                             (eq_reflection % _ % _ %% (empty_iff % _))) %%
                           (eq_reflection % _ % _ %% (simp_thms_31 % _))))))) %%
                 (eq_reflection % _ % _ %% (de_Morgan_disj % _ % _)))) %%
             (transitive % _ % _ % _ %%
               (eq_reflection % _ % _ %% (distinct.simps_2 % _ % _)) %%
               (transitive % _ % _ % _ %%
                 (combination % _ % _ % _ % _ %%
                   (combination % op & % _ % _ % _ %% (reflexive % _) %%
                     (combination % Not % _ % _ % _ %% (reflexive % _) %%
                       (transitive % _ % _ % _ %%
                         (transitive % _ % _ % _ %%
                           (combination % op : n % _ % _ % _ %% (reflexive % _) %%
                             (transitive % _ % _ % _ %%
                               (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
                               (combination % insert b % _ % _ % _ %%
                                 (reflexive % _) %%
                                 (eq_reflection % _ % _ %% set.simps_1)))) %%
                           (eq_reflection % _ % _ %% (insert_iff % _ % _ % _))) %%
                         (transitive % _ % _ % _ %%
                           (combination % op | (n = b) % _ % _ % _ %%
                             (reflexive % _) %%
                             (eq_reflection % _ % _ %% (empty_iff % _))) %%
                           (eq_reflection % _ % _ %% (simp_thms_31 % _)))))) %%
                   (transitive % _ % _ % _ %%
                     (eq_reflection % _ % _ %% (distinct.simps_2 % _ % _)) %%
                     (transitive % _ % _ % _ %%
                       (combination % _ % _ % _ % _ %%
                         (combination % op & % _ % _ % _ %% (reflexive % _) %%
                           (transitive % _ % _ % _ %%
                             (combination % Not % _ % _ % _ %% (reflexive % _) %%
                               (transitive % _ % _ % _ %%
                                 (combination % op : b % _ % _ % _ %%
                                   (reflexive % _) %%
                                   (eq_reflection % _ % _ %% set.simps_1)) %%
                                 (eq_reflection % _ % _ %% (empty_iff % _)))) %%
                             (eq_reflection % _ % _ %% simp_thms_8))) %%
                         (eq_reflection % _ % _ %% distinct.simps_1)) %%
                       (eq_reflection % _ % _ %% (simp_thms_25 % _))))) %%
                 (eq_reflection % _ % _ %% (simp_thms_21 % _))))) %%
           (eq_reflection % _ % _ %% (conj_assoc % _ % _ % _))))) %%
     (transitive % _ % _ % _ %%
       (eq_reflection % _ % _ %% (distinct.simps_2 % _ % _)) %%
       (transitive % _ % _ % _ %%
         (combination % _ % _ % _ % _ %%
           (combination % op & % _ % _ % _ %% (reflexive % _) %%
             (transitive % _ % _ % _ %%
               (combination % Not % _ % _ % _ %% (reflexive % _) %%
                 (transitive % _ % _ % _ %%
                   (transitive % _ % _ % _ %%
                     (combination % op : b % _ % _ % _ %% (reflexive % _) %%
                       (transitive % _ % _ % _ %%
                         (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
                         (combination % insert n % _ % _ % _ %% (reflexive % _) %%
                           (transitive % _ % _ % _ %%
                             (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
                             (combination % insert one % _ % _ % _ %%
                               (reflexive % _) %%
                               (eq_reflection % _ % _ %% set.simps_1)))))) %%
                     (eq_reflection % _ % _ %% (insert_iff % _ % _ % _))) %%
                   (combination % op | (b = n) % _ % _ % _ %% (reflexive % _) %%
                     (transitive % _ % _ % _ %%
                       (eq_reflection % _ % _ %% (insert_iff % _ % _ % _)) %%
                       (transitive % _ % _ % _ %%
                         (combination % op | (b = one) % _ % _ % _ %%
                           (reflexive % _) %%
                           (eq_reflection % _ % _ %% (empty_iff % _))) %%
                         (eq_reflection % _ % _ %% (simp_thms_31 % _))))))) %%
               (eq_reflection % _ % _ %% (de_Morgan_disj % _ % _)))) %%
           (transitive % _ % _ % _ %%
             (eq_reflection % _ % _ %% (distinct.simps_2 % _ % _)) %%
             (transitive % _ % _ % _ %%
               (combination % _ % _ % _ % _ %%
                 (combination % op & % _ % _ % _ %% (reflexive % _) %%
                   (combination % Not % _ % _ % _ %% (reflexive % _) %%
                     (transitive % _ % _ % _ %%
                       (transitive % _ % _ % _ %%
                         (combination % op : n % _ % _ % _ %% (reflexive % _) %%
                           (transitive % _ % _ % _ %%
                             (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
                             (combination % insert one % _ % _ % _ %%
                               (reflexive % _) %%
                               (eq_reflection % _ % _ %% set.simps_1)))) %%
                         (eq_reflection % _ % _ %% (insert_iff % _ % _ % _))) %%
                       (transitive % _ % _ % _ %%
                         (combination % op | (n = one) % _ % _ % _ %%
                           (reflexive % _) %%
                           (eq_reflection % _ % _ %% (empty_iff % _))) %%
                         (eq_reflection % _ % _ %% (simp_thms_31 % _)))))) %%
                 (transitive % _ % _ % _ %%
                   (eq_reflection % _ % _ %% (distinct.simps_2 % _ % _)) %%
                   (transitive % _ % _ % _ %%
                     (combination % _ % _ % _ % _ %%
                       (combination % op & % _ % _ % _ %% (reflexive % _) %%
                         (transitive % _ % _ % _ %%
                           (combination % Not % _ % _ % _ %% (reflexive % _) %%
                             (transitive % _ % _ % _ %%
                               (combination % op : one % _ % _ % _ %%
                                 (reflexive % _) %%
                                 (eq_reflection % _ % _ %% set.simps_1)) %%
                               (eq_reflection % _ % _ %% (empty_iff % _)))) %%
                           (eq_reflection % _ % _ %% simp_thms_8))) %%
                       (eq_reflection % _ % _ %% distinct.simps_1)) %%
                     (eq_reflection % _ % _ %% (simp_thms_25 % _))))) %%
               (eq_reflection % _ % _ %% (simp_thms_21 % _))))) %%
         (eq_reflection % _ % _ %% (conj_assoc % _ % _ % _))))) %%
   (eq_reflection % _ % _ %% (conj_assoc % _ % _ % _))) %%
 (combination % op & (one ~= n) % _ % _ % _ %% (reflexive % _) %%
   (eq_reflection % _ % _ %% (conj_assoc % _ % _ % _))))) %%
                                        vardistinct)))) %%
                                (eq_reflection % _ % _ %% simp_thms_8)))) %%
                          TrueI))))) %%
                (reflexive % _))) %%
            (reflexive % _))) %%
        (Lam H: _. meta_eq_to_obj_eq % _ % _ %% (reflexive % _))))) %%
  (eq_reflection % _ % _ %%
    (imp_cong % _ % _ % _ % _ %%
      (meta_eq_to_obj_eq % _ % _ %%
        (equal_elim % _ % _ %%
          (symmetric % _ % _ %%
            (combination % _ % _ % _ % _ %%
              (combination % op == % _ % _ % _ %% (reflexive % _) %%
                (combination % Not % _ % _ % _ %% (reflexive % _) %%
                  (combination % _ % _ % _ % _ %%
                    (combination % op < % _ % _ % _ %% (reflexive % _) %%
                      (combination % _ % _ % _ % _ %%
                        (combination % op - % _ % _ % _ %% (reflexive % _) %%
                          (eq_reflection % _ % _ %% (ivarUpdSame % _ % _ % _))) %%
                        (reflexive % _))) %%
                    (eq_reflection % _ % _ %%
                      (ivarUpdOther % _ % _ % _ % _ %%
                        (equal_elim % _ % _ %%
                          (symmetric % _ % _ %%
                            (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                              (transitive % _ % _ % _ %%
                                (combination % Not % _ % _ % _ %% (reflexive % _) %%
                                  (Eq_FalseI % _ %%
                                    (conjunct1 % _ % _ %%
                                      (equal_elim % _ % _ %%
                                        (combination % Trueprop % _ % _ % _ %%
                                          (reflexive % _) %%
                                          (transitive % _ % _ % _ %%
 (transitive % _ % _ % _ %%
   (combination % _ % _ % _ % _ %%
     (combination % op & % _ % _ % _ %% (reflexive % _) %%
       (transitive % _ % _ % _ %%
         (eq_reflection % _ % _ %% (distinct.simps_2 % _ % _)) %%
         (transitive % _ % _ % _ %%
           (combination % _ % _ % _ % _ %%
             (combination % op & % _ % _ % _ %% (reflexive % _) %%
               (transitive % _ % _ % _ %%
                 (combination % Not % _ % _ % _ %% (reflexive % _) %%
                   (transitive % _ % _ % _ %%
                     (transitive % _ % _ % _ %%
                       (combination % op : one % _ % _ % _ %% (reflexive % _) %%
                         (transitive % _ % _ % _ %%
                           (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
                           (combination % insert n % _ % _ % _ %% (reflexive % _) %%
                             (transitive % _ % _ % _ %%
                               (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
                               (combination % insert b % _ % _ % _ %%
                                 (reflexive % _) %%
                                 (eq_reflection % _ % _ %% set.simps_1)))))) %%
                       (eq_reflection % _ % _ %% (insert_iff % _ % _ % _))) %%
                     (combination % op | (one = n) % _ % _ % _ %% (reflexive % _) %%
                       (transitive % _ % _ % _ %%
                         (eq_reflection % _ % _ %% (insert_iff % _ % _ % _)) %%
                         (transitive % _ % _ % _ %%
                           (combination % op | (one = b) % _ % _ % _ %%
                             (reflexive % _) %%
                             (eq_reflection % _ % _ %% (empty_iff % _))) %%
                           (eq_reflection % _ % _ %% (simp_thms_31 % _))))))) %%
                 (eq_reflection % _ % _ %% (de_Morgan_disj % _ % _)))) %%
             (transitive % _ % _ % _ %%
               (eq_reflection % _ % _ %% (distinct.simps_2 % _ % _)) %%
               (transitive % _ % _ % _ %%
                 (combination % _ % _ % _ % _ %%
                   (combination % op & % _ % _ % _ %% (reflexive % _) %%
                     (combination % Not % _ % _ % _ %% (reflexive % _) %%
                       (transitive % _ % _ % _ %%
                         (transitive % _ % _ % _ %%
                           (combination % op : n % _ % _ % _ %% (reflexive % _) %%
                             (transitive % _ % _ % _ %%
                               (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
                               (combination % insert b % _ % _ % _ %%
                                 (reflexive % _) %%
                                 (eq_reflection % _ % _ %% set.simps_1)))) %%
                           (eq_reflection % _ % _ %% (insert_iff % _ % _ % _))) %%
                         (transitive % _ % _ % _ %%
                           (combination % op | (n = b) % _ % _ % _ %%
                             (reflexive % _) %%
                             (eq_reflection % _ % _ %% (empty_iff % _))) %%
                           (eq_reflection % _ % _ %% (simp_thms_31 % _)))))) %%
                   (transitive % _ % _ % _ %%
                     (eq_reflection % _ % _ %% (distinct.simps_2 % _ % _)) %%
                     (transitive % _ % _ % _ %%
                       (combination % _ % _ % _ % _ %%
                         (combination % op & % _ % _ % _ %% (reflexive % _) %%
                           (transitive % _ % _ % _ %%
                             (combination % Not % _ % _ % _ %% (reflexive % _) %%
                               (transitive % _ % _ % _ %%
                                 (combination % op : b % _ % _ % _ %%
                                   (reflexive % _) %%
                                   (eq_reflection % _ % _ %% set.simps_1)) %%
                                 (eq_reflection % _ % _ %% (empty_iff % _)))) %%
                             (eq_reflection % _ % _ %% simp_thms_8))) %%
                         (eq_reflection % _ % _ %% distinct.simps_1)) %%
                       (eq_reflection % _ % _ %% (simp_thms_25 % _))))) %%
                 (eq_reflection % _ % _ %% (simp_thms_21 % _))))) %%
           (eq_reflection % _ % _ %% (conj_assoc % _ % _ % _))))) %%
     (transitive % _ % _ % _ %%
       (eq_reflection % _ % _ %% (distinct.simps_2 % _ % _)) %%
       (transitive % _ % _ % _ %%
         (combination % _ % _ % _ % _ %%
           (combination % op & % _ % _ % _ %% (reflexive % _) %%
             (transitive % _ % _ % _ %%
               (combination % Not % _ % _ % _ %% (reflexive % _) %%
                 (transitive % _ % _ % _ %%
                   (transitive % _ % _ % _ %%
                     (combination % op : b % _ % _ % _ %% (reflexive % _) %%
                       (transitive % _ % _ % _ %%
                         (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
                         (combination % insert n % _ % _ % _ %% (reflexive % _) %%
                           (transitive % _ % _ % _ %%
                             (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
                             (combination % insert one % _ % _ % _ %%
                               (reflexive % _) %%
                               (eq_reflection % _ % _ %% set.simps_1)))))) %%
                     (eq_reflection % _ % _ %% (insert_iff % _ % _ % _))) %%
                   (combination % op | (b = n) % _ % _ % _ %% (reflexive % _) %%
                     (transitive % _ % _ % _ %%
                       (eq_reflection % _ % _ %% (insert_iff % _ % _ % _)) %%
                       (transitive % _ % _ % _ %%
                         (combination % op | (b = one) % _ % _ % _ %%
                           (reflexive % _) %%
                           (eq_reflection % _ % _ %% (empty_iff % _))) %%
                         (eq_reflection % _ % _ %% (simp_thms_31 % _))))))) %%
               (eq_reflection % _ % _ %% (de_Morgan_disj % _ % _)))) %%
           (transitive % _ % _ % _ %%
             (eq_reflection % _ % _ %% (distinct.simps_2 % _ % _)) %%
             (transitive % _ % _ % _ %%
               (combination % _ % _ % _ % _ %%
                 (combination % op & % _ % _ % _ %% (reflexive % _) %%
                   (combination % Not % _ % _ % _ %% (reflexive % _) %%
                     (transitive % _ % _ % _ %%
                       (transitive % _ % _ % _ %%
                         (combination % op : n % _ % _ % _ %% (reflexive % _) %%
                           (transitive % _ % _ % _ %%
                             (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
                             (combination % insert one % _ % _ % _ %%
                               (reflexive % _) %%
                               (eq_reflection % _ % _ %% set.simps_1)))) %%
                         (eq_reflection % _ % _ %% (insert_iff % _ % _ % _))) %%
                       (transitive % _ % _ % _ %%
                         (combination % op | (n = one) % _ % _ % _ %%
                           (reflexive % _) %%
                           (eq_reflection % _ % _ %% (empty_iff % _))) %%
                         (eq_reflection % _ % _ %% (simp_thms_31 % _)))))) %%
                 (transitive % _ % _ % _ %%
                   (eq_reflection % _ % _ %% (distinct.simps_2 % _ % _)) %%
                   (transitive % _ % _ % _ %%
                     (combination % _ % _ % _ % _ %%
                       (combination % op & % _ % _ % _ %% (reflexive % _) %%
                         (transitive % _ % _ % _ %%
                           (combination % Not % _ % _ % _ %% (reflexive % _) %%
                             (transitive % _ % _ % _ %%
                               (combination % op : one % _ % _ % _ %%
                                 (reflexive % _) %%
                                 (eq_reflection % _ % _ %% set.simps_1)) %%
                               (eq_reflection % _ % _ %% (empty_iff % _)))) %%
                           (eq_reflection % _ % _ %% simp_thms_8))) %%
                       (eq_reflection % _ % _ %% distinct.simps_1)) %%
                     (eq_reflection % _ % _ %% (simp_thms_25 % _))))) %%
               (eq_reflection % _ % _ %% (simp_thms_21 % _))))) %%
         (eq_reflection % _ % _ %% (conj_assoc % _ % _ % _))))) %%
   (eq_reflection % _ % _ %% (conj_assoc % _ % _ % _))) %%
 (combination % op & (one ~= n) % _ % _ % _ %% (reflexive % _) %%
   (eq_reflection % _ % _ %% (conj_assoc % _ % _ % _))))) %%
                                        vardistinct)))) %%
                                (eq_reflection % _ % _ %% simp_thms_8)))) %%
                          TrueI)))))) %%
              (reflexive % _))) %%
          (reflexive % _))) %%
      (Lam H: _.
        meta_eq_to_obj_eq % _ % _ %%
         (equal_elim % _ % _ %%
           (symmetric % _ % _ %%
             (combination % _ % _ % _ % _ %%
               (combination % op == % _ % _ % _ %% (reflexive % _) %%
                 (eq_reflection % _ % _ %%
                   (imp_cong % _ % _ % _ % _ %%
                     (meta_eq_to_obj_eq % _ % _ %%
                       (equal_elim % _ % _ %%
                         (symmetric % _ % _ %%
                           (combination % _ % _ % _ % _ %%
                             (combination % op == % _ % _ % _ %% (reflexive % _) %%
                               (combination % op < 0 % _ % _ % _ %% (reflexive % _) %%
                                 (combination % iheap h1 count % _ % _ % _ %%
                                   (reflexive % _) %%
                                   (combination % theloc % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (eq_reflection % _ % _ %%
                                       (rvarIupdTriv % _ % _ % _ % _)))))) %%
                             (reflexive % _))) %%
                         (reflexive % _))) %%
                     (Lam H: _.
                       meta_eq_to_obj_eq % _ % _ %%
                        (equal_elim % _ % _ %%
                          (symmetric % _ % _ %%
                            (combination % _ % _ % _ % _ %%
                              (combination % op == % _ % _ % _ %% (reflexive % _) %%
                                (combination % op & (v = IVal 0) % _ % _ % _ %%
                                  (reflexive % _) %%
                                  (combination % _ % _ % _ % _ %%
                                    (combination % op = % _ % _ % _ %%
                                      (reflexive % _) %%
                                      (combination % iheap hh count % _ % _ % _ %%
                                        (reflexive % _) %%
                                        (combination % theloc % _ % _ % _ %%
                                          (reflexive % _) %%
                                          (eq_reflection % _ % _ %%
 (rvarIupdTriv % _ % _ % _ % _))))) %%
                                    (reflexive % _)))) %%
                              (reflexive % _))) %%
                          (reflexive % _)))))) %%
               (reflexive % _))) %%
           (reflexive % _)))))))))) %%
                                  (reflexive % _))))) %%
                         (reflexive % _)))))))))) %%
    (reflexive % _))))))))))) %%
                      (reflexive % _)) %%
                    (eq_reflection % _ % _ %%
                      (split_conv %
                        (%h (hh, v, p).
                            EX p2. (EX p1 p2a h1.
                                       (EX a.
E\<lfloor>self\<rfloor> = Ref a &
h1 = h<a\<bullet>count:=(i - 1)> & p1 = \<langle>3 0 0 0\<rangle>) &
                                       (EX p2.
(EX pp. p2 =
        \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
        (i - 1 < E<one> -->
         hh = h1 & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
        (~ i - 1 < E<one> -->
         0 < h1<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
         v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
p2a = \<langle>4 + renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                                       p2 =
                                       \<langle>renv.clock p1 +
     renv.clock
      p2a callc p1 +
          callc p2a invkc p1 + invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                                   p = \<langle>4 +
     renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) %
                        _ %
                        _))) %%
                  (transitive % _ % _ % _ %%
                    (transitive % _ % _ % _ %%
                      (combination %
                        (%(hh, v, p).
                            EX p2. (EX p1 p2a h1a.
                                       (EX a.
E\<lfloor>self\<rfloor> = Ref a &
h1a = h1<a\<bullet>count:=(i - 1)> & p1 = \<langle>3 0 0 0\<rangle>) &
                                       (EX p2.
(EX pp. p2 =
        \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
        (i - 1 < E<one> -->
         hh = h1a & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
        (~ i - 1 < E<one> -->
         0 < h1a<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
         v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
p2a = \<langle>4 + renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                                       p2 =
                                       \<langle>renv.clock p1 +
     renv.clock
      p2a callc p1 +
          callc p2a invkc p1 + invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                                   p = \<langle>4 +
     renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) %
                        _ %
                        _ %
                        _ %%
                        (reflexive % _) %%
                        (reflexive % _)) %%
                      (eq_reflection % _ % _ %%
                        (split_conv %
                          (%hh (v, p).
                              EX p2. (EX p1 p2a h1a.
                                         (EX a.
  E\<lfloor>self\<rfloor> = Ref a &
  h1a = h1<a\<bullet>count:=(i - 1)> & p1 = \<langle>3 0 0 0\<rangle>) &
                                         (EX p2.
  (EX pp. p2 =
          \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
          (i - 1 < E<one> -->
           hh = h1a & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
          (~ i - 1 < E<one> -->
           0 < h1a<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
           v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
  p2a = \<langle>4 + renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                                         p2 =
                                         \<langle>renv.clock p1 +
       renv.clock
        p2a callc p1 +
            callc
             p2a invkc p1 + invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                                     p = \<langle>4 +
       renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) %
                          _ %
                          _))) %%
                    (transitive % _ % _ % _ %%
                      (transitive % _ % _ % _ %%
                        (combination %
                          (%(v, p).
                              EX p2. (EX p1 p2a h1a.
                                         (EX a.
  E\<lfloor>self\<rfloor> = Ref a &
  h1a = h1<a\<bullet>count:=(i - 1)> & p1 = \<langle>3 0 0 0\<rangle>) &
                                         (EX p2.
  (EX pp. p2 =
          \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
          (i - 1 < E<one> -->
           hh = h1a & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
          (~ i - 1 < E<one> -->
           0 < h1a<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
           v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
  p2a = \<langle>4 + renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                                         p2 =
                                         \<langle>renv.clock p1 +
       renv.clock
        p2a callc p1 +
            callc
             p2a invkc p1 + invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                                     p = \<langle>4 +
       renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) %
                          _ %
                          _ %
                          _ %%
                          (reflexive % _) %%
                          (reflexive % _)) %%
                        (eq_reflection % _ % _ %%
                          (split_conv %
                            (%v p. EX p2. (EX p1 p2a h1a.
   (EX a. E\<lfloor>self\<rfloor> = Ref a &
          h1a = h1<a\<bullet>count:=(i - 1)> & p1 = \<langle>3 0 0 0\<rangle>) &
   (EX p2. (EX pp. p2 =
                   \<langle>Suc (Suc (renv.clock
                                       pp)) callc pp invkc pp invkdpth pp\<rangle> &
                   (i - 1 < E<one> -->
                    hh = h1a & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                   (~ i - 1 < E<one> -->
                    0 < h1a<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
                    v = IVal 0 &
                    hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
           p2a = \<langle>4 + renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
   p2 =
   \<langle>renv.clock p1 +
            renv.clock
             p2a callc p1 +
                 callc
                  p2a invkc p1 +
                      invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                                          p = \<langle>4 +
            renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) %
                            _ %
                            _))) %%
                      (combination %
                        (%p. EX p2. (EX p1 p2a h1a.
                                        (EX a.
 E\<lfloor>self\<rfloor> = Ref a &
 h1a = h1<a\<bullet>count:=(i - 1)> & p1 = \<langle>3 0 0 0\<rangle>) &
                                        (EX p2.
 (EX pp. p2 =
         \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
         (i - 1 < E<one> -->
          hh = h1a & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
         (~ i - 1 < E<one> -->
          0 < h1a<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
          v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
 p2a = \<langle>4 + renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                                        p2 =
                                        \<langle>renv.clock p1 +
      renv.clock
       p2a callc p1 +
           callc p2a invkc p1 + invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                                    p = \<langle>4 +
      renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) %
                        _ %
                        _ %
                        _ %%
                        (reflexive % _) %%
                        (reflexive % _)))))))) %%
          (combination % op = p % _ % _ % _ %% (reflexive % _) %%
            (transitive % _ % _ % _ %%
              (transitive % _ % _ % _ %%
                (combination % _ % _ % _ % _ %%
                  (combination % op \<smile> % _ % _ % _ %% (reflexive % _) %%
                    (combination % _ % _ % _ % _ %%
                      (combination % renv.clock_field % _ % _ % _ %%
                        (reflexive % _) %%
                        axm.Nat.One_nat_def) %%
                      (reflexive % _))) %%
                  (renv_cup_def % _ % _)) %%
                (renv_cup_def % _ % _)) %%
              (combination % _ % _ % _ % _ %%
                (combination % renv.clock_field % _ % _ % _ %% (reflexive % _) %%
                  (transitive % _ % _ % _ %%
                    (transitive % _ % _ % _ %%
                      (combination % _ % _ % _ % _ %%
                        (combination % op + % _ % _ % _ %% (reflexive % _) %%
                          (eq_reflection % _ % _ %%
                            (select_convs_1 % _ % _ % _ % _ % _))) %%
                        (eq_reflection % _ % _ %%
                          (select_convs_1 % _ % _ % _ % _ % _))) %%
                      (eq_reflection % _ % _ %% (add_Suc % _ % _))) %%
                    (combination % Suc % _ % _ % _ %% (reflexive % _) %%
                      (eq_reflection % _ % _ %% (zero % _))))) %%
                (combination % _ % _ % _ % _ %%
                  (combination % callc_field % _ % _ % _ %% (reflexive % _) %%
                    (transitive % _ % _ % _ %%
                      (combination % _ % _ % _ % _ %%
                        (combination % op + % _ % _ % _ %% (reflexive % _) %%
                          (eq_reflection % _ % _ %%
                            (select_convs_2 % _ % _ % _ % _ % _))) %%
                        (eq_reflection % _ % _ %%
                          (select_convs_2 % _ % _ % _ % _ % _))) %%
                      (eq_reflection % _ % _ %% (zero % _)))) %%
                  (combination % _ % _ % _ % _ %%
                    (combination % invkc_field % _ % _ % _ %% (reflexive % _) %%
                      (transitive % _ % _ % _ %%
                        (combination % _ % _ % _ % _ %%
                          (combination % op + % _ % _ % _ %% (reflexive % _) %%
                            (eq_reflection % _ % _ %%
                              (select_convs_3 % _ % _ % _ % _ % _))) %%
                          (eq_reflection % _ % _ %%
                            (select_convs_3 % _ % _ % _ % _ % _))) %%
                        (eq_reflection % _ % _ %% (zero % _)))) %%
                    (combination % _ % _ % _ % _ %%
                      (combination % invkdpth_field % _ % _ % _ %% (reflexive % _) %%
                        (transitive % _ % _ % _ %%
                          (combination % _ % _ % _ % _ %%
                            (combination % max % _ % _ % _ %% (reflexive % _) %%
                              (eq_reflection % _ % _ %%
                                (select_convs_4 % _ % _ % _ % _ % _))) %%
                            (eq_reflection % _ % _ %%
                              (select_convs_4 % _ % _ % _ % _ % _))) %%
                          (eq_reflection % _ % _ %% (max_0L % _)))) %%
                      (reflexive % _)))))))))))))))))))))))))))) %%
  (eq_reflection % _ % _ %%
    (mem_Collect_eq % _ %
      (%(E, h, hh, v, p).
          EX p1 p2 h1 i.
             (EX a. E\<lfloor>self\<rfloor> = Ref a &
                    h1 = h &
                    i = h1<a\<bullet>count> & p1 = \<langle>2 0 0 0\<rangle>) &
             (EX p2a.
                 (EX p1 p2 h1a.
                     (EX a. E\<lfloor>self\<rfloor> = Ref a &
                            h1a = h1<a\<bullet>count:=(i - 1)> &
                            p1 = \<langle>3 0 0 0\<rangle>) &
                     (EX p2a.
                         (EX pp. p2a =
                                 \<langle>Suc
(Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                 (i - 1 < E<one> -->
                                  hh = h1a &
                                  v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                 (~ i - 1 < E<one> -->
                                  0 < h1a<(theloc
 E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                  v = IVal 0 &
                                  hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> =
                                  0)) &
                         p2 =
                         \<langle>4 + renv.clock
                                       p2a callc
 p2a invkc p2a invkdpth p2a\<rangle>) &
                     p2a =
                     \<langle>renv.clock p1 +
                              renv.clock
                               p2 callc p1 +
                                  callc
                                   p2 invkc p1 +
                                      invkc
                                       p2 max (invkdpth p1) (invkdpth p2)\<rangle>) &
                 p2 =
                 \<langle>4 + renv.clock
                               p2a callc p2a invkc p2a invkdpth p2a\<rangle>) &
             p = \<langle>Suc (renv.clock p1 +
                               renv.clock
                                p2) callc p1 +
                                    callc
                                     p2 invkc p1 +
                                        invkc
                                         p2 max (invkdpth p1)
  (invkdpth p2)\<rangle>)))) %%
(transitive % _ % _ % _ %%
  (eq_reflection % _ % _ %%
    (split_conv %
      (%E (h, hh, v, p).
          EX p1 p2 h1 i.
             (EX a. E\<lfloor>self\<rfloor> = Ref a &
                    h1 = h &
                    i = h1<a\<bullet>count> & p1 = \<langle>2 0 0 0\<rangle>) &
             (EX p2a.
                 (EX p1 p2 h1a.
                     (EX a. E\<lfloor>self\<rfloor> = Ref a &
                            h1a = h1<a\<bullet>count:=(i - 1)> &
                            p1 = \<langle>3 0 0 0\<rangle>) &
                     (EX p2a.
                         (EX pp. p2a =
                                 \<langle>Suc
(Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                 (i - 1 < E<one> -->
                                  hh = h1a &
                                  v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                 (~ i - 1 < E<one> -->
                                  0 < h1a<(theloc
 E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                  v = IVal 0 &
                                  hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> =
                                  0)) &
                         p2 =
                         \<langle>4 + renv.clock
                                       p2a callc
 p2a invkc p2a invkdpth p2a\<rangle>) &
                     p2a =
                     \<langle>renv.clock p1 +
                              renv.clock
                               p2 callc p1 +
                                  callc
                                   p2 invkc p1 +
                                      invkc
                                       p2 max (invkdpth p1) (invkdpth p2)\<rangle>) &
                 p2 =
                 \<langle>4 + renv.clock
                               p2a callc p2a invkc p2a invkdpth p2a\<rangle>) &
             p = \<langle>Suc (renv.clock p1 +
                               renv.clock
                                p2) callc p1 +
                                    callc
                                     p2 invkc p1 +
                                        invkc
                                         p2 max (invkdpth p1)
  (invkdpth p2)\<rangle>) %
      _ %
      _)) %%
  (transitive % _ % _ % _ %%
    (transitive % _ % _ % _ %%
      (combination % _ % _ % _ % _ %%
        (combination % split % _ % _ % _ %% (reflexive % _) %%
          (abstract_rule % _ % _ %%
            (Lam h.
              combination % split % _ % _ % _ %% (reflexive % _) %%
               (abstract_rule % _ % _ %%
                 (Lam hh.
                   combination % split % _ % _ % _ %% (reflexive % _) %%
                    (abstract_rule % _ % _ %%
                      (Lam v.
                        abstract_rule % _ % _ %%
                         (Lam p.
                           combination % Ex % _ % _ % _ %% (reflexive % _) %%
                            (abstract_rule % _ % _ %%
                              (Lam p1.
                                combination % Ex % _ % _ % _ %% (reflexive % _) %%
                                 (abstract_rule % _ % _ %%
                                   (Lam p2.
                                     combination % Ex % _ % _ % _ %%
                                      (reflexive % _) %%
                                      (abstract_rule % _ % _ %%
                                        (Lam h1.
                                          combination % Ex % _ % _ % _ %%
(reflexive % _) %%
(abstract_rule % _ % _ %%
  (Lam i.
    combination % _ % _ % _ % _ %%
     (combination % op & % _ % _ % _ %% (reflexive % _) %%
       (combination % Ex % _ % _ % _ %% (reflexive % _) %%
         (abstract_rule % _ % _ %%
           (Lam a.
             combination % _ % _ % _ % _ %%
              (combination % op & % _ % _ % _ %% (reflexive % _) %%
                (combination % _ % _ % _ % _ %%
                  (combination % op = % _ % _ % _ %% (reflexive % _) %%
                    (eq_reflection % _ % _ %% (rvarIupdTriv % _ % _ % _ % _))) %%
                  (reflexive % _))) %%
              (reflexive % _))))) %%
     (combination % _ % _ % _ % _ %%
       (combination % op & % _ % _ % _ %% (reflexive % _) %%
         (combination % Ex % _ % _ % _ %% (reflexive % _) %%
           (abstract_rule % _ % _ %%
             (Lam p2.
               combination % _ % _ % _ % _ %%
                (combination % op & % _ % _ % _ %% (reflexive % _) %%
                  (combination % Ex % _ % _ % _ %% (reflexive % _) %%
                    (abstract_rule % _ % _ %%
                      (Lam p1.
                        combination % Ex % _ % _ % _ %% (reflexive % _) %%
                         (abstract_rule % _ % _ %%
                           (Lam p2.
                             combination % Ex % _ % _ % _ %% (reflexive % _) %%
                              (abstract_rule % _ % _ %%
                                (Lam h1.
                                  combination % _ % _ % _ % _ %%
                                   (combination % op & % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (combination % Ex % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (abstract_rule % _ % _ %%
                                         (Lam a.
combination % _ % _ % _ % _ %%
 (combination % op & % _ % _ % _ %% (reflexive % _) %%
   (combination % _ % _ % _ % _ %%
     (combination % op = % _ % _ % _ %% (reflexive % _) %%
       (eq_reflection % _ % _ %% (rvarIupdTriv % _ % _ % _ % _))) %%
     (reflexive % _))) %%
 (reflexive % _))))) %%
                                   (combination % _ % _ % _ % _ %%
                                     (combination % op & % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (combination % Ex % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (abstract_rule % _ % _ %%
(Lam p2.
  combination % _ % _ % _ % _ %%
   (combination % op & % _ % _ % _ %% (reflexive % _) %%
     (combination % Ex % _ % _ % _ %% (reflexive % _) %%
       (abstract_rule % _ % _ %%
         (Lam pp.
           combination %
            op & (p2 =
                  \<langle>Suc (Suc (renv.clock
                                      pp)) callc pp invkc pp invkdpth pp\<rangle>) %
            _ %
            _ %
            _ %%
            (reflexive % _) %%
            (combination % _ % _ % _ % _ %%
              (combination % op & % _ % _ % _ %% (reflexive % _) %%
                (eq_reflection % _ % _ %%
                  (imp_cong % _ % _ % _ % _ %%
                    (meta_eq_to_obj_eq % _ % _ %%
                      (equal_elim % _ % _ %%
                        (symmetric % _ % _ %%
                          (combination % _ % _ % _ % _ %%
                            (combination % op == % _ % _ % _ %% (reflexive % _) %%
                              (combination % op < (i - 1) % _ % _ % _ %%
                                (reflexive % _) %%
                                (eq_reflection % _ % _ %%
                                  (ivarUpdSame % _ % _ % _)))) %%
                            (reflexive % _))) %%
                        (reflexive % _))) %%
                    (Lam H: _. meta_eq_to_obj_eq % _ % _ %% (reflexive % _))))) %%
              (eq_reflection % _ % _ %%
                (imp_cong % _ % _ % _ % _ %%
                  (meta_eq_to_obj_eq % _ % _ %%
                    (equal_elim % _ % _ %%
                      (symmetric % _ % _ %%
                        (combination % _ % _ % _ % _ %%
                          (combination % op == % _ % _ % _ %% (reflexive % _) %%
                            (combination % Not % _ % _ % _ %% (reflexive % _) %%
                              (combination % op < (i - 1) % _ % _ % _ %%
                                (reflexive % _) %%
                                (eq_reflection % _ % _ %%
                                  (ivarUpdSame % _ % _ % _))))) %%
                          (reflexive % _))) %%
                      (reflexive % _))) %%
                  (Lam H: _.
                    meta_eq_to_obj_eq % _ % _ %%
                     (equal_elim % _ % _ %%
                       (symmetric % _ % _ %%
                         (combination % _ % _ % _ % _ %%
                           (combination % op == % _ % _ % _ %% (reflexive % _) %%
                             (eq_reflection % _ % _ %%
                               (imp_cong % _ % _ % _ % _ %%
                                 (meta_eq_to_obj_eq % _ % _ %%
                                   (equal_elim % _ % _ %%
                                     (symmetric % _ % _ %%
                                       (combination % _ % _ % _ % _ %%
                                         (combination % op == % _ % _ % _ %%
(reflexive % _) %%
(combination % op < 0 % _ % _ % _ %% (reflexive % _) %%
  (combination % iheap h1 count % _ % _ % _ %% (reflexive % _) %%
    (combination % theloc % _ % _ % _ %% (reflexive % _) %%
      (eq_reflection % _ % _ %% (rvarIupdTriv % _ % _ % _ % _)))))) %%
                                         (reflexive % _))) %%
                                     (reflexive % _))) %%
                                 (Lam H: _.
                                   meta_eq_to_obj_eq % _ % _ %%
                                    (equal_elim % _ % _ %%
                                      (symmetric % _ % _ %%
                                        (combination % _ % _ % _ % _ %%
                                          (combination % op == % _ % _ % _ %%
 (reflexive % _) %%
 (combination % op & (v = IVal 0) % _ % _ % _ %% (reflexive % _) %%
   (combination % _ % _ % _ % _ %%
     (combination % op = % _ % _ % _ %% (reflexive % _) %%
       (combination % iheap hh count % _ % _ % _ %% (reflexive % _) %%
         (combination % theloc % _ % _ % _ %% (reflexive % _) %%
           (eq_reflection % _ % _ %% (rvarIupdTriv % _ % _ % _ % _))))) %%
     (reflexive % _)))) %%
                                          (reflexive % _))) %%
                                      (reflexive % _)))))) %%
                           (reflexive % _))) %%
                       (reflexive % _)))))))))) %%
   (reflexive % _))))) %%
                                     (reflexive % _)))))))))) %%
                (reflexive % _))))) %%
       (reflexive % _)))))))))))))))))) %%
        (reflexive % _)) %%
      (eq_reflection % _ % _ %%
        (split_conv %
          (%h (hh, v, p).
              EX p1 p2 h1 ia.
                 (EX a. E\<lfloor>self\<rfloor> = Ref a &
                        h1 = h &
                        ia = h1<a\<bullet>count> & p1 = \<langle>2 0 0 0\<rangle>) &
                 (EX p2a.
                     (EX p1 p2 h1a.
                         (EX a. E\<lfloor>self\<rfloor> = Ref a &
                                h1a = h1<a\<bullet>count:=(ia - 1)> &
                                p1 = \<langle>3 0 0 0\<rangle>) &
                         (EX p2a.
                             (EX pp. p2a =
                                     \<langle>Suc
    (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                     (ia - 1 < i -->
                                      hh = h1a &
                                      v = IVal 0 &
                                      pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                     (~ ia - 1 < i -->
                                      0 < h1a<(theloc
     E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                      v = IVal 0 &
                                      hh<(theloc
E\<lfloor>self\<rfloor>)\<bullet>count> =
                                      0)) &
                             p2 =
                             \<langle>4 + renv.clock
p2a callc p2a invkc p2a invkdpth p2a\<rangle>) &
                         p2a =
                         \<langle>renv.clock p1 +
                                  renv.clock
                                   p2 callc p1 +
                                      callc
                                       p2 invkc p1 +
                                          invkc
p2 max (invkdpth p1) (invkdpth p2)\<rangle>) &
                     p2 =
                     \<langle>4 + renv.clock
                                   p2a callc p2a invkc p2a invkdpth p2a\<rangle>) &
                 p = \<langle>Suc (renv.clock p1 +
                                   renv.clock
                                    p2) callc p1 +
                                        callc
                                         p2 invkc p1 +
 invkc p2 max (invkdpth p1) (invkdpth p2)\<rangle>) %
          _ %
          _))) %%
    (transitive % _ % _ % _ %%
      (transitive % _ % _ % _ %%
        (combination %
          (%(hh, v, p).
              EX p1 p2 h1a ia.
                 (EX a. E\<lfloor>self\<rfloor> = Ref a &
                        h1a = h1 &
                        ia = h1a<a\<bullet>count> & p1 = \<langle>2 0 0 0\<rangle>) &
                 (EX p2a.
                     (EX p1 p2 h1.
                         (EX a. E\<lfloor>self\<rfloor> = Ref a &
                                h1 = h1a<a\<bullet>count:=(ia - 1)> &
                                p1 = \<langle>3 0 0 0\<rangle>) &
                         (EX p2a.
                             (EX pp. p2a =
                                     \<langle>Suc
    (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                     (ia - 1 < i -->
                                      hh = h1 &
                                      v = IVal 0 &
                                      pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                     (~ ia - 1 < i -->
                                      0 < h1<(theloc
    E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                      v = IVal 0 &
                                      hh<(theloc
E\<lfloor>self\<rfloor>)\<bullet>count> =
                                      0)) &
                             p2 =
                             \<langle>4 + renv.clock
p2a callc p2a invkc p2a invkdpth p2a\<rangle>) &
                         p2a =
                         \<langle>renv.clock p1 +
                                  renv.clock
                                   p2 callc p1 +
                                      callc
                                       p2 invkc p1 +
                                          invkc
p2 max (invkdpth p1) (invkdpth p2)\<rangle>) &
                     p2 =
                     \<langle>4 + renv.clock
                                   p2a callc p2a invkc p2a invkdpth p2a\<rangle>) &
                 p = \<langle>Suc (renv.clock p1 +
                                   renv.clock
                                    p2) callc p1 +
                                        callc
                                         p2 invkc p1 +
 invkc p2 max (invkdpth p1) (invkdpth p2)\<rangle>) %
          _ %
          _ %
          _ %%
          (reflexive % _) %%
          (reflexive % _)) %%
        (eq_reflection % _ % _ %%
          (split_conv %
            (%hh (v, p).
                EX p1 p2 h1a ia.
                   (EX a. E\<lfloor>self\<rfloor> = Ref a &
                          h1a = h1 &
                          ia = h1a<a\<bullet>count> &
                          p1 = \<langle>2 0 0 0\<rangle>) &
                   (EX p2a.
                       (EX p1 p2 h1.
                           (EX a. E\<lfloor>self\<rfloor> = Ref a &
                                  h1 = h1a<a\<bullet>count:=(ia - 1)> &
                                  p1 = \<langle>3 0 0 0\<rangle>) &
                           (EX p2a.
                               (EX pp. p2a =
                                       \<langle>Suc
      (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                       (ia - 1 < i -->
                                        hh = h1 &
                                        v = IVal 0 &
                                        pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                       (~ ia - 1 < i -->
                                        0 < h1<(theloc
      E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                        v = IVal 0 &
                                        hh<(theloc
  E\<lfloor>self\<rfloor>)\<bullet>count> =
                                        0)) &
                               p2 =
                               \<langle>4 + renv.clock
  p2a callc p2a invkc p2a invkdpth p2a\<rangle>) &
                           p2a =
                           \<langle>renv.clock p1 +
                                    renv.clock
                                     p2 callc p1 +
                                        callc
                                         p2 invkc p1 +
 invkc p2 max (invkdpth p1) (invkdpth p2)\<rangle>) &
                       p2 =
                       \<langle>4 + renv.clock
                                     p2a callc p2a invkc p2a invkdpth p2a\<rangle>) &
                   p = \<langle>Suc (renv.clock p1 +
                                     renv.clock
                                      p2) callc p1 +
                                          callc
p2 invkc p1 + invkc p2 max (invkdpth p1) (invkdpth p2)\<rangle>) %
            _ %
            _))) %%
      (transitive % _ % _ % _ %%
        (transitive % _ % _ % _ %%
          (combination %
            (%(v, p).
                EX p1 p2 h1a ia.
                   (EX a. E\<lfloor>self\<rfloor> = Ref a &
                          h1a = h1 &
                          ia = h1a<a\<bullet>count> &
                          p1 = \<langle>2 0 0 0\<rangle>) &
                   (EX p2a.
                       (EX p1 p2 h1.
                           (EX a. E\<lfloor>self\<rfloor> = Ref a &
                                  h1 = h1a<a\<bullet>count:=(ia - 1)> &
                                  p1 = \<langle>3 0 0 0\<rangle>) &
                           (EX p2a.
                               (EX pp. p2a =
                                       \<langle>Suc
      (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                       (ia - 1 < i -->
                                        hh = h1 &
                                        v = IVal 0 &
                                        pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                       (~ ia - 1 < i -->
                                        0 < h1<(theloc
      E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                        v = IVal 0 &
                                        hh<(theloc
  E\<lfloor>self\<rfloor>)\<bullet>count> =
                                        0)) &
                               p2 =
                               \<langle>4 + renv.clock
  p2a callc p2a invkc p2a invkdpth p2a\<rangle>) &
                           p2a =
                           \<langle>renv.clock p1 +
                                    renv.clock
                                     p2 callc p1 +
                                        callc
                                         p2 invkc p1 +
 invkc p2 max (invkdpth p1) (invkdpth p2)\<rangle>) &
                       p2 =
                       \<langle>4 + renv.clock
                                     p2a callc p2a invkc p2a invkdpth p2a\<rangle>) &
                   p = \<langle>Suc (renv.clock p1 +
                                     renv.clock
                                      p2) callc p1 +
                                          callc
p2 invkc p1 + invkc p2 max (invkdpth p1) (invkdpth p2)\<rangle>) %
            _ %
            _ %
            _ %%
            (reflexive % _) %%
            (reflexive % _)) %%
          (eq_reflection % _ % _ %%
            (split_conv %
              (%v p. EX p1 p2 h1a ia.
                        (EX a. E\<lfloor>self\<rfloor> = Ref a &
                               h1a = h1 &
                               ia = h1a<a\<bullet>count> &
                               p1 = \<langle>2 0 0 0\<rangle>) &
                        (EX p2a.
                            (EX p1 p2 h1.
                                (EX a. E\<lfloor>self\<rfloor> = Ref a &
                                       h1 = h1a<a\<bullet>count:=(ia - 1)> &
                                       p1 = \<langle>3 0 0 0\<rangle>) &
                                (EX p2a.
                                    (EX pp. p2a =
 \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
 (ia - 1 < i --> hh = h1 & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
 (~ ia - 1 < i -->
  0 < h1<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
  v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
                                    p2 =
                                    \<langle>4 +
  renv.clock p2a callc p2a invkc p2a invkdpth p2a\<rangle>) &
                                p2a =
                                \<langle>renv.clock p1 +
                                         renv.clock
                                          p2 callc p1 +
  callc p2 invkc p1 + invkc p2 max (invkdpth p1) (invkdpth p2)\<rangle>) &
                            p2 =
                            \<langle>4 + renv.clock
                                          p2a callc
    p2a invkc p2a invkdpth p2a\<rangle>) &
                        p = \<langle>Suc (renv.clock p1 +
                                          renv.clock
p2) callc p1 +
    callc p2 invkc p1 + invkc p2 max (invkdpth p1) (invkdpth p2)\<rangle>) %
              _ %
              _))) %%
        (combination %
          (%p. EX p1 p2 h1a ia.
                  (EX a. E\<lfloor>self\<rfloor> = Ref a &
                         h1a = h1 &
                         ia = h1a<a\<bullet>count> & p1 = \<langle>2 0 0 0\<rangle>) &
                  (EX p2a.
                      (EX p1 p2 h1.
                          (EX a. E\<lfloor>self\<rfloor> = Ref a &
                                 h1 = h1a<a\<bullet>count:=(ia - 1)> &
                                 p1 = \<langle>3 0 0 0\<rangle>) &
                          (EX p2a.
                              (EX pp. p2a =
                                      \<langle>Suc
     (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                      (ia - 1 < i -->
                                       hh = h1 &
                                       v = IVal 0 &
                                       pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                      (~ ia - 1 < i -->
                                       0 < h1<(theloc
     E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                       v = IVal 0 &
                                       hh<(theloc
 E\<lfloor>self\<rfloor>)\<bullet>count> =
                                       0)) &
                              p2 =
                              \<langle>4 + renv.clock
 p2a callc p2a invkc p2a invkdpth p2a\<rangle>) &
                          p2a =
                          \<langle>renv.clock p1 +
                                   renv.clock
                                    p2 callc p1 +
                                       callc
                                        p2 invkc p1 +
invkc p2 max (invkdpth p1) (invkdpth p2)\<rangle>) &
                      p2 =
                      \<langle>4 + renv.clock
                                    p2a callc p2a invkc p2a invkdpth p2a\<rangle>) &
                  p = \<langle>Suc (renv.clock p1 +
                                    renv.clock
                                     p2) callc p1 +
                                         callc
                                          p2 invkc p1 +
  invkc p2 max (invkdpth p1) (invkdpth p2)\<rangle>) %
          _ %
          _ %
          _ %%
          (reflexive % _) %%
          (reflexive % _)))))))) %%
                                       (combination % op = p % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (transitive % _ % _ % _ %%
(transitive % _ % _ % _ %%
  (combination % _ % _ % _ % _ %%
    (combination % op \<smile> % _ % _ % _ %% (reflexive % _) %%
      (combination % _ % _ % _ % _ %%
        (combination % renv.clock_field % _ % _ % _ %% (reflexive % _) %%
          axm.Nat.One_nat_def) %%
        (reflexive % _))) %%
    (renv_cup_def % _ % _)) %%
  (renv_cup_def % _ % _)) %%
(combination % _ % _ % _ % _ %%
  (combination % renv.clock_field % _ % _ % _ %% (reflexive % _) %%
    (transitive % _ % _ % _ %%
      (transitive % _ % _ % _ %%
        (combination % _ % _ % _ % _ %%
          (combination % op + % _ % _ % _ %% (reflexive % _) %%
            (eq_reflection % _ % _ %% (select_convs_1 % _ % _ % _ % _ % _))) %%
          (eq_reflection % _ % _ %% (select_convs_1 % _ % _ % _ % _ % _))) %%
        (eq_reflection % _ % _ %% (add_Suc % _ % _))) %%
      (combination % Suc % _ % _ % _ %% (reflexive % _) %%
        (eq_reflection % _ % _ %% (zero % _))))) %%
  (combination % _ % _ % _ % _ %%
    (combination % callc_field % _ % _ % _ %% (reflexive % _) %%
      (transitive % _ % _ % _ %%
        (combination % _ % _ % _ % _ %%
          (combination % op + % _ % _ % _ %% (reflexive % _) %%
            (eq_reflection % _ % _ %% (select_convs_2 % _ % _ % _ % _ % _))) %%
          (eq_reflection % _ % _ %% (select_convs_2 % _ % _ % _ % _ % _))) %%
        (eq_reflection % _ % _ %% (zero % _)))) %%
    (combination % _ % _ % _ % _ %%
      (combination % invkc_field % _ % _ % _ %% (reflexive % _) %%
        (transitive % _ % _ % _ %%
          (combination % _ % _ % _ % _ %%
            (combination % op + % _ % _ % _ %% (reflexive % _) %%
              (eq_reflection % _ % _ %% (select_convs_3 % _ % _ % _ % _ % _))) %%
            (eq_reflection % _ % _ %% (select_convs_3 % _ % _ % _ % _ % _))) %%
          (eq_reflection % _ % _ %% (zero % _)))) %%
      (combination % _ % _ % _ % _ %%
        (combination % invkdpth_field % _ % _ % _ %% (reflexive % _) %%
          (transitive % _ % _ % _ %%
            (combination % _ % _ % _ % _ %%
              (combination % max % _ % _ % _ %% (reflexive % _) %%
                (eq_reflection % _ % _ %% (select_convs_4 % _ % _ % _ % _ % _))) %%
              (eq_reflection % _ % _ %% (select_convs_4 % _ % _ % _ % _ % _))) %%
            (eq_reflection % _ % _ %% (max_0L % _)))) %%
        (reflexive % _))))))))) %%
                                   (eq_reflection % _ % _ %%
                                     (conj_assoc % _ % _ % _))) %%
                                 (combination % op & (h1 = h) % _ % _ % _ %%
                                   (reflexive % _) %%
                                   (eq_reflection % _ % _ %%
                                     (conj_assoc % _ % _ % _)))))) %%
                          (eq_reflection % _ % _ %% (ex_simps_2 % _ % _))) %%
                        (combination % op & (h1 = h) % _ % _ % _ %% (reflexive % _) %%
                          (transitive % _ % _ % _ %%
                            (transitive % _ % _ % _ %%
                              (combination % Ex % _ % _ % _ %% (reflexive % _) %%
                                (abstract_rule % _ % _ %% (Lam i. reflexive % _))) %%
                              (eq_reflection % _ % _ %%
                                (simp_thms_39 % _ %
                                  (%i. p1 = \<langle>Suc 0 0 0 0\<rangle> &
                                       (EX p1 p2a h1a ia.
(EX a. E\<lfloor>self\<rfloor> = Ref a &
       h1a = h1 & ia = h1a<a\<bullet>count> & p1 = \<langle>2 0 0 0\<rangle>) &
(EX p2. (EX p1 p2a h1.
            (EX a. E\<lfloor>self\<rfloor> = Ref a &
                   h1 = h1a<a\<bullet>count:=(ia - 1)> &
                   p1 = \<langle>3 0 0 0\<rangle>) &
            (EX p2. (EX pp. p2 =
                            \<langle>Suc (Suc
(renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                            (ia - 1 < i -->
                             hh = h1 &
                             v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                            (~ ia - 1 < i -->
                             0 < h1<(theloc
                                      E\<lfloor>self\<rfloor>)\<bullet>count> -->
                             v = IVal 0 &
                             hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> =
                             0)) &
                    p2a =
                    \<langle>4 + renv.clock
                                  p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
            p2 =
            \<langle>renv.clock p1 +
                     renv.clock
                      p2a callc p1 +
                          callc
                           p2a invkc p1 +
                               invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
        p2a = \<langle>4 + renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
p2 =
\<langle>Suc (renv.clock p1 +
              renv.clock
               p2a) callc p1 +
                    callc
                     p2a invkc p1 +
                         invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                                       p = \<langle>Suc
          (renv.clock p1 +
           renv.clock
            p2) callc p1 +
                callc
                 p2 invkc p1 +
                    invkc p2 max (invkdpth p1) (invkdpth p2)\<rangle>)))) %%
                            (combination % op & (p1 = \<langle>Suc 0 0 0 0\<rangle>) %
                              _ %
                              _ %
                              _ %%
                              (reflexive % _) %%
                              (combination % _ % _ % _ % _ %%
                                (combination % op & % _ % _ % _ %% (reflexive % _) %%
                                  (combination % Ex % _ % _ % _ %% (reflexive % _) %%
                                    (abstract_rule % _ % _ %%
                                      (Lam p1.
                                        combination % Ex % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (abstract_rule % _ % _ %%
(Lam p2.
  combination % Ex % _ % _ % _ %% (reflexive % _) %%
   (abstract_rule % _ % _ %%
     (Lam h1a.
       combination % Ex % _ % _ % _ %% (reflexive % _) %%
        (abstract_rule % _ % _ %%
          (Lam i.
            combination %
             op & (EX a. E\<lfloor>self\<rfloor> = Ref a &
                         h1a = h1 &
                         i = h1a<a\<bullet>count> & p1 = \<langle>2 0 0 0\<rangle>) %
             _ %
             _ %
             _ %%
             (reflexive % _) %%
             (combination % _ % _ % _ % _ %%
               (combination % op & % _ % _ % _ %% (reflexive % _) %%
                 (combination % Ex % _ % _ % _ %% (reflexive % _) %%
                   (abstract_rule % _ % _ %%
                     (Lam p2.
                       combination % _ % _ % _ % _ %%
                        (combination % op & % _ % _ % _ %% (reflexive % _) %%
                          (combination % Ex % _ % _ % _ %% (reflexive % _) %%
                            (abstract_rule % _ % _ %%
                              (Lam p1.
                                combination % Ex % _ % _ % _ %% (reflexive % _) %%
                                 (abstract_rule % _ % _ %%
                                   (Lam p2.
                                     combination % Ex % _ % _ % _ %%
                                      (reflexive % _) %%
                                      (abstract_rule % _ % _ %%
                                        (Lam h1.
                                          combination %
op & (EX a. E\<lfloor>self\<rfloor> = Ref a &
            h1 = h1a<a\<bullet>count:=(i - 1)> & p1 = \<langle>3 0 0 0\<rangle>) %
_ %
_ %
_ %%
(reflexive % _) %%
(combination % _ % _ % _ % _ %%
  (combination % op & % _ % _ % _ %% (reflexive % _) %%
    (combination % Ex % _ % _ % _ %% (reflexive % _) %%
      (abstract_rule % _ % _ %%
        (Lam p2.
          combination % _ % _ % _ % _ %%
           (combination % op & % _ % _ % _ %% (reflexive % _) %%
             (combination % Ex % _ % _ % _ %% (reflexive % _) %%
               (abstract_rule % _ % _ %%
                 (Lam pp.
                   combination %
                    op & (p2 =
                          \<langle>Suc (Suc (renv.clock
   pp)) callc pp invkc pp invkdpth pp\<rangle>) %
                    _ %
                    _ %
                    _ %%
                    (reflexive % _) %%
                    (combination % _ % _ % _ % _ %%
                      (combination % op & % _ % _ % _ %% (reflexive % _) %%
                        (eq_reflection % _ % _ %%
                          (imp_cong % _ % _ % _ % _ %%
                            (meta_eq_to_obj_eq % _ % _ %%
                              (equal_elim % _ % _ %%
                                (symmetric % _ % _ %%
                                  (combination % _ % _ % _ % _ %%
                                    (combination % op == % _ % _ % _ %%
                                      (reflexive % _) %%
                                      (equal_elim % _ % _ %%
                                        (eq_cong2 % _ % _ % _ %%
                                          (equal_elim % _ % _ %%
 (symmetric % _ % _ %%
   (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
     (combination % _ % _ % _ % _ %%
       (combination % op = % _ % _ % _ %% (reflexive % _) %%
         (combination % _ % _ % _ % _ %%
           (combination % op < % _ % _ % _ %% (reflexive % _) %%
             (eq_reflection % _ % _ %%
               (equal_elim % _ % _ %%
                 (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                   (combination % _ % _ % _ % _ %%
                     (combination % op = % _ % _ % _ %% (reflexive % _) %%
                       (combination % op + i % _ % _ % _ %% (reflexive % _) %%
                         (eq_reflection % _ % _ %%
                           (HOL.sym % _ % _ %% int_numeral_0_eq_0)))) %%
                     (reflexive % _))) %%
                 (zadd_0_right % _)))) %%
           (transitive % _ % _ % _ %%
             (combination % _ % _ % _ % _ %%
               (combination % op + % _ % _ % _ %% (reflexive % _) %%
                 (eq_reflection % _ % _ %%
                   (equal_elim % _ % _ %%
                     (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                       (combination % _ % _ % _ % _ %%
                         (combination % op = % _ % _ % _ %% (reflexive % _) %%
                           (combination % op * 2 % _ % _ % _ %% (reflexive % _) %%
                             (eq_reflection % _ % _ %%
                               (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                         (reflexive % _))) %%
                     (zmult_1_right % _)))) %%
               (reflexive % _)) %%
             (eq_reflection % _ % _ %%
               (equal_elim % _ % _ %%
                 (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                   (combination % _ % _ % _ % _ %%
                     (combination % op = % _ % _ % _ %% (reflexive % _) %%
                       (combination % op + 2 % _ % _ % _ %% (reflexive % _) %%
                         (eq_reflection % _ % _ %%
                           (HOL.sym % _ % _ %% int_numeral_0_eq_0)))) %%
                     (reflexive % _))) %%
                 (zadd_0_right % _)))))) %%
       (reflexive % _)))) %%
 (HOL.refl % _))) %%
                                        (eq_reflection % _ % _ %%
                                          (HOL.trans % _ % _ % _ %%
 (equal_elim % _ % _ %%
   (symmetric % _ % _ %%
     (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
       (transitive % _ % _ % _ %%
         (combination % _ % _ % _ % _ %%
           (combination % op = % _ % _ % _ %% (reflexive % _) %%
             (combination % _ % _ % _ % _ %%
               (combination % op < % _ % _ % _ %% (reflexive % _) %%
                 (transitive % _ % _ % _ %%
                   (transitive % _ % _ % _ %%
                     (combination % op - i % _ % _ % _ %% (reflexive % _) %%
                       (eq_reflection % _ % _ %%
                         (HOL.sym % _ % _ %% int_numeral_1_eq_1))) %%
                     (zdiff_def % _ % _)) %%
                   (combination % op + i % _ % _ % _ %% (reflexive % _) %%
                     (transitive % _ % _ % _ %%
                       (eq_reflection % _ % _ %%
                         (HOL.sym % _ % _ %% (number_of_minus % _))) %%
                       (combination % number_of % _ % _ % _ %% (reflexive % _) %%
                         (transitive % _ % _ % _ %%
                           (eq_reflection % _ % _ %% (bin_minus_1 % _)) %%
                           (transitive % _ % _ % _ %%
                             (combination % bin_pred % _ % _ % _ %% (reflexive % _) %%
                               (transitive % _ % _ % _ %%
                                 (combination % _ % _ % _ % _ %%
                                   (combination % NCons % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (eq_reflection % _ % _ %% bin_minus_Pls)) %%
                                   (reflexive % _)) %%
                                 (eq_reflection % _ % _ %% NCons_simps_1))) %%
                             (eq_reflection % _ % _ %% bin_pred_Pls)))))))) %%
               (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
           (combination % _ % _ % _ % _ %%
             (combination % op < % _ % _ % _ %% (reflexive % _) %%
               (transitive % _ % _ % _ %%
                 (combination % _ % _ % _ % _ %%
                   (combination % op + % _ % _ % _ %% (reflexive % _) %%
                     (eq_reflection % _ % _ %%
                       (equal_elim % _ % _ %%
                         (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                           (combination % _ % _ % _ % _ %%
                             (combination % op = % _ % _ % _ %% (reflexive % _) %%
                               (combination % op * -1 % _ % _ % _ %%
                                 (reflexive % _) %%
                                 (eq_reflection % _ % _ %%
                                   (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                             (reflexive % _))) %%
                         (zmult_1_right % _)))) %%
                   (reflexive % _)) %%
                 (eq_reflection % _ % _ %% (zadd_ac_2 % _ % _)))) %%
             (transitive % _ % _ % _ %%
               (transitive % _ % _ % _ %%
                 (combination % _ % _ % _ % _ %%
                   (combination % op + % _ % _ % _ %% (reflexive % _) %%
                     (eq_reflection % _ % _ %%
                       (equal_elim % _ % _ %%
                         (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                           (combination % _ % _ % _ % _ %%
                             (combination % op = % _ % _ % _ %% (reflexive % _) %%
                               (combination % op * Numeral1 % _ % _ % _ %%
                                 (reflexive % _) %%
                                 (eq_reflection % _ % _ %%
                                   (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                             (reflexive % _))) %%
                         (zmult_1_right % _)))) %%
                   (reflexive % _)) %%
                 (eq_reflection % _ % _ %% (zadd_ac_2 % _ % _))) %%
               (eq_reflection % _ % _ %%
                 (equal_elim % _ % _ %%
                   (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                     (combination % _ % _ % _ % _ %%
                       (combination % op = % _ % _ % _ %% (reflexive % _) %%
                         (combination % _ % _ % _ % _ %%
                           (combination % op + % _ % _ % _ %% (reflexive % _) %%
                             (eq_reflection % _ % _ %%
                               (HOL.sym % _ % _ %% int_numeral_0_eq_0))) %%
                           (reflexive % _))) %%
                       (reflexive % _))) %%
                   (zadd_0 % _)))))) %%
         (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
   TrueI) %%
 (HOL.trans % _ % _ % _ %% (less_add_iff2 % _ % _ % _ % _ % _) %%
   (equal_elim % _ % _ %%
     (symmetric % _ % _ %%
       (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
         (transitive % _ % _ % _ %%
           (combination % _ % _ % _ % _ %%
             (combination % op = % _ % _ % _ %% (reflexive % _) %%
               (combination % op < i % _ % _ % _ %% (reflexive % _) %%
                 (transitive % _ % _ % _ %%
                   (combination % _ % _ % _ % _ %%
                     (combination % op + % _ % _ % _ %% (reflexive % _) %%
                       (transitive % _ % _ % _ %%
                         (transitive % _ % _ % _ %%
                           (combination % _ % _ % _ % _ %%
                             (combination % op * % _ % _ % _ %% (reflexive % _) %%
                               (transitive % _ % _ % _ %%
                                 (eq_reflection % _ % _ %%
                                   (bin_arith_simps_26 % _ % _)) %%
                                 (combination % number_of % _ % _ % _ %%
                                   (reflexive % _) %%
                                   (transitive % _ % _ % _ %%
                                     (transitive % _ % _ % _ %%
                                       (combination % bin_add (bin.Pls BIT True) % _ %
                                         _ %
                                         _ %%
                                         (reflexive % _) %%
                                         (eq_reflection % _ % _ %%
bin_arith_simps_8)) %%
                                       (eq_reflection % _ % _ %%
                                         (bin_arith_simps_25 % _ % _))) %%
                                     (transitive % _ % _ % _ %%
                                       (combination % _ % _ % _ % _ %%
                                         (combination % NCons % _ % _ % _ %%
(reflexive % _) %%
(transitive % _ % _ % _ %%
  (combination % bin_add bin.Pls % _ % _ % _ %% (reflexive % _) %%
    (eq_reflection % _ % _ %% bin_arith_simps_3)) %%
  (eq_reflection % _ % _ %% (bin_arith_simps_5 % _)))) %%
                                         (reflexive % _)) %%
                                       (eq_reflection % _ % _ %%
                                         (bin_arith_simps_36 % _ % _ % _))))))) %%
                             (reflexive % _)) %%
                           (eq_reflection % _ % _ %% (bin_arith_simps_14 % _ % _))) %%
                         (combination % number_of % _ % _ % _ %% (reflexive % _) %%
                           (transitive % _ % _ % _ %%
                             (eq_reflection % _ % _ %%
                               (bin_arith_simps_31 % _ % _)) %%
                             (transitive % _ % _ % _ %%
                               (combination % _ % _ % _ % _ %%
                                 (combination % NCons % _ % _ % _ %%
                                   (reflexive % _) %%
                                   (transitive % _ % _ % _ %%
                                     (eq_reflection % _ % _ %%
                                       (bin_arith_simps_30 % _ % _)) %%
                                     (transitive % _ % _ % _ %%
                                       (combination % _ % _ % _ % _ %%
                                         (combination % bin_add % _ % _ % _ %%
(reflexive % _) %%
(transitive % _ % _ % _ %%
  (combination % _ % _ % _ % _ %%
    (combination % NCons % _ % _ % _ %% (reflexive % _) %%
      (eq_reflection % _ % _ %% (bin_arith_simps_9 % _))) %%
    (reflexive % _)) %%
  (eq_reflection % _ % _ %% bin_arith_simps_32))) %%
                                         (reflexive % _)) %%
                                       (eq_reflection % _ % _ %%
                                         (bin_arith_simps_5 % _))))) %%
                                 (reflexive % _)) %%
                               (eq_reflection % _ % _ %%
                                 (bin_arith_simps_36 % _ % _ % _))))))) %%
                     (reflexive % _)) %%
                   (eq_reflection % _ % _ %%
                     (equal_elim % _ % _ %%
                       (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                         (combination % _ % _ % _ % _ %%
                           (combination % op = % _ % _ % _ %% (reflexive % _) %%
                             (combination % op + 2 % _ % _ % _ %% (reflexive % _) %%
                               (eq_reflection % _ % _ %%
                                 (HOL.sym % _ % _ %% int_numeral_0_eq_0)))) %%
                           (reflexive % _))) %%
                       (zadd_0_right % _)))))) %%
             (combination % _ % _ % _ % _ %%
               (combination % op < % _ % _ % _ %% (reflexive % _) %%
                 (eq_reflection % _ % _ %%
                   (equal_elim % _ % _ %%
                     (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                       (combination % _ % _ % _ % _ %%
                         (combination % op = % _ % _ % _ %% (reflexive % _) %%
                           (combination % op + i % _ % _ % _ %% (reflexive % _) %%
                             (eq_reflection % _ % _ %%
                               (HOL.sym % _ % _ %% int_numeral_0_eq_0)))) %%
                         (reflexive % _))) %%
                     (zadd_0_right % _)))) %%
               (transitive % _ % _ % _ %%
                 (combination % _ % _ % _ % _ %%
                   (combination % op + % _ % _ % _ %% (reflexive % _) %%
                     (transitive % _ % _ % _ %%
                       (eq_reflection % _ % _ %% (bin_arith_simps_14 % _ % _)) %%
                       (combination % number_of % _ % _ % _ %% (reflexive % _) %%
                         (transitive % _ % _ % _ %%
                           (eq_reflection % _ % _ %% (bin_arith_simps_31 % _ % _)) %%
                           (transitive % _ % _ % _ %%
                             (combination % _ % _ % _ % _ %%
                               (combination % NCons % _ % _ % _ %% (reflexive % _) %%
                                 (transitive % _ % _ % _ %%
                                   (eq_reflection % _ % _ %%
                                     (bin_arith_simps_30 % _ % _)) %%
                                   (transitive % _ % _ % _ %%
                                     (combination % _ % _ % _ % _ %%
                                       (combination % bin_add % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (transitive % _ % _ % _ %%
(combination % _ % _ % _ % _ %%
  (combination % NCons % _ % _ % _ %% (reflexive % _) %%
    (eq_reflection % _ % _ %% (bin_arith_simps_9 % _))) %%
  (reflexive % _)) %%
(eq_reflection % _ % _ %% bin_arith_simps_32))) %%
                                       (reflexive % _)) %%
                                     (eq_reflection % _ % _ %%
                                       (bin_arith_simps_5 % _))))) %%
                               (reflexive % _)) %%
                             (eq_reflection % _ % _ %%
                               (bin_arith_simps_36 % _ % _ % _))))))) %%
                   (reflexive % _)) %%
                 (eq_reflection % _ % _ %%
                   (equal_elim % _ % _ %%
                     (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                       (combination % _ % _ % _ % _ %%
                         (combination % op = % _ % _ % _ %% (reflexive % _) %%
                           (combination % op + 2 % _ % _ % _ %% (reflexive % _) %%
                             (eq_reflection % _ % _ %%
                               (HOL.sym % _ % _ %% int_numeral_0_eq_0)))) %%
                         (reflexive % _))) %%
                     (zadd_0_right % _)))))) %%
           (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
     TrueI)))))) %%
                                    (reflexive % _))) %%
                                (reflexive % _))) %%
                            (Lam H: _.
                              meta_eq_to_obj_eq % _ % _ %% (reflexive % _))))) %%
                      (eq_reflection % _ % _ %%
                        (imp_cong % _ % _ % _ % _ %%
                          (meta_eq_to_obj_eq % _ % _ %%
                            (equal_elim % _ % _ %%
                              (symmetric % _ % _ %%
                                (combination % _ % _ % _ % _ %%
                                  (combination % op == % _ % _ % _ %%
                                    (reflexive % _) %%
                                    (combination % Not % _ % _ % _ %%
                                      (reflexive % _) %%
                                      (equal_elim % _ % _ %%
                                        (eq_cong2 % _ % _ % _ %%
                                          (equal_elim % _ % _ %%
 (symmetric % _ % _ %%
   (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
     (combination % _ % _ % _ % _ %%
       (combination % op = % _ % _ % _ %% (reflexive % _) %%
         (combination % _ % _ % _ % _ %%
           (combination % op < % _ % _ % _ %% (reflexive % _) %%
             (eq_reflection % _ % _ %%
               (equal_elim % _ % _ %%
                 (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                   (combination % _ % _ % _ % _ %%
                     (combination % op = % _ % _ % _ %% (reflexive % _) %%
                       (combination % op + i % _ % _ % _ %% (reflexive % _) %%
                         (eq_reflection % _ % _ %%
                           (HOL.sym % _ % _ %% int_numeral_0_eq_0)))) %%
                     (reflexive % _))) %%
                 (zadd_0_right % _)))) %%
           (transitive % _ % _ % _ %%
             (combination % _ % _ % _ % _ %%
               (combination % op + % _ % _ % _ %% (reflexive % _) %%
                 (eq_reflection % _ % _ %%
                   (equal_elim % _ % _ %%
                     (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                       (combination % _ % _ % _ % _ %%
                         (combination % op = % _ % _ % _ %% (reflexive % _) %%
                           (combination % op * 2 % _ % _ % _ %% (reflexive % _) %%
                             (eq_reflection % _ % _ %%
                               (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                         (reflexive % _))) %%
                     (zmult_1_right % _)))) %%
               (reflexive % _)) %%
             (eq_reflection % _ % _ %%
               (equal_elim % _ % _ %%
                 (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                   (combination % _ % _ % _ % _ %%
                     (combination % op = % _ % _ % _ %% (reflexive % _) %%
                       (combination % op + 2 % _ % _ % _ %% (reflexive % _) %%
                         (eq_reflection % _ % _ %%
                           (HOL.sym % _ % _ %% int_numeral_0_eq_0)))) %%
                     (reflexive % _))) %%
                 (zadd_0_right % _)))))) %%
       (reflexive % _)))) %%
 (HOL.refl % _))) %%
                                        (eq_reflection % _ % _ %%
                                          (HOL.trans % _ % _ % _ %%
 (equal_elim % _ % _ %%
   (symmetric % _ % _ %%
     (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
       (transitive % _ % _ % _ %%
         (combination % _ % _ % _ % _ %%
           (combination % op = % _ % _ % _ %% (reflexive % _) %%
             (combination % _ % _ % _ % _ %%
               (combination % op < % _ % _ % _ %% (reflexive % _) %%
                 (transitive % _ % _ % _ %%
                   (transitive % _ % _ % _ %%
                     (combination % op - i % _ % _ % _ %% (reflexive % _) %%
                       (eq_reflection % _ % _ %%
                         (HOL.sym % _ % _ %% int_numeral_1_eq_1))) %%
                     (zdiff_def % _ % _)) %%
                   (combination % op + i % _ % _ % _ %% (reflexive % _) %%
                     (transitive % _ % _ % _ %%
                       (eq_reflection % _ % _ %%
                         (HOL.sym % _ % _ %% (number_of_minus % _))) %%
                       (combination % number_of % _ % _ % _ %% (reflexive % _) %%
                         (transitive % _ % _ % _ %%
                           (eq_reflection % _ % _ %% (bin_minus_1 % _)) %%
                           (transitive % _ % _ % _ %%
                             (combination % bin_pred % _ % _ % _ %% (reflexive % _) %%
                               (transitive % _ % _ % _ %%
                                 (combination % _ % _ % _ % _ %%
                                   (combination % NCons % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (eq_reflection % _ % _ %% bin_minus_Pls)) %%
                                   (reflexive % _)) %%
                                 (eq_reflection % _ % _ %% NCons_simps_1))) %%
                             (eq_reflection % _ % _ %% bin_pred_Pls)))))))) %%
               (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
           (combination % _ % _ % _ % _ %%
             (combination % op < % _ % _ % _ %% (reflexive % _) %%
               (transitive % _ % _ % _ %%
                 (combination % _ % _ % _ % _ %%
                   (combination % op + % _ % _ % _ %% (reflexive % _) %%
                     (eq_reflection % _ % _ %%
                       (equal_elim % _ % _ %%
                         (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                           (combination % _ % _ % _ % _ %%
                             (combination % op = % _ % _ % _ %% (reflexive % _) %%
                               (combination % op * -1 % _ % _ % _ %%
                                 (reflexive % _) %%
                                 (eq_reflection % _ % _ %%
                                   (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                             (reflexive % _))) %%
                         (zmult_1_right % _)))) %%
                   (reflexive % _)) %%
                 (eq_reflection % _ % _ %% (zadd_ac_2 % _ % _)))) %%
             (transitive % _ % _ % _ %%
               (transitive % _ % _ % _ %%
                 (combination % _ % _ % _ % _ %%
                   (combination % op + % _ % _ % _ %% (reflexive % _) %%
                     (eq_reflection % _ % _ %%
                       (equal_elim % _ % _ %%
                         (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                           (combination % _ % _ % _ % _ %%
                             (combination % op = % _ % _ % _ %% (reflexive % _) %%
                               (combination % op * Numeral1 % _ % _ % _ %%
                                 (reflexive % _) %%
                                 (eq_reflection % _ % _ %%
                                   (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                             (reflexive % _))) %%
                         (zmult_1_right % _)))) %%
                   (reflexive % _)) %%
                 (eq_reflection % _ % _ %% (zadd_ac_2 % _ % _))) %%
               (eq_reflection % _ % _ %%
                 (equal_elim % _ % _ %%
                   (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                     (combination % _ % _ % _ % _ %%
                       (combination % op = % _ % _ % _ %% (reflexive % _) %%
                         (combination % _ % _ % _ % _ %%
                           (combination % op + % _ % _ % _ %% (reflexive % _) %%
                             (eq_reflection % _ % _ %%
                               (HOL.sym % _ % _ %% int_numeral_0_eq_0))) %%
                           (reflexive % _))) %%
                       (reflexive % _))) %%
                   (zadd_0 % _)))))) %%
         (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
   TrueI) %%
 (HOL.trans % _ % _ % _ %% (less_add_iff2 % _ % _ % _ % _ % _) %%
   (equal_elim % _ % _ %%
     (symmetric % _ % _ %%
       (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
         (transitive % _ % _ % _ %%
           (combination % _ % _ % _ % _ %%
             (combination % op = % _ % _ % _ %% (reflexive % _) %%
               (combination % op < i % _ % _ % _ %% (reflexive % _) %%
                 (transitive % _ % _ % _ %%
                   (combination % _ % _ % _ % _ %%
                     (combination % op + % _ % _ % _ %% (reflexive % _) %%
                       (transitive % _ % _ % _ %%
                         (transitive % _ % _ % _ %%
                           (combination % _ % _ % _ % _ %%
                             (combination % op * % _ % _ % _ %% (reflexive % _) %%
                               (transitive % _ % _ % _ %%
                                 (eq_reflection % _ % _ %%
                                   (bin_arith_simps_26 % _ % _)) %%
                                 (combination % number_of % _ % _ % _ %%
                                   (reflexive % _) %%
                                   (transitive % _ % _ % _ %%
                                     (transitive % _ % _ % _ %%
                                       (combination % bin_add (bin.Pls BIT True) % _ %
                                         _ %
                                         _ %%
                                         (reflexive % _) %%
                                         (eq_reflection % _ % _ %%
bin_arith_simps_8)) %%
                                       (eq_reflection % _ % _ %%
                                         (bin_arith_simps_25 % _ % _))) %%
                                     (transitive % _ % _ % _ %%
                                       (combination % _ % _ % _ % _ %%
                                         (combination % NCons % _ % _ % _ %%
(reflexive % _) %%
(transitive % _ % _ % _ %%
  (combination % bin_add bin.Pls % _ % _ % _ %% (reflexive % _) %%
    (eq_reflection % _ % _ %% bin_arith_simps_3)) %%
  (eq_reflection % _ % _ %% (bin_arith_simps_5 % _)))) %%
                                         (reflexive % _)) %%
                                       (eq_reflection % _ % _ %%
                                         (bin_arith_simps_36 % _ % _ % _))))))) %%
                             (reflexive % _)) %%
                           (eq_reflection % _ % _ %% (bin_arith_simps_14 % _ % _))) %%
                         (combination % number_of % _ % _ % _ %% (reflexive % _) %%
                           (transitive % _ % _ % _ %%
                             (eq_reflection % _ % _ %%
                               (bin_arith_simps_31 % _ % _)) %%
                             (transitive % _ % _ % _ %%
                               (combination % _ % _ % _ % _ %%
                                 (combination % NCons % _ % _ % _ %%
                                   (reflexive % _) %%
                                   (transitive % _ % _ % _ %%
                                     (eq_reflection % _ % _ %%
                                       (bin_arith_simps_30 % _ % _)) %%
                                     (transitive % _ % _ % _ %%
                                       (combination % _ % _ % _ % _ %%
                                         (combination % bin_add % _ % _ % _ %%
(reflexive % _) %%
(transitive % _ % _ % _ %%
  (combination % _ % _ % _ % _ %%
    (combination % NCons % _ % _ % _ %% (reflexive % _) %%
      (eq_reflection % _ % _ %% (bin_arith_simps_9 % _))) %%
    (reflexive % _)) %%
  (eq_reflection % _ % _ %% bin_arith_simps_32))) %%
                                         (reflexive % _)) %%
                                       (eq_reflection % _ % _ %%
                                         (bin_arith_simps_5 % _))))) %%
                                 (reflexive % _)) %%
                               (eq_reflection % _ % _ %%
                                 (bin_arith_simps_36 % _ % _ % _))))))) %%
                     (reflexive % _)) %%
                   (eq_reflection % _ % _ %%
                     (equal_elim % _ % _ %%
                       (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                         (combination % _ % _ % _ % _ %%
                           (combination % op = % _ % _ % _ %% (reflexive % _) %%
                             (combination % op + 2 % _ % _ % _ %% (reflexive % _) %%
                               (eq_reflection % _ % _ %%
                                 (HOL.sym % _ % _ %% int_numeral_0_eq_0)))) %%
                           (reflexive % _))) %%
                       (zadd_0_right % _)))))) %%
             (combination % _ % _ % _ % _ %%
               (combination % op < % _ % _ % _ %% (reflexive % _) %%
                 (eq_reflection % _ % _ %%
                   (equal_elim % _ % _ %%
                     (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                       (combination % _ % _ % _ % _ %%
                         (combination % op = % _ % _ % _ %% (reflexive % _) %%
                           (combination % op + i % _ % _ % _ %% (reflexive % _) %%
                             (eq_reflection % _ % _ %%
                               (HOL.sym % _ % _ %% int_numeral_0_eq_0)))) %%
                         (reflexive % _))) %%
                     (zadd_0_right % _)))) %%
               (transitive % _ % _ % _ %%
                 (combination % _ % _ % _ % _ %%
                   (combination % op + % _ % _ % _ %% (reflexive % _) %%
                     (transitive % _ % _ % _ %%
                       (eq_reflection % _ % _ %% (bin_arith_simps_14 % _ % _)) %%
                       (combination % number_of % _ % _ % _ %% (reflexive % _) %%
                         (transitive % _ % _ % _ %%
                           (eq_reflection % _ % _ %% (bin_arith_simps_31 % _ % _)) %%
                           (transitive % _ % _ % _ %%
                             (combination % _ % _ % _ % _ %%
                               (combination % NCons % _ % _ % _ %% (reflexive % _) %%
                                 (transitive % _ % _ % _ %%
                                   (eq_reflection % _ % _ %%
                                     (bin_arith_simps_30 % _ % _)) %%
                                   (transitive % _ % _ % _ %%
                                     (combination % _ % _ % _ % _ %%
                                       (combination % bin_add % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (transitive % _ % _ % _ %%
(combination % _ % _ % _ % _ %%
  (combination % NCons % _ % _ % _ %% (reflexive % _) %%
    (eq_reflection % _ % _ %% (bin_arith_simps_9 % _))) %%
  (reflexive % _)) %%
(eq_reflection % _ % _ %% bin_arith_simps_32))) %%
                                       (reflexive % _)) %%
                                     (eq_reflection % _ % _ %%
                                       (bin_arith_simps_5 % _))))) %%
                               (reflexive % _)) %%
                             (eq_reflection % _ % _ %%
                               (bin_arith_simps_36 % _ % _ % _))))))) %%
                   (reflexive % _)) %%
                 (eq_reflection % _ % _ %%
                   (equal_elim % _ % _ %%
                     (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                       (combination % _ % _ % _ % _ %%
                         (combination % op = % _ % _ % _ %% (reflexive % _) %%
                           (combination % op + 2 % _ % _ % _ %% (reflexive % _) %%
                             (eq_reflection % _ % _ %%
                               (HOL.sym % _ % _ %% int_numeral_0_eq_0)))) %%
                         (reflexive % _))) %%
                     (zadd_0_right % _)))))) %%
           (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
     TrueI))))))) %%
                                  (reflexive % _))) %%
                              (reflexive % _))) %%
                          (Lam H: _.
                            meta_eq_to_obj_eq % _ % _ %% (reflexive % _))))))))) %%
           (reflexive % _))))) %%
  (reflexive % _)))))))))) %%
                        (reflexive % _))))) %%
               (reflexive % _)))))))))))) %%
                                (reflexive % _)))))))) %%
                 (eq_reflection % _ % _ %%
                   (simp_thms_39 % _ %
                     (%h1. p1 = \<langle>Suc 0 0 0 0\<rangle> &
                           (EX p1 p2a h1a i.
                               (EX a. E\<lfloor>self\<rfloor> = Ref a &
                                      h1a = h1 &
                                      i = h1a<a\<bullet>count> &
                                      p1 = \<langle>2 0 0 0\<rangle>) &
                               (EX p2. (EX p1 p2a h1.
(EX a. E\<lfloor>self\<rfloor> = Ref a &
       h1 = h1a<a\<bullet>count:=(i - 1)> & p1 = \<langle>3 0 0 0\<rangle>) &
(EX p2. (EX pp. p2 =
                \<langle>Suc (Suc (renv.clock
                                    pp)) callc pp invkc pp invkdpth pp\<rangle> &
                (i < 2 -->
                 hh = h1 & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                (~ i < 2 -->
                 0 < h1<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
                 v = IVal 0 &
                 hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
        p2a = \<langle>4 + renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
p2 =
\<langle>renv.clock p1 +
         renv.clock
          p2a callc p1 +
              callc
               p2a invkc p1 + invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                                       p2a =
                                       \<langle>4 +
     renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                               p2 =
                               \<langle>Suc (renv.clock p1 +
  renv.clock
   p2a) callc p1 +
        callc p2a invkc p1 + invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                           p = \<langle>Suc (renv.clock p1 +
  renv.clock
   p2) callc p1 +
       callc p2 invkc p1 + invkc p2 max (invkdpth p1) (invkdpth p2)\<rangle>)))))) %%
          (eq_reflection % _ % _ %% (ex_simps_2 % _ % _))) %%
        (combination % op & (p1 = \<langle>Suc 0 0 0 0\<rangle>) % _ % _ % _ %%
          (reflexive % _) %%
          (combination % Ex % _ % _ % _ %% (reflexive % _) %%
            (abstract_rule % _ % _ %% (Lam p2. reflexive % _))))))) %%
 (eq_reflection % _ % _ %%
   (simp_thms_39 % _ %
     (%p1. EX p2. (EX p1 p2a h1 i.
                      (EX a. E\<lfloor>self\<rfloor> = Ref a &
                             h1 = h &
                             i = h1<a\<bullet>count> &
                             p1 = \<langle>2 0 0 0\<rangle>) &
                      (EX p2. (EX p1 p2a h1a.
                                  (EX a. E\<lfloor>self\<rfloor> = Ref a &
                                         h1a = h1<a\<bullet>count:=(i - 1)> &
                                         p1 = \<langle>3 0 0 0\<rangle>) &
                                  (EX p2. (EX pp.
   p2 = \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
   (i < 2 --> hh = h1a & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
   (~ i < 2 -->
    0 < h1a<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
    v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
                                          p2a =
                                          \<langle>4 +
        renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                                  p2 =
                                  \<langle>renv.clock p1 +
renv.clock
 p2a callc p1 +
     callc p2a invkc p1 + invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                              p2a =
                              \<langle>4 + renv.clock
 p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                      p2 =
                      \<langle>Suc (renv.clock p1 +
                                    renv.clock
                                     p2a) callc p1 +
                                          callc
p2a invkc p1 + invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                  p = \<langle>Suc (renv.clock p1 +
                                    renv.clock
                                     p2) callc p1 +
                                         callc
                                          p2 invkc p1 +
  invkc p2 max (invkdpth p1) (invkdpth p2)\<rangle>)))) %%
                                          (combination % Ex % _ % _ % _ %%
 (reflexive % _) %%
 (abstract_rule % _ % _ %%
   (Lam p2.
     combination %
      op & (EX p1 p2a h1 i.
               (EX a. E\<lfloor>self\<rfloor> = Ref a &
                      h1 = h &
                      i = h1<a\<bullet>count> & p1 = \<langle>2 0 0 0\<rangle>) &
               (EX p2. (EX p1 p2a h1a.
                           (EX a. E\<lfloor>self\<rfloor> = Ref a &
                                  h1a = h1<a\<bullet>count:=(i - 1)> &
                                  p1 = \<langle>3 0 0 0\<rangle>) &
                           (EX p2. (EX pp. p2 =
\<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
(i < 2 --> hh = h1a & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
(~ i < 2 -->
 0 < h1a<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
 v = IVal 0 & hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
                                   p2a =
                                   \<langle>4 +
 renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                           p2 =
                           \<langle>renv.clock p1 +
                                    renv.clock
                                     p2a callc p1 +
                                         callc
                                          p2a invkc p1 +
   invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                       p2a =
                       \<langle>4 + renv.clock
                                     p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
               p2 =
               \<langle>Suc (renv.clock p1 +
                             renv.clock
                              p2a) callc p1 +
                                   callc
                                    p2a invkc p1 +
                                        invkc
                                         p2a max (invkdpth p1)
   (invkdpth p2a)\<rangle>) %
      _ %
      _ %
      _ %%
      (reflexive % _) %%
      (combination % op = p % _ % _ % _ %% (reflexive % _) %%
        (combination % _ % _ % _ % _ %%
          (combination % renv.clock_field % _ % _ % _ %% (reflexive % _) %%
            (combination % Suc % _ % _ % _ %% (reflexive % _) %%
              (transitive % _ % _ % _ %%
                (transitive % _ % _ % _ %%
                  (combination % _ % _ % _ % _ %%
                    (combination % op + % _ % _ % _ %% (reflexive % _) %%
                      (eq_reflection % _ % _ %%
                        (select_convs_1 % _ % _ % _ % _ % _))) %%
                    (reflexive % _)) %%
                  (eq_reflection % _ % _ %% (add_Suc % _ % _))) %%
                (combination % Suc % _ % _ % _ %% (reflexive % _) %%
                  (eq_reflection % _ % _ %% (zero % _)))))) %%
          (combination % _ % _ % _ % _ %%
            (combination % callc_field % _ % _ % _ %% (reflexive % _) %%
              (transitive % _ % _ % _ %%
                (combination % _ % _ % _ % _ %%
                  (combination % op + % _ % _ % _ %% (reflexive % _) %%
                    (eq_reflection % _ % _ %%
                      (select_convs_2 % _ % _ % _ % _ % _))) %%
                  (reflexive % _)) %%
                (eq_reflection % _ % _ %% (zero % _)))) %%
            (combination % _ % _ % _ % _ %%
              (combination % invkc_field % _ % _ % _ %% (reflexive % _) %%
                (transitive % _ % _ % _ %%
                  (combination % _ % _ % _ % _ %%
                    (combination % op + % _ % _ % _ %% (reflexive % _) %%
                      (eq_reflection % _ % _ %%
                        (select_convs_3 % _ % _ % _ % _ % _))) %%
                    (reflexive % _)) %%
                  (eq_reflection % _ % _ %% (zero % _)))) %%
              (combination % _ % _ % _ % _ %%
                (combination % invkdpth_field % _ % _ % _ %% (reflexive % _) %%
                  (transitive % _ % _ % _ %%
                    (combination % _ % _ % _ % _ %%
                      (combination % max % _ % _ % _ %% (reflexive % _) %%
                        (eq_reflection % _ % _ %%
                          (select_convs_4 % _ % _ % _ % _ % _))) %%
                      (reflexive % _)) %%
                    (eq_reflection % _ % _ %% (max_0L % _)))) %%
                (reflexive % _))))))))))))))))))))) %%
             (reflexive % _)))) %%
       (subsetI % _ % _ %%
         (Lam x.
           equal_elim % _ %
            (!!x. [| one ~= n & one ~= b & n ~= b & b ~= n & b ~= one & n ~= one;
                     x : {(E, h, hh, v, p).
                          EX p2. (EX p1 p2a h1 i.
                                     (EX a. E\<lfloor>self\<rfloor> = Ref a &
 h1 = h & i = h1<a\<bullet>count> & p1 = \<langle>2 0 0 0\<rangle>) &
                                     (EX p2. (EX p1 p2a h1a.
      (EX a. E\<lfloor>self\<rfloor> = Ref a &
             h1a = h1<a\<bullet>count:=(i - 1)> & p1 = \<langle>3 0 0 0\<rangle>) &
      (EX p2. (EX pp. p2 =
                      \<langle>Suc (Suc (renv.clock
                                          pp)) callc
     pp invkc pp invkdpth pp\<rangle> &
                      (i < 2 -->
                       hh = h1a & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                      (~ i < 2 -->
                       0 < h1a<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
                       v = IVal 0 &
                       hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
              p2a =
              \<langle>4 + renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
      p2 =
      \<langle>renv.clock p1 +
               renv.clock
                p2a callc p1 +
                    callc
                     p2a invkc p1 +
                         invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
  p2a = \<langle>4 + renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                                     p2 =
                                     \<langle>Suc
    (renv.clock p1 +
     renv.clock
      p2a) callc p1 +
           callc p2a invkc p1 + invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                                 p = \<langle>Suc
    (Suc (renv.clock p2)) callc p2 invkc p2 invkdpth p2\<rangle>} |]
                  ==> x : {(E, h, hh, v, p).
                           0 < h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
                           v = IVal 0 &
                           hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0}) %%
            (symmetric % _ % _ %%
              (split_paired_all %
                (%x. ([| one ~= n & one ~= b & n ~= b & b ~= n & b ~= one & n ~= one;
                         x : {(E, h, hh, v, p).
                              EX p2. (EX p1 p2a h1 i.
                                         (EX a.
  E\<lfloor>self\<rfloor> = Ref a &
  h1 = h & i = h1<a\<bullet>count> & p1 = \<langle>2 0 0 0\<rangle>) &
                                         (EX p2.
  (EX p1 p2a h1a.
      (EX a. E\<lfloor>self\<rfloor> = Ref a &
             h1a = h1<a\<bullet>count:=(i - 1)> & p1 = \<langle>3 0 0 0\<rangle>) &
      (EX p2. (EX pp. p2 =
                      \<langle>Suc (Suc (renv.clock
                                          pp)) callc
     pp invkc pp invkdpth pp\<rangle> &
                      (i < 2 -->
                       hh = h1a & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                      (~ i < 2 -->
                       0 < h1a<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> -->
                       v = IVal 0 &
                       hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
              p2a =
              \<langle>4 + renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
      p2 =
      \<langle>renv.clock p1 +
               renv.clock
                p2a callc p1 +
                    callc
                     p2a invkc p1 +
                         invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
  p2a = \<langle>4 + renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                                         p2 =
                                         \<langle>Suc
        (renv.clock p1 +
         renv.clock
          p2a) callc p1 +
               callc
                p2a invkc p1 + invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                                     p = \<langle>Suc
        (Suc (renv.clock p2)) callc p2 invkc p2 invkdpth p2\<rangle>} |]
                      ==> x : {(E, h, hh, v, p).
                               0 < h<(theloc
                                       E\<lfloor>self\<rfloor>)\<bullet>count> -->
                               v = IVal 0 &
                               hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> =
                               0})))) %%
            (Lam x.
              equal_elim % _ % _ %%
               (symmetric % _ % _ %%
                 (split_paired_all %
                   (%ba. ([| one ~= n &
                             one ~= b & n ~= b & b ~= n & b ~= one & n ~= one;
                             (x, ba)
                             : {(E, h, hh, v, p).
                                EX p2. (EX p1 p2a h1 i.
(EX a. E\<lfloor>self\<rfloor> = Ref a &
       h1 = h & i = h1<a\<bullet>count> & p1 = \<langle>2 0 0 0\<rangle>) &
(EX p2. (EX p1 p2a h1a.
            (EX a. E\<lfloor>self\<rfloor> = Ref a &
                   h1a = h1<a\<bullet>count:=(i - 1)> &
                   p1 = \<langle>3 0 0 0\<rangle>) &
            (EX p2. (EX pp. p2 =
                            \<langle>Suc (Suc
(renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                            (i < 2 -->
                             hh = h1a &
                             v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                            (~ i < 2 -->
                             0 < h1a<(theloc
                                       E\<lfloor>self\<rfloor>)\<bullet>count> -->
                             v = IVal 0 &
                             hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> =
                             0)) &
                    p2a =
                    \<langle>4 + renv.clock
                                  p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
            p2 =
            \<langle>renv.clock p1 +
                     renv.clock
                      p2a callc p1 +
                          callc
                           p2a invkc p1 +
                               invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
        p2a = \<langle>4 + renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
p2 =
\<langle>Suc (renv.clock p1 +
              renv.clock
               p2a) callc p1 +
                    callc
                     p2a invkc p1 +
                         invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                                       p = \<langle>Suc
          (Suc (renv.clock p2)) callc p2 invkc p2 invkdpth p2\<rangle>} |]
                          ==> (x, ba)
                              : {(E, h, hh, v, p).
                                 0 < h<(theloc
                                         E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                 v = IVal 0 &
                                 hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> =
                                 0})))) %%
               (Lam xa.
                 equal_elim % _ % _ %%
                  (symmetric % _ % _ %%
                    (split_paired_all %
                      (%ba. ([| one ~= n &
                                one ~= b & n ~= b & b ~= n & b ~= one & n ~= one;
                                (x, xa, ba)
                                : {(E, h, hh, v, p).
                                   EX p2. (EX p1 p2a h1 i.
   (EX a. E\<lfloor>self\<rfloor> = Ref a &
          h1 = h & i = h1<a\<bullet>count> & p1 = \<langle>2 0 0 0\<rangle>) &
   (EX p2. (EX p1 p2a h1a.
               (EX a. E\<lfloor>self\<rfloor> = Ref a &
                      h1a = h1<a\<bullet>count:=(i - 1)> &
                      p1 = \<langle>3 0 0 0\<rangle>) &
               (EX p2. (EX pp. p2 =
                               \<langle>Suc (Suc
   (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                               (i < 2 -->
                                hh = h1a &
                                v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                               (~ i < 2 -->
                                0 < h1a<(theloc
                                          E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                v = IVal 0 &
                                hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> =
                                0)) &
                       p2a =
                       \<langle>4 + renv.clock
                                     p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
               p2 =
               \<langle>renv.clock p1 +
                        renv.clock
                         p2a callc p1 +
                             callc
                              p2a invkc p1 +
                                  invkc
                                   p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
           p2a = \<langle>4 + renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
   p2 =
   \<langle>Suc (renv.clock p1 +
                 renv.clock
                  p2a) callc p1 +
                       callc
                        p2a invkc p1 +
                            invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                                          p = \<langle>Suc
             (Suc (renv.clock p2)) callc p2 invkc p2 invkdpth p2\<rangle>} |]
                             ==> (x, xa, ba)
                                 : {(E, h, hh, v, p).
                                    0 < h<(theloc
 E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                    v = IVal 0 &
                                    hh<(theloc
                                         E\<lfloor>self\<rfloor>)\<bullet>count> =
                                    0})))) %%
                  (Lam xb.
                    equal_elim % _ % _ %%
                     (symmetric % _ % _ %%
                       (split_paired_all %
                         (%ba. ([| one ~= n &
                                   one ~= b & n ~= b & b ~= n & b ~= one & n ~= one;
                                   (x, xa, xb, ba)
                                   : {(E, h, hh, v, p).
                                      EX p2. (EX p1 p2a h1 i.
      (EX a. E\<lfloor>self\<rfloor> = Ref a &
             h1 = h & i = h1<a\<bullet>count> & p1 = \<langle>2 0 0 0\<rangle>) &
      (EX p2. (EX p1 p2a h1a.
                  (EX a. E\<lfloor>self\<rfloor> = Ref a &
                         h1a = h1<a\<bullet>count:=(i - 1)> &
                         p1 = \<langle>3 0 0 0\<rangle>) &
                  (EX p2. (EX pp. p2 =
                                  \<langle>Suc
 (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                  (i < 2 -->
                                   hh = h1a &
                                   v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                  (~ i < 2 -->
                                   0 < h1a<(theloc
  E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                   v = IVal 0 &
                                   hh<(theloc
                                        E\<lfloor>self\<rfloor>)\<bullet>count> =
                                   0)) &
                          p2a =
                          \<langle>4 + renv.clock
                                        p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                  p2 =
                  \<langle>renv.clock p1 +
                           renv.clock
                            p2a callc p1 +
                                callc
                                 p2a invkc p1 +
                                     invkc
                                      p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
              p2a =
              \<langle>4 + renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
      p2 =
      \<langle>Suc (renv.clock p1 +
                    renv.clock
                     p2a) callc p1 +
                          callc
                           p2a invkc p1 +
                               invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
  p = \<langle>Suc (Suc (renv.clock p2)) callc p2 invkc p2 invkdpth p2\<rangle>} |]
                                ==> (x, xa, xb, ba)
                                    : {(E, h, hh, v, p).
                                       0 < h<(theloc
    E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                       v = IVal 0 &
                                       hh<(theloc
 E\<lfloor>self\<rfloor>)\<bullet>count> =
                                       0})))) %%
                     (Lam a b (H: _) Ha: _.
                       iffD2 % _ % _ %%
                        (mem_Collect_eq % _ %
                          (%(E, h, hh, v, p).
                              0 < h<(theloc
                                      E\<lfloor>self\<rfloor>)\<bullet>count> -->
                              v = IVal 0 &
                              hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> =
                              0)) %%
                        (equal_elim % _ % _ %%
                          (symmetric % _ % _ %%
                            (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                              (transitive % _ % _ % _ %%
                                (eq_reflection % _ % _ %%
                                  (split_conv %
                                    (%E (h, hh, v, p).
                                        0 < h<(theloc
     E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                        v = IVal 0 &
                                        hh<(theloc
  E\<lfloor>self\<rfloor>)\<bullet>count> =
                                        0) %
                                    _ %
                                    _)) %%
                                (transitive % _ % _ % _ %%
                                  (transitive % _ % _ % _ %%
                                    (combination %
                                      (%(h, hh, v, p).
                                          0 < h<(theloc
       x\<lfloor>self\<rfloor>)\<bullet>count> -->
                                          v = IVal 0 &
                                          hh<(theloc
    x\<lfloor>self\<rfloor>)\<bullet>count> =
                                          0) %
                                      _ %
                                      _ %
                                      _ %%
                                      (reflexive % _) %%
                                      (reflexive % _)) %%
                                    (eq_reflection % _ % _ %%
                                      (split_conv %
                                        (%h (hh, v, p).
 0 < h<(theloc x\<lfloor>self\<rfloor>)\<bullet>count> -->
 v = IVal 0 & hh<(theloc x\<lfloor>self\<rfloor>)\<bullet>count> = 0) %
                                        _ %
                                        _))) %%
                                  (transitive % _ % _ % _ %%
                                    (transitive % _ % _ % _ %%
                                      (combination %
                                        (%(hh, v, p).
 0 < xa<(theloc x\<lfloor>self\<rfloor>)\<bullet>count> -->
 v = IVal 0 & hh<(theloc x\<lfloor>self\<rfloor>)\<bullet>count> = 0) %
                                        _ %
                                        _ %
                                        _ %%
                                        (reflexive % _) %%
                                        (reflexive % _)) %%
                                      (eq_reflection % _ % _ %%
                                        (split_conv %
                                          (%hh (v, p).
   0 < xa<(theloc x\<lfloor>self\<rfloor>)\<bullet>count> -->
   v = IVal 0 & hh<(theloc x\<lfloor>self\<rfloor>)\<bullet>count> = 0) %
                                          _ %
                                          _))) %%
                                    (transitive % _ % _ % _ %%
                                      (transitive % _ % _ % _ %%
                                        (combination %
                                          (%(v, p).
   0 < xa<(theloc x\<lfloor>self\<rfloor>)\<bullet>count> -->
   v = IVal 0 & xb<(theloc x\<lfloor>self\<rfloor>)\<bullet>count> = 0) %
                                          _ %
                                          _ %
                                          _ %%
                                          (reflexive % _) %%
                                          (reflexive % _)) %%
                                        (eq_reflection % _ % _ %%
                                          (split_conv %
 (%v p. 0 < xa<(theloc x\<lfloor>self\<rfloor>)\<bullet>count> -->
        v = IVal 0 & xb<(theloc x\<lfloor>self\<rfloor>)\<bullet>count> = 0) %
 _ %
 _))) %%
                                      (combination %
                                        (%p.
 0 < xa<(theloc x\<lfloor>self\<rfloor>)\<bullet>count> -->
 a = IVal 0 & xb<(theloc x\<lfloor>self\<rfloor>)\<bullet>count> = 0) %
                                        _ %
                                        _ %
                                        _ %%
                                        (reflexive % _) %%
                                        (reflexive % _)))))))) %%
                          (exE % _ % _ %%
                            (equal_elim % _ % _ %%
                              (combination % Trueprop % _ % _ % _ %%
                                (reflexive % _) %%
                                (transitive % _ % _ % _ %%
                                  (eq_reflection % _ % _ %%
                                    (split_conv %
                                      (%E (h, hh, v, p).
                                          EX p2.
  (EX p1 p2a h1 i.
      (EX a. E\<lfloor>self\<rfloor> = Ref a &
             h1 = h & i = h1<a\<bullet>count> & p1 = \<langle>2 0 0 0\<rangle>) &
      (EX p2. (EX p1 p2a h1a.
                  (EX a. E\<lfloor>self\<rfloor> = Ref a &
                         h1a = h1<a\<bullet>count:=(i - 1)> &
                         p1 = \<langle>3 0 0 0\<rangle>) &
                  (EX p2. (EX pp. p2 =
                                  \<langle>Suc
 (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                  (i < 2 -->
                                   hh = h1a &
                                   v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                  (~ i < 2 -->
                                   0 < h1a<(theloc
  E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                   v = IVal 0 &
                                   hh<(theloc
                                        E\<lfloor>self\<rfloor>)\<bullet>count> =
                                   0)) &
                          p2a =
                          \<langle>4 + renv.clock
                                        p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                  p2 =
                  \<langle>renv.clock p1 +
                           renv.clock
                            p2a callc p1 +
                                callc
                                 p2a invkc p1 +
                                     invkc
                                      p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
              p2a =
              \<langle>4 + renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
      p2 =
      \<langle>Suc (renv.clock p1 +
                    renv.clock
                     p2a) callc p1 +
                          callc
                           p2a invkc p1 +
                               invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
  p = \<langle>Suc (Suc (renv.clock p2)) callc p2 invkc p2 invkdpth p2\<rangle>) %
                                      _ %
                                      _)) %%
                                  (transitive % _ % _ % _ %%
                                    (transitive % _ % _ % _ %%
                                      (combination %
                                        (%(h, hh, v, p).
 EX p2. (EX p1 p2a h1 i.
            (EX a. x\<lfloor>self\<rfloor> = Ref a &
                   h1 = h &
                   i = h1<a\<bullet>count> & p1 = \<langle>2 0 0 0\<rangle>) &
            (EX p2. (EX p1 p2a h1a.
                        (EX a. x\<lfloor>self\<rfloor> = Ref a &
                               h1a = h1<a\<bullet>count:=(i - 1)> &
                               p1 = \<langle>3 0 0 0\<rangle>) &
                        (EX p2. (EX pp. p2 =
                                        \<langle>Suc
       (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                        (i < 2 -->
                                         hh = h1a &
                                         v = IVal 0 &
                                         pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                        (~ i < 2 -->
                                         0 < h1a<(theloc
        x\<lfloor>self\<rfloor>)\<bullet>count> -->
                                         v = IVal 0 &
                                         hh<(theloc
   x\<lfloor>self\<rfloor>)\<bullet>count> =
                                         0)) &
                                p2a =
                                \<langle>4 + renv.clock
   p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                        p2 =
                        \<langle>renv.clock p1 +
                                 renv.clock
                                  p2a callc p1 +
                                      callc
                                       p2a invkc p1 +
invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                    p2a =
                    \<langle>4 + renv.clock
                                  p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
            p2 =
            \<langle>Suc (renv.clock p1 +
                          renv.clock
                           p2a) callc p1 +
                                callc
                                 p2a invkc p1 +
                                     invkc
                                      p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
        p = \<langle>Suc (Suc (renv.clock
                                p2)) callc p2 invkc p2 invkdpth p2\<rangle>) %
                                        _ %
                                        _ %
                                        _ %%
                                        (reflexive % _) %%
                                        (reflexive % _)) %%
                                      (eq_reflection % _ % _ %%
                                        (split_conv %
                                          (%h (hh, v, p).
   EX p2. (EX p1 p2a h1 i.
              (EX a. x\<lfloor>self\<rfloor> = Ref a &
                     h1 = h &
                     i = h1<a\<bullet>count> & p1 = \<langle>2 0 0 0\<rangle>) &
              (EX p2. (EX p1 p2a h1a.
                          (EX a. x\<lfloor>self\<rfloor> = Ref a &
                                 h1a = h1<a\<bullet>count:=(i - 1)> &
                                 p1 = \<langle>3 0 0 0\<rangle>) &
                          (EX p2. (EX pp. p2 =
                                          \<langle>Suc
         (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                          (i < 2 -->
hh = h1a & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                          (~ i < 2 -->
0 < h1a<(theloc x\<lfloor>self\<rfloor>)\<bullet>count> -->
v = IVal 0 & hh<(theloc x\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
                                  p2a =
                                  \<langle>4 +
renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                          p2 =
                          \<langle>renv.clock p1 +
                                   renv.clock
                                    p2a callc p1 +
                                        callc
                                         p2a invkc p1 +
  invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                      p2a =
                      \<langle>4 + renv.clock
                                    p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
              p2 =
              \<langle>Suc (renv.clock p1 +
                            renv.clock
                             p2a) callc p1 +
                                  callc
                                   p2a invkc p1 +
                                       invkc
                                        p2a max (invkdpth p1)
  (invkdpth p2a)\<rangle>) &
          p = \<langle>Suc (Suc (renv.clock
                                  p2)) callc p2 invkc p2 invkdpth p2\<rangle>) %
                                          _ %
                                          _))) %%
                                    (transitive % _ % _ % _ %%
                                      (transitive % _ % _ % _ %%
                                        (combination %
                                          (%(hh, v, p).
   EX p2. (EX p1 p2a h1 i.
              (EX a. x\<lfloor>self\<rfloor> = Ref a &
                     h1 = xa &
                     i = h1<a\<bullet>count> & p1 = \<langle>2 0 0 0\<rangle>) &
              (EX p2. (EX p1 p2a h1a.
                          (EX a. x\<lfloor>self\<rfloor> = Ref a &
                                 h1a = h1<a\<bullet>count:=(i - 1)> &
                                 p1 = \<langle>3 0 0 0\<rangle>) &
                          (EX p2. (EX pp. p2 =
                                          \<langle>Suc
         (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                          (i < 2 -->
hh = h1a & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                          (~ i < 2 -->
0 < h1a<(theloc x\<lfloor>self\<rfloor>)\<bullet>count> -->
v = IVal 0 & hh<(theloc x\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
                                  p2a =
                                  \<langle>4 +
renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                          p2 =
                          \<langle>renv.clock p1 +
                                   renv.clock
                                    p2a callc p1 +
                                        callc
                                         p2a invkc p1 +
  invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                      p2a =
                      \<langle>4 + renv.clock
                                    p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
              p2 =
              \<langle>Suc (renv.clock p1 +
                            renv.clock
                             p2a) callc p1 +
                                  callc
                                   p2a invkc p1 +
                                       invkc
                                        p2a max (invkdpth p1)
  (invkdpth p2a)\<rangle>) &
          p = \<langle>Suc (Suc (renv.clock
                                  p2)) callc p2 invkc p2 invkdpth p2\<rangle>) %
                                          _ %
                                          _ %
                                          _ %%
                                          (reflexive % _) %%
                                          (reflexive % _)) %%
                                        (eq_reflection % _ % _ %%
                                          (split_conv %
 (%hh (v, p).
     EX p2. (EX p1 p2a h1 i.
                (EX a. x\<lfloor>self\<rfloor> = Ref a &
                       h1 = xa &
                       i = h1<a\<bullet>count> & p1 = \<langle>2 0 0 0\<rangle>) &
                (EX p2. (EX p1 p2a h1a.
                            (EX a. x\<lfloor>self\<rfloor> = Ref a &
                                   h1a = h1<a\<bullet>count:=(i - 1)> &
                                   p1 = \<langle>3 0 0 0\<rangle>) &
                            (EX p2. (EX pp. p2 =
 \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
 (i < 2 --> hh = h1a & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
 (~ i < 2 -->
  0 < h1a<(theloc x\<lfloor>self\<rfloor>)\<bullet>count> -->
  v = IVal 0 & hh<(theloc x\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
                                    p2a =
                                    \<langle>4 +
  renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                            p2 =
                            \<langle>renv.clock p1 +
                                     renv.clock
                                      p2a callc p1 +
                                          callc
p2a invkc p1 + invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                        p2a =
                        \<langle>4 + renv.clock
                                      p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                p2 =
                \<langle>Suc (renv.clock p1 +
                              renv.clock
                               p2a) callc p1 +
                                    callc
                                     p2a invkc p1 +
                                         invkc
                                          p2a max (invkdpth p1)
    (invkdpth p2a)\<rangle>) &
            p = \<langle>Suc (Suc (renv.clock
                                    p2)) callc p2 invkc p2 invkdpth p2\<rangle>) %
 _ %
 _))) %%
                                      (transitive % _ % _ % _ %%
                                        (transitive % _ % _ % _ %%
                                          (combination %
 (%(v, p).
     EX p2. (EX p1 p2a h1 i.
                (EX a. x\<lfloor>self\<rfloor> = Ref a &
                       h1 = xa &
                       i = h1<a\<bullet>count> & p1 = \<langle>2 0 0 0\<rangle>) &
                (EX p2. (EX p1 p2a h1a.
                            (EX a. x\<lfloor>self\<rfloor> = Ref a &
                                   h1a = h1<a\<bullet>count:=(i - 1)> &
                                   p1 = \<langle>3 0 0 0\<rangle>) &
                            (EX p2. (EX pp. p2 =
 \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
 (i < 2 --> xb = h1a & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
 (~ i < 2 -->
  0 < h1a<(theloc x\<lfloor>self\<rfloor>)\<bullet>count> -->
  v = IVal 0 & xb<(theloc x\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
                                    p2a =
                                    \<langle>4 +
  renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                            p2 =
                            \<langle>renv.clock p1 +
                                     renv.clock
                                      p2a callc p1 +
                                          callc
p2a invkc p1 + invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                        p2a =
                        \<langle>4 + renv.clock
                                      p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                p2 =
                \<langle>Suc (renv.clock p1 +
                              renv.clock
                               p2a) callc p1 +
                                    callc
                                     p2a invkc p1 +
                                         invkc
                                          p2a max (invkdpth p1)
    (invkdpth p2a)\<rangle>) &
            p = \<langle>Suc (Suc (renv.clock
                                    p2)) callc p2 invkc p2 invkdpth p2\<rangle>) %
 _ %
 _ %
 _ %%
 (reflexive % _) %%
 (reflexive % _)) %%
                                          (eq_reflection % _ % _ %%
 (split_conv %
   (%v p. EX p2. (EX p1 p2a h1 i.
                     (EX a. x\<lfloor>self\<rfloor> = Ref a &
                            h1 = xa &
                            i = h1<a\<bullet>count> &
                            p1 = \<langle>2 0 0 0\<rangle>) &
                     (EX p2. (EX p1 p2a h1a.
                                 (EX a. x\<lfloor>self\<rfloor> = Ref a &
                                        h1a = h1<a\<bullet>count:=(i - 1)> &
                                        p1 = \<langle>3 0 0 0\<rangle>) &
                                 (EX p2. (EX pp.
  p2 = \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
  (i < 2 --> xb = h1a & v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
  (~ i < 2 -->
   0 < h1a<(theloc x\<lfloor>self\<rfloor>)\<bullet>count> -->
   v = IVal 0 & xb<(theloc x\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
                                         p2a =
                                         \<langle>4 +
       renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                                 p2 =
                                 \<langle>renv.clock p1 +
                                          renv.clock
p2a callc p1 +
    callc p2a invkc p1 + invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                             p2a =
                             \<langle>4 + renv.clock
p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                     p2 =
                     \<langle>Suc (renv.clock p1 +
                                   renv.clock
                                    p2a) callc p1 +
                                         callc
                                          p2a invkc p1 +
   invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                 p = \<langle>Suc (Suc (renv.clock
                                         p2)) callc
    p2 invkc p2 invkdpth p2\<rangle>) %
   _ %
   _))) %%
                                        (combination %
                                          (%p.
   EX p2. (EX p1 p2a h1 i.
              (EX a. x\<lfloor>self\<rfloor> = Ref a &
                     h1 = xa &
                     i = h1<a\<bullet>count> & p1 = \<langle>2 0 0 0\<rangle>) &
              (EX p2. (EX p1 p2a h1a.
                          (EX a. x\<lfloor>self\<rfloor> = Ref a &
                                 h1a = h1<a\<bullet>count:=(i - 1)> &
                                 p1 = \<langle>3 0 0 0\<rangle>) &
                          (EX p2. (EX pp. p2 =
                                          \<langle>Suc
         (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                          (i < 2 -->
xb = h1a & a = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                          (~ i < 2 -->
0 < h1a<(theloc x\<lfloor>self\<rfloor>)\<bullet>count> -->
a = IVal 0 & xb<(theloc x\<lfloor>self\<rfloor>)\<bullet>count> = 0)) &
                                  p2a =
                                  \<langle>4 +
renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                          p2 =
                          \<langle>renv.clock p1 +
                                   renv.clock
                                    p2a callc p1 +
                                        callc
                                         p2a invkc p1 +
  invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
                      p2a =
                      \<langle>4 + renv.clock
                                    p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
              p2 =
              \<langle>Suc (renv.clock p1 +
                            renv.clock
                             p2a) callc p1 +
                                  callc
                                   p2a invkc p1 +
                                       invkc
                                        p2a max (invkdpth p1)
  (invkdpth p2a)\<rangle>) &
          p = \<langle>Suc (Suc (renv.clock
                                  p2)) callc p2 invkc p2 invkdpth p2\<rangle>) %
                                          _ %
                                          _ %
                                          _ %%
                                          (reflexive % _) %%
                                          (reflexive % _))))))) %%
                              (iffD1 % _ % _ %%
                                (mem_Collect_eq % _ %
                                  (%(E, h, hh, v, p).
                                      EX p2. (EX p1 p2a h1 i.
      (EX a. E\<lfloor>self\<rfloor> = Ref a &
             h1 = h & i = h1<a\<bullet>count> & p1 = \<langle>2 0 0 0\<rangle>) &
      (EX p2. (EX p1 p2a h1a.
                  (EX a. E\<lfloor>self\<rfloor> = Ref a &
                         h1a = h1<a\<bullet>count:=(i - 1)> &
                         p1 = \<langle>3 0 0 0\<rangle>) &
                  (EX p2. (EX pp. p2 =
                                  \<langle>Suc
 (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle> &
                                  (i < 2 -->
                                   hh = h1a &
                                   v = IVal 0 & pp = \<langle>Suc 0 0 0 0\<rangle>) &
                                  (~ i < 2 -->
                                   0 < h1a<(theloc
  E\<lfloor>self\<rfloor>)\<bullet>count> -->
                                   v = IVal 0 &
                                   hh<(theloc
                                        E\<lfloor>self\<rfloor>)\<bullet>count> =
                                   0)) &
                          p2a =
                          \<langle>4 + renv.clock
                                        p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
                  p2 =
                  \<langle>renv.clock p1 +
                           renv.clock
                            p2a callc p1 +
                                callc
                                 p2a invkc p1 +
                                     invkc
                                      p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
              p2a =
              \<langle>4 + renv.clock p2 callc p2 invkc p2 invkdpth p2\<rangle>) &
      p2 =
      \<langle>Suc (renv.clock p1 +
                    renv.clock
                     p2a) callc p1 +
                          callc
                           p2a invkc p1 +
                               invkc p2a max (invkdpth p1) (invkdpth p2a)\<rangle>) &
  p = \<langle>Suc (Suc (renv.clock p2)) callc p2 invkc p2 invkdpth p2\<rangle>)) %%
                                Ha)) %%
                            (Lam p2 Ha: _.
                              conjE % _ % _ % _ %% H %%
                               (Lam (H: _) H: _.
                                 conjE % _ % _ % _ %% Ha %%
                                  (Lam (Ha: _) Hb: _.
                                    exE % _ % _ %% Ha %%
                                     (Lam p1 Ha: _.
                                       exE % _ % _ %% Ha %%
                                        (Lam p2 Ha: _.
                                          exE % _ % _ %% Ha %%
(Lam h1 Ha: _.
  exE % _ % _ %% Ha %%
   (Lam i Ha: _.
     conjE % _ % _ % _ %% H %%
      (Lam (H: _) H: _.
        conjE % _ % _ % _ %% Ha %%
         (Lam (Ha: _) Hb: _.
           exE % _ % _ %% Ha %%
            (Lam aa Ha: _.
              conjE % _ % _ % _ %% H %%
               (Lam (H: _) H: _.
                 conjE % _ % _ % _ %% Hb %%
                  (Lam (Hb: _) Hc: _.
                    exE % _ % _ %% Hb %%
                     (Lam p2 Hb: _.
                       conjE % _ % _ % _ %% Ha %%
                        (Lam (Ha: _) Hc: _.
                          conjE % _ % _ % _ %% H %%
                           (Lam (H: _) H: _.
                             conjE % _ % _ % _ %% Hb %%
                              (Lam (Hb: _) Hd: _.
                                exE % _ % _ %% Hb %%
                                 (Lam p1 Hb: _.
                                   exE % _ % _ %% Hb %%
                                    (Lam p2 Hb: _.
                                      exE % _ % _ %% Hb %%
                                       (Lam h1 Hb: _.
                                         conjE % _ % _ % _ %% Hc %%
                                          (Lam (Hc: _) Hd: _.
 conjE % _ % _ % _ %% H %%
  (Lam (H: _) H: _.
    conjE % _ % _ % _ %%
     (equal_elim % _ % _ %%
       (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
         (combination % _ % _ % _ % _ %%
           (combination % op & % _ % _ % _ %% (reflexive % _) %%
             (combination % Ex % _ % _ % _ %% (reflexive % _) %%
               (abstract_rule % _ % _ %%
                 (Lam a.
                   combination % op & (x\<lfloor>self\<rfloor> = Ref a) % _ % _ % _ %%
                    (reflexive % _) %%
                    (combination % _ % _ % _ % _ %%
                      (combination % op & % _ % _ % _ %% (reflexive % _) %%
                        (combination % op = h1 % _ % _ % _ %% (reflexive % _) %%
                          (combination % _ % _ % _ % _ %%
                            (combination % _ % _ % _ % _ %%
                              (combination % _ % _ % _ % _ %%
                                (combination % obj_ifieldupdate % _ % _ % _ %%
                                  (reflexive % _) %%
                                  (eq_reflection % _ % _ %% Hc)) %%
                                (reflexive % _)) %%
                              (reflexive % _)) %%
                            (reflexive % _)))) %%
                      (reflexive % _)))))) %%
           (reflexive % _))) %%
       Hb) %%
     (Lam (H: _) Hb: _.
       exE % _ % _ %% H %%
        (Lam ab H: _.
          conjE % _ % _ % _ %%
           (equal_elim % _ % _ %%
             (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
               (combination % _ % _ % _ % _ %%
                 (combination % op & % _ % _ % _ %% (reflexive % _) %%
                   (combination % op = i % _ % _ % _ %% (reflexive % _) %%
                     (combination % _ % _ % _ % _ %%
                       (combination % _ % _ % _ % _ %%
                         (combination % iheap % _ % _ % _ %% (reflexive % _) %%
                           (eq_reflection % _ % _ %% Hc)) %%
                         (reflexive % _)) %%
                       (reflexive % _)))) %%
                 (reflexive % _))) %%
             Hd) %%
           (Lam (Hc: _) Hd: _.
             conjE % _ % _ % _ %%
              (equal_elim % _ % _ %%
                (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                  (combination % _ % _ % _ % _ %%
                    (combination % op & % _ % _ % _ %% (reflexive % _) %%
                      (combination % Ex % _ % _ % _ %% (reflexive % _) %%
                        (abstract_rule % _ % _ %%
                          (Lam p2.
                            combination % _ % _ % _ % _ %%
                             (combination % op & % _ % _ % _ %% (reflexive % _) %%
                               (combination % Ex % _ % _ % _ %% (reflexive % _) %%
                                 (abstract_rule % _ % _ %%
                                   (Lam pp.
                                     combination %
                                      op & (p2 =
 \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle>) %
                                      _ %
                                      _ %
                                      _ %%
                                      (reflexive % _) %%
                                      (combination % _ % _ % _ % _ %%
                                        (combination % op & % _ % _ % _ %%
                                          (reflexive % _) %%
                                          (combination % _ % _ % _ % _ %%
 (combination % op --> % _ % _ % _ %% (reflexive % _) %%
   (combination % _ % _ % _ % _ %%
     (combination % op < % _ % _ % _ %% (reflexive % _) %%
       (eq_reflection % _ % _ %% Hc)) %%
     (reflexive % _))) %%
 (reflexive % _))) %%
                                        (combination % _ % _ % _ % _ %%
                                          (combination % op --> % _ % _ % _ %%
 (reflexive % _) %%
 (combination % Not % _ % _ % _ %% (reflexive % _) %%
   (combination % _ % _ % _ % _ %%
     (combination % op < % _ % _ % _ %% (reflexive % _) %%
       (eq_reflection % _ % _ %% Hc)) %%
     (reflexive % _)))) %%
                                          (reflexive % _))))))) %%
                             (reflexive % _))))) %%
                    (reflexive % _))) %%
                Hb) %%
              (Lam (Hb: _) Hd: _.
                exE % _ % _ %% Hb %%
                 (Lam p2 Hb: _.
                   conjE % _ % _ % _ %%
                    (equal_elim % _ % _ %%
                      (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                        (combination % op & (x\<lfloor>self\<rfloor> = Ref ab) % _ %
                          _ %
                          _ %%
                          (reflexive % _) %%
                          (combination % _ % _ % _ % _ %%
                            (combination % op & % _ % _ % _ %% (reflexive % _) %%
                              (combination % op = h1 % _ % _ % _ %% (reflexive % _) %%
                                (combination % obj_ifieldupdate xa ab count % _ % _ %
                                  _ %%
                                  (reflexive % _) %%
                                  (combination % _ % _ % _ % _ %%
                                    (combination % op - % _ % _ % _ %%
                                      (reflexive % _) %%
                                      (eq_reflection % _ % _ %% Hc)) %%
                                    (reflexive % _))))) %%
                            (reflexive % _)))) %%
                      H) %%
                    (Lam (H: _) Hc: _.
                      conjE % _ % _ % _ %% Hb %%
                       (Lam (Hb: _) Hd: _.
                         exE % _ % _ %% Hb %%
                          (Lam pp Hb: _.
                            conjE % _ % _ % _ %% Hc %%
                             (Lam (Hc: _) Hd: _.
                               conjE % _ % _ % _ %%
                                (equal_elim % _ % _ %%
                                  (combination % Trueprop % _ % _ % _ %%
                                    (reflexive % _) %%
                                    (combination %
                                      op & (p2 =
 \<langle>Suc (Suc (renv.clock pp)) callc pp invkc pp invkdpth pp\<rangle>) %
                                      _ %
                                      _ %
                                      _ %%
                                      (reflexive % _) %%
                                      (combination % _ % _ % _ % _ %%
                                        (combination % op & % _ % _ % _ %%
                                          (reflexive % _) %%
                                          (combination %
 op --> (xa<aa\<bullet>count> < 2) %
 _ %
 _ %
 _ %%
 (reflexive % _) %%
 (combination % _ % _ % _ % _ %%
   (combination % op & % _ % _ % _ %% (reflexive % _) %%
     (combination % op = xb % _ % _ % _ %% (reflexive % _) %%
       (eq_reflection % _ % _ %% Hc))) %%
   (reflexive % _)))) %%
                                        (combination %
                                          op --> (~ xa<aa\<bullet>count> < 2) %
                                          _ %
                                          _ %
                                          _ %%
                                          (reflexive % _) %%
                                          (combination % _ % _ % _ % _ %%
 (combination % op --> % _ % _ % _ %% (reflexive % _) %%
   (combination % op < 0 % _ % _ % _ %% (reflexive % _) %%
     (combination % _ % _ % _ % _ %%
       (combination % _ % _ % _ % _ %%
         (combination % iheap % _ % _ % _ %% (reflexive % _) %%
           (eq_reflection % _ % _ %% Hc)) %%
         (reflexive % _)) %%
       (reflexive % _)))) %%
 (reflexive % _)))))) %%
                                  Hb) %%
                                (Lam (Hb: _) Hb: _.
                                  conjE % _ % _ % _ %% Hb %%
                                   (Lam (Hb: _) Hc: _.
                                     impI % _ % _ %%
                                      (Lam H2: _.
                                        equal_elim % _ % _ %%
                                         (symmetric % _ % _ %%
(combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
  (combination % op & (a = IVal 0) % _ % _ % _ %% (reflexive % _) %%
    (combination % _ % _ % _ % _ %%
      (combination % op = % _ % _ % _ %% (reflexive % _) %%
        (combination % iheap xb count % _ % _ % _ %% (reflexive % _) %%
          (transitive % _ % _ % _ %%
            (combination % theloc % _ % _ % _ %% (reflexive % _) %%
              (eq_reflection % _ % _ %%
                (equal_elim % _ % _ %%
                  (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                    (combination % op = x\<lfloor>self\<rfloor> % _ % _ % _ %%
                      (reflexive % _) %%
                      (combination % Ref % _ % _ % _ %% (reflexive % _) %%
                        (eq_reflection % _ % _ %%
                          (equal_elim % _ % _ %%
                            (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                              (transitive % _ % _ % _ %%
                                (combination % _ % _ % _ % _ %%
                                  (combination % op = % _ % _ % _ %%
                                    (reflexive % _) %%
                                    (eq_reflection % _ % _ %% H)) %%
                                  (reflexive % _)) %%
                                (eq_reflection % _ % _ %% (ref.inject % _ % _)))) %%
                            Ha))))) %%
                  H))) %%
            (eq_reflection % _ % _ %% (simps % _))))) %%
      (reflexive % _))))) %%
                                         (impCE % _ % _ % _ %%
(equal_elim % _ % _ %%
  (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
    (eq_reflection % _ % _ %%
      (imp_cong % _ % _ % _ % _ %% (meta_eq_to_obj_eq % _ % _ %% (reflexive % _)) %%
        (Lam Hb: _.
          meta_eq_to_obj_eq % _ % _ %%
           (equal_elim % _ % _ %%
             (symmetric % _ % _ %%
               (combination % _ % _ % _ % _ %%
                 (combination % op == % _ % _ % _ %% (reflexive % _) %%
                   (transitive % _ % _ % _ %%
                     (eq_reflection % _ % _ %%
                       (imp_cong % _ % _ % _ % _ %%
                         (meta_eq_to_obj_eq % _ % _ %%
                           (equal_elim % _ % _ %%
                             (symmetric % _ % _ %%
                               (combination % _ % _ % _ % _ %%
                                 (combination % op == % _ % _ % _ %%
                                   (reflexive % _) %%
                                   (transitive % _ % _ % _ %%
                                     (combination % op < 0 % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (transitive % _ % _ % _ %%
                                         (combination % _ % _ % _ % _ %%
(combination % _ % _ % _ % _ %%
  (combination % iheap % _ % _ % _ %% (reflexive % _) %%
    (combination % _ % _ % _ % _ %%
      (combination % _ % _ % _ % _ %%
        (combination % obj_ifieldupdate xa % _ % _ % _ %% (reflexive % _) %%
          (eq_reflection % _ % _ %%
            (equal_elim % _ % _ %%
              (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                (transitive % _ % _ % _ %%
                  (combination % _ % _ % _ % _ %%
                    (combination % op = % _ % _ % _ %% (reflexive % _) %%
                      (eq_reflection % _ % _ %% H)) %%
                    (reflexive % _)) %%
                  (eq_reflection % _ % _ %% (ref.inject % _ % _)))) %%
              Ha))) %%
        (reflexive % _)) %%
      (reflexive % _))) %%
  (reflexive % _)) %%
(transitive % _ % _ % _ %%
  (combination % theloc % _ % _ % _ %% (reflexive % _) %%
    (eq_reflection % _ % _ %%
      (equal_elim % _ % _ %%
        (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
          (combination % op = x\<lfloor>self\<rfloor> % _ % _ % _ %%
            (reflexive % _) %%
            (combination % Ref % _ % _ % _ %% (reflexive % _) %%
              (eq_reflection % _ % _ %%
                (equal_elim % _ % _ %%
                  (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                    (transitive % _ % _ % _ %%
                      (combination % _ % _ % _ % _ %%
                        (combination % op = % _ % _ % _ %% (reflexive % _) %%
                          (eq_reflection % _ % _ %% H)) %%
                        (reflexive % _)) %%
                      (eq_reflection % _ % _ %% (ref.inject % _ % _)))) %%
                  Ha))))) %%
        H))) %%
  (eq_reflection % _ % _ %% (simps % _)))) %%
                                         (eq_reflection % _ % _ %%
(ilfdUpdSame % _ % _ % _ % _)))) %%
                                     (Eq_TrueI % _ %%
                                       (ccontr % _ %%
                                         (Lam H: _.
equal_elim % _ % _ %%
 (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
   (transitive % _ % _ % _ %%
     (transitive % _ % _ % _ %%
       (combination % _ % _ % _ % _ %%
         (combination % op <= % _ % _ % _ %% (reflexive % _) %%
           (transitive % _ % _ % _ %%
             (transitive % _ % _ % _ %%
               (combination % _ % _ % _ % _ %%
                 (combination % op + % _ % _ % _ %% (reflexive % _) %%
                   (transitive % _ % _ % _ %% (zdiff_def % _ % _) %%
                     (combination % op + xa<aa\<bullet>count> % _ % _ % _ %%
                       (reflexive % _) %%
                       (eq_reflection % _ % _ %% bin_arith_simps_13)))) %%
                 (reflexive % _)) %%
               (equal_elim % _ % _ %%
                 (eq_cong2 % _ % _ % _ %%
                   (equal_elim % _ % _ %%
                     (symmetric % _ % _ %%
                       (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                         (combination % _ % _ % _ % _ %%
                           (combination % op = % _ % _ % _ %% (reflexive % _) %%
                             (combination % _ % _ % _ % _ %%
                               (combination % op + % _ % _ % _ %% (reflexive % _) %%
                                 (eq_reflection % _ % _ %%
                                   (equal_elim % _ % _ %%
                                     (combination % Trueprop % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (combination % _ % _ % _ % _ %%
                                         (combination % op = % _ % _ % _ %%
(reflexive % _) %%
(combination % op * Numeral1 % _ % _ % _ %% (reflexive % _) %%
  (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                                         (reflexive % _))) %%
                                     (zmult_1_right % _)))) %%
                               (eq_reflection % _ % _ %%
                                 (equal_elim % _ % _ %%
                                   (combination % Trueprop % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (combination % _ % _ % _ % _ %%
                                       (combination % op = % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (combination % op + xa<aa\<bullet>count> %
_ %
_ %
_ %%
(reflexive % _) %%
(eq_reflection % _ % _ %% (HOL.sym % _ % _ %% int_numeral_0_eq_0)))) %%
                                       (reflexive % _))) %%
                                   (zadd_0_right % _))))) %%
                           (reflexive % _)))) %%
                     (HOL.refl % _))) %%
                 (eq_reflection % _ % _ %%
                   (HOL.trans % _ % _ % _ %%
                     (equal_elim % _ % _ %%
                       (symmetric % _ % _ %%
                         (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                           (transitive % _ % _ % _ %%
                             (combination % _ % _ % _ % _ %%
                               (combination % op = % _ % _ % _ %% (reflexive % _) %%
                                 (transitive % _ % _ % _ %%
                                   (transitive % _ % _ % _ %%
                                     (combination % _ % _ % _ % _ %%
                                       (combination % op + % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (eq_reflection % _ % _ %%
(zadd_ac_2 % _ % _))) %%
                                       (reflexive % _)) %%
                                     (eq_reflection % _ % _ %%
                                       (zadd_ac_2 % _ % _))) %%
                                   (transitive % _ % _ % _ %%
                                     (eq_reflection % _ % _ %%
                                       (zadd_ac_3 % _ % _ % _)) %%
                                     (combination % op + -1 % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (eq_reflection % _ % _ %%
                                         (zadd_ac_2 % _ % _)))))) %%
                               (combination % _ % _ % _ % _ %%
                                 (combination % op + % _ % _ % _ %% (reflexive % _) %%
                                   (eq_reflection % _ % _ %%
                                     (equal_elim % _ % _ %%
                                       (combination % Trueprop % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (combination % _ % _ % _ % _ %%
(combination % op = % _ % _ % _ %% (reflexive % _) %%
  (combination % op * -1 % _ % _ % _ %% (reflexive % _) %%
    (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
(reflexive % _))) %%
                                       (zmult_1_right % _)))) %%
                                 (transitive % _ % _ % _ %%
                                   (combination % _ % _ % _ % _ %%
                                     (combination % op + % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (eq_reflection % _ % _ %%
                                         (equal_elim % _ % _ %%
(combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
  (combination % _ % _ % _ % _ %%
    (combination % op = % _ % _ % _ %% (reflexive % _) %%
      (combination % op * 2 % _ % _ % _ %% (reflexive % _) %%
        (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
    (reflexive % _))) %%
(zmult_1_right % _)))) %%
                                     (reflexive % _)) %%
                                   (eq_reflection % _ % _ %%
                                     (zadd_ac_2 % _ % _))))) %%
                             (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
                       TrueI) %%
                     (HOL.trans % _ % _ % _ %%
                       (left_zadd_zmult_distrib % _ % _ % _ % _) %%
                       (equal_elim % _ % _ %%
                         (symmetric % _ % _ %%
                           (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                             (transitive % _ % _ % _ %%
                               (combination % _ % _ % _ % _ %%
                                 (combination % op = % _ % _ % _ %% (reflexive % _) %%
                                   (combination % _ % _ % _ % _ %%
                                     (combination % op + % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (transitive % _ % _ % _ %%
                                         (transitive % _ % _ % _ %%
(combination % _ % _ % _ % _ %%
  (combination % op * % _ % _ % _ %% (reflexive % _) %%
    (transitive % _ % _ % _ %%
      (eq_reflection % _ % _ %% (bin_arith_simps_11 % _ % _)) %%
      (combination % number_of % _ % _ % _ %% (reflexive % _) %%
        (transitive % _ % _ % _ %%
          (eq_reflection % _ % _ %% (bin_arith_simps_6 % _)) %%
          (transitive % _ % _ % _ %%
            (eq_reflection % _ % _ %% (bin_arith_simps_18 % _)) %%
            (combination % _ % _ % _ % _ %%
              (combination % op BIT % _ % _ % _ %% (reflexive % _) %%
                (transitive % _ % _ % _ %%
                  (eq_reflection % _ % _ %% (bin_arith_simps_17 % _)) %%
                  (eq_reflection % _ % _ %% bin_arith_simps_32))) %%
              (reflexive % _))))))) %%
  (reflexive % _)) %%
(eq_reflection % _ % _ %% (bin_arith_simps_14 % _ % _))) %%
                                         (combination % number_of % _ % _ % _ %%
(reflexive % _) %%
(transitive % _ % _ % _ %% (eq_reflection % _ % _ %% (bin_arith_simps_30 % _ % _)) %%
  (transitive % _ % _ % _ %%
    (combination % _ % _ % _ % _ %%
      (combination % bin_add % _ % _ % _ %% (reflexive % _) %%
        (transitive % _ % _ % _ %%
          (combination % _ % _ % _ % _ %%
            (combination % NCons % _ % _ % _ %% (reflexive % _) %%
              (eq_reflection % _ % _ %% (bin_arith_simps_9 % _))) %%
            (reflexive % _)) %%
          (eq_reflection % _ % _ %% bin_arith_simps_32))) %%
      (reflexive % _)) %%
    (eq_reflection % _ % _ %% (bin_arith_simps_5 % _))))))) %%
                                     (reflexive % _))) %%
                                 (combination % _ % _ % _ % _ %%
                                   (combination % op + % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (transitive % _ % _ % _ %%
                                       (eq_reflection % _ % _ %%
                                         (bin_arith_simps_14 % _ % _)) %%
                                       (combination % number_of % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (transitive % _ % _ % _ %%
(eq_reflection % _ % _ %% (bin_arith_simps_30 % _ % _)) %%
(transitive % _ % _ % _ %%
  (combination % _ % _ % _ % _ %%
    (combination % bin_add % _ % _ % _ %% (reflexive % _) %%
      (transitive % _ % _ % _ %%
        (combination % _ % _ % _ % _ %%
          (combination % NCons % _ % _ % _ %% (reflexive % _) %%
            (eq_reflection % _ % _ %% (bin_arith_simps_9 % _))) %%
          (reflexive % _)) %%
        (eq_reflection % _ % _ %% bin_arith_simps_32))) %%
    (reflexive % _)) %%
  (eq_reflection % _ % _ %% (bin_arith_simps_5 % _))))))) %%
                                   (eq_reflection % _ % _ %%
                                     (equal_elim % _ % _ %%
                                       (combination % Trueprop % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (combination % _ % _ % _ % _ %%
(combination % op = % _ % _ % _ %% (reflexive % _) %%
  (combination % op + xa<aa\<bullet>count> % _ % _ % _ %% (reflexive % _) %%
    (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% int_numeral_0_eq_0)))) %%
(reflexive % _))) %%
                                       (zadd_0_right % _))))) %%
                               (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
                         TrueI)))))) %%
             (combination % _ % _ % _ % _ %%
               (combination % op + % _ % _ % _ %% (reflexive % _) %%
                 (eq_reflection % _ % _ %% int_numeral_1_eq_1)) %%
               (reflexive % _)))) %%
         (eq_reflection % _ % _ %% (zadd_0 % _))) %%
       (eq_reflection % _ % _ %%
         (HOL.trans % _ % _ % _ %%
           (equal_elim % _ % _ %%
             (symmetric % _ % _ %%
               (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                 (transitive % _ % _ % _ %%
                   (combination % _ % _ % _ % _ %%
                     (combination % op = % _ % _ % _ %% (reflexive % _) %%
                       (combination % _ % _ % _ % _ %%
                         (combination % op <= % _ % _ % _ %% (reflexive % _) %%
                           (transitive % _ % _ % _ %%
                             (combination % _ % _ % _ % _ %%
                               (combination % op + % _ % _ % _ %% (reflexive % _) %%
                                 (eq_reflection % _ % _ %%
                                   (HOL.sym % _ % _ %% int_numeral_1_eq_1))) %%
                               (reflexive % _)) %%
                             (eq_reflection % _ % _ %% (zadd_ac_2 % _ % _)))) %%
                         (reflexive % _))) %%
                     (combination % _ % _ % _ % _ %%
                       (combination % op <= % _ % _ % _ %% (reflexive % _) %%
                         (combination % _ % _ % _ % _ %%
                           (combination % op + % _ % _ % _ %% (reflexive % _) %%
                             (eq_reflection % _ % _ %%
                               (equal_elim % _ % _ %%
                                 (combination % Trueprop % _ % _ % _ %%
                                   (reflexive % _) %%
                                   (combination % _ % _ % _ % _ %%
                                     (combination % op = % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (combination % _ % _ % _ % _ %%
                                         (combination % op * % _ % _ % _ %%
(reflexive % _) %%
(eq_reflection % _ % _ %% (HOL.sym % _ % _ %% int_numeral_1_eq_1))) %%
                                         (reflexive % _))) %%
                                     (reflexive % _))) %%
                                 (zmult_1 % _)))) %%
                           (eq_reflection % _ % _ %%
                             (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                       (transitive % _ % _ % _ %%
                         (transitive % _ % _ % _ %%
                           (combination % _ % _ % _ % _ %%
                             (combination % op + % _ % _ % _ %% (reflexive % _) %%
                               (eq_reflection % _ % _ %%
                                 (equal_elim % _ % _ %%
                                   (combination % Trueprop % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (combination % _ % _ % _ % _ %%
                                       (combination % op = % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (combination % _ % _ % _ % _ %%
(combination % op * % _ % _ % _ %% (reflexive % _) %%
  (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% int_numeral_1_eq_1))) %%
(reflexive % _))) %%
                                       (reflexive % _))) %%
                                   (zmult_1 % _)))) %%
                             (reflexive % _)) %%
                           (eq_reflection % _ % _ %% (zadd_ac_2 % _ % _))) %%
                         (eq_reflection % _ % _ %%
                           (equal_elim % _ % _ %%
                             (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                               (combination % _ % _ % _ % _ %%
                                 (combination % op = % _ % _ % _ %% (reflexive % _) %%
                                   (combination % _ % _ % _ % _ %%
                                     (combination % op + % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (eq_reflection % _ % _ %%
                                         (HOL.sym % _ % _ %% int_numeral_0_eq_0))) %%
                                     (reflexive % _))) %%
                                 (reflexive % _))) %%
                             (zadd_0 % _)))))) %%
                   (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
             TrueI) %%
           (HOL.trans % _ % _ % _ %% (le_add_iff1 % _ % _ % _ % _ % _) %%
             (equal_elim % _ % _ %%
               (symmetric % _ % _ %%
                 (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                   (transitive % _ % _ % _ %%
                     (combination % _ % _ % _ % _ %%
                       (combination % op = % _ % _ % _ %% (reflexive % _) %%
                         (combination % _ % _ % _ % _ %%
                           (combination % op <= % _ % _ % _ %% (reflexive % _) %%
                             (combination % _ % _ % _ % _ %%
                               (combination % op + % _ % _ % _ %% (reflexive % _) %%
                                 (combination % _ % _ % _ % _ %%
                                   (combination % op * % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (transitive % _ % _ % _ %%
                                       (eq_reflection % _ % _ %%
                                         (bin_arith_simps_26 % _ % _)) %%
                                       (combination % number_of % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (transitive % _ % _ % _ %%
(transitive % _ % _ % _ %%
  (combination % bin_add (bin.Pls BIT True) % _ % _ % _ %% (reflexive % _) %%
    (transitive % _ % _ % _ %% (eq_reflection % _ % _ %% (bin_arith_simps_19 % _)) %%
      (transitive % _ % _ % _ %%
        (combination % bin_pred % _ % _ % _ %% (reflexive % _) %%
          (transitive % _ % _ % _ %%
            (combination % _ % _ % _ % _ %%
              (combination % NCons % _ % _ % _ %% (reflexive % _) %%
                (eq_reflection % _ % _ %% bin_arith_simps_7)) %%
              (reflexive % _)) %%
            (eq_reflection % _ % _ %% bin_arith_simps_32))) %%
        (eq_reflection % _ % _ %% bin_arith_simps_1)))) %%
  (eq_reflection % _ % _ %% (bin_arith_simps_22 % _))) %%
(transitive % _ % _ % _ %% (eq_reflection % _ % _ %% (bin_arith_simps_17 % _)) %%
  (eq_reflection % _ % _ %% bin_arith_simps_32)))))) %%
                                   (reflexive % _))) %%
                               (eq_reflection % _ % _ %%
                                 (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                           (reflexive % _))) %%
                       (combination % _ % _ % _ % _ %%
                         (combination % op <= % _ % _ % _ %% (reflexive % _) %%
                           (combination % op + (Numeral0 * xa<aa\<bullet>count>) % _ %
                             _ %
                             _ %%
                             (reflexive % _) %%
                             (eq_reflection % _ % _ %%
                               (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                         (reflexive % _))) %%
                     (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
               TrueI))))) %%
     (transitive % _ % _ % _ %%
       (transitive % _ % _ % _ %%
         (combination % _ % _ % _ % _ %%
           (combination % op <= % _ % _ % _ %% (reflexive % _) %%
             (transitive % _ % _ % _ %%
               (combination % _ % _ % _ % _ %%
                 (combination % op + % _ % _ % _ %% (reflexive % _) %%
                   (transitive % _ % _ % _ %%
                     (combination % _ % _ % _ % _ %%
                       (combination % op * % _ % _ % _ %% (reflexive % _) %%
                         (eq_reflection % _ % _ %% int_numeral_0_eq_0)) %%
                       (reflexive % _)) %%
                     (eq_reflection % _ % _ %% (zmult_0 % _)))) %%
                 (reflexive % _)) %%
               (eq_reflection % _ % _ %% (zadd_0 % _)))) %%
           (eq_reflection % _ % _ %% int_numeral_0_eq_0)) %%
         (eq_reflection % _ % _ %%
           (HOL.trans % _ % _ % _ %%
             (equal_elim % _ % _ %%
               (symmetric % _ % _ %%
                 (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                   (transitive % _ % _ % _ %%
                     (combination % op = (1 <= 0) % _ % _ % _ %% (reflexive % _) %%
                       (combination % _ % _ % _ % _ %%
                         (combination % op <= % _ % _ % _ %% (reflexive % _) %%
                           (eq_reflection % _ % _ %% int_numeral_1_eq_1)) %%
                         (eq_reflection % _ % _ %% int_numeral_0_eq_0))) %%
                     (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
               TrueI) %%
             (le_number_of_eq_not_less % _ % _)))) %%
       (transitive % _ % _ % _ %%
         (combination % Not % _ % _ % _ %% (reflexive % _) %%
           (transitive % _ % _ % _ %%
             (transitive % _ % _ % _ %%
               (combination % _ % _ % _ % _ %%
                 (combination % op < % _ % _ % _ %% (reflexive % _) %%
                   (eq_reflection % _ % _ %% int_numeral_0_eq_0)) %%
                 (eq_reflection % _ % _ %% int_numeral_1_eq_1)) %%
               (eq_reflection % _ % _ %%
                 (HOL.trans % _ % _ % _ %%
                   (equal_elim % _ % _ %%
                     (symmetric % _ % _ %%
                       (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                         (transitive % _ % _ % _ %%
                           (combination % op = (0 < 1) % _ % _ % _ %%
                             (reflexive % _) %%
                             (combination % _ % _ % _ % _ %%
                               (combination % op < % _ % _ % _ %% (reflexive % _) %%
                                 (eq_reflection % _ % _ %% int_numeral_0_eq_0)) %%
                               (eq_reflection % _ % _ %% int_numeral_1_eq_1))) %%
                           (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
                     TrueI) %%
                   (less_number_of_eq_neg % _ % _)))) %%
             (transitive % _ % _ % _ %%
               (combination % neg % _ % _ % _ %% (reflexive % _) %%
                 (combination % number_of % _ % _ % _ %% (reflexive % _) %%
                   (transitive % _ % _ % _ %%
                     (transitive % _ % _ % _ %%
                       (combination % bin_add bin.Pls % _ % _ % _ %%
                         (reflexive % _) %%
                         (transitive % _ % _ % _ %%
                           (eq_reflection % _ % _ %% (bin_arith_simps_19 % _)) %%
                           (transitive % _ % _ % _ %%
                             (combination % bin_pred % _ % _ % _ %% (reflexive % _) %%
                               (transitive % _ % _ % _ %%
                                 (combination % _ % _ % _ % _ %%
                                   (combination % NCons % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (eq_reflection % _ % _ %% bin_arith_simps_7)) %%
                                   (reflexive % _)) %%
                                 (eq_reflection % _ % _ %% bin_arith_simps_32))) %%
                             (eq_reflection % _ % _ %% bin_arith_simps_1)))) %%
                       (eq_reflection % _ % _ %% (bin_arith_simps_22 % _))) %%
                     (eq_reflection % _ % _ %% bin_arith_simps_1)))) %%
               (Eq_TrueI % _ %% bin_rel_simps_11)))) %%
         (eq_reflection % _ % _ %% simp_thms_7))))) %%
 (thm % _ % _ % _ % _ %%
   (conjI % _ % _ %% (iffD1 % _ % _ %% (linorder_not_less % _ % _) %% H) %%
     (iffD1 % _ % _ %% (linorder_not_less % _ % _) %% Hb)))))))) %%
                                 (reflexive % _))) %%
                             (reflexive % _))) %%
                         (Lam Hb: _.
                           meta_eq_to_obj_eq % _ % _ %%
                            (equal_elim % _ % _ %%
                              (symmetric % _ % _ %%
                                (combination % _ % _ % _ % _ %%
                                  (combination % op == % _ % _ % _ %%
                                    (reflexive % _) %%
                                    (combination % op & (a = IVal 0) % _ % _ % _ %%
                                      (reflexive % _) %%
                                      (combination % _ % _ % _ % _ %%
                                        (combination % op = % _ % _ % _ %%
                                          (reflexive % _) %%
                                          (combination % iheap xb count % _ % _ % _ %%
 (reflexive % _) %%
 (transitive % _ % _ % _ %%
   (combination % theloc % _ % _ % _ %% (reflexive % _) %%
     (eq_reflection % _ % _ %%
       (equal_elim % _ % _ %%
         (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
           (combination % op = x\<lfloor>self\<rfloor> % _ % _ % _ %%
             (reflexive % _) %%
             (combination % Ref % _ % _ % _ %% (reflexive % _) %%
               (eq_reflection % _ % _ %%
                 (equal_elim % _ % _ %%
                   (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                     (transitive % _ % _ % _ %%
                       (combination % _ % _ % _ % _ %%
                         (combination % op = % _ % _ % _ %% (reflexive % _) %%
                           (eq_reflection % _ % _ %% H)) %%
                         (reflexive % _)) %%
                       (eq_reflection % _ % _ %% (ref.inject % _ % _)))) %%
                   Ha))))) %%
         H))) %%
   (eq_reflection % _ % _ %% (simps % _))))) %%
                                        (reflexive % _)))) %%
                                  (reflexive % _))) %%
                              (reflexive % _))))) %%
                     (eq_reflection % _ % _ %% (simp_thms_15 % _)))) %%
                 (reflexive % _))) %%
             (reflexive % _)))))) %%
  Hc) %%
(Lam Hc: _.
  swap % _ % _ %% Hc %%
   (Lam Hc: _.
     notI % _ %%
      (Lam Hd: _.
        impCE % _ % _ % _ %%
         (equal_elim % _ % _ %%
           (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
             (eq_reflection % _ % _ %%
               (imp_cong % _ % _ % _ % _ %%
                 (meta_eq_to_obj_eq % _ % _ %% (reflexive % _)) %%
                 (Lam Hb: _.
                   meta_eq_to_obj_eq % _ % _ %%
                    (equal_elim % _ % _ %%
                      (symmetric % _ % _ %%
                        (combination % _ % _ % _ % _ %%
                          (combination % op == % _ % _ % _ %% (reflexive % _) %%
                            (combination % _ % _ % _ % _ %%
                              (combination % op & % _ % _ % _ %% (reflexive % _) %%
                                (combination % op = xb % _ % _ % _ %%
                                  (reflexive % _) %%
                                  (combination % _ % _ % _ % _ %%
                                    (combination % _ % _ % _ % _ %%
                                      (combination % obj_ifieldupdate xa % _ % _ %
                                        _ %%
                                        (reflexive % _) %%
                                        (eq_reflection % _ % _ %%
                                          (equal_elim % _ % _ %%
 (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
   (transitive % _ % _ % _ %%
     (combination % _ % _ % _ % _ %%
       (combination % op = % _ % _ % _ %% (reflexive % _) %%
         (eq_reflection % _ % _ %% H)) %%
       (reflexive % _)) %%
     (eq_reflection % _ % _ %% (ref.inject % _ % _)))) %%
 Ha))) %%
                                      (reflexive % _)) %%
                                    (reflexive % _)))) %%
                              (reflexive % _))) %%
                          (reflexive % _))) %%
                      (reflexive % _)))))) %%
           Hb) %%
         (Lam H: _. notE % _ % _ %% H %% Hd) %%
         (Lam Hb: _.
           conjE % _ % _ % _ %% Hb %%
            (Lam (Hb: _) He: _.
              conjE % _ % _ % _ %% He %%
               (Lam (He: _) Hf: _.
                 equal_elim % _ % _ %%
                  (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                    (transitive % _ % _ % _ %%
                      (combination % Not % _ % _ % _ %% (reflexive % _) %%
                        (transitive % _ % _ % _ %%
                          (combination % _ % _ % _ % _ %%
                            (combination % op & % _ % _ % _ %% (reflexive % _) %%
                              (eq_reflection % _ % _ %% (simp_thms_6 % _))) %%
                            (transitive % _ % _ % _ %%
                              (combination % _ % _ % _ % _ %%
                                (combination % op = % _ % _ % _ %% (reflexive % _) %%
                                  (eq_reflection % _ % _ %%
                                    (ilfdUpdSame % _ % _ % _ % _))) %%
                                (reflexive % _)) %%
                              (Eq_TrueI % _ %%
                                (ccontr % _ %%
                                  (Lam Hb: _.
                                    linorder_neqE % _ % _ % _ %% Hb %%
                                     (Lam Hb: _.
                                       equal_elim % _ % _ %%
                                        (combination % Trueprop % _ % _ % _ %%
                                          (reflexive % _) %%
                                          (transitive % _ % _ % _ %%
 (transitive % _ % _ % _ %%
   (combination % _ % _ % _ % _ %%
     (combination % op <= % _ % _ % _ %% (reflexive % _) %%
       (combination % _ % _ % _ % _ %%
         (combination % op + % _ % _ % _ %% (reflexive % _) %%
           (transitive % _ % _ % _ %%
             (combination % _ % _ % _ % _ %%
               (combination % op + % _ % _ % _ %% (reflexive % _) %%
                 (transitive % _ % _ % _ %% (zdiff_def % _ % _) %%
                   (combination % op + xa<aa\<bullet>count> % _ % _ % _ %%
                     (reflexive % _) %%
                     (eq_reflection % _ % _ %% bin_arith_simps_13)))) %%
               (reflexive % _)) %%
             (equal_elim % _ % _ %%
               (eq_cong2 % _ % _ % _ %%
                 (equal_elim % _ % _ %%
                   (symmetric % _ % _ %%
                     (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                       (combination % _ % _ % _ % _ %%
                         (combination % op = % _ % _ % _ %% (reflexive % _) %%
                           (transitive % _ % _ % _ %%
                             (combination % _ % _ % _ % _ %%
                               (combination % op + % _ % _ % _ %% (reflexive % _) %%
                                 (eq_reflection % _ % _ %%
                                   (equal_elim % _ % _ %%
                                     (combination % Trueprop % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (combination % _ % _ % _ % _ %%
                                         (combination % op = % _ % _ % _ %%
(reflexive % _) %%
(combination % op * Numeral0 % _ % _ % _ %% (reflexive % _) %%
  (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                                         (reflexive % _))) %%
                                     (zmult_1_right % _)))) %%
                               (eq_reflection % _ % _ %%
                                 (equal_elim % _ % _ %%
                                   (combination % Trueprop % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (combination % _ % _ % _ % _ %%
                                       (combination % op = % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (combination % op + xa<aa\<bullet>count> %
_ %
_ %
_ %%
(reflexive % _) %%
(eq_reflection % _ % _ %% (HOL.sym % _ % _ %% int_numeral_0_eq_0)))) %%
                                       (reflexive % _))) %%
                                   (zadd_0_right % _)))) %%
                             (eq_reflection % _ % _ %%
                               (equal_elim % _ % _ %%
                                 (combination % Trueprop % _ % _ % _ %%
                                   (reflexive % _) %%
                                   (combination % _ % _ % _ % _ %%
                                     (combination % op = % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (combination % _ % _ % _ % _ %%
                                         (combination % op + % _ % _ % _ %%
(reflexive % _) %%
(eq_reflection % _ % _ %% (HOL.sym % _ % _ %% int_numeral_0_eq_0))) %%
                                         (reflexive % _))) %%
                                     (reflexive % _))) %%
                                 (zadd_0 % _))))) %%
                         (reflexive % _)))) %%
                   (HOL.refl % _))) %%
               (eq_reflection % _ % _ %%
                 (HOL.trans % _ % _ % _ %%
                   (equal_elim % _ % _ %%
                     (symmetric % _ % _ %%
                       (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                         (transitive % _ % _ % _ %%
                           (combination % _ % _ % _ % _ %%
                             (combination % op = % _ % _ % _ %% (reflexive % _) %%
                               (transitive % _ % _ % _ %%
                                 (transitive % _ % _ % _ %%
                                   (combination % _ % _ % _ % _ %%
                                     (combination % op + % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (eq_reflection % _ % _ %%
                                         (zadd_ac_2 % _ % _))) %%
                                     (eq_reflection % _ % _ %%
                                       (HOL.sym % _ % _ %% int_numeral_1_eq_1))) %%
                                   (eq_reflection % _ % _ %% (zadd_ac_2 % _ % _))) %%
                                 (transitive % _ % _ % _ %%
                                   (eq_reflection % _ % _ %%
                                     (zadd_ac_3 % _ % _ % _)) %%
                                   (combination % op + -1 % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (eq_reflection % _ % _ %%
                                       (zadd_ac_2 % _ % _)))))) %%
                             (combination % _ % _ % _ % _ %%
                               (combination % op + % _ % _ % _ %% (reflexive % _) %%
                                 (eq_reflection % _ % _ %%
                                   (equal_elim % _ % _ %%
                                     (combination % Trueprop % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (combination % _ % _ % _ % _ %%
                                         (combination % op = % _ % _ % _ %%
(reflexive % _) %%
(combination % op * -1 % _ % _ % _ %% (reflexive % _) %%
  (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                                         (reflexive % _))) %%
                                     (zmult_1_right % _)))) %%
                               (transitive % _ % _ % _ %%
                                 (combination % _ % _ % _ % _ %%
                                   (combination % op + % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (eq_reflection % _ % _ %%
                                       (equal_elim % _ % _ %%
                                         (combination % Trueprop % _ % _ % _ %%
(reflexive % _) %%
(combination % _ % _ % _ % _ %%
  (combination % op = % _ % _ % _ %% (reflexive % _) %%
    (combination % op * Numeral1 % _ % _ % _ %% (reflexive % _) %%
      (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
  (reflexive % _))) %%
                                         (zmult_1_right % _)))) %%
                                   (reflexive % _)) %%
                                 (eq_reflection % _ % _ %% (zadd_ac_2 % _ % _))))) %%
                           (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
                     TrueI) %%
                   (HOL.trans % _ % _ % _ %%
                     (left_zadd_zmult_distrib % _ % _ % _ % _) %%
                     (equal_elim % _ % _ %%
                       (symmetric % _ % _ %%
                         (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                           (transitive % _ % _ % _ %%
                             (combination % _ % _ % _ % _ %%
                               (combination % op = % _ % _ % _ %% (reflexive % _) %%
                                 (transitive % _ % _ % _ %%
                                   (combination % _ % _ % _ % _ %%
                                     (combination % op + % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (transitive % _ % _ % _ %%
                                         (transitive % _ % _ % _ %%
(combination % _ % _ % _ % _ %%
  (combination % op * % _ % _ % _ %% (reflexive % _) %%
    (transitive % _ % _ % _ %%
      (eq_reflection % _ % _ %% (bin_arith_simps_11 % _ % _)) %%
      (combination % number_of % _ % _ % _ %% (reflexive % _) %%
        (transitive % _ % _ % _ %%
          (eq_reflection % _ % _ %% (bin_arith_simps_6 % _)) %%
          (transitive % _ % _ % _ %%
            (eq_reflection % _ % _ %% (bin_arith_simps_17 % _)) %%
            (eq_reflection % _ % _ %% bin_arith_simps_32)))))) %%
  (reflexive % _)) %%
(eq_reflection % _ % _ %% (bin_arith_simps_14 % _ % _))) %%
                                         (combination % number_of % _ % _ % _ %%
(reflexive % _) %%
(eq_reflection % _ % _ %% (bin_arith_simps_9 % _))))) %%
                                     (reflexive % _)) %%
                                   (eq_reflection % _ % _ %%
                                     (equal_elim % _ % _ %%
                                       (combination % Trueprop % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (combination % _ % _ % _ % _ %%
(combination % op = % _ % _ % _ %% (reflexive % _) %%
  (combination % _ % _ % _ % _ %%
    (combination % op + % _ % _ % _ %% (reflexive % _) %%
      (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% int_numeral_0_eq_0))) %%
    (reflexive % _))) %%
(reflexive % _))) %%
                                       (zadd_0 % _))))) %%
                               (transitive % _ % _ % _ %%
                                 (combination % _ % _ % _ % _ %%
                                   (combination % op + % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (transitive % _ % _ % _ %%
                                       (eq_reflection % _ % _ %%
                                         (bin_arith_simps_14 % _ % _)) %%
                                       (combination % number_of % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (eq_reflection % _ % _ %%
(bin_arith_simps_9 % _))))) %%
                                   (eq_reflection % _ % _ %%
                                     (equal_elim % _ % _ %%
                                       (combination % Trueprop % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (combination % _ % _ % _ % _ %%
(combination % op = % _ % _ % _ %% (reflexive % _) %%
  (combination % op + xa<aa\<bullet>count> % _ % _ % _ %% (reflexive % _) %%
    (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% int_numeral_0_eq_0)))) %%
(reflexive % _))) %%
                                       (zadd_0_right % _)))) %%
                                 (eq_reflection % _ % _ %%
                                   (equal_elim % _ % _ %%
                                     (combination % Trueprop % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (combination % _ % _ % _ % _ %%
                                         (combination % op = % _ % _ % _ %%
(reflexive % _) %%
(combination % _ % _ % _ % _ %%
  (combination % op + % _ % _ % _ %% (reflexive % _) %%
    (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% int_numeral_0_eq_0))) %%
  (reflexive % _))) %%
                                         (reflexive % _))) %%
                                     (zadd_0 % _))))) %%
                             (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
                       TrueI))))))) %%
         (eq_reflection % _ % _ %% (zadd_0 % _)))) %%
     (eq_reflection % _ % _ %% (zadd_0 % _))) %%
   (eq_reflection % _ % _ %%
     (HOL.trans % _ % _ % _ %%
       (equal_elim % _ % _ %%
         (symmetric % _ % _ %%
           (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
             (transitive % _ % _ % _ %%
               (combination % _ % _ % _ % _ %%
                 (combination % op = % _ % _ % _ %% (reflexive % _) %%
                   (combination % _ % _ % _ % _ %%
                     (combination % op <= % _ % _ % _ %% (reflexive % _) %%
                       (combination % op + xa<aa\<bullet>count> % _ % _ % _ %%
                         (reflexive % _) %%
                         (eq_reflection % _ % _ %%
                           (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                     (reflexive % _))) %%
                 (combination % _ % _ % _ % _ %%
                   (combination % op <= % _ % _ % _ %% (reflexive % _) %%
                     (combination % _ % _ % _ % _ %%
                       (combination % op + % _ % _ % _ %% (reflexive % _) %%
                         (eq_reflection % _ % _ %%
                           (equal_elim % _ % _ %%
                             (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                               (combination % _ % _ % _ % _ %%
                                 (combination % op = % _ % _ % _ %% (reflexive % _) %%
                                   (combination % _ % _ % _ % _ %%
                                     (combination % op * % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (eq_reflection % _ % _ %%
                                         (HOL.sym % _ % _ %% int_numeral_1_eq_1))) %%
                                     (reflexive % _))) %%
                                 (reflexive % _))) %%
                             (zmult_1 % _)))) %%
                       (eq_reflection % _ % _ %%
                         (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                   (transitive % _ % _ % _ %%
                     (transitive % _ % _ % _ %%
                       (combination % _ % _ % _ % _ %%
                         (combination % op + % _ % _ % _ %% (reflexive % _) %%
                           (eq_reflection % _ % _ %%
                             (equal_elim % _ % _ %%
                               (combination % Trueprop % _ % _ % _ %%
                                 (reflexive % _) %%
                                 (combination % _ % _ % _ % _ %%
                                   (combination % op = % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (combination % _ % _ % _ % _ %%
                                       (combination % op * % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (eq_reflection % _ % _ %%
(HOL.sym % _ % _ %% int_numeral_1_eq_1))) %%
                                       (reflexive % _))) %%
                                   (reflexive % _))) %%
                               (zmult_1 % _)))) %%
                         (reflexive % _)) %%
                       (eq_reflection % _ % _ %% (zadd_ac_2 % _ % _))) %%
                     (eq_reflection % _ % _ %%
                       (equal_elim % _ % _ %%
                         (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                           (combination % _ % _ % _ % _ %%
                             (combination % op = % _ % _ % _ %% (reflexive % _) %%
                               (combination % _ % _ % _ % _ %%
                                 (combination % op + % _ % _ % _ %% (reflexive % _) %%
                                   (eq_reflection % _ % _ %%
                                     (HOL.sym % _ % _ %% int_numeral_0_eq_0))) %%
                                 (reflexive % _))) %%
                             (reflexive % _))) %%
                         (zadd_0 % _)))))) %%
               (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
         TrueI) %%
       (HOL.trans % _ % _ % _ %% (le_add_iff1 % _ % _ % _ % _ % _) %%
         (equal_elim % _ % _ %%
           (symmetric % _ % _ %%
             (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
               (transitive % _ % _ % _ %%
                 (combination % _ % _ % _ % _ %%
                   (combination % op = % _ % _ % _ %% (reflexive % _) %%
                     (combination % _ % _ % _ % _ %%
                       (combination % op <= % _ % _ % _ %% (reflexive % _) %%
                         (combination % _ % _ % _ % _ %%
                           (combination % op + % _ % _ % _ %% (reflexive % _) %%
                             (combination % _ % _ % _ % _ %%
                               (combination % op * % _ % _ % _ %% (reflexive % _) %%
                                 (transitive % _ % _ % _ %%
                                   (eq_reflection % _ % _ %%
                                     (bin_arith_simps_26 % _ % _)) %%
                                   (combination % number_of % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (transitive % _ % _ % _ %%
                                       (transitive % _ % _ % _ %%
                                         (combination % bin_add (bin.Pls BIT True) %
_ %
_ %
_ %%
(reflexive % _) %%
(transitive % _ % _ % _ %% (eq_reflection % _ % _ %% (bin_arith_simps_19 % _)) %%
  (transitive % _ % _ % _ %%
    (combination % bin_pred % _ % _ % _ %% (reflexive % _) %%
      (transitive % _ % _ % _ %%
        (combination % _ % _ % _ % _ %%
          (combination % NCons % _ % _ % _ %% (reflexive % _) %%
            (eq_reflection % _ % _ %% bin_arith_simps_7)) %%
          (reflexive % _)) %%
        (eq_reflection % _ % _ %% bin_arith_simps_32))) %%
    (eq_reflection % _ % _ %% bin_arith_simps_1)))) %%
                                         (eq_reflection % _ % _ %%
(bin_arith_simps_22 % _))) %%
                                       (transitive % _ % _ % _ %%
                                         (eq_reflection % _ % _ %%
(bin_arith_simps_17 % _)) %%
                                         (eq_reflection % _ % _ %%
bin_arith_simps_32)))))) %%
                               (reflexive % _))) %%
                           (eq_reflection % _ % _ %%
                             (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                       (reflexive % _))) %%
                   (combination % _ % _ % _ % _ %%
                     (combination % op <= % _ % _ % _ %% (reflexive % _) %%
                       (combination % op + (Numeral0 * xa<aa\<bullet>count>) % _ % _ %
                         _ %%
                         (reflexive % _) %%
                         (eq_reflection % _ % _ %%
                           (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                     (reflexive % _))) %%
                 (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
           TrueI))))) %%
 (transitive % _ % _ % _ %%
   (transitive % _ % _ % _ %%
     (combination % _ % _ % _ % _ %%
       (combination % op <= % _ % _ % _ %% (reflexive % _) %%
         (transitive % _ % _ % _ %%
           (combination % _ % _ % _ % _ %%
             (combination % op + % _ % _ % _ %% (reflexive % _) %%
               (transitive % _ % _ % _ %%
                 (combination % _ % _ % _ % _ %%
                   (combination % op * % _ % _ % _ %% (reflexive % _) %%
                     (eq_reflection % _ % _ %% int_numeral_0_eq_0)) %%
                   (reflexive % _)) %%
                 (eq_reflection % _ % _ %% (zmult_0 % _)))) %%
             (reflexive % _)) %%
           (eq_reflection % _ % _ %% (zadd_0 % _)))) %%
       (eq_reflection % _ % _ %% int_numeral_0_eq_0)) %%
     (eq_reflection % _ % _ %%
       (HOL.trans % _ % _ % _ %%
         (equal_elim % _ % _ %%
           (symmetric % _ % _ %%
             (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
               (transitive % _ % _ % _ %%
                 (combination % op = (1 <= 0) % _ % _ % _ %% (reflexive % _) %%
                   (combination % _ % _ % _ % _ %%
                     (combination % op <= % _ % _ % _ %% (reflexive % _) %%
                       (eq_reflection % _ % _ %% int_numeral_1_eq_1)) %%
                     (eq_reflection % _ % _ %% int_numeral_0_eq_0))) %%
                 (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
           TrueI) %%
         (le_number_of_eq_not_less % _ % _)))) %%
   (transitive % _ % _ % _ %%
     (combination % Not % _ % _ % _ %% (reflexive % _) %%
       (transitive % _ % _ % _ %%
         (transitive % _ % _ % _ %%
           (combination % _ % _ % _ % _ %%
             (combination % op < % _ % _ % _ %% (reflexive % _) %%
               (eq_reflection % _ % _ %% int_numeral_0_eq_0)) %%
             (eq_reflection % _ % _ %% int_numeral_1_eq_1)) %%
           (eq_reflection % _ % _ %%
             (HOL.trans % _ % _ % _ %%
               (equal_elim % _ % _ %%
                 (symmetric % _ % _ %%
                   (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                     (transitive % _ % _ % _ %%
                       (combination % op = (0 < 1) % _ % _ % _ %% (reflexive % _) %%
                         (combination % _ % _ % _ % _ %%
                           (combination % op < % _ % _ % _ %% (reflexive % _) %%
                             (eq_reflection % _ % _ %% int_numeral_0_eq_0)) %%
                           (eq_reflection % _ % _ %% int_numeral_1_eq_1))) %%
                       (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
                 TrueI) %%
               (less_number_of_eq_neg % _ % _)))) %%
         (transitive % _ % _ % _ %%
           (combination % neg % _ % _ % _ %% (reflexive % _) %%
             (combination % number_of % _ % _ % _ %% (reflexive % _) %%
               (transitive % _ % _ % _ %%
                 (transitive % _ % _ % _ %%
                   (combination % bin_add bin.Pls % _ % _ % _ %% (reflexive % _) %%
                     (transitive % _ % _ % _ %%
                       (eq_reflection % _ % _ %% (bin_arith_simps_19 % _)) %%
                       (transitive % _ % _ % _ %%
                         (combination % bin_pred % _ % _ % _ %% (reflexive % _) %%
                           (transitive % _ % _ % _ %%
                             (combination % _ % _ % _ % _ %%
                               (combination % NCons % _ % _ % _ %% (reflexive % _) %%
                                 (eq_reflection % _ % _ %% bin_arith_simps_7)) %%
                               (reflexive % _)) %%
                             (eq_reflection % _ % _ %% bin_arith_simps_32))) %%
                         (eq_reflection % _ % _ %% bin_arith_simps_1)))) %%
                   (eq_reflection % _ % _ %% (bin_arith_simps_22 % _))) %%
                 (eq_reflection % _ % _ %% bin_arith_simps_1)))) %%
           (Eq_TrueI % _ %% bin_rel_simps_11)))) %%
     (eq_reflection % _ % _ %% simp_thms_7))))) %%
                                        (thm % _ % _ % _ % _ %%
                                          (conjI % _ % _ %%
 (iffD2 % _ % _ %% (add1_zle_eq % _ % _) %% Hb) %%
 (iffD2 % _ % _ %% (add1_zle_eq % _ % _) %%
   (equal_elim % _ % _ %%
     (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
       (combination % op < 0 % _ % _ % _ %% (reflexive % _) %%
         (combination % iheap xa count % _ % _ % _ %% (reflexive % _) %%
           (transitive % _ % _ % _ %%
             (combination % theloc % _ % _ % _ %% (reflexive % _) %%
               (eq_reflection % _ % _ %%
                 (equal_elim % _ % _ %%
                   (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                     (combination % op = x\<lfloor>self\<rfloor> % _ % _ % _ %%
                       (reflexive % _) %%
                       (combination % Ref % _ % _ % _ %% (reflexive % _) %%
                         (eq_reflection % _ % _ %%
                           (equal_elim % _ % _ %%
                             (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                               (transitive % _ % _ % _ %%
                                 (combination % _ % _ % _ % _ %%
                                   (combination % op = % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (eq_reflection % _ % _ %% H)) %%
                                   (reflexive % _)) %%
                                 (eq_reflection % _ % _ %% (ref.inject % _ % _)))) %%
                             Ha))))) %%
                   H))) %%
             (eq_reflection % _ % _ %% (simps % _)))))) %%
     H2))))) %%
                                     (Lam H: _.
                                       equal_elim % _ % _ %%
                                        (combination % Trueprop % _ % _ % _ %%
                                          (reflexive % _) %%
                                          (transitive % _ % _ % _ %%
 (transitive % _ % _ % _ %%
   (combination % _ % _ % _ % _ %%
     (combination % op <= % _ % _ % _ %% (reflexive % _) %%
       (transitive % _ % _ % _ %%
         (combination % op + (xa<aa\<bullet>count> + 1) % _ % _ % _ %%
           (reflexive % _) %%
           (eq_reflection % _ % _ %% (zadd_0 % _))) %%
         (equal_elim % _ % _ %%
           (eq_cong2 % _ % _ % _ %%
             (equal_elim % _ % _ %%
               (symmetric % _ % _ %%
                 (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                   (combination % _ % _ % _ % _ %%
                     (combination % op = % _ % _ % _ %% (reflexive % _) %%
                       (combination % _ % _ % _ % _ %%
                         (combination % op + % _ % _ % _ %% (reflexive % _) %%
                           (eq_reflection % _ % _ %%
                             (equal_elim % _ % _ %%
                               (combination % Trueprop % _ % _ % _ %%
                                 (reflexive % _) %%
                                 (combination % _ % _ % _ % _ %%
                                   (combination % op = % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (combination % op * 2 % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (eq_reflection % _ % _ %%
                                         (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                                   (reflexive % _))) %%
                               (zmult_1_right % _)))) %%
                         (eq_reflection % _ % _ %%
                           (equal_elim % _ % _ %%
                             (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                               (combination % _ % _ % _ % _ %%
                                 (combination % op = % _ % _ % _ %% (reflexive % _) %%
                                   (combination % op + xa<aa\<bullet>count> % _ % _ %
                                     _ %%
                                     (reflexive % _) %%
                                     (eq_reflection % _ % _ %%
                                       (HOL.sym % _ % _ %% int_numeral_0_eq_0)))) %%
                                 (reflexive % _))) %%
                             (zadd_0_right % _))))) %%
                     (reflexive % _)))) %%
               (HOL.refl % _))) %%
           (eq_reflection % _ % _ %%
             (HOL.trans % _ % _ % _ %%
               (equal_elim % _ % _ %%
                 (symmetric % _ % _ %%
                   (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                     (transitive % _ % _ % _ %%
                       (combination % _ % _ % _ % _ %%
                         (combination % op = % _ % _ % _ %% (reflexive % _) %%
                           (transitive % _ % _ % _ %%
                             (transitive % _ % _ % _ %%
                               (combination % _ % _ % _ % _ %%
                                 (combination % op + % _ % _ % _ %% (reflexive % _) %%
                                   (combination % op + xa<aa\<bullet>count> % _ % _ %
                                     _ %%
                                     (reflexive % _) %%
                                     (eq_reflection % _ % _ %%
                                       (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                                 (eq_reflection % _ % _ %%
                                   (HOL.sym % _ % _ %% int_numeral_1_eq_1))) %%
                               (eq_reflection % _ % _ %% (zadd_ac_2 % _ % _))) %%
                             (eq_reflection % _ % _ %% (zadd_ac_3 % _ % _ % _)))) %%
                         (transitive % _ % _ % _ %%
                           (combination % _ % _ % _ % _ %%
                             (combination % op + % _ % _ % _ %% (reflexive % _) %%
                               (eq_reflection % _ % _ %%
                                 (equal_elim % _ % _ %%
                                   (combination % Trueprop % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (combination % _ % _ % _ % _ %%
                                       (combination % op = % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (combination % op * Numeral1 % _ % _ % _ %%
(reflexive % _) %%
(eq_reflection % _ % _ %% (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                                       (reflexive % _))) %%
                                   (zmult_1_right % _)))) %%
                             (transitive % _ % _ % _ %%
                               (combination % _ % _ % _ % _ %%
                                 (combination % op + % _ % _ % _ %% (reflexive % _) %%
                                   (eq_reflection % _ % _ %%
                                     (equal_elim % _ % _ %%
                                       (combination % Trueprop % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (combination % _ % _ % _ % _ %%
(combination % op = % _ % _ % _ %% (reflexive % _) %%
  (combination % op * Numeral1 % _ % _ % _ %% (reflexive % _) %%
    (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
(reflexive % _))) %%
                                       (zmult_1_right % _)))) %%
                                 (reflexive % _)) %%
                               (eq_reflection % _ % _ %% (zadd_ac_2 % _ % _)))) %%
                           (eq_reflection % _ % _ %% (zadd_ac_3 % _ % _ % _)))) %%
                       (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
                 TrueI) %%
               (HOL.trans % _ % _ % _ %% (left_zadd_zmult_distrib % _ % _ % _ % _) %%
                 (equal_elim % _ % _ %%
                   (symmetric % _ % _ %%
                     (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                       (transitive % _ % _ % _ %%
                         (combination % _ % _ % _ % _ %%
                           (combination % op = % _ % _ % _ %% (reflexive % _) %%
                             (combination % _ % _ % _ % _ %%
                               (combination % op + % _ % _ % _ %% (reflexive % _) %%
                                 (transitive % _ % _ % _ %%
                                   (transitive % _ % _ % _ %%
                                     (combination % _ % _ % _ % _ %%
                                       (combination % op * % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (transitive % _ % _ % _ %%
(eq_reflection % _ % _ %% (bin_arith_simps_11 % _ % _)) %%
(combination % number_of % _ % _ % _ %% (reflexive % _) %%
  (transitive % _ % _ % _ %%
    (eq_reflection % _ % _ %% (bin_arith_simps_25 % _ % _)) %%
    (transitive % _ % _ % _ %%
      (combination % _ % _ % _ % _ %%
        (combination % NCons % _ % _ % _ %% (reflexive % _) %%
          (transitive % _ % _ % _ %%
            (combination % bin_add bin.Pls % _ % _ % _ %% (reflexive % _) %%
              (eq_reflection % _ % _ %% bin_arith_simps_3)) %%
            (eq_reflection % _ % _ %% (bin_arith_simps_5 % _)))) %%
        (reflexive % _)) %%
      (eq_reflection % _ % _ %% (bin_arith_simps_36 % _ % _ % _))))))) %%
                                       (reflexive % _)) %%
                                     (eq_reflection % _ % _ %%
                                       (bin_arith_simps_14 % _ % _))) %%
                                   (combination % number_of % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (transitive % _ % _ % _ %%
                                       (eq_reflection % _ % _ %%
                                         (bin_arith_simps_31 % _ % _)) %%
                                       (transitive % _ % _ % _ %%
                                         (combination % _ % _ % _ % _ %%
(combination % NCons % _ % _ % _ %% (reflexive % _) %%
  (transitive % _ % _ % _ %%
    (eq_reflection % _ % _ %% (bin_arith_simps_30 % _ % _)) %%
    (transitive % _ % _ % _ %%
      (combination % _ % _ % _ % _ %%
        (combination % bin_add % _ % _ % _ %% (reflexive % _) %%
          (transitive % _ % _ % _ %%
            (combination % _ % _ % _ % _ %%
              (combination % NCons % _ % _ % _ %% (reflexive % _) %%
                (eq_reflection % _ % _ %% (bin_arith_simps_9 % _))) %%
              (reflexive % _)) %%
            (eq_reflection % _ % _ %% bin_arith_simps_32))) %%
        (reflexive % _)) %%
      (eq_reflection % _ % _ %% (bin_arith_simps_5 % _))))) %%
(reflexive % _)) %%
                                         (eq_reflection % _ % _ %%
(bin_arith_simps_36 % _ % _ % _))))))) %%
                               (reflexive % _))) %%
                           (combination % _ % _ % _ % _ %%
                             (combination % op + % _ % _ % _ %% (reflexive % _) %%
                               (transitive % _ % _ % _ %%
                                 (eq_reflection % _ % _ %%
                                   (bin_arith_simps_14 % _ % _)) %%
                                 (combination % number_of % _ % _ % _ %%
                                   (reflexive % _) %%
                                   (transitive % _ % _ % _ %%
                                     (eq_reflection % _ % _ %%
                                       (bin_arith_simps_31 % _ % _)) %%
                                     (transitive % _ % _ % _ %%
                                       (combination % _ % _ % _ % _ %%
                                         (combination % NCons % _ % _ % _ %%
(reflexive % _) %%
(transitive % _ % _ % _ %% (eq_reflection % _ % _ %% (bin_arith_simps_30 % _ % _)) %%
  (transitive % _ % _ % _ %%
    (combination % _ % _ % _ % _ %%
      (combination % bin_add % _ % _ % _ %% (reflexive % _) %%
        (transitive % _ % _ % _ %%
          (combination % _ % _ % _ % _ %%
            (combination % NCons % _ % _ % _ %% (reflexive % _) %%
              (eq_reflection % _ % _ %% (bin_arith_simps_9 % _))) %%
            (reflexive % _)) %%
          (eq_reflection % _ % _ %% bin_arith_simps_32))) %%
      (reflexive % _)) %%
    (eq_reflection % _ % _ %% (bin_arith_simps_5 % _))))) %%
                                         (reflexive % _)) %%
                                       (eq_reflection % _ % _ %%
                                         (bin_arith_simps_36 % _ % _ % _))))))) %%
                             (eq_reflection % _ % _ %%
                               (equal_elim % _ % _ %%
                                 (combination % Trueprop % _ % _ % _ %%
                                   (reflexive % _) %%
                                   (combination % _ % _ % _ % _ %%
                                     (combination % op = % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (combination % op + xa<aa\<bullet>count> % _ %
                                         _ %
                                         _ %%
                                         (reflexive % _) %%
                                         (eq_reflection % _ % _ %%
(HOL.sym % _ % _ %% int_numeral_0_eq_0)))) %%
                                     (reflexive % _))) %%
                                 (zadd_0_right % _))))) %%
                         (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
                   TrueI))))))) %%
     (transitive % _ % _ % _ %%
       (transitive % _ % _ % _ %%
         (combination % op + 2 % _ % _ % _ %% (reflexive % _) %%
           (transitive % _ % _ % _ %% (zdiff_def % _ % _) %%
             (combination % op + xa<aa\<bullet>count> % _ % _ % _ %%
               (reflexive % _) %%
               (eq_reflection % _ % _ %% bin_arith_simps_13)))) %%
         (equal_elim % _ % _ %%
           (eq_cong2 % _ % _ % _ %%
             (equal_elim % _ % _ %%
               (symmetric % _ % _ %%
                 (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                   (combination % _ % _ % _ % _ %%
                     (combination % op = % _ % _ % _ %% (reflexive % _) %%
                       (combination % _ % _ % _ % _ %%
                         (combination % op + % _ % _ % _ %% (reflexive % _) %%
                           (eq_reflection % _ % _ %%
                             (equal_elim % _ % _ %%
                               (combination % Trueprop % _ % _ % _ %%
                                 (reflexive % _) %%
                                 (combination % _ % _ % _ % _ %%
                                   (combination % op = % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (combination % op * Numeral1 % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (eq_reflection % _ % _ %%
                                         (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                                   (reflexive % _))) %%
                               (zmult_1_right % _)))) %%
                         (eq_reflection % _ % _ %%
                           (equal_elim % _ % _ %%
                             (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                               (combination % _ % _ % _ % _ %%
                                 (combination % op = % _ % _ % _ %% (reflexive % _) %%
                                   (combination % op + xa<aa\<bullet>count> % _ % _ %
                                     _ %%
                                     (reflexive % _) %%
                                     (eq_reflection % _ % _ %%
                                       (HOL.sym % _ % _ %% int_numeral_0_eq_0)))) %%
                                 (reflexive % _))) %%
                             (zadd_0_right % _))))) %%
                     (reflexive % _)))) %%
               (HOL.refl % _))) %%
           (eq_reflection % _ % _ %%
             (HOL.trans % _ % _ % _ %%
               (equal_elim % _ % _ %%
                 (symmetric % _ % _ %%
                   (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                     (transitive % _ % _ % _ %%
                       (combination % _ % _ % _ % _ %%
                         (combination % op = % _ % _ % _ %% (reflexive % _) %%
                           (transitive % _ % _ % _ %%
                             (transitive % _ % _ % _ %%
                               (combination % op + 2 % _ % _ % _ %% (reflexive % _) %%
                                 (eq_reflection % _ % _ %% (zadd_ac_2 % _ % _))) %%
                               (eq_reflection % _ % _ %% (zadd_ac_3 % _ % _ % _))) %%
                             (combination % op + -1 % _ % _ % _ %% (reflexive % _) %%
                               (eq_reflection % _ % _ %% (zadd_ac_2 % _ % _))))) %%
                         (transitive % _ % _ % _ %%
                           (transitive % _ % _ % _ %%
                             (combination % _ % _ % _ % _ %%
                               (combination % op + % _ % _ % _ %% (reflexive % _) %%
                                 (eq_reflection % _ % _ %%
                                   (equal_elim % _ % _ %%
                                     (combination % Trueprop % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (combination % _ % _ % _ % _ %%
                                         (combination % op = % _ % _ % _ %%
(reflexive % _) %%
(combination % op * 2 % _ % _ % _ %% (reflexive % _) %%
  (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                                         (reflexive % _))) %%
                                     (zmult_1_right % _)))) %%
                               (combination % _ % _ % _ % _ %%
                                 (combination % op + % _ % _ % _ %% (reflexive % _) %%
                                   (eq_reflection % _ % _ %%
                                     (equal_elim % _ % _ %%
                                       (combination % Trueprop % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (combination % _ % _ % _ % _ %%
(combination % op = % _ % _ % _ %% (reflexive % _) %%
  (combination % op * -1 % _ % _ % _ %% (reflexive % _) %%
    (eq_reflection % _ % _ %% (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
(reflexive % _))) %%
                                       (zmult_1_right % _)))) %%
                                 (reflexive % _))) %%
                             (eq_reflection % _ % _ %% (zadd_ac_3 % _ % _ % _))) %%
                           (combination % op + -1 % _ % _ % _ %% (reflexive % _) %%
                             (eq_reflection % _ % _ %% (zadd_ac_2 % _ % _))))) %%
                       (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
                 TrueI) %%
               (HOL.trans % _ % _ % _ %% (left_zadd_zmult_distrib % _ % _ % _ % _) %%
                 (equal_elim % _ % _ %%
                   (symmetric % _ % _ %%
                     (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                       (transitive % _ % _ % _ %%
                         (combination % _ % _ % _ % _ %%
                           (combination % op = % _ % _ % _ %% (reflexive % _) %%
                             (combination % _ % _ % _ % _ %%
                               (combination % op + % _ % _ % _ %% (reflexive % _) %%
                                 (transitive % _ % _ % _ %%
                                   (transitive % _ % _ % _ %%
                                     (combination % _ % _ % _ % _ %%
                                       (combination % op * % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (transitive % _ % _ % _ %%
(eq_reflection % _ % _ %% (bin_arith_simps_11 % _ % _)) %%
(combination % number_of % _ % _ % _ %% (reflexive % _) %%
  (transitive % _ % _ % _ %% (eq_reflection % _ % _ %% (bin_arith_simps_22 % _)) %%
    (transitive % _ % _ % _ %% (eq_reflection % _ % _ %% (bin_arith_simps_18 % _)) %%
      (combination % _ % _ % _ % _ %%
        (combination % op BIT % _ % _ % _ %% (reflexive % _) %%
          (transitive % _ % _ % _ %%
            (eq_reflection % _ % _ %% (bin_arith_simps_17 % _)) %%
            (eq_reflection % _ % _ %% bin_arith_simps_32))) %%
        (reflexive % _))))))) %%
                                       (reflexive % _)) %%
                                     (eq_reflection % _ % _ %%
                                       (bin_arith_simps_14 % _ % _))) %%
                                   (combination % number_of % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (transitive % _ % _ % _ %%
                                       (eq_reflection % _ % _ %%
                                         (bin_arith_simps_30 % _ % _)) %%
                                       (transitive % _ % _ % _ %%
                                         (combination % _ % _ % _ % _ %%
(combination % bin_add % _ % _ % _ %% (reflexive % _) %%
  (transitive % _ % _ % _ %%
    (combination % _ % _ % _ % _ %%
      (combination % NCons % _ % _ % _ %% (reflexive % _) %%
        (eq_reflection % _ % _ %% (bin_arith_simps_9 % _))) %%
      (reflexive % _)) %%
    (eq_reflection % _ % _ %% bin_arith_simps_32))) %%
(reflexive % _)) %%
                                         (eq_reflection % _ % _ %%
(bin_arith_simps_5 % _))))))) %%
                               (reflexive % _))) %%
                           (combination % _ % _ % _ % _ %%
                             (combination % op + % _ % _ % _ %% (reflexive % _) %%
                               (transitive % _ % _ % _ %%
                                 (eq_reflection % _ % _ %%
                                   (bin_arith_simps_14 % _ % _)) %%
                                 (combination % number_of % _ % _ % _ %%
                                   (reflexive % _) %%
                                   (transitive % _ % _ % _ %%
                                     (eq_reflection % _ % _ %%
                                       (bin_arith_simps_30 % _ % _)) %%
                                     (transitive % _ % _ % _ %%
                                       (combination % _ % _ % _ % _ %%
                                         (combination % bin_add % _ % _ % _ %%
(reflexive % _) %%
(transitive % _ % _ % _ %%
  (combination % _ % _ % _ % _ %%
    (combination % NCons % _ % _ % _ %% (reflexive % _) %%
      (eq_reflection % _ % _ %% (bin_arith_simps_9 % _))) %%
    (reflexive % _)) %%
  (eq_reflection % _ % _ %% bin_arith_simps_32))) %%
                                         (reflexive % _)) %%
                                       (eq_reflection % _ % _ %%
                                         (bin_arith_simps_5 % _))))))) %%
                             (eq_reflection % _ % _ %%
                               (equal_elim % _ % _ %%
                                 (combination % Trueprop % _ % _ % _ %%
                                   (reflexive % _) %%
                                   (combination % _ % _ % _ % _ %%
                                     (combination % op = % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (combination % op + xa<aa\<bullet>count> % _ %
                                         _ %
                                         _ %%
                                         (reflexive % _) %%
                                         (eq_reflection % _ % _ %%
(HOL.sym % _ % _ %% int_numeral_0_eq_0)))) %%
                                     (reflexive % _))) %%
                                 (zadd_0_right % _))))) %%
                         (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
                   TrueI)))))) %%
       (combination % _ % _ % _ % _ %%
         (combination % op + % _ % _ % _ %% (reflexive % _) %%
           (eq_reflection % _ % _ %% int_numeral_1_eq_1)) %%
         (reflexive % _)))) %%
   (equal_elim % _ % _ %%
     (eq_cong2 % _ % _ % _ %%
       (equal_elim % _ % _ %%
         (symmetric % _ % _ %%
           (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
             (combination % _ % _ % _ % _ %%
               (combination % op = % _ % _ % _ %% (reflexive % _) %%
                 (combination % _ % _ % _ % _ %%
                   (combination % op <= % _ % _ % _ %% (reflexive % _) %%
                     (combination % _ % _ % _ % _ %%
                       (combination % op + % _ % _ % _ %% (reflexive % _) %%
                         (eq_reflection % _ % _ %%
                           (equal_elim % _ % _ %%
                             (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                               (combination % _ % _ % _ % _ %%
                                 (combination % op = % _ % _ % _ %% (reflexive % _) %%
                                   (combination % op * Numeral1 % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (eq_reflection % _ % _ %%
                                       (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                                 (reflexive % _))) %%
                             (zmult_1_right % _)))) %%
                       (reflexive % _))) %%
                   (eq_reflection % _ % _ %%
                     (equal_elim % _ % _ %%
                       (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                         (combination % _ % _ % _ % _ %%
                           (combination % op = % _ % _ % _ %% (reflexive % _) %%
                             (combination % op + xa<aa\<bullet>count> % _ % _ % _ %%
                               (reflexive % _) %%
                               (eq_reflection % _ % _ %%
                                 (HOL.sym % _ % _ %% int_numeral_0_eq_0)))) %%
                           (reflexive % _))) %%
                       (zadd_0_right % _))))) %%
               (reflexive % _)))) %%
         (HOL.refl % _))) %%
     (eq_reflection % _ % _ %%
       (HOL.trans % _ % _ % _ %%
         (equal_elim % _ % _ %%
           (symmetric % _ % _ %%
             (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
               (transitive % _ % _ % _ %%
                 (combination % _ % _ % _ % _ %%
                   (combination % op = % _ % _ % _ %% (reflexive % _) %%
                     (combination % _ % _ % _ % _ %%
                       (combination % op <= % _ % _ % _ %% (reflexive % _) %%
                         (eq_reflection % _ % _ %% (zadd_ac_2 % _ % _))) %%
                       (transitive % _ % _ % _ %%
                         (combination % _ % _ % _ % _ %%
                           (combination % op + % _ % _ % _ %% (reflexive % _) %%
                             (eq_reflection % _ % _ %%
                               (HOL.sym % _ % _ %% int_numeral_1_eq_1))) %%
                           (reflexive % _)) %%
                         (eq_reflection % _ % _ %% (zadd_ac_2 % _ % _))))) %%
                   (combination % _ % _ % _ % _ %%
                     (combination % op <= % _ % _ % _ %% (reflexive % _) %%
                       (transitive % _ % _ % _ %%
                         (combination % _ % _ % _ % _ %%
                           (combination % op + % _ % _ % _ %% (reflexive % _) %%
                             (eq_reflection % _ % _ %%
                               (equal_elim % _ % _ %%
                                 (combination % Trueprop % _ % _ % _ %%
                                   (reflexive % _) %%
                                   (combination % _ % _ % _ % _ %%
                                     (combination % op = % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (combination % op * 2 % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (eq_reflection % _ % _ %%
(HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                                     (reflexive % _))) %%
                                 (zmult_1_right % _)))) %%
                           (reflexive % _)) %%
                         (eq_reflection % _ % _ %% (zadd_ac_2 % _ % _)))) %%
                     (transitive % _ % _ % _ %%
                       (combination % _ % _ % _ % _ %%
                         (combination % op + % _ % _ % _ %% (reflexive % _) %%
                           (eq_reflection % _ % _ %%
                             (equal_elim % _ % _ %%
                               (combination % Trueprop % _ % _ % _ %%
                                 (reflexive % _) %%
                                 (combination % _ % _ % _ % _ %%
                                   (combination % op = % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (combination % op * Numeral1 % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (eq_reflection % _ % _ %%
                                         (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                                   (reflexive % _))) %%
                               (zmult_1_right % _)))) %%
                         (reflexive % _)) %%
                       (eq_reflection % _ % _ %% (zadd_ac_2 % _ % _))))) %%
                 (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
           TrueI) %%
         (HOL.trans % _ % _ % _ %% (le_add_iff1 % _ % _ % _ % _ % _) %%
           (equal_elim % _ % _ %%
             (symmetric % _ % _ %%
               (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                 (transitive % _ % _ % _ %%
                   (combination % _ % _ % _ % _ %%
                     (combination % op = % _ % _ % _ %% (reflexive % _) %%
                       (combination % _ % _ % _ % _ %%
                         (combination % op <= % _ % _ % _ %% (reflexive % _) %%
                           (combination % _ % _ % _ % _ %%
                             (combination % op + % _ % _ % _ %% (reflexive % _) %%
                               (transitive % _ % _ % _ %%
                                 (transitive % _ % _ % _ %%
                                   (combination % _ % _ % _ % _ %%
                                     (combination % op * % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (transitive % _ % _ % _ %%
                                         (eq_reflection % _ % _ %%
(bin_arith_simps_26 % _ % _)) %%
                                         (combination % number_of % _ % _ % _ %%
(reflexive % _) %%
(transitive % _ % _ % _ %%
  (transitive % _ % _ % _ %%
    (combination % bin_add (bin.Pls BIT True BIT False) % _ % _ % _ %%
      (reflexive % _) %%
      (transitive % _ % _ % _ %%
        (eq_reflection % _ % _ %% (bin_arith_simps_19 % _)) %%
        (transitive % _ % _ % _ %%
          (combination % bin_pred % _ % _ % _ %% (reflexive % _) %%
            (transitive % _ % _ % _ %%
              (combination % _ % _ % _ % _ %%
                (combination % NCons % _ % _ % _ %% (reflexive % _) %%
                  (eq_reflection % _ % _ %% bin_arith_simps_7)) %%
                (reflexive % _)) %%
              (eq_reflection % _ % _ %% bin_arith_simps_32))) %%
          (eq_reflection % _ % _ %% bin_arith_simps_1)))) %%
    (eq_reflection % _ % _ %% (bin_arith_simps_22 % _))) %%
  (transitive % _ % _ % _ %% (eq_reflection % _ % _ %% (bin_arith_simps_18 % _)) %%
    (combination % _ % _ % _ % _ %%
      (combination % op BIT % _ % _ % _ %% (reflexive % _) %%
        (transitive % _ % _ % _ %%
          (eq_reflection % _ % _ %% (bin_arith_simps_17 % _)) %%
          (eq_reflection % _ % _ %% bin_arith_simps_32))) %%
      (reflexive % _))))))) %%
                                     (reflexive % _)) %%
                                   (eq_reflection % _ % _ %%
                                     (bin_arith_simps_14 % _ % _))) %%
                                 (combination % number_of % _ % _ % _ %%
                                   (reflexive % _) %%
                                   (transitive % _ % _ % _ %%
                                     (eq_reflection % _ % _ %%
                                       (bin_arith_simps_30 % _ % _)) %%
                                     (transitive % _ % _ % _ %%
                                       (combination % _ % _ % _ % _ %%
                                         (combination % bin_add % _ % _ % _ %%
(reflexive % _) %%
(transitive % _ % _ % _ %%
  (combination % _ % _ % _ % _ %%
    (combination % NCons % _ % _ % _ %% (reflexive % _) %%
      (eq_reflection % _ % _ %% (bin_arith_simps_9 % _))) %%
    (reflexive % _)) %%
  (eq_reflection % _ % _ %% bin_arith_simps_32))) %%
                                         (reflexive % _)) %%
                                       (eq_reflection % _ % _ %%
                                         (bin_arith_simps_5 % _))))))) %%
                             (reflexive % _))) %%
                         (reflexive % _))) %%
                     (combination % _ % _ % _ % _ %%
                       (combination % op <= % _ % _ % _ %% (reflexive % _) %%
                         (combination % _ % _ % _ % _ %%
                           (combination % op + % _ % _ % _ %% (reflexive % _) %%
                             (transitive % _ % _ % _ %%
                               (eq_reflection % _ % _ %%
                                 (bin_arith_simps_14 % _ % _)) %%
                               (combination % number_of % _ % _ % _ %%
                                 (reflexive % _) %%
                                 (transitive % _ % _ % _ %%
                                   (eq_reflection % _ % _ %%
                                     (bin_arith_simps_30 % _ % _)) %%
                                   (transitive % _ % _ % _ %%
                                     (combination % _ % _ % _ % _ %%
                                       (combination % bin_add % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (transitive % _ % _ % _ %%
(combination % _ % _ % _ % _ %%
  (combination % NCons % _ % _ % _ %% (reflexive % _) %%
    (eq_reflection % _ % _ %% (bin_arith_simps_9 % _))) %%
  (reflexive % _)) %%
(eq_reflection % _ % _ %% bin_arith_simps_32))) %%
                                       (reflexive % _)) %%
                                     (eq_reflection % _ % _ %%
                                       (bin_arith_simps_5 % _))))))) %%
                           (reflexive % _))) %%
                       (eq_reflection % _ % _ %%
                         (equal_elim % _ % _ %%
                           (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                             (combination % _ % _ % _ % _ %%
                               (combination % op = % _ % _ % _ %% (reflexive % _) %%
                                 (combination % op + xa<aa\<bullet>count> % _ % _ %
                                   _ %%
                                   (reflexive % _) %%
                                   (eq_reflection % _ % _ %%
                                     (HOL.sym % _ % _ %% int_numeral_0_eq_0)))) %%
                               (reflexive % _))) %%
                           (zadd_0_right % _))))) %%
                   (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
             TrueI)))))) %%
 (transitive % _ % _ % _ %%
   (transitive % _ % _ % _ %%
     (combination % _ % _ % _ % _ %%
       (combination % op <= % _ % _ % _ %% (reflexive % _) %%
         (combination % _ % _ % _ % _ %%
           (combination % op + % _ % _ % _ %% (reflexive % _) %%
             (eq_reflection % _ % _ %% int_numeral_1_eq_1)) %%
           (reflexive % _))) %%
       (reflexive % _)) %%
     (eq_reflection % _ % _ %%
       (HOL.trans % _ % _ % _ %%
         (equal_elim % _ % _ %%
           (symmetric % _ % _ %%
             (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
               (transitive % _ % _ % _ %%
                 (combination % _ % _ % _ % _ %%
                   (combination % op = % _ % _ % _ %% (reflexive % _) %%
                     (combination % _ % _ % _ % _ %%
                       (combination % op <= % _ % _ % _ %% (reflexive % _) %%
                         (transitive % _ % _ % _ %%
                           (combination % _ % _ % _ % _ %%
                             (combination % op + % _ % _ % _ %% (reflexive % _) %%
                               (eq_reflection % _ % _ %%
                                 (HOL.sym % _ % _ %% int_numeral_1_eq_1))) %%
                             (reflexive % _)) %%
                           (eq_reflection % _ % _ %% (zadd_ac_2 % _ % _)))) %%
                       (reflexive % _))) %%
                   (combination % _ % _ % _ % _ %%
                     (combination % op <= % _ % _ % _ %% (reflexive % _) %%
                       (combination % _ % _ % _ % _ %%
                         (combination % op + % _ % _ % _ %% (reflexive % _) %%
                           (eq_reflection % _ % _ %%
                             (equal_elim % _ % _ %%
                               (combination % Trueprop % _ % _ % _ %%
                                 (reflexive % _) %%
                                 (combination % _ % _ % _ % _ %%
                                   (combination % op = % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (combination % _ % _ % _ % _ %%
                                       (combination % op * % _ % _ % _ %%
                                         (reflexive % _) %%
                                         (eq_reflection % _ % _ %%
(HOL.sym % _ % _ %% int_numeral_1_eq_1))) %%
                                       (reflexive % _))) %%
                                   (reflexive % _))) %%
                               (zmult_1 % _)))) %%
                         (eq_reflection % _ % _ %%
                           (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                     (transitive % _ % _ % _ %%
                       (transitive % _ % _ % _ %%
                         (combination % _ % _ % _ % _ %%
                           (combination % op + % _ % _ % _ %% (reflexive % _) %%
                             (eq_reflection % _ % _ %%
                               (equal_elim % _ % _ %%
                                 (combination % Trueprop % _ % _ % _ %%
                                   (reflexive % _) %%
                                   (combination % _ % _ % _ % _ %%
                                     (combination % op = % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (combination % _ % _ % _ % _ %%
                                         (combination % op * % _ % _ % _ %%
(reflexive % _) %%
(eq_reflection % _ % _ %% (HOL.sym % _ % _ %% int_numeral_1_eq_1))) %%
                                         (reflexive % _))) %%
                                     (reflexive % _))) %%
                                 (zmult_1 % _)))) %%
                           (reflexive % _)) %%
                         (eq_reflection % _ % _ %% (zadd_ac_2 % _ % _))) %%
                       (eq_reflection % _ % _ %%
                         (equal_elim % _ % _ %%
                           (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                             (combination % _ % _ % _ % _ %%
                               (combination % op = % _ % _ % _ %% (reflexive % _) %%
                                 (combination % _ % _ % _ % _ %%
                                   (combination % op + % _ % _ % _ %%
                                     (reflexive % _) %%
                                     (eq_reflection % _ % _ %%
                                       (HOL.sym % _ % _ %% int_numeral_0_eq_0))) %%
                                   (reflexive % _))) %%
                               (reflexive % _))) %%
                           (zadd_0 % _)))))) %%
                 (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
           TrueI) %%
         (HOL.trans % _ % _ % _ %% (le_add_iff1 % _ % _ % _ % _ % _) %%
           (equal_elim % _ % _ %%
             (symmetric % _ % _ %%
               (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                 (transitive % _ % _ % _ %%
                   (combination % _ % _ % _ % _ %%
                     (combination % op = % _ % _ % _ %% (reflexive % _) %%
                       (combination % _ % _ % _ % _ %%
                         (combination % op <= % _ % _ % _ %% (reflexive % _) %%
                           (combination % _ % _ % _ % _ %%
                             (combination % op + % _ % _ % _ %% (reflexive % _) %%
                               (combination % _ % _ % _ % _ %%
                                 (combination % op * % _ % _ % _ %% (reflexive % _) %%
                                   (transitive % _ % _ % _ %%
                                     (eq_reflection % _ % _ %%
                                       (bin_arith_simps_26 % _ % _)) %%
                                     (combination % number_of % _ % _ % _ %%
                                       (reflexive % _) %%
                                       (transitive % _ % _ % _ %%
                                         (transitive % _ % _ % _ %%
(combination % bin_add (bin.Pls BIT True) % _ % _ % _ %% (reflexive % _) %%
  (transitive % _ % _ % _ %% (eq_reflection % _ % _ %% (bin_arith_simps_19 % _)) %%
    (transitive % _ % _ % _ %%
      (combination % bin_pred % _ % _ % _ %% (reflexive % _) %%
        (transitive % _ % _ % _ %%
          (combination % _ % _ % _ % _ %%
            (combination % NCons % _ % _ % _ %% (reflexive % _) %%
              (eq_reflection % _ % _ %% bin_arith_simps_7)) %%
            (reflexive % _)) %%
          (eq_reflection % _ % _ %% bin_arith_simps_32))) %%
      (eq_reflection % _ % _ %% bin_arith_simps_1)))) %%
(eq_reflection % _ % _ %% (bin_arith_simps_22 % _))) %%
                                         (transitive % _ % _ % _ %%
(eq_reflection % _ % _ %% (bin_arith_simps_17 % _)) %%
(eq_reflection % _ % _ %% bin_arith_simps_32)))))) %%
                                 (reflexive % _))) %%
                             (eq_reflection % _ % _ %%
                               (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                         (reflexive % _))) %%
                     (combination % _ % _ % _ % _ %%
                       (combination % op <= % _ % _ % _ %% (reflexive % _) %%
                         (combination % op + (Numeral0 * xa<aa\<bullet>count>) % _ %
                           _ %
                           _ %%
                           (reflexive % _) %%
                           (eq_reflection % _ % _ %%
                             (HOL.sym % _ % _ %% int_numeral_1_eq_1)))) %%
                       (reflexive % _))) %%
                   (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
             TrueI))))) %%
   (transitive % _ % _ % _ %%
     (transitive % _ % _ % _ %%
       (combination % _ % _ % _ % _ %%
         (combination % op <= % _ % _ % _ %% (reflexive % _) %%
           (transitive % _ % _ % _ %%
             (combination % _ % _ % _ % _ %%
               (combination % op + % _ % _ % _ %% (reflexive % _) %%
                 (transitive % _ % _ % _ %%
                   (combination % _ % _ % _ % _ %%
                     (combination % op * % _ % _ % _ %% (reflexive % _) %%
                       (eq_reflection % _ % _ %% int_numeral_0_eq_0)) %%
                     (reflexive % _)) %%
                   (eq_reflection % _ % _ %% (zmult_0 % _)))) %%
               (reflexive % _)) %%
             (eq_reflection % _ % _ %% (zadd_0 % _)))) %%
         (eq_reflection % _ % _ %% int_numeral_0_eq_0)) %%
       (eq_reflection % _ % _ %%
         (HOL.trans % _ % _ % _ %%
           (equal_elim % _ % _ %%
             (symmetric % _ % _ %%
               (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                 (transitive % _ % _ % _ %%
                   (combination % op = (1 <= 0) % _ % _ % _ %% (reflexive % _) %%
                     (combination % _ % _ % _ % _ %%
                       (combination % op <= % _ % _ % _ %% (reflexive % _) %%
                         (eq_reflection % _ % _ %% int_numeral_1_eq_1)) %%
                       (eq_reflection % _ % _ %% int_numeral_0_eq_0))) %%
                   (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
             TrueI) %%
           (le_number_of_eq_not_less % _ % _)))) %%
     (transitive % _ % _ % _ %%
       (combination % Not % _ % _ % _ %% (reflexive % _) %%
         (transitive % _ % _ % _ %%
           (transitive % _ % _ % _ %%
             (combination % _ % _ % _ % _ %%
               (combination % op < % _ % _ % _ %% (reflexive % _) %%
                 (eq_reflection % _ % _ %% int_numeral_0_eq_0)) %%
               (eq_reflection % _ % _ %% int_numeral_1_eq_1)) %%
             (eq_reflection % _ % _ %%
               (HOL.trans % _ % _ % _ %%
                 (equal_elim % _ % _ %%
                   (symmetric % _ % _ %%
                     (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                       (transitive % _ % _ % _ %%
                         (combination % op = (0 < 1) % _ % _ % _ %% (reflexive % _) %%
                           (combination % _ % _ % _ % _ %%
                             (combination % op < % _ % _ % _ %% (reflexive % _) %%
                               (eq_reflection % _ % _ %% int_numeral_0_eq_0)) %%
                             (eq_reflection % _ % _ %% int_numeral_1_eq_1))) %%
                         (eq_reflection % _ % _ %% (simp_thms_6 % _))))) %%
                   TrueI) %%
                 (less_number_of_eq_neg % _ % _)))) %%
           (transitive % _ % _ % _ %%
             (combination % neg % _ % _ % _ %% (reflexive % _) %%
               (combination % number_of % _ % _ % _ %% (reflexive % _) %%
                 (transitive % _ % _ % _ %%
                   (transitive % _ % _ % _ %%
                     (combination % bin_add bin.Pls % _ % _ % _ %% (reflexive % _) %%
                       (transitive % _ % _ % _ %%
                         (eq_reflection % _ % _ %% (bin_arith_simps_19 % _)) %%
                         (transitive % _ % _ % _ %%
                           (combination % bin_pred % _ % _ % _ %% (reflexive % _) %%
                             (transitive % _ % _ % _ %%
                               (combination % _ % _ % _ % _ %%
                                 (combination % NCons % _ % _ % _ %%
                                   (reflexive % _) %%
                                   (eq_reflection % _ % _ %% bin_arith_simps_7)) %%
                                 (reflexive % _)) %%
                               (eq_reflection % _ % _ %% bin_arith_simps_32))) %%
                           (eq_reflection % _ % _ %% bin_arith_simps_1)))) %%
                     (eq_reflection % _ % _ %% (bin_arith_simps_22 % _))) %%
                   (eq_reflection % _ % _ %% bin_arith_simps_1)))) %%
             (Eq_TrueI % _ %% bin_rel_simps_11)))) %%
       (eq_reflection % _ % _ %% simp_thms_7)))))) %%
                                        (thm % _ % _ % _ % _ %%
                                          (conjI % _ % _ %%
 (iffD2 % _ % _ %% (add1_zle_eq % _ % _) %% Hd) %%
 (iffD2 % _ % _ %% (add1_zle_eq % _ % _) %% H))))))))) %%
                          (eq_reflection % _ % _ %% (simp_thms_25 % _)))) %%
                      (eq_reflection % _ % _ %% simp_thms_7))) %%
                  (equal_elim % _ % _ %%
                    (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                      (combination % Not % _ % _ % _ %% (reflexive % _) %%
                        (combination % _ % _ % _ % _ %%
                          (combination % op & % _ % _ % _ %% (reflexive % _) %%
                            (combination % _ % _ % _ % _ %%
                              (combination % op = % _ % _ % _ %% (reflexive % _) %%
                                (eq_reflection % _ % _ %% He)) %%
                              (reflexive % _))) %%
                          (reflexive % _)))) %%
                    (equal_elim % _ % _ %%
                      (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                        (combination % Not % _ % _ % _ %% (reflexive % _) %%
                          (combination % op & (a = IVal 0) % _ % _ % _ %%
                            (reflexive % _) %%
                            (combination % _ % _ % _ % _ %%
                              (combination % op = % _ % _ % _ %% (reflexive % _) %%
                                (combination % _ % _ % _ % _ %%
                                  (combination % _ % _ % _ % _ %%
                                    (combination % iheap % _ % _ % _ %%
                                      (reflexive % _) %%
                                      (eq_reflection % _ % _ %% Hb)) %%
                                    (reflexive % _)) %%
                                  (reflexive % _))) %%
                              (reflexive % _))))) %%
                      Hc)))))))) %%
(Lam H: _. H))))))))))))))))))))))))))))))))))))))))) %
            x %%
            (equal_elim % _ % _ %%
              (combination % Trueprop % _ % _ % _ %% (reflexive % _) %%
                (transitive % _ % _ % _ %%
                  (transitive % _ % _ % _ %%
                    (combination % _ % _ % _ % _ %%
                      (combination % op & % _ % _ % _ %% (reflexive % _) %%
                        (transitive % _ % _ % _ %%
                          (eq_reflection % _ % _ %% (distinct.simps_2 % _ % _)) %%
                          (transitive % _ % _ % _ %%
                            (combination % _ % _ % _ % _ %%
                              (combination % op & % _ % _ % _ %% (reflexive % _) %%
                                (transitive % _ % _ % _ %%
                                  (combination % Not % _ % _ % _ %% (reflexive % _) %%
                                    (transitive % _ % _ % _ %%
                                      (transitive % _ % _ % _ %%
                                        (combination % op : one % _ % _ % _ %%
                                          (reflexive % _) %%
                                          (transitive % _ % _ % _ %%
 (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
 (combination % insert n % _ % _ % _ %% (reflexive % _) %%
   (transitive % _ % _ % _ %% (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
     (combination % insert b % _ % _ % _ %% (reflexive % _) %%
       (eq_reflection % _ % _ %% set.simps_1)))))) %%
                                        (eq_reflection % _ % _ %%
                                          (insert_iff % _ % _ % _))) %%
                                      (combination % op | (one = n) % _ % _ % _ %%
                                        (reflexive % _) %%
                                        (transitive % _ % _ % _ %%
                                          (eq_reflection % _ % _ %%
 (insert_iff % _ % _ % _)) %%
                                          (transitive % _ % _ % _ %%
 (combination % op | (one = b) % _ % _ % _ %% (reflexive % _) %%
   (eq_reflection % _ % _ %% (empty_iff % _))) %%
 (eq_reflection % _ % _ %% (simp_thms_31 % _))))))) %%
                                  (eq_reflection % _ % _ %%
                                    (de_Morgan_disj % _ % _)))) %%
                              (transitive % _ % _ % _ %%
                                (eq_reflection % _ % _ %%
                                  (distinct.simps_2 % _ % _)) %%
                                (transitive % _ % _ % _ %%
                                  (combination % _ % _ % _ % _ %%
                                    (combination % op & % _ % _ % _ %%
                                      (reflexive % _) %%
                                      (combination % Not % _ % _ % _ %%
                                        (reflexive % _) %%
                                        (transitive % _ % _ % _ %%
                                          (transitive % _ % _ % _ %%
 (combination % op : n % _ % _ % _ %% (reflexive % _) %%
   (transitive % _ % _ % _ %% (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
     (combination % insert b % _ % _ % _ %% (reflexive % _) %%
       (eq_reflection % _ % _ %% set.simps_1)))) %%
 (eq_reflection % _ % _ %% (insert_iff % _ % _ % _))) %%
                                          (transitive % _ % _ % _ %%
 (combination % op | (n = b) % _ % _ % _ %% (reflexive % _) %%
   (eq_reflection % _ % _ %% (empty_iff % _))) %%
 (eq_reflection % _ % _ %% (simp_thms_31 % _)))))) %%
                                    (transitive % _ % _ % _ %%
                                      (eq_reflection % _ % _ %%
                                        (distinct.simps_2 % _ % _)) %%
                                      (transitive % _ % _ % _ %%
                                        (combination % _ % _ % _ % _ %%
                                          (combination % op & % _ % _ % _ %%
 (reflexive % _) %%
 (transitive % _ % _ % _ %%
   (combination % Not % _ % _ % _ %% (reflexive % _) %%
     (transitive % _ % _ % _ %%
       (combination % op : b % _ % _ % _ %% (reflexive % _) %%
         (eq_reflection % _ % _ %% set.simps_1)) %%
       (eq_reflection % _ % _ %% (empty_iff % _)))) %%
   (eq_reflection % _ % _ %% simp_thms_8))) %%
                                          (eq_reflection % _ % _ %%
 distinct.simps_1)) %%
                                        (eq_reflection % _ % _ %%
                                          (simp_thms_25 % _))))) %%
                                  (eq_reflection % _ % _ %% (simp_thms_21 % _))))) %%
                            (eq_reflection % _ % _ %% (conj_assoc % _ % _ % _))))) %%
                      (transitive % _ % _ % _ %%
                        (eq_reflection % _ % _ %% (distinct.simps_2 % _ % _)) %%
                        (transitive % _ % _ % _ %%
                          (combination % _ % _ % _ % _ %%
                            (combination % op & % _ % _ % _ %% (reflexive % _) %%
                              (transitive % _ % _ % _ %%
                                (combination % Not % _ % _ % _ %% (reflexive % _) %%
                                  (transitive % _ % _ % _ %%
                                    (transitive % _ % _ % _ %%
                                      (combination % op : b % _ % _ % _ %%
                                        (reflexive % _) %%
                                        (transitive % _ % _ % _ %%
                                          (eq_reflection % _ % _ %%
 (set.simps_2 % _ % _)) %%
                                          (combination % insert n % _ % _ % _ %%
 (reflexive % _) %%
 (transitive % _ % _ % _ %% (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
   (combination % insert one % _ % _ % _ %% (reflexive % _) %%
     (eq_reflection % _ % _ %% set.simps_1)))))) %%
                                      (eq_reflection % _ % _ %%
                                        (insert_iff % _ % _ % _))) %%
                                    (combination % op | (b = n) % _ % _ % _ %%
                                      (reflexive % _) %%
                                      (transitive % _ % _ % _ %%
                                        (eq_reflection % _ % _ %%
                                          (insert_iff % _ % _ % _)) %%
                                        (transitive % _ % _ % _ %%
                                          (combination % op | (b = one) % _ % _ % _ %%
 (reflexive % _) %%
 (eq_reflection % _ % _ %% (empty_iff % _))) %%
                                          (eq_reflection % _ % _ %%
 (simp_thms_31 % _))))))) %%
                                (eq_reflection % _ % _ %%
                                  (de_Morgan_disj % _ % _)))) %%
                            (transitive % _ % _ % _ %%
                              (eq_reflection % _ % _ %% (distinct.simps_2 % _ % _)) %%
                              (transitive % _ % _ % _ %%
                                (combination % _ % _ % _ % _ %%
                                  (combination % op & % _ % _ % _ %%
                                    (reflexive % _) %%
                                    (combination % Not % _ % _ % _ %%
                                      (reflexive % _) %%
                                      (transitive % _ % _ % _ %%
                                        (transitive % _ % _ % _ %%
                                          (combination % op : n % _ % _ % _ %%
 (reflexive % _) %%
 (transitive % _ % _ % _ %% (eq_reflection % _ % _ %% (set.simps_2 % _ % _)) %%
   (combination % insert one % _ % _ % _ %% (reflexive % _) %%
     (eq_reflection % _ % _ %% set.simps_1)))) %%
                                          (eq_reflection % _ % _ %%
 (insert_iff % _ % _ % _))) %%
                                        (transitive % _ % _ % _ %%
                                          (combination % op | (n = one) % _ % _ % _ %%
 (reflexive % _) %%
 (eq_reflection % _ % _ %% (empty_iff % _))) %%
                                          (eq_reflection % _ % _ %%
 (simp_thms_31 % _)))))) %%
                                  (transitive % _ % _ % _ %%
                                    (eq_reflection % _ % _ %%
                                      (distinct.simps_2 % _ % _)) %%
                                    (transitive % _ % _ % _ %%
                                      (combination % _ % _ % _ % _ %%
                                        (combination % op & % _ % _ % _ %%
                                          (reflexive % _) %%
                                          (transitive % _ % _ % _ %%
 (combination % Not % _ % _ % _ %% (reflexive % _) %%
   (transitive % _ % _ % _ %%
     (combination % op : one % _ % _ % _ %% (reflexive % _) %%
       (eq_reflection % _ % _ %% set.simps_1)) %%
     (eq_reflection % _ % _ %% (empty_iff % _)))) %%
 (eq_reflection % _ % _ %% simp_thms_8))) %%
                                        (eq_reflection % _ % _ %%
                                          distinct.simps_1)) %%
                                      (eq_reflection % _ % _ %%
                                        (simp_thms_25 % _))))) %%
                                (eq_reflection % _ % _ %% (simp_thms_21 % _))))) %%
                          (eq_reflection % _ % _ %% (conj_assoc % _ % _ % _))))) %%
                    (eq_reflection % _ % _ %% (conj_assoc % _ % _ % _))) %%
                  (combination % op & (one ~= n) % _ % _ % _ %% (reflexive % _) %%
                    (eq_reflection % _ % _ %% (conj_assoc % _ % _ % _))))) %%
              vardistinct))))))"
*}

(* reconstruct the full proof out of the proof term *)
ML {*
val prf' = Reconstruct.reconstruct_proof (sign_of (theory "VDM5")) trm prf;
*}

(* replay the proof *)
ML {* 
val my_thm = ProofChecker.thm_of_proof (theory "VDM5") prf';
*}

end
