header {*Application: functions over trees and lists*}
(*<*)
theory mTreeList = Adapt:
(*>*)
text {*The Camelot code
       \begin{verbatim}
         type itree = Leaf of int | Node of itree * itree
         type ilist = Nil | Cons of int * ilist
       \end{verbatim}
       should result in the following definitions and lemmas.*}

consts DIAM :: cname
       DOLLAR :: ifldname
       F0 :: ifldname
       F1 :: rfldname
       F2 :: rfldname

axioms TreeFieldDistinct[simp]: "DOLLAR \<noteq> F0 \<and> F1 \<noteq> F2 \<and> F0 \<noteq> DOLLAR \<and> F2 \<noteq> F1"

subsection {*The list representation predicate*}
consts mList::"(nat \<times> locn \<times> (locn set) \<times> heap) set"
inductive mList intros
mListNIL:"\<lbrakk>h@@a = Some DIAM; h<a\<bullet>DOLLAR> = 2\<rbrakk> \<Longrightarrow> (0,a,{a},h) : mList"
mListCONS:"\<lbrakk>h@@a = Some DIAM; h<a\<bullet>DOLLAR> \<noteq> 2; h\<lfloor>a\<diamondsuit>F1\<rfloor> = Ref aa; a \<notin> X; (n,aa,X,h):mList\<rbrakk>
          \<Longrightarrow> (Suc n, a, X \<union> {a}, h): mList"

lemma mListSame[rule_format]:
"(n,a,X,h) \<in> mList \<Longrightarrow> (\<forall> hh . same X h hh \<longrightarrow> (n,a,X,hh) \<in> mList)"
apply (erule mList.induct, safe)
apply (rule mListNIL)
apply (simp add: same_def)
apply (simp add: same_def)
apply (rule mListCONS)
apply ( simp add: same_def)
apply ( simp add: same_def)
apply ( simp add: same_def)
apply simp
apply simp
apply (subgoal_tac "same X h hh", simp)
apply ( simp add: same_def)
done

lemma mListDom: "\<lbrakk>(n, a, X, h) \<in> mList\<rbrakk> \<Longrightarrow>  X \<subseteq> Dom h"
by (erule mList.induct, simp_all add:fmap_lookup_def fmap_dom_def dom_def)

lemma mListFresh: "(L, a, X, h) \<in> mList \<Longrightarrow> freshloc (Dom h) \<notin> X"
by (subgoal_tac "X \<subseteq> Dom h", fastsimp, erule mListDom)

lemma mListSameFresh: "(n, a, X, h) \<in> mList
       \<Longrightarrow> same X h
           \<lparr>oheap = oheap h(freshloc (Dom h)\<mapsto>\<^sub>fDIAM),
              iheap = (iheap h)
                (DOLLAR := (iheap h DOLLAR)(freshloc (Dom h) := U),
                 F0 := (iheap h F0)(freshloc (Dom h) := Y)),
              rheap = (rheap h)(F1 := (rheap h F1)(freshloc (Dom h) := Z))\<rparr>"
apply (erule mList.induct)
apply (simp add: same_def)
apply (subgoal_tac "a \<noteq> freshloc (Dom h)", clarsimp) apply (simp add: FMAPlookup1)
  apply (subgoal_tac "a : Dom h")
  apply fastsimp
  apply (simp add: fmap_lookup_def fmap_dom_def dom_def)
apply (simp add: same_def)
apply (subgoal_tac "a \<noteq> freshloc (Dom h)", clarsimp) apply (erule_tac x=a in allE, clarsimp)
  apply (simp add: FMAPlookup1) 
  apply (subgoal_tac "a : Dom h")
  apply fastsimp
  apply (simp add: fmap_lookup_def fmap_dom_def dom_def)
done

lemma mListExtend:
  "\<lbrakk>(n, a, Y, h) \<in> mList; l \<notin> Dom h; F0 \<noteq> DOLLAR\<rbrakk> \<Longrightarrow>
  (Suc n, l, Y \<union> {l}, \<lparr>oheap = oheap h(l\<mapsto>\<^sub>fDIAM), 
                       iheap = (iheap h)(DOLLAR := (iheap h DOLLAR)(l := 1), F0 := (iheap h F0)(l := i)),
                       rheap = (rheap h)(F1 := (rheap h F1)(l := Ref a))\<rparr>) : mList"
apply (subgoal_tac "l \<noteq> a")
apply (erule mList.elims)
apply (rule mListCONS, safe)
apply (simp add: FMAPlookup1)
apply (clarsimp) 
apply simp
apply (rule mListNIL) 
apply (simp add: FMAPlookup1) apply clarsimp
apply (subgoal_tac "X \<subseteq> Dom h") prefer 2 apply (erule mListDom)
apply (rule mListCONS, safe)
apply (simp add: FMAPlookup1)
apply (clarsimp)
apply simp
apply (fast)  
apply (rule mListCONS) 
apply (simp add: FMAPlookup1) 
apply clarsimp 
apply simp
apply simp
apply (rule mListSame, assumption)
apply (simp add: same_def) apply clarsimp apply (simp add: FMAPlookup1)
apply fast
apply (subgoal_tac "a:Y") 
apply (insert mListDom) apply fast
apply (erule mList.elims, simp_all)
done

lemma SameExtend1:"\<lbrakk>l \<notin> X\<rbrakk> \<Longrightarrow> same X h \<lparr>oheap = (oheap h)(l\<mapsto>\<^sub>fC),
                                         iheap = (iheap h)(DOLLAR := (iheap h DOLLAR)(l := i1),
                                                           F0 := (iheap h F0)(l := i2)),
                                         rheap = (rheap h)(F1 := (rheap h F1)(l := r))\<rparr>"
by (simp add: same_def FMAPlookup1)

lemma DomExtend1: "\<lbrakk>l \<notin> Dom h \<rbrakk> \<Longrightarrow>
                   Dom h \<subseteq> Dom \<lparr>oheap = oheap h(l\<mapsto>\<^sub>fC),
                    iheap = (iheap h)(DOLLAR := (iheap h DOLLAR)(l := i1), F0 := (iheap h F0)(l := i2)),
                    rheap = (rheap h)(F1 := (rheap h F1)(l := r))\<rparr>"
by fastsimp

lemma SameExtend2:"\<lbrakk>l \<notin> X\<rbrakk> \<Longrightarrow> same X h \<lparr>oheap = oheap h(l\<mapsto>\<^sub>fC),
                                         iheap = (iheap h)(DOLLAR := (iheap h DOLLAR)(l := i)),
                                         rheap = rheap h\<rparr>"
by (simp add: same_def FMAPlookup1)

lemma DomExtend2: "\<lbrakk>l \<notin> Dom h \<rbrakk> \<Longrightarrow>
                   Dom h \<subseteq> Dom \<lparr>oheap = oheap h(l\<mapsto>\<^sub>fC),
                                iheap = (iheap h)(DOLLAR := (iheap h DOLLAR)(l := i)),
                                rheap = rheap h\<rparr>"
by fastsimp

subsection {*The tree representation predicate*}
consts mTree::"(nat \<times> locn \<times> (locn set) \<times> heap) set"
inductive mTree intros
mTreeLEAF:"\<lbrakk>h@@a = Some DIAM; h<a\<bullet>DOLLAR> = 0\<rbrakk> \<Longrightarrow> (0,a,{a},h) : mTree"
mTreeNODE:"\<lbrakk>h@@a = Some DIAM; h<a\<bullet>DOLLAR> \<noteq> 0; 
            h\<lfloor>a\<diamondsuit>F1\<rfloor> = Ref a1; (n,a1,X1,h):mTree; 
            h\<lfloor>a\<diamondsuit>F2\<rfloor> = Ref a2; (n,a2,X2,h):mTree;
            X1 \<inter> X2 = {}; a \<notin> X1 \<union> X2 \<rbrakk>
          \<Longrightarrow> (Suc n, a, X1 \<union> X2 \<union> {a}, h): mTree"

lemma mTreeSame[rule_format]:
"(n,a,X,h) \<in> mTree \<Longrightarrow> (\<forall> hh . same X h hh \<longrightarrow> (n,a,X,hh) \<in> mTree)"
apply (erule mTree.induct, safe)
apply (rule mTreeLEAF)
apply (simp add: same_def)
apply (simp add: same_def)
apply (rule mTreeNODE)
apply ( simp add: same_def)
apply ( simp add: same_def)
apply ( simp add: same_def)
apply (subgoal_tac "same X1 h hh", simp)
apply ( simp add: same_def)
apply ( simp add: same_def)
apply (subgoal_tac "same X2 h hh", simp)
apply ( simp add: same_def)
apply simp
apply simp
done

lemma mTreeDomAux:"(L,r,X,h) : mTree \<Longrightarrow> (\<forall> x. x \<in> X  \<longrightarrow> x \<in> Dom h)"
 apply (erule mTree.induct) 
 apply clarify
 apply (simp add: fmap_lookup_def fmap_dom_def dom_def)
 apply (simp add: fmap_lookup_def fmap_dom_def dom_def)
done

lemma mTreeDom: "\<lbrakk>(L, r, X, h) \<in> mTree\<rbrakk> \<Longrightarrow>  X \<subseteq> Dom h"
by (insert mTreeDomAux, auto)

lemma mTreeFresh: "(L, a, X, h) \<in> mTree \<Longrightarrow> freshloc (Dom h) \<notin> X"
by (subgoal_tac "X \<subseteq> fmap_dom (oheap h)", fastsimp, erule mTreeDom)
(*<*)
end
(*>*)
