theory VDMspecial = Adapt:

(* 0 *)
(* Introduction: define a freelist *)

consts DIAMOND :: cname
consts DollarN :: rfldname (* to point to the next member in a freelist *)
       Dollar :: ifldname (* a tag to discriminate constructors in our "universal" diamond *)
       F0 :: ifldname (* a working field *)
       F1 :: rfldname (* a working field *)
       DollarF :: rfldname (* the pointer to a head of a freelist*)

axioms dstnct: "distinct[F1, DollarF, DollarN] \<and> distinct[DollarN, DollarF, F1]
                 \<and> distinct[F0, Dollar] \<and> distinct[Dollar, F0]"

record diam_rec = 
       d_diam :: int
       f0_diam :: int 
       f1_diam :: ref
       nex_diam :: ref
       df_diam :: ref

axioms DIAMfields: "fmap_lookup(oheap h) loc = Some DIAMOND
                     \<Longrightarrow> (\<exists> rec . rec = 
                                      r\<lparr> d_diam := iheap h Dollar loc,
                                         f0_diam :=  iheap h F0 loc,
                                         f1_diam :=  rheap h F1 loc,
                                         nex_diam := rheap h DollarN loc,
                                         df_diam := rheap h DollarF loc\<rparr>)"


consts stloc :: locn

lemma NonNull : "Ref loc ~= Nullref"
apply simp
done

consts FreelistLoc::"(ref \<times> heap  \<times> (locn set) \<times> nat) set"
inductive FreelistLoc intros
FL_nothing : "(Nullref,h, {},0) \<in>  FreelistLoc"
FL_something : "\<lbrakk> fmap_lookup(oheap h) loc = Some DIAMOND;
                          rheap h DollarN loc = n;
                          loc \<notin> X;
                         (n, h, X, i) \<in> FreelistLoc\<rbrakk> 
                   \<Longrightarrow> (Ref loc, h, X\<union> {loc}, Suc i) : FreelistLoc"

lemma flistNonNullNonEmpty : "(Ref loc, h, X, m) : FreelistLoc \<Longrightarrow> X ~= {}"
apply (erule FreelistLoc.cases)
apply simp
apply simp
done

lemma flistNonNullLoc : "(Ref loc, h, X, m) : FreelistLoc \<Longrightarrow> loc \<in> X"
apply (erule FreelistLoc.cases)
apply simp
apply simp
done

lemma flistNonNullNonZero : "(Ref loc, h, X, m) : FreelistLoc \<Longrightarrow> m ~= 0"
apply (erule FreelistLoc.cases)
apply simp
apply simp
done

lemma flistNonNullPositive : "(Ref loc, h, X, m) : FreelistLoc \<Longrightarrow>  0<m"
apply (erule FreelistLoc.cases)
apply simp
apply simp
done



lemma flistSame [rule_format]: "(r, h, X, m)  \<in>  FreelistLoc
                                \<Longrightarrow>
                                (\<forall> Y hh. X\<subseteq> Y \<longrightarrow> 
                                                 same Y h hh \<longrightarrow>
                                                 (r,  hh, X, m)  \<in>  FreelistLoc)"
apply (erule FreelistLoc.induct)
apply clarify
apply (rule FL_nothing)
apply (rule allI)+
apply (rule impI)+
apply (rule FL_something)
apply (unfold same_def)
apply simp
apply simp
apply simp
apply force
done

lemma flistZeroNull: "(r, h, Y, 0)  \<in>  FreelistLoc \<Longrightarrow> r=Nullref"
apply (erule FreelistLoc.cases)
apply simp
apply simp
done

lemma flistZeroEmpty: "(r, h, Y, 0)  \<in>  FreelistLoc \<Longrightarrow> Y={}"
apply (erule FreelistLoc.cases)
apply simp
apply simp
done


lemma flistNullEmpty: "(Nullref, h, Y, m)  \<in>  FreelistLoc \<Longrightarrow> {}=Y"
apply (erule FreelistLoc.cases)
apply simp
apply simp
done

lemma flistNullZero: "(Nullref, h, Y, m)  \<in>  FreelistLoc \<Longrightarrow> 0=m"
apply (erule FreelistLoc.cases)
apply simp
apply simp
done

lemma flistTail: "\<lbrakk> (r, h, X, m)  \<in>  FreelistLoc; 
                                 r =  Ref loc \<rbrakk> 
                                \<Longrightarrow>
                             (rheap h DollarN loc, h, X-{loc}, m-(1::nat)) \<in>  FreelistLoc"   
apply (erule FreelistLoc.cases)
apply simp
apply simp
done

lemma flistTail': "\<lbrakk> (Ref loc , h, X, m)  \<in>  FreelistLoc\<rbrakk> 
                                \<Longrightarrow>
                             (rheap h DollarN loc, h, X-{loc}, m-(1::nat)) \<in>  FreelistLoc"   
apply (erule FreelistLoc.cases)
apply simp
apply simp
done



lemma funcFL [rule_format]: "(r, h, Y, m) \<in> FreelistLoc \<Longrightarrow>
                            (\<forall> YY mm. (r, h, YY, mm) \<in> FreelistLoc  \<longrightarrow> Y=YY \<and> m=mm)"
apply (erule FreelistLoc.induct)
apply (rule allI)+
apply (rule impI)
apply (rule conjI)
apply (erule flistNullEmpty) 
apply (erule flistNullZero)

apply (rule allI)+
apply (rule impI)
apply (subgoal_tac "0<mm")
apply (subgoal_tac "loc \<in> YY")
apply (frule flistTail')
apply (erule allE)
apply (erule allE)
apply (rotate_tac 7)
apply simp
apply (drule mp)
apply assumption

apply (erule conjE)
apply (rule conjI)

apply blast
apply fastsimp

apply (frule flistNonNullLoc)
apply assumption
 
apply (frule flistNonNullPositive)
apply assumption
done

(****** operations on heap that do not change freelist ******************)

lemma FLIfld:
  "\<lbrakk>(r, h, X, m) \<in> FreelistLoc\<rbrakk> \<Longrightarrow>  (r, h<loc'\<bullet>Fld := f'>,X, m) \<in> FreelistLoc"
apply (erule FreelistLoc.induct)
apply (rule FL_nothing)
apply (subgoal_tac "loc=loc'\<or> loc~=loc'")
prefer 2
apply clarify
apply (erule disjE)

apply (rule FL_something)
apply simp
apply simp
apply simp
apply assumption

apply (rule FL_something)
apply simp
apply simp
apply simp
apply assumption
done

lemma FLRfld:
  "\<lbrakk>(r, h, X, m) \<in> FreelistLoc; Fld ~= DollarN; Fld ~= DollarF\<rbrakk> 
   \<Longrightarrow>  (r, h\<lfloor>loc\<diamondsuit>Fld := f\<rfloor>, X, m) \<in> FreelistLoc"
apply (erule FreelistLoc.induct)
apply (rule FL_nothing)
apply (subgoal_tac "loc=loc'\<or> loc~=loc'")
prefer 2
apply clarify
apply (erule disjE)

apply (rule FL_something)
apply simp
apply simp
apply simp
apply fastsimp

apply (rule FL_something)
apply simp
apply simp
apply simp
apply fastsimp
done

(*****************************************************************************************)


constdefs variation :: "heap \<Rightarrow> nat \<Rightarrow> heap \<Rightarrow> nat \<Rightarrow> bool"
"variation h n hh n'      \<equiv>  (\<forall> m Y q.  
                              stloc \<notin> Y   \<longrightarrow> 
                             (rheap h DollarF stloc, h, Y, m) \<in> FreelistLoc \<longrightarrow> 
                              n + q \<le> m \<longrightarrow> 
                              (\<exists> Y' m'. stloc \<notin> Y'  \<and>
                               (rheap hh DollarF stloc, hh, Y', m') \<in> FreelistLoc \<and>
                               n' + q  \<le> m'\<and>
                               heap.oheap h = heap.oheap hh))"

lemma constHeapVari: "variation h n h n"
apply (unfold variation_def)
apply (rule allI)+
apply (rule impI)+
apply (rule exI)+
apply (rule conjI)
apply assumption
apply (rule conjI)
apply assumption
apply (rule conjI)
apply assumption
apply simp
done


(****** operations on heap that do not change variation ******************)

lemma IfldVari: "variation h n  h<loc'\<bullet>Fld := f'> n"
apply (unfold variation_def)
apply (rule allI)+
apply (rule impI)+
apply (subgoal_tac "(h<loc'\<bullet>Fld:=f'>\<lfloor>stloc\<diamondsuit>DollarF\<rfloor>, h<loc'\<bullet>Fld:=f'>, Y, m) \<in> FreelistLoc")
apply (rule exI)+
apply (rule conjI)
apply assumption
apply (rule conjI)
apply assumption
apply (rule conjI)
apply assumption
apply simp
apply (insert FLIfld)
apply (simp)
done

lemma RfldVari: "\<lbrakk>Fld ~= DollarN; Fld ~= DollarF\<rbrakk> \<Longrightarrow> variation h n  h\<lfloor>loc\<diamondsuit> Fld := f\<rfloor> n"
apply (unfold variation_def)
apply (rule allI)+
apply (rule impI)+
apply (subgoal_tac "(h\<lfloor>loc\<diamondsuit> Fld := f\<rfloor>\<lfloor>stloc\<diamondsuit>DollarF\<rfloor>, h\<lfloor>loc\<diamondsuit> Fld := f\<rfloor>, Y, m) \<in> FreelistLoc")
apply (subgoal_tac "h\<lfloor>loc\<diamondsuit>Fld:=f\<rfloor>\<lfloor>stloc\<diamondsuit>DollarF\<rfloor>=h\<lfloor>stloc\<diamondsuit>DollarF\<rfloor>")
apply (rule exI)+
apply (rule conjI)
apply assumption
apply (rule conjI)
apply assumption
apply (rule conjI)
apply assumption
apply simp
apply clarsimp
apply (insert FLRfld)
apply force
done


(*********************************************************************)


types data_size_val = "val \<Rightarrow> heap \<Rightarrow> nat"
types data_size_env = "env \<Rightarrow> ARGTYPE  \<Rightarrow> heap \<Rightarrow> nat"

lemma vdm_conseq_res: "\<lbrakk>G \<rhd> e : (\<lambda> E h hh v p.  variation  h n hh n' ); 
                        (\<forall> E h hh v p . variation  h n hh n'  \<longrightarrow> (Q  E h hh v p ))\<rbrakk>
                      \<Longrightarrow> G \<rhd> e : Q"
apply (rule vdm_conseq)
apply assumption
apply assumption
done
 
lemma vdm_invokestatic_res_const:
  "\<lbrakk>({(C\<bullet>mn(args), (\<lambda> E h hh v p.  variation  h k hh k' ))} 
    \<union> G) \<rhd> (snd (methtable C mn)) :  (\<lambda> E h hh v p.  variation  h k hh k' )\<rbrakk> \<Longrightarrow>
   G \<rhd> (C\<bullet>mn(args)) : (\<lambda> E h hh v p.  variation  h k  hh k' )"
apply (rule vdm_invokestatic)
apply (rule vdm_conseq_res)
apply assumption
apply clarsimp
done


lemma vdm_null_res1: "G \<rhd> NULL : (\<lambda>  E h  hh  v  p . variation h 0 hh 0)"
apply (rule vdm_conseq)
apply (rule vdm_null)
apply clarsimp
apply (rule constHeapVari)
done


lemma vdm_null_res2: "\<lbrakk>n=0\<rbrakk> \<Longrightarrow>G \<rhd> NULL : (\<lambda>  E h  hh  v  p . variation h n hh 0)"
apply (rule vdm_conseq)
apply (rule vdm_null)
apply clarsimp
apply (rule constHeapVari)
done

lemma vdm_null_res3: "\<lbrakk>n'=0\<rbrakk> \<Longrightarrow>G \<rhd> NULL : (\<lambda>  E h  hh  v  p . variation h 0 hh n')"
apply (rule vdm_conseq)
apply (rule vdm_null)
apply clarsimp
apply (rule constHeapVari)
done

lemma vdm_null_res4: "\<lbrakk>n=0; n'=0\<rbrakk> \<Longrightarrow>G \<rhd> NULL : (\<lambda>  E h  hh  v  p . variation h n hh n')"
apply (rule vdm_conseq)
apply (rule vdm_null)
apply clarsimp
apply (rule constHeapVari)
done

lemma applic_test :"\<lbrakk>n=0; n'=0\<rbrakk> \<Longrightarrow> \<rhd> NULL : (\<lambda>  E h  hh  v  p . variation h n hh n')"
apply (rule vdm_null_res4)
apply assumption
apply assumption
done

lemma vdm_int_res1: "G \<rhd> expr.Int i : (\<lambda>  E h  hh  v  p . variation h 0 hh 0)"
apply (rule vdm_conseq)
apply (rule vdm_int)
apply clarsimp
apply (rule constHeapVari)
done

lemma vdm_int_res2: "\<lbrakk>n=0\<rbrakk> \<Longrightarrow>G \<rhd>expr.Int i   : (\<lambda>  E h  hh  v  p . variation h n hh 0)"
apply (rule vdm_conseq)
apply (rule vdm_int)
apply clarsimp
apply (rule constHeapVari)
done


lemma vdm_int_res3: "\<lbrakk>n'=0\<rbrakk> \<Longrightarrow>G \<rhd> expr.Int i  : (\<lambda>  E h  hh  v  p . variation h 0 hh n')"
apply (rule vdm_conseq)
apply (rule vdm_int)
apply clarsimp
apply (rule constHeapVari)
done

lemma vdm_int_res4: "\<lbrakk>n=0; n'=0\<rbrakk> \<Longrightarrow>G \<rhd> expr.Int i  : (\<lambda>  E h  hh  v  p . variation h n hh n')"
apply (rule vdm_conseq)
apply (rule vdm_int)
apply clarsimp
apply (rule constHeapVari)
done


lemma vdm_ivar_res1: "G \<rhd> IVar x : (\<lambda>  E h  hh  v  p . variation h 0 hh 0)"
apply (rule vdm_conseq)
apply (rule vdm_ivar)
apply clarsimp
apply (rule constHeapVari)
done

lemma vdm_ivar_res2: "\<lbrakk>n=0\<rbrakk> \<Longrightarrow>G \<rhd> IVar x : (\<lambda>  E h  hh  v  p . variation h n hh 0)"
apply (rule vdm_conseq)
apply (rule vdm_ivar)
apply clarsimp
apply (rule constHeapVari)
done

lemma vdm_ivar_res3: "\<lbrakk>n'=0\<rbrakk> \<Longrightarrow>G \<rhd> IVar x : (\<lambda>  E h  hh  v  p . variation h 0 hh n')"
apply (rule vdm_conseq)
apply (rule vdm_ivar)
apply clarsimp
apply (rule constHeapVari)
done



lemma vdm_ivar_res4: "\<lbrakk>n=0; n'=0\<rbrakk> \<Longrightarrow>G \<rhd> IVar x : (\<lambda>  E h  hh  v  p . variation h n hh n')"
apply (rule vdm_conseq)
apply (rule vdm_ivar)
apply clarsimp
apply (rule constHeapVari)
done


lemma vdm_rvar_res1: "G \<rhd> RVar x : (\<lambda>  E h  hh  v  p . variation h 0 hh 0)"
apply (rule vdm_conseq)
apply (rule vdm_rvar)
apply clarsimp
apply (rule constHeapVari)
done



lemma vdm_rvar_res2: "\<lbrakk>n=0\<rbrakk> \<Longrightarrow>G \<rhd> RVar x : (\<lambda>  E h  hh  v  p . variation h n hh 0)"
apply (rule vdm_conseq)
apply (rule vdm_rvar)
apply clarsimp
apply (rule constHeapVari)
done

lemma vdm_rvar_res3: "\<lbrakk>n'=0\<rbrakk> \<Longrightarrow>G \<rhd> RVar x : (\<lambda>  E h  hh  v  p . variation h 0 hh n')"
apply (rule vdm_conseq)
apply (rule vdm_rvar)
apply clarsimp
apply (rule constHeapVari)
done

lemma vdm_rvar_res4: "\<lbrakk>n=0; n'=0\<rbrakk> \<Longrightarrow>G \<rhd> RVar x : (\<lambda>  E h  hh  v  p . variation h n hh n')"
apply (rule vdm_conseq)
apply (rule vdm_rvar)
apply clarsimp
apply (rule constHeapVari)
done

lemma vdm_prim_res1: "G \<rhd> Primop f x y  : (\<lambda>  E h  hh  v  p . variation h 0 hh 0)"
apply (rule vdm_conseq)
apply (rule vdm_prim)
apply clarsimp
apply (rule constHeapVari)
done

lemma vdm_prim_res2: "\<lbrakk>n=0\<rbrakk> \<Longrightarrow>G \<rhd> Primop f x y  : (\<lambda>  E h  hh  v  p . variation h n hh 0)"
apply (rule vdm_conseq)
apply (rule vdm_prim)
apply clarsimp
apply (rule constHeapVari)
done

lemma vdm_prim_res3: "\<lbrakk>n'=0\<rbrakk> \<Longrightarrow>G \<rhd> Primop f x y  : (\<lambda>  E h  hh  v  p . variation h 0 hh n')"
apply (rule vdm_conseq)
apply (rule vdm_prim)
apply clarsimp
apply (rule constHeapVari)
done

lemma vdm_prim_res4: "\<lbrakk>n=0; n'=0\<rbrakk> \<Longrightarrow>G \<rhd> Primop f x y  : (\<lambda>  E h  hh  v  p . variation h n hh n')"
apply (rule vdm_conseq)
apply (rule vdm_prim)
apply clarsimp
apply (rule constHeapVari)
done

lemma vdm_rprim_res1: "G \<rhd> RPrimop f x y  : (\<lambda>  E h  hh  v  p . variation h 0 hh 0)"
apply (rule vdm_conseq)
apply (rule vdm_rprim)
apply clarsimp
apply (rule constHeapVari)
done

lemma vdm_rprim_res2: "\<lbrakk>n=0\<rbrakk> \<Longrightarrow>G \<rhd> RPrimop f x y  : (\<lambda>  E h  hh  v  p . variation h n hh 0)"
apply (rule vdm_conseq)
apply (rule vdm_rprim)
apply clarsimp
apply (rule constHeapVari)
done

lemma vdm_rprim_res3: "\<lbrakk>n'=0\<rbrakk> \<Longrightarrow>G \<rhd> RPrimop f x y  : (\<lambda>  E h  hh  v  p . variation h 0 hh n')"
apply (rule vdm_conseq)
apply (rule vdm_rprim)
apply clarsimp
apply (rule constHeapVari)
done

lemma vdm_rprim_res4: "\<lbrakk>n=0; n'=0\<rbrakk> \<Longrightarrow>G \<rhd> RPrimop f x y  : (\<lambda>  E h  hh  v  p . variation h n hh n')"
apply (rule vdm_conseq)
apply (rule vdm_rprim)
apply clarsimp
apply (rule constHeapVari)
done


lemma vdm_getfi_res1: "G \<rhd> GetFi x f  : (\<lambda>  E h  hh  v  p . variation h 0 hh 0)"
apply (rule vdm_conseq)
apply (rule vdm_getfi)
apply clarsimp
apply (rule constHeapVari)
done

lemma vdm_getfi_res2: "\<lbrakk>n=0\<rbrakk> \<Longrightarrow>G \<rhd> GetFi x f  : (\<lambda>  E h  hh  v  p . variation h n hh 0)"
apply (rule vdm_conseq)
apply (rule vdm_getfi)
apply clarsimp
apply (rule constHeapVari)
done

lemma vdm_getfi_res3: "\<lbrakk>n'=0\<rbrakk> \<Longrightarrow>G \<rhd> GetFi x f   : (\<lambda>  E h  hh  v  p . variation h 0 hh n')"
apply (rule vdm_conseq)
apply (rule vdm_getfi)
apply clarsimp
apply (rule constHeapVari)
done

lemma vdm_geti_res4: "\<lbrakk>n=0; n'=0\<rbrakk> \<Longrightarrow>G \<rhd> GetFi x f  : (\<lambda>  E h  hh  v  p . variation h n hh n')"
apply (rule vdm_conseq)
apply (rule vdm_getfi)
apply clarsimp
apply (rule constHeapVari)
done

lemma vdm_getfr_res1: "G \<rhd> GetFr x f  : (\<lambda>  E h  hh  v  p . variation h 0 hh 0)"
apply (rule vdm_conseq)
apply (rule vdm_getfr)
apply clarsimp
apply (rule constHeapVari)
done

lemma vdm_getfr_res2: "\<lbrakk>n=0\<rbrakk> \<Longrightarrow>G \<rhd> GetFr x f  : (\<lambda>  E h  hh  v  p . variation h n hh 0)"
apply (rule vdm_conseq)
apply (rule vdm_getfr)
apply clarsimp
apply (rule constHeapVari)
done

lemma vdm_getfr_res3: "\<lbrakk>n'=0\<rbrakk> \<Longrightarrow>G \<rhd> GetFr x f   : (\<lambda>  E h  hh  v  p . variation h 0 hh n')"
apply (rule vdm_conseq)
apply (rule vdm_getfr)
apply clarsimp
apply (rule constHeapVari)
done

lemma vdm_getr_res4: "\<lbrakk>n=0; n'=0\<rbrakk> \<Longrightarrow>G \<rhd> GetFr x f  : (\<lambda>  E h  hh  v  p . variation h n hh n')"
apply (rule vdm_conseq)
apply (rule vdm_getfr)
apply clarsimp
apply (rule constHeapVari)
done

lemma vdm_putfi_res1: "G \<rhd> PutFi x f y : (\<lambda>  E h  hh  v  p . variation h 0 hh 0)"
apply (rule vdm_conseq)
apply (rule vdm_putfi)
apply (insert IfldVari)
apply clarsimp
done

lemma vdm_putfi_res2: "\<lbrakk>n=0\<rbrakk> \<Longrightarrow>G \<rhd> PutFi x f y : (\<lambda>  E h  hh  v  p . variation h n hh 0)"
apply (rule vdm_conseq)
apply (rule vdm_putfi)
apply (insert IfldVari)
apply clarsimp
done

lemma vdm_putfi_res3: "\<lbrakk>n'=0\<rbrakk> \<Longrightarrow>G \<rhd> PutFi x f y  : (\<lambda>  E h  hh  v  p . variation h 0 hh n')"
apply (rule vdm_conseq)
apply (rule vdm_putfi)
apply (insert IfldVari)
apply clarsimp
done

lemma vdm_putfi_res4: "\<lbrakk>n=0; n'=0\<rbrakk> \<Longrightarrow>G \<rhd> PutFi x f y : (\<lambda>  E h  hh  v  p . variation h n hh n')"
apply (rule vdm_conseq)
apply (rule vdm_putfi)
apply (insert IfldVari)
apply clarsimp
done

lemma vdm_putfr_res1: "\<lbrakk>f ~= DollarN; f ~= DollarF\<rbrakk> \<Longrightarrow> G \<rhd> PutFr x f y  : (\<lambda>  E h  hh  v  p . variation h 0 hh 0)"
apply (rule vdm_conseq)
apply (rule vdm_putfr)
apply (insert RfldVari)
apply clarsimp
done

lemma vdm_putfr_res2: "\<lbrakk>n=0; f ~= DollarN; f ~= DollarF\<rbrakk> \<Longrightarrow>G \<rhd> PutFr x f y  : (\<lambda>  E h  hh  v  p . variation h n hh 0)"
apply (rule vdm_conseq)
apply (rule vdm_putfr)
apply (insert RfldVari)
apply clarsimp
done

lemma vdm_putfr_res3: "\<lbrakk>n'=0; f ~= DollarN; f ~= DollarF\<rbrakk> \<Longrightarrow>G \<rhd> PutFr x f y   : (\<lambda>  E h  hh  v  p . variation h 0 hh n')"
apply (rule vdm_conseq)
apply (rule vdm_putfr)
apply (insert RfldVari)
apply clarsimp
done

lemma vdm_putfr_res4: "\<lbrakk>n=0; n'=0; f ~= DollarN; f ~= DollarF\<rbrakk> \<Longrightarrow>
                     G \<rhd> PutFr x f y  : (\<lambda>  E h  hh  v  p . variation h n hh n')"
apply (rule vdm_conseq)
apply (rule vdm_putfr)
apply (insert RfldVari)
apply clarsimp
done

lemma vdm_if_res: "\<lbrakk>G \<rhd> e1 : 
                   (\<lambda> E h hh v p . E<x>=grailbool True \<longrightarrow> variation h n hh n');
                    G \<rhd> e2 : 
                   (\<lambda> E h hh v p . E<x>=grailbool False \<longrightarrow> variation h n hh n')\<rbrakk> \<Longrightarrow>
                    G \<rhd> (IF x THEN e1 ELSE e2) : 
                            (\<lambda> E h hh v p . variation h n hh n')"
apply (rule vdm_conseq)
apply (rule vdm_if)
apply assumption
apply assumption
apply clarsimp
done

(********** help-stuff for let-rules *********************************)
(********** erule_tac for exI and allE does not work in a proper way *)

lemma allEInst: "\<lbrakk>stloc \<notin> Y; (rheap h DollarF stloc, h, Y, m) \<in> FreelistLoc; n + q \<le> m;
                  (\<forall> m Y q. stloc \<notin> Y   \<longrightarrow> 
                             (rheap h DollarF stloc, h, Y, m) \<in> FreelistLoc \<longrightarrow> 
                              n + q \<le> m \<longrightarrow> 
                              Q m Y q);
                  Q m Y q \<Longrightarrow> R\<rbrakk> \<Longrightarrow> R"
apply (erule allE)+
apply (drule mp)
apply assumption
apply (drule mp)
apply assumption
apply (drule mp)
apply assumption
apply blast
done


lemma delAssum: "\<lbrakk>P; Q; \<lbrakk>Q\<rbrakk>\<Longrightarrow> R\<rbrakk> \<Longrightarrow> R"
apply blast
done



lemma applVari1: "\<lbrakk>variation h n1 h1 n1'; variation h1 n2 hh n2';
                   n2 \<le> n1'; n = n1; n' = n2' + n1' - n2\<rbrakk>
                  \<Longrightarrow> variation h n hh n'"
apply (unfold variation_def)
apply (rule allI)+
apply (rule impI)+

apply (rotate_tac 5)
apply (erule allEInst)
apply assumption
apply (subgoal_tac "n1 + q \<le> m")
apply (rotate_tac 7)
apply assumption
apply simp
apply assumption


apply (erule delAssum)
apply assumption
apply (rotate_tac 1)
apply (erule delAssum)
apply assumption

apply (erule exE)+
apply (erule conjE)+
apply (erule allEInst)
apply assumption 
apply (subgoal_tac "n2+(q+n1'-n2)\<le>m'")
apply (rotate_tac 10)
apply assumption 
apply simp
apply assumption 

apply (erule exE)+
apply (erule conjE)+

apply (rule exI)+

apply (rule conjI)
apply assumption

apply (rule conjI)
apply assumption

apply (rule conjI)
apply arith

apply simp
done

lemma applVari2: "\<lbrakk>variation h n1 h1 n1'; variation h1 n2 hh n2';
                   n1'<n2; n = n1+(n2-n1'); n'=n2'\<rbrakk>
                  \<Longrightarrow> variation h n hh n'"
apply (unfold variation_def)
apply (rule allI)+
apply (rule impI)+

apply (rotate_tac 5)
apply (erule allEInst)
apply assumption
apply (subgoal_tac "n1 + (q+ (n2 - n1')) \<le> m")
apply (rotate_tac 7)
apply assumption
apply arith
apply assumption


apply (erule delAssum)
apply assumption
apply (rotate_tac 1)
apply (erule delAssum)
apply assumption

apply (erule exE)+
apply (erule conjE)+
apply (erule allEInst)
apply assumption 
apply (subgoal_tac "n2+q\<le>m'")
apply (rotate_tac 10)
apply assumption 
apply arith
apply assumption 

apply (erule exE)+
apply (erule conjE)+

apply (rule exI)+

apply (rule conjI)
apply assumption

apply (rule conjI)
apply assumption

apply (rule conjI)
apply arith

apply simp
done


lemma applVari: "\<lbrakk>variation h n1 h1 n1'; variation h1 n2 hh n2';
                 n2 \<le> n1' \<longrightarrow> n = n1 \<and> n' = n2' + n1' - n2; 
                  n1' < n2 \<longrightarrow> n = n1 + n2 - n1' \<and> n' = n2'\<rbrakk>
                  \<Longrightarrow> variation h n hh n'"
apply (case_tac "n2 \<le> n1'")

apply (drule mp)
apply assumption
apply (erule conjE)
apply (rule applVari1)
apply assumption+

apply (subgoal_tac "n1' < n2")
prefer 2
apply arith
apply (rotate_tac 3)
apply (drule mp)
apply assumption
apply (erule conjE)
apply (rule applVari2)
apply assumption+
apply simp
apply assumption
done

lemma vdm_leti_res: " \<lbrakk>G \<rhd> e1 : (\<lambda> E h hh v p . variation  h n1 hh n1');
                      G \<rhd> e2 : (\<lambda> E h hh v p . variation  h n2 hh n2');
                      n2 \<le> n1' \<longrightarrow> n=n1 \<and> n'=n2'+(n1'-n2);
                      n1' < n2 \<longrightarrow> n=n1+(n2-n1') \<and> n'=n2'\<rbrakk> \<Longrightarrow>
           G \<rhd> (Leti x e1 e2) :
                (\<lambda> E h hh v p  . variation  h n hh n')"
apply (rule vdm_conseq)
apply (rule vdm_leti)
apply assumption+
apply clarsimp
apply (rule applVari)
apply assumption+
done

lemma vdm_letr_res: " \<lbrakk>G \<rhd> e1 : (\<lambda> E h hh v p . variation  h n1 hh n1');
                     G \<rhd> e2 : (\<lambda> E h hh v p . variation  h n2 hh n2');
                      n2 \<le> n1' \<longrightarrow> n=n1 \<and> n'=n2'+(n1'-n2);
                      n1' < n2 \<longrightarrow> n=n1+(n2-n1') \<and> n'=n2'\<rbrakk> \<Longrightarrow>
           G \<rhd> (Letr x e1 e2) :
                (\<lambda> E h hh v p  . variation  h n hh n')"
apply (rule vdm_conseq)
apply (rule vdm_letr)
apply assumption+
apply clarsimp
apply (rule applVari)
apply assumption+
done

lemma vdm_letv_res: " \<lbrakk>G \<rhd> e1 : (\<lambda> E h hh v p . variation  h n1 hh n1');
                     G \<rhd> e2 : (\<lambda> E h hh v p . variation  h n2 hh n2');
                      n2 \<le> n1' \<longrightarrow> n=n1 \<and> n'=n2'+(n1'-n2);
                      n1' < n2 \<longrightarrow> n=n1+(n2-n1') \<and> n'=n2'\<rbrakk> \<Longrightarrow>
           G \<rhd> (Letv e1 e2) :
                (\<lambda> E h hh v p  . variation  h n hh n')"
apply (rule vdm_conseq)
apply (rule vdm_letv)
apply assumption+
apply clarsimp
apply (rule applVari)
apply assumption+
done



lemma vdm_call_res: "({(Call f, (\<lambda> E h hh v p  . variation  h n hh n'))} \<union> G ) \<rhd> funtable f : (\<lambda> E h hh v p  . variation h n hh n')\<Longrightarrow>
                     G \<rhd> Call f : (\<lambda> E h hh v p  . variation  h n hh n')"
apply (rule vdm_call)
apply assumption
done


end 


