header {*Combinators*}
(*<*)
theory Comb = VDMderivedPC:
(*>*)

subsection {* Logical combinators*}
constdefs AND:: "[vdmassn, vdmassn] \<Rightarrow> vdmassn" (infixr "&&" 0)
  "AND ve1 ve2 E h hh v p == (ve1 E h hh v p \<and> ve2 E h hh v p)"

constdefs impliesAssn::"vdmassn \<Rightarrow> vdmassn \<Rightarrow> vdmassn"
  "impliesAssn P Q E h hh v p == (P E h hh v p \<longrightarrow> Q E h hh v p)"

constdefs IMPLIES::"vdmassn \<Rightarrow> vdmassn \<Rightarrow> bool"
  "IMPLIES P Q == (\<forall> E h hh v p . (P  E h hh v p ) \<longrightarrow> (Q  E h hh v p))"

constdefs EXloc::"(locn \<Rightarrow> vdmassn) \<Rightarrow> vdmassn"
  "EXloc P E h hh v p == (\<exists> l . P l E h hh v p)"

constdefs ALLnat::"(nat \<Rightarrow> vdmassn) \<Rightarrow> vdmassn"
  "ALLnat P E h hh v p == (\<forall> n . P n E h hh v p)"

lemmas logic_predicates = AND_def IMPLIES_def EXloc_def

subsection {*Combinators for values, heaps and resources*}
text {*Value assertions relate result values to environments and initial heaps.*}
types "valExpr" = "[env, heap, val] \<Rightarrow> bool"

constdefs 
constVE:: "val \<Rightarrow> valExpr" 
  "constVE w E h v == (w = v) "
ivarVE:: "iname \<Rightarrow> valExpr"
  "ivarVE x E h v == (\<exists> i. E<x> = i \<and> v = IVal i)"
rvarVE:: "rname \<Rightarrow> valExpr"
  "rvarVE x E h v == (\<exists> r. E\<lfloor>x\<rfloor> = r \<and> v = RVal r)"
idotVE::"valExpr \<Rightarrow> ifldname \<Rightarrow> valExpr"
  "idotVE ve f E h v == (\<exists> l. ve E h (RVal (Ref l)) \<and> constVE (IVal(h<l\<bullet>f>)) E h v)"
rdotVE::"valExpr \<Rightarrow> rfldname \<Rightarrow> valExpr"
  "rdotVE ve f E h v == (\<exists> l. ve E h (RVal (Ref l)) \<and> constVE (RVal(h\<lfloor>l\<diamondsuit>f\<rfloor>)) E h v)"
iopVE::"valExpr \<Rightarrow> (int \<Rightarrow> int \<Rightarrow> int) \<Rightarrow> valExpr \<Rightarrow> valExpr"
  "iopVE ve1 f ve2 E h v == (\<exists> i1 i2. ve1 E h (IVal i1) \<and> ve2 E h (IVal i2) \<and> v = IVal (f i1 i2))"
ropVE::"valExpr \<Rightarrow> (ref \<Rightarrow> ref \<Rightarrow> int) \<Rightarrow> valExpr \<Rightarrow> valExpr"
  "ropVE ve1 f ve2 E h v == (\<exists> r1 r2. ve1 E h (RVal r1) \<and> ve2 E h (RVal r2) \<and> v = IVal (f r1 r2))"

lemmas valExpr_predicates = constVE_def ivarVE_def rvarVE_def idotVE_def rdotVE_def 
                            iopVE_def ropVE_def

constdefs ResultIs::"valExpr \<Rightarrow> vdmassn"
"ResultIs ve E h hh v p == ve E h v"

text {*Heap assertions relate final heaps to environments and initial heaps.*}
types "heapExpr" = "[env, heap, heap] \<Rightarrow> bool"

constdefs 
Same::heapExpr
  "Same E h hh \<equiv> (h = hh)"
iUpd::"heapExpr \<Rightarrow> valExpr \<Rightarrow> ifldname \<Rightarrow> valExpr \<Rightarrow> heapExpr"
  "iUpd he ve1 f ve2 E h hh \<equiv> 
      (\<exists> h' . he E h h' \<and> (\<exists> l i. hh = h'\<lparr>iheap := (iheap h')(f := (iheap h' f)(l:=i))\<rparr> \<and> 
                                   ve1 E h' (RVal (Ref l)) \<and> 
                                   ve2 E h' (IVal i)))"
rUpd::"heapExpr \<Rightarrow> valExpr \<Rightarrow> rfldname \<Rightarrow> valExpr \<Rightarrow> heapExpr"
  "rUpd he ve1 f ve2 E h hh \<equiv>
      (\<exists> h' . he E h h' \<and> (\<exists> l r. hh = h'\<lparr>rheap := (rheap h')(f := (rheap h' f)(l:=r))\<rparr> \<and> 
                                   ve1 E h' (RVal (Ref l)) \<and> 
                                   ve2 E h' (RVal r)))"
constdefs extendHE::"heapExpr \<Rightarrow> cname \<Rightarrow> locn \<Rightarrow> (ifldname \<times> iname) list \<Rightarrow>
                    (rfldname \<times> rname) list \<Rightarrow> heapExpr"
  "extendHE he c l iflds rflds E h hh \<equiv>
     (\<exists> h' . he E h h' \<and> (l = freshloc (Dom h')) \<and> (hh = newObj h' l E c iflds rflds))"

constdefs HeapIs::"heapExpr \<Rightarrow> vdmassn"
"HeapIs he E h hh v p == he E h hh"

lemmas heap_predicates = iUpd_def rUpd_def Same_def extendHE_def

text {*Resourse assertions for the various cost components.*}
constdefs 
ticks::"valExpr \<Rightarrow> vdmassn"
  "ticks ve E h hh v p == (\<exists> i. ve E h (IVal i) \<and> clock p = i)"
calls::"valExpr \<Rightarrow> vdmassn"
  "calls ve E h hh v p == (\<exists> i. ve E h (IVal i) \<and> callc p = i)"
invokes::"valExpr \<Rightarrow> vdmassn"
  "invokes ve E h hh v p == (\<exists> i. ve E h (IVal i) \<and> invkc p = i)"
depth::"valExpr \<Rightarrow> vdmassn"
  "depth ve E h hh v p == (\<exists> i. ve E h (IVal i) \<and> (int (invkdpth p)) = i)"
allocates::"valExpr \<Rightarrow> vdmassn"
  "allocates ve E h hh v p == ve E h (IVal ((HSize hh) - (HSize h)))"

constdefs 
costs::"[int, int, int, int, nat] \<Rightarrow> vdmassn "
  "costs a t c i d == (allocates (constVE (IVal a)) && ticks (constVE (IVal t)) &&
                       calls (constVE (IVal c)) && invokes (constVE (IVal i)) &&
                       depth (constVE (IVal (int d))))"

tickCosts::"int \<Rightarrow> vdmassn"
  "tickCosts t == costs 0 t 0 0 0"

lemmas cost_predicates = tickCosts_def costs_def allocates_def ticks_def calls_def invokes_def depth_def

subsection {*Combinators for complex instructions, calls and invocations*}
constdefs condComb:: "iname \<Rightarrow> vdmassn \<Rightarrow> vdmassn \<Rightarrow> vdmassn"
"condComb x P1 P2 E h hh v p == 
  (\<exists> pp . p = tkn 2 pp \<and> (E<x> = grailbool True \<or> E<x> = grailbool False) \<and>
          (if E<x> = grailbool True then (P1  E h hh v pp) else (P2 E h hh v pp)))"

constdefs letiComb:: "iname \<Rightarrow> vdmassn \<Rightarrow> vdmassn \<Rightarrow> vdmassn"
"letiComb x P1 P2 E h hh v p == 
  (\<exists> p1 p2 h1 i . (P1 E h h1 (IVal i) p1) \<and> (P2 (E<x:=i>) h1 hh v p2) \<and>
                   p = tk (p1 \<smile> p2))"

constdefs letrComb:: "rname \<Rightarrow> vdmassn \<Rightarrow> vdmassn \<Rightarrow> vdmassn"
"letrComb x P1 P2 E h hh v p == 
  (\<exists> p1 p2 h1 r . (P1 E h h1 (RVal r) p1) \<and> (P2 (E\<lfloor>x:=r\<rfloor>) h1 hh v p2) \<and>
                   p = tk (p1 \<smile> p2))"
constdefs letvComb:: "vdmassn \<Rightarrow> vdmassn \<Rightarrow> vdmassn"
  "letvComb P1 P2 E h hh v p == 
  (\<exists> p1 p2 h1 w . (P1 E h h1 w p1) \<and> (P2  E h1 hh v p2) \<and> p = (p1 \<smile> p2))"

constdefs tkCallAssn::"vdmassn \<Rightarrow> vdmassn"
"tkCallAssn P E h hh v p == P E h hh v (tkcall p)"


lemmas assn_predicates = HeapIs_def ResultIs_def condComb_def letiComb_def letrComb_def 
                         letvComb_def tkCallAssn_def
lemmas predicates = assn_predicates valExpr_predicates heap_predicates cost_predicates
                    logic_predicates

text {*Lemmas proving the coincidence of combinator specifications to
       specifications used in the rules of the axiomatic semantics.*}

lemma NULLcomb:
      "((HeapIs Same) && (ResultIs (constVE (RVal Nullref))) && (tickCosts 1)) =
       (\<lambda>  E h  hh  v  p . hh = h \<and> v = RVal Nullref \<and> p = tickRo)"
(*<*)by (rule+, (simp add: predicates)+)(*>*)

lemma IFcomb:
  "(condComb x P1 P2) = 
   (\<lambda> E h hh v p . \<exists> pp. p = tkn 2 pp \<and> 
                               (E<x> = grailbool True \<longrightarrow> (P1  E h hh v pp  )) \<and> 
                               (E<x> = grailbool False \<longrightarrow> (P2  E h hh v pp  )) \<and>
                               (E<x> = grailbool True \<or> E<x> = grailbool False))"
(*<*)by ((rule ext)+, simp_all add:predicates, auto)(*>*)

lemma LETIcomb:
  "letiComb x P1 P2 =
   (\<lambda> E h hh v p  . \<exists> p1 p2 h1 i . (P1 E h h1 (IVal i) p1) \<and> (P2 (E<x:=i>) h1 hh v p2) \<and> p = tk (p1 \<smile> p2))"
(*<*)by ((rule ext)+, simp_all add:predicates)(*>*)

lemma LETRcomb:
  "letrComb x P1 P2 =
   (\<lambda> E h hh v p  . \<exists> p1 p2 h1 r . (P1 E h h1 (RVal r) p1) \<and> (P2 (E\<lfloor>x:=r\<rfloor>) h1 hh v p2) \<and> p = tk (p1 \<smile> p2))"
(*<*)by ((rule ext)+, simp_all add:predicates)(*>*)

lemma LETVcomb:
  "letvComb P1 P2 =
   (\<lambda> E h hh v p  . \<exists> p1 p2 h1 w . (P1 E h h1 w p1) \<and> (P2  E h1 hh v p2) \<and> p = (p1 \<smile> p2))"
(*<*)by ((rule ext)+, simp_all add:predicates)(*>*)

lemma NEWcomb:
  "EXloc (\<lambda> l . (HeapIs (extendHE Same c l iflds rflds) &&
                        ResultIs (constVE (RVal (Ref l))) &&
                        costs 1 1 0 0 0))=
   (\<lambda> E h hh v p  . \<exists> l . l = freshloc (fmap_dom (heap.oheap h)) \<and> 
                                    hh = newObj h l E c iflds rflds \<and>
                                    v = RVal (Ref l) \<and>
                                    p = tickRo)" 
(*<*)by ((rule ext)+, rule, simp_all add:predicates newObj_def)(*>*)

lemma INTcomb:
      "((HeapIs Same) && (ResultIs (constVE (IVal i))) && (tickCosts 1)) = 
       (\<lambda>  E h hh v p . hh = h \<and> v = IVal i \<and> p = tickRo)"
(*<*)by (rule+, (simp add: predicates)+)(*>*)

lemma IVARcomb:
      "((HeapIs Same) && (ResultIs (ivarVE x)) && (tickCosts 1)) = 
       (\<lambda> E h hh v p . hh = h \<and> v = IVal (E<x>) \<and> p = tickRo)"
(*<*)by (rule+, (simp add: predicates)+)(*>*)

lemma RVARcomb:
      "((HeapIs Same) && (ResultIs (rvarVE x)) && (tickCosts 1)) = 
       (\<lambda> E h hh v p . hh = h \<and> v = RVal (E\<lfloor>x\<rfloor>) \<and> p = tickRo)"
(*<*)by (rule+, (simp add: predicates)+)(*>*)

lemma PRIMcomb:
      "((HeapIs Same) && (ResultIs (iopVE (ivarVE x) f (ivarVE y))) && (tickCosts 3)) =
       (\<lambda> E h hh v p  . hh = h \<and> v = IVal (f (E<x>) (E<y>)) \<and> p = \<langle>3 0 0 0\<rangle>)"
(*<*)by (rule+, (simp add: predicates)+)(*>*)

lemma RPRIMcomb:
      "((HeapIs Same) && (ResultIs (ropVE (rvarVE x) f (rvarVE y))) && (tickCosts 3)) =
       (\<lambda> E h hh v p  . hh = h \<and> v = IVal (f (E\<lfloor>x\<rfloor>) (E\<lfloor>y\<rfloor>)) \<and> p = \<langle>3 0 0 0\<rangle>)"
(*<*)by (rule+, (simp add: predicates)+)(*>*)

lemma GETFIcomb:
      "((HeapIs Same) && (ResultIs (idotVE (rvarVE x) f)) && (tickCosts 2)) =
       (\<lambda> E h hh v p  . \<exists> a . E\<lfloor>x\<rfloor> = Ref a \<and> hh = h \<and> v = IVal ((heap.iheap hh) f a) \<and> p = \<langle>2 0 0 0\<rangle> )"
(*<*)
apply (rule ext)+
apply rule
apply (simp_all add: predicates)
apply clarsimp
apply (rule_tac x=l in exI, simp)
apply clarsimp
done
(*>*)

lemma GETFRcomb:
  "((HeapIs Same) && (ResultIs (rdotVE (rvarVE x) f)) && (tickCosts 2)) =
   (\<lambda> E h hh v p  . \<exists> a . E\<lfloor>x\<rfloor> = Ref a \<and> hh = h \<and> v = RVal ((heap.rheap hh) f a) \<and> p = \<langle>2 0 0 0\<rangle>)"
(*<*)
apply (rule ext)+
apply rule
apply (simp_all add: predicates)
apply force+
done
(*>*)

lemma PUTFIcomb: 
  "((HeapIs (iUpd Same (rvarVE x) f (ivarVE y))) && (ResultIs (constVE arbitrary)) && (tickCosts 3)) = 
   (\<lambda> E h hh v p  . \<exists> a . E\<lfloor>x\<rfloor>  = Ref a \<and> hh = h<a\<bullet>f:=E<y>> \<and> v = arbitrary \<and>  p = \<langle>3 0 0 0\<rangle>)"
(*<*)
apply (rule ext)+
apply rule
apply (simp_all add: predicates)
apply force+
done
(*>*)

lemma PUTFRcomb: 
  "((HeapIs (rUpd Same (rvarVE x) f (rvarVE y))) && (ResultIs (constVE arbitrary)) && (tickCosts 3)) =
   (\<lambda> E h hh v p  . \<exists> a . E\<lfloor>x\<rfloor>  = Ref a \<and> hh = h\<lfloor>a\<diamondsuit>f:=E\<lfloor>y\<rfloor>\<rfloor> \<and> v = arbitrary \<and> p = \<langle>3 0 0 0\<rangle>)"
(*<*)
apply (rule ext)+
apply rule
apply (simp_all add: predicates)
apply force+
done
(*>*)

lemmas Comb_preds = NULLcomb IFcomb LETIcomb LETRcomb LETVcomb NEWcomb INTcomb IVARcomb RVARcomb
                    PRIMcomb RPRIMcomb GETFIcomb  GETFRcomb PUTFIcomb PUTFRcomb

subsection {*Derived axiomatic rules with combinators*}
lemma vdmC_null: "G \<rhd>  NULL : ((HeapIs Same) && (ResultIs (constVE (RVal Nullref)))
                                       && (tickCosts 1))"
by(simp add:Comb_preds vdm_basics)

lemma vdmC_int: "G \<rhd>  expr.Int i : ((HeapIs Same) && (ResultIs (constVE (IVal i))) && (tickCosts 1))"
by(simp add:Comb_preds vdm_basics)

lemma vdmC_ivar: "G \<rhd> IVar x : ((HeapIs Same) && (ResultIs (ivarVE x)) && (tickCosts 1))"
by(simp add:Comb_preds vdm_basics)

lemma vdmC_rvar: "G \<rhd> RVar x : ((HeapIs Same) && (ResultIs (rvarVE x)) && (tickCosts 1))"
by(simp add:Comb_preds vdm_basics)

lemma vdmC_prim: "G \<rhd> Primop f x y : ((HeapIs Same) && (ResultIs (iopVE (ivarVE x) f (ivarVE y))) && (tickCosts 3))"
by(simp add:Comb_preds vdm_basics)

lemma vdmC_rprim: "G \<rhd> RPrimop f x y : ((HeapIs Same) && (ResultIs (ropVE (rvarVE x) f (rvarVE y))) && (tickCosts 3))"
by(simp add:Comb_preds vdm_basics)

lemma vdmC_getfi: "G \<rhd> GetFi x f : ((HeapIs Same) && (ResultIs (idotVE (rvarVE x) f)) && (tickCosts 2))"
by(simp add:Comb_preds vdm_basics)

lemma vdmC_getfr: "G \<rhd> GetFr x f : ((HeapIs Same) && (ResultIs (rdotVE (rvarVE x) f)) && (tickCosts 2))"
by(simp add:Comb_preds vdm_basics)

lemma vdmC_putfi: "G \<rhd> PutFi x f y : ((HeapIs (iUpd Same (rvarVE x) f (ivarVE y))) &&
                                 (ResultIs (constVE arbitrary)) && (tickCosts 3))"
by(simp add:Comb_preds, rule vdm_conseq, auto intro!: vdm_basics)

lemma vdmC_putfr: "G \<rhd> PutFr x f y : ((HeapIs (rUpd Same (rvarVE x) f (rvarVE y))) &&
                                 (ResultIs (constVE arbitrary)) && (tickCosts 3))"

by(simp add:Comb_preds, rule vdm_conseq, auto intro!: vdm_basics)

lemma vdmC_if: "\<lbrakk>G \<rhd> e1 : P1; G \<rhd> e2 : P2\<rbrakk> \<Longrightarrow> G \<rhd> (IF x THEN e1 ELSE e2) : (condComb x P1 P2)"
by(simp add:Comb_preds, rule vdm_conseq, auto intro!: vdm_if)

lemma vdmC_leti: "\<lbrakk>G \<rhd> e1 : P1; G \<rhd> e2 : P2\<rbrakk> \<Longrightarrow> G \<rhd> (Leti x e1 e2) : letiComb x P1 P2"
by(simp add:Comb_preds, rule vdm_conseq, rule vdm_basics, auto)

lemma vdmC_letr: "\<lbrakk>G \<rhd> e1 : P1; G \<rhd> e2 : P2\<rbrakk> \<Longrightarrow> G \<rhd> (Letr x e1 e2) : letrComb x P1 P2"
by(simp add:Comb_preds, rule vdm_conseq, rule vdm_basics, auto)

lemma vdmC_letv: "\<lbrakk>G \<rhd> e1 : P1; G \<rhd> e2 : P2\<rbrakk> \<Longrightarrow> G \<rhd> (Letv e1 e2) : letvComb P1 P2"
by(simp add:Comb_preds, rule vdm_conseq, rule vdm_basics, auto)

lemma vdmC_conseq: "\<lbrakk>G \<rhd> e : P; IMPLIES P Q\<rbrakk> \<Longrightarrow> G \<rhd> e : Q"
by(simp only:logic_predicates, rule vdm_conseq,auto)

lemma vdmC_new: "G \<rhd> New c iflds rflds : 
          EXloc (\<lambda> l . (HeapIs (extendHE Same c l iflds rflds) &&
                        ResultIs (constVE (RVal (Ref l))) &&
                        costs 1 1 0 0 0))"
by(simp add:Comb_preds, rule vdm_conseq, rule vdm_basics, auto)

lemmas vdmC_basics  = vdmC_null vdmC_int vdmC_ivar vdmC_rvar 
                      vdmC_prim vdmC_rprim vdmC_getfi vdmC_getfr 
                      vdmC_putfi vdmC_putfr vdmC_new vdmC_if 
                      vdmC_leti vdmC_letr vdmC_letv 

lemmas vdmC_logic = vdmC_conseq

subsection {* Elimination rules for primops *}
lemma IconstElim:
      "\<lbrakk>(HeapIs Same && ResultIs (constVE (IVal i)) && tickCosts n) E h hh v p;
        \<lbrakk>h = hh; v = IVal i; p = \<langle>n 0 0 0\<rangle>\<rbrakk> \<Longrightarrow> R
       \<rbrakk>  \<Longrightarrow> R"
by (simp add: predicates)

lemma RconstElim:
      "\<lbrakk>(HeapIs Same && ResultIs (constVE (RVal r)) && tickCosts n) E h hh v p;
        \<lbrakk>h = hh; v = RVal r; p = \<langle>n 0 0 0\<rangle>\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates)

lemma IvarElim:
      "\<lbrakk>(HeapIs Same && ResultIs (ivarVE y) && tickCosts n) E h hh v p;
        \<lbrakk>h = hh; v = IVal (E<y>); p = \<langle>n 0 0 0\<rangle>\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates)

lemma RvarElim:
      "\<lbrakk>(HeapIs Same && ResultIs (rvarVE y) && tickCosts n) E h hh v p;
        \<lbrakk>h = hh; v = RVal (E\<lfloor>y\<rfloor>);  p = \<langle>n 0 0 0\<rangle>\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates)

lemma IopElim:
      "\<lbrakk>(HeapIs Same && ResultIs (iopVE (ivarVE x) f (ivarVE y)) && tickCosts n) E h hh v p;
        (ivarVE x) E h (IVal i);
        (ivarVE y) E h (IVal j);
        \<lbrakk>h = hh; v = IVal (f (E<x>) (E<y>));  p = \<langle>n 0 0 0\<rangle>\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates)

lemma RopElim:
      "\<lbrakk>(HeapIs Same && ResultIs (ropVE (rvarVE x) f (rvarVE y)) && tickCosts n) E h hh v p;
        \<lbrakk>h = hh; v = IVal (f (E\<lfloor>x\<rfloor>) (E\<lfloor>y\<rfloor>));  p = \<langle>n 0 0 0\<rangle>\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates)

lemma GetfiElim:
      "\<lbrakk>(HeapIs Same && ResultIs (idotVE (rvarVE y) F ) && tickCosts n) E h hh v p;
        E\<lfloor>y\<rfloor> = Ref l; 
        \<lbrakk>h = hh; v = IVal (h<l\<bullet>F>);  p = \<langle>n 0 0 0\<rangle>\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates, auto)

lemma GetfrElim:
      "\<lbrakk>(HeapIs Same && ResultIs (rdotVE (rvarVE y) F ) && tickCosts n) E h hh v p;
        E\<lfloor>y\<rfloor> = Ref l; 
        \<lbrakk>h = hh; v = RVal (h\<lfloor>l\<diamondsuit>F\<rfloor>); p = \<langle>n 0 0 0\<rangle>\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates, auto)

lemma PutfiElim:
      "\<lbrakk>(HeapIs (iUpd Same (rvarVE x) F (ivarVE y)) && 
         ResultIs (constVE arbitrary) && tickCosts n) E h hh v p;
        E\<lfloor>x\<rfloor> = Ref a;
        \<lbrakk>hh = h<a\<bullet>F:=E<y>>; v = arbitrary; p = \<langle>n 0 0 0\<rangle>\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates)

lemma PutfrElim:
      "\<lbrakk>(HeapIs (rUpd Same (rvarVE x) F (rvarVE y)) && 
         ResultIs (constVE arbitrary) && tickCosts n) E h hh v p;
        E\<lfloor>x\<rfloor> = Ref a;
        \<lbrakk>hh = h\<lfloor>a\<diamondsuit>F:=E\<lfloor>y\<rfloor>\<rfloor>; v = arbitrary; p = \<langle>n 0 0 0\<rangle>\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates)

lemma NewElim:
      "\<lbrakk>(EXloc (\<lambda> l . (HeapIs (extendHE Same c l iflds rflds) &&
                        ResultIs (constVE (RVal (Ref l))) &&
                        costs 1 1 0 0 0))) E h hh v p;
         l = (freshloc (fmap_dom (oheap h)));
        \<lbrakk>hh = (newObj h l E c iflds rflds); v = RVal (Ref l); p = \<langle>1 0 0 0\<rangle>\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates)

lemmas primElims = IconstElim RconstElim IvarElim RvarElim IopElim RopElim 
                   GetfiElim GetfrElim PutfiElim PutfrElim NewElim

subsection {* Elimination rules for let-primop combinations*} 
lemma LetIconstElim:
      "\<lbrakk>letiComb x (HeapIs Same && ResultIs (constVE (IVal i)) && tickCosts n) Q E h hh v p;
        \<lbrakk>Q (E<x:=i>) h hh v (tkn (- n - 1) p)\<rbrakk> \<Longrightarrow> R
       \<rbrakk>  \<Longrightarrow> R"
by (simp add: predicates, clarsimp,
    subgoal_tac "p2 = (mkRescomp (clock p2) (callc p2) (invkc p2) (invkdpth p2))", auto)

lemma LetRconstElim:
      "\<lbrakk>letrComb x (HeapIs Same && ResultIs (constVE (RVal r)) && tickCosts n) Q E h hh v p;
        \<lbrakk>Q (E\<lfloor>x:=r\<rfloor>) h hh v (tkn (- n - 1) p)\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates, clarsimp,
    subgoal_tac "p2 = (mkRescomp (clock p2) (callc p2) (invkc p2) (invkdpth p2))", auto)

lemma LetIvarElim:
      "\<lbrakk>letiComb x (HeapIs Same && ResultIs (ivarVE y) && tickCosts n) Q E h hh v p;
        (ivarVE y) E h (IVal i);
        \<lbrakk>Q (E<x:=i>) h hh v (tkn (- n - 1) p)\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates, clarsimp,
    subgoal_tac "p2 = (mkRescomp (clock p2) (callc p2) (invkc p2) (invkdpth p2))", auto)

lemma LetRvarElim:
      "\<lbrakk>letrComb x (HeapIs Same && ResultIs (rvarVE y) && tickCosts n) Q E h hh v p;
        (rvarVE y) E h (RVal r);
        \<lbrakk>Q (E\<lfloor>x:=r\<rfloor>) h hh v (tkn (-n - 1) p)\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates, clarsimp,
    subgoal_tac "p2 = (mkRescomp (clock p2) (callc p2) (invkc p2) (invkdpth p2))", auto)

lemma LetIopElim:
      "\<lbrakk>letiComb z (HeapIs Same && ResultIs (iopVE (ivarVE x) f (ivarVE y)) && tickCosts n) Q E h hh v p;
        (ivarVE x) E h (IVal i);
        (ivarVE y) E h (IVal j);
        \<lbrakk>Q (E<z:=f i j>) h hh v (tkn (-n - 1) p)\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates, clarsimp,
    subgoal_tac "p2 = (mkRescomp (clock p2) (callc p2) (invkc p2) (invkdpth p2))", auto)

lemma LetRopElim:
      "\<lbrakk>letiComb z (HeapIs Same && ResultIs (ropVE (rvarVE x) f (rvarVE y)) && tickCosts n) Q E h hh v p;
        (rvarVE x) E h (RVal i);
        (rvarVE y) E h (RVal j);
        \<lbrakk>Q (E<z:=f i j>) h hh v (tkn (-n - 1) p)\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates, clarsimp,
    subgoal_tac "p2 = (mkRescomp (clock p2) (callc p2) (invkc p2) (invkdpth p2))", auto)

lemma LetGetfiElim:
      "\<lbrakk>letiComb x (HeapIs Same && ResultIs (idotVE (rvarVE y) F ) && tickCosts n) Q E h hh v p;
        idotVE (rvarVE y) F E h (IVal i);
        \<lbrakk>Q (E<x:=i>) h hh v (tkn (- n - 1) p)\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates, clarsimp,
    subgoal_tac "Ref l = Ref la", clarify,
    subgoal_tac "p2 = (mkRescomp (clock p2) (callc p2) (invkc p2) (invkdpth p2))", auto)

lemma LetGetfrElim:
      "\<lbrakk>letrComb x (HeapIs Same && ResultIs (rdotVE (rvarVE y) F ) && tickCosts n) Q E h hh v p;
        rdotVE (rvarVE y) F E h (RVal r);
        \<lbrakk>Q (E\<lfloor>x:=r\<rfloor>) h hh v (tkn (- n - 1) p)\<rbrakk> \<Longrightarrow>R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates, clarsimp,
    subgoal_tac "Ref l = Ref la", clarify,
    subgoal_tac "p2 = (mkRescomp (clock p2) (callc p2) (invkc p2) (invkdpth p2))", auto)

lemma LetPutfiElim:
      "\<lbrakk>letvComb (HeapIs (iUpd Same (rvarVE x) F (ivarVE y)) && 
                  ResultIs (constVE arbitrary) && tickCosts n) Q E h hh v p;
        E\<lfloor>x\<rfloor> = Ref a;
        \<lbrakk>Q E (h<a\<bullet>F:=E<y>>) hh v (tkn (- n) p)\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates, clarsimp,
    subgoal_tac "p2 = (mkRescomp (clock p2) (callc p2) (invkc p2) (invkdpth p2))", auto)

lemma LetPutfrElim:
      "\<lbrakk>letvComb (HeapIs (rUpd Same (rvarVE x) F (rvarVE y)) && ResultIs (constVE arbitrary) && tickCosts n) Q E h hh v p;
        E\<lfloor>x\<rfloor> = Ref a;
        \<lbrakk>Q E (h\<lfloor>a\<diamondsuit>F:=E\<lfloor>y\<rfloor>\<rfloor>) hh v (tkn ( - n) p)\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates, clarsimp,
    subgoal_tac "p2 = (mkRescomp (clock p2) (callc p2) (invkc p2) (invkdpth p2))", auto)

lemma LetNewElim:
      "\<lbrakk>letrComb x (EXloc (\<lambda> l . (HeapIs (extendHE Same c l iflds rflds) &&
                        ResultIs (constVE (RVal (Ref l))) &&
                        costs 1 1 0 0 0))) Q E h hh v p;
         l = (freshloc (fmap_dom (oheap h)));
        \<lbrakk>Q (E\<lfloor>x:=Ref l\<rfloor>) (newObj h l E c iflds rflds) hh v (tkn (-2) p)\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates newObj_def, clarsimp,
    subgoal_tac "p2 = (mkRescomp (clock p2) (callc p2) (invkc p2) (invkdpth p2))", auto)

lemma CondElim:
      "\<lbrakk>condComb b P Q E h hh v p; 
        \<lbrakk>E<b>=grailbool True; P E h hh v (tkn (- 2) p)\<rbrakk> \<Longrightarrow> R; 
        \<lbrakk>E<b>=grailbool False; Q E h hh v (tkn (- 2) p)\<rbrakk> \<Longrightarrow> R
       \<rbrakk> \<Longrightarrow> R"
by (simp add: predicates,
    (subgoal_tac "pp = (mkRescomp (clock pp) (callc pp) (invkc pp) (invkdpth pp))", auto)+)

lemma LetiElim:
     "\<lbrakk>letiComb x P Q E h hh v p;
         \<forall> p1 p2 h1 i n m f2 . (P E h h1 (IVal i) p1 \<and> 
                                (Q (E<x:=i>) h1 hh v p2 \<and> p = tk (p1 \<smile> p2)) \<longrightarrow> R)
       \<rbrakk> \<Longrightarrow> R"
by (simp add: letiComb_def)

lemma LetrElim:
     "\<lbrakk>letrComb x P Q E h hh v p;
         \<forall> p1 p2 h1 r n m f2 . (P E h h1 (RVal r) p1 \<and> 
                                (Q (E\<lfloor>x:=r\<rfloor>) h1 hh v p2 \<and> p = tk (p1 \<smile> p2)) \<longrightarrow> R)
       \<rbrakk> \<Longrightarrow> R"
by (simp add: letrComb_def)

lemma LetvElim:
     "\<lbrakk>letvComb P Q E h hh v p;
         \<forall> p1 p2 h1 w n m f2 . (P E h h1 w p1 \<and> 
                              (Q E h1 hh v p2 \<and> p = (p1 \<smile> p2)) \<longrightarrow> R)
       \<rbrakk> \<Longrightarrow> R"
by (simp add: letvComb_def)

lemmas letElims = CondElim LetIconstElim LetRconstElim LetIvarElim LetRvarElim
                           LetIopElim LetRopElim LetGetfiElim LetGetfrElim
                           LetPutfiElim LetPutfrElim LetNewElim

subsection {* Elimination rules for logical combinators*}
lemma AllnatElim:
      "\<lbrakk>ALLnat P E h hh v p; !!n . P n E h hh v p \<Longrightarrow> R\<rbrakk> \<Longrightarrow> R"
by (simp add: ALLnat_def)

lemma ExlocElim: "\<lbrakk>EXloc P E h hh v p; EX n . P n E h hh v p \<Longrightarrow> R\<rbrakk> \<Longrightarrow> R"
by (simp add: EXloc_def)

lemma impliesAssnElim:
      "\<lbrakk>impliesAssn P Q E h hh v p; P E h hh v p;  Q E h hh v p \<Longrightarrow> R\<rbrakk> \<Longrightarrow> R"
by (simp only: impliesAssn_def)

lemmas logElims = AllnatElim ExlocElim impliesAssnElim

subsection {* Introduction rules for logical combinators*}
lemma IMPLIES_Intro:
      "\<lbrakk>!! E h hh v p . P E h hh v p \<Longrightarrow> Q  E h hh v p\<rbrakk> \<Longrightarrow> IMPLIES P Q"
by (simp add: IMPLIES_def)

lemma Allnat_Intro:
       "\<lbrakk>!!n. P n E h hh v p\<rbrakk> \<Longrightarrow> ALLnat P E h hh v p"
by (simp add: ALLnat_def)

lemma impliesAssn_Intro:
      "\<lbrakk>P E h hh v p \<Longrightarrow> Q E h hh v p\<rbrakk> \<Longrightarrow> impliesAssn P Q E h hh v p"
by (simp add: impliesAssn_def)

lemma tkCallAssn_Intro:
      "\<lbrakk>P E h hh v (tkcall p)\<rbrakk> \<Longrightarrow> tkCallAssn P E h hh v p"
by (simp add: tkCallAssn_def)

lemmas logIntros = IMPLIES_Intro Allnat_Intro impliesAssn_Intro tkCallAssn_Intro

(*<*)
end
(*>*)
