theory TransSems = Expr + Machine:

section {* Imperative small-step semantics *}

(* Pretty much as defined in Grail FGC paper: semantics combines 
   small steps for method calls, which avoids the need for
   a framestack.  *)

consts
  stepexpr1    :: "(state \<times> 'a expr \<times> state \<times> 'a expr) set"
  stepexpr     :: "(state \<times> 'a expr \<times> state \<times> val) set"

syntax
 "_stepexpr1"  :: "[state, 'a expr, state, 'a expr] \<Rightarrow> bool"  ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>1 \<langle>_,_\<rangle>")
 "_stepexpr"   :: "[state, 'a expr, state, val] \<Rightarrow> bool"      ("\<langle>_,_\<rangle> \<down> \<langle>_,_\<rangle>")

translations
 "\<langle>s,e\<rangle> \<longrightarrow>\<^sub>1 \<langle>s',e'\<rangle>" == "(s,e,s',e') : stepexpr1"
 "\<langle>s,e\<rangle> \<down> \<langle>s',v\<rangle>"     == "(s,e,s',v) : stepexpr"


inductive stepexpr1 stepexpr intros
(* values *)
 stepNull:    "\<langle>s, expr.Null\<rangle>   \<down>  \<langle>tick s, RVal Nullref\<rangle>"

 stepInt:     "\<langle>s, expr.Int i\<rangle>  \<down>  \<langle>tick s, IVal i\<rangle>"

 stepIVar:    "\<langle>s, IVar v\<rangle>      \<down>  \<langle>tick s, IVal (s<v>)\<rangle>"

 stepRVar:    "\<langle>s, RVar v\<rangle>      \<down>  \<langle>tick s, RVal (s\<lfloor>v\<rfloor>)\<rangle>"

 stepPrimop:  "\<langle>s, Primop f vn1 vn2\<rangle>  \<down>  \<langle>tickn 3 s, IVal (f (s<vn1>) (s<vn2>))\<rangle>"

 stepRPrimop: "\<langle>s, RPrimop f vn1 vn2\<rangle> \<down>  \<langle>tickn 3 s, IVal (f (s\<lfloor>vn1\<rfloor>) (s\<lfloor>vn2\<rfloor>))\<rangle>"

 stepGetFi:   "s\<lfloor>vn\<rfloor> = Ref a  \<Longrightarrow>  \<langle>s, GetFi vn f\<rangle> \<down> \<langle>tickn 2 s, IVal (s<a\<bullet>f>)\<rangle>"

 stepGetFr:   "s\<lfloor>vn\<rfloor> = Ref a  \<Longrightarrow>  \<langle>s, GetFr vn f\<rangle> \<down> \<langle>tickn 2 s, RVal (s\<lfloor>a\<diamondsuit>f\<rfloor>)\<rangle>"

 stepPutFi:   "s\<lfloor>vn1\<rfloor> = Ref a \<Longrightarrow> 
		\<langle>s, PutFi vn1 f vn2\<rangle> \<down> \<langle>tickn 3 (s<a\<bullet>f := (s<vn2>)>), IVal (s<vn2>)\<rangle>"

 stepPutFr:   "s\<lfloor>vn1\<rfloor> = Ref a \<Longrightarrow> 
                \<langle>s, PutFr vn1 f vn2\<rangle> \<down> \<langle>tickn 3 (s\<lfloor>a\<diamondsuit>f := (s\<lfloor>vn2\<rfloor>)\<rfloor>), RVal (s\<lfloor>vn2\<rfloor>)\<rangle>"

 stepNew:      "\<langle> s, New c ifldvals rfldvals\<rangle> \<down> 
		\<langle>tick (newobj s c ifldvals rfldvals), RVal (Ref (freshlocst s))\<rangle>" 

(* non-values *)

 stepIf_True:  "s<v> = grailbool True \<Longrightarrow>  \<langle>s, Ifg v e1 e2\<rangle> \<longrightarrow>\<^sub>1 \<langle>tick s, e1\<rangle>"

 stepIf_False: "s<v> = grailbool False \<Longrightarrow> \<langle>s, Ifg v e1 e2\<rangle> \<longrightarrow>\<^sub>1 \<langle>tick s, e2\<rangle>"

 stepLeti:     "\<langle>s, e\<rangle> \<down> \<langle>s', IVal i\<rangle> \<Longrightarrow> \<langle>s, Leti vn e es\<rangle> \<longrightarrow>\<^sub>1 \<langle>(tick s')<vn:=i>, es\<rangle>"

 stepLetr:     "\<langle>s, e\<rangle> \<down> \<langle>s', RVal r\<rangle> \<Longrightarrow> \<langle>s, Letr vn e es\<rangle> \<longrightarrow>\<^sub>1 \<langle>(tick s')\<lfloor>vn:=r\<rfloor>, es\<rangle>"

 stepLetv:     "\<langle>s, e\<rangle> \<down> \<langle>s', v\<rangle> \<Longrightarrow> \<langle>s, Letv e es\<rangle> \<longrightarrow>\<^sub>1 \<langle>s', es\<rangle>"

 stepCall:     "\<langle>s, CALL fn\<rangle> \<longrightarrow>\<^sub>1 \<langle>tick s, funtable fn\<rangle>" 

(* charges for invoke: vn1 = 1, vn2 = 1, frame push = 1; frame pop & return = 2. *)
 stepInvoke: 
  "\<lbrakk> s\<lfloor>vn1\<rfloor> = Ref a; s\<guillemotleft>a\<guillemotright> = Some C;
     \<langle>newframe (tickn 3 s) mn (Ref a) (s\<lfloor>vn2\<rfloor>), methtable C mn\<rangle> \<down> \<langle>s', rtv\<rangle> \<rbrakk>
 \<Longrightarrow>
     \<langle>s, Invoke vn1 mn vn2\<rangle> \<down> \<langle>tickn 2 (oldframe s' s), rtv\<rangle>"

 stepInvokeStatic: 
  "\<lbrakk> \<langle>newframe (tickn 2 s) mn Nullref (s\<lfloor>vn2\<rfloor>), methtable C mn\<rangle> \<down> \<langle>s', rtv\<rangle> \<rbrakk>
 \<Longrightarrow>
     \<langle>s, InvokeStatic C mn vn2\<rangle> \<down> \<langle>tickn 2 (oldframe s' s), rtv\<rangle>"

(* structural *)
 stepAnn:   "\<lbrakk> \<langle>s,e\<rangle> \<down> \<langle>s',v\<rangle> \<rbrakk> \<Longrightarrow> \<langle>s, Ann A e\<rangle> \<down> \<langle>s',v\<rangle>"

 stepClose: "\<lbrakk> \<langle>s, e\<rangle> \<longrightarrow>\<^sub>1 \<langle>s1, e1\<rangle>; \<langle>s1, e1\<rangle> \<down> \<langle>v, s2\<rangle> \<rbrakk> \<Longrightarrow> \<langle>s, e\<rangle> \<down> \<langle>v, s2\<rangle>"



subsection {* Elimination rules *}

text {* The elimination rules for \<down> are written out by hand because they 
   combine *two* uses of elimination in the operational semantics: the second one 
   trivially discounts the possibility of stepClose being used. *}
   

lemma step_cases:
  "\<lbrakk> \<langle>s,NULL\<rangle> \<down> \<langle>s',v\<rangle>; \<lbrakk>s' = tick s; v = RVal Nullref\<rbrakk> \<Longrightarrow> P \<rbrakk> \<Longrightarrow> P"
  "\<lbrakk> \<langle>s,expr.Int i\<rangle> \<down> \<langle>s',v\<rangle>; \<lbrakk>s' = tick s; v = IVal i\<rbrakk> \<Longrightarrow> P \<rbrakk> \<Longrightarrow> P"
  "\<lbrakk>\<langle>s,IVar iv\<rangle> \<down> \<langle>s',v\<rangle>; \<lbrakk>s' = tick s; v = IVal s<iv>\<rbrakk> \<Longrightarrow> P \<rbrakk> \<Longrightarrow> P"
  "\<lbrakk>\<langle>s,RVar rv\<rangle> \<down> \<langle>s',v\<rangle>; \<lbrakk>s' = tick s; v = RVal s\<lfloor>rv\<rfloor>\<rbrakk> \<Longrightarrow> P \<rbrakk> \<Longrightarrow> P"
  "\<lbrakk>\<langle>s,Primop f vn1 vn2\<rangle> \<down> \<langle>s',v\<rangle>;
    \<lbrakk>s' = tickn 3 s; v = IVal (f s<vn1> s<vn2>)\<rbrakk> \<Longrightarrow> P \<rbrakk> \<Longrightarrow> P"
  "\<lbrakk>\<langle>s,RPrimop g rvn1 rvn2\<rangle> \<down> \<langle>s',v\<rangle>;
    \<lbrakk>s' = tickn 3 s; v = IVal (g s\<lfloor>rvn1\<rfloor> s\<lfloor>rvn2\<rfloor>)\<rbrakk> \<Longrightarrow> P \<rbrakk> \<Longrightarrow> P"
  "\<lbrakk>\<langle>s,vn\<bullet>fn\<rangle> \<down> \<langle>s',v\<rangle>;
    \<And>a. \<lbrakk>s\<lfloor>vn\<rfloor> = Ref a; s' = tickn 2 s; v = IVal s<a\<bullet>fn>\<rbrakk> \<Longrightarrow> P \<rbrakk> \<Longrightarrow> P"
  "\<lbrakk>\<langle>s,vn\<diamondsuit>gn\<rangle> \<down> \<langle>s',v\<rangle>;
    \<And>a. \<lbrakk>s\<lfloor>vn\<rfloor> = Ref a; s' = tickn 2 s; v = RVal s\<lfloor>a\<diamondsuit>gn\<rfloor>\<rbrakk> \<Longrightarrow> P \<rbrakk> \<Longrightarrow> P"
  "\<lbrakk>\<langle>s,rvn1\<bullet>fn := vn2\<rangle> \<down> \<langle>s',v\<rangle>;
    \<And>a. \<lbrakk>s\<lfloor>rvn1\<rfloor> = Ref a; s' = tickn 3 s<a\<bullet>fn:=s<vn2>>; v = IVal s<vn2>\<rbrakk> \<Longrightarrow> P \<rbrakk>
  \<Longrightarrow> P"
  "\<lbrakk>\<langle>s,rvn1\<diamondsuit>gn := rvn2\<rangle> \<down> \<langle>s',v\<rangle>;
    \<And>a. \<lbrakk>s\<lfloor>rvn1\<rfloor> = Ref a; s' = tickn 3 s\<lfloor>a\<diamondsuit>gn:=s\<lfloor>rvn2\<rfloor>\<rfloor>; v = RVal s\<lfloor>rvn2\<rfloor>\<rbrakk> \<Longrightarrow> P \<rbrakk>
   \<Longrightarrow> P"
  "\<lbrakk>\<langle>s,NEW <c> (ifldvals,rfldvals)\<rangle> \<down> \<langle>s',v\<rangle>;
    \<lbrakk>s' = tick (newobj s c ifldvals rfldvals); v = RVal (Ref (freshlocst s))\<rbrakk>
    \<Longrightarrow> P \<rbrakk> \<Longrightarrow> P"
  "\<lbrakk>\<langle>s,rvn1\<diamondsuit>mn(rvn2) :: 'a expr\<rangle> \<down> \<langle>s',v\<rangle>;
    (*\<And>C a s'a.
     \<lbrakk>s\<lfloor>rvn1\<rfloor> = Ref a; s\<lless>a\<ggreater> = Some C;
         \<langle>newframe (tickn 3 s) mn (Ref a) s\<lfloor>rvn2\<rfloor>,methtable C mn :: 'a expr\<rangle> \<down> \<langle>s'a,v\<rangle>;
	 s' = tickn 2 (oldframe s'a s)\<rbrakk> \<Longrightarrow> P*)
    \<forall> C a s'a.
     (s\<lfloor>rvn1\<rfloor> = Ref a \<and> s\<lless>a\<ggreater> = Some C \<and>
         \<langle>newframe (tickn 3 s) mn (Ref a) s\<lfloor>rvn2\<rfloor>,methtable C mn :: 'a expr\<rangle> \<down> \<langle>s'a,v\<rangle> \<and>
	 s' = tickn 2 (oldframe s'a s)) \<longrightarrow> P \<rbrakk> \<Longrightarrow> P"
  "\<lbrakk>\<langle>s,C\<bullet>mn(rvn2)::'a expr\<rangle> \<down> \<langle>s',v\<rangle>;
   \<And>s'a. \<lbrakk>\<langle>newframe (tickn 2 s) mn Nullref s\<lfloor>rvn2\<rfloor>,methtable C mn :: 'a expr\<rangle> \<down> \<langle>s'a,v\<rangle>;
      s' = tickn 2 (oldframe s'a s)\<rbrakk> \<Longrightarrow> P \<rbrakk> \<Longrightarrow> P"
"\<lbrakk>\<langle>s,Ann A e\<rangle> \<down> \<langle>s',v\<rangle>; \<langle>s,e\<rangle> \<down> \<langle>s',v\<rangle> \<Longrightarrow> P \<rbrakk> \<Longrightarrow> P"
by (erule stepexpr1_stepexpr.elims, fastsimp+)+


inductive_cases step1_cases:
  "\<langle>s, Leti vn e es\<rangle> \<longrightarrow>\<^sub>1 \<langle>s', e'\<rangle>"
  "\<langle>s, Letr vn e es\<rangle> \<longrightarrow>\<^sub>1 \<langle>s', e'\<rangle>"
  "\<langle>s, Letv e es\<rangle> \<longrightarrow>\<^sub>1 \<langle>s', e'\<rangle>"
  "\<langle>s, CALL fn\<rangle> \<longrightarrow>\<^sub>1 \<langle>s', e'\<rangle>"

end
