theory NatSemsLemmas = MachineLemmas + NatSems:

subsection {* Monotonicity of resource parameters *}

text {* Here are the functions which are used in the operational
  semantics to change state. *}

lemma resource_monos: 
  "\<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<Longrightarrow> callcount s <= callcount t"
  "\<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<Longrightarrow> invokecount s <= invokecount t"
  "\<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<Longrightarrow> maxstack s <= maxstack t"
  "\<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<Longrightarrow> clock s < clock t"  (* clock is strictly increasing *)
  "\<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<Longrightarrow> (fmap_dom (oheap s) \<subseteq> fmap_dom (oheap t))"
by ((erule evalexpr.induct, simp_all)+, auto)


subsection {* Parametric behaviour of op sems wrt resource parameters *}

lemma evalintro_cong: "\<lbrakk> \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle>; s=s'; v=v'; t=t' \<rbrakk> \<Longrightarrow> \<langle>s',e\<rangle> \<longrightarrow>e \<langle>v',t'\<rangle>"
by auto


lemma plusone [simp]: "x + 1 = (1::int) + x" by auto

lemma clock_add : "\<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<Longrightarrow> \<langle>tickn i s,e\<rangle> \<longrightarrow>e \<langle>v,tickn i t\<rangle>"
apply (erule evalexpr.induct)
prefer 12 (* Treat True/False rules in correct order first *)
apply (rule_tac s="tickn i s" in evalintro_cong, rule evalIf_True, simp+)
prefer 12
apply (rule_tac s="tickn i s" in evalintro_cong, rule evalIf_False, simp+)
apply (rule_tac s="tickn i s" in evalintro_cong, rule evalexpr.intros, simp+)+
done
declare plusone [simp del]

declare state_functions [simp]  

lemma callcount_add: "\<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<Longrightarrow> \<langle>incrcallcount s,e\<rangle> \<longrightarrow>e \<langle>v,incrcallcount t\<rangle>"
apply (erule evalexpr.induct)
prefer 12 (* Treat True/False rules in correct order first *)
apply (rule_tac s="incrcallcount s" in evalintro_cong, rule evalIf_True, simp+)
prefer 12
apply (rule_tac s="incrcallcount s" in evalintro_cong, rule evalIf_False, simp+)
apply (rule_tac s="incrcallcount s" in evalintro_cong, rule evalexpr.intros, simp+)+
done
declare state_functions [simp del]


lemma tickcall_add: "\<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<Longrightarrow> \<langle>tickcall s,e\<rangle> \<longrightarrow>e \<langle>v,tickcall t\<rangle>"
by (drule clock_add, drule callcount_add, simp)

end

