theory NatSems = Expr + Machine:

section {* Big-step semantics *}

text {*
  We define a big-step semantics for  Grail.  For the purpose of later
  proofs, the relation is also indexed by the height of the derivation.
  *}


consts
  evalexpr  :: "(state \<times> 'a expr \<times> val \<times> state) set"

syntax
 evalexpr_  :: "[state, 'a expr, val, state] \<Rightarrow> bool"      ("\<langle>_,_\<rangle> \<longrightarrow>e \<langle>_,_\<rangle>")

translations
 "\<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,s'\<rangle>" == "(s,e,v,s') : evalexpr"


inductive evalexpr intros
 evalNull:    "\<langle>s, expr.Null\<rangle>   \<longrightarrow>e  \<langle>RVal Nullref, tick s\<rangle>"

 evalInt:     "\<langle>s, expr.Int i\<rangle>  \<longrightarrow>e  \<langle>IVal i, tick s\<rangle>"

 evalIVar:    "\<langle>s, IVar v\<rangle>      \<longrightarrow>e  \<langle>IVal (s<v>), tick s\<rangle>"

 evalRVar:    "\<langle>s, RVar v\<rangle>      \<longrightarrow>e  \<langle>RVal (s\<lfloor>v\<rfloor>), tick s\<rangle>"

 evalPrimop:  "\<langle>s, Primop f vn1 vn2\<rangle>  \<longrightarrow>e  \<langle>IVal (f (s<vn1>) (s<vn2>)), tickn 3 s\<rangle>"

 evalRPrimop: "\<langle>s, RPrimop f vn1 vn2\<rangle> \<longrightarrow>e  \<langle>IVal (f (s\<lfloor>vn1\<rfloor>) (s\<lfloor>vn2\<rfloor>)), tickn 3 s\<rangle>"

 evalGetFi:   "s\<lfloor>vn\<rfloor> = Ref a  \<Longrightarrow>  \<langle>s,  GetFi vn f\<rangle> \<longrightarrow>e \<langle>IVal (s<a\<bullet>f>), tickn 2 s\<rangle>"

 evalGetFr:   "s\<lfloor>vn\<rfloor> = Ref a  \<Longrightarrow>  \<langle>s,  GetFr vn f\<rangle> \<longrightarrow>e \<langle>RVal (s\<lfloor>a\<diamondsuit>f\<rfloor>), tickn 2 s\<rangle>"

 evalPutFi:   "s\<lfloor>vn1\<rfloor> = Ref a \<Longrightarrow> 
		\<langle>s, PutFi vn1 f vn2\<rangle> \<longrightarrow>e \<langle> IVal (s<vn2>), tickn 3 (s<a\<bullet>f := (s<vn2>)>) \<rangle>"

 evalPutFr:   "s\<lfloor>vn1\<rfloor> = Ref a \<Longrightarrow> 
                \<langle>s, PutFr vn1 f vn2\<rangle> \<longrightarrow>e \<langle> RVal (s\<lfloor>vn2\<rfloor>), tickn 3 (s\<lfloor>a\<diamondsuit>f := (s\<lfloor>vn2\<rfloor>)\<rfloor>) \<rangle>"

 evalNew:      "\<langle> s, New c ifldvals rfldvals\<rangle> \<longrightarrow>e 
		\<langle>RVal (Ref (freshlocst s)), tick (newobj s c ifldvals rfldvals)\<rangle>" 

 evalIf_True:  "\<lbrakk> s<v> = grailbool True; 
		  \<langle>tick s, l1\<rangle> \<longrightarrow>e \<langle>rtv, s1\<rangle> \<rbrakk> \<Longrightarrow> \<langle>s, Ifg v l1 l2\<rangle> \<longrightarrow>e \<langle>rtv, s1\<rangle>"

 evalIf_False: "\<lbrakk> s<v> = grailbool False; 
		  \<langle>tick s, l2\<rangle> \<longrightarrow>e \<langle>rtv, s1\<rangle> \<rbrakk> \<Longrightarrow> \<langle>s, Ifg v l1 l2\<rangle> \<longrightarrow>e \<langle>rtv,s1\<rangle>"

 evalLeti:     "\<lbrakk> \<langle>s, e\<rangle> \<longrightarrow>e \<langle>IVal i, s1\<rangle> ; \<langle>(tick s1)<vn:=i>, ls\<rangle> \<longrightarrow>e \<langle>rtv2, s2\<rangle> \<rbrakk>
	        \<Longrightarrow>
                \<langle>s, Leti vn e ls\<rangle> \<longrightarrow>e \<langle>rtv2, s2\<rangle>"

 evalLetr:     "\<lbrakk> \<langle>s, e\<rangle> \<longrightarrow>e \<langle>RVal r, s1\<rangle> ; \<langle>(tick s1)\<lfloor>vn:=r\<rfloor>, ls\<rangle> \<longrightarrow>e \<langle>rtv2, s2\<rangle> \<rbrakk>
                \<Longrightarrow>
                \<langle>s, Letr vn e ls\<rangle> \<longrightarrow>e \<langle>rtv2, s2\<rangle>"

 evalLetv:    "\<lbrakk> \<langle>s, e\<rangle> \<longrightarrow>e \<langle>rtv1, s1\<rangle> ; \<langle>s1, ls\<rangle> \<longrightarrow>e \<langle>rtv2, s2\<rangle> \<rbrakk>
	        \<Longrightarrow>
                \<langle>s, Letv e ls\<rangle> \<longrightarrow>e \<langle>rtv2, s2\<rangle>"

 evalCall:     "\<lbrakk> \<langle>tickcall s, funtable fn\<rangle> \<longrightarrow>e \<langle>rtv, s1\<rangle> \<rbrakk>
                \<Longrightarrow>
                \<langle>s, CALL fn\<rangle> \<longrightarrow>e \<langle>rtv, s1\<rangle>" 

 evalInvoke: 
  "\<lbrakk> s\<lfloor>vn1\<rfloor> = Ref a; s\<guillemotleft>a\<guillemotright> = Some C;
     \<langle>newframe s mn (Ref a) (s\<lfloor>vn2\<rfloor>), methtable C mn\<rangle> \<longrightarrow>e \<langle>rtv, s'\<rangle> \<rbrakk>
 \<Longrightarrow>
    \<langle>s , Invoke vn1 mn vn2\<rangle> \<longrightarrow>e \<langle>rtv, tickn 5 (oldframe s' s) \<rangle>"

 evalInvokeStatic: 
  "\<lbrakk> \<langle>newframe s mn Nullref (s\<lfloor>vn2\<rfloor>), methtable C mn\<rangle> \<longrightarrow>e \<langle>rtv, s'\<rangle> \<rbrakk>
 \<Longrightarrow>
   \<langle>s , InvokeStatic C mn vn2\<rangle> \<longrightarrow>e \<langle>rtv, tickn 4 (oldframe s' s) \<rangle>"

 evalAnn: "\<lbrakk> \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,s'\<rangle> \<rbrakk> \<Longrightarrow> \<langle>s, Ann A e\<rangle> \<longrightarrow>e \<langle>v,s'\<rangle>"

text {*
  Notes:
  \begin{enumerate}
  \item Annotations are ignored in the operational semantics.
    
  \item Put instructions ought to have no return value, but we do not
     include void type, so we return the value stored.

  \item To explain the resource counting in Invoke: vn1 = 1, vn2 = 1,
  frame push/pop = 2, and the implicit return = 1.
  NB: we could break up the increment of ticks into before/after 
  CALL.


  \item Many rules omit type-checking premises (just like Grail\dots).
  For example, in get field and put field rules, we should
  check that the object belongs to a class that indeed has
  the fields being accessed.  

  \item
  Object initialization in the New rule simply sets an object
  component of the heap.
  The iheap and rheap are left alone.  For the logic (and
  by comparison with Grail), it might be better to have a
  New operator which also initialises the fields of an
  object.  However, if we admit in-place-update in objects,
  it seems difficult to avoid dealing with partly-defined
  data structures.

  \item 
   We might tickn 2 in the If rules, but we leave it at one to
   allow for extra store/retrieve which may not be necessary in 
   some cases on the real machine.

 \item The rule for evaluating Let once contained an additional side
  condition that the expression being bound does not itself contain a
  CALL (non-tail position).  So evaluation would get stuck for non-Grail
  programs.  However, there seems to be no harm in considering the
  more general semantics for a slightly richer language, since this
  side condition is not used in the logic.  (This restriction could
  therefore be considered as part of the type-checking phase for Toy Grail).

  \end{enumerate}
*}


subsection {* Elimination rules *}

inductive_cases eval_cases: 
  "(s, expr.Null, v, s') \<in> evalexpr"
  "(s, expr.Int i, v, s') \<in> evalexpr"
  "(s, expr.IVar vn, v, s') \<in> evalexpr"
  "(s, expr.RVar vn, v, s') \<in> evalexpr"
  "(s, expr.Primop f vn1 vn2, v, s') \<in> evalexpr"
  "(s, expr.RPrimop f vn1 vn2, v, s') \<in> evalexpr"
  "(s, expr.GetFi vn f, v, s') \<in> evalexpr"
  "(s, expr.GetFr vn f, v, s') \<in> evalexpr"
  "(s, expr.PutFi vn1 f vn2, v, s') \<in> evalexpr"
  "(s, expr.PutFr vn1 f vn2, v, s') \<in> evalexpr"
  "(s, New c ifs rfs, v, s') \<in> evalexpr"
  "(s, Ifg vn l1 l2, v, s') \<in> evalexpr"
  "(s, Leti vn e ls, v, s') \<in> evalexpr"
  "(s, Letr vn e ls, v, s') \<in> evalexpr"
  "(s, Letv e ls, v, s') \<in> evalexpr"
  "(s, Call fn, v, s') \<in> evalexpr"
  "(s, expr.Invoke vn1 mn vn2, v, s') \<in> evalexpr"
  "(s, expr.InvokeStatic c mn vn, v, s') \<in> evalexpr"
  "(s, Ann A e, v, s') \<in> evalexpr"

           
end
