theory FunNatSems = Expr + FunMachine:

section {* Big-step semantics *}

text {*
  We define a big-step semantics for  Grail.  For the purpose of later
  proofs, the relation is also indexed by the height of the derivation.
  *}

consts
  evalexprn  :: "(env \<times> state \<times> 'a expr \<times> nat \<times> val \<times> state) set"

syntax
 evalexprn_  :: "[env, state, 'a expr, nat, val, state] \<Rightarrow> bool"   ("_ \<turnstile> _ \<midarrow>_\<longrightarrow>_ '(_, _')")

translations
 "p \<turnstile> s \<midarrow>e\<longrightarrow>n (v,s')" == "(p,s,e,n,v,s') : evalexprn"

constdefs
 evalexpr :: "[env, state, 'a expr, val, state] \<Rightarrow> bool"  ("_ \<turnstile> _ \<midarrow>_\<longrightarrow> '(_, _')" 1000)
 "(p \<turnstile> s \<midarrow>e\<longrightarrow> (v,s')) \<equiv> (\<exists> n. (p \<turnstile> s \<midarrow>e\<longrightarrow>n (v,s')))"


inductive evalexprn intros
 evalNull:    "p \<turnstile> s \<midarrow>expr.Null\<longrightarrow>1  (RVal Nullref,tick s)"

 evalInt:     "p \<turnstile> s \<midarrow>expr.Int i\<longrightarrow>1 (IVal i,tick s)"

 evalIVar:    "p \<turnstile> s \<midarrow>IVar v\<longrightarrow>1 (IVal (p<v>),tick s)"

 evalRVar:    "p \<turnstile> s \<midarrow>RVar v\<longrightarrow>1 (RVal (p\<lfloor>v\<rfloor>),tick s)"

 evalPrimop:  "p \<turnstile> s \<midarrow>Primop f vn1 vn2\<longrightarrow>1  (IVal (f (p<vn1>) (p<vn2>)),tickn 3 s)"

 evalRPrimop: "p \<turnstile> s \<midarrow>RPrimop f vn1 vn2\<longrightarrow>1 (IVal (f (p\<lfloor>vn1\<rfloor>) (p\<lfloor>vn2\<rfloor>)),tickn 3 s)"

 evalGetFi:   "p\<lfloor>vn\<rfloor> = Ref a  \<Longrightarrow>
		p \<turnstile> s \<midarrow>GetFi vn f\<longrightarrow>1 (IVal (s<a\<bullet>f>),tickn 2 s)"

 evalGetFr:   "p\<lfloor>vn\<rfloor> = Ref a  \<Longrightarrow>  
		p \<turnstile> s \<midarrow>GetFr vn f\<longrightarrow>1 (RVal (s\<lfloor>a\<diamondsuit>f\<rfloor>),tickn 2 s)"

 evalPutFi:   "p\<lfloor>vn1\<rfloor> = Ref a \<Longrightarrow>				(* IVal (p<vn2>) *)
		p \<turnstile> s \<midarrow>PutFi vn1 f vn2\<longrightarrow>1 (arbitrary,tickn 3 (s<a\<bullet>f := (p<vn2>)>))"

 evalPutFr:   "p\<lfloor>vn1\<rfloor> = Ref a \<Longrightarrow>				(* RVal (p\<lfloor>vn2\<rfloor>) *)
                p \<turnstile> s \<midarrow>PutFr vn1 f vn2\<longrightarrow>1 (arbitrary,tickn 3 (s\<lfloor>a\<diamondsuit>f := (p\<lfloor>vn2\<rfloor>)\<rfloor>))"

 evalNew:     "p \<turnstile> s \<midarrow>New c ifldvals rfldvals\<longrightarrow>1
		        (RVal (Ref (freshlocst s)),tick (newobj s p c ifldvals rfldvals))" 

 evalIf_True:  "\<lbrakk> p<v> = grailbool True; 
		  p \<turnstile> tick s \<midarrow>e1\<longrightarrow>n (rtv, s1) \<rbrakk> \<Longrightarrow> p \<turnstile> s \<midarrow>Ifg v e1 e2\<longrightarrow>(n+1) (rtv,s1)"

 evalIf_False: "\<lbrakk> p<v> = grailbool False; 
		  p \<turnstile> tick s \<midarrow>e2\<longrightarrow>n (rtv, s1) \<rbrakk> \<Longrightarrow> p \<turnstile> s \<midarrow>Ifg v e1 e2\<longrightarrow>(n+1) (rtv,s1)"

 evalLeti:     "\<lbrakk> p \<turnstile> s \<midarrow>e\<longrightarrow>n (IVal i,s1); 
		  p<vn:=i> \<turnstile> (tick s1)\<midarrow>es\<longrightarrow>m (rtv2,s2) \<rbrakk>
	        \<Longrightarrow>
                  p \<turnstile> s \<midarrow>Leti vn e es\<longrightarrow>((max m n)+1) (rtv2,s2)"

 evalLetr:     "\<lbrakk> p \<turnstile> s \<midarrow>e\<longrightarrow>n (RVal r,s1); 
		  p\<lfloor>vn:=r\<rfloor> \<turnstile> (tick s1)\<midarrow>es\<longrightarrow>m (rtv2,s2) \<rbrakk>
	        \<Longrightarrow>
                  p \<turnstile> s \<midarrow>Letr vn e es\<longrightarrow>((max m n)+1) (rtv2,s2)"

 evalLetv:     "\<lbrakk> p \<turnstile> s \<midarrow>e\<longrightarrow>n (rtv1,s1); p \<turnstile> s1 \<midarrow>es\<longrightarrow>m (rtv2,s2) \<rbrakk>
	        \<Longrightarrow>
                  p \<turnstile> s \<midarrow>Letv e es\<longrightarrow>((max m n)+1) (rtv2,s2)"

 evalCall:     "\<lbrakk> p \<turnstile> tickcall s \<midarrow>funtable fn\<longrightarrow>n (rtv,s1) \<rbrakk>
                \<Longrightarrow>
                  p \<turnstile> s \<midarrow>CALL fn\<longrightarrow>(n+1) (rtv,s1)" 

 evalInvoke: 
  "\<lbrakk> p\<lfloor>vn1\<rfloor> = Ref a; s\<guillemotleft>a\<guillemotright> = Some C;
     (newframe_env (Ref a) (p\<lfloor>vn2\<rfloor>)) \<turnstile> 
	(newframe_state s) \<midarrow>methtable C mn\<longrightarrow>n (rtv,s') \<rbrakk>
 \<Longrightarrow>
    p \<turnstile> s \<midarrow>Invoke vn1 mn vn2\<longrightarrow>(n+1) (rtv,tickn 5 (popframe_state s'))"

 evalInvokeStatic: 
  "\<lbrakk> (newframe_env Nullref (p\<lfloor>vn2\<rfloor>)) \<turnstile> 
	(newframe_state s) \<midarrow>methtable C mn\<longrightarrow>n (rtv,s') \<rbrakk>
 \<Longrightarrow>
   p \<turnstile> s \<midarrow>InvokeStatic C mn vn2\<longrightarrow>(n+1) (rtv,tickn 4 (popframe_state s'))"

 evalAnn: "p \<turnstile> s \<midarrow>e\<longrightarrow>n (v,s') \<Longrightarrow> p \<turnstile> s \<midarrow>Ann A e\<longrightarrow>(n+1) (v,s')"

text {*
  Comentary:
  \begin{enumerate}
  \item Put instructions in rules @{text evalPutFi} and @{text
  evalPutFr} are only evaluated
  for their side-effect and should only be used with @{text Letv}.  
  To emphasise this, they return the undetermined value @{text arbitrary}.

  \item Annotations are ignored in the operational semantics.
    
  \item To explain the resource counting in Invoke: vn1 = 1, vn2 = 1,
  frame push/pop = 2, and the implicit return = 1.
  NB: we could break up the increment of ticks into before/after 
  CALL.

  \item Many rules omit type-checking premises.
  For example, in get field and put field rules, we should
  check that the object belongs to a class that indeed has
  the fields being accessed.  

  \item
  Object initialization in the New rule simply sets an object
  component of the heap.
  The iheap and rheap are left alone.  For the logic (and
  by comparison with Grail), it might be better to have a
  New operator which also initialises the fields of an
  object.  However, if we admit in-place-update in objects,
  it seems difficult to avoid dealing with partly-defined
  data structures.

  \item 
   We might tickn 2 in the If rules, but we leave it at one to
   allow for extra store/retrieve which may not be necessary in 
   some cases on the real machine.

 \item The rule for evaluating Let once contained an additional side
  condition that the expression being bound does not itself contain a
  CALL (non-tail position).  So evaluation would get stuck for non-Grail
  programs.  However, there seems to be no harm in considering the
  more general semantics for a slightly richer language, since this
  side condition is not used in the logic.  (This restriction could
  therefore be considered as part of the type-checking phase for Toy Grail).

  \end{enumerate}
*}


subsection {* Elimination rules *}

inductive_cases eval_cases: 
 "p \<turnstile> s \<midarrow>expr.Null\<longrightarrow>n  (v,s')"
 "p \<turnstile> s \<midarrow>expr.Int i\<longrightarrow>n (v,s')"
 "p \<turnstile> s \<midarrow>IVar vn\<longrightarrow>n (v,s')"
 "p \<turnstile> s \<midarrow>RVar vn\<longrightarrow>n (v,s')"
 "p \<turnstile> s \<midarrow>Primop f vn1 vn2\<longrightarrow>n  (v,s')"
 "p \<turnstile> s \<midarrow>RPrimop f vn1 vn2\<longrightarrow>n (v,s')"
 "p \<turnstile> s \<midarrow>GetFi vn f\<longrightarrow>n (v,s')"
 "p \<turnstile> s \<midarrow>GetFr vn f\<longrightarrow>n (v,s')"
 "p \<turnstile> s \<midarrow>PutFi vn1 f vn2\<longrightarrow>n (v,s')"
 "p \<turnstile> s \<midarrow>PutFr vn1 f vn2\<longrightarrow>n (v,s')"
 "p \<turnstile> s \<midarrow>New c ifldvals rfldvals\<longrightarrow>n (v,s')"
 "p \<turnstile> s \<midarrow>Ifg vn e1 e2\<longrightarrow>n (v,s')"
 "p \<turnstile> s \<midarrow>Leti vn e es\<longrightarrow>n (v,s')"
 "p \<turnstile> s \<midarrow>Letr vn e es\<longrightarrow>n (v,s')"
 "p \<turnstile> s \<midarrow>Leti vn e es\<longrightarrow>n (v,s')"
 "p \<turnstile> s \<midarrow>CALL fn\<longrightarrow>n (v,s')"
 "p \<turnstile> s \<midarrow>Invoke vn1 mn vn2\<longrightarrow>n (v,s')"
 "p \<turnstile> s \<midarrow>InvokeStatic C mn vn2\<longrightarrow>n (v,s')"

end
