theory ExSem = Expr + FunMachine:

section {* Big-step semantics with exhaustive costs*}

text {*
  We define a big-step semantics for  Grail.  For the purpose of later
  proofs, the relation is also indexed by the height of the derivation.
  *}

record renv = clock :: nat
              callc :: nat
              invkc :: nat
              invkdpth :: nat
              freelocs :: nat

constdefs renv_plus:: "renv \<Rightarrow> renv \<Rightarrow> renv"
"renv_plus p1 p2 == \<lparr>clock = clock p1 + clock p2,
                     callc = callc p1 + callc p2,
                     invkc = invkc p1 + invkc p2,
                     invkdpth = invkdpth p1 + invkdpth p2,
                     freelocs = freelocs p1 + freelocs p2\<rparr>"

constdefs renv_cup :: "renv \<Rightarrow> renv \<Rightarrow> renv"
"renv_cup p1 p2 == \<lparr>clock = clock p1 + clock p2,
                    callc = callc p1 + callc p2,
                    invkc = invkc p1 + invkc p2,
                    invkdpth = max (invkdpth p1) (invkdpth p2),
                    freelocs = freelocs p1 + freelocs p2\<rparr>"

constdefs geq :: "renv \<Rightarrow> renv \<Rightarrow> bool"
"geq p pp == (clock pp <= clock p) \<and> (callc pp <= callc p) \<and> 
             (invkc pp <= invkc p) \<and> (invkdpth pp <= invkdpth p) \<and> 
             (freelocs pp <= freelocs p)"

constdefs mkREnv:: "nat \<Rightarrow> nat \<Rightarrow> nat \<Rightarrow> nat \<Rightarrow> nat \<Rightarrow> renv"
"mkREnv C CC IC ID FL == \<lparr>clock = C, callc = CC, invkc = IC, invkdpth = ID, freelocs = FL\<rparr>"

consts
  exsemn  :: "(env \<times> renv \<times> heap \<times> 'a expr \<times> nat \<times> heap \<times> val) set"

syntax
 exsemn_  :: "[env, renv, heap, 'a expr, nat, heap, val] \<Rightarrow> bool"   ("_ ; _ \<turnstile> _ , _ \<Down>_ '(_ , _')")

translations
 "E;p \<turnstile> h,e \<Down>n (hh,v)" == "(E,p,h,e,n,hh,v) : exsemn"

constdefs
 exsem :: "[env, renv, heap, 'a expr, heap, val] \<Rightarrow> bool"  ("_ ; _ \<turnstile> _ , _ \<Down> _ , _" 1000)
 "(E;p \<turnstile> h,e \<Down> hh,v \<equiv> (\<exists> n. (E;p \<turnstile> h,e \<Down>n (hh,v))))"

(* strict system
inductive exsemn intros
 exNull:    "E; mkREnv 1 0 0 0 0 \<turnstile> h,(expr.Null) \<Down>1 (h,RVal Nullref)"

 exInt:     "E; mkREnv 1 0 0 0 0 \<turnstile> h,(expr.Int i) \<Down>1 (h,IVal i)"

 exIVar:    "E; mkREnv 1 0 0 0 0 \<turnstile> h,IVar v \<Down>1 (h,IVal (E<v>))"

 exRVar:    "E; mkREnv 1 0 0 0 0 \<turnstile> h,RVar v \<Down>1 (h,RVal (E\<lfloor>v\<rfloor>))"

 exPrimop:  "\<lbrakk>E; p1 \<turnstile> h, IVar x \<Down>n (h1,IVal i1) ; E; p2 \<turnstile> h1, IVar y \<Down>m (h2,IVal i2) \<rbrakk> \<Longrightarrow>
                E; renv_cup (mkREnv 1 0 0 0 0) (renv_cup p1 p2) \<turnstile> 
                h, (Primop f x y) \<Down>((max n m) + 1) (h2,(IVal (f i1 i2)))"

 exRPrimop:  "\<lbrakk>E; p1 \<turnstile> h, RVar x \<Down>n (h1,RVal r1) ; E; p2 \<turnstile> h1, RVar y \<Down>m (h2,RVal r2) \<rbrakk> \<Longrightarrow>
                E; renv_cup (mkREnv 1 0 0 0 0) (renv_cup p1 p2) \<turnstile> 
                h, (RPrimop f x y) \<Down>((max n m) + 1) (h2,(IVal (f r1 r2)))"

 exGetfi: "\<lbrakk>E ; p \<turnstile> h, RVar x \<Down>n (h1, RVal(Ref a))\<rbrakk> \<Longrightarrow>
           E; renv_cup (mkREnv 1 0 0 0 0) p \<turnstile> h,(GetFi x f) \<Down>(n+1) (h1, IVal ((heap.iheap h1) f a))"

 exGetfr: "\<lbrakk>E ; p \<turnstile> h, RVar x \<Down>n (h1, RVal(Ref a))\<rbrakk> \<Longrightarrow>
           E; renv_cup (mkREnv 1 0 0 0 0) p \<turnstile> h,(GetFr x f) \<Down>(n+1) (h1, RVal ((heap.rheap h1) f a))"

 exPutfi: "\<lbrakk>E; p1 \<turnstile> h, RVar x \<Down>n (h1,RVal (Ref a)) ; 
            E; p2 \<turnstile> h1, IVar y \<Down>m (\<lparr>oheap = oh, iheap = ih, rheap = rh\<rparr>,IVal i) \<rbrakk> \<Longrightarrow>
                E; renv_cup (mkREnv 1 0 0 0 0) (renv_cup p1 p2) \<turnstile> 
                h, (PutFi x f y) \<Down>((max n m) + 1) 
                (\<lparr>oheap = oh, iheap = ih(f := (ih f)(a := i)), rheap = rh\<rparr>,arbitrary)"

 exPutfr: "\<lbrakk>E; p1 \<turnstile> h, RVar x \<Down>n (h1,RVal (Ref a)) ; 
            E; p2 \<turnstile> h1, RVar y \<Down>m (\<lparr>oheap = oh, iheap = ih, rheap = rh\<rparr>,RVal r) \<rbrakk> \<Longrightarrow>
                E; renv_cup (mkREnv 1 0 0 0 0) (renv_cup p1 p2) \<turnstile> 
                h, (PutFr x f y) \<Down>((max n m) + 1) 
                (\<lparr>oheap = oh, iheap = ih, rheap = rh(f := (rh f)(a := r))\<rparr>,arbitrary)"

  exNew: "\<lbrakk> l = freshloc (fmap_dom (heap.oheap h)) ;
            h1 = \<lparr>oheap = (heap.oheap h)(l \<mapsto>\<^sub>f c),
                  iheap = iheapflds ifldvals l (heap.iheap h) (ienv E),
                  rheap = rheapflds rfldvals l (heap.rheap h) (renv E)\<rparr>\<rbrakk> \<Longrightarrow>
          E; (mkREnv 1 0 0 0 1) \<turnstile> h,(New c ifldvals rfldvals) \<Down>1 (h1, RVal (Ref l))"

 exIf_True:  "\<lbrakk>E; p1 \<turnstile> h, IVar x \<Down>n (h1,IVal (grailbool True)) ;  E; p2 \<turnstile> h1, e1 \<Down>m (h2,v)\<rbrakk> \<Longrightarrow>
               E; renv_cup (mkREnv 1 0 0 0 0) (renv_cup p1 p2) \<turnstile> h, (Ifg x e1 e2) \<Down>((max n m) + 1) (h2,v)"

 exIf_False:  "\<lbrakk>E; p1 \<turnstile> h, IVar x \<Down>n (h1,IVal (grailbool False)) ;  E; p2 \<turnstile> h1, e2 \<Down>m (h2,v)\<rbrakk> \<Longrightarrow>
               E; renv_cup (mkREnv 1 0 0 0 0) (renv_cup p1 p2) \<turnstile> h, (Ifg x e1 e2) \<Down>((max n m) + 1) (h2,v)"

 exLeti: "\<lbrakk>E; p1 \<turnstile> h,e1 \<Down>n (h1,IVal i) ;  E<x:=i>; p2 \<turnstile> h1, e2 \<Down>m (h2,v)\<rbrakk> \<Longrightarrow>
           E; renv_cup (mkREnv 1 0 0 0 0) (renv_cup p1 p2) \<turnstile> h, (Leti x e1 e2) \<Down>((max n m) + 1) (h2,v)"

 exLetr: "\<lbrakk>E; p1 \<turnstile> h,e1 \<Down>n (h1,RVal r) ;  E\<lfloor>x:=r\<rfloor>; p2 \<turnstile> h1, e2 \<Down>m (h2,v)\<rbrakk> \<Longrightarrow>
           E; renv_cup (mkREnv 1 0 0 0 0) (renv_cup p1 p2) \<turnstile> h, (Letr x e1 e2) \<Down>((max n m) + 1) (h2,v)"

 exLetv: "\<lbrakk>E; p1 \<turnstile> h,e1 \<Down>n (h1,w) ;  E; p2 \<turnstile> h1, e2 \<Down>m (h2,v)\<rbrakk> \<Longrightarrow>
           E; (renv_cup p1 p2) \<turnstile> h, (Letv e1 e2) \<Down>((max n m) + 1) (h2,v)"

 exCall: "\<lbrakk>E ; p \<turnstile> h, funtable f \<Down>n (h1, v)\<rbrakk> \<Longrightarrow>
           E; renv_cup (mkREnv 1 1 0 0 0) p \<turnstile> h,(Call f) \<Down>(n+1) (h1, v)"

 exInvoke: "\<lbrakk>E; p1 \<turnstile> h,RVar x \<Down>n (h1,RVal (Ref a)) ;  
             E; p2 \<turnstile> h1,RVar y \<Down>m (h2,RVal v);
             fmap_lookup (heap.oheap h2) a = Some C;
             (newframe_env (Ref a) v) ; p3 \<turnstile> h2,methtable C mn \<Down>k (h3,w)\<rbrakk> \<Longrightarrow>
             E; renv_plus (renv_cup (mkREnv 3 0 1 1 0) (renv_cup p1 p2)) p3 \<turnstile> 
              h, (Invoke x mn y) \<Down>((max (max n m) k) + 1) (h3,w)"

 exInvokeStatic: "\<lbrakk>E; p1 \<turnstile> h,RVar y \<Down>n (h1,RVal v); 
                  (newframe_env NullRef v); p2 \<turnstile> h1,methtable C mn \<Down>m (h2,w)\<rbrakk> \<Longrightarrow>
                   E; renv_plus (renv_cup (mkREnv 2 0 1 1 0) p1) p2 \<turnstile> 
                   h, (InvokeStatic C mn y) \<Down>((max n m) + 1) (h2,w)"

 exAnn: "E; p \<turnstile> h,e \<Down>n (h1,v) \<Longrightarrow> E; p \<turnstile> h,(Ann A e) \<Down>(n+1) (h1,v)"

 exWeak: "E; p \<turnstile> h,e \<Down>n (h1,v) \<Longrightarrow> E; renv_cup pp p \<turnstile> h,e \<Down>(n+1) (h1,v)"
*)
inductive exsemn intros
 exNull:    "\<lbrakk>geq p (mkREnv 1 0 0 0 0)\<rbrakk> \<Longrightarrow> E; p \<turnstile> h,(expr.Null) \<Down>1 (h,RVal Nullref)"

 exInt:     "\<lbrakk>geq p (mkREnv 1 0 0 0 0)\<rbrakk> \<Longrightarrow> E; p \<turnstile> h,(expr.Int i) \<Down>1 (h,IVal i)"

 exIVar:    "\<lbrakk>geq p (mkREnv 1 0 0 0 0)\<rbrakk> \<Longrightarrow> E; p \<turnstile> h,IVar v \<Down>1 (h,IVal (E<v>))"

 exRVar:    "\<lbrakk>geq p (mkREnv 1 0 0 0 0)\<rbrakk> \<Longrightarrow> E; p \<turnstile> h,RVar v \<Down>1 (h,RVal (E\<lfloor>v\<rfloor>))"

 exPrimop:  "\<lbrakk>E; p1 \<turnstile> h, IVar x \<Down>n (h1,IVal i1); 
              E; p2 \<turnstile> h1, IVar y \<Down>m (h2,IVal i2);
              geq p (renv_cup (mkREnv 1 0 0 0 0) (renv_cup p1 p2))
             \<rbrakk> \<Longrightarrow> 
             E; p \<turnstile> h, (Primop f x y) \<Down>((max n m) + 1) (h2,(IVal (f i1 i2)))"

 exRPrimop:  "\<lbrakk>E; p1 \<turnstile> h, RVar x \<Down>n (h1,RVal r1);
               E; p2 \<turnstile> h1, RVar y \<Down>m (h2,RVal r2);
               geq p (renv_cup (mkREnv 1 0 0 0 0) (renv_cup p1 p2))
              \<rbrakk> \<Longrightarrow>
              E; p \<turnstile> h, (RPrimop f x y) \<Down>((max n m) + 1) (h2,(IVal (f r1 r2)))"

 exGetfi: "\<lbrakk>E ;pp \<turnstile> h, RVar x \<Down>n (h1, RVal(Ref a)); geq p (renv_cup (mkREnv 1 0 0 0 0) pp)\<rbrakk> \<Longrightarrow>
            E;p \<turnstile> h,(GetFi x f) \<Down>(n+1) (h1, IVal ((heap.iheap h1) f a))"

 exGetfr: "\<lbrakk>E ;pp \<turnstile> h, RVar x \<Down>n (h1, RVal(Ref a)); geq p (renv_cup (mkREnv 1 0 0 0 0) pp)\<rbrakk> \<Longrightarrow>
            E;p \<turnstile> h,(GetFr x f) \<Down>(n+1) (h1, RVal ((heap.rheap h1) f a))"

 exPutfi: "\<lbrakk>E; p1 \<turnstile> h, RVar x \<Down>n (h1,RVal (Ref a)) ; 
            E; p2 \<turnstile> h1, IVar y \<Down>m (\<lparr>oheap = oh, iheap = ih, rheap = rh\<rparr>,IVal i);
            geq p (renv_cup (mkREnv 1 0 0 0 0) (renv_cup p1 p2))
           \<rbrakk> \<Longrightarrow>
           E;p \<turnstile> h, (PutFi x f y) \<Down>((max n m) + 1) 
                (\<lparr>oheap = oh, iheap = ih(f := (ih f)(a := i)), rheap = rh\<rparr>,arbitrary)"

 exPutfr: "\<lbrakk>E; p1 \<turnstile> h, RVar x \<Down>n (h1,RVal (Ref a)) ; 
            E; p2 \<turnstile> h1, RVar y \<Down>m (\<lparr>oheap = oh, iheap = ih, rheap = rh\<rparr>,RVal r);
            geq p (renv_cup (mkREnv 1 0 0 0 0) (renv_cup p1 p2))
           \<rbrakk> \<Longrightarrow>
           E;p \<turnstile> h, (PutFr x f y) \<Down>((max n m) + 1) 
                (\<lparr>oheap = oh, iheap = ih, rheap = rh(f := (rh f)(a := r))\<rparr>,arbitrary)"

  exNew: "\<lbrakk> l = freshloc (fmap_dom (heap.oheap h)) ;
            h1 = \<lparr>oheap = (heap.oheap h)(l \<mapsto>\<^sub>f c),
                  iheap = iheapflds ifldvals l (heap.iheap h) (ienv E),
                  rheap = rheapflds rfldvals l (heap.rheap h) (renv E)\<rparr>;
            geq p (mkREnv 1 0 0 0 1)
          \<rbrakk> \<Longrightarrow>
          E;p \<turnstile> h,(New c ifldvals rfldvals) \<Down>1 (h1, RVal (Ref l))"

 exIf_True:  "\<lbrakk>E; p1 \<turnstile> h, IVar x \<Down>n (h1,IVal (grailbool True));
               E; p2 \<turnstile> h1, e1 \<Down>m (h2,v);
               geq p (renv_cup (mkREnv 1 0 0 0 0) (renv_cup p1 p2))
              \<rbrakk> \<Longrightarrow>
              E;p \<turnstile> h, (Ifg x e1 e2) \<Down>((max n m) + 1) (h2,v)"

 exIf_False: "\<lbrakk>E; p1 \<turnstile> h, IVar x \<Down>n (h1,IVal (grailbool False));
               E; p2 \<turnstile> h1, e2 \<Down>m (h2,v);
               geq p (renv_cup (mkREnv 1 0 0 0 0) (renv_cup p1 p2))
              \<rbrakk> \<Longrightarrow>
              E;p \<turnstile> h, (Ifg x e1 e2) \<Down>((max n m) + 1) (h2,v)"

 exLeti: "\<lbrakk>E; p1 \<turnstile> h,e1 \<Down>n (h1,IVal i);
           E<x:=i>; p2 \<turnstile> h1, e2 \<Down>m (h2,v);
           geq p (renv_cup (mkREnv 1 0 0 0 0) (renv_cup p1 p2))
          \<rbrakk> \<Longrightarrow>
          E;p \<turnstile> h, (Leti x e1 e2) \<Down>((max n m) + 1) (h2,v)"

 exLetr: "\<lbrakk>E; p1 \<turnstile> h,e1 \<Down>n (h1,RVal r);
           E\<lfloor>x:=r\<rfloor>; p2 \<turnstile> h1, e2 \<Down>m (h2,v);
           geq p (renv_cup (mkREnv 1 0 0 0 0) (renv_cup p1 p2))
          \<rbrakk> \<Longrightarrow>
          E;p \<turnstile> h, (Letr x e1 e2) \<Down>((max n m) + 1) (h2,v)"

 exLetv: "\<lbrakk>E; p1 \<turnstile> h,e1 \<Down>n (h1,w) ;  E; p2 \<turnstile> h1, e2 \<Down>m (h2,v);
           geq p (renv_cup p1 p2)
          \<rbrakk> \<Longrightarrow>
           E;p \<turnstile> h, (Letv e1 e2) \<Down>((max n m) + 1) (h2,v)"

 exCall: "\<lbrakk>E ; pp \<turnstile> h, funtable f \<Down>n (h1, v);
           geq p (renv_cup (mkREnv 1 1 0 0 0) pp)
          \<rbrakk> \<Longrightarrow>
          E;p \<turnstile> h,(Call f) \<Down>(n+1) (h1, v)"

 exInvoke: "\<lbrakk>E; p1 \<turnstile> h,RVar x \<Down>n (h1,RVal (Ref a)) ;  
             E; p2 \<turnstile> h1,RVar y \<Down>m (h2,RVal v);
             fmap_lookup (heap.oheap h2) a = Some C;
             (newframe_env (Ref a) v) ; p3 \<turnstile> h2,methtable C mn \<Down>k (h3,w);
             geq p (renv_plus (renv_cup (mkREnv 3 0 1 1 0) (renv_cup p1 p2)) p3)
            \<rbrakk> \<Longrightarrow>
            E;p \<turnstile> h, (Invoke x mn y) \<Down>((max (max n m) k) + 1) (h3,w)"

 exInvokeStatic: "\<lbrakk>E; p1 \<turnstile> h,RVar y \<Down>n (h1,RVal v); 
                   (newframe_env NullRef v); p2 \<turnstile> h1,methtable C mn \<Down>m (h2,w);
                   geq p (renv_plus (renv_cup (mkREnv 2 0 1 1 0) p1) p2)\<rbrakk> \<Longrightarrow>
                   E;p \<turnstile> h, (InvokeStatic C mn y) \<Down>((max n m) + 1) (h2,w)"

 exAnn: "\<lbrakk>geq p pp\<rbrakk> \<Longrightarrow> E; pp \<turnstile> h,e \<Down>n (h1,v) \<Longrightarrow> E; p \<turnstile> h,(Ann A e) \<Down>(n+1) (h1,v)"


text {*
  Comentary:
  \begin{enumerate}
  \item Put instructions in rules @{text evalPutFi} and @{text
  evalPutFr} are only evaluated
  for their side-effect and should only be used with @{text Letv}.  
  To emphasise this, they return the undetermined value @{text arbitrary}.

  \item Annotations are ignored in the operational semantics.
    
  \item To explain the resource counting in Invoke: vn1 = 1, vn2 = 1,
  frame push/pop = 2, and the implicit return = 1.
  NB: we could break up the increment of ticks into before/after 
  CALL.

  \item Many rules omit type-checking premises.
  For example, in get field and put field rules, we should
  check that the object belongs to a class that indeed has
  the fields being accessed.  

  \item
  Object initialization in the New rule simply sets an object
  component of the heap.
  The iheap and rheap are left alone.  For the logic (and
  by comparison with Grail), it might be better to have a
  New operator which also initialises the fields of an
  object.  However, if we admit in-place-update in objects,
  it seems difficult to avoid dealing with partly-defined
  data structures.

  \item 
   We might tickn 2 in the If rules, but we leave it at one to
   allow for extra store/retrieve which may not be necessary in 
   some cases on the real machine.

 \item The rule for evaluating Let once contained an additional side
  condition that the expression being bound does not itself contain a
  CALL (non-tail position).  So evaluation would get stuck for non-Grail
  programs.  However, there seems to be no harm in considering the
  more general semantics for a slightly richer language, since this
  side condition is not used in the logic.  (This restriction could
  therefore be considered as part of the type-checking phase for Toy Grail).

  \end{enumerate}
*}


subsection {* Elimination rules *}

inductive_cases eval_cases: 
 "E;p \<turnstile> h,(expr.Null) \<Down>n  (h1,v)"
 "E;p \<turnstile> h,(expr.Int i) \<Down>n  (h1,v)"
 "E;p \<turnstile> h,(IVar x) \<Down>n  (h1,v)"
 "E;p \<turnstile> h,(RVar x) \<Down>n  (h1,v)"
 "E;p \<turnstile> h,(Primop f x y) \<Down>n  (h1,v)"
 "E;p \<turnstile> h,(RPrimop f x y) \<Down>n  (h1,v)"
 "E;p \<turnstile> h,(GetFi x f) \<Down>n  (h1,v)"
 "E;p \<turnstile> h,(GetFr x f) \<Down>n  (h1,v)"
 "E;p \<turnstile> h,(PutFi x f y) \<Down>n  (h1,v)"
 "E;p \<turnstile> h,(PutFr x f y) \<Down>n  (h1,v)"
 "E;p \<turnstile> h,(New c ifldvals rfldvals) \<Down>n  (h1,v)"
 "E;p \<turnstile> h,(Ifg x e1 e2) \<Down>n  (h1,v)"
 "E;p \<turnstile> h,(Leti x e1 e2) \<Down>n  (h1,v)"
 "E;p \<turnstile> h,(Letr x e1 e2) \<Down>n  (h1,v)"
 "E;p \<turnstile> h,(Letv e1 e2) \<Down>n  (h1,v)"
 "E;p \<turnstile> h,(Call f) \<Down>n  (h1,v)"
 "E;p \<turnstile> h,(Invoke x m y) \<Down>n  (h1,v)"
 "E;p \<turnstile> h,(InvokeStatic C m y) \<Down>n  (h1,v)"
 "E;p \<turnstile> h,(Ann a e) \<Down>n  (h1,v)"

end
