(*  
   File:	ToyPrelude
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: Prelude.thy,v 1.1 2003/12/14 23:48:42 a1hloidl Exp $

   Prelude (core libraries) for Grail.
*)

header {* Prelude (core libraries) for Grail. *}

theory Prelude = Expr + FunMachine:

(* full detail on proof terms that are generated *)
ML {*
proofs := 2;
*}

subsection {* Semantic functions for useful Primops *}

constdefs AND_fct :: "[int,int]\<Rightarrow>int"  "AND_fct \<equiv> \<lambda> x y. x*y"
constdefs OR_fct  :: "[int,int]\<Rightarrow>int"  "OR_fct  \<equiv> \<lambda> x y. grailbool (0<x+y)"
constdefs NOT_fct :: "[int,int]\<Rightarrow>int"  "NOT_fct \<equiv> \<lambda> x y .grailbool (x=0)"

constdefs EQ_fct :: "[int,int]\<Rightarrow>int"  "EQ_fct \<equiv> \<lambda> x y. grailbool (x=y)"
constdefs NE_fct :: "[int,int]\<Rightarrow>int"  "NE_fct \<equiv> \<lambda> x y. grailbool (\<not> (x=y))"
constdefs LT_fct :: "[int,int]\<Rightarrow>int"  "LT_fct \<equiv> \<lambda> x y. grailbool (x<y)"
constdefs GT_fct :: "[int,int]\<Rightarrow>int"  "GT_fct \<equiv> \<lambda> x y. grailbool ((y<x))"
constdefs LE_fct :: "[int,int]\<Rightarrow>int"  "LE_fct \<equiv> \<lambda> x y. grailbool (\<not> (y<x))"
constdefs GE_fct :: "[int,int]\<Rightarrow>int"  "GE_fct \<equiv> \<lambda> x y. grailbool (\<not> (x<y))"

constdefs ISZERO_fct :: "[int,int]=>int"  "ISZERO_fct  \<equiv> \<lambda> x y . grailbool (x=0)"
constdefs NOTZERO_fct :: "[int,int]=>int" "NOTZERO_fct \<equiv> \<lambda> x y . grailbool (\<not> (x=0))"

constdefs DEC_fct :: "[int,int]=>int"   "DEC_fct   \<equiv> \<lambda> x y. x- 1"
constdefs INC_fct :: "[int,int]=>int"   "INC_fct   \<equiv> \<lambda> x y. x+1"
constdefs PLUS_fct :: "[int,int]=>int"  "PLUS_fct  \<equiv> \<lambda> x y. x+y"
constdefs MINUS_fct :: "[int,int]=>int" "MINUS_fct \<equiv> \<lambda> x y. x-y" 
constdefs MULT_fct :: "[int,int]=>int"  "MULT_fct  \<equiv> \<lambda> x y. x*y"

lemmas PrimopDefs = 
  AND_fct_def OR_fct_def NOT_fct_def 
  EQ_fct_def NE_fct_def LT_fct_def
  GT_fct_def LE_fct_def GE_fct_def 
  ISZERO_fct_def NOTZERO_fct_def
  DEC_fct_def INC_fct_def 
  PLUS_fct_def MINUS_fct_def 
  MULT_fct_def 

declare PrimopDefs [simp]


subsection {* Some handy shorthand syntax *}

text {* The syntax here and in following sections just defines
  abbreviations which are expanded and contracted by Isabelle's
  parser and printer.   These abbreviations have no logical
  meaning.
  *}

syntax
 "_primand"  :: "iname \<Rightarrow> iname \<Rightarrow> 'a expr"  (infixl ":&" 60)
 "_primor"  :: "iname \<Rightarrow> iname \<Rightarrow> 'a expr"  (infixl ":|" 60)
 "_primnot"  :: "iname \<Rightarrow> 'a expr"  (":\<not> _" [60] 61)
 "_primeq"  :: "iname \<Rightarrow> iname \<Rightarrow> 'a expr"  (infixl ":==" 60)
 "_primne"  :: "iname \<Rightarrow> iname \<Rightarrow> 'a expr"  (infixl ":!=" 60)
 "_primlt"  :: "iname \<Rightarrow> iname \<Rightarrow> 'a expr"  (infixl ":<" 60)
 "_primgt"  :: "iname \<Rightarrow> iname \<Rightarrow> 'a expr"  (infixl ":>" 60)
 "_primge"  :: "iname \<Rightarrow> iname \<Rightarrow> 'a expr"  (infixl ":>=" 60)
 "_primle"  :: "iname \<Rightarrow> iname \<Rightarrow> 'a expr"  (infixl ":<=" 60)
 "_primplus"  :: "iname \<Rightarrow> iname \<Rightarrow> 'a expr"  (infixl ":+" 60)
 "_primminus"  :: "iname \<Rightarrow> iname \<Rightarrow> 'a expr"  (infixl ":-" 60)
 "_primmult"  :: "iname \<Rightarrow> iname \<Rightarrow> 'a expr"  (infixl ":*" 60)

translations
 "n :& m"   == "Primop AND_fct n m"
 "n :| m"   == "Primop OR_fct  n m"
 ":\<not> m"     => "Primop NOT_fct m m"
 ":\<not> m"     <= "Primop NOT_fct m z"
 "n :== m"  == "Primop EQ_fct  n m"
 "n :!= m"  == "Primop NE_fct  n m"
 "n :> m"   == "Primop GT_fct  n m"
 "n :< m"   == "Primop LT_fct  n m"
 "n :>= m"  == "Primop GE_fct  n m"
 "n :<= m"  == "Primop LE_fct  n m"
 "n :+ m"   == "Primop PLUS_fct n m"
 "n :- m"   == "Primop MINUS_fct n m"
 "n :* m"   == "Primop MULT_fct n m"

syntax
 "_primiszero"  :: "iname \<Rightarrow> 'a expr"  ("_ :0?" [60] 61)
translations
 "n :0?" => "Primop ISZERO_fct n n"
 "n :0?" <= "Primop ISZERO_fct n z"

syntax
 "_priminc"  :: "iname \<Rightarrow> 'a expr"  ("_ :++" [60] 61)
translations
 "m :++" => "Primop INC_fct m m"
 "m :++" <= "Primop INC_fct m z"

syntax
 "_primdec"  :: "iname \<Rightarrow> 'a expr"  ("_ :--" [60] 61)
translations
 "m :--" => "Primop DEC_fct m m"
 "m :--" <= "Primop DEC_fct m z"



subsection {* Syntax for injections *}

syntax
 "_numgr"  :: "'a \<Rightarrow> 'a expr"  ("_\<^sup>z" [1000] 65)   (* did have \<int> here, but X-Sym bugs *)
 "_mkIVar"  :: "iname \<Rightarrow> 'a expr"  ("_\<^sup>I" [1000] 65)
 "_mkRVar"  :: "rname \<Rightarrow> 'a expr"  ("_\<^sup>R" [1000] 65)

translations
 "n\<^sup>z" == "expr.Int n"
 "x\<^sup>I" == "expr.IVar x"
 "x\<^sup>R" == "expr.RVar x"


subsection {* Syntax for constants *}

syntax
  tt :: "'a expr"
  ff :: "'a expr"
translations
 "tt" == "1\<^sup>z"
 "ff" == "0\<^sup>z"

end
