(* This file contains basic components of the machine model
   (which are needed by expressions)
 *)

header {* Basic definitions for the machine model *} 

(*<*)
theory MachineBasic =  Main:

(* full detail on proof terms that are generated *)
ML {*
proofs := 2;
*}
(*>*)

subsection {* Types and Names *}

text {* We declare abstract types for names, including some 
  reserved names. *}

typedecl
  iname		 --  {* names of integer variables *}
typedecl
  rname		 --  {* names of reference variables *}

consts
  self     :: rname -- {* the self object *}
  param    :: rname -- {* the method parameter *}
  params   :: "rname list" -- {* the method parameters *}

axioms
  constdistinct: "distinct [self,param,dummyref]"
typedecl
funame          -- {* names of functions *}
typedecl 
  cname		-- {* names of classes *}
typedecl
  ifldname	-- {* names of integer fields *}
typedecl
  rfldname	-- {* names of reference fields *}
typedecl
  mname		-- {* names of methods *}


subsection {* Locations and references *}

text {*
  We model locations as natural numbers.  This is somewhat concrete,
  but avoids constructing an abstract type or
  assuming the properties we expect. *}

types
  locn = nat

datatype ref = Nullref | Ref locn  

text {* We define a partial projection on non-null locations. *}

consts theloc :: "ref \<Rightarrow> locn"
primrec
  "theloc (Ref a) = a"

text {* 
  Given a finite set of locations, we can always find a new fresh one.
  *}

constdefs
  freshloc  :: "locn set \<Rightarrow> locn"         
 "freshloc L == Suc (Max (insert 0 L))" 

lemma freshloc: "finite L \<Longrightarrow> freshloc L \<notin> L"
  apply (simp add: freshloc_def)
  apply (subgoal_tac "finite (insert 0 L)")
  apply (erule thin_rl)
  apply (drule Max)
  apply (auto)
  done



(*<*)
end
(*>*)
