(*  
   File:	$RCSfile: ExampleSwapI.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleSwapI.thy,v 1.1 2003/12/14 23:48:41 a1hloidl Exp $

   Non-recursive function (VDM style) w/ Invokes
*)

theory ExampleSwapI = VDM + Prelude + Lemmas + Adapt :

section {* swap two fields *}

(* taken from ExampleSwapFields *)

subsection {* Version w/ InvokeStaticMulti *}

locale swap_example =
  fixes    m  :: iname
  fixes	   n  :: iname
  fixes	   q  :: iname
  fixes	   x    :: ifldname
  fixes	   swap      :: mname
  fixes    SwapClass :: cname
  fixes    f  :: rname
  fixes    g  :: rname
  assumes swapbody[simp]: 
  "methtable SwapClass swap =  
     ((LET 
      m  = param1\<bullet>x ;
      n  = param2\<bullet>x ;
      q  = n :< m
     IN
      IF q 
        THEN LET
               _ = param1\<bullet>x := n ; 
               _ = param2\<bullet>x := m 
      IN
         1\<^sup>z
      END 
         ELSE 0\<^sup>z
     END) :: 'a expr)"
  assumes  allclasses: "all_classes = {SwapClass}"
  assumes  vardistinct: "distinct [m,n,q]"
  (* assumes  flddistinct: "distinct [x,y]" *)

lemma (in swap_example) 
   "\<rhd> ((InvokeStaticMulti SwapClass swap [f,g]) :: 'a expr) :
       {(E,h,hh,v,p). \<exists> a b . (E\<lfloor>f\<rfloor> = Ref a \<longrightarrow> E\<lfloor>g\<rfloor> = Ref b \<longrightarrow> hh<a\<bullet>x> = min (h<a\<bullet>x>) (h<b\<bullet>x>) \<and> hh<b\<bullet>x> = max (h<a\<bullet>x>) (h<b\<bullet>x>))}"
apply (rule vdm_invokestaticmulti)
apply (rule vdm_conseq)
(* apply (rule adapt_invokestatic) *)
(* apply (rule vdm_ax) *)
apply clarsimp
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule subsetI)
apply auto
apply (rule_tac x="ad" in exI) 
apply (rule impI)
apply (rule_tac x="ae" in exI) 
apply (rule impI)
oops


(*
apply (rename_tac E hi hpost v a p)
apply (rule_tac x="a" in exI)
apply clarsimp
apply (case_tac "hi<a\<bullet>y> < E<m:=hi<a\<bullet>x>><n:=hi<a\<bullet>y>><m>") (* do the swap *)
 apply (insert vardistinct)
 apply clarsimp
 apply (rule conjI)
 apply arith
 apply arith
 (* .. *)
 apply (rule conjI)
 apply (simp, arith)+
done
*)


end
