(* 				 
   File:	$RCSfile: SemanticsFM.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: SemanticsFM.thy,v 1.1 2003/12/14 23:48:39 a1hloidl Exp $

   Functional semantics for a (restricted version of) Grail.
*)

header {* Big-step semantics *}

(*<*)
theory SemanticsFM = Finmap + Expr + FunMachine + Lemmas:
(*>*)

(* --------------------------------------------------------------------------- *)

consts
 param1 :: "rname"
 param2 :: "rname"
 param3 :: "rname"
 param4 :: "rname"
 param5 :: "rname"
 param6 :: "rname"
 param7 :: "rname"
 param8 :: "rname"
 param9 :: "rname"

constdefs
 params :: "rname list"
 "params == [param1,param2,param3,param4,param5,param6,param7,param8,param9]"

types Bindings = "rname \<leadsto>\<^sub>f ref"

constdefs "bind_args" :: "Bindings \<Rightarrow> env \<Rightarrow> env"
 "bind_args bs E     == E\<lparr> renv := \<lambda> x. (if (x : fmap_dom bs) then (the (fmap_lookup bs x)) else (E\<lfloor>x\<rfloor>)) \<rparr> "

consts "mk_bindings" :: "(rname \<times> rname) list \<Rightarrow> env \<Rightarrow> Bindings"
primrec
 "mk_bindings [] E = emptyfinmap"
 "mk_bindings (x#xs) E = (case x of (a,b) \<Rightarrow> (mk_bindings xs E)(a\<mapsto>\<^sub>fE\<lfloor>b\<rfloor>))"

(*
lemma rvarUpdSwap: "x~=y ==> E\<lfloor>x := a\<rfloor>\<lfloor>y := b\<rfloor> = E\<lfloor>y := b\<rfloor>\<lfloor>x := a\<rfloor>"
sorry

lemma ba_other: "\<forall> x y E E'. x~=y \<longrightarrow> (bind_args xs E (E'\<lfloor>y:=z\<rfloor>))\<lfloor>x\<rfloor> = (bind_args xs E E')\<lfloor>x\<rfloor>"
apply (rule bind_args.induct)
 apply clarsimp
 (* .. *)
 apply (rule allI)+
 apply (rule impI)
 apply (rename_tac x' xs' x y E E')
 apply clarsimp
 apply (erule_tac x="x" in allE) apply (rotate_tac -1)
 apply (erule_tac x="y" in allE) apply (rotate_tac -1)
 apply clarsimp
 apply (case_tac "x=a")
  apply clarsimp
  apply (subgoal_tac "E'\<lfloor>y:=z\<rfloor>\<lfloor>a:=E\<lfloor>b\<rfloor>\<rfloor> = E'\<lfloor>a:=E\<lfloor>b\<rfloor>\<rfloor>\<lfloor>y:=z\<rfloor>")
   apply clarsimp
   apply (rule sym)
   apply (frule rvarUpdSwap) (*  [of "y" "a" "E'" "z" "E\<lfloor>b\<rfloor>"]) *)
   apply fast
 apply (erule_tac x="E" in allE) apply (rotate_tac -1)
 apply (erule_tac x="E'\<lfloor>a:=E\<lfloor>b\<rfloor>\<rfloor>" in allE)
 apply (case_tac "y=a")
  apply clarsimp
  (* .. *)
  apply (rotate_tac -1)
  apply (subgoal_tac "E'\<lfloor>y:=z\<rfloor>\<lfloor>a:=E\<lfloor>b\<rfloor>\<rfloor> = E'\<lfloor>a:=E\<lfloor>b\<rfloor>\<rfloor>\<lfloor>y:=z\<rfloor>")
    apply clarsimp
    (* .. *)
    (* apply (frule sym) *)
    apply (rotate_tac -1) apply (erule thin_rl)
    apply (frule rvarUpdSwap) (*  [of "y" "a" "E'" "z" "E\<lfloor>b\<rfloor>"]) *)
    apply fast
done

lemma ba_other2: "\<lbrakk> x~=y \<rbrakk> \<Longrightarrow> (bind_args xs E (E'\<lfloor>y:=z\<rfloor>))\<lfloor>x\<rfloor> = (bind_args xs E E')\<lfloor>x\<rfloor>"
apply (insert ba_other)
apply fast
done

consts "is_bound" :: "(rname \<times> rname) list \<Rightarrow> rname \<Rightarrow> bool"
primrec
 "is_bound [] y = False"
 "is_bound (x#xs) y = (case x of (a,b) => ((a=y) \<or> is_bound xs y))"

lemma b1:"\<forall> x zs . \<not> is_bound zs x \<longrightarrow> (bind_args zs E E')\<lfloor>x\<rfloor> = E'\<lfloor>x\<rfloor>"
 apply (rule allI)+
 apply (rule bind_args.induct) apply clarsimp 
  apply clarify
  apply (frule mp)
  apply (case_tac "a=x")
   apply clarsimp
   apply clarsimp
  apply (erule thin_rl)
  apply clarsimp
  apply (subgoal_tac "(bind_args xs E E'\<lfloor>a:=E\<lfloor>b\<rfloor>\<rfloor>)\<lfloor>x\<rfloor> = (bind_args xs E E')\<lfloor>x\<rfloor>")
  apply (subgoal_tac "x~=a")
   apply (rotate_tac -1)
   apply (frule ba_other2) 
   apply clarsimp
  apply clarsimp
  apply (subgoal_tac "x~=a")
   apply (rotate_tac -1)
   apply (frule ba_other2) 
   apply fast
  apply clarsimp
done

lemma b1_2:"\<not> is_bound zs x \<Longrightarrow> (bind_args zs E E')\<lfloor>x\<rfloor> = E'\<lfloor>x\<rfloor>"
apply (insert b1)
apply clarsimp 
done
*)

(* old crap 
lemma b1:"\<forall> x . (\<not> (\<exists> y. (x,y) \<in> set zs)) \<longrightarrow> (bind_args zs E E')\<lfloor>x\<rfloor> = E'\<lfloor>x\<rfloor>"
 apply (induct zs)
 apply (rule allI)+ apply (clarsimp)
 apply (rename_tac x' xs')
 apply (clarsimp)
 (* apply (rule bind_args.induct) apply clarsimp  apply (rule allI)+ *)
 (* apply clarsimp *)
 apply (subgoal_tac "x~=a")
  apply clarsimp
  apply (insert ba_other) apply (rotate_tac -1)
  apply (erule_tac x="x" in allE)
  apply (erule_tac x="x" in allE)
  apply (erule_tac x="x" in allE)
  apply clarsimp
  apply (subgoal_tac "(E'\<lfloor>a := E\<lfloor>b\<rfloor>\<rfloor>)\<lfloor>x\<rfloor> = E'\<lfloor>x\<rfloor>")
   apply (frule rvarUpdOther) (*  [of "x" "a" "E'" "E\<lfloor>b\<rfloor>"]) *)
   apply clarsimp
   apply (subgoal_tac "E'\<lfloor>a:=E\<lfloor>b\<rfloor>\<rfloor>\<lfloor>x\<rfloor> = E'\<lfloor>x\<rfloor>")
    apply clarsimp
   apply (rule bind_args.induct)
    apply (subgoal_tac "a~=x")
    apply clarsimp

 apply (rename_tac z zs z' xs' ys')
 apply (erule_tac x="z'" in allE)
 apply (erule_tac x="xs'" in allE)
 apply (erule_tac x="ys'" in allE)
 apply clarsimp
 apply (rotate_tac 1)
 apply (frule sym)
 apply (erule thin_rl)
 apply (rotate_tac -1)
 apply clarsimp
sorry
*)
(*
consts is_unique :: "(rname \<times> rname) list \<Rightarrow> rname \<Rightarrow> bool"
primrec
 "is_unique [] y = False"
 "is_unique (x#xs) y = (case x of (a,b) => (if (a=y) then \<not> is_bound xs y else is_unique xs a))"

lemma b2 : "is_unique zs x \<longrightarrow> (x,y) \<in> set zs \<longrightarrow> (bind_args zs E E')\<lfloor>x\<rfloor> = E\<lfloor>y\<rfloor>"
apply (rule bind_args.induct) apply clarsimp
(* apply (induct xs) *)
apply clarsimp
(* apply (rename_tac x' y' xs') *)
apply (rule conjI)
apply (rule impI)
apply (erule conjE) apply clarsimp
apply (subgoal_tac "(bind_args xs E E'\<lfloor>x:=E\<lfloor>y\<rfloor>\<rfloor>)\<lfloor>x\<rfloor> = E'\<lfloor>x:=E\<lfloor>y\<rfloor>\<rfloor>\<lfloor>x\<rfloor>")
apply clarsimp
apply (rule b1_2)
apply assumption
apply (rule impI)
apply (case_tac "a=x")
 apply clarsimp
 defer 1
 apply (frule ba_other2)
oops
*)
(*
  apply (subgoal_tac "(E'\<lparr>renv := (renv_fct E')(x := E\<lfloor>y\<rfloor>)\<rparr>) = E'")
   apply clarsimp
 apply (frule b1) apply auto
 apply (frule b1 [of "x" "x#xs'" _ "ys"]) apply clarsimp
 apply (simp only: bind_args_def)
apply (case_tac "(y, z) \<in> set xs")
 apply simp
oops
*)

constdefs
  newframe_env_multi :: "env \<Rightarrow> ref \<Rightarrow> (rname \<times> rname) list \<Rightarrow> env" 
  "newframe_env_multi E objref ys \<equiv> bind_args (mk_bindings ys E)
                                	   \<lparr> ienv = emptyi,
                                	     renv = (emptyr(self := objref)) \<rparr>"
                                


(* --------------------------------------------------------------------------- *)

(* full detail on proof terms that are generated *)
ML {*
proofs := 2;
*}

text {*
  We define a big-step semantics for  Grail.  For the purpose of later
  proofs, the relation is also indexed by the height of the derivation.
  *}

subsection{* Preliminaries: resource environments and abbreviations *}

text {* 
We define resource tuples to model resource consumption during the execution.
Currently, a resource tuple is a record with 4 components, counting execution time, 
function and method calls, and measuring maximal depth of method invocations.
*}

record renv = clock :: nat        -- {* execution time *}
              callc :: nat        -- {* call counter *}
              invkc :: nat        -- {* invoke counter *}
              invkdpth :: nat     -- {* max invoke depth *}

text {*
To add up resource consumption, we use the following two combinators over resource tuples.
*}

translations 
 "renv" <=(type) "\<lparr> clock :: nat, callc :: nat, invkc :: nat, invkdpth :: nat \<rparr>"

constdefs renv_plus:: "renv \<Rightarrow> renv \<Rightarrow> renv"  (infixr "\<oplus>" 0)
"renv_plus p1 p2 == \<lparr>clock = clock p1 + clock p2,
                     callc = callc p1 + callc p2,
                     invkc = invkc p1 + invkc p2,
                     invkdpth = invkdpth p1 + invkdpth p2\<rparr>"

constdefs renv_cup :: "renv \<Rightarrow> renv \<Rightarrow> renv" (infixr "\<smile>" 0)
"renv_cup p1 p2 == \<lparr>clock = clock p1 + clock p2,
                    callc = callc p1 + callc p2,
                    invkc = invkc p1 + invkc p2,
                    invkdpth = max (invkdpth p1) (invkdpth p2)\<rparr>"

text {* Some nicer syntax for creating and manipulating resource tuples. *}

(*constdefs*) 
syntax mkREnv:: "nat \<Rightarrow> nat \<Rightarrow> nat \<Rightarrow> nat \<Rightarrow> renv"
translations
"mkREnv C CC IC ID" == "\<lparr>clock = C, callc = CC, invkc = IC, invkdpth = ID\<rparr>"

syntax mkREnv_HWL :: "nat \<Rightarrow> nat \<Rightarrow> nat \<Rightarrow> nat \<Rightarrow> renv" ("\<langle>_ _ _ _\<rangle>")
translations
"\<langle>C CC IC ID\<rangle>" == "\<lparr>renv.clock = C, callc = CC, invkc = IC, invkdpth = ID\<rparr>"

(*avoid name clash with tickn and tick*)
(*constdefs*)
syntax tkn ::"nat \<Rightarrow> renv \<Rightarrow> renv"
translations
"tkn n p" == "((mkREnv n 0 0 0) \<smile> p)"

(*constdefs*)
syntax tk::"renv \<Rightarrow> renv"
translations
"tk p" == "tkn 1 p"

(*constdefs*)
syntax tkcall::"renv \<Rightarrow> renv"
translations
"tkcall p" == "((mkREnv 1 1 0 0) \<smile> p)"

(*a resource environment with a single clocktick*)
(*constdefs*)
syntax tickRo::"renv"
translations
"tickRo" == "mkREnv (Suc 0) 0 0 0"

declare renv_plus_def [simp add]
declare renv_cup_def [simp add]
(*declare mkREnv_def [simp add]
declare tkn_def [simp add]
declare tk_def [simp add]
declare tkcall_def [simp add]
declare tickRo_def [simp add]
*)

text {*
Function for creating a new object on the heap and initialising its fields with the
given values.
*}

(*Similar to newobj*)
constdefs
  newObj    :: "heap \<Rightarrow> locn \<Rightarrow> env \<Rightarrow> cname \<Rightarrow> (ifldname \<times> iname) list \<Rightarrow> (rfldname \<times> rname) list \<Rightarrow> heap"
  "newObj h l e c ifldvals rfldvals \<equiv> 
       \<lparr> oheap = (heap.oheap h)(l \<mapsto>\<^sub>f c),
         iheap = iheapflds ifldvals l (heap.iheap h) (ienv_fct e),
         rheap = rheapflds rfldvals l (heap.rheap h) (renv_fct e) \<rparr>"


subsection {* Operational semantics *}

text {*
We now define the operational semantics of Grail as an inductively defined set, 
connecting, for a given expression, all possible pre-states with its post-states.
Note that we define the semantics with a counter of derivation height to use this
counter later on in the soundness  proof to do induction over. The counter is \emph{not}
used to capture resource consumption (we have a separate field in the resource tuple 
for that). 
*}

consts
  semn  :: "(env \<times> heap \<times> 'a expr \<times> nat \<times> heap \<times> val \<times> renv) set" -- {* operational semantics *}

syntax
 semn_  :: "[env, heap, 'a expr, nat, heap, val, renv] \<Rightarrow> bool"   ("_ \<turnstile> _ , _ \<Down>_ '(_ , _ , _')")

translations
 "E \<turnstile> h,e \<Down>n (hh,v,p)" == "(E,h,e,n,hh,v,p) : semn"

inductive semn intros
 semNull:    "E \<turnstile> h,(expr.Null) \<Down>1 (h,RVal Nullref, tickRo)"

 semInt:     "E \<turnstile> h,(expr.Int i) \<Down>1 (h,IVal i, tickRo)"

 semIVar:    "E \<turnstile> h,IVar v \<Down>1 (h,IVal (E<v>), tickRo)"

 semRVar:    "E \<turnstile> h,RVar v \<Down>1 (h,RVal (E\<lfloor>v\<rfloor>), tickRo)"

 semPrimop:  "E \<turnstile> h, (Primop f x y) \<Down>1 (h,IVal (f (E<x>) (E<y>)), \<langle>3 0 0 0\<rangle>)"

 semRPrimop:  "E \<turnstile> h, (RPrimop f x y) \<Down>1 (h,IVal (f (E\<lfloor>x\<rfloor>) (E\<lfloor>y\<rfloor>)), \<langle>3 0 0 0\<rangle>)"

 semGetfi: "\<lbrakk>E\<lfloor>x\<rfloor> = Ref a\<rbrakk> \<Longrightarrow>
            E \<turnstile> h,(GetFi x f) \<Down>1 (h, IVal ((heap.iheap h) f a), \<langle>2 0 0 0\<rangle>)"

 semGetfr: "\<lbrakk>E\<lfloor>x\<rfloor> = Ref a\<rbrakk> \<Longrightarrow>
            E \<turnstile> h,(GetFr x f) \<Down>1 (h, RVal ((heap.rheap h) f a), \<langle>2 0 0 0\<rangle>)"

 semPutfi: "\<lbrakk>E\<lfloor>x\<rfloor> = Ref a\<rbrakk> \<Longrightarrow>
            E \<turnstile> h, (PutFi x f y) \<Down>1 (h<a\<bullet>f:=E<y>>, arbitrary, \<langle>3 0 0 0\<rangle>)"

 semPutfr: "\<lbrakk>E\<lfloor>x\<rfloor> = Ref a\<rbrakk> \<Longrightarrow>
            E \<turnstile> h, (PutFr x f y) \<Down>1 (h\<lfloor>a\<diamondsuit>f:=E\<lfloor>y\<rfloor>\<rfloor>, arbitrary,\<langle>3 0 0 0\<rangle>)"

 semNew: "\<lbrakk> l = freshloc (fmap_dom (heap.oheap h))\<rbrakk> \<Longrightarrow>
          E \<turnstile> h,(New c ifldvals rfldvals) \<Down>1 (newObj h l E c ifldvals rfldvals, RVal (Ref l), tickRo)"

 semIf_True:  "\<lbrakk>E<x> = grailbool True; E \<turnstile> h, e1 \<Down>m (h1,v,p)\<rbrakk> \<Longrightarrow>
               E \<turnstile> h, (Ifg x e1 e2) \<Down>(m + 1) (h1,v, (tkn 2 p))"

 semIf_False:  "\<lbrakk>E<x> = grailbool False; E \<turnstile> h, e2 \<Down>m (h1,v,p)\<rbrakk> \<Longrightarrow>
                E \<turnstile> h, (Ifg x e1 e2) \<Down>(m + 1) (h1,v, (tkn 2 p))"

 semLeti: "\<lbrakk>E \<turnstile> h,e1 \<Down>n (h1,IVal i,p1);  E<x:=i> \<turnstile> h1, e2 \<Down>m (h2,v,p2)\<rbrakk> \<Longrightarrow>
           E \<turnstile> h, (Leti x e1 e2) \<Down>((max n m) + 1) (h2,v, tk (p1 \<smile> p2))"

 semLetr: "\<lbrakk>E \<turnstile> h,e1 \<Down>n (h1,RVal r,p1);  E\<lfloor>x:=r\<rfloor> \<turnstile> h1, e2 \<Down>m (h2,v,p2)\<rbrakk> \<Longrightarrow>
           E \<turnstile> h, (Letr x e1 e2) \<Down>((max n m) + 1) (h2,v, tk (p1 \<smile> p2))"

 semLetv: "\<lbrakk>E \<turnstile> h,e1 \<Down>n (h1,w,p1);  E \<turnstile> h1, e2 \<Down>m (h2,v,p2)\<rbrakk> \<Longrightarrow>
           E \<turnstile> h, (Letv e1 e2) \<Down>(max n m) (h2,v, p1 \<smile> p2)"

 semCall: "\<lbrakk>E \<turnstile> h, funtable f \<Down>n (h1,v,p)\<rbrakk> \<Longrightarrow>
           E \<turnstile> h,(Call f) \<Down>(n+1) (h1, v, tkcall p)"

 semInvoke: "\<lbrakk>E\<lfloor>x\<rfloor> = Ref a;  
              fmap_lookup (heap.oheap h) a = Some C; 
              (newframe_env (Ref a) (E\<lfloor>y\<rfloor>)) \<turnstile> h,methtable C mn \<Down>n (h1,v,p)\<rbrakk> \<Longrightarrow>
             E \<turnstile> h, (Invoke x mn y) \<Down>(n + 1) (h1,v,\<langle>5 0 1 1\<rangle> \<oplus> p)"

 semInvokeStatic: "\<lbrakk>(newframe_env Nullref (E\<lfloor>y\<rfloor>)) \<turnstile> h,methtable C mn \<Down>n (h1,v,p)\<rbrakk> \<Longrightarrow>
                   E \<turnstile> h, (InvokeStatic C mn y) \<Down>(n + 1) (h1,v, \<langle>3 0 1 1\<rangle> \<oplus> p)"

 semInvokeStaticMulti: "\<lbrakk> (newframe_env_multi E Nullref (zip params ys)) \<turnstile> h,methtable C mn \<Down>n (h1,v,p)\<rbrakk> \<Longrightarrow>
                   E \<turnstile> h, (InvokeStaticMulti C mn ys) \<Down>(n + 1) (h1,v, \<langle>3 0 1 1\<rangle> \<oplus> p)"

 semMHInvoke: "\<lbrakk>E\<lfloor>x\<rfloor> = Ref a;
                fmap_lookup (heap.oheap h) a = Some C; 
                E\<lfloor>self := Ref a\<rfloor>  \<turnstile> h,methtable C mn \<Down>n (h1,v,p)\<rbrakk> \<Longrightarrow>
               E \<turnstile> h, (MH_Invoke x mn) \<Down>(n + 1) (h1,v,\<langle>4 0 1 1\<rangle> \<oplus> p)"

 semMHInvokeStatic: "\<lbrakk>E \<turnstile> h,methtable C mn \<Down>n (h1,v,p)\<rbrakk> \<Longrightarrow>
                     E \<turnstile> h, (MH_InvokeStatic C mn) \<Down>(n + 1) (h1,v, \<langle>2 0 1 1\<rangle> \<oplus> p)"

(*  semAnn: "E \<turnstile> h,e \<Down>n (h1,v,p) \<Longrightarrow> E \<turnstile> h,(Ann A e) \<Down>(n+1) (h1,v,p)" *)

text {* Operational semantics without height index *}

constdefs
 sem :: "[env, heap, 'a expr, heap, val, renv] \<Rightarrow> bool"  ("_ \<turnstile> _ , _ \<Down> _ , _ , _" 1000)
 "E \<turnstile> h,e \<Down> hh,v,p \<equiv> (\<exists> n. (E \<turnstile> h,e \<Down>n (hh,v,p)))"

text {*
  Comentary:
  \begin{enumerate}
  \item in MHInvokeStatic: static condition: method body does not refer to ''this'' - no need
    to add the binding self $\mapsto$ Nullref to E
  \item Put instructions in rules @{text evalPutFi} and @{text
  evalPutFr} are only evaluated
  for their side-effect and should only be used with @{text Letv}.  
  To emphasise this, they return the undetermined value @{text arbitrary}.

  \item Annotations are ignored in the operational semantics.
    
  \item To explain the resource counting in Invoke: vn1 = 1, vn2 = 1,
  frame push/pop = 2, and the implicit return = 1.
  NB: we could break up the increment of ticks into before/after 
  CALL.

  \item Many rules omit type-checking premises.
  For example, in get field and put field rules, we should
  check that the object belongs to a class that indeed has
  the fields being accessed.  

  \item
  Object initialization in the New rule simply sets an object
  component of the heap.
  The iheap and rheap are left alone.  For the logic (and
  by comparison with Grail), it might be better to have a
  New operator which also initialises the fields of an
  object.  However, if we admit in-place-update in objects,
  it seems difficult to avoid dealing with partly-defined
  data structures.

  \item 
   We might tickn 2 in the If rules, but we leave it at one to
   allow for extra store/retrieve which may not be necessary in 
   some cases on the real machine.

 \item The rule for evaluating Let once contained an additional side
  condition that the expression being bound does not itself contain a
  CALL (non-tail position).  So evaluation would get stuck for non-Grail
  programs.  However, there seems to be no harm in considering the
  more general semantics for a slightly richer language, since this
  side condition is not used in the logic.  (This restriction could
  therefore be considered as part of the type-checking phase for Toy Grail).

  \end{enumerate}
*}

subsection {* Elimination rules *}

inductive_cases eval_cases: 
 "E \<turnstile> h,(expr.Null) \<Down>n  (h1,v,p)"
 "E \<turnstile> h,(expr.Int i) \<Down>n  (h1,v,p)"
 "E \<turnstile> h,(IVar x) \<Down>n  (h1,v,p)"
 "E \<turnstile> h,(RVar x) \<Down>n  (h1,v,p)"
 "E \<turnstile> h,(Primop f x y) \<Down>n  (h1,v,p)"
 "E \<turnstile> h,(RPrimop f x y) \<Down>n  (h1,v,p)"
 "E \<turnstile> h,(GetFi x f) \<Down>n  (h1,v,p)"
 "E \<turnstile> h,(GetFr x f) \<Down>n  (h1,v,p)"
 "E \<turnstile> h,(PutFi x f y) \<Down>n  (h1,v,p)"
 "E \<turnstile> h,(PutFr x f y) \<Down>n  (h1,v,p)"
 "E \<turnstile> h,(New c ifldvals rfldvals) \<Down>n  (h1,v,p)"
 "E \<turnstile> h,(Ifg x e1 e2) \<Down>n  (h1,v,p)"
 "E \<turnstile> h,(Leti x e1 e2) \<Down>n  (h1,v,p)"
 "E \<turnstile> h,(Letr x e1 e2) \<Down>n  (h1,v,p)"
 "E \<turnstile> h,(Letv e1 e2) \<Down>n  (h1,v,p)"
 "E \<turnstile> h,(Call f) \<Down>n  (h1,v,p)"
 "E \<turnstile> h,(Invoke x m y) \<Down>n  (h1,v,p)"
 "E \<turnstile> h,(InvokeStatic C m y) \<Down>n  (h1,v,p)"
 "E \<turnstile> h,(InvokeStaticMulti C m ys) \<Down>n  (h1,v,p)"
 "E \<turnstile> h,(MH_Invoke x m) \<Down>n  (h1,v,p)"
 "E \<turnstile> h,(MH_InvokeStatic C m) \<Down>n  (h1,v,p)"

(*  "E \<turnstile> h,(Ann a e) \<Down>n  (h1,v,p)" *)

subsection {* Miscellaneous lemmas *}

lemma no_zero_height_derivsAux: "\<forall> E h h1 v p . (E \<turnstile> h, e \<Down>0  (h1,v,p) \<longrightarrow> False)"
(*<*)
apply (induct_tac e)
apply (simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
defer 1
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply clarsimp
apply (subgoal_tac "n=0 & m=0")
apply clarsimp
apply (simp add: max_def)
apply (case_tac "n \<le> m", auto)
done
(*>*)

lemma no_zero_height_derivs: "E \<turnstile> h, e \<Down>0  (h1,v,p) \<Longrightarrow> False"
by (insert no_zero_height_derivsAux, fastsimp)

(*<*)
end
(*>*)
