(*  
   File:	$RCSfile: ExSwap.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExSwap.thy,v 1.1 2003/12/05 15:19:17 a1hloidl Exp $

   Non-recursive function (VDM style) w/ Invokes
*)

theory ExSwap = VDM + Prelude + Lemmas + Adapt :

section {* swap two fields *}

(* taken from ExampleSwapFields *)

subsection {* Version w/ MH_InvokeStatic *}

text {* Version with 2 params *}

locale swap_example =
  fixes    m  :: iname
  fixes	   n  :: iname
  fixes	   q  :: iname
  fixes	   x    :: ifldname
  fixes	   swap      :: mname
  fixes    SwapClass :: cname
  fixes    f  :: rname
  fixes    foo  :: rname
  fixes    bar  :: rname
  fixes    a    :: locn
  fixes    b    :: locn
  assumes swapbody[simp]: 
  "methtable SwapClass swap =  
     ((LET 
      m  = param1\<bullet>x ;
      n  = param2\<bullet>x ;
      q  = n :< m
     IN
      IF q 
        THEN LET
               _ = param1\<bullet>x := n ; 
               _ = param2\<bullet>x := m 
      IN
         1\<^sup>z
      END 
         ELSE 0\<^sup>z
     END) :: 'a expr)"
  assumes  allclasses: "all_classes = {SwapClass}"
  assumes  vardistinct: "distinct [m,n,q] \<and> distinct [param1,param2]"
  assumes  flddistinct: "distinct [x,y]"


lemma (in swap_example) 
   "{} \<rhd> ((InvokeStaticMulti SwapClass swap [foo,bar]) :: 'a expr) :
    {(E,h,hh,v,p). (qach_QaQ E h a foo SwapClass \<and> qach_QaQ E h b bar SwapClass)  \<longrightarrow> (hh<a\<bullet>x> = min (h<a\<bullet>x>) (h<b\<bullet>x>) \<and> hh<b\<bullet>x> = max (h<a\<bullet>x>) (h<b\<bullet>x>))}"
apply (rule vdm_invokestaticmulti)
apply (simp)
apply (rule vdm_conseq)
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) 
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) 
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) 
apply (rule vdm_basics) 
apply (rule vdm_basics) 
apply (rule vdm_basics)
apply (rule vdm_basics)
apply clarsimp
apply (simp add: newframe_env_multi_def qach_QaQ_def)
(* apply (rename_tac E hi hpost v a p) *)
apply (case_tac "aa<ae\<bullet>x> < aa<ad\<bullet>x>")
 apply clarsimp
 apply (simp add: newframe_env_multi_def bind_args_def qach_QaQ_def)
(* -- *)
apply (rule_tac x="a" in exI)
apply clarsimp
apply (case_tac "hi<a\<bullet>y> < E<m:=hi<a\<bullet>x>><n:=hi<a\<bullet>y>><m>") (* do the swap *)
 apply (insert vardistinct)
 apply clarsimp
 apply (rule conjI)
 apply arith
 apply arith
 (* .. *)
 apply (rule conjI)
 apply (simp, arith)+
done

subsection {* Version w/ Invoke *}

(*--
lemma (in swap_example) 
   "\<rhd> ((MH_Invoke f swap) :: 'a expr) :
    {(E,h,hh,v,p). \<exists> a . (E\<lfloor>f\<rfloor> = Ref a \<and> fmap_lookup (oheap h) a = Some SwapClass \<longrightarrow> hh<a\<bullet>x> = min (h<a\<bullet>x>) (h<a\<bullet>y>) \<and> hh<a\<bullet>y> = max (h<a\<bullet>x>) (h<a\<bullet>y>))}"
apply (rule vdm_mhinvoke)
apply (simp add: qach_QaQ_def)
apply (rule allI)+
apply (rule impI)
apply (case_tac "C=SwapClass")
 apply (simp add: swapbody)
 apply clarsimp
 apply (rule vdm_conseq)
 apply (rule vdm_basics) defer 1
 apply (rule vdm_basics) defer 1
 apply (rule vdm_basics) defer 1
 apply (rule vdm_basics) 
 apply (rule vdm_basics) defer 1
 apply (rule vdm_basics) defer 1
 apply (rule vdm_basics)
 apply (rule vdm_basics) 
 defer 1 
 defer 1 (* other case *)
 apply (rule vdm_basics) 
 apply (rule vdm_basics) 
 apply (rule vdm_basics) 
 apply (rule vdm_basics) 
 apply (rule vdm_basics)
 apply clarsimp
 apply (case_tac "h'<af\<bullet>y> < E'\<lfloor>self:=Ref af\<rfloor><m:=h'<af\<bullet>x>><n:=h'<af\<bullet>y>><m>")
   apply clarsimp
   apply (insert vardistinct)
   apply clarsimp
   apply (rule_tac x="af" in exI)
   apply (simp, arith)+
   (* .. *)
   apply (rule_tac x="af" in exI)
   apply (simp, arith)+
 (* case C \<noteq> SwapClass remains ... *)
oops
--*)

(*--
(* version with finclasses variant; same lemma,; uses all_classes and different rule  *)
lemma (in swap_example) 
   "\<rhd> ((MH_Invoke f swap) :: 'a expr) :
    {(E,h,hh,v,p). \<exists> a . (E\<lfloor>f\<rfloor> = Ref a \<and> fmap_lookup (oheap h) a = Some SwapClass \<longrightarrow> hh<a\<bullet>x> = min (h<a\<bullet>x>) (h<a\<bullet>y>) \<and> hh<a\<bullet>y> = max (h<a\<bullet>x>) (h<a\<bullet>y>))}"
apply (rule vdm_mhinvoke_finclass)
apply (simp add: qach_QaQ_def allclasses)
apply (rule allI)+
apply (rule impI)
apply (erule_tac conjE)
apply (erule_tac x="C" in allE)
(* apply (case_tac "C=SwapClass") *)
 apply (simp add: swapbody)
 apply clarsimp
 apply (rule vdm_conseq)
 apply (rule vdm_basics) defer 1
 apply (rule vdm_basics) defer 1
 apply (rule vdm_basics) defer 1
 apply (rule vdm_basics) 
 apply (rule vdm_basics) defer 1
 apply (rule vdm_basics) defer 1
 apply (rule vdm_basics)
 apply (rule vdm_basics) 
 defer 1 
 apply (rule vdm_basics) 
 apply (rule vdm_basics) 
 apply (rule vdm_basics) 
 apply (rule vdm_basics) 
 apply (rule vdm_basics)
 apply clarsimp
 apply (case_tac "h'<af\<bullet>y> < E'\<lfloor>self:=Ref af\<rfloor><m:=h'<af\<bullet>x>><n:=h'<af\<bullet>y>><m>")
   apply clarsimp
   apply (insert vardistinct)
   apply clarsimp
   apply (rule_tac x="af" in exI)
   apply (simp, arith)+
   (* .. *)
   apply (rule_tac x="af" in exI)
   apply (simp, arith)+
done
--*)

subsection {* Version w/ InvokeStatic and adaptation *}

locale swap_example2 =
  fixes    m  	     :: iname
  fixes	   n  	     :: iname
  fixes	   q  	     :: iname
  fixes	   x  	     :: ifldname
  fixes	   y  	     :: ifldname
  fixes	   swap      :: mname
  fixes    SwapClass :: cname
  fixes	   r  	     :: rname
  fixes    f         :: rname
  assumes swapbody[simp]: 
  "methtable SwapClass swap =  
     ((LET 
      m  = self\<bullet>x ;
      n  = self\<bullet>y ;
      q  = n :< m
     IN
      IF q 
        THEN LET
               _ = self\<bullet>x := n ; 
               _ = self\<bullet>y := m 
      IN
         1\<^sup>z
      END 
         ELSE 0\<^sup>z
     END) :: 'a expr)"
  assumes  allclasses: "all_classes = {SwapClass}"
  assumes  vardistinct: "distinct [m,n,q] \<and> distinct [r,f]"
  assumes  flddistinct: "distinct [x,y]"

(* trivial, doesn't need adaptation *)
lemma (in swap_example2) 
   "\<rhd> ((InvokeStatic SwapClass swap r) :: 'a expr) :
    {(E,h,hh,v,p). \<exists> a . (E\<lfloor>r\<rfloor> = Ref a \<longrightarrow> hh<a\<bullet>x> = min (h<a\<bullet>x>) (h<a\<bullet>y>) \<and> hh<a\<bullet>y> = max (h<a\<bullet>x>) (h<a\<bullet>y>))}"
apply (rule vdm_invokestatic)
apply (simp)
apply (rule vdm_conseq)
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) 
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) 
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) 
apply (rule vdm_basics) 
apply (rule vdm_basics) 
apply (rule vdm_basics)
apply (rule vdm_basics)
apply clarsimp
done

lemma (in swap_example2) 
   "{(((InvokeStatic SwapClass swap r) :: 'a expr),
    {(E,h,hh,v,p). \<exists> a . (E\<lfloor>r\<rfloor> = Ref a \<longrightarrow> hh<a\<bullet>x> = min (h<a\<bullet>x>) (h<a\<bullet>y>) \<and> hh<a\<bullet>y> = max (h<a\<bullet>x>) (h<a\<bullet>y>))})}
    \<rhd> ((InvokeStatic SwapClass swap f) :: 'a expr) :
           {(E,h,hh,v,p). \<exists> a . (E\<lfloor>f\<rfloor> = Ref a \<longrightarrow> hh<a\<bullet>x> = min (h<a\<bullet>x>) (h<a\<bullet>y>) \<and> hh<a\<bullet>y> = max (h<a\<bullet>x>) (h<a\<bullet>y>))}"
apply (rule vdm_conseq)
apply (rule adapt_invokestatic)
apply (rule vdm_ax)
apply clarsimp
apply (rule conjI)
apply (insert vardistinct)
apply (unfold not_free_in_assn_def subst_def)
apply fast
apply blast
apply (rule allI)+
apply clarsimp
apply clarsimp
done


(*
apply (rename_tac E hi hpost v a p)
apply (rule_tac x="a" in exI)
apply clarsimp
apply (case_tac "hi<a\<bullet>y> < E<m:=hi<a\<bullet>x>><n:=hi<a\<bullet>y>><m>") (* do the swap *)
 apply (insert vardistinct)
 apply clarsimp
 apply (rule conjI)
 apply arith
 apply arith
 (* .. *)
 apply (rule conjI)
 apply (simp, arith)+
done
*)


end
