(* 				 
   File:	$RCSfile: Adapt.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: Adapt.thy,v 1.1 2003/12/05 15:19:17 a1hloidl Exp $

   Adaptation rules for calls and invokes.
*)

theory Adapt = VDMaux:

(* header {* Adaption rules and other beasts *} *)

section {* Definitions *}

subsection {* Substitutions on assertions *}

text {* 
Substitutions on assertions are needed to adapt assertions in context to the body
when we meet a recursive call. Since we use a shallow embedding of assertions, all
we have to do is to modify the environment to take the substituter instead of the
substitee. Since we only need this to substitute argument for formal parameter,
we only have to define the case of substituting rname for rname.
*}

constdefs subst :: "vdmassn \<Rightarrow> rname \<Rightarrow> rname \<Rightarrow> vdmassn"
"subst P y x \<equiv> {(E,h,hh,v,p). (E\<lfloor>x := E\<lfloor>y\<rfloor>\<rfloor>,h,hh,v,p) \<in> P}"

constdefs nuke :: "rname \<Rightarrow> vdmassn \<Rightarrow> vdmassn"
"nuke y P \<equiv> {(E,h,hh,v,p). (E\<lfloor>y := Nullref\<rfloor>,h,hh,v,p) \<in> P}"

constdefs not_free_in_assn :: "rname \<Rightarrow> vdmassn \<Rightarrow> bool"
"not_free_in_assn y Q \<equiv> \<forall> r E h hh v p. (E,h,hh,v,p) \<in> Q \<longrightarrow> (E\<lfloor>y:=r\<rfloor>,h,hh,v,p) \<in> Q"

lemmas petaQ_lemmas = subst_def nuke_def not_free_in_assn_def

(* HOAS stuff *)

constdefs ho_unfree :: "rname \<Rightarrow> (rname \<Rightarrow> vdmassn) \<Rightarrow> bool"
 "ho_unfree y Q \<equiv> \<forall> (z::rname). Q z = Q y"

section {* Main stuff *}

lemma bonzo_: "\<lbrakk> G \<Turnstile> e : P cn ; ho_unfree cn' P \<rbrakk> \<Longrightarrow> G \<Turnstile> e : P cn'"
apply (unfold vdm_valid_in_ctxt_def)
apply (rule impI)
apply (frule mp) apply (assumption) apply (erule thin_rl) apply (rotate_tac 1) apply (erule thin_rl) 
apply (unfold ho_unfree_def)
apply (unfold vdm_valid_def)
apply (clarify)
apply (rotate_tac 1)
apply (erule_tac x="cn" in allE)
apply clarsimp
done

(*
lemma bonzo_1712: "E \<turnstile> h , cn\<bullet>mn(pn) \<Down> hh , v , p \<Longrightarrow> E\<lfloor>pn':=E\<lfloor>pn\<rfloor>\<rfloor> \<turnstile> h , cn\<bullet>mn(pn') \<Down> hh , v , p"
sorry
*)

(*
lemma "\<lbrakk> (E,h,hh,v,p) \<in> Q ; not_free_in_assn y Q ; x ~= y\<rbrakk> \<Longrightarrow> (E\<lfloor>y:=E\<lfloor>x\<rfloor>\<rfloor>,h,hh,v,p) \<in> subst Q y x"
apply (unfold subst_def)
apply clarify
apply (subgoal_tac "E=E\<lfloor>y:=E\<lfloor>x\<rfloor>\<rfloor>\<lfloor>x:=E\<lfloor>y:=E\<lfloor>x\<rfloor>\<rfloor>\<lfloor>y\<rfloor>\<rfloor>")
 apply clarsimp
 (* ..*) 
 apply (rule E_ext)
 apply clarsimp
 apply (unfold not_free_in_assn_def)
 apply clarsimp
sorry
*)

subsection {* Semantic Adaptation *}

text {*
This part contains a general adaptation rule based on the "semantic" versions of
substitution and free-ness. Specialised versions for InvokeStatic etc are given.
No syntactic substitution is used at the moment.
*}

text {*
auxiliary lemmas needed in the main lemma:  adapt_invokestatic
*}

text {* unproven lemmas; all trivial but needed due to Isabelle silliness *}

lemma FUCK_1: "Semantics.renv.clock \<langle> a b c d \<rangle> = a"
sorry
lemma FUCK_2: "Semantics.renv.callc \<langle> a b c d \<rangle> = b"
sorry
lemma FUCK_3: "Semantics.renv.invkc \<langle> a b c d \<rangle> = c"
sorry
lemma FUCK_4: "Semantics.renv.invkdpth \<langle> a b c d \<rangle> = d"
sorry
lemma FUCK_99: "newframe_env Nullref E\<lfloor>pn'\<rfloor> \<turnstile> h , methtable cn mn \<Down>na (hh , v , pa) \<Longrightarrow>
                newframe_env Nullref E\<lfloor>pn'\<rfloor> \<turnstile> h , methtable cn mn \<Down>na (hh , v , pa)"
sorry

(*
lemma bonzo_aux_1: "E \<turnstile> h , cn\<bullet>mn(pn') \<Down> hh , v , p \<Longrightarrow> E\<lfloor>pn:=E\<lfloor>pn'\<rfloor>\<rfloor> \<turnstile> h , cn\<bullet>mn(pn) \<Down> hh , v , p"
sorry
*)

lemma bonzo_aux_01: "(\<forall> E h cn mn pn' hh v p pn. E \<turnstile> h , cn\<bullet>mn(pn') \<Down> hh , v , p \<longrightarrow> E\<lfloor>pn:=E\<lfloor>pn'\<rfloor>\<rfloor> \<turnstile> h , cn\<bullet>mn(pn) \<Down> hh , v , p)"
apply (rule allI)+
apply (rule impI)
apply (unfold sem_def)
(* interesting case *)
apply (erule exE)
apply (rule_tac x="n" in exI)
apply (erule eval_cases)
apply (subgoal_tac "newframe_env Nullref E\<lfloor>pn'\<rfloor> = newframe_env Nullref E\<lfloor>pn:=E\<lfloor>pn'\<rfloor>\<rfloor>\<lfloor>pn\<rfloor>")
 defer 1
 apply clarsimp
 (* .. *)
 apply (subgoal_tac "(\<exists> n' hh' v' p' . E\<lfloor>pn:=E\<lfloor>pn'\<rfloor>\<rfloor> \<turnstile> h , cn\<bullet>mn(pn) \<Down>n' (hh' , v' , p') \<and> n'=n \<and> hh'=hh \<and> v'=v \<and> p'=p)") 
  defer 1
  apply clarify
  apply (rule exI)  apply (rule exI)  apply (rule exI)  apply (rule exI)
  apply (rule conjI)
  apply (rule semInvokeStatic)
  apply (subgoal_tac "newframe_env Nullref E\<lfloor>pn:=E\<lfloor>pn'\<rfloor>\<rfloor>\<lfloor>pn\<rfloor> \<turnstile> h , methtable cn mn \<Down>na (hh , v , pa)")
   apply assumption
   (* .. *)
   defer 1
  apply (rule  conjI) defer 1  apply (rule  conjI) defer 1  apply (rule  conjI) defer 1
  defer 1
  apply (rotate_tac -1)
  apply (erule exE)  apply (erule exE)  apply (erule exE)  apply (erule exE)
  apply (rotate_tac -1) apply (erule conjE)
  apply (rotate_tac -1) apply (erule conjE)
  apply (rotate_tac -1) apply (erule conjE)
  apply (rotate_tac -1) apply (erule conjE)
  apply fast
 defer 1
 apply arith
 apply fast
 apply fast
 defer 1
 apply (rotate_tac -1)
 apply (frule sym)
 apply (erule thin_rl)
 apply clarsimp
 (*apply assumption*) (* AHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH *)
 defer 1
 (* apply (unfold renv_plus_def) *)
 apply (subgoal_tac "3 = renv.clock \<langle>3 0 1 1\<rangle>")
 apply (subgoal_tac "0 = callc \<langle>3 0 1 1\<rangle>")
 apply (subgoal_tac "1 = invkc \<langle>3 0 1 1\<rangle>")
 apply (subgoal_tac "1 = invkdpth \<langle>3 0 1 1\<rangle>")
 defer 1 apply (simp only: FUCK_4) apply (simp only: FUCK_3) apply (simp only: FUCK_2) apply (simp only: FUCK_1) 
 defer 1
 apply (unfold renv_plus_def)
 apply safe
 apply (simp only: FUCK_1) apply (simp only: FUCK_2) apply (simp only: FUCK_3) apply (simp only: FUCK_4) 
 apply (simp only: FUCK_99)
done

(* MAIN LEMMA *)
lemma adapt_invokestatic_sem: 
  "\<lbrakk> G \<Turnstile> InvokeStatic cn mn pn : Q ; not_free_in_assn  pn' Q  \<rbrakk> \<Longrightarrow> 
   G \<Turnstile> InvokeStatic cn mn pn' : subst Q pn' pn"
apply (unfold vdm_valid_in_ctxt_def)
apply (rule impI)
apply (frule mp) apply (assumption) apply (erule thin_rl) apply (rotate_tac 1) apply (erule thin_rl)
apply (unfold not_free_in_assn_def)
apply (unfold subst_def)
apply (unfold vdm_valid_def)
apply (clarify)
apply (rotate_tac -1)
apply (insert bonzo_aux_01)
apply (rotate_tac -1)
apply (erule_tac x="E" in allE, rotate_tac -1)
apply (erule_tac x="h" in allE, rotate_tac -1)
apply (erule_tac x="cn" in allE, rotate_tac -1)
apply (erule_tac x="mn" in allE, rotate_tac -1)
apply (erule_tac x="pn'" in allE, rotate_tac -1)
apply (erule_tac x="hh" in allE, rotate_tac -1)
apply (erule_tac x="v" in allE, rotate_tac -1)
apply (erule_tac x="p" in allE, rotate_tac -1)
apply (erule_tac x="pn" in allE, rotate_tac -1)
apply (frule mp) apply assumption apply (erule thin_rl) 
apply (rotate_tac 1)
apply (erule_tac x="E\<lfloor>pn:=E\<lfloor>pn'\<rfloor>\<rfloor>" in allE, rotate_tac -1)
apply (erule_tac x="h" in allE, rotate_tac -1)
apply (erule_tac x="hh" in allE, rotate_tac -1)
apply (erule_tac x="v" in allE, rotate_tac -1)
apply (erule_tac x="p" in allE, rotate_tac -1)
apply (frule mp) apply assumption apply (erule thin_rl) apply (erule thin_rl)
apply assumption
done

text {*
Proof idea for this admissible rule:
\begin{itemize}
 \item use soundness to get from $\rhd$ to $\vdash$ version
 \item use \texttt{adapt\_invokestatic\_sem} to get from derive $\vdash$ version of succedent;
 \item use completeness to get from the $\vdash$ to the $\rhd$ version
\end{itemize}
*}

theorem vdm_sound_ctxt: "(G \<rhd> e:P) \<Longrightarrow> (G \<Turnstile> e:P)"
(* see VDMSoundRec5.thy for the real proof *)
sorry

theorem vdm_complete: "(* \<lbrakk>strongSpec strongContext; finite strongContext\<rbrakk> \<Longrightarrow> *) 
 G \<Turnstile> e : P \<Longrightarrow> G \<rhd> e : P"
(* see VDMComplete5.thy for real proof *)
sorry

lemma adapt_invokestatic: 
  "\<lbrakk> G \<rhd> InvokeStatic cn mn pn : Q ; not_free_in_assn  pn' Q  \<rbrakk> \<Longrightarrow> 
   G \<rhd> InvokeStatic cn mn pn' : subst Q pn' pn"
apply (frule vdm_sound_ctxt [of "G" "InvokeStatic cn mn pn" "Q"])
apply (erule thin_rl)
apply (rotate_tac 1)
apply (frule adapt_invokestatic_sem [of "G" "cn" "mn" "pn" "Q" "pn'"])
apply assumption
apply (erule thin_rl) apply (erule thin_rl)
apply (frule vdm_complete [of "G" "InvokeStatic cn mn pn'" "subst Q pn' pn"])
apply assumption
done

(*
apply (rotate_tac -2)
apply (erule eval_cases)
apply (erule_tac x="E\<lfloor>pn:=E\<lfloor>pn'\<rfloor>\<rfloor>" in allE, rotate_tac -1)apply (erule_tac x="h" in allE, rotate_tac -1)
apply (erule_tac x="hh" in allE, rotate_tac -1)
apply (erule_tac x="v" in allE, rotate_tac -1)
apply (erule_tac x="p" in allE, rotate_tac -1)
apply (frule mp) apply assumption apply (erule thin_rl)
apply (rotate_tac -1)
apply (frule mp) apply assumption 
apply assumption 
done
*)
(*
apply (frule bonzo_aux_1 [of E])
apply clarsimp
apply (subgoal_tac "E\<lfloor>pn:=E\<lfloor>pn'\<rfloor>\<rfloor> \<turnstile> h , cn\<bullet>mn(pn) \<Down> hh , v , p")
 apply (erule_tac x="E\<lfloor>pn:=E\<lfloor>pn'\<rfloor>\<rfloor>" in allE)
 apply (erule_tac x="h" in allE)
 apply (erule_tac x="hh" in allE)
 apply (erule_tac x="v" in allE)
 apply (erule_tac x="p" in allE)
 apply (frule mp)  apply (assumption) apply (rotate_tac -2) apply (erule thin_rl)
 apply (subgoal_tac "(E\<lfloor>pn:=E\<lfloor>pn'\<rfloor>\<rfloor>, h, hh, v, p) \<in> Q pn \<Longrightarrow> (E, h, hh, v, p) \<in> Q pn'")
  apply clarsimp
  (* .. *)
(* only the 2 subgoals left *)
oops
*)
(*
apply (tactic {* all_tac *})
 (* should be provable via this *)
 apply (frule  bonzo_1712) 
apply (rule eval_cases)
apply (insert bonzo_1712)
apply clarsimp
apply (rotate_tac -1)
apply (subgoal_tac "E \<turnstile> h , cn\<bullet>mn(pn') \<Down> hh , v , p")
 apply (rule eval_cases)
apply (erule_tac x="E" in allE)
apply (erule_tac x="h" in allE)
apply (erule_tac x="hh" in allE)
apply (erule_tac x="v" in allE)
apply (erule_tac x="p" in allE)
apply (rule semn.induct)
defer 1
apply clarsimp
apply (rotate_tac 1)
apply (erule_tac x="cn" in allE)
apply clarsimp
oops
*)

(* --------------------------------------------------------------------------- *)
(*--
subsection {* HOAS approach *}

text {* 
Experimentation with HOAS formulations of the above.
All lemmas here need the non-freeness side condition. 
*}


(* probably needs precondition: pn not free assertion Q *)
(*
lemma bonzo_aux_2: "(E\<lfloor>pn:=E\<lfloor>pn'\<rfloor>\<rfloor>, h, hh, v, p) \<in> Q pn  \<Longrightarrow> (E, h, hh, v, p) \<in> Q pn'"
sorry
*)

subsubsection {* Lemmas *}

lemma bonzo_aux_02: "(\<forall> Q E h cn mn pn' hh v p pn. (E\<lfloor>pn:=E\<lfloor>pn'\<rfloor>\<rfloor>, h, hh, v, p) \<in> Q pn  \<longrightarrow> (E, h, hh, v, p) \<in> Q pn')"
apply (rule allI)+
apply (rule impI)
sorry

lemma bonzo_aux_002: "(\<forall> Q E h cn mn pn' hh v p pn. (E\<lfloor>pn:=E\<lfloor>pn'\<rfloor>\<rfloor>, h, hh, v, p) \<in> Q  \<longrightarrow> (E, h, hh, v, p) \<in> Q)"
sorry

lemma bonzo_1702: "\<lbrakk> G \<Turnstile> InvokeStatic cn mn pn : Q pn\<rbrakk> \<Longrightarrow> 
                   G \<Turnstile> InvokeStatic cn mn pn' : Q pn'"
apply (unfold vdm_valid_in_ctxt_def)
apply (rule impI)
apply (frule mp) apply (assumption) apply (erule thin_rl) apply (erule thin_rl)
(* apply (unfold ho_unfree_def) *)
apply (unfold vdm_valid_def)
apply (clarify)
apply (rotate_tac -1)
(* apply (insert bonzo_aux_1) *)
apply (subgoal_tac "E\<lfloor>pn:=E\<lfloor>pn'\<rfloor>\<rfloor> \<turnstile> h , cn\<bullet>mn(pn) \<Down> hh , v , p")
 apply (erule_tac x="E\<lfloor>pn:=E\<lfloor>pn'\<rfloor>\<rfloor>" in allE)
 apply (erule_tac x="h" in allE)
 apply (erule_tac x="hh" in allE)
 apply (erule_tac x="v" in allE)
 apply (erule_tac x="p" in allE)
 apply (frule mp)  apply (assumption) apply (rotate_tac -2) apply (erule thin_rl)
 apply (subgoal_tac "(E\<lfloor>pn:=E\<lfloor>pn'\<rfloor>\<rfloor>, h, hh, v, p) \<in> Q pn \<Longrightarrow> (E, h, hh, v, p) \<in> Q pn'")
  apply clarsimp
  (* .. *)
(* only the 2 subgoals left *)
oops

(* same as above but using lemmas rather than subgoals *)
lemma bonzo_1703: "\<lbrakk> G \<Turnstile> InvokeStatic cn mn pn : Q pn  \<rbrakk> \<Longrightarrow> 
                   G \<Turnstile> InvokeStatic cn mn pn' : Q pn'"
apply (unfold vdm_valid_in_ctxt_def)
apply (rule impI)
apply (frule mp) apply (assumption) apply (erule thin_rl) apply (erule thin_rl)
(* apply (unfold ho_unfree_def)*)
apply (unfold vdm_valid_def)
apply (clarify)
apply (rotate_tac -1)
apply (insert bonzo_aux_01)
apply (rotate_tac -1)
apply (erule_tac x="E" in allE, rotate_tac -1)
apply (erule_tac x="h" in allE, rotate_tac -1)
apply (erule_tac x="cn" in allE, rotate_tac -1)
apply (erule_tac x="mn" in allE, rotate_tac -1)
apply (erule_tac x="pn'" in allE, rotate_tac -1)
apply (erule_tac x="hh" in allE, rotate_tac -1)
apply (erule_tac x="v" in allE, rotate_tac -1)
apply (erule_tac x="p" in allE, rotate_tac -1)
apply (erule_tac x="pn" in allE, rotate_tac -1)
apply (frule mp) apply assumption apply (erule thin_rl) 
apply (insert bonzo_aux_02)
apply (rotate_tac -1)
apply (erule_tac x="Q" in allE, rotate_tac -1)
apply (erule_tac x="E" in allE, rotate_tac -1)
apply (erule_tac x="h" in allE, rotate_tac -1)
apply (erule_tac x="cn" in allE, rotate_tac -1)
apply (erule_tac x="mn" in allE, rotate_tac -1)
apply (erule_tac x="pn'" in allE, rotate_tac -1)
apply (erule_tac x="hh" in allE, rotate_tac -1)
apply (erule_tac x="v" in allE, rotate_tac -1)
apply (erule_tac x="p" in allE, rotate_tac -1)
apply (erule_tac x="pn" in allE, rotate_tac -1)
apply (rotate_tac -3)
apply (erule_tac x="E\<lfloor>pn:=E\<lfloor>pn'\<rfloor>\<rfloor>" in allE, rotate_tac -1)apply (erule_tac x="h" in allE, rotate_tac -1)
apply (erule_tac x="hh" in allE, rotate_tac -1)
apply (erule_tac x="v" in allE, rotate_tac -1)
apply (erule_tac x="p" in allE, rotate_tac -1)
apply (frule mp) apply assumption apply (erule thin_rl)
apply (rotate_tac -1)
apply (frule mp) apply assumption 
apply assumption 
done

lemma bonzo_1721: 
     "\<lbrakk>G \<rhd> InvokeStatic cn mn pn : Q pn ; ho_unfree pn' Q \<rbrakk> \<Longrightarrow>  
      G \<Turnstile> InvokeStatic cn mn pn' : Q pn'"
(* apply (rule allI)+ *)
apply (insert vdm_sound_ctxt [of "G" "InvokeStatic cn mn pn" "Q pn"])
apply clarsimp
apply (frule bonzo_ [of "G" "InvokeStatic cn mn pn" "Q" "pn" "pn'"])
apply assumption
oops

(* --------------------------------------------------------------------------- *)

subsection {* Syntactic subsitution etc *}

text {* this bit defines syntactic substitution and generalises some of the lemmas
above; I don't think we need that generality *}

subsubsection {* Substitution function etc *}

consts synt_subst :: "'a expr \<Rightarrow> rname \<Rightarrow> rname  \<Rightarrow> 'a expr"
primrec
"synt_subst (expr.Int i) y' x'    = (expr.Int i)"
"synt_subst (IVar x) y' x'        = (IVar x)"
"synt_subst (Primop f x y) y' x'  = (Primop f x y)"
"synt_subst (expr.Null) y' x'     = (expr.Null)"
"synt_subst (RPrimop f x y) y' x' = (if (x=x') 
                                      then (if (y=x') then (RPrimop f y' y') else (RPrimop f y' y)) 
                                      else (if (y=x') then (RPrimop f x y') else (RPrimop f x y)))"
"synt_subst (RVar x) y' x'        = (if (x=x') then (RVar y') else (RVar x))"
"synt_subst (New C ifldvals rfldvals) y' x' = (New C ifldvals rfldvals)"
"synt_subst (GetFi x f) y' x'     = (if (x=x') then (GetFi y' f) else (GetFi x f))" 
"synt_subst (GetFr x f) y' x'     = (if (x=x') then (GetFr y' f) else (GetFr x f))" 
"synt_subst (PutFi x f y) y' x'   = (if (x=x') then (PutFi y' f y) else (PutFi x f y))" 
"synt_subst (PutFr x f y) y' x'   = (if (x=x') 
                                       then (if (y=x') then (PutFr y' f y') else (PutFr y' f y)) 
                                       else (if (y=x') then (PutFr x f y') else (PutFr x f y)))" 
"synt_subst (Invoke x m y) y' x'  = (if (x=x') 
                                       then (if (y=x') then (Invoke y' m y') else (Invoke y' m y)) 
                                       else (if (y=x') then (Invoke x m y') else (Invoke x m y)))" 
"synt_subst (InvokeStatic C m y) y' x' = (if (y=x') then (InvokeStatic C m y') else (InvokeStatic C m y))" 
"synt_subst (MH_Invoke x m) y' x' = (if (x=x') then (MH_Invoke y' m) else (MH_Invoke x m))" 
"synt_subst (MH_InvokeStatic C m) y' x' = (MH_InvokeStatic C m)"  
"synt_subst (Leti x e1 e2) y' x'  = (Leti x (synt_subst e1 y' x') (synt_subst e2 y' x'))" 
"synt_subst (Letr x e1 e2) y' x'  = (Letr x (synt_subst e1 y' x') (synt_subst e2 y' x'))" 
"synt_subst (Letv e1 e2) y' x'    = (Letv (synt_subst e1 y' x') (synt_subst e2 y' x'))" 
"synt_subst (Ifg x e1 e2) y' x'   = (Ifg x (synt_subst e1 y' x') (synt_subst e2 y' x'))"
"synt_subst (Call f) y' x'        = (Call f)"

consts BV :: "'a expr \<Rightarrow> rname list"
primrec
"BV (expr.Int i)    = []"
"BV (IVar x)        = []"
"BV (Primop f x y)  = []"
"BV (expr.Null)     = []"
"BV (RPrimop f x y) = []"
"BV (RVar x)        = []"
"BV (New C ifldvals rfldvals) = []"
"BV (GetFi x f)     = []"
"BV (GetFr x f)     = []"
"BV (PutFi x f y)   = []"
"BV (PutFr x f y)   = []"
"BV (Invoke x m y)  = []"
"BV (InvokeStatic C m y) = []"
"BV (MH_Invoke x m) = []"
"BV (MH_InvokeStatic C m) = []"
"BV (Leti x e1 e2)  = (BV e1) @ (BV e2)"
"BV (Letr x e1 e2)  = x # ((BV e1) @ (BV e2))"
"BV (Letv e1 e2)    = (BV e1) @ (BV e2)"
"BV (Ifg x e1 e2)   = (BV e1) @ (BV e2)"
"BV (Call f)        = []"

(*
consts FV :: "'a expr \<Rightarrow> rname list"
primrec
"FV (expr.Int i)    = []"
"FV (IVar x)        = []"
"FV (Primop f x y)  = []"
"FV (expr.Null)     = []"
"FV (RPrimop f x y) = [x,y]"
"FV (RVar x)        = [x]"
"FV (New C ifldvals rfldvals) = []"
"FV (GetFi x f)     = [x]"
"FV (GetFr x f)     = [x]"
"FV (PutFi x f y)   = [x]"
"FV (PutFr x f y)   = [x,y]"
"FV (Invoke x m y)  = [x,y]"
"FV (InvokeStatic C m y) = [y]"
"FV (MH_Invoke x m) = [x]"
"FV (MH_InvokeStatic C m) = []"
"FV (Leti x e1 e2)  = (FV e1) @ (FV e2)"
"FV (Letr x e1 e2)  = (FV e1) @ (FV e2)"
"FV (Letv e1 e2)    = (FV e1) @ (FV e2)"
"FV (Ifg x e1 e2)   = (FV e1) @ (FV e2)"
"FV (Call f)        = []"
*)

consts FRV :: "'a expr \<Rightarrow> rname list"
primrec
"FRV (expr.Int i)    = []"
"FRV (IVar x)        = []"
"FRV (Primop f x y)  = []"
"FRV (expr.Null)     = []"
"FRV (RPrimop f x y) = [x,y]"
"FRV (RVar x)        = [x]"
"FRV (New C ifldvals rfldvals) = []"
"FRV (GetFi x f)     = [x]"
"FRV (GetFr x f)     = [x]"
"FRV (PutFi x f y)   = [x]"
"FRV (PutFr x f y)   = [x,y]"
"FRV (Invoke x m y)  = [x,y]"
"FRV (InvokeStatic C m y) = [y]"
"FRV (MH_Invoke x m) = [x]"
"FRV (MH_InvokeStatic C m) = []"
"FRV (Leti x e1 e2)  = (FRV e1) @ (FRV e2)"
"FRV (Letr x e1 e2)  = (FRV e1) @ (FRV e2)"
"FRV (Letv e1 e2)    = (FRV e1) @ (FRV e2)"
"FRV (Ifg x e1 e2)   = (FRV e1) @ (FRV e2)"
"FRV (Call f)        = []"

consts FIV :: "'a expr \<Rightarrow> iname list"
primrec
"FIV (expr.Int i)    = []"
"FIV (IVar x)        = [x]"
"FIV (Primop f x y)  = [x,y]"
"FIV (expr.Null)     = []"
"FIV (RPrimop f x y) = []"
"FIV (RVar x)        = []"
"FIV (New C ifldvals rfldvals) = []"
"FIV (GetFi x f)     = []"
"FIV (GetFr x f)     = []"
"FIV (PutFi x f y)   = [y]"
"FIV (PutFr x f y)   = []"
"FIV (Invoke x m y)  = []"
"FIV (InvokeStatic C m y) = []"
"FIV (MH_Invoke x m) = []"
"FIV (MH_InvokeStatic C m) = []"
"FIV (Leti x e1 e2)  = (FIV e1) @ (FIV e2)"
"FIV (Letr x e1 e2)  = (FIV e1) @ (FIV e2)"
"FIV (Letv e1 e2)    = (FIV e1) @ (FIV e2)"
"FIV (Ifg x e1 e2)   = (FIV e1) @ (FIV e2)"
"FIV (Call f)        = []"

subsubsection {* Lemmas etc *}

lemma ssubstTriv: "\<forall> e x y. x \<notin> set (FV e) \<longrightarrow> synt_subst e y x = e"
apply (rule allI)+
apply (rule synt_subst.induct)
apply simp_all
done

lemma ssubstTriv0: "x \<notin> set (FV e) \<Longrightarrow> synt_subst e y x = e"
apply (insert ssubstTriv)
apply (erule_tac x="e" in allE)
apply (erule_tac x="x" in allE)
apply (erule_tac x="y" in allE)
apply (frule mp)
apply assumption
apply assumption
done

(* same lemmas for semantic substitution *)
lemma substTriv0: "not_free_in_assn x P \<Longrightarrow> subst P y x = P"
apply (simp add: not_free_in_assn_def subst_def)
apply (subgoal_tac "\<forall> E h hh v p . (E\<lfloor>x:=E\<lfloor>y\<rfloor>\<rfloor>, h, hh, v, p) \<in> P \<longrightarrow> (E, h, hh, v, p) \<in> P")
 apply blast
 (* -- *) 
 apply clarsimp
 apply (erule_tac x="x" in allE, rotate_tac -1)
 apply (erule_tac x="E\<lfloor>x:=E\<lfloor>y\<rfloor>\<rfloor>" in allE, rotate_tac -1)
 apply (erule_tac x="h" in allE, rotate_tac -1)
 apply (erule_tac x="hh" in allE, rotate_tac -1)
 apply (erule_tac x="v" in allE, rotate_tac -1)
 apply (erule_tac x="p" in allE, rotate_tac -1)
 apply (frule mp) apply assumption apply (erule thin_rl)
 apply (subgoal_tac "E\<lfloor>x:=E\<lfloor>y\<rfloor>\<rfloor>\<lfloor>x:=E\<lfloor>x:=E\<lfloor>y\<rfloor>\<rfloor>\<lfloor>x\<rfloor>\<rfloor> = E")
  apply clarsimp
  (* -- *)
apply (tactic {* all_tac *})
sorry

(* try to prove fused axiom,adaptation rule as a derived rule *)

lemma vdm_subst: 
      "(G \<rhd> e : P \<and> not_free_in_assn x P) 
       \<longrightarrow>
       G \<rhd> (synt_subst e y x) : (subst P y x)"
(* apply (simp add: subst_def) *)
apply (induct_tac e)
(* Int *)
apply (subgoal_tac "x \<notin> set (FV (expr.Int int))")
apply (frule ssubstTriv0) apply clarsimp
apply (subgoal_tac "subst P y x = P")
 apply clarsimp
 apply (rotate_tac -1)
 apply (frule substTriv0) apply (rotate_tac -1) apply simp
apply simp
(* IVar *)
apply (subgoal_tac "x \<notin> set (FV (IVar iname))")
apply (frule ssubstTriv0) apply clarsimp
apply (subgoal_tac "subst P y x = P")
 apply clarsimp
 apply (rotate_tac -1)
 apply (frule substTriv0) apply (rotate_tac -1) apply simp
apply simp

oops


(* --------------------------------------------------------------------------- *)

subsection {* Misc unused stuff *}

lemma cut:"\<lbrakk> G \<rhd> ee : P ; (insert (ee, P) G) \<rhd> e : Q \<rbrakk> \<Longrightarrow> G \<rhd> e : Q"
sorry (* VDMderived5 for the proof *)

lemma "G \<rhd> e : P \<longrightarrow> (\<forall> E h hh v p. E \<turnstile> h , e \<Down>m (hh , v , p) \<longrightarrow> (E,h,hh,v,p) \<in> P)"
sorry

lemma vdm_invokestatic_drved:
  "\<lbrakk> (G \<union> {(InvokeStatic C mn y,P)}) \<rhd> 
    (methtable C mn) :  
    {(E,h,hh,v,p) . \<forall> E'. E = newframe_env Nullref (E'\<lfloor>y\<rfloor>)  \<longrightarrow>
                    (E',h,hh,v,\<langle>3 0 1 1\<rangle> \<oplus> p) \<in> P} \<rbrakk> \<Longrightarrow>
   G \<rhd> (InvokeStatic C mn y) : P"
oops

lemma vdm_adapt_invokestatic: 
      "\<forall> pn pn' . (InvokeStatic cn mn pn', Q cn pn') \<in> G \<longrightarrow> G \<rhd> InvokeStatic cn mn pn : Q cn pn"
apply (rule vdm_proof.induct)
(* Int *)
prefer 3
apply (rule allI)+
apply (rule impI)
apply (rule vdm_ax)
sorry

lemma vdm_adapt_invoke: 
      "(\<forall> on' pn' . (insert (Invoke on' mn pn', Q on' pn') G) \<rhd> e : P) \<longrightarrow> (insert (Invoke on mn pn, Q on pn) G) \<rhd> e : P"
apply (rule vdm_proof.induct)
(* Int *)
sorry

lemma vdm_adapt_context0: 
      " \<lbrakk>(InvokeStatic CLONELIST clone l, Q) : G ;  (insert (InvokeStatic CLONELIST clone l', subst Q l' l) G) \<rhd> e : P \<rbrakk> 
        \<Longrightarrow>
       G \<rhd> e : P"
sorry
--*)
end