theory unused = Semantics:

constdefs geq :: "renv \<Rightarrow> renv \<Rightarrow> bool" (infixr "\<ge>" 0)
"geq p pp == (clock pp <= clock p) \<and> (callc pp <= callc p) \<and> 
             (invkc pp <= invkc p) \<and> (invkdpth pp <= invkdpth p)"

declare geq_def [simp add]

lemma CupMono1 [simp]: "(pp \<smile> p) \<ge>  pp"
by (simp add: max_def)

lemma CupMono2 [simp]: "(pp \<smile> p) \<ge>  p"
by (simp add: max_def)

lemma PlusMono1 [simp]: "(pp \<oplus> p) \<ge> pp"
by (simp add: max_def)

lemma PlusMono1 [simp]: "(pp \<oplus> p) \<ge> p"
by (simp add: max_def)

lemma GeqTrans: "(p \<ge> pp) \<and> (pp \<ge> ppp) \<longrightarrow> (p \<ge> ppp)"
by clarsimp

lemma "renv_plus (mkREnv 1 0 0 0) r = renv_cup (mkREnv 1 0 0 0) r"
by (simp add: renv_cup_def renv_plus_def mkREnv_def)

subsection {*Sanity checks: introduction and elimination lemmas*}
lemma semNullI: "E \<turnstile> h,(expr.Null) \<Down>1 (h,RVal Nullref, tickRo)"
by (rule semNull)

lemma semIntI: "E \<turnstile> h,(expr.Int i) \<Down>1 (h,IVal i, tickRo)"
by (rule semInt)

lemma semIVarI[simp]: "E \<turnstile> h,IVar v \<Down>1 (h,IVal (E<v>), tickRo)"
by (rule semIVar)

lemma semRVarI: "E \<turnstile> h,RVar v \<Down>1 (h,RVal (E\<lfloor>v\<rfloor>), tickRo)"
by (rule semRVar)

lemma semPrimopI: "E \<turnstile> h, (Primop f x y) \<Down>1 (h,IVal (f (E<x>) (E<y>)), (mkREnv 3 0 0 0))"
by (rule semPrimop)

lemma semRPrimopI: "E \<turnstile> h, (RPrimop f x y) \<Down>1 (h,IVal (f (E\<lfloor>x\<rfloor>) (E\<lfloor>y\<rfloor>)), (mkREnv 3 0 0 0))"
by (rule semRPrimop)

lemma semGetfiI: 
  "E\<lfloor>x\<rfloor> = Ref a \<Longrightarrow> E \<turnstile> h,(GetFi x f) \<Down>1 (h, IVal ((heap.iheap h) f a), mkREnv 2 0 0 0)"
by (rule semGetfi, simp)

lemma semGetfrI: 
  "E\<lfloor>x\<rfloor> = Ref a \<Longrightarrow> E \<turnstile> h,(GetFr x f) \<Down>1 (h, RVal ((heap.rheap h) f a), mkREnv 2 0 0 0)"
by (rule semGetfr, simp)

lemma semPutfiI: 
 "E\<lfloor>x\<rfloor> = Ref a \<Longrightarrow> 
  E \<turnstile> h, (PutFi x f y) \<Down>1
            (\<lparr>oheap = heap.oheap h, iheap = (heap.iheap h)(f := ((heap.iheap h) f)(a := E<y>)), rheap = heap.rheap h\<rparr>,
             arbitrary,
             mkREnv 3 0 0 0)"
by (rule semPutfi, simp)

lemma semPutfrI:  
 "E\<lfloor>x\<rfloor> = Ref a \<Longrightarrow> 
  E \<turnstile> h, (PutFr x f y) \<Down>1
            (\<lparr>oheap = heap.oheap h, iheap = heap.iheap h, rheap = (heap.rheap h)(f := ((heap.rheap h) f)(a := E\<lfloor>y\<rfloor>))\<rparr>,
             arbitrary,
             mkREnv 3 0 0 0)"
by (rule semPutfr, simp)

lemma semNewI: 
 "l = freshloc (fmap_dom (heap.oheap h)) \<Longrightarrow>
  E \<turnstile> h,(New c ifldvals rfldvals) \<Down>1 (newObj h l E c ifldvals rfldvals, RVal (Ref l), tickRo)"
by (rule semNew, simp)

lemma semIf_TrueI:
  "\<lbrakk>E<x> = grailbool True; E \<turnstile> h, e1 \<Down>m (h1,v,p)\<rbrakk> \<Longrightarrow>
   E \<turnstile> h, (Ifg x e1 e2) \<Down>(m + 1) (h1,v, (tkn 2 p))"
by (rule semIf_True)

lemma semIf_FalseI:
  "\<lbrakk>E<x> = grailbool False; E \<turnstile> h, e2 \<Down>m (h1,v,p)\<rbrakk> \<Longrightarrow>
   E \<turnstile> h, (Ifg x e1 e2) \<Down>(m + 1) (h1,v, (tkn 2 p))"
by (rule semIf_False)

lemma semLetiI:
 "\<lbrakk>E \<turnstile> h,e1 \<Down>n (h1,IVal i,p1);  E<x:=i> \<turnstile> h1, e2 \<Down>m (h2,v,p2)\<rbrakk> \<Longrightarrow>
  E \<turnstile> h, (Leti x e1 e2) \<Down>((max n m) + 1) (h2,v, tk (p1 \<smile> p2))"
by (rule semLeti)

lemma semLetrI: 
 "\<lbrakk>E \<turnstile> h,e1 \<Down>n (h1,RVal r,p1);  E\<lfloor>x:=r\<rfloor> \<turnstile> h1, e2 \<Down>m (h2,v,p2)\<rbrakk> \<Longrightarrow>
  E \<turnstile> h, (Letr x e1 e2) \<Down>((max n m) + 1) (h2,v, tk (p1 \<smile> p2))"
by (rule semLetr)

lemma semLetvI: 
"\<lbrakk>E \<turnstile> h,e1 \<Down>n (h1,w,p1);  E \<turnstile> h1, e2 \<Down>m (h2,v,p2)\<rbrakk> \<Longrightarrow>
 E \<turnstile> h, (Letv e1 e2) \<Down>(max n m) (h2,v, p1 \<smile> p2)"
by (rule semLetv)

lemma semCallI:
 "\<lbrakk>E \<turnstile> h, ((funtable f) ::'a expr) \<Down>n (h1,v,p)\<rbrakk> \<Longrightarrow>
  E \<turnstile> h,((Call f):: 'a expr) \<Down>(n+1) (h1, v, tkcall p)"
by (rule semCall, simp)

lemma semInvokeI:
 "\<lbrakk>E\<lfloor>x\<rfloor> = Ref a;  
   fmap_lookup (heap.oheap h) a = Some C; 
  (newframe_env (Ref a) (E\<lfloor>y\<rfloor>)) \<turnstile> h,((methtable C mn) ::'a expr) \<Down>n (h1,v,p)\<rbrakk> \<Longrightarrow>
  E \<turnstile> h, ((Invoke x mn y)::'a expr) \<Down>(n + 1) (h1,v,(mkREnv 5 0 1 1) \<oplus> p)"
by (rule semInvoke, simp)

lemma semInvokeStaticI:
 "\<lbrakk>(newframe_env Nullref (E\<lfloor>y\<rfloor>)) \<turnstile> h,((methtable C mn):: 'a expr) \<Down>n (h1,v,p)\<rbrakk> \<Longrightarrow>
  E \<turnstile> h, ((InvokeStatic C mn y):: 'a expr) \<Down>(n + 1) (h1,v, (mkREnv 3 0 1 1) \<oplus> p)"
by (rule semInvokeStatic, simp)

lemma semMHInvokeI:
 "\<lbrakk>E\<lfloor>x\<rfloor> = Ref a;
   fmap_lookup (heap.oheap h) a = Some C; 
   E\<lfloor>self := Ref a\<rfloor>  \<turnstile> h,((methtable C mn):: 'a expr) \<Down>n (h1,v,p)\<rbrakk> \<Longrightarrow>
   E \<turnstile> h, ((MH_Invoke x mn)::'a expr) \<Down>(n + 1) (h1,v,(mkREnv 4 0 1 1) \<oplus> p)"
by (rule semMHInvoke, simp+)

lemma semMHInvokeStaticI:
 "\<lbrakk>E \<turnstile> h,((methtable C mn):: 'a expr) \<Down>n (h1,v,p)\<rbrakk> \<Longrightarrow>
  E \<turnstile> h, ((MH_InvokeStatic C mn)::'a expr) \<Down>(n + 1) (h1,v, (mkREnv 2 0 1 1) \<oplus> p)"
by (rule semMHInvokeStatic, simp)

lemma semAnnI: "E \<turnstile> h,e \<Down>n (h1,v,p) \<Longrightarrow> E \<turnstile> h,(Ann A e) \<Down>(n+1) (h1,v,p)"
by (rule semAnn)

lemma semNullE: "E \<turnstile> h,(expr.Null) \<Down>n (hh,v,p) \<Longrightarrow> n=1 \<and> hh=h \<and> v=RVal Nullref \<and> p=tickRo"
by (erule semn.elims, simp_all)

lemma semIntE: "E \<turnstile> h,(expr.Int i) \<Down>n (hh,v,p) \<Longrightarrow> n=1 \<and> hh=h \<and> v=IVal i \<and> p=tickRo"
by (erule semn.elims, simp_all)

lemma  semIVarE:    "E \<turnstile> h,IVar x \<Down>n (hh,v,p) \<Longrightarrow> n=1 \<and> hh=h \<and> v=IVal (E<x>) \<and> p=tickRo"
by (erule semn.elims, simp_all)

lemma  semRVarE:    "E \<turnstile> h,RVar x \<Down>n (hh,v,p) \<Longrightarrow> n=1 \<and> hh=h \<and> v=RVal (E\<lfloor>x\<rfloor>) \<and> p=tickRo"
by (erule semn.elims, simp_all)

lemma  semPrimopE:  "E \<turnstile> h, (Primop f x y) \<Down>n (hh,v,p) \<Longrightarrow> n=1 \<and> hh=h \<and> v=IVal (f (E<x>) (E<y>)) \<and> p=mkREnv 3 0 0 0"
by (erule semn.elims, simp_all)

lemma  semRPrimopE:  "E \<turnstile> h, (RPrimop f x y) \<Down>n (hh,v,p) \<Longrightarrow> n=1 \<and> hh=h \<and>v=IVal (f (E\<lfloor>x\<rfloor>) (E\<lfloor>y\<rfloor>)) \<and> p=mkREnv 3 0 0 0"
by (erule semn.elims, simp_all)

lemma  semGetfiE: "E \<turnstile> h,(GetFi x f) \<Down>n (hh,v,p)
                 \<Longrightarrow> \<exists> a . (E\<lfloor>x\<rfloor> = Ref a \<and> n=1 \<and> hh=h \<and> v=IVal ((heap.iheap h) f a) \<and> p=mkREnv 2 0 0 0)"
by (erule semn.elims, simp_all)

lemma  semGetfrE: "E \<turnstile> h,(GetFr x f) \<Down>n (hh,v,p)
                 \<Longrightarrow> \<exists> a . (E\<lfloor>x\<rfloor> = Ref a \<and> n=1 \<and> hh=h \<and> v=RVal ((heap.rheap h) f a) \<and> p=mkREnv 2 0 0 0)"
by (erule semn.elims, simp_all)

lemma  semPutfiE: "E \<turnstile> h, (PutFi x f y) \<Down>n (hh,v,p)
                 \<Longrightarrow> \<exists> a .(E\<lfloor>x\<rfloor> = Ref a \<and> n=1 \<and> 
                           hh = \<lparr>oheap = heap.oheap h, 
                                 iheap = (heap.iheap h)(f := ((heap.iheap h) f)(a := E<y>)), 
                                 rheap = heap.rheap h\<rparr> \<and> 
                          v=arbitrary \<and> 
                          p=mkREnv 3 0 0 0)"
by (erule semn.elims, simp_all)

lemma  semPutfrE: "E \<turnstile> h, (PutFr x f y) \<Down>n (hh,v,p)
                 \<Longrightarrow> \<exists> a .(E\<lfloor>x\<rfloor> = Ref a \<and> n=1 \<and> 
                           hh = \<lparr>oheap = heap.oheap h,
                                 iheap = heap.iheap h, 
                                 rheap = (heap.rheap h)(f := ((heap.rheap h) f)(a := E\<lfloor>y\<rfloor>))\<rparr> \<and> 
                           v=arbitrary \<and> 
                           p=mkREnv 3 0 0 0)"
by (erule semn.elims, simp_all)

lemma  semNewE: "E \<turnstile> h,(New c ifldvals rfldvals) \<Down>n (hh,v,p)
               \<Longrightarrow> \<exists> l .(l = freshloc (fmap_dom (heap.oheap h)) \<and> n=1 \<and>
                         hh = (newObj h l E c ifldvals rfldvals) \<and>
                         v=RVal (Ref l) \<and> p=tickRo)"
by (erule semn.elims, simp_all)

lemma semIf_E:  "E \<turnstile> h, (Ifg x e1 e2) \<Down>n (hh,v,p)
                \<Longrightarrow> \<exists> m pp. (n = Suc m \<and>
                             ((E<x> = grailbool True \<and> E \<turnstile> h, e1 \<Down>m (hh,v,pp) \<and> p=(tkn 2 pp)) \<or> 
                              (E<x> = grailbool False \<and> E \<turnstile> h, e2 \<Down>m (hh,v,pp) \<and> p=(tkn 2 pp))))"
by (erule semn.elims, simp_all, fastsimp+)

lemma semLetiE: "E \<turnstile> h, (Leti x e1 e2) \<Down>n (hh,v,p)
                \<Longrightarrow> \<exists> m k h1 p1 p2 i. (n=(max k m) + 1 \<and>
                                       E \<turnstile> h,e1 \<Down>k (h1,IVal i,p1) \<and>
                                       E<x:=i> \<turnstile> h1, e2 \<Down>m (hh,v,p2) \<and>
                                       p= tk (p1 \<smile> p2))"
by (erule semn.elims, simp_all, fastsimp)

lemma  semLetrE: "E \<turnstile> h, (Letr x e1 e2) \<Down>n (hh,v,p)
                \<Longrightarrow> \<exists> m k h1 p1 p2 r. (n=(max k m) + 1 \<and>
                                       E \<turnstile> h,e1 \<Down>k (h1,RVal r,p1) \<and>
                                       E\<lfloor>x:=r\<rfloor> \<turnstile> h1, e2 \<Down>m (hh,v,p2) \<and>
                                       p=tk (p1 \<smile> p2))"
by (erule semn.elims, simp_all, fastsimp)

lemma  semLetvE: "E \<turnstile> h, (Letv e1 e2) \<Down>n (hh,v,p)
                \<Longrightarrow> \<exists> m k h1 p1 p2 w . (n=(max k m) + 1 \<and>
                                        E \<turnstile> h,e1 \<Down>k (h1,w,p1) \<and>
                                        E \<turnstile> h1, e2 \<Down>m (hh,v,p2) \<and>
                                        p=(p1 \<smile> p2))"
by (erule semn.elims, simp_all, fastsimp)

lemma  semCallE: "E \<turnstile> h,((Call f):: 'a expr) \<Down>n (hh,v,p)
                \<Longrightarrow> \<exists> m pp. (n = Suc m \<and>
                             E \<turnstile> h, ((funtable f)::'a expr) \<Down>m (hh,v,pp) \<and>
                             p=tkcall pp)"
by (erule semn.elims, simp_all, fastsimp)

lemma  semInvokeE: "E \<turnstile> h, ((Invoke x mn y):: 'a expr) \<Down>n (hh,v,p)
                  \<Longrightarrow> \<exists> m a C pp. ((n = Suc m) \<and>
                                   (E\<lfloor>x\<rfloor> = Ref a) \<and> 
                                   (fmap_lookup (heap.oheap h) a = Some C) \<and> 
                                   (newframe_env (Ref a) (E\<lfloor>y\<rfloor>)) \<turnstile> h,((methtable C mn)::'a expr) \<Down>m (hh,v,pp) \<and> 
                                   (p=((mkREnv 5 0 1 1) \<oplus> pp)))"
by (erule semn.elims, simp_all, fastsimp)

lemma  semInvokeStaticE: "E \<turnstile> h, ((InvokeStatic C mn y)::'a expr) \<Down>n (hh,v,p)
                        \<Longrightarrow> \<exists> m pp . ((n = Suc m) \<and>
                                      (newframe_env Nullref (E\<lfloor>y\<rfloor>)) \<turnstile> h,((methtable C mn)::'a expr) \<Down>m (hh,v,pp) \<and> 
                                      (p=((mkREnv 3 0 1 1) \<oplus> pp)))"
by (erule semn.elims, simp_all, fastsimp)

lemma  semMHInvokeE: "E \<turnstile> h, ((MH_Invoke x mn)::'a expr) \<Down>n (hh,v,p)
                    \<Longrightarrow> \<exists> a m pp C .((n = Suc m) \<and>
                                     (E\<lfloor>x\<rfloor> = Ref a) \<and> 
                                     fmap_lookup (heap.oheap h) a = Some C \<and> 
                                     E\<lfloor>self := Ref a\<rfloor>  \<turnstile> h,((methtable C mn)::'a expr) \<Down>m (hh,v,pp) \<and> 
                                     (p=((mkREnv 4 0 1 1) \<oplus> pp)))"
by (erule semn.elims, simp_all, fastsimp)

lemma  semMHInvokeStaticE: "E \<turnstile> h, ((MH_InvokeStatic C mn)::'a expr) \<Down>n (hh,v,p)
                          \<Longrightarrow> \<exists> m pp . ((n = Suc m) \<and> 
                                        E \<turnstile> h,((methtable C mn)::'a expr) \<Down>m (hh,v,pp) \<and> 
                                        (p=((mkREnv 2 0 1 1) \<oplus> pp)))"
by (erule semn.elims, simp_all, fastsimp)

lemma  semAnnE: "E \<turnstile> h,(Ann A e) \<Down>n (hh,v,p) \<Longrightarrow> \<exists> m . ((n = Suc m) \<and> E \<turnstile> h,e \<Down>m (hh,v,p))"
by (erule semn.elims, simp_all)


(* Prob not needed: 
section{*Operational semantics with limited invocation depth*}
consts
  MHIS  :: "(nat \<times> env \<times> heap \<times> 'a expr \<times> nat \<times> heap \<times> val \<times> renv) set"

syntax
 MHIS_  :: "[nat,env, heap, 'a expr, nat, heap, val, renv] \<Rightarrow> bool"   ("_,_ \<turnstile> _ , _ \<Down>_ '(_ , _ , _')")

translations
 "N,E \<turnstile> h,e \<Down>n (hh,v,p)" == "(N,E,h,e,n,hh,v,p) : MHIS"

inductive MHIS intros
 MHISNull:    "N, E \<turnstile> h,(expr.Null) \<Down>1 (h,RVal Nullref, mkREnv 1 0 0 0)"

 MHISInt:     "N,E \<turnstile> h,(expr.Int i) \<Down>1 (h,IVal i, mkREnv 1 0 0 0)"

 MHISIVar:    "N,E \<turnstile> h,IVar v \<Down>1 (h,IVal (E<v>), mkREnv 1 0 0 0)"

 MHISRVar:    "N,E \<turnstile> h,RVar v \<Down>1 (h,RVal (E\<lfloor>v\<rfloor>), mkREnv 1 0 0 0)"

 MHISPrimop:  "\<lbrakk>N,E \<turnstile> h, IVar x \<Down>n (h1,IVal i1,p1);
                N,E \<turnstile> h1, IVar y \<Down>m (h2,IVal i2,p2) \<rbrakk> \<Longrightarrow>
               N,E \<turnstile> h, (Primop f x y) \<Down>((max n m) + 1) (h2,IVal (f i1 i2),(mkREnv 1 0 0 0) \<smile> p1 \<smile> p2)"

 MHISRPrimop:  "\<lbrakk>N,E \<turnstile> h, RVar x \<Down>n (h1,RVal r1,p1); 
                 N,E \<turnstile> h1, RVar y \<Down>m (h2,RVal r2,p2) \<rbrakk> \<Longrightarrow>
                N,E \<turnstile> h, (RPrimop f x y) \<Down>((max n m) + 1) (h2,IVal (f r1 r2), (mkREnv 1 0 0 0) \<smile> p1 \<smile> p2)"

 MHISGetfi: "\<lbrakk>N,E \<turnstile> h, RVar x \<Down>n (h1, RVal(Ref a),p)\<rbrakk> \<Longrightarrow>
             N,E \<turnstile> h,(GetFi x f) \<Down>(n + 1) (h1, IVal ((heap.iheap h1) f a), (mkREnv 1 0 0 0) \<smile> p)"

 MHISGetfr: "\<lbrakk>N,E \<turnstile> h, RVar x \<Down>n (h1, RVal(Ref a),p)\<rbrakk> \<Longrightarrow>
             N,E \<turnstile> h,(GetFr x f) \<Down>(n + 1) (h1, RVal ((heap.rheap h1) f a), (mkREnv 1 0 0 0) \<smile> p)"

 MHISPutfi: "\<lbrakk>N,E \<turnstile> h, RVar x \<Down>n (h1,RVal (Ref a),p1) ; 
              N,E \<turnstile> h1, IVar y \<Down>m (\<lparr>oheap = oh, iheap = ih, rheap = rh\<rparr>,IVal i,p2) \<rbrakk> \<Longrightarrow>
             N,E \<turnstile> h, (PutFi x f y) \<Down>((max n m) + 1)
                   (\<lparr>oheap = oh, iheap = ih(f := (ih f)(a := i)), rheap = rh\<rparr>,
                  arbitrary,
                  (mkREnv 1 0 0 0) \<smile> p1 \<smile> p2)"

 MHISPutfr: "\<lbrakk>N,E \<turnstile> h, RVar x \<Down>n (h1,RVal (Ref a),p1) ; 
              N,E \<turnstile> h1, RVar y \<Down>m (\<lparr>oheap = oh, iheap = ih, rheap = rh\<rparr>,RVal r,p2) \<rbrakk> \<Longrightarrow>
             N,E \<turnstile> h, (PutFr x f y) \<Down>((max n m) + 1)
                  (\<lparr>oheap = oh, iheap = ih, rheap = rh(f := (rh f)(a := r))\<rparr>,
                  arbitrary,
                  (mkREnv 1 0 0 0) \<smile> p1 \<smile> p2)"

 MHISNew: "\<lbrakk> l = freshloc (fmap_dom (heap.oheap h)) ;
            h1 = \<lparr>oheap = (heap.oheap h)(l \<mapsto>\<^sub>f c),
                  iheap = iheapflds ifldvals l (heap.iheap h) (ienv E),
                  rheap = rheapflds rfldvals l (heap.rheap h) (renv E)\<rparr>\<rbrakk> \<Longrightarrow>
           N,E \<turnstile> h,(New c ifldvals rfldvals) \<Down>1 (h1, RVal (Ref l), mkREnv 1 0 0 0)"

 MHISIf_True:  "\<lbrakk>N,E \<turnstile> h, IVar x \<Down>n (h1,IVal (grailbool True),p1);  
                 N,E \<turnstile> h1, e1 \<Down>m (h2,v,p2)\<rbrakk> \<Longrightarrow>
                N,E \<turnstile> h, (Ifg x e1 e2) \<Down>((max n m) + 1) (h2,v, (mkREnv 1 0 0 0) \<smile> p1 \<smile> p2)"

 MHISIf_False:  "\<lbrakk>N,E \<turnstile> h, IVar x \<Down>n (h1,IVal (grailbool False),p1);
                  N,E \<turnstile> h1, e2 \<Down>m (h2,v,p2)\<rbrakk> \<Longrightarrow>
                 N,E \<turnstile> h, (Ifg x e1 e2) \<Down>((max n m) + 1) (h2,v, (mkREnv 1 0 0 0) \<smile> p1 \<smile> p2)"

 MHISLeti: "\<lbrakk>N,E \<turnstile> h,e1 \<Down>n (h1,IVal i,p1);  N,E<x:=i> \<turnstile> h1, e2 \<Down>m (h2,v,p2)\<rbrakk> \<Longrightarrow>
            N,E \<turnstile> h, (Leti x e1 e2) \<Down>((max n m) + 1) (h2,v, (mkREnv 1 0 0 0) \<smile> p1 \<smile> p2)"

 MHISLetr: "\<lbrakk>N,E \<turnstile> h,e1 \<Down>n (h1,RVal r,p1);  N,E\<lfloor>x:=r\<rfloor> \<turnstile> h1, e2 \<Down>m (h2,v,p2)\<rbrakk> \<Longrightarrow>
            N,E \<turnstile> h, (Letr x e1 e2) \<Down>((max n m) + 1) (h2,v, (mkREnv 1 0 0 0) \<smile> p1 \<smile> p2)"

 MHISLetv: "\<lbrakk>N,E \<turnstile> h,e1 \<Down>n (h1,w,p1);  N,E \<turnstile> h1, e2 \<Down>m (h2,v,p2)\<rbrakk> \<Longrightarrow>
            N,E \<turnstile> h, (Letv e1 e2) \<Down>((max n m) + 1) (h2,v, p1 \<smile> p2)"

 MHISCall: "\<lbrakk>N,E \<turnstile> h, funtable f \<Down>n (h1,v,p)\<rbrakk> \<Longrightarrow>
            N,E \<turnstile> h,(Call f) \<Down>(n + 1) (h1, v, (mkREnv 1 1 0 0) \<smile> p)"

 MHISInvoke: "\<lbrakk>N,E \<turnstile> h,RVar x \<Down>n (h1,RVal (Ref a),p1) ;  
               N,E \<turnstile> h1,RVar y \<Down>m (h2,RVal v,p2);
               fmap_lookup (heap.oheap h2) a = Some C; 
               N,(newframe_env (Ref a) v) \<turnstile> h2,methtable C mn \<Down>k (h3,w,p3)\<rbrakk> \<Longrightarrow>
              (Suc N),E \<turnstile> h, (Invoke x mn y) \<Down>((max (max n m) k) + 1)  (h3,w,((mkREnv 3 0 1 1) \<smile> p1 \<smile> p2) \<oplus> p3)"

 MHISInvokeStatic: "\<lbrakk>N, E \<turnstile> h,RVar y \<Down>n (h1,RVal v,p1); 
                     N,(newframe_env Nullref v) \<turnstile> h1,methtable C mn \<Down>m (h2,w,p2)\<rbrakk> \<Longrightarrow>
                    (Suc N), E \<turnstile> h, (InvokeStatic C mn y) \<Down>((max n m) + 1) (h2,w, ((mkREnv 2 0 1 1) \<smile> p1) \<oplus> p2)"

 MHISMHInvoke: "\<lbrakk>N,E \<turnstile> h,RVar x \<Down>n (h1,RVal (Ref a),p1) ;  
                 fmap_lookup (heap.oheap h1) a = Some C; 
                 N, E\<lfloor>self := Ref a\<rfloor>  \<turnstile> h1,methtable C mn \<Down>m (h2,v,p2)\<rbrakk> \<Longrightarrow>
                (Suc N),E \<turnstile> h, (MH_Invoke x mn) \<Down>((max n m) + 1) (h2,v,((mkREnv 3 0 1 1) \<smile> p1) \<oplus> p2)"

 MHISMHInvokeStatic: "\<lbrakk>N,E \<turnstile> h,methtable C mn \<Down>n (h1,v,p1)\<rbrakk> \<Longrightarrow>
                      (Suc N),E \<turnstile> h, (MH_InvokeStatic C mn) \<Down>(n + 1) (h1,v, (mkREnv 2 0 1 1) \<oplus> p1)"

 MHISAnn: "N,E \<turnstile> h,e \<Down>n (h1,v,p) \<Longrightarrow> N,E \<turnstile> h,(Ann A e) \<Down>(n + 1) (h1,v,p)"

inductive_cases MHIS_cases: 
 "N,E \<turnstile> h,(expr.Null) \<Down>n  (h1,v,p)"
 "N,E \<turnstile> h,(expr.Int i) \<Down>n  (h1,v,p)"
 "N,E \<turnstile> h,(IVar x) \<Down>n (h1,v,p)"
 "N,E \<turnstile> h,(RVar x) \<Down>n (h1,v,p)"
 "N,E \<turnstile> h,(Primop f x y) \<Down>n (h1,v,p)"
 "N,E \<turnstile> h,(RPrimop f x y) \<Down>n (h1,v,p)"
 "N,E \<turnstile> h,(GetFi x f) \<Down>n (h1,v,p)"
 "N,E \<turnstile> h,(GetFr x f) \<Down>n (h1,v,p)"
 "N,E \<turnstile> h,(PutFi x f y) \<Down>n (h1,v,p)"
 "N,E \<turnstile> h,(PutFr x f y) \<Down>n (h1,v,p)"
 "N,E \<turnstile> h,(New c ifldvals rfldvals) \<Down>n (h1,v,p)"
 "N,E \<turnstile> h,(Ifg x e1 e2) \<Down>n (h1,v,p)"
 "N,E \<turnstile> h,(Leti x e1 e2) \<Down>n (h1,v,p)"
 "N,E \<turnstile> h,(Letr x e1 e2) \<Down>n (h1,v,p)"
 "N,E \<turnstile> h,(Letv e1 e2) \<Down>n (h1,v,p)"
 "N,E \<turnstile> h,(Call f) \<Down>n (h1,v,p)"
 "N,E \<turnstile> h,(Invoke x m y) \<Down>n (h1,v,p)"
 "N,E \<turnstile> h,(InvokeStatic C m y) \<Down>n (h1,v,p)"
 "N,E \<turnstile> h,(MH_Invoke x m) \<Down>n (h1,v,p)"
 "N,E \<turnstile> h,(MH_InvokeStatic C m) \<Down>n (h1,v,p)"
 "N,E \<turnstile> h,(Ann a e) \<Down>n (h1,v,p)"

lemma "\<forall> M e E h hh v p. ((\<exists> n .(M,E \<turnstile> h,e \<Down>n (hh,v,p))) \<longrightarrow> M \<le> N \<longrightarrow> (\<exists> n . (N,E \<turnstile> h,e \<Down>n (hh,v,p))))"
apply clarsimp
(*apply (induct N)*)
apply (erule MHIS.elims, simp_all)
apply clarsimp
apply (rule_tac x=1 in exI)
apply (insert MHISNull, fastsimp)
apply (rotate_tac -1, erule thin_rl)
apply clarsimp
apply (rule_tac x=1 in exI)
apply (insert MHISInt, fastsimp)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply clarsimp
apply (rule_tac x=1 in exI)
apply (insert MHISIVar, fastsimp)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply clarsimp
apply (rule_tac x=1 in exI)
apply (insert MHISRVar, fastsimp)
apply (rotate_tac -1, erule thin_rl)
apply (subgoal_tac "N,Ea \<turnstile> ha , IVar x \<Down>na (h1 , IVal i1 , p1)")
apply (subgoal_tac "N,Ea \<turnstile> h1 , IVar y \<Down>m (h2 , IVal i2 , p2)")
apply clarsimp
apply (rule_tac x="(max na m) + 1" in exI)
apply (insert MHISPrimop, fastsimp)
apply clarsimp
apply (erule MHIS.elims, simp_all)
apply clarsimp
apply (erule MHIS.elims, simp_all)
apply clarsimp
apply fastsimp
apply clarsimp
apply (erule MHIS.elims, simp_all)
apply clarsimp
(*RPrimop*)
apply (rotate_tac -1, erule thin_rl)
apply (subgoal_tac "N,Ea \<turnstile> ha , RVar x \<Down>na (h1 , RVal r1 , p1)")
apply (subgoal_tac "N,Ea \<turnstile> h1 , RVar y \<Down>m (h2 , RVal r2 , p2)")
apply (rule_tac x="(max na m) + 1" in exI)
apply (insert MHISRPrimop, fastsimp)
apply clarsimp
apply (erule MHIS.elims, simp_all)
apply clarsimp
apply (erule MHIS.elims, simp_all)
apply clarsimp
apply fastsimp
apply (erule MHIS.elims, simp_all)
(*Getfi*)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply clarsimp
apply (subgoal_tac "N,Ea \<turnstile> ha , RVar x \<Down>na (h1 , RVal (Ref a) , pa)")
apply (rule_tac x="na + 1" in exI)
apply (insert MHISGetfi, fastsimp)
apply clarsimp
apply (erule MHIS.elims, simp_all)
apply clarsimp
apply (insert MHISRVar)
apply fastsimp
(*Getfr*)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -2, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply clarsimp
apply (subgoal_tac "N,Ea \<turnstile> ha , RVar x \<Down>na (h1 , RVal (Ref a) , pa)")
apply (rule_tac x="na + 1" in exI)
apply (insert MHISGetfr, fastsimp)
apply clarsimp
apply (erule MHIS.elims, simp_all)
apply clarsimp
apply (insert MHISRVar)
apply fastsimp

apply (erule MHIS.elims, simp_all)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -2, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rule_tac x="(max na m) + 1" in exI)
apply (insert MHISRPrimop, fastsimp)
apply clarsimp
apply (rule_tac x="na + 1" in exI)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (insert MHISGetfi, fastsimp)
apply clarsimp
apply (rule_tac x="na + 1" in exI)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (insert MHISGetfr, fastsimp)
apply clarsimp
apply (rule_tac x="(max na m) + 1" in exI)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (insert MHISPutfi, fastsimp)
apply clarsimp
apply (rule_tac x="(max na m) + 1" in exI)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (insert MHISPutfr, fastsimp)
apply clarsimp
apply (rule_tac x="1" in exI)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (insert MHISNew, fastsimp)
apply clarsimp
apply (rule_tac x="(max na m) + 1" in exI)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (insert MHISIf_True, fastsimp)
apply clarsimp
apply (rule_tac x="(max na m) + 1" in exI)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (insert MHISIf_False, fastsimp)
apply clarsimp
apply (rule_tac x="(max na m) + 1" in exI)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (insert MHISLeti, fastsimp)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply clarsimp
apply (rule_tac x="(max na m) + 1" in exI)
apply (insert MHISLetr, fastsimp)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply clarsimp
apply (rule_tac x="(max na m) + 1" in exI)
apply (insert MHISLetv, fastsimp)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply clarsimp
apply (rule_tac x="na + 1" in exI)
apply (insert MHISCall, fastsimp)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply clarsimp
apply (rule_tac x="na + 1" in exI)
apply (insert MHISAnn, fastsimp)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (case_tac "M < Suc n")
apply (subgoal_tac "M \<le> n")
prefer 2 apply fastsimp
apply fastsimp
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply (rotate_tac -1, erule thin_rl)
apply clarsimp
apply (subgoal_tac "0,Ea \<turnstile> ha , IVar x \<Down>Suc 0 (ha , IVal (Ea<x>) , \<lparr>renv.clock = Suc 0, callc = 0, invkc = 0,
 invkdpth = 0\<rparr>)")
prefer 2 apply fastsimp
apply (subgoal_tac "0,Ea \<turnstile> ha , IVar y \<Down>Suc 0 (ha , IVal (Ea<y>) , \<lparr>renv.clock = Suc 0, callc = 0, invkc = 0,
 invkdpth = 0\<rparr>)")
apply (insert MHISPrimop), fastsimp)
apply (erule MHIS.elims, simp_all)
apply clarify
apply (clarsimp, insert MHISInt, fastsimp)
prefer 12
apply (erule MHIS.elims, simp_all)
apply (clarsimp, insert MHISMHInvokeStatic, fastsimp)
apply (rotate_tac -1, erule_tac thin_rl)
apply (insert MHISInt, fastsimp)
apply (rotate_tac -1, erule_tac thin_rl)
apply (rotate_tac -1, erule_tac thin_rl)
apply (insert MHISIVar, fastsimp)
apply (rotate_tac -1, erule_tac thin_rl)
apply (rotate_tac -1, erule_tac thin_rl)
apply (rotate_tac -1, erule_tac thin_rl)
apply (insert MHISRVar, fastsimp)
apply (rotate_tac -1, erule_tac thin_rl)
apply (rotate_tac -1, erule_tac thin_rl)
apply (rotate_tac -1, erule_tac thin_rl)
apply (rotate_tac -1, erule_tac thin_rl)
apply (insert MHISPrimop, fastsimp)
prefer 13
apply (rotate_tac -1, erule_tac thin_rl)
apply (rotate_tac -1, erule_tac thin_rl)
apply (rotate_tac -1, erule_tac thin_rl)
apply (rotate_tac -1, erule_tac thin_rl)
apply (rotate_tac -1, erule_tac thin_rl)
apply (insert MHISInvoke)
apply fastsimp
apply (erule_tac thin_rl)
apply (rule MHISIVar)
apply (rule MHISRVar)
apply (rule MHISPrimop, fastsimp, simp)
apply (rule MHISRPrimop, fastsimp, simp)
apply (rule MHISGetfi, simp)
apply (rule MHISGetfr, simp)
apply (rule MHISPutfi, fastsimp, simp)
apply (rule MHISPutfr, fastsimp, simp)
apply (rule MHISNew, simp, simp)
apply (rule MHISIf_True, simp, simp)
apply (rule MHISIf_False, simp, simp)
apply (rule MHISLeti, fastsimp, simp)
apply (rule MHISLetr, fastsimp, simp)
apply (rule MHISLetv, fastsimp, simp)
apply (rule MHISCall, simp)
apply (subgoal_tac apply (rule MHISInvokeStatic)
apply (rule MHISGetfr, simp)

*)
subsection{*Old stuff*}
lemma "\<forall> E h C mn hh v p m e.
 (E \<turnstile> h,(callSubst n C mn e) \<Down> hh,v,p \<longrightarrow> n <= m \<longrightarrow> E \<turnstile> h,(callSubst m C mn e) \<Down> hh,v,p)"
apply clarsimp
apply (simp add: sem_def, clarsimp)
apply (induct n)
apply (insert LOOPSpec)
apply (erule semn.elims, simp_all)
apply clarsimp
apply (subgoal_tac "Ea \<turnstile> ha , CALL LOOP \<Down>(na + 1) (h1 , va , (mkREnv 1 1 0 0) \<smile> pa)")
apply fastsimp
apply (rule semCall, simp)
apply (case_tac e)
apply (rule_tac x=1 in exI, simp)
apply(case_tac m, simp_all)
apply(case_tac nat, simp_all)
apply clarsimp
apply (erule semn.elims, simp_all)
apply clarsimp
apply (subgoal_tac "Ea \<turnstile> ha , CALL LOOP \<Down>(na + 1) (h1 , va , (mkREnv 1 1 0 0) \<smile> pa)")
apply fastsimp
apply (rule semCall, simp)
apply (subgoal_tac "e = NULL")
apply simp
apply (rule_tac x=1 in exI)
apply simp
apply (subgoal_tac "Ea \<turnstile> ha ,  NULL \<Down>Suc 0 (ha , RVal Nullref , \<lparr>renv.clock = Suc 0, callc = 0, invkc = 0,
     invkdpth = 0\<rparr>)")
apply (subgoal_tac "NULL = callSubst m C mn NULL")
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply clarify

done
(* assumption wrong*)
defer 1
apply (rule_tac x=1 in exI, auto)
apply (case_tac m)
apply (simp_all)
apply (case_tac nat)
apply (simp_all)
(* assumption wrong*)
defer 1
apply (erule semn.elims, simp_all)
apply clarsimp
apply (simp add: subst_def)


lemma SoundRel:
"\<forall> Gamma P .((Gamma,e,P) : vdm_d \<longrightarrow> soundrel e P)"
apply clarsimp
apply (simp add: soundrel_def)
apply (erule vdm_d.induct)
apply (simp_all)
(*Vase MHInvokeStatic*)
prefer 16
apply clarsimp
apply (erule semn.elims, simp_all)
(*Case Ax*)
prefer 16
apply clarsimp
apply (erule semn.elims, simp_all)
apply clarsimp
done
(*Case NULL*)
apply clarsimp
apply (erule semn.elims, simp_all)
(*Case expr.Int*)
apply clarsimp
apply (erule semn.elims, simp_all)
(*Case IVar*)
apply clarsimp
apply (erule semn.elims, simp_all)
(*Case RVar*)
apply clarsimp
apply (erule semn.elims, simp_all)
(*Case Primop*)
apply clarsimp
apply (erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x="p1" in exI, rule_tac x="p2" in exI, simp add: max_def)
apply (rule_tac x="h1" in exI, rule_tac x="i1" in exI, rule)
apply fastsimp
apply (rule_tac x="i2" in exI, simp)
apply (subgoal_tac "ha = h1", clarsimp)
apply (subgoal_tac "h2 = h1", clarsimp)
apply (erule semn.elims, simp_all)
apply clarsimp
apply (erule semn.elims, simp_all)
apply (erule semn.elims, simp_all)
(*Case RPrimop*)
apply clarsimp
apply (erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x="p1" in exI, rule_tac x="p2" in exI, simp add: max_def)
apply (rule_tac x="h1" in exI, rule_tac x="r1" in exI, rule)
apply fastsimp
apply (rule_tac x="r2" in exI, simp)
apply (subgoal_tac "ha = h1", clarsimp)
apply (subgoal_tac "h2 = h1", clarsimp)
apply (erule semn.elims, simp_all)
apply clarsimp
apply (erule semn.elims, simp_all)
apply (erule semn.elims, simp_all)
(*Case New*)
apply clarsimp
apply (erule semn.elims, simp_all)
(*Case Getfi*)
apply clarsimp
apply (erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x="pa" in exI, rule_tac x="a" in exI, simp)
(*Case Getfr*)
apply clarsimp
apply (erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x="pa" in exI, rule_tac x="a" in exI, simp)
(*Case Putfi*)
apply clarsimp
apply (erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x="p1" in exI, rule_tac x="p2" in exI, rule_tac x="h1" in exI, rule_tac x="oh" in exI, 
       rule_tac x="ih" in exI, rule_tac x="rh" in exI, rule_tac x="a" in exI, simp)
apply (rule_tac x="i" in exI, simp)
(*Case Putfr*)
apply clarsimp
apply (erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x="p1" in exI, rule_tac x="p2" in exI, rule_tac x="h1" in exI, rule_tac x="oh" in exI, 
       rule_tac x="ih" in exI, rule_tac x="rh" in exI, rule_tac x="a" in exI, simp)
apply (rule_tac x="r" in exI, simp)
(*Case Leti*)
apply clarsimp
apply (erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x="p1" in exI, rule_tac x="p2" in exI, rule_tac x="h1" in exI, rule_tac x="i" in exI, simp)
(*Case Letr*)
apply clarsimp
apply (erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x="p1" in exI, rule_tac x="p2" in exI, rule_tac x="h1" in exI, rule_tac x="r" in exI, simp)
(*Case Letv*)
apply clarsimp
apply (erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x="p1" in exI, rule_tac x="p2" in exI, rule_tac x="h1" in exI, simp)
apply (rule_tac x=w in exI, simp)
(*Case If*)
apply clarsimp
apply (erule semn.elims, simp_all)
(*Case true*)
apply clarsimp
apply (rule_tac x="mkREnv 1 0 0 0" in exI, rule_tac x="h1" in exI, rule_tac x="p2" in exI, simp add:max_def)
apply (subgoal_tac "Ea<xa> = 1 \<and> p1 = mkREnv 1 0 0 0", clarsimp)
apply (erule semn.elims, simp_all)
(*Case false*)
apply clarsimp
apply (rule_tac x="mkREnv 1 0 0 0" in exI, rule_tac x="h1" in exI, rule_tac x="p2" in exI, simp add:max_def)
apply (subgoal_tac "Ea<xa> = 0 \<and> p1 = mkREnv 1 0 0 0", clarsimp)
apply (erule semn.elims, simp_all)
apply clarsimp
oops


lemma Sound:
"(Gamma,e,P) : vdm_d \<longrightarrow> (\<forall> E p h hh v . (E \<turnstile> h,e \<Down> hh,v,p \<longrightarrow> (E,h,hh,v,p) \<in> P))"
apply clarsimp
apply (subgoal_tac "\<exists> m . E \<turnstile> h,e \<Down>m (hh,v,p)")
prefer 2 apply (simp add: sem_def)
apply clarsimp
apply (insert SoundRel)
apply (simp add: soundrel_def)
apply fastsimp
done

theorem VDMSound:" ({},e,P) : vdm_d \<longrightarrow> sound e P"
by (simp add: sound_def Sound)


subsection{*Earlrier attempts to prove something like MURECCALL*}
text {*
  These version have the disadvantage that they contain universal quantifications
  over contexts in the premisses, which makes them difficult to apply
  *}
lemma vdm_callMut: "
\<lbrakk> \<forall> f G P . (((Call f)::'a expr), P) : G \<longrightarrow> (G \<rhd> ((funtable f)::'a expr) : {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> P}) ; 
  \<forall> e G P . ((e, P) : G \<longrightarrow>  (\<exists> f. e = ((Call f)::'a expr) \<and> P = spectable f))  ;
  ((Call g)::'a expr, spectable g) : G 
\<rbrakk> \<Longrightarrow>
(G - {((Call g)::'a expr, spectable g)}) \<rhd> ((Call g)::'a expr) : (spectable g)"
apply (case_tac "\<exists> f P. (((Call f)::'a expr), P) : (G - {(CALL g, spectable g)})")
 apply (erule exE)
 apply (erule exE)
 apply (subgoal_tac "(G - {(CALL g, spectable g)}) \<rhd> ((Call f)::'a expr) : P")
     (* prove subgoal *)
     prefer 2 
     apply (rule vdm_call)
     apply (erule_tac x="f" in allE, rotate_tac -1)
     apply (erule_tac x="(G - {(CALL g, spectable g)} \<union>{(CALL f, P)})" in allE, rotate_tac -1)
     apply (erule_tac x="P" in allE, rotate_tac -1)
     apply (erule_tac x="Call f" in allE, rotate_tac -1)
     apply (erule_tac x="(G - {(CALL g, spectable g)} \<union>{(CALL f, P)})" in allE, rotate_tac -1)
     apply (erule_tac x="P" in allE, rotate_tac -1)
     apply clarsimp
     (* use subgoal *)
 apply (rule vdm_call) 
 apply (subgoal_tac "G \<rhd>  funtable
                          g : {(E, h, hh, v, p).
                               (E, h, hh, v,
                                \<lparr>renv.clock = 1, callc = 1, invkc = 0, invkdpth = 0\<rparr> \<smile>
                                p)
                               \<in> spectable g}")
 apply (subgoal_tac "G = (G - {(CALL g, spectable g)}) \<union> {(CALL g, spectable g)}")
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply fastsimp
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl)
  defer 1
  apply (erule_tac x="g" in allE, rotate_tac -1)
  apply (erule_tac x="G" in allE, rotate_tac -1)
  apply (erule_tac x="spectable g" in allE)
  apply (erule thin_rl)
  apply simp
  (* case \<not> \<exists> ... *)
  apply (subgoal_tac "G = {(CALL g, spectable g)}")
   apply (rotate_tac -2)
   apply (erule thin_rl)
   apply simp
   apply (rule vdm_call)
   apply simp
   apply (erule thin_rl)
   apply (erule thin_rl)
(* 2 trivial subgoals: *)
sorry

subsubsection{*An alternative without a cut rule, using finite contexts*}
lemma MutRecLemma1: 
  "\<forall> GG g . (finite GG \<and> card GG = n \<and> 
             (\<forall> f G P . ((Call f)::'a expr,P) : G \<longrightarrow> (G \<rhd> ((funtable f)::'a expr):{(E,h,hh,v,p). (E,h,hh,v,tkcall p) : P})) \<and> 
             (\<forall> e G P . (e::'a expr,P) : G \<longrightarrow> (\<exists> f . (e = Call f \<and> P = spectable f))) \<and> 
             (((Call g)::'a expr, spectable g) : GG) \<longrightarrow>
             \<rhd> (Call g) : spectable g)"
apply (induct n)
(* Case n = 0*)
apply clarsimp
(* Case n \<noteq> 0*)
apply clarsimp
apply (case_tac "1 < card GG")
(* Case n > 1*)
apply (subgoal_tac "\<exists> G . finite G \<and> card G = n \<and> ((CALL g)::'a expr, spectable g) : G")
  apply (erule exE)
  apply (rotate_tac 1)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply fastsimp
(*discharge the subgoal*)
  apply (erule thin_rl)
  apply (case_tac "\<exists> e P . (e::'a expr,P) : GG - {((CALL g)::'a expr, spectable g)}")
  (*first case*)
  apply (erule exE)
  apply (erule exE)
  apply (rule_tac x="GG - {(e::'a expr,P)}" in exI)
  apply clarsimp
  apply (erule_tac x = e in allE)
  apply (erule_tac x = GG in allE)
  apply (erule_tac x = P in allE)
  apply clarsimp
  apply (rotate_tac 2)
  apply (erule thin_rl)
  apply rule prefer 2 apply fastsimp
  apply (simp add:card_Diff_singleton_if)
  (*second case*)
  apply (case_tac "{((CALL g)::'a expr, spectable g)} = GG")
  apply fastsimp
  apply fast
(* case card GG = 1*)
  apply (subgoal_tac "1 = card GG")
  prefer 2 apply simp
  apply simp
  apply (subgoal_tac "{((CALL g)::'a expr, spectable g)} = GG")
    apply clarsimp
    apply (rule vdm_call)
    apply clarsimp
    apply (erule_tac x=g in allE)
    apply (erule_tac thin_rl)
    apply (erule_tac thin_rl)
    apply (erule_tac x="{((CALL g)::'a expr, spectable g)}" in allE)
    apply (erule_tac x="spectable g" in allE)
    apply simp
(* Both goals should not be difficult to prove, but currently I'm too stupid*)
sorry

lemma MutRecLemma2: 
"\<lbrakk>finite GG; card GG = n;
  (\<forall> f G P . ((Call f)::'a expr,P) : G \<longrightarrow> (G \<rhd> ((funtable f)::'a expr):{(E,h,hh,v,p). (E,h,hh,v,tkcall p) : P}));
  (\<forall> e G P . (e::'a expr,P) : G \<longrightarrow> (\<exists> f . (e = Call f \<and> P = spectable f)));
  (((Call g)::'a expr, spectable g) : GG)
 \<rbrakk> \<Longrightarrow>
 \<rhd> (Call g) : spectable g"
apply (insert MutRecLemma1 [of n])
apply (erule_tac x = GG in allE)
apply (rotate_tac 3)
apply (erule_tac x = g in allE)
apply fastsimp
done

theorem MutRec:
 "\<lbrakk> finite G;
    \<forall> f G P . ((Call f)::'a expr,P) : G \<longrightarrow> (G \<rhd> ((funtable f)::'a expr):{(E,h,hh,v,p). (E,h,hh,v,tkcall p) : P});
    \<forall> e G P . (e::'a expr,P) : G \<longrightarrow> (\<exists> f . (e = Call f \<and> P = spectable f));
    ((Call g)::'a expr, spectable g) : G
  \<rbrakk> \<Longrightarrow>
  \<rhd> (Call g) : spectable g"
apply clarsimp
apply (subgoal_tac "\<exists> n . card G = n")
apply (erule exE)
apply (rule MutRecLemma2)
apply auto
done
end
