(*  
   File:	$RCSfile: VDMderived.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: VDMderived.thy,v 1.1 2003/08/28 16:32:14 a1hloidl Exp $

   
*)

theory VDMderived = Lemmas + VDM: 


section {* Weakening lemmas for contexts*}
lemma CtxtWeak: "G \<rhd> e : P \<Longrightarrow> (G \<union> D) \<rhd> e : P"
apply (erule vdm_proof.induct)
apply (rule vdm_conseq, fast, simp)
apply (rule vdm_null)
apply (rule vdm_int)
apply (rule vdm_ivar)
apply (rule vdm_rvar)
apply (rule vdm_prim)
apply (rule vdm_rprim)
apply (rule vdm_getfi)
apply (rule vdm_getfr)
apply (rule vdm_putfi)
apply (rule vdm_putfr)
apply (rule vdm_new)
apply (rule vdm_if, simp, simp)
apply (rule vdm_leti, simp, simp)
apply (rule vdm_letr, simp, simp)
apply (rule vdm_letv, simp, simp)
apply (rule vdm_call, simp)
apply (rule vdm_mhinvokestatic, simp)
apply (rule vdm_mhinvoke, simp)
apply (rule vdm_invokestatic, simp)
apply (rule vdm_invoke, simp)
apply (rule vdm_ax, simp)
done

lemma CtxtWeakSingleton: "G \<rhd> e : P \<Longrightarrow> (insert (ee, Q) G) \<rhd> e : P"
by (insert CtxtWeak [of G e P "{(ee,Q)}"], simp)

section{*Cut rules*}
lemma CutAux: 
"(DD \<rhd> e : Q \<Longrightarrow>
(\<forall> G ee P D . (DD = (insert (ee, P) D) \<longrightarrow> (G \<rhd> ee :P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> D \<rhd> e:Q)))"
apply (erule vdm_proof.induct)
apply clarsimp
apply (fastsimp intro: vdm_conseq) 
apply (fastsimp intro: vdm_null) 
apply (fastsimp intro: vdm_int)
apply (fastsimp intro: vdm_ivar)
apply (fastsimp intro: vdm_rvar)
apply (fastsimp intro: vdm_prim)
apply (fastsimp intro: vdm_rprim)
apply (fastsimp intro: vdm_getfi)
apply (fastsimp intro: vdm_getfr)
apply (fastsimp intro: vdm_putfi)
apply (fastsimp intro: vdm_putfr)
apply (fastsimp intro: vdm_new)
(*case vdm_if*)
apply clarsimp
apply (erule_tac x=Ga in allE, erule_tac x=Ga in allE)
apply (erule_tac x=ee in allE, erule_tac x=ee in allE)
apply (erule_tac x=P in allE, erule_tac x=P in allE)
apply (erule_tac x=D in allE, erule_tac x=D in allE)
apply (insert vdm_if, simp, fast)
(*case vdm_leti*)
apply clarsimp apply (rotate_tac 4) apply(erule thin_rl)
apply (erule_tac x=Ga in allE, erule_tac x=Ga in allE)
apply (erule_tac x=ee in allE, erule_tac x=ee in allE)
apply (erule_tac x=P in allE, erule_tac x=P in allE)
apply (erule_tac x=D in allE, erule_tac x=D in allE)
apply (insert vdm_leti, simp, fast)
(*case vdm_letr*)
apply clarsimp apply (rotate_tac 4) apply(erule thin_rl, erule thin_rl)
apply (erule_tac x=Ga in allE, erule_tac x=Ga in allE)
apply (erule_tac x=ee in allE, erule_tac x=ee in allE)
apply (erule_tac x=P in allE, erule_tac x=P in allE)
apply (erule_tac x=D in allE, erule_tac x=D in allE)
apply (insert vdm_letr, simp, fast)
(*case vdm_letv*)
apply clarsimp apply (rotate_tac 4) apply(erule thin_rl, erule thin_rl, erule thin_rl)
apply (erule_tac x=Ga in allE, erule_tac x=Ga in allE)
apply (erule_tac x=ee in allE, erule_tac x=ee in allE)
apply (erule_tac x=P in allE, erule_tac x=P in allE)
apply (erule_tac x=D in allE, erule_tac x=D in allE)
apply (insert vdm_letv, simp, fast)
(*case vdm_call*)
apply clarsimp apply (rotate_tac 2) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rule vdm_call)
apply (erule_tac x = Ga in allE, erule_tac x = ee in allE, erule_tac x = Pa in allE,
       erule_tac x="(insert (CALL f, P) D)" in allE, fastsimp) 
(* case vdm_mh_invokestatic*)
apply clarsimp apply (rotate_tac 2) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rule vdm_mhinvokestatic)
apply (erule_tac x = Ga in allE, erule_tac x = ee in allE, erule_tac x = Pa in allE,
       erule_tac x="(insert (C\<bullet>\<bullet>mn, P) D)" in allE, fastsimp) 
(* case vdm_mh_invoke*)
apply clarsimp apply (rotate_tac 1) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rule vdm_mhinvoke)
apply clarsimp
apply (erule_tac x = "E'" in allE, erule_tac x = "h'" in allE,
       erule_tac x = "a" in allE, erule_tac x = "C" in allE, clarsimp)
apply (erule_tac x = Ga in allE, erule_tac x = ee in allE, erule_tac x = Pa in allE,
       erule_tac x="(insert (x\<diamondsuit>\<diamondsuit>mn, P) D)" in allE, fastsimp) 
(* case vdm_invokestatic*)
apply clarsimp apply (rotate_tac 2) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rule vdm_invokestatic)
apply (erule_tac x = Ga in allE, erule_tac x = ee in allE, erule_tac x = Pa in allE,
       erule_tac x="(insert (C\<bullet>mn(y), P) D)" in allE, fastsimp) 
(* case vdm_invoke*)
apply clarsimp apply (rotate_tac 1) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rule vdm_invoke)
apply clarsimp
apply (erule_tac x = "E'" in allE, erule_tac x = "h'" in allE,
       erule_tac x = "a" in allE, erule_tac x = "C" in allE, clarsimp)
apply (erule_tac x = Ga in allE, erule_tac x = ee in allE, erule_tac x = Pa in allE,
       erule_tac x="(insert (x\<diamondsuit>mn(y), P) D)" in allE, fastsimp) 
(*Case vdm_ax*)
apply clarsimp apply (rotate_tac 1) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (erule disjE)
apply clarsimp
apply (subgoal_tac "(Ga \<union> D) \<rhd>  ee : Pa")
apply (subgoal_tac "D = (Ga \<union> D)", simp, fast)
apply (simp add: CtxtWeak)
apply (rule vdm_ax, simp)
done

lemma CCutAux: 
"(DD \<rhd> e : Q \<Longrightarrow>
(\<forall> G f P D . (DD = (insert (Call f, P) D) \<longrightarrow> (G \<rhd> Call f :P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> D \<rhd> e:Q)))"
by (insert CutAux , fast)

lemma mhInvStat_CutAux: 
"(DD \<rhd> e : Q) \<Longrightarrow>
 (\<forall> G C mn P D . ((DD = (insert (C\<bullet>\<bullet>mn, P) D)) \<longrightarrow> (G \<rhd> (C\<bullet>\<bullet>mn) : P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> (D \<rhd> e : Q)))"
by (insert CutAux , fast)

lemma mhInv_CutAux: 
"(DD \<rhd> e : Q) \<Longrightarrow> 
(\<forall> G x mn P D . ((DD = (insert (x\<diamondsuit>\<diamondsuit>mn, P) D)) \<longrightarrow> (G \<rhd> (x\<diamondsuit>\<diamondsuit>mn) : P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> (D \<rhd> e : Q)))"
by (insert CutAux , fast)

lemma InvStat_CutAux: 
"(DD \<rhd> e : Q) \<Longrightarrow>
(\<forall> G C mn y P D . ((DD = (insert (C\<bullet>mn(y), P) D)) \<longrightarrow> (G \<rhd> (C\<bullet>mn(y)) : P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> (D \<rhd> e : Q)))"
by (insert CutAux , fast)

lemma Inv_CutAux: 
"(DD \<rhd> e : Q) \<Longrightarrow>
(\<forall> G C mn P D . ((DD = (insert (x\<diamondsuit>mn(y), P) D)) \<longrightarrow> (G \<rhd> (x\<diamondsuit>mn(y)) : P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> (D \<rhd> e : Q)))"
by (insert CutAux , fast)

lemma CCut:"\<lbrakk> (insert (ee, P) D) \<rhd> e: Q; G \<rhd> ee : P; G \<subseteq> D\<rbrakk> \<Longrightarrow> D \<rhd> e:Q"
by (insert CutAux, fast)

lemma cut:"\<lbrakk> G \<rhd> ee : P ; (insert (ee, P) G) \<rhd> e : Q \<rbrakk> \<Longrightarrow> G \<rhd> e : Q"
by (insert CCut, fast)

(*callInvokeContext G == true if G contains only entried for Calls or xxx_invokes*)
constdefs callInvokeContext::"'a vdmcontext \<Rightarrow> bool"
"callInvokeContext G == 
(\<forall> e Q . (e,Q) : G \<longrightarrow> ((\<exists> f . e = Call f) \<or> 
                        (\<exists> x mn . e = x\<diamondsuit>\<diamondsuit>mn) \<or> (\<exists> C mn . e = C\<bullet>\<bullet>mn) \<or> 
                        (\<exists> x mn y . e = x\<diamondsuit>mn(y)) \<or> (\<exists> C mn y. e = C\<bullet>mn(y))))"

(*contextProvable G D == true if all calls and invokes in G are provable from D*)
constdefs contextProvable::"'a vdmcontext \<Rightarrow> 'a vdmcontext \<Rightarrow> bool"
"contextProvable G D == ((\<forall> f Q . (Call f, Q) : G \<longrightarrow> D \<rhd> Call f : Q) \<and> 
                         (\<forall> x mn Q . (x\<diamondsuit>\<diamondsuit>mn, Q) : G \<longrightarrow> D \<rhd> (x\<diamondsuit>\<diamondsuit>mn) : Q) \<and> 
                         (\<forall> C mn Q . (C\<bullet>\<bullet>mn, Q) : G \<longrightarrow> D \<rhd> (C\<bullet>\<bullet>mn) : Q) \<and> 
                         (\<forall> x mn y Q . (x\<diamondsuit>mn(y), Q) : G \<longrightarrow> D \<rhd> (x\<diamondsuit>mn(y)) : Q) \<and> 
                         (\<forall> C mn y Q . (C\<bullet>mn(y), Q) : G \<longrightarrow> D \<rhd> (C\<bullet>mn(y)) : Q))"

declare callInvokeContext_def[simp]
declare contextProvable_def[simp]

lemma cut2Aux:
"G \<rhd> e : P \<Longrightarrow> ((callInvokeContext G) \<longrightarrow> (\<forall> D . (D \<subseteq> G \<longrightarrow> (contextProvable G D) \<longrightarrow> D \<rhd> e : P)))"
apply (erule vdm_proof.induct)
apply clarsimp
apply (subgoal_tac "D \<rhd>  e : P")
apply (rule vdm_conseq) prefer 2 apply (simp, simp, simp)
apply (insert vdm_null, fastsimp, erule thin_rl)
apply (insert vdm_int, fastsimp, erule thin_rl, erule thin_rl)
apply (insert vdm_ivar, fastsimp, erule thin_rl, erule thin_rl, erule thin_rl)
apply (insert vdm_rvar, fastsimp, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (insert vdm_prim, fastsimp, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (insert vdm_rprim, fastsimp, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (insert vdm_getfi, fastsimp, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (insert vdm_getfr, fastsimp, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (insert vdm_putfi, fastsimp, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (insert vdm_putfr, fastsimp, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (insert vdm_new, fastsimp)
(*case vdm_if*)
apply (rotate_tac 4) apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                            erule thin_rl)
apply clarsimp
apply (erule_tac x=D in allE, simp)
apply (erule_tac x=D in allE, simp)
apply (erule thin_rl, erule thin_rl)
apply (insert vdm_if, fastsimp)
(*case vdm_leti*)
apply (rotate_tac 4) apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                            erule thin_rl, erule thin_rl)
apply clarsimp
apply (erule_tac x=D in allE, simp)
apply (erule_tac x=D in allE, simp)
apply (erule thin_rl, erule thin_rl)
apply (insert vdm_leti, fastsimp)
(*case vdm_letr*)
apply (rotate_tac 4) apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                            erule thin_rl, erule thin_rl, erule thin_rl)
apply clarsimp
apply (erule_tac x=D in allE, simp)
apply (erule_tac x=D in allE, simp)
apply (erule thin_rl, erule thin_rl)
apply (insert vdm_letr, fastsimp)
(*case vdm_letv*)
apply (rotate_tac 4) apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply clarsimp
apply (erule_tac x=D in allE, simp)
apply (erule_tac x=D in allE, simp)
apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (insert vdm_letv, fastsimp)
(*case vdm_call*)
apply (rotate_tac 2) apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply clarsimp
apply (case_tac "(Call f, P) : G")
(* case (Call f, P) : G*)
apply (erule_tac x="Call f" in allE) 
apply (erule_tac x="f" in allE) 
apply (rotate_tac -1)
apply (erule_tac x="P" in allE) apply simp
(* case (Call f, P) \<notin> G*)
apply (rule vdm_call)
apply (erule_tac x="insert (CALL f, P) D" in allE)
apply (subgoal_tac "insert (CALL f, P) D \<subseteq> insert (CALL f, P) G")
prefer 2 apply (erule thin_rl, erule thin_rl) apply (rotate_tac 1) 
         apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, fast)
apply simp
apply (subgoal_tac "(\<forall>fa Q. (fa = f \<and> Q = P \<longrightarrow> insert (CALL f, P) D \<rhd>  (CALL f) : P ) \<and>
                  ((CALL fa, Q) \<in> G \<longrightarrow> insert (CALL f, P) D \<rhd>  (CALL fa) : Q )) \<and>
          (\<forall>x mn Q. (x\<diamondsuit>\<diamondsuit>mn, Q) \<in> G \<longrightarrow> insert (CALL f, P) D \<rhd>  (x\<diamondsuit>\<diamondsuit>mn) : Q ) \<and>
          (\<forall>C mn Q. (C\<bullet>\<bullet>mn, Q) \<in> G \<longrightarrow> insert (CALL f, P) D \<rhd>  (C\<bullet>\<bullet>mn) : Q ) \<and>
          (\<forall>x mn y Q. (x\<diamondsuit>mn(y), Q) \<in> G \<longrightarrow> insert (CALL f, P) D \<rhd>  (x\<diamondsuit>mn(y)) : Q ) \<and>
          (\<forall>C mn y Q. (C\<bullet>mn(y), Q) \<in> G \<longrightarrow> insert (CALL f, P) D \<rhd>  (C\<bullet>mn(y)) : Q )")
apply simp
apply rule
apply clarsimp
apply rule
apply clarsimp
apply (rule vdm_ax, simp)
apply clarsimp
apply (erule_tac x=fa in allE)
apply (erule_tac x=Q in allE)
apply (simp add: CtxtWeakSingleton)
apply rule
apply clarsimp
apply (erule_tac x=x in allE)
apply (erule_tac x=mn in allE)
apply (erule_tac x=Q in allE)
apply (simp add: CtxtWeakSingleton)
apply rule
apply clarsimp
apply (erule_tac x=C in allE)
apply (erule_tac x=mn in allE)
apply (erule_tac x=Q in allE)
apply (simp add: CtxtWeakSingleton)
apply rule
apply clarsimp
apply (erule thin_rl, erule thin_rl, erule thin_rl, 
       erule thin_rl, erule thin_rl, erule thin_rl)
apply (erule_tac x=x in allE)
apply (erule_tac x=mn in allE)
apply (erule_tac x=y in allE)
apply (erule_tac x=Q in allE)
apply (simp add: CtxtWeakSingleton)
apply clarsimp
apply (erule thin_rl, erule thin_rl, erule thin_rl, 
       erule thin_rl, erule thin_rl, erule thin_rl)
apply (erule_tac x=C in allE)
apply (erule_tac x=mn in allE)
apply (erule thin_rl, erule_tac x=y in allE)
apply (erule_tac x=Q in allE)
apply (simp add: CtxtWeakSingleton)
(* case vdm_mhinvokestatic*)
apply (rotate_tac 2) apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply clarsimp
apply (case_tac "(C\<bullet>\<bullet>mn, P) : G")
(* case (C\<bullet>\<bullet>mn, P) : G*)
apply (erule_tac x="C\<bullet>\<bullet>mn" in allE) 
apply (erule_tac x="C" in allE) 
apply (erule_tac x="mn" in allE) 
apply (erule_tac x="P" in allE, simp)
(* case (C\<bullet>\<bullet>mn, P) \<notin> G*)
apply (rule vdm_mhinvokestatic)
apply (erule_tac x="insert (C\<bullet>\<bullet>mn, P) D" in allE)
apply (subgoal_tac "insert (C\<bullet>\<bullet>mn, P) D \<subseteq> insert (C\<bullet>\<bullet>mn, P) G")
prefer 2 apply (erule thin_rl, erule thin_rl) apply (rotate_tac 1) 
         apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, fast)
apply simp
apply (subgoal_tac "(\<forall>f Q. (CALL f, Q) \<in> G \<longrightarrow> insert (C\<bullet>\<bullet>mn, P) D \<rhd>  (CALL f) : Q ) \<and>
          (\<forall>x mna Q. (x\<diamondsuit>\<diamondsuit>mna, Q) \<in> G \<longrightarrow> insert (C\<bullet>\<bullet>mn, P) D \<rhd>  (x\<diamondsuit>\<diamondsuit>mna) : Q ) \<and>
          (\<forall>Ca mna Q.
              (Ca = C \<and> mna = mn \<and> Q = P \<longrightarrow> insert (C\<bullet>\<bullet>mn, P) D \<rhd>  (C\<bullet>\<bullet>mn) : P ) \<and>
              ((Ca\<bullet>\<bullet>mna, Q) \<in> G \<longrightarrow> insert (C\<bullet>\<bullet>mn, P) D \<rhd>  (Ca\<bullet>\<bullet>mna) : Q )) \<and>
          (\<forall>x mna y Q. (x\<diamondsuit>mna(y), Q) \<in> G \<longrightarrow> insert (C\<bullet>\<bullet>mn, P) D \<rhd>  (x\<diamondsuit>mna(y)) : Q ) \<and>
          (\<forall>Ca mna y Q. (Ca\<bullet>mna(y), Q) \<in> G \<longrightarrow> insert (C\<bullet>\<bullet>mn, P) D \<rhd>  (Ca\<bullet>mna(y)) : Q )")
apply simp
apply rule
apply clarsimp
apply (erule_tac x=f in allE)
apply (erule_tac x=Q in allE)
apply (simp add: CtxtWeakSingleton)
apply rule
apply clarsimp
apply (erule_tac x=x in allE)
apply (erule_tac x=mna in allE)
apply (erule_tac x=Q in allE)
apply (simp add: CtxtWeakSingleton)
apply rule
apply clarsimp
apply rule
apply clarsimp
apply (rule vdm_ax, simp)
apply clarsimp
apply (erule_tac x=Ca in allE)
apply (erule_tac x=mna in allE)
apply (erule_tac x=Q in allE)
apply (simp add: CtxtWeakSingleton)
apply rule
apply clarsimp
apply (erule thin_rl, erule thin_rl, erule thin_rl, 
       erule thin_rl, erule thin_rl, erule thin_rl)
apply (erule_tac x=x in allE)
apply (erule_tac x=mna in allE)
apply (erule_tac x=y in allE)
apply (erule_tac x=Q in allE)
apply (simp add: CtxtWeakSingleton)
apply clarsimp
apply (erule thin_rl, erule thin_rl, erule thin_rl, 
       erule thin_rl, erule thin_rl, erule thin_rl)
apply (erule_tac x=Ca in allE)
apply (erule_tac x=mna in allE)
apply (erule thin_rl, erule_tac x=y in allE)
apply (erule_tac x=Q in allE)
apply (simp add: CtxtWeakSingleton)
(* case vdm_mhinvoke*)
apply (rotate_tac 1) apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply clarsimp
apply (case_tac "(x\<diamondsuit>\<diamondsuit>mn, P) : G")
(* case (x\<diamondsuit>\<diamondsuit>mn, P) : G*)
apply (erule_tac x="x" in allE) 
apply (erule_tac x="mn" in allE) 
apply (erule_tac x="P" in allE, simp)
(* case (x\<bullet>\<bullet>mn, P) \<notin> G*)
apply (rule vdm_mhinvoke)
apply clarsimp
apply (erule_tac x="E'" in allE, erule_tac x="h'" in allE,
       erule_tac x=a in allE, rotate_tac 5, erule_tac x=C in allE, clarsimp)
apply (erule_tac x="insert (x\<diamondsuit>\<diamondsuit>mn, P) D" in allE)
apply (subgoal_tac "insert (x\<diamondsuit>\<diamondsuit>mn, P) D \<subseteq> insert (x\<diamondsuit>\<diamondsuit>mn, P) G")
prefer 2 apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) apply (rotate_tac 1) 
         apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, fast)
apply simp
apply (subgoal_tac "(\<forall>f Q. (CALL f, Q) \<in> G \<longrightarrow> insert (x\<diamondsuit>\<diamondsuit>mn, P) D \<rhd>  (CALL f) : Q ) \<and>
          (\<forall>xa mna Q.
              (xa = x \<and> mna = mn \<and> Q = P \<longrightarrow> insert (x\<diamondsuit>\<diamondsuit>mn, P) D \<rhd>  (x\<diamondsuit>\<diamondsuit>mn) : P ) \<and>
              ((xa\<diamondsuit>\<diamondsuit>mna, Q) \<in> G \<longrightarrow> insert (x\<diamondsuit>\<diamondsuit>mn, P) D \<rhd>  (xa\<diamondsuit>\<diamondsuit>mna) : Q )) \<and>
          (\<forall>C mna Q. (C\<bullet>\<bullet>mna, Q) \<in> G \<longrightarrow> insert (x\<diamondsuit>\<diamondsuit>mn, P) D \<rhd>  (C\<bullet>\<bullet>mna) : Q ) \<and>
          (\<forall>xa mna y Q. (xa\<diamondsuit>mna(y), Q) \<in> G \<longrightarrow> insert (x\<diamondsuit>\<diamondsuit>mn, P) D \<rhd>  (xa\<diamondsuit>mna(y)) : Q ) \<and>
          (\<forall>C mna y Q. (C\<bullet>mna(y), Q) \<in> G \<longrightarrow> insert (x\<diamondsuit>\<diamondsuit>mn, P) D \<rhd>  (C\<bullet>mna(y)) : Q )")
apply simp
apply rule
apply clarsimp
apply (erule_tac x=f in allE)
apply (erule_tac x=Q in allE)
apply (simp add: CtxtWeakSingleton)
apply rule
apply clarsimp
apply rule
apply clarsimp
apply (rule vdm_ax, simp)
apply rule
apply (erule_tac thin_rl)
apply (erule_tac x=xa in allE)
apply (erule_tac x=mna in allE)
apply (erule_tac x=Q in allE)
apply (simp add: CtxtWeakSingleton)
apply rule
apply clarsimp
apply (erule_tac thin_rl, erule_tac thin_rl)
apply (erule_tac x=Ca in allE)
apply (erule_tac x=mna in allE)
apply (erule_tac x=Q in allE)
apply (simp add: CtxtWeakSingleton)
apply rule
apply clarsimp
apply (erule_tac x=xa in allE)
apply (erule_tac x=mna in allE)
apply (rotate_tac -1)
apply (erule_tac x=y in allE)
apply (erule_tac x=Q in allE)
apply (simp add: CtxtWeakSingleton)
apply clarsimp
apply (erule_tac x=Ca in allE)
apply (erule_tac x=mna in allE)
apply (rotate_tac -1)
apply (erule_tac x=y in allE)
apply (erule_tac x=Q in allE)
apply (simp add: CtxtWeakSingleton)
(*case vdm_invokestatic*)
apply (rotate_tac 2) apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply clarsimp
apply (case_tac "(C\<bullet>mn(y), P) : G")
(* case (C\<bullet>mn(y), P) : G*)
apply (erule_tac x="C\<bullet>mn(y)" in allE) 
apply (erule_tac x="C" in allE) 
apply (erule_tac x="mn" in allE) 
apply (erule_tac x="P" in allE, simp)
(* case (C\<bullet>mn(y), P) \<notin> G*)
apply (rule vdm_invokestatic)
apply (erule_tac x="insert (C\<bullet>mn(y), P) D" in allE)
apply (subgoal_tac "insert (C\<bullet>mn(y), P) D \<subseteq> insert (C\<bullet>mn(y), P) G")
prefer 2 apply (erule thin_rl, erule thin_rl) apply (rotate_tac 1) 
         apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, fast)
apply simp
apply (subgoal_tac "(\<forall>f Q. (CALL f, Q) \<in> G \<longrightarrow> insert (C\<bullet>mn(y), P) D \<rhd>  (CALL f) : Q ) \<and>
          (\<forall>x mna Q. (x\<diamondsuit>\<diamondsuit>mna, Q) \<in> G \<longrightarrow> insert (C\<bullet>mn(y), P) D \<rhd>  (x\<diamondsuit>\<diamondsuit>mna) : Q ) \<and>
          (\<forall>Ca mna Q. (Ca\<bullet>\<bullet>mna, Q) \<in> G \<longrightarrow> insert (C\<bullet>mn(y), P) D \<rhd>  (Ca\<bullet>\<bullet>mna) : Q ) \<and>
          (\<forall>x mna ya Q. (x\<diamondsuit>mna(ya), Q) \<in> G \<longrightarrow> insert (C\<bullet>mn(y), P) D \<rhd>  (x\<diamondsuit>mna(ya)) : Q ) \<and>
          (\<forall>Ca mna ya Q.
              (Ca = C \<and> mna = mn \<and> ya = y \<and> Q = P \<longrightarrow> insert (C\<bullet>mn(y), P) D \<rhd>  (C\<bullet>mn(y)) : P ) \<and>
              ((Ca\<bullet>mna(ya), Q) \<in> G \<longrightarrow> insert (C\<bullet>mn(y), P) D \<rhd>  (Ca\<bullet>mna(ya)) : Q ))")
apply simp
apply rule
apply clarsimp
apply (erule_tac x=f in allE)
apply (erule_tac x=Q in allE)
apply (simp add: CtxtWeakSingleton)
apply rule
apply clarsimp
apply (erule_tac x=x in allE)
apply (erule_tac x=mna in allE)
apply (erule_tac x=Q in allE)
apply (simp add: CtxtWeakSingleton)
apply rule
apply clarsimp
apply (erule_tac x=Ca in allE)
apply (erule_tac x=mna in allE)
apply (erule_tac x=Q in allE)
apply (simp add: CtxtWeakSingleton)
apply rule
apply clarsimp
apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (erule_tac x=x in allE)
apply (erule_tac x=mna in allE)
apply (erule_tac x=ya in allE)
apply (erule_tac x=Q in allE)
apply (simp add: CtxtWeakSingleton)
apply rule
apply clarsimp
apply rule
apply clarsimp
apply (rule vdm_ax, simp)
apply clarsimp
apply (erule thin_rl, erule thin_rl, erule thin_rl, 
       erule thin_rl, erule thin_rl, erule thin_rl)
apply (erule_tac x=Ca in allE)
apply (erule_tac x=mna in allE)
apply (erule thin_rl, erule_tac x=ya in allE)
apply (erule_tac x=Q in allE)
apply (simp add: CtxtWeakSingleton)
(* case vdm_invoke*)
apply (rotate_tac 1) apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply clarsimp
apply (case_tac "(x\<diamondsuit>mn(y), P) : G")
(* case (x\<diamondsuit>mn(y), P) : G*)
apply (erule_tac x="x" in allE) 
apply (erule_tac x="mn" in allE) 
apply (erule_tac x="P" in allE, simp)
(* case (x\<bullet>mn(y), P) \<notin> G*)
apply (rule vdm_invoke)
apply clarsimp
apply (erule_tac x="E'" in allE, erule_tac x="h'" in allE,
       erule_tac x=a in allE, rotate_tac 5, erule_tac x=C in allE, clarsimp)
apply (erule_tac x="insert (x\<diamondsuit>mn(y), P) D" in allE)
apply (subgoal_tac "insert (x\<diamondsuit>mn(y), P) D \<subseteq> insert (x\<diamondsuit>mn(y), P) G")
prefer 2 apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) apply (rotate_tac 1) 
         apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl,erule thin_rl, fast)
apply simp
apply (subgoal_tac "(\<forall>f Q. (CALL f, Q) \<in> G \<longrightarrow> insert (x\<diamondsuit>mn(y), P) D \<rhd>  (CALL f) : Q ) \<and>
          (\<forall>xa mna Q. (xa\<diamondsuit>\<diamondsuit>mna, Q) \<in> G \<longrightarrow> insert (x\<diamondsuit>mn(y), P) D \<rhd>  (xa\<diamondsuit>\<diamondsuit>mna) : Q ) \<and>
          (\<forall>C mna Q. (C\<bullet>\<bullet>mna, Q) \<in> G \<longrightarrow> insert (x\<diamondsuit>mn(y), P) D \<rhd>  (C\<bullet>\<bullet>mna) : Q ) \<and>
          (\<forall>xa mna ya Q.
              (xa = x \<and> mna = mn \<and> ya = y \<and> Q = P \<longrightarrow> insert (x\<diamondsuit>mn(y), P) D \<rhd>  (x\<diamondsuit>mn(y)) : P ) \<and>
              ((xa\<diamondsuit>mna(ya), Q) \<in> G \<longrightarrow> insert (x\<diamondsuit>mn(y), P) D \<rhd>  (xa\<diamondsuit>mna(ya)) : Q )) \<and>
          (\<forall>C mna ya Q. (C\<bullet>mna(ya), Q) \<in> G \<longrightarrow> insert (x\<diamondsuit>mn(y), P) D \<rhd>  (C\<bullet>mna(ya)) : Q )")
apply simp
apply rule
apply clarsimp
apply (erule_tac x=f in allE)
apply (erule_tac x=Q in allE)
apply (simp add: CtxtWeakSingleton)
apply rule
apply clarsimp
apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (erule_tac x=xa in allE)
apply (erule_tac x=mna in allE)
apply (erule_tac x=Q in allE)
apply (simp add: CtxtWeakSingleton)
apply rule
apply clarsimp
apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (erule_tac x=Ca in allE)
apply (erule_tac x=mna in allE)
apply (erule_tac x=Q in allE)
apply (simp add: CtxtWeakSingleton)
apply rule
apply clarsimp
apply rule
apply clarsimp
apply (rule vdm_ax, simp)
apply clarsimp
apply (erule_tac x=xa in allE)
apply (erule_tac x=mna in allE)
apply (rotate_tac -1)
apply (erule_tac x=ya in allE)
apply (erule_tac x=Q in allE)
apply (simp add: CtxtWeakSingleton)
apply clarsimp
apply (erule_tac x=Ca in allE)
apply (erule_tac x=mna in allE)
apply (rotate_tac -1)
apply (erule_tac x=ya in allE)
apply (erule_tac x=Q in allE)
apply (simp add: CtxtWeakSingleton)
(*case vdm_ax*)
apply (rotate_tac 1) apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply clarsimp
apply (erule_tac x=e in allE)
apply (subgoal_tac "(\<exists> f . e = Call f) \<or> (\<exists>x mn. e = x\<diamondsuit>\<diamondsuit>mn) \<or> (\<exists>C mn. e = C\<bullet>\<bullet>mn) \<or> 
                    (\<exists>x mn y. e = x\<diamondsuit>mn(y)) \<or> (\<exists>C mn y. e = C\<bullet>mn(y))")
apply clarsimp
apply (erule disjE, fast)
apply (erule disjE, fast)
apply (erule disjE, fast)
apply (erule disjE, fast)
apply fast
apply fast
done

lemma cut2:"\<lbrakk>G \<rhd> e : P; D \<subseteq> G; callInvokeContext G; contextProvable G D\<rbrakk> \<Longrightarrow> D \<rhd> e : P"
by (insert cut2Aux [of G e P], fastsimp)

section{*Mutual recursion*}
consts
  spectable  :: "funame \<Rightarrow> vdmassn"
  Mspectable :: "cname \<Rightarrow> mname \<Rightarrow> vdmassn"

(*in mhinvoke, invoke, and invokestatic we maybe have to update E?*)
constdefs consistent::"'a vdmcontext \<Rightarrow> bool"
"consistent G == 
((\<forall> f P. (Call f, P) : G \<longrightarrow> (P = spectable f \<and> G \<rhd> funtable f: {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> P})) \<and> 
 (\<forall> C mn P. (C\<bullet>\<bullet>mn, P) : G \<longrightarrow> (P = Mspectable C mn \<and> G \<rhd> methtable C mn: {(E,h,hh,v,p) . (E,h,hh,v,\<langle>2 0 1 1\<rangle> \<oplus> p) \<in> P})) \<and> 
 (\<forall> mn x P. (x\<diamondsuit>\<diamondsuit>mn, P) : G \<longrightarrow> ((\<exists> E' h' a C . qach_QaQ E' h' a x C \<and> P = Mspectable C mn) \<and> 
                                  (\<forall> E' h' a C . qach_QaQ E' h' a x C \<longrightarrow> 
                                                G \<rhd> methtable C mn: {(E, h, hh, v, p). E = E'\<lfloor>self:=Ref a\<rfloor> \<and> h = h' \<longrightarrow> 
                                                                                           (E', h', hh, v, \<langle>4 0 1 1\<rangle> \<oplus> p) \<in> P}))) \<and> 
 (\<forall> C mn y P. (C\<bullet>mn(y), P) : G \<longrightarrow> (P = Mspectable C mn \<and> 
                                    G \<rhd> methtable C mn: {(E,h,hh,v,p) . 
                                                          \<forall> E'. E = newframe_env Nullref (E'\<lfloor>y\<rfloor>)  \<longrightarrow> (E',h,hh,v,\<langle>3 0 1 1\<rangle> \<oplus> p) \<in> P})) \<and>
 (\<forall> x mn y P. (x\<diamondsuit>mn(y), P) : G \<longrightarrow> ((\<exists> E' h' a C . qach_QaQ E' h' a x C \<and> P = Mspectable C mn) \<and> 
                                     (\<forall> E' h' a C . qach_QaQ E' h' a x C \<longrightarrow> 
                                                    G \<rhd> methtable C mn: 
                                                    {(E,h,hh,v,p) . \<forall> E' . E = newframe_env (E'\<lfloor>x\<rfloor>) (E'\<lfloor>y\<rfloor>) \<and> h = h' \<longrightarrow>  
                                                                           (E',h,hh,v,\<langle>5 0 1 1\<rangle> \<oplus> p) \<in> P}))))"

constdefs specContext::"'a vdmcontext \<Rightarrow> bool"
"specContext G == 
(\<forall> e Q . (e,Q) : G \<longrightarrow> ((\<exists> f . e = Call f \<and> Q = spectable f) \<or>
                        (\<exists> C mn . e = C\<bullet>\<bullet>mn \<and> Q = Mspectable C mn) \<or> 
                        (\<exists> x mn C . e = x\<diamondsuit>\<diamondsuit>mn \<and> Q = Mspectable C mn) \<or>
                        (\<exists> C mn y. e = C\<bullet>mn(y) \<and> Q = Mspectable C mn) \<or> 
                        (\<exists> x mn y C. e = x\<diamondsuit>mn(y) \<and> Q = Mspectable C mn)))"
lemma specContext_preserved: "specContext G \<Longrightarrow> specContext (G - {(e,Q)})"
by (simp add: specContext_def)

lemma consistent_preserved: "\<lbrakk>consistent G; specContext G; (e,Q):G\<rbrakk> \<Longrightarrow> consistent (G - {(e,Q)})"
apply (simp add: consistent_def, clarsimp)
apply (subgoal_tac "(G - {(e,Q)}) \<rhd> e:Q")
prefer 2 
  apply (simp add: specContext_def)
  apply (erule_tac x=e in allE, erule_tac x=Q in allE, simp)
  apply (erule disjE, clarify)
  (*case call*)
  apply (rotate_tac 2, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
  apply (rule vdm_call)
  apply (erule_tac x=f in allE, erule_tac x="spectable f" in allE, simp)
  apply (subgoal_tac "G = insert (CALL f, spectable f) (G - {(CALL f, spectable f)})")
  apply clarsimp
  apply fastsimp
  apply (erule disjE, clarify)
  (*case mhinvokestatic*)
  apply (rotate_tac 1, erule thin_rl)
  apply (rotate_tac 1, erule thin_rl, erule thin_rl, erule thin_rl)
  apply (rule vdm_mhinvokestatic)
  apply (erule_tac x=C in allE, erule_tac x=mn in allE, erule_tac x="Mspectable C mn" in allE, simp)
  apply (subgoal_tac "G = insert (C\<bullet>\<bullet>mn, Mspectable C mn) (G - {(C\<bullet>\<bullet>mn, Mspectable C mn)})")
  apply clarsimp
  apply fastsimp
  apply (erule disjE, clarify)
  (*case mhinvoke*)
  apply (rotate_tac 1, erule thin_rl, erule thin_rl)
  apply (rotate_tac 1, erule thin_rl, erule thin_rl)
  apply (rule vdm_mhinvoke)
  apply clarsimp
  apply (erule_tac x=mn in allE, erule_tac x=x in allE, erule_tac x="Mspectable C mn" in allE, simp)
  apply (subgoal_tac "G = insert (x\<diamondsuit>\<diamondsuit>mn, Mspectable C mn) (G - {(x\<diamondsuit>\<diamondsuit>mn, Mspectable C mn)})")
  apply clarsimp
  apply fastsimp
  apply (erule disjE, clarify)
  (*case invokestatic*)
  apply (rotate_tac 1, erule thin_rl, erule thin_rl, erule thin_rl)
  apply (rotate_tac 1, erule thin_rl)
  apply (rule vdm_invokestatic)
  apply (erule_tac x=C in allE, erule_tac x=mn in allE, erule_tac x=y in allE, erule_tac x="Mspectable C mn" in allE, simp)
  apply (subgoal_tac "G = insert (C\<bullet>mn(y), Mspectable C mn) (G - {(C\<bullet>mn(y), Mspectable C mn)})")
  apply clarsimp
  apply fastsimp 
  apply clarify
  (*case invoke*)
  apply (rotate_tac 1, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
  apply (rule vdm_invoke)
  apply clarsimp
  apply (erule_tac x=x in allE, erule_tac x=mn in allE, erule_tac x=y in allE, erule_tac x="Mspectable C mn" in allE, simp)
  apply (subgoal_tac "G = insert (x\<diamondsuit>mn(y), Mspectable C mn) (G - {(x\<diamondsuit>mn(y), Mspectable C mn)})")
  apply clarsimp
  apply fastsimp
(*now use the subgoal (G - {(e,Q)}) \<rhd> e:Q to prove the goal*)
apply (subgoal_tac "G = insert (e, Q) (G - {(e, Q)})") prefer 2 apply fast
apply (rule, clarify)
(*case call*)
apply (erule_tac x=f in allE, erule_tac x=P in allE, clarsimp)
apply (rule cut, assumption, simp)
apply (rule, clarify)
(*case mhinvokestatic*)
apply (erule_tac x=C in allE, erule_tac x=mn in allE, erule_tac x=P in allE, clarsimp)
apply (rule cut, assumption, simp)
apply (rule, clarify)
(*case mhinvoke*)
apply (erule_tac x=mn in allE, erule_tac x=x in allE, erule_tac x=P in allE, clarsimp)
apply (rule cut, assumption, simp)
apply (rule, clarify)
(*case invokestatic*)
apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rotate_tac 1) apply (erule thin_rl)
apply (erule_tac x=C in allE, erule_tac x=mn in allE, erule_tac x=y in allE, erule_tac x=P in allE, clarsimp)
apply (rule cut, assumption, simp)
apply clarsimp
(*case invoke*)
apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (erule_tac x=x in allE, erule_tac x=mn in allE, erule_tac x=y in allE, erule_tac x=P in allE, clarsimp)
apply (rule cut, assumption, simp)
done

lemma MUTREClemma: 
"\<forall> G . ((finite G \<and> card G = n \<and> specContext G \<and> consistent G \<and> (e,P) : G) \<longrightarrow> \<rhd> e:P)"
apply (induct n)
(*case n=0*)
apply clarsimp
(*Case n>0*)
apply clarsimp
apply (case_tac "G = {(e,P)}")
apply clarsimp
apply (simp add: specContext_def)
apply (erule_tac x="{(e,P)}" in allE)
apply (erule disjE, clarsimp, simp add:consistent_def)
apply (rule vdm_call, simp)
apply (erule disjE, clarsimp, simp add:consistent_def)
apply (rule vdm_mhinvokestatic, simp)
apply (erule disjE, clarsimp, simp add:consistent_def)
apply (rule vdm_mhinvoke, simp)
apply (erule disjE, clarsimp, simp add:consistent_def)
apply (rule vdm_invokestatic, simp)
apply (clarsimp, simp add:consistent_def)
apply (rule vdm_invoke, simp)
(*Case G has more entries than (e,P)*)
apply (subgoal_tac "\<exists> ee Q . (ee,Q) \<noteq> (e,P) \<and> (ee,Q) : G")
prefer 2
apply (rotate_tac 2)
apply (erule thin_rl, erule thin_rl)
apply (rotate_tac 1)
apply (erule thin_rl)
apply fastsimp
(* use the fact that there is another pair (ee,Q):G*)
apply clarsimp
apply (subgoal_tac "(G - {(ee,Q)}) \<rhd> ee: Q")
apply (erule_tac x="G - {(ee, Q)}" in allE)
(*apply (rotate_tac 5)
apply (erule thin_rl)*)
apply (subgoal_tac "specContext (G - {(ee, Q)}) \<longrightarrow> card (G - {(ee, Q)}) = n \<longrightarrow> finite (G - {(ee, Q)}) \<longrightarrow> (e, P) \<notin> G - {(ee, Q)}")
prefer 2 apply (subgoal_tac "consistent (G - {(ee, Q)})", fast) 
apply (simp only: consistent_preserved)
apply (subgoal_tac "specContext (G - {(ee, Q)})", simp (no_asm_use))
apply (subgoal_tac "card (G - {(ee, Q)}) = n", simp)
apply (simp add: card_Diff_singleton) 
apply (rotate_tac 3)
apply (erule thin_rl, erule thin_rl, erule thin_rl)
apply (simp add: specContext_preserved) 
(*the proof for (G - {(ee, Q)}) \<rhd>  ee : Q *)
  apply (simp add: specContext_def)
  apply (erule_tac x=ee in allE, erule_tac x=Q in allE, simp)
  apply (erule disjE, clarsimp)
  (*case call*)
    apply (rule vdm_call)
    apply (subgoal_tac "G - {(CALL f, spectable f)} \<union> {(CALL f, spectable f)} = G")
    prefer 2 apply fast
    apply clarsimp
    apply (rotate_tac 4) apply (erule thin_rl)
    (*before unfolding consistent, we first bring the other 4 cases to the same state as this goal*)
  defer 1
  apply (erule disjE, clarsimp)
  (*case mhinvokestatic*)
    apply (rule vdm_mhinvokestatic)
    apply (subgoal_tac "G - {(C\<bullet>\<bullet>mn, Mspectable C mn)} \<union> {(C\<bullet>\<bullet>mn, Mspectable C mn)} = G")
    prefer 2 apply fast
    apply clarsimp
    apply (rotate_tac 4) apply (erule thin_rl)
  defer 1
  apply (erule disjE, clarsimp)
  (*case mhinvoke*)
    apply (rule vdm_mhinvoke, clarsimp)
    apply (subgoal_tac "insert (x\<diamondsuit>\<diamondsuit>mn, Mspectable C mn) (G - {(x\<diamondsuit>\<diamondsuit>mn, Mspectable C mn)}) = G")
    prefer 2 apply fast
    apply clarsimp
    apply (rotate_tac 4) apply (erule thin_rl)
  defer 1
  apply (erule disjE, clarsimp)
  (*case invokestatic*)
    apply (rule vdm_invokestatic)
    apply (subgoal_tac "G - {(C\<bullet>mn(y), Mspectable C mn)} \<union> {(C\<bullet>mn(y), Mspectable C mn)} = G")
    prefer 2 apply fast
    apply clarsimp
    apply (rotate_tac 4) apply (erule thin_rl)
  defer 1
  apply clarsimp
  (*case invoke*)
    apply (rule vdm_invoke, clarsimp)
    apply (subgoal_tac "insert (x\<diamondsuit>mn(y), Mspectable C mn) (G - {(x\<diamondsuit>mn(y), Mspectable C mn)}) = G")
    prefer 2 apply fast
    apply clarsimp
    apply (rotate_tac 4) apply (erule thin_rl)
  defer 1
  (* back to case call*)
  apply (unfold consistent_def) (*unfolds in all subgoals*)
  apply (erule conjE)
  apply (erule_tac x=f in allE, erule_tac x="spectable f" in allE, simp)
  (* case mhinvokestatic*)
  apply (erule conjE)
  apply (rotate_tac 7, erule thin_rl) (*dont need the assumtion for calls*)
  apply (erule conjE)
  apply (erule_tac x=C in allE, erule_tac x=mn in allE, erule_tac x="Mspectable C mn" in allE, simp)
  (* case mhinvoke*)
  apply (erule conjE)
  apply (rotate_tac 8, erule thin_rl) (*dont need the assumtion for calls*)
  apply (erule conjE)
  apply (rotate_tac 8, erule thin_rl) (*dont need the assumtion for mhinvokestatic*)
  apply (erule conjE)
  apply (erule_tac x=mn in allE, erule_tac x=x in allE, erule_tac x="Mspectable C mn" in allE, simp)
  (* case invokestatic*)
  apply (erule conjE)
  apply (rotate_tac 7, erule thin_rl) (*dont need the assumtion for calls*)
  apply (erule conjE)
  apply (rotate_tac 7, erule thin_rl) (*dont need the assumtion for mhinvokestatic*)
  apply (erule conjE)
  apply (rotate_tac 7, erule thin_rl) (*dont need the assumtion for mhinvoke*)
  apply (erule conjE)
  apply (erule_tac x=C in allE, erule_tac x=mn in allE, erule_tac x=y in allE, erule_tac x="Mspectable C mn" in allE, simp)
  (* case invoke*)
  apply (erule conjE)
  apply (rotate_tac 8, erule thin_rl) (*dont need the assumtion for calls*)
  apply (erule conjE)
  apply (rotate_tac 8, erule thin_rl) (*dont need the assumtion for mhinvokestatic*)
  apply (erule conjE)
  apply (rotate_tac 8, erule thin_rl) (*dont need the assumtion for mhinvoke*)
  apply (erule conjE)
  apply (rotate_tac 8, erule thin_rl) (*dont need the assumtion for invokestatic*)
  apply (erule_tac x=x in allE, erule_tac x=mn in allE, erule_tac x=y in allE, erule_tac x="Mspectable C mn" in allE, simp)
done

theorem MUTREC:
"\<lbrakk> finite G; card G = n; specContext G; consistent G; (e,P) : G \<rbrakk> \<Longrightarrow> \<rhd> e:P"
by (insert MUTREClemma [of n e P], fast)

section{*Earlier version: rules for mutual recursion over functions *}
(* case for a 2 functions *)
lemma mutrecCall2: 
"\<lbrakk> {(((Call f)::'a expr), F), (((Call g)::'a expr), G)} \<rhd> ((funtable f)::'a expr) : {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> F} ;
   {(((Call f)::'a expr), F), (((Call g)::'a expr), G)} \<rhd> ((funtable g)::'a expr) : {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> G} 
 \<rbrakk> \<Longrightarrow>
 \<rhd> ((Call g)::'a expr) : G"
apply (clarsimp)
apply (subgoal_tac "{(((Call g)::'a expr), G)} \<rhd> ((Call f)::'a expr) : F")
  prefer 2 apply (rule vdm_call, simp)
apply (subgoal_tac "{(((Call g)::'a expr), G)} \<rhd> ((funtable g)::'a expr) : {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> G}")
  prefer 2 apply (erule cut, simp)  
apply (rule vdm_call, simp)
done

(*case for 3 functions*)
lemma mutrecCall3: 
"\<lbrakk> {(((Call f)::'a expr), F), (((Call g)::'a expr), G), (((Call k)::'a expr), K)} \<rhd> ((funtable f)::'a expr) : {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> F} ;
   {(((Call f)::'a expr), F), (((Call g)::'a expr), G), (((Call k)::'a expr), K)} \<rhd> ((funtable g)::'a expr) : {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> G} ;
   {(((Call f)::'a expr), F), (((Call g)::'a expr), G), (((Call k)::'a expr), K)} \<rhd> ((funtable k)::'a expr) : {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> K} 
 \<rbrakk> \<Longrightarrow>
 \<rhd> ((Call g)::'a expr) : G"
apply (clarsimp)
apply (subgoal_tac "{(((Call g)::'a expr), G), (((Call k)::'a expr), K)} \<rhd> ((Call f)::'a expr) : F")
  prefer 2 apply (rule vdm_call, simp)
apply (subgoal_tac "{(((Call g)::'a expr), G), (((Call k)::'a expr), K)} \<rhd> ((funtable k)::'a expr) : {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> K}")
  prefer 2 apply (erule cut, simp)
apply (subgoal_tac "{(((Call g)::'a expr), G)} \<rhd> ((Call k)::'a expr) : K")
  prefer 2 apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) apply (rule vdm_call)
  apply (subgoal_tac "{(CALL k, K), (CALL g, G)} \<rhd>  funtable k : {(E, h, hh, v, p). (E, h, hh, v, \<lparr>renv.clock = 1, callc = 1, invkc = 0, invkdpth = 0\<rparr> \<smile> p) \<in> K}")
  apply (simp)
  defer 1
apply (subgoal_tac "{(((Call g)::'a expr), G), (((Call k)::'a expr), K)} \<rhd> ((funtable g)::'a expr) : {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> G}")
  prefer 2 apply (erule cut, simp)  
apply (subgoal_tac "{(((Call g)::'a expr), G)} \<rhd> ((funtable g)::'a expr) : {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> G}")
  prefer 2 apply (erule cut, simp)  apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)apply (erule thin_rl)
  defer 1
apply (rule vdm_call, simp)
(*now discharge the set inclusions*)
apply (subgoal_tac "\<exists> P . P \<rhd>  funtable k : {(E, h, hh, v, p). (E, h, hh, v, \<lparr>renv.clock = 1, callc = 1, invkc = 0, invkdpth = 0\<rparr> \<smile> p) \<in> K} \<and> P = {(CALL k, K), (CALL g, G)}")
apply fastsimp
apply (rule_tac x="{(CALL g, G), (CALL k, K)}" in exI, fastsimp)
apply (subgoal_tac "\<exists> P . P \<rhd>  funtable g : {(E, h, hh, v, p). (E, h, hh, v, \<lparr>renv.clock = 1, callc = 1, invkc = 0, invkdpth = 0\<rparr> \<smile> p) \<in> G} \<and> P = {(CALL k, K), (CALL g, G)}")
apply fastsimp
apply (rule_tac x="{(CALL g, G), (CALL k, K)}" in exI, fastsimp)
done

lemma mutrecLemma:
  "\<forall> G f.
      ((finite G \<and> card G = n \<and> 
       (\<forall> e P . (e,P) : G \<longrightarrow> (\<exists> f . e = ((Call f)::'a expr) \<and> P = spectable f)) \<and> 
       (\<forall> f . ((Call f)::'a expr, spectable f) : G \<longrightarrow> G \<rhd> funtable f:{(E,h,hh,v,p) . (E,h,hh,v,tkcall p) : spectable f}) \<and>
       ((Call f)::'a expr, spectable f) : G)
       \<longrightarrow> \<rhd> ((Call f)::'a expr):spectable f)"
apply (induct n)
(*case n=0*)
apply clarsimp
(*Case n>0*)
apply clarsimp
apply(case_tac "\<exists> g . g \<noteq> f \<and> ((Call g)::'a expr, spectable g):G")
prefer 2
(* G = {(Call f, spectable f)}, so base case*)
apply (subgoal_tac "G = {(CALL f, spectable f)}")
apply clarsimp
apply (rule vdm_call)
apply clarsimp
defer 1 (* prove that G is singleton later*)
(*Case G contains entries for at least f anf g*)
apply clarsimp
apply (subgoal_tac "(G - {(Call g, spectable g)}) \<rhd> (Call g): spectable g")
prefer 2 
  apply (rule vdm_call)
  apply clarsimp
  apply (subgoal_tac "G \<rhd>  funtable g : {(E, h, hh, v, p).
                                        (E, h, hh, v, \<lparr>renv.clock = Suc (renv.clock p), callc = Suc (callc p), invkc = invkc p, invkdpth = invkdpth p\<rparr>)
                                        \<in> spectable g} ")
  prefer 2 apply (erule_tac x=g in allE, fast)
  apply (subgoal_tac "G = insert (CALL g, spectable g) (G - {(CALL g, spectable g)})")
  apply clarsimp
  apply fastsimp
apply (subgoal_tac "\<forall> k P. (Call k,spectable k) : (G - {(CALL g, spectable g)}) \<longrightarrow>  
                    ((G - {(CALL g, spectable g)}) \<rhd> ((funtable k)::'a expr) : {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) : spectable k})")  
prefer 2
  apply clarsimp
  apply (rule cut)
  apply (subgoal_tac "(G - {(CALL g, spectable g)}) \<rhd>  (CALL g) : spectable g")
  prefer 2 apply assumption
  apply fast
  apply (subgoal_tac "G \<rhd>  funtable k : {(E, h, hh, v, p).
                                 (E, h, hh, v, \<lparr>renv.clock = Suc (renv.clock p), callc = Suc (callc p), invkc = invkc p, invkdpth = invkdpth p\<rparr>)
                                 \<in> spectable k}")
  prefer 2 apply (erule_tac x=k in allE, fast)
  apply (subgoal_tac "G = insert (CALL g, spectable g) (G - {(CALL g, spectable g)})")
  apply clarsimp
  apply fastsimp
apply (erule_tac x = "G - {(CALL g, spectable g)}" in allE)
apply (rotate_tac -1)
apply (erule_tac x=f in allE)
apply (subgoal_tac "finite (G - {(CALL g, spectable g)})")
prefer 2 apply simp
apply (subgoal_tac "card (G - {(CALL g, spectable g)}) = n")
prefer 2 defer 1 (*postpone*)
apply (subgoal_tac "(\<forall>e P. (e, P) \<in> G - {(CALL g, spectable g)} \<longrightarrow> (\<exists>f. e = CALL f \<and> P = spectable f))")
prefer 2 apply clarsimp
apply (subgoal_tac "(\<forall>f. (CALL f, spectable f) \<in> G - {(CALL g, spectable g)} \<longrightarrow>
                      (G - {(CALL g,
                             spectable
                              g)}) \<rhd>  funtable
                                       f : {u. (\<lambda>(E, h, hh, v, p).
                                                   (E, h, hh, v,
                                                    \<lparr>renv.clock = Suc (renv.clock p), callc = Suc (callc p), invkc = invkc p, invkdpth = invkdpth p\<rparr>)
                                                   \<in> spectable f)
                                                u} )")
prefer 2 apply clarsimp
apply (subgoal_tac "(CALL f, spectable f) \<in> G - {(CALL g, spectable g)}")
prefer 2 apply clarsimp
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply fast
(*now the deferred goals*)
apply rule
apply clarsimp
apply (erule_tac x=a in allE)
apply (erule_tac x=b in allE)
apply clarsimp
apply (case_tac "fa = f")
apply fast
apply fast
apply fast
apply (insert card_Diff_singleton)
apply fastsimp
done
    
(*now the case for n functions*)
theorem MUTRECCALL:
"\<lbrakk> finite G; card G = n;
   (\<forall> e P . (e,P) : G \<longrightarrow> (\<exists> f . e = ((Call f)::'a expr) \<and> P = spectable f));
   (\<forall> f . ((Call f)::'a expr, spectable f) : G \<longrightarrow> G \<rhd> funtable f:{(E,h,hh,v,p) . (E,h,hh,v,tkcall p) : spectable f});
   ((Call f)::'a expr, spectable f) : G
 \<rbrakk> \<Longrightarrow>
 \<rhd> ((Call f)::'a expr):spectable f"
apply (insert mutrecLemma [of n])
apply (erule_tac x=G in allE)
apply (rotate_tac -1)
apply (erule_tac x=f in allE)
apply auto
done

(*Identity of heaps wrt a set of locations -- should be moved to Lemmas.thy or so*)
syntax objhp::"heap \<Rightarrow> oheap"
translations "objhp" == "heap.oheap"
syntax inthp::"heap \<Rightarrow> iheap"
translations "inthp" == "heap.iheap"
syntax refhp::"heap \<Rightarrow> oheap"
translations "refhp" == "heap.rheap"
constdefs same::"locn set \<Rightarrow> heap \<Rightarrow> heap \<Rightarrow> bool"
"same X h hh == \<forall> l. (l \<in> X \<longrightarrow> (fmap_lookup (objhp h) l = fmap_lookup (objhp hh) l \<and> 
                                  (\<forall> ifield . (inthp h ifield l = inthp hh ifield l)) \<and>
                                  (\<forall> rfield . (refhp h rfield l = refhp hh rfield l))))"
end
