(*  
   File:	$RCSfile: VDMVanilla.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: VDMVanilla.thy,v 1.1 2003/08/28 16:32:14 a1hloidl Exp $

   VDM with some more familar syntax.
*)

theory VDM = Semantics:

(*derivation system for VDM*)

lemma CupMono1 [simp]: "(pp \<smile> p) \<ge>  pp"
by (simp add: max_def)

lemma CupMono2 [simp]: "(pp \<smile> p) \<ge>  p"
by (simp add: max_def)

lemma PlusMono1 [simp]: "(pp \<oplus> p) \<ge> pp"
by (simp add: max_def)

lemma PlusMono2 [simp]: "(pp \<oplus> p) \<ge> p"
by (simp add: max_def)

lemma GeqTrans: "(p \<ge> pp) \<and> (pp \<ge> ppp) \<longrightarrow> (p \<ge> ppp)"
by clarsimp

types
  "vdmassn" = "(env \<times> heap \<times> heap \<times> val \<times> renv) set"

  "vdmcontext" = "(cname \<times> mname \<times> vdmassn) set"

consts vdm_d :: "(vdmcontext \<times> 'a expr \<times> vdmassn) set"      
(*no rules for Ann A e, call, invoke, invokestatic, mh_invoke and mh_invokestatic yet*)

syntax (xsymbols)
  bonzo3_RiseOfTheAllquantor :: "[vdmcontext, 'a expr, vdmassn] \<Rightarrow> bool" ("_ \<turnstile>\<^sub>v (_):/ (1_)" [900,100,200] 50)

translations
 "E \<turnstile>\<^sub>v e : P" == "(E,e,P) \<in> vdm_d"
 
inductive vdm_d intros
d_Null: "(Gamma, NULL, {(E,h,hh,v,p). ((mkREnv 1 0 0 0) = p) \<and> h = hh \<and> v = RVal Nullref}) : vdm_d"
d_Int: "(Gamma, expr.Int i, {(E,h,hh,v,p). ((mkREnv 1 0 0 0) = p) \<and> h = hh \<and> v = IVal i}) : vdm_d"
d_IVar: "(Gamma, IVar x, {(E,h,hh,v,p). ((mkREnv 1 0 0 0) = p) \<and> h = hh \<and> v = IVal (E<x>)}) : vdm_d"
d_RVar: "(Gamma, RVar x, {(E,h,hh,v,p). ((mkREnv 1 0 0 0) = p) \<and> h = hh \<and> v = RVal (E\<lfloor>x\<rfloor>)}) : vdm_d"
d_Prim: "\<lbrakk>(Gamma, IVar x, P1) : vdm_d; (Gamma, IVar y, P2) :vdm_d\<rbrakk> \<Longrightarrow>
    (Gamma, 
     Primop f x y, 
     {(E,h,hh,v,p) . (\<exists> p1 p2 h1 u w. ((((mkREnv 1 0 0 0) \<smile> p1 \<smile> p2) = p) \<and> 
                                       ((E,h,h1,IVal u,p1) \<in> P1) \<and> 
                                       ((E,h1,h,IVal w,p2) \<in> P2) \<and> 
                                       (v = IVal (f u w))))}) : vdm_d"
d_RPrim: "\<lbrakk>(Gamma, RVar x, P1) : vdm_d; (Gamma, RVar y, P2) :vdm_d\<rbrakk> \<Longrightarrow>
    (Gamma, 
     RPrimop f x y, 
     {(E,h,hh,v,p) . (\<exists> p1 p2 h1 u w. ((((mkREnv 1 0 0 0) \<smile> p1 \<smile> p2) = p) \<and> 
                                       ((E,h,h1,RVal u,p1) \<in> P1) \<and> 
                                       ((E,h1,h,RVal w,p2) \<in> P2) \<and> 
                                       (v = IVal (f u w))))}) : vdm_d"
d_New: "(Gamma, 
         New c ifldvals rfldvals, 
         {(E,h,hh,v,p) . \<exists> l . (l = freshloc (fmap_dom (heap.oheap h)) \<and> 
                                hh = \<lparr>oheap = (heap.oheap h)(l \<mapsto>\<^sub>f c),
                                      iheap = iheapflds ifldvals l (heap.iheap h) (ienv E),
                                      rheap = rheapflds rfldvals l (heap.rheap h) (renv E)\<rparr> \<and>
                                (v = RVal (Ref l)) \<and> 
                                ((mkREnv 1 0 0 0) = p))}) : vdm_d"
d_Getfi: "\<lbrakk>(Gamma, RVar x, P) : vdm_d \<rbrakk> \<Longrightarrow>
          (Gamma, GetFi x f, {(E,h,hh,v,p) . \<exists> p0 a .(((E,h,hh,RVal (Ref a),p0) \<in> P) \<and> 
                                                      (v = IVal ((heap.iheap hh) f a)) \<and> 
                                                      (((mkREnv 1 0 0 0) \<smile> p0) = p))}) : vdm_d"
d_Getfr: "\<lbrakk>(Gamma, RVar x, P) : vdm_d \<rbrakk> \<Longrightarrow>
          (Gamma, GetFr x f, {(E,h,hh,v,p) . \<exists> p0 a .(((E,h,hh,RVal (Ref a),p0) \<in> P) \<and> 
                                                      (v = RVal ((heap.rheap hh) f a)) \<and> 
                                                      (((mkREnv 1 0 0 0) \<smile> p0) = p))}) : vdm_d"
d_Putfi: "\<lbrakk>(Gamma, RVar x, P0) : vdm_d; (Gamma, IVar y,P1) : vdm_d \<rbrakk> \<Longrightarrow>
          (Gamma, 
           PutFi x f y, 
           {(E,h,hh,v,p) . \<exists> p0 p1 h1 oh ih rh a i.
                            (((E,h,h1,RVal (Ref a),p0) \<in> P0) \<and> 
                             ((E,h1,\<lparr>oheap = oh, iheap = ih, rheap = rh\<rparr>,IVal i,p1) \<in> P1) \<and> 
                             (v = arbitrary) \<and> 
                             (hh = \<lparr>oheap = oh, iheap = ih(f := (ih f)(a := i)), rheap = rh\<rparr>) \<and> 
                             (((mkREnv 1 0 0 0) \<smile> p0 \<smile> p1) = p))}) : vdm_d"
d_Putfr: "\<lbrakk>(Gamma, RVar x, P0) : vdm_d; (Gamma, RVar y,P1) : vdm_d \<rbrakk> \<Longrightarrow>
          (Gamma, 
           PutFr x f y,
           {(E,h,hh,v,p) . \<exists> p0 p1 h1 oh ih rh a r.
                            (((E,h,h1,RVal (Ref a),p0) \<in> P0) \<and> 
                             ((E,h1,\<lparr>oheap = oh, iheap = ih, rheap = rh\<rparr>,RVal r,p1) \<in> P1) \<and> 
                             (v = arbitrary) \<and> 
                             (hh = \<lparr>oheap = oh, iheap = ih, rheap = rh(f := (rh f)(a := r))\<rparr>) \<and> 
                             (((mkREnv 1 0 0 0) \<smile> p0 \<smile> p1) = p))}) : vdm_d"
d_Leti: "\<lbrakk>(Gamma, e1,P1) : vdm_d; (Gamma, e2,P2) : vdm_d \<rbrakk> 
        \<Longrightarrow> (Gamma, 
             Leti x e1 e2,
             {(E,h,hh,v,p) . \<exists> p1 p2 h1 i . ((E,h,h1,IVal i,p1) \<in> P1 \<and>
                                             (E<x:=i>,h1,hh,v,p2) \<in> P2 \<and>
                                              p = ((mkREnv 1 0 0 0) \<smile> p1 \<smile> p2))}) : vdm_d"
d_Letr: "\<lbrakk>(Gamma, e1,P1) : vdm_d; (Gamma, e2,P2) : vdm_d \<rbrakk> 
        \<Longrightarrow> (Gamma, 
             Letr x e1 e2, 
             {(E,h,hh,v,p) . \<exists> p1 p2 h1 r . ((E,h,h1,RVal r,p1) \<in> P1 \<and>
                                             (E\<lfloor>x:=r\<rfloor>,h1,hh,v,p2) \<in> P2 \<and>
                                             p = ((mkREnv 1 0 0 0) \<smile> p1 \<smile> p2))}) : vdm_d"
d_Letv: "\<lbrakk>(Gamma, e1,P1) : vdm_d; (Gamma, e2,P2) : vdm_d \<rbrakk> 
        \<Longrightarrow> (Gamma,
             Letv e1 e2,
             {(E,h,hh,v,p) . \<exists> p1 p2 h1 w . ((E,h,h1,w,p1) \<in> P1 \<and>
                                             (E,h1,hh,v,p2) \<in> P2 \<and>
                                             p = (p1 \<smile> p2))}) : vdm_d"
d_If: "\<lbrakk> (Gamma, IVar x, P0): vdm_d; (Gamma, e1, P1) : vdm_d; (Gamma, e2, P2) : vdm_d \<rbrakk>
   \<Longrightarrow> (Gamma, 
        IF x THEN e1 ELSE e2,
        {(E,h,hh,v,p). \<exists> p0 h1 pp. 
                         ((((mkREnv 1 0 0 0) \<smile> p0 \<smile> pp) = p) \<and> 
                          ((E,h,h1,IVal(E<x>),p0) \<in> P0) \<and> 
                          (E<x> = grailbool True \<longrightarrow> (E,h1,hh,v,pp) \<in> P1) \<and> 
                          (E<x> = grailbool False \<longrightarrow> (E,h1,hh,v,pp) \<in> P2))}): vdm_d"
d_MHInvokeStatic:
  "\<lbrakk>(Gamma \<union> {(C,mn,P)},
    methtable C mn, 
    {(E,h,hh,v,p) . (E,h,hh,v,(mkREnv 2 0 1 1) \<oplus> p) \<in> P }) : vdm_d
   \<rbrakk> \<Longrightarrow>
   (Gamma, MH_InvokeStatic C mn, P) : vdm_d"
d_AxMHStatic: "\<lbrakk>(C,mn,P) \<in> Gamma \<rbrakk> \<Longrightarrow> (Gamma, MH_InvokeStatic C mn, P) : vdm_d"

constdefs soundrel::"'a expr \<Rightarrow> vdmassn \<Rightarrow> bool"
"soundrel e P \<equiv>  (\<forall> n E p h hh v . (E \<turnstile> h,e \<Down>n (hh,v,p) \<longrightarrow> (E,h,hh,v,p) \<in> P))"

(*instantiation of expr with heap arbitrary - CountextSound needs some concrete instationatuion though*)
constdefs sound::"heap expr \<Rightarrow> vdmassn \<Rightarrow> bool"
"sound e P \<equiv>  (\<forall> E p h hh v . (E \<turnstile> h,e \<Down> hh,v,p \<longrightarrow> (E,h,hh,v,p) \<in> P))"

constdefs ContextSound::"vdmcontext \<Rightarrow> bool"
"ContextSound Gamma \<equiv>  (\<forall> C mn P . (C,mn,P) \<in> Gamma \<longrightarrow> (sound (MH_InvokeStatic C mn) P))"

(*substitutes MHinvokeStatics*)
consts subst:: "'a expr \<Rightarrow> 'a expr \<Rightarrow> 'a expr"
primrec
"subst (expr.Int i) a = (expr.Int i)"
"subst (IVar x) a = (IVar x)"
"subst (Primop f x y) a = (Primop f x y)"
"subst (expr.Null) a = (expr.Null)"
"subst (RPrimop f x y) a = (RPrimop f x y)"
"subst (RVar x) a = (RVar x)"
"subst (New C ifldvals rfldvals) a = (New C ifldvals rfldvals)"
"subst (GetFi x f) a = (GetFi x f)" 
"subst (GetFr x f) a = (GetFr x f)" 
"subst (PutFi x f y) a = (PutFi x f y)" 
"subst (PutFr x f y) a = (PutFr x f y)" 
"subst (Invoke x m y) a = (Invoke x m y)" 
"subst (InvokeStatic C m y) a = (InvokeStatic C m y)" 
"subst (MH_Invoke x m) a = (MH_Invoke x m)" 
"subst (MH_InvokeStatic C m) a = a"  
"subst (Leti x e1 e2) a = (Leti x (subst e1 a) (subst e2 a))" 
"subst (Letr x e1 e2) a = (Letr x (subst e1 a) (subst e2 a))" 
"subst (Letv e1 e2) a = (Letv (subst e1 a) (subst e2 a))" 
"subst (Ifg x e1 e2) a = (Ifg x (subst e1 a) (subst e2 a))"
"subst (Call f) a = (Call f)"
"subst (Ann A e) a = (Ann A (subst e a))"

consts LOOP:: funame
lemma LOOPSpec: "\<not> (E \<turnstile> h , CALL LOOP \<Down>na (hh , v , p))"
sorry

consts callSubst:: "nat \<Rightarrow> cname \<Rightarrow> mname \<Rightarrow> 'a expr \<Rightarrow> 'a expr"
primrec 
"callSubst 0 C mn e = (Call LOOP)"
"callSubst (Suc n) C mn e = (subst (methtable C mn) (callSubst n C mn e))"

lemma "\<forall> E h C mn hh v p m e.
 (E \<turnstile> h,(callSubst n C mn e) \<Down> hh,v,p \<longrightarrow> n <= m \<longrightarrow> E \<turnstile> h,(callSubst m C mn e) \<Down> hh,v,p)"
apply clarsimp
apply (simp add: sem_def, clarsimp)
apply (induct n)
apply (insert LOOPSpec)
apply (erule semn.elims, simp_all)
apply clarsimp
apply (subgoal_tac "Ea \<turnstile> ha , CALL LOOP \<Down>(na + 1) (h1 , va , (mkREnv 1 1 0 0) \<smile> pa)")
apply fastsimp
apply (rule semCall, simp)
apply (case_tac e)
apply (rule_tac x=1 in exI, simp)
apply(case_tac m, simp_all)
apply(case_tac nat, simp_all)
apply clarsimp
apply (erule semn.elims, simp_all)
apply clarsimp
apply (subgoal_tac "Ea \<turnstile> ha , CALL LOOP \<Down>(na + 1) (h1 , va , (mkREnv 1 1 0 0) \<smile> pa)")
apply fastsimp
apply (rule semCall, simp)
apply (subgoal_tac "e = NULL")
apply simp
apply (rule_tac x=1 in exI)
apply simp
apply (subgoal_tac "Ea \<turnstile> ha ,  NULL \<Down>Suc 0 (ha , RVal Nullref , \<lparr>renv.clock = Suc 0, callc = 0, invkc = 0,
     invkdpth = 0\<rparr>)")
apply (subgoal_tac "NULL = callSubst m C mn NULL")
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply clarify

done
(* assumption wrong*)
defer 1
apply (rule_tac x=1 in exI, auto)
apply (case_tac m)
apply (simp_all)
apply (case_tac nat)
apply (simp_all)
(* assumption wrong*)
defer 1
apply (erule semn.elims, simp_all)
apply clarsimp
apply (simp add: subst_def)


lemma SoundRel:
"\<forall> Gamma P .((Gamma,e,P) : vdm_d \<longrightarrow> soundrel e P)"
apply clarsimp
apply (simp add: soundrel_def)
apply (erule vdm_d.induct)
apply (simp_all)
(*Vase MHInvokeStatic*)
prefer 16
apply clarsimp
apply (erule semn.elims, simp_all)
(*Case Ax*)
prefer 16
apply clarsimp
apply (erule semn.elims, simp_all)
apply clarsimp
done
(*Case NULL*)
apply clarsimp
apply (erule semn.elims, simp_all)
(*Case expr.Int*)
apply clarsimp
apply (erule semn.elims, simp_all)
(*Case IVar*)
apply clarsimp
apply (erule semn.elims, simp_all)
(*Case RVar*)
apply clarsimp
apply (erule semn.elims, simp_all)
(*Case Primop*)
apply clarsimp
apply (erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x="p1" in exI, rule_tac x="p2" in exI, simp add: max_def)
apply (rule_tac x="h1" in exI, rule_tac x="i1" in exI, rule)
apply fastsimp
apply (rule_tac x="i2" in exI, simp)
apply (subgoal_tac "ha = h1", clarsimp)
apply (subgoal_tac "h2 = h1", clarsimp)
apply (erule semn.elims, simp_all)
apply clarsimp
apply (erule semn.elims, simp_all)
apply (erule semn.elims, simp_all)
(*Case RPrimop*)
apply clarsimp
apply (erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x="p1" in exI, rule_tac x="p2" in exI, simp add: max_def)
apply (rule_tac x="h1" in exI, rule_tac x="r1" in exI, rule)
apply fastsimp
apply (rule_tac x="r2" in exI, simp)
apply (subgoal_tac "ha = h1", clarsimp)
apply (subgoal_tac "h2 = h1", clarsimp)
apply (erule semn.elims, simp_all)
apply clarsimp
apply (erule semn.elims, simp_all)
apply (erule semn.elims, simp_all)
(*Case New*)
apply clarsimp
apply (erule semn.elims, simp_all)
(*Case Getfi*)
apply clarsimp
apply (erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x="pa" in exI, rule_tac x="a" in exI, simp)
(*Case Getfr*)
apply clarsimp
apply (erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x="pa" in exI, rule_tac x="a" in exI, simp)
(*Case Putfi*)
apply clarsimp
apply (erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x="p1" in exI, rule_tac x="p2" in exI, rule_tac x="h1" in exI, rule_tac x="oh" in exI, 
       rule_tac x="ih" in exI, rule_tac x="rh" in exI, rule_tac x="a" in exI, simp)
apply (rule_tac x="i" in exI, simp)
(*Case Putfr*)
apply clarsimp
apply (erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x="p1" in exI, rule_tac x="p2" in exI, rule_tac x="h1" in exI, rule_tac x="oh" in exI, 
       rule_tac x="ih" in exI, rule_tac x="rh" in exI, rule_tac x="a" in exI, simp)
apply (rule_tac x="r" in exI, simp)
(*Case Leti*)
apply clarsimp
apply (erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x="p1" in exI, rule_tac x="p2" in exI, rule_tac x="h1" in exI, rule_tac x="i" in exI, simp)
(*Case Letr*)
apply clarsimp
apply (erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x="p1" in exI, rule_tac x="p2" in exI, rule_tac x="h1" in exI, rule_tac x="r" in exI, simp)
(*Case Letv*)
apply clarsimp
apply (erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x="p1" in exI, rule_tac x="p2" in exI, rule_tac x="h1" in exI, simp)
apply (rule_tac x=w in exI, simp)
(*Case If*)
apply clarsimp
apply (erule semn.elims, simp_all)
(*Case true*)
apply clarsimp
apply (rule_tac x="mkREnv 1 0 0 0" in exI, rule_tac x="h1" in exI, rule_tac x="p2" in exI, simp add:max_def)
apply (subgoal_tac "Ea<xa> = 1 \<and> p1 = mkREnv 1 0 0 0", clarsimp)
apply (erule semn.elims, simp_all)
(*Case false*)
apply clarsimp
apply (rule_tac x="mkREnv 1 0 0 0" in exI, rule_tac x="h1" in exI, rule_tac x="p2" in exI, simp add:max_def)
apply (subgoal_tac "Ea<xa> = 0 \<and> p1 = mkREnv 1 0 0 0", clarsimp)
apply (erule semn.elims, simp_all)
apply clarsimp
oops


lemma Sound:
"(Gamma,e,P) : vdm_d \<longrightarrow> (\<forall> E p h hh v . (E \<turnstile> h,e \<Down> hh,v,p \<longrightarrow> (E,h,hh,v,p) \<in> P))"
apply clarsimp
apply (subgoal_tac "\<exists> m . E \<turnstile> h,e \<Down>m (hh,v,p)")
prefer 2 apply (simp add: sem_def)
apply clarsimp
apply (insert SoundRel)
apply (simp add: soundrel_def)
apply fastsimp
done

theorem VDMSound:" ({},e,P) : vdm_d \<longrightarrow> sound e P"
by (simp add: sound_def Sound)

lemma CompleteAux:
"\<forall> Gamma P E h hh v p . ((Gamma,e, P) : vdm_d \<longrightarrow> (E \<turnstile> h,e \<Down> hh,v,p) \<longrightarrow> (E,h,hh,v,p) \<in> P)"
apply clarsimp
apply (induct e)
(*Case expr.Int*)
apply (erule vdm_d.elims, simp_all add: sem_def,
       clarsimp,
       erule semn.elims, simp_all)
(*Case IVar*)
apply (erule vdm_d.elims, simp_all add: sem_def,
       clarsimp,
       erule semn.elims, simp_all)
(*Case Primop*)
apply (erule vdm_d.elims, simp_all add: sem_def,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=p1 in exI, rule_tac x=p2 in exI, simp add: max_def)
apply (rule_tac x=h1 in exI, rule_tac x=i1 in exI)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=i2 in exI)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
(*case NULL*)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
(*case RVar*)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
(*case RPrimop*)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=p1 in exI, rule_tac x=p2 in exI, simp add: max_def)
apply (rule_tac x=h1 in exI, rule_tac x=r1 in exI)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=r2 in exI)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
(*case NEW*)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
(*case Getfi*)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=pa in exI, rule_tac x=a in exI, simp)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
(*case Getfr*)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=pa in exI, rule_tac x=a in exI, simp)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
(*case Putfi*)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=p1 in exI, rule_tac x=p2 in exI, rule_tac x=h1 in exI, rule_tac x=oh in exI, 
       rule_tac x=ih in exI, rule_tac x=rh in exI, rule_tac x=a in exI, simp add: max_def)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=i in exI, simp)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
(*case Putfr*)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=p1 in exI, rule_tac x=p2 in exI, rule_tac x=h1 in exI, rule_tac x=oh in exI, 
       rule_tac x=ih in exI, rule_tac x=rh in exI, rule_tac x=a in exI, simp add: max_def)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=r in exI, simp)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
(*case Invoke*)
apply (erule vdm_d.elims, simp_all)
(*case InvokeStatic*)
apply (erule vdm_d.elims, simp_all)
(*case MH_Invoke*)
apply (erule vdm_d.elims, simp_all)
(*case MH_InvokeStatic*)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (erule vdm_d.elims, simp_all,
       clarsimp)
apply clarsimp
apply (rule_tac x=r in exI, simp)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply (erule vdm_d.elims, simp_all)
done
(*case Leti*)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=p1 in exI, rule_tac x=p2 in exI, rule_tac x=h1 in exI, 
       rule_tac x=i in exI, simp add: max_def)
apply rule
apply fastsimp
apply fastsimp
(*case Letr*)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=p1 in exI, rule_tac x=p2 in exI, rule_tac x=h1 in exI, 
       rule_tac x=r in exI, simp add: max_def)
apply rule
apply fastsimp
apply fastsimp
(*case Letv*)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=p1 in exI, rule_tac x=p2 in exI, rule_tac x=h1 in exI, simp add: max_def)
apply rule
apply fastsimp
apply fastsimp
(*case If*)
apply (erule vdm_d.elims, simp_all, clarsimp)
apply (erule semn.elims, simp_all)
(*Case true*)
apply clarsimp
apply (rule_tac x=p1 in exI, rule_tac x=h1 in exI, rule_tac x=p2 in exI, simp add: max_def)
apply (subgoal_tac "Ea<xa>=1", clarsimp)
apply rule
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply fastsimp
apply (erule semn.elims, simp_all)
(* case false*)
apply clarsimp
apply (rule_tac x=p1 in exI, rule_tac x=h1 in exI, rule_tac x=p2 in exI, simp add: max_def)
apply (subgoal_tac "Ea<xa>=0", clarsimp)
apply rule
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply fastsimp
apply (erule semn.elims, simp_all)
(*case Call*)
apply (erule vdm_d.elims, simp_all)
(*case Ann*)
apply (erule vdm_d.elims, simp_all)
done

lemma Complete:
"\<forall> E h hh v p P . (E \<turnstile> h,e \<Down> hh,v,p \<longrightarrow> (e,{(E,h,hh,v,p)}): vdm_d)"???
apply clarsimp
apply (induct e)
apply (simp add: sem_def, clarsimp)
apply (erule semn.elims, simp_all, clarsimp)
oops
apply (subgoal_tac "(expr.Int i, {(E,h,hh,v,p). ((mkREnv 1 0 0 0) \<ge> p) \<and> h = hh \<and> v = IVal i}) : vdm_d
apply (rule d_Int)
apply (insert CompleteAux)
apply (subgoal_tac "P={(E,h,hh,v,p). ((mkREnv 1 0 0 0) \<ge> p) \<and> h = hh \<and> v = IVal int}")
apply clarsimp
apply (rule d_Int)

end
