(* 				 
   File:	$RCSfile: VDMSoundRec.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: VDMSoundRec.thy,v 1.1 2003/08/28 16:32:13 a1hloidl Exp $

   Soundness proof of the VDM-style program logic w.r.t. the functional semantics.
   Rules for Call, Invoke, InvokeStatic only.
   TODO: merge with VDMSound.thy
*)

theory VDMSoundRec = VDM :

subsection {* Auxiliary lemmas and assorted bonzos *}

lemma calllemma00: 
 "\<forall> e P G. ((e, P) \<in> G \<longrightarrow>
      (\<forall>n. |\<Turnstile>\<^sub>n G \<longrightarrow>
           (\<forall>m. m \<le> n \<longrightarrow>
                (\<forall> E h hh v p. E \<turnstile> h , e \<Down>m (hh , v , p) \<longrightarrow> (E, h, hh, v, p) \<in> P))))"
apply (rule allI)+
apply (rule impI)
apply (rule allI)
apply (rule impI)
apply (subgoal_tac "\<Turnstile>\<^sub>n e : P")
apply (simp add: vdm_context_validn_def vdm_validn_def) 
apply (simp add: vdm_context_validn_def, fastsimp)
done

lemma calllemma0: "\<And> e P G. ((e, P) \<in> G \<Longrightarrow>
       \<forall>n. |\<Turnstile>\<^sub>n G \<longrightarrow>
           (\<forall>m. m \<le> n \<longrightarrow>
                (\<forall>E h hh v p. E \<turnstile> h , e \<Down>m (hh , v , p) \<longrightarrow> (E, h, hh, v, p) \<in> P)))"
apply (rule allI)
apply (rule impI)
apply (subgoal_tac "\<Turnstile>\<^sub>n e : P")
 apply (simp add: vdm_context_validn_def vdm_validn_def) 
 apply (simp add: vdm_context_validn_def, fastsimp)
done

subsection {* Soundness *}
(*the following theorem might need a calllemma (or invokelemmas),
  similar to ToyHLrec2 or 3, but not using the clock as measure. 
  Below is a first attempt.
*)

lemma vdmspec_lemma:
"\<lbrakk> G \<rhd> e : P ; 
  \<forall>n. |\<Turnstile>\<^sub>n G \<longrightarrow> (\<forall>m. m \<le> n \<longrightarrow> (\<forall>E h hh v p. E \<turnstile> h , e \<Down>m (hh , v , p) \<longrightarrow> (E, h, hh, v, p) \<in> P));
  |\<Turnstile>\<^sub>n G; m \<le> n;
  E \<turnstile> h , e \<Down>m (hh , v , p)\<rbrakk> \<Longrightarrow> (E,h,hh,v,p) \<in> P"
by simp

lemma SucMaxLemma1: "Suc (max na ma) \<le> n \<Longrightarrow> na \<le> n"
by(subgoal_tac "na < Suc (max na ma)", (simp add: max_def)+)

lemma SucMaxLemma2: "Suc (max na ma) \<le> n \<Longrightarrow> ma \<le> n"
by(subgoal_tac "ma < Suc (max na ma)", (simp add: max_def)+)

lemma vdm_soundAux: "(G \<rhd> e:P) \<Longrightarrow> (\<forall> n . G \<Turnstile>\<^sub>n e:P)"
(*all cases apart from call and 4 invokes go through*)
apply (erule vdm_proof.induct)
apply (simp_all add: vdm_valid_in_ctxt_n_def vdm_validn_def)
apply fastsimp
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all) apply (simp add: obj_ifieldupdate_def obj_rfieldupdate_def)
apply (clarsimp, erule semn.elims, simp_all) apply (simp add: obj_ifieldupdate_def obj_rfieldupdate_def)
apply (clarsimp, erule semn.elims, simp_all)
(*If*)
apply (clarsimp, erule semn.elims, simp_all)
(*True*)
apply (clarsimp, rule_tac x=pa in exI, simp)
apply (subgoal_tac "ma \<le> n")
apply (rotate_tac 5, erule thin_rl)
apply (erule vdmspec_lemma, simp+)
(*False*)
apply (clarsimp, rule_tac x=pa in exI, simp)
apply (subgoal_tac "ma \<le> n")
apply (rotate_tac 5, erule thin_rl)
apply (erule vdmspec_lemma, simp+)
(*Leti*)
apply (clarsimp, erule semn.elims, simp_all, clarsimp)
apply (rule_tac x=p1 in exI, rule_tac x=p2 in exI, rule_tac x=h1 in exI, rule_tac x=i in exI, simp, rule)
apply (subgoal_tac "na \<le> n")
apply(rotate_tac 5, erule thin_rl)
apply (erule vdmspec_lemma, simp+, erule SucMaxLemma1)
apply (subgoal_tac "ma \<le> n")
apply(rotate_tac 5, erule thin_rl)
apply (erule vdmspec_lemma, simp+, erule SucMaxLemma2)
(*Letr*)
apply (clarsimp, erule semn.elims, simp_all, clarsimp)
apply (rule_tac x=p1 in exI, rule_tac x=p2 in exI, rule_tac x=h1 in exI, rule_tac x=r in exI, simp, rule)
apply (subgoal_tac "na \<le> n")
apply(rotate_tac 5, erule thin_rl)
apply (erule vdmspec_lemma, simp+, erule SucMaxLemma1)
apply (subgoal_tac "ma \<le> n")
apply(rotate_tac 5, erule thin_rl)
apply (erule vdmspec_lemma, simp+, erule SucMaxLemma2)
(*Letv*)
apply (clarsimp, erule semn.elims, simp_all, clarsimp)
apply (rule_tac x=p1 in exI, rule_tac x=p2 in exI, rule_tac x=h1 in exI, simp)
apply (rule_tac x=w in exI)
apply (erule_tac x="n" in allE)
apply(erule thin_rl, erule thin_rl, erule thin_rl, fastsimp)
(*Call*)
apply (rule allI)
apply (induct_tac n)
 defer 1 (* should follow directly from the set of 0-step evaluations (semn) being empty *)
 (* -- *)
 apply (erule thin_rl)
 apply (tactic {* rename_tac "k" 1 *})
 apply (rule impI)
 apply (rule allI)
 apply (case_tac "m=Suc k")
  (* interesting case *)
  apply (erule_tac x="k" in allE, rotate_tac -1)
  apply (frule mp) apply (rule ctxt_insertn) apply (rule ctxt_lower_suc) apply (assumption) 
    apply (rotate_tac -3)
    apply (frule mp) apply (rule ctxt_lower_suc) apply (assumption) apply (erule thin_rl)
    apply (rotate_tac -1)
    apply (simp add: vdm_validn_def)
    apply (erule thin_rl)
  apply (rotate_tac -1)
  apply (erule_tac x="k" in allE)
  apply (erule thin_rl)
  apply clarsimp
  apply (erule eval_cases)
  apply clarsimp
  apply (tactic {* all_tac *})
  (* boring case *)
  apply (rotate_tac -3)
  apply (frule mp) apply (rule ctxt_lower_suc) apply (assumption) apply (erule thin_rl)
  apply (rotate_tac -1)
  apply (erule_tac x="m" in allE)
  apply (case_tac "m=Suc k")
   apply (rule impI)
   apply simp
   (* -- *)
   apply (rule impI)
   apply clarsimp
  defer 1 (* get invoke lemma out of the way; not finished with call yet *)
  defer 1 (* get invoke lemma out of the way; not finished with call yet *)
  defer 1 (* get invoke lemma out of the way; not finished with call yet *)
  defer 1 (* get invoke lemma out of the way; not finished with call yet *)
  (* 2 CALL subgoals that remain *)
  (* 1. calllemma could be used here; for now the proof is inlined  *)
  apply (insert calllemma00)
  apply (erule_tac x="e" in allE)
  apply (erule_tac x="P" in allE)
  apply (erule_tac x="G" in allE)
  apply (frule mp) apply (assumption) 
  apply (assumption) 
  (* 2. base case of induction; should be trivial *)
  apply (erule thin_rl)
  apply (rule impI)
  apply (rule allI)
  apply (rule impI)
  apply (rule allI)+
  apply (rule impI)
  apply (simp add: vdm_validn_def vdm_context_validn_def)
  apply clarsimp
  apply (insert no_zero_height_derivs)
  apply fastsimp
(* MH_InvokeStatic *)
apply (rule allI)
apply (induct_tac n)
 (* base case *)
  apply (erule thin_rl)
  apply clarify
  (* .. *)
  apply (simp add: vdm_validn_def vdm_context_validn_def)
  apply clarsimp
  apply (insert no_zero_height_derivs)
  apply fastsimp
 (* -- *)
 apply (erule thin_rl)
 apply (tactic {* rename_tac "k" 1 *})
 apply (rule impI)
 apply (rule allI)
 apply (case_tac "m=Suc k")
  (* interesting case *)
  apply (erule_tac x="k" in allE, rotate_tac -1)
  apply (frule mp) apply (rule ctxt_insertn) apply (rule ctxt_lower_suc) apply (assumption) 
    apply (rotate_tac -4)
    apply (frule mp) apply (rule ctxt_lower_suc) apply (assumption) apply (erule thin_rl)
    apply (rotate_tac -1)
    apply (simp add: vdm_validn_def)
    apply (erule thin_rl)
  apply (rotate_tac -1)
  apply (erule_tac x="k" in allE)
  apply (erule thin_rl)
  apply clarsimp
  apply (erule eval_cases)
  apply clarsimp
  apply (tactic {* all_tac *})
  (* boring case *)
  apply (rotate_tac -4)
  apply (frule mp) apply (rule ctxt_lower_suc) apply (assumption) apply (erule thin_rl)
  apply (rotate_tac -1)
  apply (erule_tac x="m" in allE)
  apply (case_tac "m=Suc k")
   apply (rule impI)
   apply simp
   (* -- *)
   apply (rotate_tac -2)
   apply (rule impI)
   apply clarsimp
apply (tactic {* all_tac *})
defer 1 (* MH_Invoke_finclass *)
(* InvokeStatic *)
(* clean-up *)
apply (rotate_tac -2)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rule allI)
apply (induct_tac n)
 (* base case *)
  apply clarify
  apply (simp add: vdm_validn_def vdm_context_validn_def)
  apply clarsimp
  apply (insert no_zero_height_derivs)
  apply fastsimp
 (* -- *)
 apply (rotate_tac -1)
 apply (erule thin_rl)
 apply (tactic {* rename_tac "k" 1 *})
 apply (rule impI)
 apply (rule allI)
 apply (case_tac "m=Suc k")
  (* interesting case *)
  apply clarsimp
  apply (rotate_tac 1)
  apply (erule_tac x="k" in allE, rotate_tac -1)
  apply (frule mp) apply (rule ctxt_insertn) apply (rule ctxt_lower_suc) apply (assumption) 
    apply (rotate_tac -4)
    apply (frule mp) apply (rule ctxt_lower_suc) apply (assumption) apply (erule thin_rl)
    apply (rotate_tac -1)
    apply (simp add: vdm_validn_def)
    apply (erule thin_rl)
  apply (rotate_tac -1)
  apply (erule_tac x="k" in allE)
  apply (erule thin_rl)
  apply clarsimp
  apply (erule eval_cases)
  apply clarsimp
  apply (tactic {* all_tac *})
  (* Doch Dal (boring case)  *)
  apply (rotate_tac -3)
  apply (frule mp) apply (rule ctxt_lower_suc) apply (assumption) apply (erule thin_rl)
  apply (rotate_tac -1)
  apply (erule_tac x="m" in allE)
  apply (case_tac "m=Suc k")
   apply (rule impI)
   apply simp
   (* -- *)
   apply (rotate_tac -2)
   apply (rule impI)
   apply clarsimp
apply (tactic {* all_tac *}) (* Doch rIn *)
defer 1 (* Invoke *)
(* MH_Invoke_finclass *)
(* ngoqvam QIp yISay'! *)
apply (rotate_tac -2)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rotate_tac -1)
apply (erule thin_rl)
apply (rule allI)
apply (induct_tac n)
 (* base case *)
  apply clarify
  apply (simp add: vdm_validn_def vdm_context_validn_def)
  apply clarsimp
  apply (insert no_zero_height_derivs)
  apply fastsimp
 (* -- *)
 apply (rotate_tac -1)
 apply (erule thin_rl)
 apply (rotate_tac -2)
 apply (erule thin_rl)
 apply (tactic {* rename_tac "k" 1 *})
 apply (rule impI)
 apply (rule allI)
 apply (case_tac "m=Suc k")
  (* interesting case *)
  apply clarsimp
  apply (erule eval_cases)
  (* apply (simp add: qach_QaQ_def)  apply clarify  *)
  apply (rotate_tac 1)
  (*
  apply (erule_tac x="E" in allE, rotate_tac -1)
  apply (erule_tac x="h" in allE, rotate_tac -1)
  apply (rotate_tac 1)
  *)
  apply (erule_tac x="E" in allE, rotate_tac -1)
  apply (erule_tac x="h" in allE, rotate_tac -1)
  apply (erule_tac x="a" in allE, rotate_tac -1)
  apply (erule_tac x="C" in allE, rotate_tac -1)
  apply (tactic {* all_tac *})
  apply (frule mp) defer 1 apply (erule thin_rl) apply (rotate_tac -1) 
  apply (erule conjE) apply (rotate_tac -1)
  apply (erule_tac x="k" in allE, rotate_tac -1)
  apply (frule mp) apply (rule ctxt_insertn) apply (rule ctxt_lower_suc) apply (assumption) 
    apply (rotate_tac -2)
    apply (frule mp) apply (rule ctxt_lower_suc) apply (assumption) apply (erule thin_rl) apply (rotate_tac -1)
    apply (simp add: vdm_validn_def)
    apply (erule thin_rl)
   apply (rotate_tac -1)
   apply (erule_tac x="k" in allE)
   (* apply (erule thin_rl) *)
   apply clarsimp
   (* case m != Suc k *)
   apply clarsimp
   apply (frule mp) apply (rule ctxt_lower_suc)  apply assumption apply (erule thin_rl) apply (rotate_tac -1)
   apply (erule_tac x="m" in allE, rotate_tac -1)
   apply (frule mp) apply clarsimp  apply (erule thin_rl) apply (rotate_tac -1)
   apply (erule_tac x="E" in allE, rotate_tac -1)
   apply (erule_tac x="h" in allE, rotate_tac -1)
   apply (erule_tac x="hh" in allE, rotate_tac -1)
   apply (erule_tac x="v" in allE, rotate_tac -1)
   apply (erule_tac x="p" in allE, rotate_tac -1)
   apply (frule mp) apply (assumption)  
 apply assumption
 apply (tactic {* all_tac *}) (* one bloody side condition left *)
 defer 1 (* Invoke *)
 apply (erule thin_rl)
 (* apply (rule conjI) *)
 (* apply clarsimp *)
 apply (simp add: qach_QaQ_def)
apply (tactic {* all_tac *}) (* Doch rIn *)
(* Invoke *)
(* ngoqvam QIp yISay'! *)
apply (rotate_tac -2)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rotate_tac -2)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rule allI)
apply (induct_tac n)
 (* base case *)
  apply clarify
  apply (simp add: vdm_validn_def vdm_context_validn_def)
  apply clarsimp
  apply (insert no_zero_height_derivs)
  apply fastsimp
 (* -- *)
 apply (rotate_tac -1)
 apply (erule thin_rl)
 apply (rotate_tac -2)
 apply (erule thin_rl)
 apply (tactic {* rename_tac "k" 1 *})
 apply (rule impI)
 apply (rule allI)
 apply (case_tac "m=Suc k")
  (* interesting case *)
  apply clarsimp
  apply (erule eval_cases)
  (* apply (simp add: qach_QaQ_def)  apply clarify  *)
  apply (rotate_tac 1)
  (*
  apply (erule_tac x="E" in allE, rotate_tac -1)
  apply (erule_tac x="h" in allE, rotate_tac -1)
  apply (rotate_tac 1)
  *)
  apply (erule_tac x="E" in allE, rotate_tac -1)
  apply (erule_tac x="h" in allE, rotate_tac -1)
  apply (erule_tac x="a" in allE, rotate_tac -1)
  apply (erule_tac x="C" in allE, rotate_tac -1)
  apply (tactic {* all_tac *})
  apply (frule mp) defer 1 apply (erule thin_rl) apply (rotate_tac -1) 
  apply (erule conjE) apply (rotate_tac -1)
  apply (erule_tac x="k" in allE, rotate_tac -1)
  apply (frule mp) apply (rule ctxt_insertn) apply (rule ctxt_lower_suc) apply (assumption) 
    apply (rotate_tac -2)
    apply (frule mp) apply (rule ctxt_lower_suc) apply (assumption) apply (erule thin_rl) apply (rotate_tac -1)
    apply (simp add: vdm_validn_def)
    apply (erule thin_rl)
   apply (rotate_tac -1)
   apply (erule_tac x="k" in allE)
   (* apply (erule thin_rl) *)
   apply clarsimp
   (* case m != Suc k *)
   apply clarsimp
   apply (frule mp) apply (rule ctxt_lower_suc)  apply assumption apply (erule thin_rl) apply (rotate_tac -1)
   apply (erule_tac x="m" in allE, rotate_tac -1)
   apply (frule mp) apply clarsimp  apply (erule thin_rl) apply (rotate_tac -1)
   apply (erule_tac x="E" in allE, rotate_tac -1)
   apply (erule_tac x="h" in allE, rotate_tac -1)
   apply (erule_tac x="hh" in allE, rotate_tac -1)
   apply (erule_tac x="v" in allE, rotate_tac -1)
   apply (erule_tac x="p" in allE, rotate_tac -1)
   apply (frule mp) apply (assumption)  
 apply assumption
 apply (tactic {* all_tac *}) (* one bloody side condition left *)
 apply (erule thin_rl)
 (* apply (rule conjI) *)
 (* apply clarsimp *)
 apply (simp add: qach_QaQ_def)
done (* Qapla'! *)
(* Hoch rIn! *)

theorem vdm_sound_ctxt: "(G \<rhd> e:P) \<Longrightarrow> (G \<Turnstile> e:P)"
apply (subgoal_tac "\<forall> n . G \<Turnstile>\<^sub>n e:P")
prefer 2 apply (rule vdm_soundAux, simp)
apply (erule thin_rl)
apply (simp add: vdm_valid_in_ctxt_n_def vdm_valid_in_ctxt_def)
apply clarsimp
apply (subgoal_tac "\<forall>n. |\<Turnstile>\<^sub>n G")
apply (simp add: validn_valid)
apply (rule contxt_valid_validn, simp)
done

theorem vdm_sound: "\<rhd> e : P  \<Longrightarrow> \<Turnstile> e : P"
apply (insert vdm_sound_ctxt [of "{}"])
apply (simp add: vdm_valid_in_ctxt_def vdm_validn_def vdm_valid_def sem_def)
apply fast
done

end
