theory VDMComplete = VDMSoundRec + VDMderived:
(* 				 
   File:	$RCSfile: VDMComplete.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: VDMComplete.thy,v 1.1 2003/08/28 16:32:12 a1hloidl Exp $

   Proof of completeness of VDM-style program logic.
*)

text {* The semantic definition of strongest vdm-specification.
        This correponds to the weakest hoare pre-condition, which 
        is simply the set of states which ensure the post-condition.*}

constdefs
 SSpec    :: "'a expr \<Rightarrow> vdmassn"
 "SSpec e == {(E,h,hh,v,p). E \<turnstile> h,e \<Down> hh,v,p}"

(* declare SSpec_def [simp] *)

lemma SSpec_valid: "\<Turnstile> e: SSpec e"
by (simp add: vdm_valid_def SSpec_def)

lemma SSpec_strong: "\<Turnstile> e : P \<Longrightarrow> (SSpec e) \<subseteq> P"
by (simp add: vdm_valid_def SSpec_def, auto)

lemma VDM_proof_SSpec: "\<rhd> e : P \<Longrightarrow> SSpec e \<subseteq> P"
apply (subgoal_tac "\<Turnstile> e : P")
apply (rule SSpec_strong, simp)
apply (insert vdm_sound) apply fastsimp
done

(* Overall proof idea (see~\cite{HofmannScript} and~\cite{NipkowXX}): 
    (0)SSpec_lemma -(1)-> completeAux -(2)-> vdm_complete
    (0) induction over expr; use vdm_ax in Call case 
    (1) induction over expr; use vdm_call and SSpec_lemma in Call case
    (2) use vdm_conseq and completeAux
*)

(* all prg bits are Calls and there is at most one spec for each call in the set
constdefs WF_ctxt :: "'a vdmcontext \<Rightarrow> bool"
 "WF_ctxt G == \<forall> e P. (e,P) \<in> G \<longrightarrow> \<exists> f. e = Call f \<and> 
                        (\<forall> P' . (Call f, P') \<in> G \<longrightarrow>  P=P')"
*)
(*
lemma well_formed_ctxts_are_cool:
  "\<lbrakk> \<forall> f G P P'. (CALL f, P) \<in> G \<and> (CALL funame, P') \<in> G \<longrightarrow> P = P' ;
     (CALL f, Q) \<in> G \<rbrakk>
   \<Longrightarrow>
   insert (Call f, Q') G = G"
sorry
*)
section{*Relating function calls to their specifications*}
lemma SSpec_lemma: 
"\<lbrakk>\<forall> f . G \<rhd> ((Call f)::'a expr) : SSpec ((Call f)::'a expr);
  \<forall> C mn . G \<rhd> ((C\<bullet>\<bullet>mn)::'a expr) : SSpec ((C\<bullet>\<bullet>mn)::'a expr);
  \<forall> x mn . G \<rhd> ((x\<diamondsuit>\<diamondsuit>mn)::'a expr) : SSpec ((x\<diamondsuit>\<diamondsuit>mn)::'a expr);
  \<forall> C mn y. G \<rhd> ((C\<bullet>mn(y))::'a expr) : SSpec ((C\<bullet>mn(y))::'a expr);
  \<forall> x mn y. G \<rhd> ((x\<diamondsuit>mn(y))::'a expr) : SSpec ((x\<diamondsuit>mn(y))::'a expr)\<rbrakk>
 \<Longrightarrow> G \<rhd> (e::'a expr) : (SSpec (e::'a expr))"
apply (simp add: SSpec_def sem_def)
apply (induct e)
apply (simp_all) (*  NB: Call case disappeared already! *)
(* Int *)
apply (rule vdm_conseq, rule vdm_int, clarsimp)
apply (rule_tac x=1 in exI, rule semInt)
(*IVar*)
apply (rule vdm_conseq, rule vdm_ivar, clarsimp)
apply (rule_tac x=1 in exI, rule semIVar)
(*Primop*)
apply (rule vdm_conseq, rule vdm_prim, clarsimp)
apply (rule_tac x=1 in exI, rule semPrimop)
(*Null*)
apply (rule vdm_conseq, rule vdm_null, clarsimp)
apply (rule_tac x=1 in exI, rule semNull)
(*RVar*)
apply (rule vdm_conseq, rule vdm_rvar, clarsimp)
apply (rule_tac x=1 in exI, rule semRVar)
(*RPrimop*)
apply (rule vdm_conseq, rule vdm_rprim, clarsimp)
apply (rule_tac x=1 in exI, rule semRPrimop)
(*New*)
apply (rule vdm_conseq, rule vdm_new, clarsimp)
apply (rule_tac x=1 in exI, rule semNew, simp)
(*Getfi*)
apply (rule vdm_conseq, rule vdm_getfi, clarsimp)
apply (rule_tac x=1 in exI, rule semGetfi, simp)
(*Getfr*)
apply (rule vdm_conseq, rule vdm_getfr, clarsimp)
apply (rule_tac x=1 in exI, rule semGetfr, simp)
(*Putfi*)
apply (rule vdm_conseq, rule vdm_putfi, clarsimp)
apply (rule_tac x=1 in exI, rule semPutfi, simp)
(*Putfr*)
apply (rule vdm_conseq, rule vdm_putfr, clarsimp)
apply (rule_tac x=1 in exI, rule semPutfr, simp)
(*Leti*)
apply (rule vdm_conseq, rule vdm_leti, fast, fast, clarsimp)
apply (rule_tac x="(max n na) + 1" in exI, insert semLeti, fastsimp)
(* Letr*)
apply (rotate_tac -1)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_letr, fast, fast, clarsimp)
apply (rule_tac x="(max n na) + 1" in exI, insert semLetr, fastsimp)
(* Letv*)
apply (rotate_tac -2)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_letv, fast, fast, clarsimp)
apply (rule_tac x="(max n na)" in exI, insert semLetv, fastsimp)
(*If*)
apply (rotate_tac -3)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_if, fast, fast, clarsimp)
apply (case_tac "a<iname>=1", clarsimp)
apply (rule_tac x="n+1" in exI, insert semIf_True, fastsimp)
apply (subgoal_tac "a<iname>=0", clarsimp)
apply (rule_tac x="n+1" in exI, insert semIf_False, fastsimp)
apply clarsimp (* E<x> is either true or false*)
(* Case Ann left - there is no vdm rule vdm_ann yet*)
sorry

lemma "\<lbrakk>callInvokeContext G; consistent G\<rbrakk> \<Longrightarrow> specContext G"
apply (simp add: consistent_def specContext_def)
apply rule
apply rule
apply rule
apply (erule_tac x=e in allE)
apply (subgoal_tac "(\<exists>f. e = CALL f) \<or> (\<exists>x mn. e = x\<diamondsuit>\<diamondsuit>mn) \<or> (\<exists>C mn. e = C\<bullet>\<bullet>mn) \<or> (\<exists>x mn y. e = x\<diamondsuit>mn(y)) \<or> (\<exists>C mn y. e = C\<bullet>mn(y))")
prefer 2 apply (subgoal_tac "(\<exists>Q. (e, Q) \<in> G)") prefer 2 apply (erule_tac x=Q in exI)
         apply simp
apply (rotate_tac -2) apply (erule thin_rl)
apply (erule disjE, clarsimp)
apply (erule disjE, clarsimp)
apply (rotate_tac 1) apply (erule thin_rl, erule thin_rl)
apply (rotate_tac 1) apply (erule thin_rl, erule thin_rl)
apply (erule_tac x=mn in allE) 
apply (erule_tac x=x in allE) 
apply (erule_tac x=Q in allE, simp)
apply (erule disjE, clarsimp)
apply (erule disjE, clarsimp)
apply (rotate_tac 1) apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (erule_tac x=x in allE) 
apply (erule_tac x=mn in allE) 
apply (erule_tac x=y in allE) 
apply (erule_tac x=Q in allE, simp)
apply clarsimp
done


section{*Contexts containing exactly the specifications*}
(* arbitrary instantiation needed - maybe we should remove polymorhism from expressions after all!!!*)
constdefs strongContext:: "heap vdmcontext"
"strongContext == {(e,P) . \<exists> f. (e = (Call f) \<and> P = SSpec e)} \<union> 
                  {(e,P) . \<exists> C mn. (e = (C\<bullet>\<bullet>mn) \<and> P = SSpec e)} \<union> 
                  {(e,P) . \<exists> x mn. (e = (x\<diamondsuit>\<diamondsuit>mn) \<and> P = SSpec e)} \<union>
                  {(e,P) . \<exists> C mn y. (e = (C\<bullet>mn(y)) \<and> P = SSpec e)} \<union> 
                  {(e,P) . \<exists> x mn y. (e = (x\<diamondsuit>mn(y)) \<and> P = SSpec e)}"

constdefs strongSpec::"'a vdmcontext \<Rightarrow> bool"
"strongSpec G == (\<forall> e P . (e,P): G \<longrightarrow> ((\<forall> f. e = Call f \<longrightarrow> spectable f = SSpec e) \<and> 
                                         (\<forall> C mn. e = C\<bullet>\<bullet>mn \<longrightarrow> Mspectable C mn = SSpec e) \<and> 
                                         (\<forall> x mn. e = x\<diamondsuit>\<diamondsuit>mn \<longrightarrow> ((\<exists> E h a C . qach_QaQ E h a x C \<and>  Mspectable C mn = SSpec e))) \<and> 
                                         (\<forall> C mn y. e = C\<bullet>mn(y) \<longrightarrow> Mspectable C mn = SSpec e) \<and> 
                                         (\<forall> x mn y. e = x\<diamondsuit>mn(y) \<longrightarrow> (\<forall> E h a C . qach_QaQ E h a x C \<longrightarrow> Mspectable C mn = SSpec e))))"

lemma L1:
"strongSpec strongContext \<Longrightarrow> 
 strongContext \<rhd>  ((funtable f)::heap expr) : {(E, h, hh, v, p). (E, h, hh, v, tkcall p) \<in> SSpec ((CALL f)::heap expr)}"
apply (subgoal_tac "strongContext \<rhd> ((funtable f)::heap expr) : SSpec ((funtable f):: heap expr)")
apply (subgoal_tac "SSpec ((funtable f)::heap expr) = {(E, h, hh, v, p). (E, h, hh, v, tkcall p) \<in> SSpec ((CALL f)::heap expr)}")
apply simp
(*proof of the set equality*)
  apply (simp add: SSpec_def sem_def, rule)
  (*inclusion \<subseteq> *)
  apply (clarsimp, rule_tac x="n + 1" in exI, insert semCall, fastsimp)
  (*inclusion \<supseteq> *)
  apply (clarsimp, erule semn.elims, simp_all, clarsimp, rule_tac x="na" in exI, subgoal_tac "b=p", simp, fastsimp)
(*proof of strongContext \<rhd>  funtable f : SSpec (funtable f)*)
apply (rule SSpec_lemma)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
done

lemma L2:
"strongSpec strongContext \<Longrightarrow> 
strongContext \<rhd>  ((methtable C mn)::heap expr) : {(E, h, hh, v, p). (E, h, hh, v, \<langle>Suc (Suc (renv.clock p)) callc p Suc (invkc p) Suc (invkdpth p)\<rangle>) \<in> SSpec ((C\<bullet>\<bullet>mn)::heap expr)}"
apply (subgoal_tac "strongContext \<rhd> ((methtable C mn)::heap expr) : SSpec ((methtable C mn):: heap expr)")
apply (subgoal_tac "SSpec ((methtable C mn)::heap expr) = {(E, h, hh, v, p). (E, h, hh, v, \<langle>Suc (Suc (renv.clock p)) callc p Suc (invkc p) Suc (invkdpth p)\<rangle>) \<in> SSpec ((C\<bullet>\<bullet>mn)::heap expr)}")
apply simp
(*proof of the set equality*)
  apply (simp add: SSpec_def sem_def, rule)
  (*inclusion \<subseteq> *)
  apply (clarsimp, rule_tac x="n + 1" in exI, insert semMHInvokeStatic, fastsimp)
  (*inclusion \<supseteq> *)
  apply (clarsimp, erule semn.elims, simp_all, clarsimp, rule_tac x="na" in exI, subgoal_tac "b=p", simp, fastsimp)
(*proof of strongContext \<rhd>  methtable C mn : SSpec (methtable C mn) *)
apply (rule SSpec_lemma)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
done

lemma L3:
"\<lbrakk>strongSpec strongContext; (x\<diamondsuit>\<diamondsuit>mn, SSpec (x\<diamondsuit>\<diamondsuit>mn)) \<in> strongContext; qach_QaQ E' h' a x C\<rbrakk> \<Longrightarrow>
(\<forall> E' h' a C . (qach_QaQ E' h' a x C) \<longrightarrow>
strongContext \<rhd> ((methtable C mn)::heap expr) :
       {(E, h, hh, v, p). (E = E'\<lfloor>self:=Ref a\<rfloor> \<and> h = h') \<longrightarrow> 
          (E', h', hh, v, \<langle>4 + renv.clock p callc p Suc (invkc p) Suc (invkdpth p)\<rangle>) \<in> SSpec ((x\<diamondsuit>\<diamondsuit>mn)::heap expr)})"
sorry
(*apply (simp add: qach_QaQ_def, clarsimp)
apply (simp add: strongSpec_def)
apply (erule_tac x= "x\<diamondsuit>\<diamondsuit>mn" in allE, simp)
apply (subgoal_tac "strongContext \<rhd> ((methtable C mn)::heap expr) : SSpec ((methtable C mn):: heap expr)")
prefer 2
apply (rule SSpec_lemma)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
apply (subgoal_tac "(\<exists>P. (x\<diamondsuit>\<diamondsuit>mn, P) \<in> strongContext) ", simp)
prefer 2 apply (simp add: strongContext_def)
apply clarsimp
apply (simp add: qach_QaQ_def, clarsimp)
apply (subgoal_tac "strongContext \<rhd>  ((methtable Ca mn)::heap expr) : {(E, h, hh, v, p).
                                  E = E'a\<lfloor>self:=Ref aa\<rfloor> \<and> h = h'a \<longrightarrow>
                                  (E'a, h'a, hh, v, \<langle>4 + renv.clock p callc p Suc (invkc p) Suc (invkdpth p)\<rangle>) \<in> (Mspectable Caa mn)}")
apply simp
apply (subgoal_tac "strongContext \<rhd>  ((methtable Ca mn)::heap expr) : SSpec ((methtable Ca mn)::heap expr)")
apply (subgoal_tac "SSpec ((methtable Ca mn)::heap expr) = {(E, h, hh, v, p).
                                  E = E'a\<lfloor>self:=Ref aa\<rfloor> \<and> h = h'a \<longrightarrow>
                                  (E'a, h'a, hh, v, \<langle>4 + renv.clock p callc p Suc (invkc p) Suc (invkdpth p)\<rangle>) \<in> Mspectable Caa mn}")
apply simp
apply rule apply clarsimp
apply (simp add: SSpec_def sem_def, clarsimp) apply (rule_tac x="n+1" in exI) apply (insert semMHInvoke) apply (erule thin_rl)apply (erule thin_rl)apply (erule thin_rl) apply (rotate_tac 2) apply (erule thin_rl)apply (erule thin_rl)apply (erule thin_rl)apply (erule thin_rl)apply (erule thin_rl)apply (erule thin_rl)
apply fastsimp
apply clarsimp
prefer 2 apply (insert SSpec_lemma [of "strongContext" "(methtable Ca mn)::heap expr"])
  apply (simp add: SSpec_def)

  apply (clarsimp, rule_tac x="n + 1" in exI) apply(insert semMHInvoke, fastsimp)

  apply (clarsimp) 
  apply (subgoal_tac "ab = E'\<lfloor>self:=Ref a\<rfloor> \<and> ac = h'", clarsimp)
  apply (erule semn.elims, simp_all) apply clarsimp apply(rule_tac x="na" in exI, subgoal_tac "b=p", simp, fastsimp)
  apply clarsimp
  apply (subgoal_tac "ab \<turnstile> ac , x\<diamondsuit>\<diamondsuit>mn \<Down>Suc n (ad , ae , \<langle>4 + renv.clock b callc b Suc (invkc b) Suc (invkdpth b)\<rangle>)")
  apply(erule semn.elims, simp_all) apply clarsimp apply(rule_tac x=n 
  apply (erule_tac x=E in allE)
  apply (simp add: strongContext_def, clarsimp) apply (erule_tac x="E'" in allE) apply(erule semn.elims, simp_all)apply(rule_tac x="na" in exI, subgoal_tac "b=p", simp, fastsimp)
*proof of strongContext \<rhd>  methtable C mn : SSpec (methtable C mn) *
done
*)

lemma  "strongSpec strongContext \<Longrightarrow> consistent strongContext"
apply (simp add: consistent_def)
apply (rule, clarsimp) apply (rule conjI) apply (simp add: strongSpec_def) apply (erule_tac x="(CALL f)::heap expr" in allE, clarsimp)
                                          apply (erule impE, fastsimp) apply(simp add: strongContext_def)
                       apply (subgoal_tac "P = SSpec ((CALL f)::heap expr)", simp)
                       apply (subgoal_tac "strongContext \<rhd>  funtable f : {(E, h, hh, v, p). (E, h, hh, v, \<langle>1 1 0 0\<rangle> \<smile> p) \<in> SSpec (CALL f)}")
                       apply simp
                       apply (fastsimp intro:L1)
                       apply (simp add: strongSpec_def)  apply (erule_tac x="(CALL f)::heap expr" in allE, clarsimp)
                       apply (erule impE, fastsimp) apply(simp add: strongContext_def)
apply (rule, clarsimp) apply (rule conjI) apply (simp add: strongSpec_def) apply (erule_tac x="(C\<bullet>\<bullet>mn)::heap expr" in allE, clarsimp)
                                          apply (erule impE, fastsimp) apply(simp add: strongContext_def)
                       apply (subgoal_tac "P = SSpec ((C\<bullet>\<bullet>mn)::heap expr)", simp)
                       apply (fastsimp intro: L2)
                       apply (simp add: strongSpec_def)  apply (erule_tac x="(C\<bullet>\<bullet>mn)::heap expr" in allE, clarsimp)
                       apply (erule impE, fastsimp) apply(simp add: strongContext_def)
apply (rule, clarsimp) apply (rule conjI) apply (simp add: strongSpec_def) apply (erule_tac x="(x\<diamondsuit>\<diamondsuit>mn)::heap expr" in allE, clarsimp)
                                          apply (erule impE, fastsimp) apply clarsimp 
                                          apply (rule_tac x=E in exI, rule_tac x=h in exI, rule_tac x=a in exI, rule_tac x=C in exI, simp)
                                          apply (simp add: strongContext_def)
                       apply (subgoal_tac "P = SSpec ((x\<diamondsuit>\<diamondsuit>mn)::heap expr)", simp) 
                       prefer 2 apply (simp add: strongContext_def) 
                       apply clarsimp
                       apply (insert L3) apply fast
               

section{*Proof of completeness*}

lemma completeAux: "\<lbrakk>strongSpec strongContext; finite strongContext\<rbrakk> \<Longrightarrow> {} \<rhd> (e::heap expr): SSpec e"
apply (rule cut2)
apply (subgoal_tac "strongContext \<rhd>  e : SSpec e")
apply assumption
defer 1
apply clarsimp
apply (simp add: callInvokeContext_def strongContext_def)
apply clarsimp
apply (rule conjI, clarsimp)
apply (subgoal_tac "\<rhd> CALL f : spectable f")
apply (subgoal_tac "SSpec ((CALL f)::heap expr) = spectable f")
apply (simp add: strongContext_def)
apply (simp add: strongSpec_def strongContext_def) apply (erule_tac x="CALL f" in allE) apply (erule_tac x="Q" in allE, simp)
apply (rule MUTREC)
apply assumption
apply (simp add: strongContext_def)
apply (simp add: strongSpec_def specContext_def strongContext_def, clarsimp)
apply (erule_tac x=e in allE)
apply (erule_tac x=Qa in allE)
apply (rule conjI, clarsimp)
apply (rule conjI, clarsimp)
apply (rule conjI, clarsimp) need qach QaQ here
apply (rule conjI, clarsimp)
apply (rule conjI)apply rule 
apply (subgoal_tac "(\<exists>x mn. e = x\<diamondsuit>\<diamondsuit>mn \<and> (\<exists>C. SSpec e = Mspectable C mn))") apply simp 
apply clarsimp
defer 1
apply (rule conjI, clarsimp)
apply rule
apply (subgoal_tac "(\<exists>x mn. (\<exists>y. e = x\<diamondsuit>mn(y)) \<and> (\<exists>C. SSpec e = Mspectable C mn))") apply simp
apply clarsimp
defer 1
apply (simp add:consistent_def strongContext_def) 
prefer 2
apply (simp add: strongContext_def strongSpec_def) apply(erule_tac x="(CALL f)::heap expr" in allE, erule_tac x="SSpec ((CALL f)::heap expr)" in allE, clarsimp)
prefer 2
sorry
(*apply clarsimp
apply (simp add: SSpec_def sem_def)
apply (rule conjI)
apply (simp add: strongSpec_def)
apply (simp add: consistent_def)
apply (rule, clarsimp)
apply (subgoal_tac "strongContext \<rhd> funtable fa : SSpec (funtable fa)")
apply (subgoal_tac "SSpec (funtable fa) = 
                    {(E, h, hh, v, p). (E, h, hh, v, \<langle>Suc (renv.clock p) Suc (callc p) invkc p invkdpth p\<rangle>) \<in> SSpec (CALL fa)}")
apply fastsimp
apply (simp add: SSpec_def)

apply (subgoal_tac "({(e, P). \<exists>f. e = CALL f \<and> P = spectable f \<and> P = SSpec e} \<union>
               {(e, P). \<exists>C mn. e = C\<bullet>\<bullet>mn \<and> P = Mspectable C mn \<and> P = SSpec e} \<union>
               {(e, P). \<exists>x mn. e = x\<diamondsuit>\<diamondsuit>mn \<and> (\<exists>E' h' a C. qach_QaQ E' h' a x C \<and> P = Mspectable C mn \<and> P = SSpec e)} \<union>
               {(e, P). \<exists>C mn. (\<exists>y. e = C\<bullet>mn(y)) \<and> P = Mspectable C mn \<and> P = SSpec e} \<union>
               {(e, P).
                \<exists>x mn. (\<exists>y. e = x\<diamondsuit>mn(y)) \<and>
                       (\<exists>E' h' a C.
                           qach_QaQ E' h' a x C \<and>
                           P = Mspectable C mn \<and>
                           P = SSpec e)}) \<rhd> (CALL fa) : SSpec (CALL fa)")
prefer 2
apply (rule vdm_ax, fastsimp)



apply clarsimp
apply (rule vdm_ax, simp)
apply simp
apply clarsimp+
apply (rule vdm_conseq)
apply (rule SSpec_lemma)
apply clarsimp
apply (rule vdm_ax)
apply simp
apply clarsimp
apply (simp add: SSpec_def sem_def)
apply clarsimp
apply (rule_tac x="n + 1" in exI, simp)
apply (subgoal_tac "a \<turnstile> aa , CALL f \<Down>Suc n (ab , ac , \<lparr>renv.clock = 1, callc = 1, invkc = 0, invkdpth = 0\<rparr> \<smile> b)")
apply simp
apply (erule thin_rl)
apply (erule thin_rl)
apply (insert semCall)
apply fastsimp
done
*)

lemma vdm_complete: "\<lbrakk>strongSpec strongContext; goodContext\<rbrakk> \<Longrightarrow> \<Turnstile> (e::heap expr) : P \<Longrightarrow> \<rhd> e : P"
apply (rule vdm_conseq)
apply (rule completeAux)
apply assumption
apply assumption
apply (rule SSpec_strong)
apply  simp
done

end

lemma completeAux: "G \<rhd> e: SSpec e"
apply (induct e)
apply (simp_all add: SSpec_def sem_def)
(*Int*)
apply (rule vdm_conseq, rule vdm_int, clarsimp)
apply (rule_tac x=1 in exI, rule semInt)
(*IVar*)
apply (rule vdm_conseq, rule vdm_ivar, clarsimp)
apply (rule_tac x=1 in exI, rule semIVar)
(*Primop*)
apply (rule vdm_conseq, rule vdm_prim, clarsimp)
apply (rule_tac x=1 in exI, rule semPrimop)
(*Null*)
apply (rule vdm_conseq, rule vdm_null, clarsimp)
apply (rule_tac x=1 in exI, rule semNull)
(*RVar*)
apply (rule vdm_conseq, rule vdm_rvar, clarsimp)
apply (rule_tac x=1 in exI, rule semRVar)
(*RPrimop*)
apply (rule vdm_conseq, rule vdm_rprim, clarsimp)
apply (rule_tac x=1 in exI, rule semRPrimop)
(*New*)
apply (rule vdm_conseq, rule vdm_new, clarsimp)
apply (rule_tac x=1 in exI, rule semNew, simp)
(*Getfi*)
apply (rule vdm_conseq, rule vdm_getfi, clarsimp)
apply (rule_tac x=1 in exI, rule semGetfi, simp)
(*Getfr*)
apply (rule vdm_conseq, rule vdm_getfr, clarsimp)
apply (rule_tac x=1 in exI, rule semGetfr, simp)
(*Putfi*)
apply (rule vdm_conseq, rule vdm_putfi, clarsimp)
apply (rule_tac x=1 in exI, rule semPutfi, simp)
(*Putfr*)
apply (rule vdm_conseq, rule vdm_putfr, clarsimp)
apply (rule_tac x=1 in exI, rule semPutfr, simp)
(*Invoke*)
defer 1
(*InvokeStatic*)
defer 1
(*mhinvoke*)
defer 1
(*mhinvokestatic*)
defer 1
(*Leti*)
apply (rule vdm_conseq, rule vdm_leti, fast, fast, clarsimp)
apply (rule_tac x="(max n na) + 1" in exI, insert semLeti, fastsimp)
(* Letr*)
apply (rotate_tac -1, erule thin_rl)
apply (rule vdm_conseq, rule vdm_letr, fast, fast, clarsimp)
apply (rule_tac x="(max n na) + 1" in exI, insert semLetr, fastsimp)
(* Letv*)
apply (rotate_tac -2, erule thin_rl, erule thin_rl)
apply (rule vdm_conseq, rule vdm_letv, fast, fast, clarsimp)
apply (rule_tac x="(max n na)" in exI, insert semLetv, fastsimp)
(*If*)
apply (rotate_tac -3, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rule vdm_conseq, rule vdm_if, fast, fast, clarsimp)
apply (case_tac "a<iname>=1", clarsimp)
apply (rule_tac x="n+1" in exI, insert semIf_True, fastsimp)
apply (subgoal_tac "a<iname>=0", clarsimp)
apply (rule_tac x="n+1" in exI, insert semIf_False, fastsimp)
apply clarsimp (* E<x> is either true or false*)
(*Call*)
apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rule vdm_call)
apply clarsimp
done
(*maybe it would be better to have funbodies is the context triples (and method bodies?*)
(*why do we not have sets of vdmtuples on the right-hand side?*)
prefer 2
sorry
apply (subgoal_tac "{(E, h, hh, v, p). \<exists>n. E \<turnstile> h , CALL funame \<Down>n (hh , v , p)} \<subseteq> {(E, h, hh, v, p). \<exists>n. E \<turnstile> h , CALL funame \<Down>n (hh , v , p)}")
apply simp apply fastsimp
apply clarsimp
apply (subgoal_tac " insert (CALL funame, {(E, h, hh, v, p). \<exists>n. E \<turnstile> h , CALL funame \<Down>n (hh , v , p)})
        G \<rhd> (CALL funame) : {(E, h, hh, v, p). \<exists>n. E \<turnstile> h , CALL funame \<Down>n (hh , v , p)}")
prefer 2 apply (rule vdm_ax, fast)
sorry
(*apply clarsimp
apply (subgoal_tac "{E,h,hh,v,p} . ")
apply (erule thin_rl)
defer 1
*)


other proof of completeAux
apply (induct e)
apply (simp_all add: SSpec_def sem_def)
(*Int*)
apply (rule vdm_conseq, rule vdm_int, clarsimp)
apply (rule_tac x=1 in exI, rule semInt)
(*IVar*)
apply (rule vdm_conseq, rule vdm_ivar, clarsimp)
apply (rule_tac x=1 in exI, rule semIVar)
(*Primop*)
apply (rule vdm_conseq, rule vdm_prim, clarsimp)
apply (rule_tac x=1 in exI, rule semPrimop)
(*Null*)
apply (rule vdm_conseq, rule vdm_null, clarsimp)
apply (rule_tac x=1 in exI, rule semNull)
(*RVar*)
apply (rule vdm_conseq, rule vdm_rvar, clarsimp)
apply (rule_tac x=1 in exI, rule semRVar)
(*RPrimop*)
apply (rule vdm_conseq, rule vdm_rprim, clarsimp)
apply (rule_tac x=1 in exI, rule semRPrimop)
(*New*)
apply (rule vdm_conseq, rule vdm_new, clarsimp)
apply (rule_tac x=1 in exI, rule semNew, simp)
(*Getfi*)
apply (rule vdm_conseq, rule vdm_getfi, clarsimp)
apply (rule_tac x=1 in exI, rule semGetfi, simp)
(*Getfr*)
apply (rule vdm_conseq, rule vdm_getfr, clarsimp)
apply (rule_tac x=1 in exI, rule semGetfr, simp)
(*Putfi*)
apply (rule vdm_conseq, rule vdm_putfi, clarsimp)
apply (rule_tac x=1 in exI, rule semPutfi, simp)
(*Putfr*)
apply (rule vdm_conseq, rule vdm_putfr, clarsimp)
apply (rule_tac x=1 in exI, rule semPutfr, simp)
(*Invoke*)
defer 1
(*InvokeStatic*)
defer 1
(*mhinvoke*)
defer 1
(*mhinvokestatic*)
defer 1 (*does not hold for empty context*)
(*Leti*)
apply (rule vdm_conseq, rule vdm_leti, fast, fast, clarsimp)
apply (rule_tac x="(max n na) + 1" in exI, insert semLeti, fastsimp)
(* Letr*)
apply (rotate_tac -1)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_letr, fast, fast, clarsimp)
apply (rule_tac x="(max n na) + 1" in exI, insert semLetr, fastsimp)
(* Letv*)
apply (rotate_tac -2)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_letv, fast, fast, clarsimp)
apply (rule_tac x="(max n na)" in exI, insert semLetv, fastsimp)
(*If*)
apply (rotate_tac -3)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_if, fast, fast, clarsimp)
apply (case_tac "a<iname>=1", clarsimp)
apply (rule_tac x="n+1" in exI, insert semIf_True, fastsimp)
apply (subgoal_tac "a<iname>=0", clarsimp)
apply (rule_tac x="n+1" in exI, insert semIf_False, fastsimp)
apply clarsimp (* E<x> is either true or false*)
(*Call*)
(* proof idea: use vdm_call and SSpec_lemma *)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rule vdm_call) 
apply simp
(* have to massage the subgoal so that we can SSpec_lemma; 
   SSpec_body should do the massaging *)
apply (insert "SSpec_lemma")
apply (simp add: SSpec_def sem_def)
apply auto
(* apply (rule vdm_conseq)  *)
(* apply (erule_tac x="funame" in allE) *)
apply auto
apply (tactic {* all_tac *})
(*Ann*)
defer 1
sorry


lemma SSpec_lemmafun: "\<forall> f . G \<rhd> ((Call f)::'a expr) : SSpec ((Call f)::'a expr) \<Longrightarrow> G \<rhd> (e::'a expr) : SSpec (e::'a expr)"
apply (simp add: SSpec_def sem_def)
apply (induct e)
apply (simp_all) (*  NB: Call case disappeared already! *)
(* Int *)
apply (rule vdm_conseq, rule vdm_int, clarsimp)
apply (rule_tac x=1 in exI, rule semInt)
(*IVar*)
apply (rule vdm_conseq, rule vdm_ivar, clarsimp)
apply (rule_tac x=1 in exI, rule semIVar)
(*Primop*)
apply (rule vdm_conseq, rule vdm_prim, clarsimp)
apply (rule_tac x=1 in exI, rule semPrimop)
(*Null*)
apply (rule vdm_conseq, rule vdm_null, clarsimp)
apply (rule_tac x=1 in exI, rule semNull)
(*RVar*)
apply (rule vdm_conseq, rule vdm_rvar, clarsimp)
apply (rule_tac x=1 in exI, rule semRVar)
(*RPrimop*)
apply (rule vdm_conseq, rule vdm_rprim, clarsimp)
apply (rule_tac x=1 in exI, rule semRPrimop)
(*New*)
apply (rule vdm_conseq, rule vdm_new, clarsimp)
apply (rule_tac x=1 in exI, rule semNew, simp)
(*Getfi*)
apply (rule vdm_conseq, rule vdm_getfi, clarsimp)
apply (rule_tac x=1 in exI, rule semGetfi, simp)
(*Getfr*)
apply (rule vdm_conseq, rule vdm_getfr, clarsimp)
apply (rule_tac x=1 in exI, rule semGetfr, simp)
(*Putfi*)
apply (rule vdm_conseq, rule vdm_putfi, clarsimp)
apply (rule_tac x=1 in exI, rule semPutfi, simp)
(*Putfr*)
apply (rule vdm_conseq, rule vdm_putfr, clarsimp)
apply (rule_tac x=1 in exI, rule semPutfr, simp)
(* Invoke *)
defer 1
(* InvokeStatic *)
defer 1
(* MH_Invoke *)
defer 1
(* MH_InvokeStatic *)
defer 1
(*Leti*)
apply (rule vdm_conseq, rule vdm_leti, fast, fast, clarsimp)
apply (rule_tac x="(max n na) + 1" in exI, insert semLeti, fastsimp)
(* Letr*)
apply (rotate_tac -1)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_letr, fast, fast, clarsimp)
apply (rule_tac x="(max n na) + 1" in exI, insert semLetr, fastsimp)
(* Letv*)
apply (rotate_tac -2)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_letv, fast, fast, clarsimp)
apply (rule_tac x="(max n na)" in exI, insert semLetv, fastsimp)
(*If*)
apply (rotate_tac -3)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_if, fast, fast, clarsimp)
apply (case_tac "a<iname>=1", clarsimp)
apply (rule_tac x="n+1" in exI, insert semIf_True, fastsimp)
apply (subgoal_tac "a<iname>=0", clarsimp)
apply (rule_tac x="n+1" in exI, insert semIf_False, fastsimp)
apply clarsimp (* E<x> is either true or false*)
apply (tactic {* all_tac *})
(* 5 subgoals left, for cases:
   Ann, and the 4 invokes *)
sorry

lemma completeAux2: "{} \<rhd> e: SSpec e"
