theory ExampleListClass = VDMderived:

constdefs HSize ::"heap \<Rightarrow> int"
"HSize h == int (card (fmap_dom (heap.oheap h)))"
declare HSize_def [simp]

lemma SizeInsert[simp]: "int (card (insert (freshloc H) H)) = int (card H) + 1"
sorry


consts LST     :: cname     (*these consts, and models, should be in the locale\<dots>*)
       TAG     :: ifldname
       HD      :: ifldname
       TL      :: rfldname

consts models::"(int list \<times> ref \<times> heap) set"
inductive models intros
  NIL:  "\<lbrakk>fmap_lookup(objhp H) l = Some LST \<and> inthp H TAG l = 0\<rbrakk> \<Longrightarrow> ([],Ref l, H) \<in> models"
  CONS: "\<lbrakk>\<exists> tt . (fmap_lookup(objhp H) l = Some LST \<and> 
                  inthp H TAG l \<noteq> 0 \<and> inthp H HD l = h \<and> refhp H TL l = tt \<and> 
                  (t,tt,H) \<in> models)\<rbrakk>
        \<Longrightarrow> ( h # t, Ref l,H) \<in> models"
lemma NIL_I : "fmap_lookup(objhp H) l = Some LST \<and> inthp H TAG l = 0 \<Longrightarrow> ([],Ref l, H) \<in> models" by(rule NIL, auto)
lemma CONS_I: "\<exists> tt . (fmap_lookup(objhp H) l = Some LST \<and> 
                  inthp H TAG l \<noteq> 0 \<and> inthp H HD l = h \<and> refhp H TL l = tt \<and> 
                  (t,tt,H) \<in> models)
        \<Longrightarrow> ( h # t, Ref l,H) \<in> models" by(rule CONS, auto)
lemma NIL_E:  "([],Ref l, H) \<in> models \<Longrightarrow> fmap_lookup(objhp H) l = Some LST \<and> inthp H TAG l = 0"
               by(erule models.elims,auto)
lemma CONS_E: "(h # t, Ref l,H) \<in> models \<Longrightarrow> 
               (\<exists> tt . (fmap_lookup(objhp H) l = Some LST \<and> inthp H TAG l \<noteq> 0 \<and> 
                        inthp H HD l = h \<and> refhp H TL l = tt \<and> 
                        (t,tt,H) \<in> models))"
               by(erule models.elims,auto)

(*The following are VERY useful lemmas, we should generate them automatically, together  with the models relation.*)
(*lemma modelsTick[simp]: "\<forall> r s n . ((L,r,s) \<in> models \<longrightarrow> (L,r, tickn n s) \<in> models)"
apply(induct_tac L)
apply(clarsimp)
apply(erule models.elims, simp_all)
apply(rule NIL, auto)
apply(erule models.elims, simp_all)
by(rule CONS, auto)

lemma modelsIvarupdate[simp]: "\<forall> r s v val . ((L,r,s) \<in> models \<longrightarrow> (L,r, ivarupdate s v val) \<in> models)"
apply(induct_tac L)
apply(clarsimp)
apply(erule models.elims, simp_all)
apply(rule NIL, auto)
apply(erule models.elims, simp_all)
by(rule CONS, auto)

lemma modelsRvarupdate[simp]: "\<forall> r s v val . ((L,r,s) \<in> models \<longrightarrow> (L,r, rvarupdate s v val) \<in> models)"
apply(induct_tac L)
apply(clarsimp)
apply(erule models.elims, simp_all)
apply(rule NIL, auto)
apply(erule models.elims, simp_all)
by(rule CONS, auto)

lemma modelsIncrcallcount[simp]: "\<forall> r s . ((L,r,s) \<in> models \<longrightarrow> (L,r, incrcallcount s) \<in> models)"
apply(induct_tac L)
apply(clarsimp)
apply(erule models.elims, simp_all)
apply(rule NIL, auto)
apply(erule models.elims, simp_all)
by(rule CONS, auto)
*)

consts LLength::"(nat \<times> ref \<times> (ref set) \<times> heap) set"
(* (n,l,X,s) \<in> LLength if s l models a list of length n with pointers from X, and all tail pointers distinct*)


inductive LLength intros

  NIL_LL:  "\<lbrakk>fmap_lookup(objhp hp) l = Some LST; 
	     inthp hp TAG l = 0;
             Ref l \<in> X\<rbrakk> 
           \<Longrightarrow> (0,Ref l, X, hp) \<in> LLength"

  CONS_LL: "\<lbrakk>fmap_lookup(objhp hp) l = Some LST;
	     inthp hp TAG l = 1;
	     inthp hp HD l = h; 
	     refhp hp TL l = tt; 
             Ref l \<in> X;
             tt \<in> X - {Ref l};  (i,tt, X - {Ref l} , hp) \<in> LLength\<rbrakk>
           \<Longrightarrow> ( Suc i , Ref l, X, hp) \<in> LLength"

lemma LLTAG[simp]:
  "\<forall> r X oh ih rh l tag.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> LLength \<and> Ref l \<notin> X \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih(TAG := (ih TAG)(l := tag)), refhp = rh\<rparr>) \<in> LLength)"
apply clarsimp
apply (induct N)
apply (erule LLength.elims)
apply clarsimp
apply (rule NIL_LL, fastsimp+)
apply (erule LLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_LL, fastsimp+)

lemma LLHD[simp]:
  "\<forall> r X oh ih rh.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> LLength \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih(HD := ih HD), refhp = rh\<rparr>) \<in> LLength)"
by fastsimp

lemma LLTAG_HD[simp]:
  "\<forall> r X oh ih rh l tag.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> LLength \<and> Ref l \<notin> X \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih(TAG := (ih TAG)(l := tag), HD := ih HD), refhp = rh\<rparr>) \<in> LLength)"
apply clarsimp
apply (induct N)
apply (erule LLength.elims)
apply clarsimp
apply (rule NIL_LL, fastsimp+)
apply (erule LLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_LL, fastsimp+)

lemma LLTL[simp]:
  "\<forall> r X oh ih rh l t.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> LLength \<and> Ref l \<notin> X \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh(TL := (rh TL)(l := t))\<rparr>) \<in> LLength)"
apply clarsimp
apply (induct N)
apply (erule LLength.elims)
apply clarsimp
apply (rule NIL_LL, fastsimp+)
apply (erule LLength.elims)
apply clarsimp
apply clarsimp
apply (subgoal_tac "l \<noteq> la")
by (rule CONS_LL, fastsimp+)
(*
lemma LLengthMono[simp]: "\<forall> r H X Y. ((L,r,X,H) \<in> LLength \<and> (Y Int (X Un {r}) = {}) \<longrightarrow> (L,r, X Un Y,H) \<in> LLength)"
apply(induct_tac L)
apply(clarsimp)
apply(erule LLength.elims, simp_all)
apply(rule NIL_LL, auto)
apply(erule LLength.elims, simp_all)
apply clarsimp
apply(rule CONS_LL, auto)
apply(erule_tac x="refhp hp TL l" in allE)
apply(erule_tac x="hp" in allE)
apply(erule_tac x="Xa" in allE)
apply(erule_tac x="Y - {Ref l}" in allE)
apply fastsimp
apply(subgoal_tac "Xa \<union> (Y - {refhp hp TL l}) = Xa \<union> Y - {refhp hp TL l}")
apply fastsimp
apply fastsimp
sorry
*)

(*Version with locations instead of references*)
consts LocLength::"(nat \<times> locn \<times> (locn set) \<times> heap) set"
inductive LocLength intros

  NIL_LocL:  "\<lbrakk>fmap_lookup(objhp hp) l = Some LST; 
	       inthp hp TAG l = 0;
               l \<in> X\<rbrakk> 
             \<Longrightarrow> (0,l, X, hp) \<in> LocLength"

  CONS_LocL: "\<lbrakk>fmap_lookup(objhp hp) l = Some LST;
	       inthp hp TAG l = 1;
	       inthp hp HD l = h; 
	       refhp hp TL l = Ref tt; 
               l \<in> X;
               tt \<in> X - {l};  (i,tt, X - {l} , hp) \<in> LocLength\<rbrakk>
             \<Longrightarrow> ( Suc i , l, X, hp) \<in> LocLength"


lemma LocLTAG[simp]:
  "\<forall> r X oh ih rh l tag.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> LocLength \<and> l \<notin> X \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih(TAG := (ih TAG)(l := tag)), refhp = rh\<rparr>) \<in> LocLength)"
apply clarsimp
apply (induct N)
apply (erule LocLength.elims)
apply clarsimp
apply (rule NIL_LocL, fastsimp+)
apply (erule LocLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_LocL, fastsimp+)

lemma LocLHD[simp]:
  "\<forall> r X oh ih rh.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> LocLength \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih(HD := ih HD), refhp = rh\<rparr>) \<in> LocLength)"
by fastsimp


(*identify over heaps which are identical on the domain of the predicate*)
lemma LocLengthSame:
"\<forall> l X h hh . (((n,l,X,h) \<in> LocLength \<and> same X h hh) \<longrightarrow> (n,l,X,hh) \<in> LocLength)"
apply (induct n)
apply clarsimp
apply (erule LocLength.elims, simp_all)
apply (rule NIL_LocL)
apply (simp_all add: same_def)
apply clarsimp
apply (erule LocLength.elims)
apply clarsimp
apply (rule CONS_LocL)
apply (erule_tac thin_rl, simp add: same_def)
apply (erule_tac thin_rl, simp add: same_def)
apply (erule_tac thin_rl, simp add: same_def)
apply (erule_tac thin_rl, simp add: same_def)
apply (erule_tac thin_rl, simp add: same_def)
apply (erule_tac thin_rl, simp add: same_def)
apply (erule_tac x=tt in allE)
apply (rotate_tac -1) 
apply (erule_tac x="X - {l}" in allE)
apply (rotate_tac -1) 
apply (erule_tac x=hp in allE)
apply (rotate_tac -1) 
apply (erule_tac x=hh in allE)
apply fast
done

(*
lemma LocLTAG_HD[simp]:
  "\<forall> r X oh ih rh l tag.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> LocLength \<and> l \<notin> X \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih(TAG := (ih TAG)(l := tag), HD := ih HD), refhp = rh\<rparr>) \<in> LocLength)"
apply clarsimp
apply (induct N)
apply (erule LocLength.elims)
apply clarsimp
apply (rule NIL_LocL, fastsimp+)
apply (erule LocLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_LocL, fastsimp+)

lemma LocLTL[simp]:
  "\<forall> r X oh ih rh l t.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> LocLength \<and> l \<notin> X \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh(TL := (rh TL)(l := t))\<rparr>) \<in> LocLength)"
apply clarsimp
apply (induct N)
apply (erule LocLength.elims)
apply clarsimp
apply (rule NIL_LocL, fastsimp+)
apply (erule LocLength.elims)
apply clarsimp
apply clarsimp
apply (subgoal_tac "l \<noteq> la")
by (rule CONS_LocL, fastsimp+)
*)

(*Version with locations instead of references, and precise domain*)
consts DomLength::"(nat \<times> locn \<times> (locn set) \<times> heap) set"
inductive DomLength intros

  NIL_DomL:  "\<lbrakk>fmap_lookup(objhp hp) l = Some LST; 
	       inthp hp TAG l = 0\<rbrakk> 
             \<Longrightarrow> (0,l, {l}, hp) \<in> DomLength"

  CONS_DomL: "\<lbrakk>fmap_lookup(objhp hp) l = Some LST;
	       inthp hp TAG l = 1;
	       inthp hp HD l = h; 
	       refhp hp TL l = Ref tt; 
               l \<in> X;
               (i,tt, X - {l} , hp) \<in> DomLength\<rbrakk>
             \<Longrightarrow> ( Suc i , l, X, hp) \<in> DomLength"


lemma DomLTAG[simp]:
  "\<forall> r X oh ih rh l tag.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> DomLength \<and> l \<notin> X \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih(TAG := (ih TAG)(l := tag)), refhp = rh\<rparr>) \<in> DomLength)"
apply clarsimp
apply (induct N)
apply (erule DomLength.elims)
apply clarsimp
apply (rule NIL_DomL, fastsimp+)
apply (erule DomLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_DomL, fastsimp+)

lemma DomLHD[simp]:
  "\<forall> r X oh ih rh.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> DomLength \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih(HD := ih HD), refhp = rh\<rparr>) \<in> DomLength)"
by fastsimp

lemma DomLTAG_HD[simp]:
  "\<forall> r X oh ih rh l tag.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> DomLength \<and> l \<notin> X \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih(TAG := (ih TAG)(l := tag), HD := ih HD), refhp = rh\<rparr>) \<in> DomLength)"
apply clarsimp
apply (induct N)
apply (erule DomLength.elims)
apply clarsimp
apply (rule NIL_DomL, fastsimp+)
apply (erule DomLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_DomL, fastsimp+)

lemma DomLTL[simp]:
  "\<forall> r X oh ih rh l t.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> DomLength \<and> l \<notin> X \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh(TL := (rh TL)(l := t))\<rparr>) \<in> DomLength)"
apply clarsimp
apply (induct N)
apply (erule DomLength.elims)
apply clarsimp
apply (rule NIL_DomL, fastsimp+)
apply (erule DomLength.elims)
apply clarsimp
apply clarsimp
apply (subgoal_tac "l \<noteq> la")
by (rule CONS_DomL, fastsimp+)

lemma DomLengthDom[simp]:
  "\<forall> l X hp . ((L,l,X, hp) \<in> DomLength \<longrightarrow> X \<subseteq> fmap_dom (objhp hp))"
apply clarsimp
apply (induct L)
apply(erule DomLength.elims)
apply (simp_all add: fmap_lookup_def fmap_dom_def dom_def)
apply(erule DomLength.elims)
apply (simp_all add: fmap_lookup_def fmap_dom_def dom_def)
by fastsimp

lemma DomHD2[simp]: 
  "\<forall> r X oh ih rh l H. 
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> DomLength \<and> l \<notin> X \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih(HD := (ih HD)(l := H)), refhp = rh\<rparr>) \<in> DomLength)"
apply clarsimp
apply (induct N)
apply (erule DomLength.elims)
apply clarsimp
apply (rule NIL_DomL, fastsimp+)
apply (erule DomLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_DomL, fastsimp+)

lemma DomTagTagHdHd: 
  "\<forall> r X oh ih rh l ll tag1 tag2 H1 H2. 
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> DomLength \<and> l \<notin> X \<and> ll \<notin> X \<and> l \<noteq> ll \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih(TAG := (ih TAG)(l := tag1, ll := tag2), HD := (ih HD)(l := H1, ll:= H2)), 
               refhp = rh\<rparr>) \<in> DomLength)"
apply clarsimp
apply (induct N)
apply (erule DomLength.elims)
apply clarsimp
apply (rule NIL_DomL, fastsimp+)
apply (erule DomLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_DomL, fastsimp+)

lemma DomTagTagHd[simp]: 
  "\<forall> r X oh ih rh l ll tag1 tag2 H2. 
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> DomLength \<and> l \<notin> X \<and> ll \<notin> X \<and> l \<noteq> ll \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih(TAG := (ih TAG)(l := tag1, ll := tag2), HD := (ih HD)(ll:= H2)), 
               refhp = rh\<rparr>) \<in> DomLength)"
apply clarsimp
apply (induct N)
apply (erule DomLength.elims)
apply clarsimp
apply (rule NIL_DomL, fastsimp+)
apply (erule DomLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_DomL, fastsimp+)

lemma DomTlTl[simp]: 
  "\<forall> r X oh ih rh l ll T1 T2. 
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> DomLength \<and> l \<notin> X \<and> ll \<notin> X \<and> l \<noteq> ll \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh(TL := (rh TL)(l := T1, ll := T2))\<rparr>) \<in> DomLength)"
apply clarsimp
apply (induct N)
apply (erule DomLength.elims)
apply clarsimp
apply (rule NIL_DomL, fastsimp+)
apply (erule DomLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_DomL, fastsimp+)

lemma DomTagHd[simp]: 
  "\<forall> r X oh ih rh l tag H. 
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> DomLength \<and> l \<notin> X \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih(TAG := (ih TAG)(l := tag), HD := (ih HD)(l := H)), refhp = rh\<rparr>) \<in> DomLength)"
apply clarsimp
apply (induct N)
apply (erule DomLength.elims)
apply clarsimp
apply (rule NIL_DomL, fastsimp+)
apply (erule DomLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_DomL, fastsimp+)

lemma DomOheap[simp]: 
  "\<forall> r X oh ih rh l A. 
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> DomLength \<and> l \<notin> X \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh(l \<mapsto>\<^sub>f A), inthp = ih, refhp = rh\<rparr>) \<in> DomLength)"
apply clarsimp
apply (induct N)
apply (erule DomLength.elims)
apply clarsimp
apply (rule NIL_DomL)
apply auto
apply (simp add:FMAPlookup1)
apply (erule DomLength.elims)
apply clarsimp+
apply (rule CONS_DomL)
apply clarsimp
apply (subgoal_tac "l \<noteq> la")
apply (simp add:FMAPlookup1)
by (fastsimp+)

end
