(*  
   File:	$RCSfile: ExampleKountI-old.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleKountI-old.thy,v 1.1 2003/08/28 16:32:04 a1hloidl Exp $

   Example for invoke: count-down
*)

theory ExampleKountI = VDM + Prelude + Lemmas:

subsection {* Version w/ MH_InvokeStatic *}

locale kount_example =
  fixes    one        :: iname
  fixes	   n          :: iname
  fixes	   b          :: iname
  fixes	   count      :: ifldname
  fixes    KountClass :: cname
  fixes	   kount      :: mname
  assumes  kountbdy[simp]:  
  "methtable KountClass kount = 
   ((LET one = 1\<^sup>z; 
       n = self\<bullet>count ;
       n = n :-- ;
       _ = self\<bullet>count := n ;
       b = n :< one
   IN 
     IF b 
       THEN 0\<^sup>z
       ELSE MH_InvokeStatic KountClass kount
   END)::'a expr)"
  assumes  vardistinct:   "distinct [one,n,b] \<and> distinct [b,n,one]"
  assumes  allclasses:    "all_classes = {KountClass}"


(* {(E,h,hh,v,(p::rescount)). 0 < h<E\<lceil>self\<rceil>\<bullet>count> \<longrightarrow> v = IVal 0 \<and> hh<E\<lceil>self\<rceil>\<bullet>count> = 0}  *)
lemma (in kount_example)  
   "\<rhd> ((MH_InvokeStatic KountClass kount) :: 'a expr) :
    {(E,h,hh,v,(p::Semantics.renv)). 0 < h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> \<longrightarrow> v = IVal 0 \<and> hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> = 0}"
apply (rule vdm_mhinvokestatic, simp)
apply (rule vdm_conseq)
apply (rule vdm_leti)
apply (rule vdm_int)
apply (rule vdm_leti)
apply (rule vdm_getfi)
apply (rule vdm_leti)
apply (rule vdm_prim)
apply (rule vdm_letv)
apply (rule vdm_putfi)
apply (rule vdm_leti)
apply (rule vdm_prim)
apply (rule vdm_if)
apply (rule vdm_int)
apply (rule vdm_ax, simp)
apply (insert vardistinct)
apply clarsimp
(*
apply (case_tac "i < 2")
 apply clarsimp 
 apply clarsimp
*)
done

subsection {* Version w/ MH_Invoke *}

locale kount_example2 =
  fixes    one        :: iname
  fixes	   n          :: iname
  fixes	   b          :: iname
  fixes	   r          :: rname
  fixes	   count      :: ifldname
  fixes    KountClass :: cname
  fixes	   kount      :: mname
  assumes  kountbdy[simp]:  
  "methtable KountClass kount = 
   ((LET one = 1\<^sup>z; 
       n = self\<bullet>count ;
       n = n :-- ;
       _ = self\<bullet>count := n ;
       b = n :< one
   IN 
     IF b 
       THEN 0\<^sup>z
       ELSE MH_Invoke self kount
   END)::'a expr)"
  assumes  vardistinct:   "distinct [one,n,b] \<and> distinct [b,n,one]"
  assumes  vardistinct':  "distinct [r,self,param] \<and> distinct [param,self,r]"
  assumes  allclasses:    "all_classes = {KountClass}"

(* cheating over self: no "adaptation" of self needed in rec call *)
lemma (in kount_example2)  
   "\<rhd> ((MH_Invoke self kount) :: 'a expr) :
    {(E,h,hh,v,(p::Semantics.renv)). (\<forall> a . (qach_QaQ E h a self KountClass \<and> 0 < h<a\<bullet>count>) \<longrightarrow> v = IVal 0 \<and> hh<a\<bullet>count> = 0)}"
apply (insert vardistinct)
apply (rule vdm_mhinvoke)
apply (rule allI)+ apply (rule impI) apply (erule conjE)+
apply (insert finclasses)
apply (simp add: allclasses qach_QaQ_def)
apply (erule_tac x="C" in allE)
apply simp                 (* porghvam yISach! *)
apply (rule vdm_conseq)
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) 
apply (rule vdm_basics) 
apply (rule vdm_ax) apply clarsimp defer 1 defer 1
apply (rule vdm_basics) 
apply (rule vdm_basics) 
apply (rule vdm_basics) 
apply (rule vdm_basics) 
apply (rule vdm_basics)
defer 1 
apply clarsimp
(*
apply (rule_tac x="af" in exI)
apply clarsimp
*)
apply (case_tac "h'<af\<bullet>count> < 2")
 apply clarsimp
 apply clarsimp
 defer 1
 apply simp
 apply clarsimp
done

(* --------------------------------------------------------------------------- *)

section {* Different version of adaptation *}

lemma vdm_adapt_context: 
   "\<lbrakk> {(x\<diamondsuit>\<diamondsuit>mn, subst Q x y)} \<rhd> e : P  \<rbrakk>
    \<Longrightarrow>
    {(y\<diamondsuit>\<diamondsuit>mn, Q)} \<rhd> e : P"
sorry

(* using a sounder adaptation lemma than the previous one *)
lemma vdm_adapt_context_with_alias: "\<lbrakk> {(x\<diamondsuit>\<diamondsuit>mn, subst Q x y)} \<rhd> e : P ; (\<forall> E h hh v p C a. (E,h,hh,v,p) \<in> P \<longrightarrow> qach_QaQ E h a x C \<longrightarrow> qach_QaQ E h a y C) \<rbrakk> \<Longrightarrow> {(y\<diamondsuit>\<diamondsuit>mn, Q)} \<rhd> e : P"
sorry (* , NOT! *)

(* UNPROVEN LEMMA on context adaptation *)
lemma vdm_adapt_context: 
      "(insert (y\<diamondsuit>\<diamondsuit>mn, subst Q x y) G) \<rhd> e : P  
        \<Longrightarrow>
       (insert (x\<diamondsuit>\<diamondsuit>mn, Q) G) \<rhd> e : P"
apply (simp add: subst_def)
apply (induct_tac e)
sorry

lemma vdm_adapt_context_param: 
      "(insert (C\<bullet>mn(y), subst Q x y) G) \<rhd> e : P  
        \<Longrightarrow>
       (insert (C\<bullet>mn(x), Q) G) \<rhd> e : P"
sorry

lemma vdm_adapt_with_alias: "\<lbrakk> \<rhd> x\<diamondsuit>\<diamondsuit>mn : Q ; (\<forall> E h hh v p C a. (E,h,hh,v,p) \<in> Q \<longrightarrow> qach_QaQ E h a x C \<longrightarrow> qach_QaQ E h a y C) \<rbrakk> \<Longrightarrow>
                             \<rhd> y\<diamondsuit>\<diamondsuit>mn : Q"
sorry

lemma vdm_adapt_with_alias_InvokeStatic: "\<lbrakk> G \<rhd> (C\<bullet>mn(x)) : Q  ; (\<forall> E h hh v p C a. (E,h,hh,v,p) \<in> Q \<longrightarrow> qach_QaQ E h a x C \<longrightarrow> qach_QaQ E h a y C) \<rbrakk> \<Longrightarrow>
                             (G \<rhd> (C\<bullet>mn(y)) : Q)"
sorry

(*
lemma vdm_adapt_bonzo: "nuke y (subst Q x y) \<subseteq> nuke y Q"
apply (simp add: subst_def nuke_def)
apply clarsimp
apply (rule_tac x="E" in exI)
apply simp
done
*)

(* --------------------------------------------------------------------------- *)

(* honest version, starting with R-variable in Invoke *)
lemma (in kount_example2)  
   "\<rhd> ((MH_Invoke r kount) :: 'a expr) :
    {(E,h,hh,v,(p::Semantics.renv)). (\<forall> a . (qach_QaQ E h a r KountClass \<and> 0 < h<a\<bullet>count>) \<longrightarrow> v = IVal 0 \<and> hh<a\<bullet>count> = 0)}"
apply (insert vardistinct)
apply (insert vardistinct')
apply (rule vdm_mhinvoke)
apply (rule allI)+ apply (rule impI) apply (erule conjE)+
apply (insert finclasses)
apply (simp add: allclasses qach_QaQ_def)
apply (erule_tac x="C" in allE)
apply simp                 (* porghvam yISach! *)
apply (rule vdm_conseq)
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) 
apply (rule vdm_basics) 
(* needs adaptation of context here! *)
apply (rule vdm_adapt_context)
apply (rule vdm_ax) apply clarsimp defer 1 defer 1
apply (rule vdm_basics) 
apply (rule vdm_basics) 
apply (rule vdm_basics) 
apply (rule vdm_basics) 
apply (rule vdm_basics)
defer 1 
apply clarsimp
(*
apply (rule_tac x="af" in exI)
apply clarsimp
*)
apply (case_tac "h'<af\<bullet>count> < 2")
 apply clarsimp
 (* .. *)
 defer 1
 apply (simp add: subst_def)
 apply (rule conjI)
 defer 1
 defer 1
 apply simp
 apply auto (* schematics instantiated *)
 (* -------------------------------------------------- *)
 apply (erule_tac x="af" in allE)
 apply clarsimp
 apply (frule mp)  
 apply (subgoal_tac "E\<lfloor>self:=E\<lfloor>r\<rfloor>\<rfloor>\<lfloor>r\<rfloor> = E\<lfloor>r\<rfloor>")
  defer 1  (* prove subgoal *)  apply (rule rvarUpdOther) apply assumption 
  apply simp
 (* same routine as last year? same routine as every year, James *)
 apply (erule_tac x="af" in allE)
 apply clarsimp
 apply (frule mp) 
 apply (subgoal_tac "E\<lfloor>self:=E\<lfloor>r\<rfloor>\<rfloor>\<lfloor>r\<rfloor> = E\<lfloor>r\<rfloor>")
  defer 1  (* prove subgoal *)  apply (rule rvarUpdOther) apply assumption 
  (* use subgoal *)
  apply clarsimp
 apply simp
 apply (subgoal_tac "E\<lfloor>self:=E\<lfloor>r\<rfloor>\<rfloor>\<lfloor>r\<rfloor> = E\<lfloor>r\<rfloor> ")
  defer 1  (* prove subgoal *)  apply (rule rvarUpdOther) apply (assumption)
  (* -------------------------------------------------- *)
  (* universally quantified lookup of 2 envs, that are equal (assumption) *)
  apply (subgoal_tac "\<forall> z . z \<noteq> self --> E'\<lfloor>self:=Ref af\<rfloor><one:=1><n:=h'<af\<bullet>count>><n:=h'<af\<bullet>count> - 1><b:=0>\<lfloor>z\<rfloor> = E\<lfloor>self:=E\<lfloor>r\<rfloor>\<rfloor>\<lfloor>z\<rfloor>")
  prefer 2 (* prove subgoal *) apply clarsimp
  (* use subgoal *)
  apply (erule_tac x=r in allE)
  apply (rotate_tac -1) 
  apply (frule mp) apply assumption
  (* dump everthing except for 
      - r\<noteq>self, 
      - E'\<lfloor>r\<rfloor>=Ref af and 
      - this subgoal (last), the monstrous  E'\<lfloor>self:=Ref af\<rfloor><one:=1>... = E\<lfloor>self:=E\<lfloor>r\<rfloor>\<rfloor>\<lfloor>r\<rfloor> *)
  apply (erule thin_rl) apply (rotate_tac 1)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl) apply (rotate_tac 1)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl) apply (rotate_tac 1)
  apply (erule thin_rl) 
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (simp only: rvarIupdTriv) apply (simp)
  (* -- YET AGAIN *)
  (* universally quantified lookup of 2 envs, that are equal (assumption) *) 
  apply (subgoal_tac "\<forall> z . z \<noteq> self --> E'\<lfloor>self:=Ref af\<rfloor><one:=1><n:=h'<af\<bullet>count>><n:=h'<af\<bullet>count> - 1><b:=0>\<lfloor>z\<rfloor> = E\<lfloor>self:=E\<lfloor>r\<rfloor>\<rfloor>\<lfloor>z\<rfloor>")
  prefer 2 (* prove subgoal *) apply clarsimp 
  (* use subgoal *)
  apply (erule_tac x="r" in allE)
  apply (rotate_tac -1) 
  apply (frule mp) apply assumption
  apply (erule thin_rl) apply (rotate_tac 1)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl) apply (rotate_tac 1)
  apply (erule thin_rl) 
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl) apply (rotate_tac 1)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (simp only: rvarIupdTriv) apply (simp)
done

section {* Lemmas over these aux functions; SHOULD GO INTO Lemmas.thy !!!!!!!!!!! *}

lemma qach_QaQ_inj_arg: "\<lbrakk> qach_QaQ E h a r C ; qach_QaQ E h a' r C \<rbrakk> \<Longrightarrow> a = a'"
by (simp add: qach_QaQ_def)

lemma qach_QaQ_rvarIUpd[simp]: "qach_QaQ E<x:=n> h a r C = qach_QaQ E h a r C"
by (simp add: qach_QaQ_def)

lemma qach_QaQ_rvarRUpdSame[simp]: "qach_QaQ E\<lfloor>r:=Ref a\<rfloor> h a r C = (fmap_lookup (heap.oheap h) a = Some C)"
by (simp add: qach_QaQ_def)

lemma qach_QaQ_rvarRUpdOther[simp]: "r \<noteq> x  \<Longrightarrow> qach_QaQ E\<lfloor>x:=b\<rfloor> h a r C = qach_QaQ E h a r C"
by (simp add: qach_QaQ_def)

lemma qach_QaQ_heap1[simp]: "qach_QaQ E \<lparr> oheap = oheap h, iheap = foo, rheap = rheap h \<rparr> a r C = qach_QaQ E h a r C"
by (simp add: qach_QaQ_def)

lemma qach_QaQ9: "\<lbrakk> E\<lfloor>x\<rfloor> = E\<lfloor>y\<rfloor> ; qach_QaQ E h a x C \<rbrakk> \<Longrightarrow>  qach_QaQ E h a y C"
by (simp add: qach_QaQ_def)

lemma qach_QaQ8: "\<lbrakk> qach_QaQ E\<lfloor>x:=E\<lfloor>y\<rfloor>\<rfloor> h a x DecClass \<rbrakk> \<Longrightarrow> qach_QaQ E h a y DecClass"
by (simp add: qach_QaQ_def)

declare subst_def [simp]


(* honest version, starting with R-variable in Invoke *)
lemma (in kount_example2)  
   "\<rhd> ((MH_Invoke r kount) :: 'a expr) :
    {(E,h,hh,v,(p::Semantics.renv)). (\<forall> a . (qach_QaQ E h a r KountClass \<and> 0 < h<a\<bullet>count>) \<longrightarrow> v = IVal 0 \<and> hh<a\<bullet>count> = 0) }"
apply (insert vardistinct)
apply (insert vardistinct')
apply (rule vdm_mhinvoke)
apply (rule allI)+ apply (rule impI) apply (erule conjE)+
apply (insert finclasses)
apply (simp add: allclasses)
apply (erule_tac x="C" in allE)
apply simp                 (* porghvam yISach! *)
apply (rule vdm_conseq)
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) 
apply (rule vdm_basics) 
(* needs adaptation of context here! *)
apply (rule vdm_adapt_context_with_alias)
apply (rule vdm_ax) apply clarsimp defer 1 defer 1 defer 1
apply (rule vdm_basics) 
apply (rule vdm_basics) 
apply (rule vdm_basics) 
apply (rule vdm_basics) 
apply (rule vdm_basics)
defer 1 
(* apply clarsimp *)
(* apply (simp add: qach_QaQ_def subst_def) *)
(*
apply (rule_tac x="af" in exI)
apply clarsimp
*)
defer 1
(* apply (simp add: qach_QaQ_def subst_def) *)
apply auto
apply (insert qach_QaQ_inj_arg)
apply simp
defer 1
apply simp
(* unsatisfiable side-condition *)
apply (simp add: qach_QaQ_def)
oops

(* -- got this far *)

subsection {* count-down over param field *}

locale kount_example3 =
  fixes    one        :: iname
  fixes	   n          :: iname
  fixes	   b          :: iname
  fixes	   r          :: rname
  fixes	   count      :: ifldname
  fixes    KountClass :: cname
  fixes	   kount      :: mname
  assumes  kountbdy[simp]:  
  "methtable KountClass kount = 
   ((LET one = 1\<^sup>z; 
       n = param\<bullet>count ;
       n = n :-- ;
       _ = param\<bullet>count := n ;
       b = n :< one
   IN 
     IF b 
       THEN 0\<^sup>z
       ELSE InvokeStatic KountClass kount param
   END)::'a expr)"
  assumes  vardistinct:   "distinct [one,n,b] \<and> distinct [b,n,one]"
  assumes  vardistinct':  "distinct [self,param,r] \<and> distinct [r,param,self]"
  assumes  allclasses:    "all_classes = {KountClass}"

(* yIngor! {param}Daq *)
lemma (in kount_example3)  
   "\<rhd> ((InvokeStatic KountClass kount param) :: 'a expr) :
    {(E,h,hh,v,(p::Semantics.renv)). (\<forall> a . (qach_QaQ E h a param KountClass \<and> 0 < h<a\<bullet>count>) \<longrightarrow> v = IVal 0 \<and> hh<a\<bullet>count> = 0)}"
apply (rule vdm_invokestatic)
apply simp                 (* porghvam yISach! *)
apply (rule vdm_conseq)
apply (rule vdm_leti)
apply (rule vdm_int)
apply (rule vdm_leti)
apply (rule vdm_getfi)
apply (rule vdm_leti)
apply (rule vdm_prim)
apply (rule vdm_letv)
apply (rule vdm_putfi)
apply (rule vdm_leti)
apply (rule vdm_prim)
apply (rule vdm_if)
apply (rule vdm_int)
apply (rule vdm_ax)
apply (insert vardistinct)
apply (insert vardistinct')
apply (simp add: qach_QaQ_def)
apply clarsimp
apply (simp add: qach_QaQ_def)
apply (case_tac "aa<ae\<bullet>count> < 2")
 apply clarsimp
 apply clarsimp
done
(*
 (* apply totally_and_utterly_disgusting_tactic *)
 apply (subgoal_tac "af = ad")
 apply clarsimp
 defer 1
 apply (subgoal_tac "af = ad")
 apply clarsimp
 apply (simp only: renv_fct_def)
 apply simp
 apply (simp only: renv_fct_def)
 apply simp
done
(* -- not yet *)
*)

(* yIngorQo'! {param}Daq *)
lemma (in kount_example3)  
   "\<rhd> ((InvokeStatic KountClass kount r) :: 'a expr) :
    {(E,h,hh,v,(p::Semantics.renv)). (\<forall> a . (qach_QaQ E h a r KountClass \<and> 0 < h<a\<bullet>count>) \<longrightarrow> v = IVal 0 \<and> hh<a\<bullet>count> = 0)}"
apply (rule vdm_invokestatic)
apply simp                 (* porghvam yISach! *)
apply (rule vdm_conseq)
apply (rule vdm_leti)
apply (rule vdm_int)
apply (rule vdm_leti)
apply (rule vdm_getfi)
apply (rule vdm_leti)
apply (rule vdm_prim)
apply (rule vdm_letv)
apply (rule vdm_putfi)
apply (rule vdm_leti)
apply (rule vdm_prim)
apply (rule vdm_if)
apply (rule vdm_int)
(* adapt param position in context *)
apply (rule vdm_adapt_with_alias_InvokeStatic)
apply (rule vdm_ax)
apply (insert vardistinct)
apply (insert vardistinct')
apply (simp add: subst_def qach_QaQ_def newframe_env_def)
apply auto
(* False! petaQ! *)
oops

end
