(*  
   File:	$RCSfile: ExampleEvenOdd.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleEvenOdd.thy,v 1.1 2003/08/28 16:32:03 a1hloidl Exp $

   Example of mutual recursive functions using VDM style
*)

theory ExampleEvenOdd = Prelude + Lemmas + VDMderived: 

constdefs
 Even :: "int \<Rightarrow> bool"
 "Even i \<equiv> \<exists> k. i=2*k"
 Odd :: "int \<Rightarrow> bool"
 "Odd i \<equiv> \<exists> k. i=2*k+1"

lemma [simp]: "Even (x + 1) = Odd(x)"
by (simp add: Even_def Odd_def, arith)

lemma [simp]:  "Odd(x + 1) = Even(x)"
by (simp add: Even_def Odd_def)
(* arith failed, presburger succeeded! *)

(* the next two lemmas aren't really needed, just simplify a bit more *)
lemma [simp]: "(\<not> Odd(x)) = Even(x)"
by (simp add: Even_def Odd_def, arith)

lemma [simp]: "(\<not> Even(x)) = Odd(x)"
by (simp add: Even_def Odd_def, arith)

lemma [simp]: "Odd 0 = False"
by (simp add: Odd_def, arith)

lemma [simp]: "Even 0 = True"
by (simp add: Even_def)


lemma bonzo_999: "Even x --> \<not> Odd x"
by (simp add: Even_def Odd_def, arith)

lemma bonzo_998: "Odd x --> \<not> Even x"
by (simp add: Even_def Odd_def, arith)

(* ngoqvam moHbogh vImuSqu' !!!! *)
lemma bonzo_997: "0 < x --> Even (x) = Odd(x - 1)"
by (simp add: Even_def Odd_def, arith)

(* ngoqvam moHbogh vImuSqu' !!!! *)
lemma bonzo_996: "0 < x --> Odd (x) = Even (x - 1)"
by (simp add: Even_def Odd_def, arith)

lemma bonzo_995: "0 <= x ==> Odd x --> 0 < x"
by (simp add: Even_def Odd_def, arith)
                   
locale evenodd_example =
  fixes    x :: iname
  fixes    b :: iname
  fixes	   even    :: funame
  fixes    odd     :: funame

  assumes funtable_even:
  "funtable even = ((LET   b = x :0?; x = x :-- IN IF b THEN tt ELSE CALL odd END)::'a expr)"
  and funtable_odd:
  "funtable odd = ((LET   b = x :0?; x = x :-- IN IF b THEN ff ELSE CALL even END)::'a expr)"

  and  vardistinct:   "distinct[b,x] \<and> distinct[x,b]"

  and spectable_even:
  "spectable even = {(E,h,hh,v,p) . 0 <= E<x> \<longrightarrow> v = IVal (grailbool (Even(E<x>)))}"
  and spectable_odd:
  "spectable odd = {(E,h,hh,v,p) . 0 <= E<x> \<longrightarrow> v = IVal (grailbool (Odd(E<x>)))}"

lemma (in evenodd_example)
"\<rhd> ((Call even)::'a expr) : spectable even"
apply (rule mutrecCase2)
apply (subgoal_tac "{(Call odd, spectable odd), (Call even, spectable even)} \<rhd>  funtable
            odd : {(E, h, hh, v, p). (E, h, hh, v, \<lparr>renv.clock = 1, callc = 1, invkc = 0, invkdpth = 0\<rparr> \<smile> p) \<in> spectable odd} ")
apply (simp)
apply (simp add: funtable_odd spectable_odd)
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply (rule vdm_ax)
apply fast
apply clarsimp
prefer 2
apply (simp add: funtable_even spectable_even)
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply (rule vdm_ax)
apply fast
apply clarsimp
(* end of simulating vcg*)
apply (insert vardistinct)
apply (simp_all add: spectable_even spectable_odd Even_def Odd_def)
apply auto
apply arith+
done

(*now a proof with MUTRECCALL*)
lemma (in evenodd_example)
"\<rhd> ((Call even)::'a expr) : spectable even"
apply (rule MUTRECCALL)
apply (subgoal_tac "finite {(Call odd, spectable odd), (Call even, spectable even)}")
apply fast+
prefer 2 apply simp
apply auto
apply (simp add: funtable_odd spectable_odd)
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply (rule vdm_ax)
apply fast
apply clarsimp
prefer 2
apply (simp add: funtable_even spectable_even)
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply (rule vdm_ax)
apply fast
apply clarsimp
(* end of simulating vcg*)
apply (insert vardistinct)
apply (simp_all add: spectable_even spectable_odd Even_def Odd_def)
apply auto
apply arith+
done


end
