(*  Examples from Sieve$dia0.gr*)

theory ExampleDiamond = VDMderived:
(*Grail:
public class Sieve$dia_0 {
   field public static Sieve$dia_0 $f

   field public Sieve$dia_0 $n

   field public int $

   field public int f0

   field public Sieve$dia_0 f1

   method static public Sieve$dia_0 alloc () =
   let
      val freelist = getstatic <Sieve$dia_0 Sieve$dia_0.$f>

      fun q(Sieve$dia_0 freelist) =
      let
         val hd = freelist
         val tl = getfield freelist <Sieve$dia_0 Sieve$dia_0.$n>
         val () = putstatic <Sieve$dia_0 Sieve$dia_0.$f> tl
      in
         freelist
      end
   in
      if freelist = null[Sieve$dia_0]
      then new <Sieve$dia_0()> ()
      else q(freelist)
   end

   method static public void free (Sieve$dia_0 node) =
   let
      val freelist = getstatic <Sieve$dia_0 Sieve$dia_0.$f>
      val () = putfield node <Sieve$dia_0 Sieve$dia_0.$n> freelist
      val () = putstatic <Sieve$dia_0 Sieve$dia_0.$f> node
   in
      ()
   end

   method public static Sieve$dia_0 fill (Sieve$dia_0 ?x, int tag) =
   let
      val () = putfield ?x <int Sieve$dia_0.$> tag
   in
      ?x
   end

   method public static Sieve$dia_0 fill (Sieve$dia_0 ?x, int tag, int v0, Sieve$dia_0 v1) =
   let
      val () = putfield ?x <int Sieve$dia_0.$> tag
      val () = putfield ?x <int Sieve$dia_0.f0> v0
      val () = putfield ?x <Sieve$dia_0 Sieve$dia_0.f1> v1
   in
      ?x
   end

   method public static Sieve$dia_0 make (int tag) =
   let
      val ?x = invokestatic <Sieve$dia_0 Sieve$dia_0.alloc ()> ()
   in
      invokestatic <Sieve$dia_0 Sieve$dia_0.fill (Sieve$dia_0, int)> (?x, tag)
   end

   method public static Sieve$dia_0 make (int tag, int v0, Sieve$dia_0 v1) =
   let
      val ?x = invokestatic <Sieve$dia_0 Sieve$dia_0.alloc ()> ()
   in
      invokestatic <Sieve$dia_0 Sieve$dia_0.fill (Sieve$dia_0, int, int, Sieve$dia_0)> (?x, tag, v0, v1)
   end
}


*)

consts DIAMOND ::cname
consts DollarN :: rfldname 
       Dollar :: ifldname
       F0 :: ifldname
       F1 :: rfldname
consts STATICFL::cname
consts DollarF :: rfldname

consts modelsDIAMOND:: "(ref \<times> int \<times> int \<times> ref \<times> locn \<times> heap) set"
inductive modelsDIAMOND intros
modDiam: "\<lbrakk>fmap_lookup(oheap h) l = Some DIAMOND; rheap h DollarN l = n;
           iheap h Dollar l = d; iheap h F0 l = f0; rheap h F1 l = f1 \<rbrakk>
         \<Longrightarrow> (n,d,f0,f1,l,h) : modelsDIAMOND"

lemma modelsDIAMOND_Same:
"\<lbrakk>same X h hh; l : X; (n,d,f0,f1,l,h) : modelsDIAMOND\<rbrakk> \<Longrightarrow> (n,d,f0,f1,l,hh) : modelsDIAMOND" 
by (erule modelsDIAMOND.elims, clarsimp,
    rule modDiam, simp_all add:same_def)

consts modelsFreelist::"(nat \<times> locn \<times> (locn set) \<times> heap) set"
(*(i,l,X,h) : modelsFreelist if h\<lfloor>l\<rfloor> is the head of a list of diamonds of length i + 1*) 
inductive modelsFreelist intros
FL_one : "\<lbrakk>(Nullref,d,f0,f1,l,h) \<in> modelsDIAMOND; l \<in> X\<rbrakk>
           \<Longrightarrow> (0,l,{l},h) \<in>  modelsFreelist"
FL_more:   "\<lbrakk>(Ref n,d,f0,f1,l,h) : modelsDIAMOND; l \<in> X; n \<in> X - {l}; (i,n, X - {l} , h) : modelsFreelist\<rbrakk>
           \<Longrightarrow> (Suc i, l, X, h) : modelsFreelist"

lemma modelsFreelist_SameAux:
"\<forall> l X Y h hh . ((same Y h hh \<and> l : Y \<and> X \<subseteq> Y \<and> (n,l,X,h) : modelsFreelist) \<longrightarrow> (n,l,X,hh) : modelsFreelist)" 
apply (induct n)
apply clarsimp
apply (erule modelsFreelist.elims, simp_all, clarsimp)
apply (rule FL_one)
apply (subgoal_tac "(Nullref, d, f0, f1, la, hh) \<in> modelsDIAMOND")
apply assumption
apply (simp add: modelsDIAMOND_Same)
apply assumption
apply clarsimp
apply (erule modelsFreelist.elims, clarsimp)
apply (rule FL_more)
apply (subgoal_tac "(Ref na, d, f0, f1, l, hh) \<in> modelsDIAMOND")
apply assumption
apply (erule_tac thin_rl)
apply (simp add: modelsDIAMOND_Same)
apply (erule_tac thin_rl)
apply clarsimp
apply (erule_tac thin_rl)
apply clarsimp
apply (erule_tac x=na in allE, erule_tac x="Xa - {la}" in allE, erule_tac x="Y" in allE, erule_tac x=ha in allE, erule_tac x=hh in allE)
apply fastsimp
done

lemma modelsFreelist_Same:
"\<lbrakk>same Y h hh; l : Y; X \<subseteq> Y; (n,l,X,h) : modelsFreelist\<rbrakk> \<Longrightarrow> (n,l,X,hh) : modelsFreelist"
by (insert modelsFreelist_SameAux [of n],
    erule_tac x=l in allE, erule_tac x=X in allE, 
    erule_tac x=Y in allE, erule_tac x=h in allE, 
    erule_tac x=hh in allE, simp)

consts modelsStatic::"(nat \<times> locn \<times> (locn option) \<times> (locn set) \<times> heap) set"
inductive modelsStatic intros
ST_none: "\<lbrakk>fmap_lookup(oheap h) l = Some STATICFL; rheap h DollarF l = Nullref\<rbrakk>
          \<Longrightarrow> (0,l,None,{},h) : modelsStatic"
ST_some: "\<lbrakk>fmap_lookup(oheap h) l = Some STATICFL; rheap h DollarF l = Ref fl; l \<notin> X; (i,fl,X,h) : modelsFreelist\<rbrakk>
          \<Longrightarrow> (i,l,Some fl,X,h) : modelsStatic"

lemma modelsStatic_Same:
"\<lbrakk>same Y h hh; l : Y; X \<subseteq> Y; (i,l,flopt,X,h) : modelsStatic\<rbrakk> \<Longrightarrow> (i,l,flopt,X,hh) : modelsStatic"
apply (erule modelsStatic.elims, simp_all, clarsimp)
apply (rule ST_none)
apply (simp add: same_def)
apply (simp add: same_def)
apply clarsimp
apply (rule ST_some)
apply (simp add: same_def)
apply (simp add: same_def)
apply simp
apply (subgoal_tac "fl : Y")
prefer 2 apply (subgoal_tac "fl : X") apply fast  apply (erule modelsFreelist.elims, simp_all)
apply (simp add: modelsFreelist_Same)
done

lemma oheapFreshMonotone:
"fmap_lookup (oheap h) l = Some C \<Longrightarrow> fmap_lookup (oheap h(freshloc (fmap_dom (oheap h))\<mapsto>\<^sub>f D)) l = Some C"
apply (subgoal_tac "l \<noteq> freshloc (fmap_dom (oheap h))")
apply (simp add: FMAPlookup2)
apply (subgoal_tac "freshloc (fmap_dom (oheap h)) \<notin> fmap_dom (oheap h)")
prefer 2 apply (subgoal_tac "finite (fmap_dom (oheap h))")
         apply (simp add: freshloc)
         apply fast
apply (subgoal_tac "l \<in> fmap_dom (oheap h)")
apply fast
apply (simp add: fmap_dom_def fmap_lookup_def dom_def)
done

constdefs renvQ::renv "renvQ == \<langle>8 1 0 0\<rangle>"
constdefs renvAllocNone::renv "renvAllocNone == \<langle>11 1 0 0\<rangle>"
constdefs renvAllocSome::renv "renvAllocSome == \<langle>18 2 0 0\<rangle>"

constdefs renvFree :: renv "renvFree == \<langle>10 1 0 0\<rangle>"

constdefs renvFill2 :: renv "renvFill2 == \<langle>5 1 0 0\<rangle>"

constdefs renvFill4 :: renv "renvFill4 == \<langle>11 1 0 0\<rangle>"

constdefs renvMake1 :: renv "renvMake1 == \<langle>2 1 0 0\<rangle>"
constdefs renvMake3 :: renv "renvMake3 == \<langle>2 1 0 0\<rangle>"

locale Diamond = 
   fixes alloc :: mname and free :: mname and fill2 :: mname and fill4 :: mname and make1 :: mname and make3 :: mname and
         allocQ :: funame and allocTEMP :: funame and freeTEMP :: funame and 
         fill2TEMP :: funame and fill4TEMP :: funame and make1TEMP :: funame and make3TEMP :: funame and
         b :: iname and tag :: iname and v0 :: iname and
         flp ::rname and freelist :: rname and t :: rname and node :: rname and x :: rname and v1 :: rname and 
         allocBODY::"nat expr" and allocQBODY::"nat expr" and freeBODY::"nat expr" and 
         fill2BODY::"nat expr" and fill4BODY::"nat expr" and make1BODY::"nat expr" and make3BODY::"nat expr" and
         myContext :: "nat vdmcontext" 
   defines "freeBODY == (LET rf freelist = GetFr flp DollarF;
                                       _ = PutFr node DollarN freelist
                         IN PutFr flp DollarF node
                         END)::nat expr"
       and "allocBODY == (LET rf freelist = GetFr flp DollarF;
                                        b = RPrimop (% r1 r2 . if r1 = Nullref then 1 else 0) freelist freelist
                          IN IF b THEN (NEW <DIAMOND> ([],[])) ELSE CALL allocQ 
                          END)::nat expr"
       and "allocQBODY == (LET rf t = GetFr freelist DollarN;
                                  _ = PutFr flp DollarF t
                           IN RVar freelist 
                           END)::nat expr"
       and "fill2BODY == (LET _ = PutFi x Dollar tag IN RVar x END)::nat expr"
       and "fill4BODY == (LET _ = PutFi x Dollar tag;
                              _ = PutFi x F0 v0;
                              _ = PutFr x F1 v1
                          IN RVar x END)::nat expr"
       and "make1BODY == (LET rf x = CALL allocTEMP IN CALL fill2TEMP END)::nat expr"
       and "make3BODY == (LET rf x = CALL allocTEMP IN CALL fill4TEMP END)::nat expr"
       and "myContext == {((Call allocTEMP)::nat expr, spectable allocTEMP), 
                          ((Call allocQ)::nat expr, spectable allocQ), 
                          ((Call freeTEMP)::nat expr, spectable freeTEMP), 
                          ((Call fill2TEMP)::nat expr, spectable fill2TEMP), 
                          ((Call fill4TEMP)::nat expr, spectable fill4TEMP), 
                          ((Call make1TEMP)::nat expr, spectable make1TEMP), 
                          ((Call make3TEMP)::nat expr, spectable make3TEMP)}"
   assumes FREE: "methtable Diamond free == freeBODY" 
       and FREETEMP[simp]: "funtable freeTEMP == freeBODY" 
       and spectFreeTEMP:
           "spectable freeTEMP == 
            {(E,h,hh,v,p) . \<forall> freeLST FL X n d f0 f1 flopt l fl nn. 
               ((E\<lfloor>flp\<rfloor> = Ref freeLST \<and> (FL,freeLST,flopt,X,h) \<in> modelsStatic \<and> E\<lfloor>node\<rfloor> = Ref l \<and> (n,d,f0,f1,l,h) : modelsDIAMOND \<and> l \<notin> X)
               \<longrightarrow> (v = arbitrary \<and> p = renvFree \<and> hh = h\<lfloor>l\<diamondsuit>DollarN := h\<lfloor>freeLST\<diamondsuit>DollarF\<rfloor>\<rfloor>\<lfloor>freeLST\<diamondsuit>DollarF := Ref l\<rfloor> \<and> 
                     ((flopt = None \<longrightarrow> (0,freeLST,Some l,{l},hh) : modelsStatic) \<and> 
                      (flopt = Some fl \<longrightarrow> (Suc FL,freeLST,Some l, X \<union> {l},hh) : modelsStatic))))}"
       and ALLOC: "methtable Diamond alloc == allocBODY" 
       and ALLOCTEMP[simp]: "funtable allocTEMP == allocBODY" 
       and ALLOCQ[simp]: "funtable allocQ == allocQBODY"
       and spectAllocQ:
           "spectable allocQ == {(E,h,hh,v,p) . \<forall> freeLST FL X i flopt fl. 
               ((E\<lfloor>flp\<rfloor> = Ref freeLST \<and> (FL,freeLST,flopt,X,h) \<in> modelsStatic \<and> (flopt = Some fl) \<and> E\<lfloor>freelist\<rfloor> = h\<lfloor>freeLST\<diamondsuit>DollarF\<rfloor>) \<longrightarrow> 
                 ( v = RVal (Ref fl) \<and> p = renvQ \<and> (FL, fl,X,h) \<in> modelsFreelist \<and> 
                   (\<exists> n d f0 f1. (n,d,f0,f1,fl,h) \<in> modelsDIAMOND \<and> fl \<in> X \<and> 
                         hh = \<lparr>oheap = oheap h, iheap = iheap h, rheap = (rheap h)(DollarF := (rheap h DollarF)(freeLST := h\<lfloor>fl\<diamondsuit>DollarN\<rfloor>))\<rparr> \<and> 
                         (((n = Nullref) \<longrightarrow> (0,freeLST,None,{},hh) : modelsStatic) \<and>
                                               (\<forall> nn . n = Ref nn \<longrightarrow> (\<exists> i . FL = Suc i \<and> nn \<in> X - {fl} \<and> (i,nn, X - {fl}, h) : modelsFreelist \<and>
                                                                              (i,freeLST,Some nn,X - {fl},hh) : modelsStatic))))))}"
       and spectAllocTEMP:
           "spectable allocTEMP == 
            {(E,h,hh,v,p) . \<forall> freeLST FL X i flopt fl. 
               ((E\<lfloor>flp\<rfloor> = Ref freeLST \<and> (FL,freeLST,flopt,X,h) \<in> modelsStatic) \<longrightarrow> 
                   (((flopt = None) \<longrightarrow> (\<exists> r . (0,freeLST,None,X,hh) \<in> modelsStatic \<and> v = RVal (Ref r) \<and> 
                                                 r \<notin> fmap_dom (oheap h) \<and> hh = newObj h r E DIAMOND [] [] \<and> p = renvAllocNone)) \<and> 
                    ((flopt = Some fl) \<longrightarrow> ( v = RVal (Ref fl) \<and> p = renvAllocSome \<and> (FL, fl,X,h) \<in> modelsFreelist \<and> 
                                             (\<exists> n d f0 f1. (n,d,f0,f1,fl,h) \<in> modelsDIAMOND \<and> fl \<in> X \<and> 
                                               hh = \<lparr>oheap = oheap h, iheap = iheap h, rheap = (rheap h)(DollarF := (rheap h DollarF)(freeLST := h\<lfloor>fl\<diamondsuit>DollarN\<rfloor>))\<rparr> \<and> 
                                               (((n = Nullref) \<longrightarrow> (0,freeLST,None,{},hh) : modelsStatic) \<and>
                                                 (\<forall> nn . n = Ref nn \<longrightarrow> (\<exists> i . FL = Suc i \<and> nn \<in> X - {fl} \<and> (i,nn, X - {fl}, h) : modelsFreelist \<and>
                                                                                (i,freeLST,Some nn,X - {fl},hh) : modelsStatic))))))))}" 
       and FILL2: "methtable Diamond fill2 == fill2BODY" 
       and FILL2TEMP[simp]: "funtable fill2TEMP == fill2BODY" 
       and spectFill2TEMP:
           "spectable fill2TEMP == 
            {(E,h,hh,v,p) . \<forall> l i .
               ((E\<lfloor>x\<rfloor> = Ref l \<and> E<tag> = i) 
               \<longrightarrow> (v = RVal (Ref l) \<and> p = renvFill2 \<and> hh = h<l\<bullet>Dollar:=i>))}" 
       and FILL4: "methtable Diamond fill4 == fill4BODY" 
       and FILL4TEMP[simp]: "funtable fill4TEMP == fill4BODY" 
       and spectFill4TEMP:
           "spectable fill4TEMP == 
            {(E,h,hh,v,p) . \<forall> l i V1 V0.
               ((E\<lfloor>x\<rfloor> = Ref l \<and> E<tag> = i \<and> E\<lfloor>v1\<rfloor> = V1 \<and> E<v0> = V0) 
               \<longrightarrow> (v = RVal (Ref l) \<and> p = renvFill4 \<and> hh = h<l\<bullet>Dollar:=i><l\<bullet>F0:=V0>\<lfloor>l\<diamondsuit>F1:=V1\<rfloor>))}"
       and MAKE1: "methtable Diamond make1 == make1BODY" 
       and MAKE1TEMP[simp]: "funtable make1TEMP == make1BODY" 
       and spectMake1TEMP:
           "spectable make1TEMP == {(E,h,hh,v,p) . (\<exists> X h1 p1 p2 . (E,h,h1,RVal X,p1) : spectable allocTEMP \<and>
                                                                    (E\<lfloor>x:=X\<rfloor>,h1,hh,v,p2) : spectable fill2TEMP \<and>
                                                                    p = (renvMake1 \<smile> p1 \<smile> p2))}"
       and MAKE3: "methtable Diamond make3 == make3BODY" 
       and MAKE3TEMP[simp]: "funtable make3TEMP == make3BODY" 
       and spectMake3TEMP:
           "spectable make3TEMP == {(E,h,hh,v,p) . (\<exists> X h1 p1 p2 . (E,h,h1,RVal X,p1) : spectable allocTEMP \<and>
                                                                    (E\<lfloor>x:=X\<rfloor>,h1,hh,v,p2) : spectable fill4TEMP \<and>
                                                                    p = (renvMake3 \<smile> p1 \<smile> p2))}"
       and alldistinct: "distinct[alloc, free, fill2, fill4, make1, make3] \<and> distinct[make3,make1,fill4,fill2, free, alloc] \<and>
                         distinct[allocQ, allocTEMP, freeTEMP, fill2TEMP, fill4TEMP, make1TEMP, make3TEMP] \<and> 
                         distinct[make3TEMP,make1TEMP,fill4TEMP,fill2TEMP,freeTEMP,allocTEMP,allocQ] \<and>
                         distinct[flp,freelist,t,node,x,v1] \<and> distinct[v1,x,node,t,freelist,flp] \<and>
                         distinct[b,tag,v0] \<and> distinct[v0,tag,b] \<and>
                         distinct[DollarF, DollarN, F1] \<and> distinct[F1,DollarN,DollarF] \<and>
                         distinct[Dollar, F0] \<and> distinct[F0,Dollar] \<and>
                         distinct[STATICFL, DIAMOND] \<and> distinct[DIAMOND, STATICFL]"

lemma (in Diamond) "\<rhd> ((CALL allocTEMP)::nat expr) : (spectable allocTEMP)"
apply (rule MUTRECCALL)
apply (subgoal_tac "finite myContext")
apply simp
apply (simp add: myContext_def)
apply (simp add: myContext_def)
apply clarsimp
apply (simp add: myContext_def)
apply fast
prefer 2
apply (simp add: myContext_def)
apply clarsimp
apply (simp add: myContext_def)
apply (insert alldistinct)
apply (case_tac "f = make3TEMP")
apply (simp add: make3BODY_def)
apply (rule vdm_conseq) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_ax, simp) prefer 2 apply clarsimp prefer 2
apply (rule vdm_ax, simp) defer 1
apply (case_tac "f = make1TEMP")
apply (simp add: make1BODY_def)
apply (rule vdm_conseq) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_ax, simp) prefer 2 apply clarsimp prefer 2
apply (rule vdm_ax, simp) defer 1
apply (case_tac "f = fill4TEMP")
apply (simp add: fill4BODY_def)
apply (rule vdm_conseq) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_rvar) apply clarsimp defer 1
apply (case_tac "f = allocTEMP")
apply (simp add: allocBODY_def)
apply clarsimp
apply (rule vdm_conseq)
apply (rule vdm_letr, rule vdm_getfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_rprim) prefer 2 apply clarsimp prefer 2
apply (rule vdm_if) prefer 3 apply clarsimp prefer 2
apply (rule vdm_new) apply clarsimp prefer 2
apply (rule vdm_ax, simp)
apply (case_tac "aa\<lfloor>ad\<diamondsuit>DollarF\<rfloor> = Nullref")
apply clarsimp defer 1
apply clarsimp defer 1
apply (case_tac "f = allocQ")
apply (simp add: allocQBODY_def)
apply clarsimp
apply (rule vdm_conseq)
apply (rule vdm_letr, rule vdm_getfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_rvar) apply clarsimp defer 1
apply (case_tac "f = freeTEMP")
apply (simp add: freeBODY_def)
apply (rule vdm_conseq) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_getfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfr)  prefer 2 apply clarsimp prefer 2
apply (rule vdm_putfr) apply clarsimp defer 1
apply (subgoal_tac "f = fill2TEMP")
prefer 2 apply clarsimp
apply (simp add: fill2BODY_def)
apply (rule vdm_conseq) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_rvar) apply clarsimp defer 1
(* end of VCG*)
(* vc of make3TEMP*)
apply (simp add: spectMake3TEMP)
apply (rule_tac x=r in exI, rule_tac x=h1 in exI, rule_tac x=p1 in exI, simp)
apply (rule_tac x=p2 in exI, simp add: renvMake3_def)
(* vc of make1TEMP*)
apply (simp add: spectMake1TEMP)
apply (rule_tac x=r in exI, rule_tac x=h1 in exI, rule_tac x=p1 in exI, simp)
apply (rule_tac x=p2 in exI, simp add: renvMake1_def)
(*vc of fill4TEMP*)
apply (simp add: spectFill4TEMP)
apply (simp add: renvFill4_def obj_ifieldupdate_def obj_rfieldupdate_def)
(*first vc of allocTEMP*)
apply (simp add: spectAllocTEMP spectAllocQ)
apply clarsimp
apply (erule modelsStatic.elims, simp_all, clarsimp)
apply rule
apply (rule ST_none) apply (simp add: newObj_def) apply (simp add: oheapFreshMonotone) apply (simp add: newObj_def) 
apply rule
apply (subgoal_tac "finite (fmap_dom (oheap h))") apply (simp add: freshloc) apply fast
apply (simp add: newObj_def)
apply (simp add: renvAllocNone_def)
(*second vc of allocTEMP*)
apply (simp add: spectAllocTEMP spectAllocQ)
apply clarsimp
apply (subgoal_tac "\<exists> fl . flopt = Some fl")
prefer 2 apply (erule modelsStatic.elims, simp_all)
apply clarsimp
apply (simp add: renvQ_def renvAllocSome_def)
(*vc of allocQ*)
apply (simp add: spectAllocTEMP spectAllocQ)
apply clarsimp
apply (erule modelsStatic.elims, simp_all, clarsimp)
apply (erule modelsFreelist.elims, simp_all, clarsimp)
apply (simp add: renvQ_def)
apply (rule_tac x=Nullref in exI, clarsimp)
apply rule
apply (rule_tac x=d in exI, rule_tac x=f0 in exI, rule_tac x=f1 in exI, clarsimp)
apply (rule ST_none)
apply simp
apply (erule modelsDIAMOND.elims, simp_all)
apply clarsimp
apply (simp add: renvQ_def)
apply (rule_tac x="Ref n" in exI, simp)
apply rule
apply (rule_tac x=d in exI, rule_tac x=f0 in exI, rule_tac x=f1 in exI, simp)
apply (rule ST_some) 
apply simp
apply (erule modelsDIAMOND.elims, simp_all)
apply (subgoal_tac "same (X - {la}) ha \<lparr>oheap = oheap ha, iheap = iheap ha, rheap = (rheap ha)(DollarF := (rheap ha DollarF)(l := ha\<lfloor>la\<diamondsuit>DollarN\<rfloor>))\<rparr>")
apply (insert modelsFreelist_Same, simp)
apply (simp add: same_def)
(*vc of freeTEMP*)
apply (simp add: spectFreeTEMP)
apply clarsimp
apply (simp add: renvFree_def)
apply (simp add:obj_rfieldupdate_def)
apply (erule modelsStatic.elims, simp_all, clarsimp)
apply (rule ST_some, simp_all)
apply (erule modelsDIAMOND.elims, simp_all, clarsimp)
apply (rule FL_one)
apply (erule modelsDIAMOND.elims, simp_all, clarsimp)
apply (rule modDiam, simp_all)
apply (subgoal_tac "ae \<in> {ae}", fast, simp)
apply clarsimp
apply (erule modelsDIAMOND.elims, simp_all, clarsimp)
apply (subgoal_tac "fl : Xa")
apply (rule ST_some, simp_all, clarsimp)
apply (rule FL_more)
apply (rule modDiam, simp_all)
apply (subgoal_tac "same Xa ha 
                    \<lparr>oheap = oheap ha, iheap = iheap ha,
              rheap = (rheap ha)(DollarN := (rheap ha DollarN)(la := Ref fl), DollarF := (rheap ha DollarF)(l := Ref la))\<rparr>")
apply (simp add: modelsFreelist_Same)
apply (simp add: same_def)
apply (erule modelsFreelist.elims, simp_all)
(*vc of fill2TEMP*)
apply (simp add: spectFill2TEMP)
apply (simp add: renvFill2_def obj_ifieldupdate_def)
done

(* The methods Make1 and Make3 should really use invokes instead of calls - and maybe also 
   have vdm specifications which are not merely the composition of those of alloc and fill
   method public static Sieve$dia_0 make (int tag) =
   let
      val ?x = invokestatic <Sieve$dia_0 Sieve$dia_0.alloc ()> ()
   in
      invokestatic <Sieve$dia_0 Sieve$dia_0.fill (Sieve$dia_0, int)> (?x, tag)
   end

   method public static Sieve$dia_0 make (int tag, int v0, Sieve$dia_0 v1) =
   let
      val ?x = invokestatic <Sieve$dia_0 Sieve$dia_0.alloc ()> ()
   in
      invokestatic <Sieve$dia_0 Sieve$dia_0.fill (Sieve$dia_0, int, int, Sieve$dia_0)> (?x, tag, v0, v1)
   end
*)
end
